<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Santhosh Thomas Alexander<santhosh.thomas@armiasystems.com> |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
//include('../includes/image.class.php');
include('../includes/class.upload.php');
include_once('../includes/S3.php');
/****** Including resize library *******/
include_once('../api/pemfile/iphonepush.php');
include_once('../classes/cls_utils.php');
include_once('../classes/cls_store.php');
include_once('../classes/cls_products.php');

$maximagesizestringinPHP = ini_get("upload_max_filesize");
$maximagesizeinPHP = $maximagesizestringinPHP * (1024 * 1024);
//$img = new Zubrag_image;
if (get_magic_quotes_gpc()) {
$_POST = array_map('stripslashes_deep', $_POST);
$_GET = array_map('stripslashes_deep', $_GET);
$_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}



if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
$adminname = $_SESSION["sess_adminname"];
} else {
header("Location:login.php");
exit;
}

if (isset($_GET["catid"]) and $_GET["catid"] != "") {
$catid = $_GET["catid"];    
} else if (isset($_POST["catid"]) and $_POST["catid"] != "") {
$catid = $_POST["catid"];
}

$cdn_enabled = "N";
if(ENABLE_AMAZON_S3_IMAGES=="Y"){
$cdn_enabled  = "Y";
}
//getting options for the category


if ($_GET["begin"] == "") {
$begin = 0;
$num = 1;
$numBegin = 1;
} else {
$begin = $_GET["begin"];
$num = $_GET["num"];
$numBegin = $_GET["numBegin"];
;
}

if (isset($_GET["txtSearch"]) and $_GET["txtSearch"] != "") {
$txtSearch = $_GET["txtSearch"];
$cmbSearchType = $_GET["cmbSearchType"];
} else if (isset($_POST["txtSearch"]) and $_POST["txtSearch"] != "") {
$txtSearch = $_POST["txtSearch"];
$cmbSearchType = $_POST["cmbSearchType"];
}
$txtSearch = trim($txtSearch);
$sql = "SELECT * FROM " . $tableprefix . "settings ";
$result = $pdo->pdoQuery($sql)->results();
if (!empty($result)) {
$row = $result;
$chkcanship = $row["enable_canadapost"];
$max_images = $row['nproduct_images'];
}

//echo $txtSearch. "<br>";
$txtCategoryName = trim($_POST["txtCategoryName"]);
$productlist = $_POST["chkproducts"];

$txtProductName = $_POST["txtProductName"];
$txtProductCode = $_POST["txtProductCode"];
$txtDescription = $_POST["txtDescription"];
$txtPrice = $_POST["txtPrice"];
$ddlArtist = $_POST["ddlArtist"];
(isset($_POST['chkAllowFreeShipping'])) ? $chkAllowFreeShipping = $_POST['chkAllowFreeShipping'] : $chkAllowFreeShipping = 'N';
(isset($_POST['chkAllowSubscription'])) ? $chkAllowSubscription = $_POST['chkAllowSubscription'] : $chkAllowSubscription = 'N';

$txtSearchTags = $_POST["txtProductTags"];
$rdSubscriptionMode   = $_POST["rdSubscriptionMode"];
$rdPublishStatus      = $_POST["rdPublishStatus"];
//print '<pre />';print_r($_POST);EXIT;
if($rdPublishStatus=="N"){
//published time in 24_hour_format        
$selected_time = ($_POST['publishtime']!='')?$_POST['publishtime']:'12:00am'; 

$formatteDate = dateFormat($_POST['publishdate'], "m-d-Y", "Y-m-d");
$publishDate  = date("Y-m-d H:i:s", strtotime($formatteDate.$selected_time));

//Get seller time zone
$arrSellerTimezone = DbHelper::getResult('artists', "seller_time_zone", "artist_id =".$ddlArtist);        
$sellertimezone = $arrSellerTimezone[0]->seller_time_zone;
}else{
$publishDate   = "0000-00-00 00:00:00";
$sellertimezone = "";
}

//default published if settings disabled 

if(getSettingsValue('enable_product_scheduled_publishing')=='N') 
{
$rdPublishStatus    = 'Y';
}

$txtStock = $_POST["txtStock"];

$shipping_display_block = "";

(isset($_POST['txtDigitalProduct'])) ? $txtDigitalProduct = $_POST['txtDigitalProduct'] : $txtDigitalProduct = 'N';

if ($txtDigitalProduct == "Y") {
$digitalBlock = "";
$chkDigitalProduct = "checked";
$canshipblock = "none";
$shipping_display_block = "none";
$chkAllowFreeShipping = "Y";
} else {
$digitalBlock = "none";
$chkDigitalProduct = "";
$canshipblock = "";
$shipping_display_block = "";    
}

//$chkDigitalProduct = "checked";

if (isset($_GET['message'])) {
// $message = $_GET['message'];
}
if (isset($_GET['mesgg'])) {
$message = $_GET['mesgg'];
}



$qryopt = "";
$qryoptArr = array();
if ($txtSearch != "" && $txtSearch != "all") {
if ($cmbSearchType == "artistname") {
$qryopt .= "  AND  p.seller_name like :txtSearch";
$qryoptArr['txtSearch'] = "$txtSearch%";
} else if ($cmbSearchType == "dateadded") {
$dt = $txtSearch;
$arrdt = explode("/", $dt);
$day = $arrdt[1];
$month = $arrdt[0];
$year = $arrdt[2];
$dt = $year . "-" . $month . "-" . $day;
$qryopt .= "  AND  p.date_added like :dt";
$qryoptArr['dt'] = "$dt%";
} else if ($cmbSearchType == "productname") {
$qryopt .= "  AND  p.product_name like :txtSearch";
$qryoptArr['txtSearch'] = "$txtSearch%";
}
$txtSearchcat = $txtSearch;
if ($txtCategoryName)
$txtSearchcat = "";
}
if (isset($_POST["btnAddNewCategory"]) && !isNotNull($txtSearchcat)) {
$message = "";
if (!isset($catid) || $catid == "") {//at the top level
$parentcatid = "0";
} else {
$parentcatid = $catid;
}
if (!isNotNull($txtCategoryName)) {
$message .= CATNAME_REQD."<br>";
} else if (categoryExists($txtCategoryName, $catid)) {
$message .= CAT_EXIST;
}
if ($message != "") { // error
$message = "<br>".MSG_CORRECT_THE_ERRORS."<br>" . $message;
} else { // no error so insert category details
if ($parentcatid == "0") {//top level category
    $sqlinsertcat = "INSERT INTO " . $tableprefix . "categories(category_name,parent_id,route,cdn_images_moved)
					   					 VALUES ('" . addslashes($txtCategoryName) . "', '" . addslashes($parentcatid) . "','0','".  addslashes($cdn_enabled)."') ";
    $data = array(
			"category_name" => addslashes($txtCategoryName),
			"parent_id" => addslashes($parentcatid),
			"route" => '0',
                                "cdn_images_moved" => addslashes($cdn_enabled)
			
			);
    $route_pr = $pdo->insert($tableprefix."categories",$data)->lastInsertId();
    $category_id = $route_pr;
    $catOptArr = $_POST['category_options'];

    if (count($catOptArr)) {
        foreach ($catOptArr as $opt) {
            $sqlinsertcat = "INSERT INTO " . $tableprefix . "category_options(category_id,option_id)
												 VALUES ('" . addslashes($category_id) . "', '" . addslashes($opt) . "') ";
            $pdo->pdoQuery($sqlinsertcat);
        }
    }
    $sqlupdaterouteparent = "UPDATE " . $tableprefix . "categories SET route= '" . $route_pr . "' WHERE category_id = '" . $route_pr . "'";
    $resultupdatecat_parent = $pdo->pdoQuery($sqlupdaterouteparent);
    $message.="Category added successfully!";
} else {
    $sqlcatdetails = "SELECT  route,count,parent_id  FROM " . $tableprefix . "categories
										  WHERE category_id = '$parentcatid' ";

    //echo "<br>".$sqlcatdetails;
    $resultcatdetails = $pdo->pdoQuery($sqlcatdetails)->result();
    $rowcatdetails = $resultcatdetails;
    $route = $rowcatdetails["route"];

    $exp = explode(",", $route);

    if ($route == "0") {
        $route = $parentcatid;
    }
    $qry = "SELECT product_category FROM " . $tableprefix . "products WHERE product_category in($route)";

    $qryexc = $pdo->pdoQuery($qry)->results();
    if (empty($qryexc)) {

        $data = array(
			"category_name" => addslashes($txtCategoryName),
			"parent_id" => addslashes($parentcatid),
			"route" => $route,
                                "cdn_images_moved" => addslashes($cdn_enabled)
			
			);
	
	$sqlcatid = $pdo->insert($tableprefix."categories",$data)->lastInsertId();

        $category_id = $sqlcatid;
        $catOptArr = $_POST['category_options'];

        if (count($catOptArr)) {
            foreach ($catOptArr as $opt) {
                $sqlinsertcat = "INSERT INTO " . $tableprefix . "category_options(category_id,option_id)
															 VALUES ('" . addslashes($category_id) . "', '" . addslashes($opt) . "') ";
                $pdo->pdoQuery($sqlinsertcat);
            }
        }

        if ($route != "") {
            $route .= "," . $sqlcatid;
            $sqlupdatecat = "UPDATE " . $tableprefix . "categories SET route= '" . $route . "' WHERE category_id = '" . $sqlcatid . "'";
            $resultupdatecat = $pdo->pdoQuery($sqlupdatecat);
        }
        $success_message =CAT_ADDED_SUCC;
    } else {
        $message = "<br>".MSG_CORRECT_THE_ERRORS."<br>" . SUBCAT_DISABLED;
    }
}
}
} else if ($_POST["btnAddProduct"]) {

$message = "";
$checkleafcategory = " select *  FROM  " . $tableprefix . "categories where parent_id='$catid'";

if (!empty($pdo->pdoQuery($checkleafcategory)->results())) {
$message .= TXT_THERE_IS_A_SUBCAT."<br>";
}
if (!isNotNull($txtProductName)) {
$message .= PRO_NAME_EMPTY."<br>";
} else {
$qry = "SELECT  product_name FROM  " . $tableprefix . "products WHERE product_name='" . addslashes($txtProductName) . "'
           and product_artist_id='" . $ddlArtist . "' and product_category = '" . addslashes($catid) . "' ";
if (!empty($pdo->pdoQuery($qry)->results())) {
    $message .= PRO_WITH_SAME_NAME."<br>";
}
}
if (!isNotNull($txtProductCode)) {
//$message .= "* Product Code cannot be empty! <br>";
} else {
$qry = "SELECT  product_code FROM  " . $tableprefix . "products WHERE product_code='" . addslashes($txtProductCode) . "'
 and product_artist_id='" . $ddlArtist . "' and product_category = '" . addslashes($catid) . "' ";
if (!empty($pdo->pdoQuery($qry)->results())) {
    $message .= PRO_WITH_SAME_CODE."<br>";
}
}
if ($ddlArtist == "") {
$message .= SELLER_EMPTY."<br>";
}
//Generate Alias name for product
$aliasname = Utils::generateAlias($tableprefix . "products", $txtProductName);

if ($txtDescription == "") {
$message .= PRO_DESC_EMPTY."<br>";
}
$priceposted = $txtPrice;
$txtPrice = doubleval($txtPrice);
if (!isNotNull($txtPrice) && !isNotNull($priceposted)) {
$message .= PRO_PRICE_EMPTY."<br>";
} else if ($txtPrice <= 0 || !is_numeric($txtPrice)) {
$message .= PRO_PRICE_POSITIVE."<br>";
}

if ($txtDigitalProduct == "Y") {

if (!isNotNull($_FILES['txtProductZip']['name'])) {
    $message .= DIG_PRO_EMPTY."<br>";
}

$uploadfile = ReplaceArrayImage($_FILES['txtProductZip']['name']);
//$types = array('gif','jpg','png','zip', 'pdf', 'rar', 'psd', 'opf', 'azw', 'lit', 'pdb', 'pkg', 'mp3', 'mpeg', 'mp4', 'avi', 'mpg', 'wma');

//preg_match('/\.([a-zA-Z]+?)$/', $uploadfile, $matches);
$matches = explode(".", $uploadfile);

$matches_cnt = count($matches);

if (!in_array(strtolower($matches[$matches_cnt - 1]), $digital_product_types)) { // check file format is valid or not
    $message .= INVALID_FILE_FORMAT."<br>";
} // end format check
}


if (!in_array('1', $_POST['default_option'])) {
$message .= SEL_DEFAULT_OPTION."<br>";
}

$options_count = count($_POST['additional_price']);
for ($i = 0; $i < $options_count; $i++) {
$default_option = $_POST['default_option'][$i];
$additional_price = $_POST['additional_price'][$i];
$product_stock = $_POST['product_stock'][$i];
$reorder_level = $_POST['reorder_level'][$i];
$product_shipping_weight = $_POST['product_shipping_weight'][$i];

$discount = $_POST['discount'][$i];
$discount_description = $_POST['discount_description'][$i];
$product_length = $_POST['product_length'][$i];
$product_width = $_POST['product_width'][$i];
$product_height = $_POST['product_height'][$i];

$prodimagedir = "../products/";

$picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
$picsmallorgname = $_FILES['image_small']['name'][$i];
$picsmalltempname = $_FILES['image_small']['tmp_name'][$i];
$picsmalltype = $_FILES['image_small']['type'][$i];

$picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
$picbigtype = $_FILES['image_big']['type'][$i];
$picbigorgname = $_FILES['image_big']['name'][$i];
$picbigtempname = $_FILES['image_big']['tmp_name'][$i];

if ($picbigname != "") {
    $final_image_big = "productlarge_" . $i . time() . $picbigname;
} else {
    $final_image_big = "";
}

if ($picsmallname != "") {
    $final_image_small = "productsmall_" . $i . time() . $picsmallname;
} else {
    $final_image_small = "";
}

$picsmalldest = $prodimagedir . $final_image_small;
$picbigdest = $prodimagedir . $final_image_big;

$picsmallname = $final_image_small;
$picbigname = $final_image_big;

if (!is_readable($prodimagedir) || !is_writable($prodimagedir)) {
    $error = true;
    $message .= CHANGE_PERMISSION."<br>";
}

if($picbigname=='')
    {
         $message .= VAL_MSG_PIC_BIG_NULL." " . $i . "<br>";
         $error = true;
    }

if ($picsmalltype != "") {
    if (!isValidWebImageType($picsmalltype, $picsmallorgname, $picsmalltempname)) {
        $message .= SMALL_PICTURE." " . $i . "<br>";
        $error = true;
    } else {
        if (file_exists($picsmalldest)) {
            $message .= SMALL_PIC_EXISTS." " . $i . "<br>";
            $error = true;
        }
    }
}
if ($picbigtype != "") {
    if (!isValidWebImageType($picbigtype, $picbigorgname, $picbigtempname)) {
        $message .= BIG_PICTURE." " . $i . "<br>";
        $error = true;
    } else {
        if (file_exists($picbigdest)) {
            $message .= BIG_PIC_EXISTS." " . $i . "<br>";
            $error = true;
        }
    }
}


$product_stock = doubleval($product_stock);
if ($product_stock == "") {
    $message .= PRO_STOCK_EMPTY." " . ($i + 1) . " ! <br>";
}
if ($product_stock < 0 || !is_numeric($product_stock)) {
    if ($product_stock < 0) {
        $message .= PRO_STOCK_POSITIVE." " . ($i + 1) . " ! <br>";
    }
}

 if($discount != ""){
    if($discount >= 100){
        $message .= DISCOUNT_VALIDATION." ".($i+1)."! <br>";
    }
}

if ($additional_price != "") {
    if ($additional_price < 0 || !is_numeric($additional_price)) {
        $message .= ADDITIONAL_PRICE_POSITIVE." " . ($i + 1) . "! <br>";
    }
}


if ($chkcanship == "Y" && $txtDigitalProduct != "Y") {
    if ($product_length == "") {
        $message .= PRO_LEN_EMPTY." " . ($i + 1) . " !<br>";
    }
    if ($product_width == "") {
        $message .= PRO_WIDTH_EMPTY." " . ($i + 1) . " !<br>";
    }
    if ($product_height == "") {
        $message .= PRO_HEIGHT_EMPTY." " . ($i + 1) . " !<br>";
    }
    if ($txtDigitalProduct != "Y") {
        if ($product_shipping_weight == "") {
            $message .= PRO_SHIPPING_EMPTY." " . ($i + 1) . "!<br>";
        }
    }
}

if ($product_length != '') {
    if (!is_numeric($product_length)) {
        $message .= ENTER_VALID_PRO_LEN." " . ($i + 1) . "! <br>";
    }
}

if ($product_width != '') {
    if (!is_numeric($product_width)) {
        $message .= ENTER_VALID_WID." " . ($i + 1) . "! <br>";
    }
}

if ($product_height != '') {
    if (!is_numeric($product_height)) {
        $message .= ENTER_VALID_HT." " . ($i + 1) . "! <br>";
    }
}

if ($txtDigitalProduct != "Y") {
    if (!is_numeric($product_shipping_weight) || $product_shipping_weight == 0) {
        $message .= ENTER_VWT." " . ($i + 1) . "! <br>";
    }
}
$product_shipping_weight = doubleval($product_shipping_weight);

if ($product_shipping_weight < 0) {
    $message .= ENTER_PWT." " . ($i + 1) . "! <br>";
}
$reorder_level = doubleval($reorder_level);
if ($reorder_level != "") {
    if ($reorder_level < 0 || !is_numeric($reorder_level)) {
        $message .= POSITIVE_LEVEL." " . ($i + 1) . "! <br>";
    } else if ($reorder_level > $product_stock) {
        $message .= LEVEL_LESS." " . ($i + 1) . "! <br>";
    }
}
}
/*
* More Images Validation
*/

if (isset($_FILES['productMoreImage']['name']) && !empty($_FILES['productMoreImage']['name'])) {
foreach ($_FILES['productMoreImage']['name'] as $key => $moreImage) {
    if ($moreImage != '') {
        $type = $_FILES['productMoreImage']['type'][$key];
        if (!isValidWebImageType($type)) {
            $message .= " * Invalid more image " . ($key + 1) . "<br>";
        }
    }
}
}

$moreFiles = array();
foreach ($_FILES['productMoreImage'] as $k => $l) {
foreach ($l as $j => $v) {
    if (!array_key_exists($j, $moreFiles)) {
        $moreFiles[$j] = array();
    }
    $moreFiles[$j][$k] = $v;
}
}






/*
* More Images Validation - End
*/

if ($message != "") { // error
$message = "<br>".MSG_CORRECT_THE_ERRORS."<br>" . $message;
} else { // no error so insert user details
// Upload Digital Products
$digital_product_upload = 0;

$digitalproductname = preg_replace("/^[^a-z0-9.-]?(.*?)[^a-z0-9]?$/i", "$1", $_FILES['txtProductZip']['name']);
$digitalproductname = trim(str_replace(' ', '_', $digitalproductname));

$assignedname = randomDigitalProduct() . "_" . $digitalproductname;

if (@file_exists("../digital_product/" . $assignedname)) {
    $message .= PLEASE_RENAME." " . "<br>";
}

if ($txtDigitalProduct == "Y" && $_FILES['txtProductZip']['size'] > $maximagesizeinPHP) {
    $message.= FILE_SIZE_EXCEEDS." $maximagesizestringinPHP. <br>";
}


if ($txtDigitalProduct == "Y" && $message == '') {

    if (move_uploaded_file($_FILES['txtProductZip']['tmp_name'], "../digital_product/" . $assignedname)) {
        $digital_product_upload = 1;
        chmod("../digital_product/$assignedname", 0777);
    } else {
        $message .= COULDNT_UPLOAD." " . "<br>";
    }
}

//default published if settings disabled 
//  echo getSettingsValue('enable_product_scheduled_publishing');die("here");
if(getSettingsValue('enable_product_scheduled_publishing')=='N') 
{
$rdPublishStatus    = 'Y';
}       

// get the seller information and set vacation mode status in product 
$sellerCartObj      =    Store::get_seller_account_info($ddlArtist);
//echopre($sellerCartObj);
if($sellerCartObj->status==SUCCESS)
{
     $sellerCartObjVal      =   $sellerCartObj->data;
     $seller_vacation_mode  =   $sellerCartObjVal->is_vacation_mode;
}

if ($message == '') {
    
    $data = array(
			"product_name" => addslashes($txtProductName),
			"product_code" => addslashes($txtProductCode),
			"product_description" => addslashes($txtDescription),
                                "product_price" => addslashes($txtPrice),
			"vdigital_product" => $txtDigitalProduct,
			"product_category" => addslashes($catid),
                                "product_artist_id" => addslashes($ddlArtist),
			"date_added" => date(),
			"vapproved" => 'Y',
                                "payment_status" => 'COMPLETED',
			"alias" => addslashes($aliasname),
			"publish_status" => $rdPublishStatus,
                                "publish_scheduled_date" => $publishDate,
			"publish_scheduled_date" => addslashes($txtSearchTags),
			"allow_subscription" => $chkAllowSubscription,
                                "subscription_mode" => $rdSubscriptionMode,
                                "publish_timezone" => $sellertimezone,
			"allow_free_shipping" => $chkAllowFreeShipping,
			"seller_vacation_mode" => $seller_vacation_mode
			
			);
	
	$product_insert_id = $pdo->insert($tableprefix."products",$data)->lastInsertId();
    //Product Options Insertion here Santhosh thomas Alexander
    for ($i = 0; $i < $options_count; $i++) {

        $default_option = $_POST['default_option'][$i];
        $additional_price = $_POST['additional_price'][$i];
        $product_stock = $_POST['product_stock'][$i];
        $reorder_level = $_POST['reorder_level'][$i];
        $product_shipping_weight = $_POST['product_shipping_weight'][$i];
        $discount = $_POST['discount'][$i];
        $discount_description = $_POST['discount_description'][$i];
        $product_length = $_POST['product_length'][$i];
        $product_width = $_POST['product_width'][$i];
        $product_height = $_POST['product_height'][$i];
        $default_option_actual = "NO";
        if ($default_option == 1) {
            $default_option_actual = "YES";
        }
        $small_image_name_after_upload = "";
        $big_image_name_after_upload = "";

        $dir_dest = "../products";

//*********************************************Multicart3.0 Image Upload Modifications*************************//

        $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);

        $final_image_big = "";
        if ($picbigname != "") {
            $picBigArr = explode('.', $picbigname);
            $cntCountParamsBig = count($picBigArr);
            $name_big_with_out_extension = str_replace('.' . $picBigArr[$cntCountParamsBig - 1], '', $picbigname);
            $final_image_big = "productbig_" . $productid . "_" . $i . "_" . time() . $name_big_with_out_extension;
        }
        $picbigname = $final_image_big;

        $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);

        $final_image_small = "";

        if ($picsmallname != "") {
            $picSmallArr = explode('.', $picsmallname);
            $cntCountParamsSmall = count($picSmallArr);
            $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
            $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
        }else{
                // Save and resize Big Image to small size if small image not uploaded
                if($_FILES['image_big']['name'][$i]!='')
                    {
                        $picsmallname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
                        $picSmallArr = explode('.', $picsmallname);
                        $cntCountParamsSmall = count($picSmallArr);
                        $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
                        $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
                    }
        }
        $picsmallname = $final_image_small;

         /**************Saving the original image*****************/
        /*if($_FILES['image_small']['name'][$i] !=''){
           
            $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
            $imagecontent = file_get_contents($_FILES['image_small']['tmp_name'][$i]);

            $file_extn              = end(explode(".",$picsmallname));
            //Save Small image
            $original_image_name_after_upload      = "productoriginal_".$product_insert_id."_".time().$picsmallname;
            $imageOriginal                        = "../products/".$original_image_name_after_upload;
            $imageOriginalSave                     = fopen($imageOriginal,'x');
            fwrite($imageOriginalSave, $imagecontent);
            fclose($imageOriginalSave);
           
        }*/

        /**************Saving the original image*****************/
        // Save small Images


        if ($_FILES['image_small']['name'][$i] != "") {
            //Commenting the previous code
            $files = array();
            foreach ($_FILES['image_small'] as $k => $l) {
                foreach ($l as $j => $v) {
                    if (!array_key_exists($j, $files))
                        $files[$j] = array();
                    $files[$j][$k] = $v;
                }
            }

            for ($x = 0; $x < count($files); $x++) {
                if ($x == $i) {
                    $handle = new Upload($files[$x]);
                    if ($handle->uploaded) {
                        // Modification resize
                        //   $info = getimagesize($inputFileName);
                        $handle->image_resize = true;
                        $handle->image_ratio = true;
                        $handle->image_x = 387;
                        $handle->image_y = 260;
                        $handle->file_new_name_body = $picsmallname;
                        $handle->Process($dir_dest);
                        $small_image_name_after_upload = $handle->file_dst_name;
                        $imagepath             = "../products/".$small_image_name_after_upload;
                        moveImageToCDN($imagepath,'products/'.$small_image_name_after_upload);
                    }
                }
            }
       }
/********** Image resizing maintaining aspect ratio begin***********/
            /*$imagecontent           = file_get_contents($_FILES['image_small']['tmp_name'][$i]);
            $file_extn              = end(explode(".",$picsmallname));

            // $small_image_name_after_upload      = "productsmall_".$product_insert_id."_".time().$picsmallname;

            $small_image_name_after_upload = str_replace('productoriginal_','productsmall_',$original_image_name_after_upload);
            $imageSmall             = "../products/".$small_image_name_after_upload;
            $imageSmallSave         = fopen($imageSmall,'x');
            fwrite($imageSmallSave, $imagecontent);
            fclose($imageSmallSave);
            reSizeImageFromFolder($imageSmall,191,183);*/
            /********** Image resizing maintaining aspect ratio end***********/
        
        //small image upload end


        //*****************big Image Upload**************************
       
        if ($picbigname != "") {
            //Commenting the previous code
            $files = array();
            foreach ($_FILES['image_big'] as $k => $l) {
                foreach ($l as $j => $v) {
                    if (!array_key_exists($j, $files))
                        $files[$j] = array();
                    $files[$j][$k] = $v;
                }
            }
            for ($x = 0; $x < count($files); $x++) {
                if ($x == $i) {
                    $handle = new Upload($files[$x]);
                    if ($handle->uploaded) {

                        $handle->image_resize = true;
                        $handle->image_ratio = true;
                        $handle->image_x = 489;
                        $handle->image_y = 328;
                        $handle->file_new_name_body = $picbigname;
                        $handle->Process($dir_dest);
                        $big_image_name_after_upload = $handle->file_dst_name;
                        $imagepath             = "../products/".$big_image_name_after_upload;
                        moveImageToCDN($imagepath,'products/'.$big_image_name_after_upload);
                        
                        
                        $main_thumb_file_name           =    "thumb_".$picbigname;
                        $handle->file_new_name_body     =    $main_thumb_file_name;
                        $handle->image_resize           = true;
                        $handle->image_x                = 82;
                        $handle->image_y                = 79;
                        $handle->image_ratio            = true;
                        $handle->Process($dir_dest);
                        $main_thumb_file_name_after_upload = $handle->file_dst_name;
                        $imagethubpath             = "../products/".$main_thumb_file_name_after_upload;
                        moveImageToCDN($imagethubpath,'products/'.$main_thumb_file_name_after_upload);
            
                    }

                     /*// Create thumbnail Image and save to thumb folder
                    $big_file_name                  =    "thumb_".$big_image_name_after_upload;
                    $handle->file_new_name_body     =    $big_file_name;
                    $handle->image_resize           = true;
                    $handle->image_x                = 82;
                    $handle->image_y                = 79;
                    $handle->image_ratio            = true;
                    $handle->Process($dir_dest);
                    $imagethumbpath  = "../products/".$big_file_name;
                    moveImageToCDN($imagethumbpath,'products/'.$big_file_name);*/


                    // Resize  Small images in listing if small image  not uploaded
                       if($_FILES['image_small']['name'][$i]=='') {
                                    $small_file_name                =    $picsmallname;
                                    $handle->file_new_name_body     =    $small_file_name;
                                    $handle->image_resize           =    true;
                                    $handle->image_x                =    387;
                                    $handle->image_y                =    260;
                                    $handle->image_ratio            =    true;
                                    $handle->Process($dir_dest);
                                    $small_image_name_after_upload  = $handle->file_dst_name;
                                    $imagepath             = "../products/".$small_image_name_after_upload;
                                    moveImageToCDN($imagepath,'products/'.$small_image_name_after_upload);

                       }

                    
                }
            }


        }


            /********** Image resizing maintaining aspect ratio begin***********/
             /*$imagecontent = file_get_contents($_FILES['image_big']['tmp_name'][$i]);
             $file_extn              = end(explode(".",$picbigname));

              //$big_image_name_after_upload      = "productbig_".$product_insert_id."_".time().$picbigname;
              $big_image_name_after_upload = str_replace('productoriginal_','productbig_',$original_image_name_after_upload);
              $imageSmall             = "../products/".$big_image_name_after_upload;
              $imageSmallSave         = fopen($imageSmall,'x');
              fwrite($imageSmallSave, $imagecontent);
              fclose($imageSmallSave);
              reSizeImageFromFolder($imageSmall,283,269);*/
               /********** Image resizing maintaining aspect ratio begin***********/
                        //big image upload end
        //Product option Images upload end
        //small Image Upload
        /*
          $picsmallname 		= ReplaceArrayImage($_FILES['image_small']['name'][$i]);

          $final_image_small = "";

          if($picsmallname != "") {
          $picSmallArr            = explode('.', $picsmallname);
          $cntCountParamsSmall    = count($picSmallArr);
          $name_small_with_out_extension      = str_replace('.'.$picSmallArr[$cntCountParamsSmall-1], '', $picsmallname);
          $final_image_small      = "productsmall_".$product_insert_id."_".$i."_".time().$name_small_with_out_extension;

          }
          $picsmallname = $final_image_small;

          // then we check if the file has been uploaded properly
          // in its *temporary* location in the server (often, it is /tmp)

          if($picsmallname !="") {
          $files = array();
          foreach ($_FILES['image_small'] as $k => $l) {
          foreach ($l as $j => $v) {
          if (!array_key_exists($j, $files))
          $files[$j] = array();
          $files[$j][$k] = $v;
          }
          }

          for($x=0;$x < count($files);$x++) {
          if($x ==$i) {
          $handle = new Upload($files[$x]);
          if ($handle->uploaded) {

          $handle->image_resize            = true;
          //$handle->image_ratio_y           = true;
          $handle->image_x                 = 191;
          $handle->image_y                 = 183;
          $handle->file_new_name_body      = $picsmallname;
          $handle->Process($dir_dest);

          $small_image_name_after_upload  = $handle->file_dst_name;

          }
          }
          }
          }
          //small image upload end
          //big Image Upload

          $picbigname 		= ReplaceArrayImage($_FILES['image_big']['name'][$i]);

          $final_image_big = "";
          if($picbigname != "") {
          $picBigArr            = explode('.', $picbigname);
          $cntCountParamsBig    = count($picBigArr);
          $name_big_with_out_extension      = str_replace('.'.$picBigArr[$cntCountParamsBig-1], '', $picbigname);
          $final_image_big      = "productbig_".$product_insert_id."_".$i."_".time().$name_big_with_out_extension;

          }
          $picbigname = $final_image_big;

          // then we check if the file has been uploaded properly
          // in its *temporary* location in the server (often, it is /tmp)

          if($picbigname !="") {
          $files = array();
          foreach ($_FILES['image_big'] as $k => $l) {
          foreach ($l as $j => $v) {
          if (!array_key_exists($j, $files))
          $files[$j] = array();
          $files[$j][$k] = $v;
          }
          }
          for($x=0;$x < count($files);$x++) {
          if($x ==$i) {
          $handle = new Upload($files[$x]);
          if ($handle->uploaded) {

          $handle->image_resize            = true;
          $handle->image_x                 = 283;
          $handle->image_y                 = 269;
          $handle->file_new_name_body      = $picbigname;
          $handle->Process($dir_dest);
          $big_image_name_after_upload  = $handle->file_dst_name;

          }
          }
          }
          }
          //big image upload end
          //Product option Images upload end
        */  

                            $data = array(
			"product_id" => $product_insert_id,
			"additional_price" => $additional_price,
			"product_stock" => $product_stock,
                                "reorder_level" => $reorder_level,
			"product_shipping_weight" => $product_shipping_weight,
			"image_small" => $small_image_name_after_upload,
                                "image_big" => $big_image_name_after_upload,
			"discount" => $discount,
			"discount_description" => $discount_description,
                                "product_length" => $product_length,
			"product_width" => $product_width,
			"product_height" => $product_height,
                                "default_option" => $default_option_actual,
			"cdn_images_moved" => $cdn_enabled
								
			);
	
	$product_option_id = $pdo->insert($tableprefix."product_options",$data)->lastInsertId();
                $options_arr = getOptionsFromCategory($catid);
        $num_of_options = count($options_arr);
        if ($num_of_options != "") {
            foreach ($options_arr AS $eachoption) {

                $option_Id = $eachoption['option_id'];
                $option_value = $_POST["option_" . $option_Id][$i];
                if ($option_value != "") {

                    $query_option_insert = "INSERT INTO " . $tableprefix . "product_option_values
                                        (
                                        product_option_id,
                                        option_id,
                                        value
                                        )
                                        VALUES
                                        (
                                        '" . $product_option_id . "',
                                        '" . $option_Id . "',
                                        '" . $option_value . "'
                                        )";
                   $pdo->pdoQuery($query_option_insert);
                }
            }
        }

    }

//*************************************Multicart3.0 Scalability Modifications*******************************************
    
// Save product default option values to product  table
if(getSettingsValue('enable_scalability_settings')=='Y')
{
    $objDefaultOptionVo                                     =    new stdClass();
    $objOptionVo                                            =    Products::getProduct_Default_Option_Values($product_insert_id);

    $objDefaultOptionVo->default_image_small                =   $objOptionVo->image_small;
    $objDefaultOptionVo->default_stock                      =   $objOptionVo->product_stock;
    $objDefaultOptionVo->default_additional_price           =   $objOptionVo->additional_price;
    $objDefaultOptionVo->default_shipping_weight            =   $objOptionVo->product_shipping_weight;
    $objDefaultOptionVo->default_discount                   =   $objOptionVo->discount;
    $objDefaultOptionVo->default_discount_description       =   $objOptionVo->discount_description;
    $objDefaultOptionVo->default_option_id                  =   $objOptionVo->product_option_id;
    $objDefaultOptionVo->product_id                         =   $product_insert_id;

    // Save default option values to product table
    $productinfoUpdate                                      =   Products::updateProduct_Default_Option_Value($objDefaultOptionVo);
    
}
// echopre($objDefaultOptionVo);
    //exit;

//*************************************Multicart3.0 Scalability Modifications End *******************************************

    if ($txtDigitalProduct == "Y" && $digital_product_upload == '1') {

        $expiry_days = $_POST['txtDownloadExpiry'];
        //$valid_date_upto = date("Y-m-d H:s:m",mktime(date("H"),date("i"),date("s"),date("m"),date("d")+$expiry_days,date("Y")));

        $insert_digital_product = "INSERT INTO " . $tableprefix . "digital_product(ndigital_productid,vdigital_product_name,ndownload_try
					  		  ,ndownload_expiry_days)VALUES(" . $product_insert_id . ","
                . GetSQLValueString($assignedname, "text") . ",
							  " . $_POST['txtDownloadTry'] . ",
							  '" . $expiry_days . "')";

        $pdo->pdoQuery($insert_digital_product);
    }

    /*
     * Product more images By Binu Chandran.E
    */
    $moreFiles = array();
    foreach ($_FILES['productMoreImage'] as $k => $l) {
        foreach ($l as $j => $v) {
            if (!array_key_exists($j, $moreFiles)) {
                $moreFiles[$j] = array();
            }
            $moreFiles[$j][$k] = $v;
        }
    }
    $dir_dest = "../products";
    for ($x = 0; $x < count($moreFiles); $x++) {
        $moreImageName = ReplaceArrayImage($moreFiles[$x]['name']);
        if ($moreImageName != "") {
            /********** Image resizing maintaining aspect ratio begin***********/
             /*$imagecontent = file_get_contents($_FILES['productMoreImage']['tmp_name'][$x]);
             $file_extn              = end(explode(".",$moreImageName));

              $moreImageNameAfterupload = "productmore_" . $x . time() . $moreImageName;
              $imageMore             = "../products/".$moreImageNameAfterupload;
              $imageMoreSave         = fopen($imageMore,'x');
              fwrite($imageMoreSave, $imagecontent);
              fclose($imageMoreSave);
              reSizeImageFromFolder($imageMore,283,269);
              $insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                                              SET nimage_productid = '" . mysql_real_escape_string($product_insert_id) . "',
                                                  vimage_name= '" . mysql_real_escape_string($moreImageNameAfterupload) . "',
                                                  vproduct_image_delete_status 	='N'";
              mysql_query($insertMImageQuery) or die(mysql_error());*/
            
            $handle = new Upload($moreFiles[$x]);
            if ($handle->uploaded) {

                $moreImageName = "productmore_" . $x . time() . $moreImageName;
                $moreImageName_Upload       =   substr($moreImageName, 0, strrpos($moreImageName, '.'));
                $handle->image_resize = true;
                $handle->image_x = 489;
                $handle->image_y = 328;
                $handle->image_ratio= true;
                $handle->file_new_name_body = $moreImageName_Upload;
                $handle->Process($dir_dest);
                $moreImageName = $handle->file_dst_name;

                $imagepath             = "../products/".$moreImageName;
                moveImageToCDN($imagepath,'products/'.$moreImageName);

                // Save More Image Thubnail to thumb folder

                $more_thumb_file_name           =    "thumb_".$moreImageName_Upload;
                $handle->file_new_name_body     =    $more_thumb_file_name;
                $handle->image_resize           = true;
                $handle->image_x                = 82;
                $handle->image_y                = 79;
                $handle->image_ratio            = true;
                $handle->process($dir_dest);
                $more_thumb_file_name_after_upload = $handle->file_dst_name;
                $imagethubpath             = "../products/".$more_thumb_file_name_after_upload;
                moveImageToCDN($imagethubpath,'products/'.$more_thumb_file_name_after_upload);
                
                $insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                                              SET nimage_productid = :product_insert_id,
                                                  vimage_name= :moreImageName,
                                                  vproduct_image_delete_status 	='N',
                                                  cdn_images_moved = :cdn_enabled";
                $pdo->pdoQuery($insertMImageQuery, array("product_insert_id" => $product_insert_id, "moreImageName" => $moreImageName, "cdn_enabled" => $cdn_enabled));
            }
        }
    }
    
    // Send push notification
    $devicesql = "Select device_id from " . $tableprefix . "artists where artist_id ='$ddlArtist'"; //Get seller device ID           
    $result = $pdo->pdoQuery($devicesql)->result();
    $device_row = $result;
    $msg = "New Product - '".$txtProductName."' added at ".SITE_NAME. ", please check.";
    send_push_nofication($msg,SITE_NAME,"armia",$device_row['device_id'],"Product");//Message,From,passphrase,device token,type-->product,order...
    //-------------------------// 

    $txtSearch = "";
    $txtProductName = "";
    $txtProductCode = "";
    $txtDescription = "";
    $txtPrice = "";
    $ddlArtist = "";

    //update count
    $routesql = "Select route from " . $tableprefix . "categories where category_id ='$catid'";
    //echo $routesql;
    $result = $pdo->pdoQuery($routesql)->result();
    $row = $result;
    $route = $row["route"];
    $qryupdatecatcount = "update " . $tableprefix . "categories set count=count+1 where category_id in($route)";
    $pdo->pdoQuery($qryupdatecatcount);

    $success_message = PRO_ADD_SCC;

    header("Location:catalog.php?message=$message&catid=$catid");
    exit;
}
}
} else if ($_POST["btnDeleteSelected"]) {
if (!isNotNull($productlist)) {
$message .= DELETE_PRO." <br>";
} else {
$cnt = count($productlist);
$plist = implode(",", $productlist);
list($qarr,$qstr) = getInQueryString($plist);
$sql = "DELETE FROM " . $tableprefix . "products WHERE product_id IN ($qstr) ";
$res = $pdo->pdoQuery($sql,$qarr)->results();

$select_product_images = "SELECT image_small,image_big
                                              FROM " . $tableprefix . "product_options WHERE product_id IN(" . $qstr . ")";


$result_product_images = $pdo->pdoQuery($select_product_images, $qarr)->results();

if (!empty($result_product_images)) {
    foreach($result_product_images as $product_images_row) {
        $imagesmall_thumb = $product_images_row['image_small'];

        $imagelarge_thumb = $product_images_row['image_big'];

        @unlink("../products/" . $imagesmall_thumb);
        @unlink("../products/" . $imagelarge_thumb);
         deleteCDNImage('products/'.$imagesmall_thumb);
         deleteCDNImage('products/'.$imagelarge_thumb);
    }
}
$sql_options = "DELETE FROM " . $tableprefix . "product_options WHERE product_id IN ($qstr) ";
$del_options = $pdo->pdoQuery($sql_options, $qarr);

$select_product_images_more = "SELECT im.vimage_name
                                           FROM " . $tableprefix . "product_view_images im
                                           WHERE im.nimage_productid IN(" . $qstr . ")";
$rs_product_image_more = $pdo->pdoQuery($select_product_images_more,$qarr)->results();

if (count($rs_product_image_more) > 0) {

    foreach ($rs_product_image_more as $prows) {
        $moreimage = $prows['vimage_name'];
        $moreimage_thumb = "thumb_" . $prows['vimage_name'];
        @unlink("../products/" . $moreimage);
        @unlink("../products/" . $moreimage_thumb);
        deleteCDNImage('products/'.$moreimage);
        deleteCDNImage('products/'.$moreimage_thumb);
    }
}

$sql_product_images_more = "DELETE FROM " . $tableprefix . "product_view_images WHERE nimage_productid IN ($qstr) ";
$del_product_images_more = $pdo->pdoQuery($sql_product_images_more,$qarr)->results();

$delete_cart_products = "DELETE FROM " . $tableprefix . "cart WHERE product_id IN(" . $qstr . ")";

$pdo->pdoQuery($delete_cart_products,$qarr)->results();
}
}

$artistlist = makeArtistList();

/*$sql = " SELECT p.product_id,p.product_name,p.product_code,(p.product_price+po.additional_price) as product_price,p.date_added,s.artist_name
    FROM " . $tableprefix . "products p
    INNER JOIN " . $tableprefix . "product_options po ON po.product_id = p.product_id AND po.default_option = 'YES'
    INNER JOIN " . $tableprefix . "artists s ON p.product_artist_id = s.artist_id
    WHERE product_category = '" . addslashes($catid) . "' " . $qryopt . "   ORDER BY p.product_name  ";*/


//*************************************Multicart Scalability Modifications for Product Listing

$sql = " SELECT p.product_id,p.product_name,p.product_code,(p.product_price+p.default_additional_price) as product_price,p.date_added,p.seller_name as artist_name,p.product_artist_id as artist_id
    FROM " . $tableprefix . "products p
    WHERE product_category = :catid " . $qryopt . "   ORDER BY p.product_name  ";
$qryoptArr['catid'] = $catid;
//*****************************************Multicart Scalability Modifications for Product Listing


$sess_back = $_SERVER["PHP_SELF"] . "?begin=" . $begin . "&num=" . $num . "&numBegin=" . $numBegin . "&cmbSearchType=" . $cmbSearchType . "&txtSearch=" . $txtSearch . "&catid=" . $catid;
$_SESSION["gbackurl"] = $sess_back;
$Count = $pdo->pdoQuery($sql, $qryoptArr)->results();
$totalrows = count(($Count));
$txtSearch1 = urlencode($txtSearch);
$navigate = pageBrowser($totalrows, 10, 10, "&cmbSearchType=$cmbSearchType&txtSearch=$txtSearch1&catid=$catid", $_GET[numBegin], $_GET[start], $_GET[begin], $_GET[num]);
$sql = $sql . $navigate[0];
$rs = $pdo->pdoQuery($sql, $qryoptArr)->results();
$shipping_Dimension_Required    =   checkShippingDimensionEnable();
include "../includes/htmltop.php";
?>
<link rel="stylesheet" href="<?php echo $site_url; ?>/style/jquery-ui.css">
<script src="<?php echo $site_url; ?>/js/jquery-1.11.2.js"></script>
<script src="<?php echo $site_url; ?>/js/jquery-ui.js"></script>
<link href="<?php echo $site_url; ?>/style/jquerysctipttop.css" rel="stylesheet" type="text/css">
<!-- CSS Stylesheet -->
<link rel="stylesheet" href="<?php echo $site_url; ?>/style/dateselector.css" type="text/css" />
<!-- Scripts -->

<style>
/*.tooltip {
display:none;
background:transparent url(../images/tooltip/black_arrow.png);
font-size:12px;
height:70px;
width:160px;
padding:25px;
color:#fff;
}*/

.tooltip {
background-color: black;;
filter: alpha(opacity=75)-moz-opacity:0.75;
opacity: 0.75;
border: 2px solid #FFFFFF;

border-radius:5px 5px 5px 5px;
color: white;
font-size: 1.2em;
left: -12px;
padding: 10px;
position: relative;
top: 21px;
width: 200px;
}
.tooltip:after, .tooltip:before
{
top: 100%;
border: solid transparent;
content: " ";
height: 0;
width: 0;
position: absolute;
pointer-events: none;
}
.tooltip:after
{
border-color: rgba(10, 13, 15, 0);
border-top-color: #0a0d0f;
border-width: 10px;
left: 50%;
margin-left: -10px;
} .tooltip:before

{
border-color: rgba(245, 245, 245, 0);
border-top-color: #f5f5f5;
border-width: 16px;
left: 50%;
margin-left: -16px;
}

</style>
<!--<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/jquery.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/jquery.tools.min.js"></script>-->
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/dateselector.min.js"></script>

<script language="JavaScript" type="text/JavaScript">
$(document).ready(function(){
$(".help a[title]").tooltip();

$('#txtSearch').keypress(function(e){

    if(e.keyCode==13){

        clickSearch();
    }
});


$('#txtPrice').keyup(function(e){
    var price = parseFloat($('#txtPrice').val());         
    var newVal = $('#txtPrice').val().replace(/[^\d.]/, '');            
    var number = (newVal.split('.'));
    $('#txtPrice').val(newVal);
    if (typeof(number[1]) != "undefined"){
        if (number[1].length > 2)
        {               
            $("#txtPrice").val( price.toFixed(2));
        }
    }

});
$('.jqPrice').keyup(function(e){
    var price = parseFloat($(this).val());         
    var newVal = $(this).val().replace(/[^\d.]/, '');            
    var number = (newVal.split('.'));
    $(this).val(newVal);
    if (typeof(number[1]) != "undefined"){
        if (number[1].length > 2)
        {               
            $(this).val( price.toFixed(2));
        }
    }

});
$('#chkAllowSubscription').click(function(e){
   if ($('input[name=chkAllowSubscription]:checked').val() ) {  
       $('#subscription_mode').show();
   }else{$('#subscription_mode').hide();}

});

 $('#cmbSeller').change(function(){

        var sellerid    =   $(this).val();
       changePublishSettings(sellerid);
 });    
 
 
 

$('.rdPublishStatus').click(function(){

if($('input[name=rdPublishStatus]:checked').val()=="N"){            
    $("#publish_time").show();            
}else if($('input[name=rdPublishStatus]:checked').val()=="Y"){
    $("#publish_time").hide();            
}

});    


//Datepicker    
var dateToday = new Date(Date.now());
$("#publishdate").datepicker({
dateFormat: 'mm-dd-yy',
minDate: dateToday
}).datepicker('setDate', dateToday)


})


function changePublishSettings(sellerid)
{
 var action='vacationmodesetting';
 var sellerid   =   sellerid;       
 var dataString = {"action":action,"sellerId":sellerid};

$.ajax({
url		: "<?php echo SITE_URL?>/utils.php",
type		: "POST",
data		: dataString,
dataType        : "json",
   success: function(data) {
            var flag =data.flag;
               if(flag=='Y')
              {
                    $("#publish_time").show();
                    $("#jQPublishY").hide();
                    $('#jQPublish_N').prop('checked', true);
                    
             }else{
                   
                      $("#jQPublishY").show();
                      $("#publish_time").hide();
                      $('#jQPublish_Y').prop('checked', true);
                  }
      }


    });
}
function clickSearch()
{

document.frmCatalog.submit();

}
function confirmDelete(){
if(confirm("<?php echo ARE_YOU_SURE_DELETE; ?>") ){
    return true;
}
return false;
}
function checkDigitalProduct()
{

if(document.frmCatalog.txtDigitalProduct.checked == true)
{

    document.getElementById("digitalProductBlock").style.display = "";
    $(".canshipBlock").hide();
    $("#allow_free_shipping").hide();

}
else
{

    document.getElementById("digitalProductBlock").style.display = "none";
    $(".canshipBlock").show();
    $("#allow_free_shipping").show();

}

}

function add_more_upload()
{
var new_total = Math.round(document.frmCatalog.TOTAL_FILE.value) + 1;

if(new_total<=document.frmCatalog.MAX_NO_IMAGES.value)
{
    document.getElementById('pic'+document.frmCatalog.TOTAL_FILE.value).style.display='';
    document.frmCatalog.TOTAL_FILE.value++;
}//end if
}//end funciton

function checkEnter(e){
e = e || event;
return (e.keyCode || event.which || event.charCode || 0) !== 13;
}

var _URL = window.URL || window.webkitURL;

function showMyImage(files, imageId, dbImagePreview, fileInput) {
var file = files[0];
var img = new Image();
var sizeKB = file.size / 1024;
img.onload = function () {
    
    if(imageId == 'small_img_preview'){
        img_width = 200;
        img_height = 150;
    }
    else{

        img_width = 350;
        img_height = 245;
    }


    if (img.width < img_width) {

        warning_msg = "The image width should be " + img_width;
        alert(warning_msg);
        fileInput.value = '';
        return false;

    }
    else if (img.height < img_height) {

        warning_msg = "The image height should be " + img_height;
        alert(warning_msg);
        fileInput.value = '';
        return false;

    }
    else {
        var imageType = /image.*/;
        $(".jqMoreImagefromDb_" + dbImagePreview).remove();
        $("#" + imageId).show();
        var newimg = document.getElementById(imageId);
        newimg.file = file;
        var reader = new FileReader();
        reader.onload = (function (aImg) {
            return function (e) {
                aImg.src = e.target.result;
            };
        })(newimg);
        reader.readAsDataURL(file);
    }


}
img.src = _URL.createObjectURL(file);
}


function showBigImages(files, value, fileInput ) {
var file = files[0];
var img = new Image();
var sizeKB = file.size / 1024;

img.onload = function () {

    img_width = 350;
    img_height = 245;

    if (img.width < img_width) {

        warning_msg = "The image width should be " + img_width;
        alert(warning_msg);
        fileInput.value = '';
        return false;

    }
    else if (img.height < img_height) {

        warning_msg = "The image height should be " + img_height;
        alert(warning_msg);
        fileInput.value = '';
        return false;

    }
    else {


        var imageType = /image.*/;
    
        var imageId = 'big_img_preview_' + value;
        $("#" + imageId).show();
        var newimg = document.getElementById(imageId);
        newimg.file = file;
        var reader = new FileReader();
        reader.onload = (function (aImg) {
            return function (e) {
                aImg.src = e.target.result;
            };
        })(newimg);
        reader.readAsDataURL(file);
    }
}
img.src = _URL.createObjectURL(file);
}

function showSmallImages(files, value, fileInput) {
var file = files[0];
var img = new Image();
var sizeKB = file.size / 1024;

img.onload = function () {

    img_width = 200;
    img_height = 150;

    if (img.width < img_width) {

        warning_msg = "The image width should be " + img_width;
        alert(warning_msg);
        fileInput.value = '';
        return false;

    }
    else if (img.height < img_height) {

        warning_msg = "The image height should be " + img_height;
        alert(warning_msg);
        fileInput.value = '';
        return false;

    }
    else {
        var imageType = /image.*/;
        var imageId = 'small_img_preview_' + value;
        $("#" + imageId).show();
        var newimg = document.getElementById(imageId);
        newimg.file = file;
        var reader = new FileReader();
        reader.onload = (function (aImg) {
            return function (e) {
                aImg.src = e.target.result;
            };
        })(newimg);
        reader.readAsDataURL(file);
    }
}
img.src = _URL.createObjectURL(file);
}

</script>
<body>
<center>
<div align="left" id="layout">
    <!--header area start -->
    <?php
    include_once("../includes/topheader_admin.php")
            ?>
    <!--header area end -->
    <div align="left" class="main_body">
        <!--main body start -->
        <?php
        include_once("../includes/admintopmenu.php")
                ?>
        <div align="left" class="content_area">
            <!--content area start -->
            <div align="left" class="page_title"><?php echo CATALOG; ?></div>
            <div align="center" class="text_information grey_tr"><?php
                if ($_GET['message'] != '') {
                    //$message = $_GET['message'];
                }
                ?><?php echo $message ?></div>
             <div align="center" class="text_information_success grey_tr"><?php
                if ($_GET['message'] != '') {
                    $success_message = $_GET['message'];
                }
                ?><?php echo $success_message; ?></div>
            <br>
            <div align="left">
                <form name="frmCatalog" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data" >
                    <input type="hidden" name="catid" value="<?php echo htmlentities($catid); ?>" >
                    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="manage_top">
                        <tr>
                            <td colspan="3">
                                <fieldset>
                                    <legend class='page_title2'><?php echo EXISTING_CAT; ?></legend>
                                    <table width="100%" class="category_bx" border=0 align="left">
                                        <tr><td colspan="2" class="sub_hds" align='left' style='word-break:break-all;'><?php echo getCategoryLink("catalog.php", $catid) ?></td></tr>
                                        <tr><td colspan="2">
                                                <table width="70%" cellpadding="5">

                                                    <?php
                                                    if (!isset($catid) || $catid == "") {
                                                        $catid = 0;
                                                    }
                                                    $sql = "SELECT * FROM " . $tableprefix . "categories WHERE parent_id = :catid ORDER BY category_name ";
                                                    $res = $pdo->pdoQuery($sql, array("catid" => $catid))->results();
                                                    $odd = true;
                                                    if (count($res) != 0) {
                                                        ?>
                                                    <tr align="left">
                                                        <th><?php echo NAME; ?></th>
                                                        <th><?php echo ADD_SUBCAT; ?></th>
                                                        <th><?php echo DETAILS; ?></th>
                                                        <th><?php echo EDIT; ?></th>
                                                        <th><?php echo DELETE; ?></th>
                                                    </tr>
                                                        <?php
                                                        foreach ($res as $row) {
                                                            if ($row["gift_certificate_flag"] == 'Y') {
                                                                $link_go = '#';
                                                            } else {
                                                                $link_go = 'catalog.php?catid=' . $row["category_id"] . '&parent=' . $catid . '';
                                                            }
                                                            ?>
                                                    <tr align="left">
                                                        <td><?php echo "<a class='links' href='" . $link_go . "'>" . stripslashes($row["category_name"]) . "</a>&nbsp;&nbsp;"; ?></td>
                                                        <td><?php if ($row["gift_certificate_flag"] != 'Y') { ?> <?php echo "<a class='links' href='addcategory.php?catid=" . $row["category_id"] . "&parent=" . $catid . "' >+ ".ADD_SUBCAT."</a>"; ?><?php } ?></td>
                                                        <td><?php echo "<a class='links' href='" . $link_go . "'>".DETAILS."</a>"; ?></td>
                                                        <td><?php if ($row["gift_certificate_flag"] != 'Y') { ?>    <?php echo "<a href='editcategory.php?catid=" . $row["category_id"] . "&parent=" . $catid . "'  class='links' >".EDIT."</a>&nbsp;" ?> <?php } ?></td>
                                                        <td><?php if ($row["gift_certificate_flag"] != 'Y') { ?> <?php echo "<a class='links' href='catalog-delete.php?catid=" . $row["category_id"] . "&parent=" . $catid . "' onClick='return confirm(\"".ARE_U_SURE."\");'>".DELETE."</a>"; ?> <?php } ?></td>
                                                    </tr>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </table>
                                            </td></tr>
                                        <tr><td colspan="2">&nbsp;</td></tr>

                                        <tr><td colspan="2">&nbsp;</td></tr>
                                    </table>
                                </fieldset>

                            </td>
                        </tr>
                        <tr><td colspan="3">
                                <?php if (!($catid > 0)) {
                                    ?>
                                <input class="button" type="button" onclick="window.location='addcategory.php'" value="<?php echo ADD_CATEGORY; ?>"/>
                                    <?php } ?>
                            </td></tr>
                        <?php
                        $checkleafcategory = " select *  FROM  " . $tableprefix . "categories where parent_id= :catid";
                        $showproductadd = true;
                        $Count = $pdo->pdoQuery($checkleafcategory, array("catid" => $catid))->results();
                        if (count(($Count)) > 0) {
                            $showproductadd = false;
                        }
                        if (isset($catid) and $catid != "" and $showproductadd) {
                            ?>
                        <tr>
                            <td colspan="3">
                                <fieldset>
                                    <legend class='page_title2'><?php echo PRO_UNDER; ?></legend>
                                    <table width="100%" border=0 >
                                        <tr>
                                            <td colspan="2" class=listingtdbgcolor>
                                                <!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
                                                <table width="100%"  border="0" cellpadding="2" cellspacing="1" class="maintext" >                                                            
                                                    <tr class="whitebg" valign="top">
                                                        <td align="right" colspan="6" valign="top" >
                                                            <table width="100%" border=0  >
                                                                <tr>
                                                                    <td width="100%" align=right valign="baseline" class=""><?php echo SEARCH; ?>
                                                                        <select name="cmbSearchType" class="textarea">
                                                                            <option value="all"><?php echo ALL_PRODUCTS; ?></option>
                                                                            <option value="productname"  <?php
                                                                                if ($cmbSearchType == "productname" || $cmbSearchType == "") {
                                                                                    echo("selected");
                                                                                }
                                                                                        ?>><?php echo PRODUCT_NAME; ?></option>
                                                                            <option value="artistname"  <?php
                                                                                if ($cmbSearchType == "artistname") {
                                                                                    echo("selected");
                                                                                }
                                                                                        ?>><?php echo TEXT_SELLER_NAME; ?></option>
                                                                            <option value="dateadded"  <?php
                                                                                if ($cmbSearchType == "dateadded") {
                                                                                    echo("selected");
                                                                                }
                                                                                        ?>><?php echo DATE_ADDED.TEXT_DATE_FORMAT; ?></option>
                                                                        </select> &nbsp;
                                                                        <input type="text" name="txtSearch" id="txtSearch" size="20" maxlength="50" value="<?php echo(htmlentities($txtSearch)); ?>"  class="textarea">
                                                                        &nbsp;
                                                                        <a href="javascript:clickSearch();" class="search_button"><?php echo BTN_SEARCH; ?></a>&nbsp;
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                    <tr><td align="left" colspan="6"><?php echo("Listing $navigate[1] of $totalrows results."); ?></td></tr>
                                                    <tr><td><table border="0" width="100%" class='manage_table' cellpadding="0" cellspacing="0">
                                                                <tr class="form_header">
                                                                    <td>#</td>
                                                                    <th>&nbsp;</th>
                                                                    <th align='left'><?php echo PRODUCT_NAME; ?></th>
                                                                    <th align='left'><?php echo TEXT_PRODUCT_CODE; ?></th>
                                                                    <th align="left"><?php echo PRICE; ?></th>
                                                                    <th align='left'><?php echo REGISTERED.TEXT_DATE_FORMAT; ?></th>
                                                                    <th align='left'><?php echo SELLER; ?></th>
                                                                </tr>
                                                                    <?php
                                                                    $i = $begin + 1;
                                                                    foreach ($rs as $row) {
                                                                        $link = "<a href='editproduct.php?productid=" . $row["product_id"] . "' class='links'>";
                                                                        $check = "<input class='checkbox' type='checkbox' name='chkproducts[]' value='" . $row["product_id"] . "' class='smalllink'> ";
                                                                        ?>
                                                                <tr class="whitebg" valign=top>
                                                                    <td><?php echo (($page * $limit) + $i - $limit) ?></td>
                                                                    <td valign=top align='left'><?php echo $check; ?></td>
                                                                    <td valign=top align='left' style='word-break:break-all;' class=boxalternatecolor2><?php echo $link . stripslashes($row["product_name"]) . "</a>"; ?></td>
                                                                    <td valign=top align='left'><?php echo $link . $row["product_code"] . "</a>"; ?></td>
                                                                    <td valign=top align='left'> <?php echo $adminCurrency['currency_symbol']; ?> <?php echo $link . htmlentities(number_format($row["product_price"], 2, '.', '')) . "</a>"; ?></td>
                                                                    <td valign=top align='left'><?php echo $link . dateFormat($row["date_added"], "Y-m-d", "m/d/Y") . "</a>"; ?></td>
                                                                    <td valign=top align='left' class="boxalternatecolor"><?php echo $link . $row["artist_name"] . "</a>"; ?>&nbsp;</td>
                                                                </tr>
                                                                        <?php
                                                                        $i++;
                                                                    }
                                                                    ?>
                                                                <tr class="whitebg"><td align="center" colspan="6"><?php echo($navigate[2]); ?></td></tr>
                                                            </table></td></tr>
                                                        <?php if (isNotNull($check)) { ?>
                                                    <tr class="whitebg">
                                                        <td colspan="6" align="center"><input type="submit" class="button" name="btnDeleteSelected" value="<?php echo TEXT_DELETE_SELECTED; ?>" onClick="return confirmDelete();" ></td>
                                                    </tr>
                                                            <?php
                                                        }
                                                        ?>
                                                    <tr class="whitebg">
                                                        <td colspan="6">&nbsp;</td>
                                                    </tr>
                                                </table>
                                                <!-- products adding area -->
                                            </td>
                                        </tr>
                                        <script type="text/javascript" src="<?php echo SITE_URL ?>/ckeditor/ckeditor.js"></script>
                                            <?php
                                            $options_arr = getOptionsFromCategory($catid);
                                            $num_of_options = count($options_arr);
                                            $StrOptions = "";
                                            if ($num_of_options != "") {
                                                foreach ($options_arr AS $eachoption) {
                                                    $StrOptions .='<br><br><span class="category_option_label">' . $eachoption['option_name'] . '</span>';
                                                    $StrOptions .='<span class="category_option_field"><input type="text" name="option_' . $eachoption['option_id'] . '[]" value=""></span>';
                                                }
                                            }
                                            ?>
                                        <script type="text/javascript">

                                            window.onload = function()
                                            {
                                               var editor =  CKEDITOR.replace( 'editor1'
                                                , {
                                                filebrowserBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html',
                                                filebrowserImageBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Images',
                                                filebrowserFlashBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Flash',
                                                filebrowserUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                                                filebrowserImageUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                                                filebrowserFlashUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'
                                                });
                                                    CKFinder.setupCKEditor( editor, '<?php echo SITE_URL ?>/ckeditor/ckfinder/' );
                                            };
                                            //Santhosh thomas Alexander coded this
                                            //This is to do dynamic options add
                                            $(document).ready(function(){ 

                                                $("#add_more_options").click(function() {
                                                    var addVal = $("#add_value").val();
                                                    $("#add_value").val(parseInt(addVal)+1);
                                                    var block = '<tr class="option_block"><td><table width="100%" cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC"><tr><th><?php echo DEFAULT_OPT; ?></th><th><?php echo ADD_PRICE; ?> &nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th><th><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></th><th><?php echo REORDER_LEVEL; ?>&nbsp;</th></tr><tr><td><span class="default_setting_box"><input type="radio" name="default" id="default" onclick="setDefaultOption(this);"><input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value=""><?php echo $StrOptions ?><br></span></td><td><input type="text" name="additional_price[]"  onpaste="return false;" id="additional_price[]" value="" class="jqPrice jQNumeric"></td><td><input type="text" name="product_stock[]" id="product_stock[]" value="" class="clsProductStock jQNumeric"></td><td><input type="text" name="reorder_level[]" id="reorder_level[]" value="" class="jQNumeric"></td></tr><tr><th><?php echo BIG_IMG; ?>&nbsp;<span class="required">*</span></th><th><?php echo SMALL_IMG; ?>&nbsp;</th><th><?php echo DISCOUNT_PERC; ?></th><th><?php echo DISCOUNT_DESC; ?></th></tr><tr><td><input type="file" name="image_big[]" id="image_big[]" onchange="showBigImages(this.files,'+addVal+',this);" value=""><img src="" style="display:none" width="183" height="191" id="big_img_preview_'+addVal+'"></td> <td><input type="file" name="image_small[]" id="image_small[]" onchange="showSmallImages(this.files,'+addVal+',this);" value=""><img src="" style="display:none" width="183" height="191" id="small_img_preview_'+addVal+'"></td><td><input type="text" name="discount[]" id="discount[]" value="" class="jQNumeric"></td><td><input type="text" name="discount_description[]" id="discount_description[]" value=""></td></tr><tr class="canshipBlock"><th><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></th><th><?php echo LENGTH; ?> &nbsp;<span class="required">*</span></th><th><?php echo WIDTH; ?> &nbsp;<span class="required">*</span></th><th><?php echo HEIGHT; ?> &nbsp;<span class="required">*</span>  </th></tr><tr class="canshipBlock"><td><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="" class="jQNumeric"></td><td><input type="text" name="product_length[]" id="product_length[]" value="" class="jQNumeric"></td><td><input type="text" name="product_width[]" id="product_width[]" value="" class="jQNumeric"></td><td><input type="text" name="product_height[]" id="product_height[]" value="" class="jQNumeric">&nbsp;<img border="0" title="<?php echo TITLE_DELETE_OPTION; ?>" src="../images/btn_del.gif" alt="<?php echo TITLE_DELETE_OPTION; ?>" class="delete_option" onclick="javascript:delete_option(this);"></td></tr></table></td></tr>';  

                                                    $("#options_window").append(block);
                                                    $('.jqPrice').keyup(function(e){
                                                        var price = parseFloat($(this).val());         
                                                        var newVal = $(this).val().replace(/[^\d.]/, '');            
                                                        var number = (newVal.split('.'));
                                                        $(this).val(newVal);
                                                        if (typeof(number[1]) != "undefined"){
                                                            if (number[1].length > 2)
                                                            {               
                                                                $(this).val( price.toFixed(2));
                                                            }
                                                        }

                                                    });
                                                    checkDigitalProduct();
                                                });

                                            });
                                            function setDefaultOption(obj) {

                                                $(".default_option").val("");
                                                $(obj).parents(".default_setting_box").find(".default_option").val("1");


                                            }
                                            function delete_option(obj) {

                                                $(obj).parents(".option_block").hide("slow");
                                                $(obj).parents(".option_block").html("");
                                            }

                                        </script>
                                        <tr><td colspan="2" bgcolor="#FFFFFF">&nbsp;</td></tr>
                                        <tr>
                                            <td  colspan="2" bgcolor="#FFFFFF">
                                                <input type="hidden" name="sellerid" id="clsSeller" value="<?php echo $artistid;?>">
                                                 <input type="hidden" name="txtShippingDimension" id="clsShippingdimension" value="<?php echo $shipping_Dimension_Required;?>">

                                                <!-- ***************************************************************** -->
                                                <table cellpadding="2" class="bx_bg" cellspacing="2" width="100%">
                                                    <tr><td colspan="3" align="left" class="page_title2"><b><?php echo ADD_NEW_PRO; ?></b></tr>
                                                    <tr><td colspan="3"></tr>
                                                    <tr>
                                                        <td colspan="3" align="right"><span class="required">*</span><?php echo MANDATORY_FIELDS; ?></td>
                                                    </tr>
                                                    <tr><td colspan="3"></tr>
                                                    <tr><td align="right" width="33%"><?php echo PRODUCT_NAME; ?> &nbsp; <span class="required">*</span></td>
                                                        <td width="3%" align='left'></td>
                                                        <td width="64%" align='left'><input name="txtProductName" type="text" class="textarea" id="txtProductName" value="<?php echo $txtProductName; ?>" size="30" maxlength="100">
                                                            <span class="help"><a href="#" title="<?php echo PRODNAME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                        </td></tr>
                                                    <tr><td align="right" width="33%"><?php echo TEXT_PRODUCT_CODE; ?> &nbsp; </td>
                                                        <td width="3%" align='left'></td>
                                                        <td  align='left'><input name="txtProductCode"  type="text" class="textarea" id="txtProductCode" value="<?php echo $txtProductCode; ?>" size="20" maxlength="20">
                                                            <span class="help"><a href="#" title="<?php echo PRODID_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                        </td></tr>
                                                    <tr><td align="right" ><?php echo SELLER; ?>&nbsp;<span class="required">*</span></td>
                                                        <td ></td>
                                                        <td align='left'><?php echo makeDropDownList("ddlArtist", $artistlist, $ddlArtist, false, 'textarea', $properties, $behaviors) ?>
                                                            <span class="help"><a href="#" title="<?php echo PRODSELLER_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                        </td></tr>
                                                    <tr><td align="right" valign="top"><?php echo PRODUCT_DESCRIPTION_TEXT; ?>&nbsp;<span class="required">*</span></td>
                                                        <td valign="top" ></td>
                                                        <td align='left'>
                                                            <textarea id="editor1" name="txtDescription"><?php echo stripslashes($_POST['txtDescription']); ?></textarea>
                                                        </td></tr>
                                                    <tr><td align="right" ><?php echo PRICE; ?>&nbsp;<span class="required">*</span></td>
                                                        <td ></td>
                                                        <td align='left'><input name="txtPrice"  type="text"  onpaste="return false;" class="textarea jQNumeric" id="txtPrice" value="<?php echo htmlentities($txtPrice); ?>" size="30" maxlength="100">
                                                            &nbsp;<b><?php echo $adminCurrency['currency_code']; ?></b>
                                                            <span class="help"><a href="#" title="<?php echo PROD_PRICE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                        </td>
                                                    </tr>
                                                    <!----New fields ---->
                                                     <tr><td align="right" ><?php echo TEXT_SEARCH_TAGS; ?>&nbsp;</td>
                                                            <td >:</td>
                                                            <td align='left'><textarea name="txtProductTags" cols="50" class="textarea2" rows="10" id="txtProductTags"><?php echo htmlentities($txtSearchTags);?></textarea>
                                                                 &nbsp;
                                                                <span class="help"><a href="#" title="<?php echo PROD_TAGS_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                            </td>
                                                        </tr>                                                                
                                                        <tr id="allow_free_shipping">
                                                            <td align="right"><?php echo TEXT_ALLOW_FREE_SHIPPING; ?>&nbsp;</td>
                                                            <td>:</td>
                                                            <td align='left'><input type="checkbox" id="chkAllowFreeShipping"  name="chkAllowFreeShipping" value="Y" <?php echo $chkAllowFreeShipping; ?>>
                                                                <span class="help"><a href="#" title="<?php echo FREE_SHIPPING_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                            </td>
                                                        </tr>
                                                        <!--<?php if(getSettingsValue('enable_subscription_products')=='Y') { ?>
                                                        <tr>
                                                            <td align="right"><?php echo TEXT_ALLOW_SUBSCRIPTION; ?>&nbsp;</td>
                                                            <td>:</td>
                                                            <td align='left'><input type="checkbox" id="chkAllowSubscription"  name="chkAllowSubscription" value="Y" <?php echo $chkAllowSubscription; ?>>
                                                                <span class="help"><a href="#" title="<?php echo ALLOW_SUBSCRIPTION_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                            </td>
                                                        </tr>
                                                        <tr id="subscription_mode" style="display: none;">
                                                            <td align="right"><?php echo TEXT_SUBSCRIPTION_MODE; ?>&nbsp;</td>
                                                            <td>:</td>
                                                            <td align='left'>
                                                                <input type="radio" name="rdSubscriptionMode" value="Daily" <?php if ($rdSubscriptionMode    == "Daily")   {   echo "checked"; }?>><?php echo TEXT_DAILY;?>                                   
                                                                <input type="radio" name="rdSubscriptionMode" value="Monthly" <?php if ($rdSubscriptionMode  == "Monthly") {   echo "checked"; }?>><?php echo TEXT_MONTHLY;?>
                                                                <input type="radio" name="rdSubscriptionMode" value="Yearly" <?php if ($rdSubscriptionMode   == "Yearly")  {   echo "checked"; }?>><?php echo TEXT_YEARLY;?>
                                                                <span class="help"><a href="#" title="<?php echo SUBSCRIPTION_MODE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                            </td>
                                                        </tr>
                                                        <?php } ?>-->
                                                        <?php if(getSettingsValue('enable_product_scheduled_publishing')=='Y') {?>
                                                        <tr>
                                                            <td align="right"><?php echo TEXT_PUBLISH_STATUS; ?>&nbsp;</td>
                                                            <td>:</td>
                                                            <td align='left'>
                                                                <span id="jQPublishY" > 
                                                                <input  id="jQPublish_Y" type="radio" name="rdPublishStatus" class="rdPublishStatus" value="Y" <?php if ($rdPublishStatus  == "Y") {   echo "checked"; } elseif($rdPublishStatus==NULL){echo "checked";}?>><?php echo TEXT_PUBLISH_NOW;?>  
                                                                </span>
                                                                <span>
                                                                <input  id="jQPublish_N" type="radio" name="rdPublishStatus" class="rdPublishStatus" value="N" <?php if ($rdPublishStatus  == "N") {   echo "checked"; }?>><?php echo TEXT_PUBLISH_LATER;?>
                                                                </span>
                                                                <span class="help"><a href="#" title="<?php echo PUBLISH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                            </td>
                                                        </tr>
                                                        
                                                        <tr id="publish_time" style="display: none;">
                                                            <td align="right"><?php echo TEXT_PUBLISH_DATE; ?>&nbsp;</td>
                                                            <td>:</td>
                                                            <td align='left'><table><tr><td><input type="text" id="publishdate" name="publishdate"></td>
                                                                        <td><?php echo TEXT_PUBLISH_TIME; ?></td>
                                                                        <td><?php echo timepicker();?></td>
                                                                        <!--<td><input type="text" id="publishtime" class="tme" name="publishtime" style="width: 54px;"></td>-->
                                                                        <td><span class="help"><a href="#" title="<?php echo TEXT_PUBLISH_TIME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></td>
                                                                    </tr>                                                                        
                                                                </table>                                                                        
                                                            </td>
                                                        </tr>                                                                                                                                
                                                      <?php }?>
                                                    <!----New fields ---->
                                                        <tr>
                                                        <td align="right"><?php echo DIGITAL_PRODUCT; ?>&nbsp;</td>
                                                        <td></td>
                                                        <td align='left'><input type="checkbox" id="txtDigitalProduct"  name="txtDigitalProduct" value="Y" onClick="checkDigitalProduct();" <?php echo $chkDigitalProduct; ?>>
                                                            <span class="help"><a href="#" title="<?php echo DWNLD_PROD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td colspan="3">
                                                            <div id="digitalProductBlock" style="display:<?php echo $digitalBlock; ?>">
                                                                <table cellpadding="2" cellspacing="2" width="100%" border="0">
                                                                    <tr>
                                                                        <td width="39%" align="right"><?php echo UPLOAD_DIGPRO; ?>&nbsp;<span class="required">*</span></td>
                                                                        <td width="3%" align="left"></td>
                                                                        <td width="21%" align='left'><input type="file" class="textarea" name="txtProductZip" id="txtProductZip"></td>
                                                                        <td width="37%" class="text_information" align="left"> <?php echo MAX_ALLOWED_SIZE; ?>   <b><?php echo $maximagesizestringinPHP; ?></b>
                                                                           
                                                                            
                                                                        </td>
                                                                    </tr>

                                                                    <tr><td colspan="4" class="text_information" ><?php echo ALLOWED_DIGITAL_FORMATS;?> :  <?php echo implode(",",$digital_product_types);?> &nbsp; <span class="help"><a href="#" title="<?php echo FILE_EXTN_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></td></tr>
                                                                    <tr>
                                                                        <td width="39%" align="right"><?php echo DWNLD_TRY;?>&nbsp;</td>
                                                                        <td width="3%" align="left"></td>
                                                                        <td colspan="2" align="left">
                                                                            <select name="txtDownloadTry" class="textarea" id="txtDownloadTry">
                                                                                    <?php
                                                                                    for ($i = 1; $i <= 10; $i++) {
                                                                                        ?>
                                                                                <option value="<?php echo $i ?>"><?php echo $i ?></option>
                                                                                        <?php
                                                                                    }
                                                                                    ?>
                                                                            </select>&nbsp;Time(s)
                                                                            <span class="help"><a href="#" title="<?php echo NO_DWNLD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td width="39%" align="right"><?php echo D_EXPIRY; ?>&nbsp;</td>
                                                                        <td width="3%" align="left"></td>
                                                                        <td colspan="2" align="left">
                                                                            <select name="txtDownloadExpiry" class="textarea" id="txtDownloadExpiry">
                                                                                    <?php
                                                                                    for ($i = 1; $i <= 10; $i++) {
                                                                                        ?>
                                                                                <option value="<?php echo $i ?>"><?php echo $i ?></option>
                                                                                        <?php
                                                                                    }
                                                                                    ?>
                                                                            </select>&nbsp;Day(s)
                                                                            <span class="help"><a href="#" title="<?php echo LINK_EXPIRE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </td>
                                                    </tr>


                                                    <tr>
                                                        
                                                        <td colspan="3" width="100%">
                                                            <table cellpadding="2" cellspacing="2" border="0" id="options_window" width="100%">
                                                                <tr>
                                                                    <td>
                                                                        <table cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC" width="100%">
                                                                            <tr>
                                                                                <th><?php echo DEFAULT_OPT; ?>
                                                                                    <span class="help"><a href="#" title="<?php echo MUL_PROD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                                <th><?php echo ADD_PRICE; ?>&nbsp;(<?php echo $adminCurrency['currency_code']; ?>)
                                                                                    <span class="help"><a href="#" title="<?php echo EXTRA_PRICE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                                <th><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span>
                                                                                    <span class="help"><a href="#" title="<?php echo AVAIL_STK_TOOLTIP; z?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                                <th><?php echo REORDER_LEVEL; ?>&nbsp;
                                                                                    <span class="help"><a href="#" title="<?php echo STK_LEVEL_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                            </tr>
                                                                                <?php
                                                                                $dchecked = "";
                                                                                $default = 1;
                                                                                if (count($_POST['default_option']) == 0) {
                                                                                    $dchecked = "checked";
                                                                                }
                                                                                if ($_POST['default_option'][0] == "1") {
                                                                                    $dchecked = "checked";
                                                                                    $default = $_POST['default_option'][0];
                                                                                }
                                                                                ?>
                                                                            <tr>
                                                                                <td align="center">  <input type="radio" name="default" id="default" onclick="setDefaultOption(this);" <?php echo $dchecked; ?>>
                                                                                        <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>"></td>
                                                                                <td align="center"><input type="text" name="additional_price[]"  onpaste="return false;" id="additional_price[]" value="<?php echo $_POST['additional_price'][0]; ?>" class="jqPrice jQNumeric">

                                                                                </td>
                                                                                <td align="center">
                                                                                    <input type="text" name="product_stock[]" class="clsProductStock jQNumeric" id="product_stock[]" value="<?php echo $_POST['product_stock'][0]; ?>">

                                                                                </td>
                                                                                <td align="center">
                                                                                    <input type="text"  class="jQNumeric" name="reorder_level[]" id="reorder_level[]" value="<?php echo $_POST['reorder_level'][0]; ?>">

                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td align="center">
                                                                                    <span class="default_setting_box">
                                                                                      
                                                                                     <?php
                                                                                            $options_arr = getOptionsFromCategory($catid);
                                                                                            $num_of_options = count($options_arr);
                                                                                            if ($num_of_options != "") {
                                                                                                foreach ($options_arr AS $eachoption) {
                                                                                                    echo "<br><br><span class='category_option_label'>" . $eachoption['option_name'] . "</span>";
                                                                                                    ?>
                                                                                        <span class="category_option_field"><input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $_POST['option_' . $eachoption['option_id']][0]; ?>"></span>
                                                                                                    <?php
                                                                                                }
                                                                                            }
                                                                                            ?>
                                                                                    </span>

                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                 <th><?php echo BIG_IMG; ?>&nbsp;<span class="required">*</span>
                                                                                    <span class="help"><a href="#" title="<?php echo IMG_DISP_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                 </th>
                                                                                <th><?php echo SMALL_IMG; ?>&nbsp;
                                                                                    <span class="help"><a href="#" title="<?php echo IMGLIST_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                               
                                                                                <th><?php echo DISCOUNT; ?> (%)
                                                                                    <span class="help"><a href="#" title="<?php echo DISC_PERC_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                                <th><?php echo DISCOUNT_DESC; ?>
                                                                                    <span class="help"><a href="#" title="<?php echo EX_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                            </tr>
                                                                            <tr>
                                                                                <td valign="top" align="center"><input type="file" name="image_big[]" id="image_big[]" onchange="showMyImage(this.files,'big_img_preview','bigimagepreview',this)" value="<?php echo $_POST['image_big'][0]; ?>">
                                                                                <img style="display:none" src="" id="big_img_preview" border="0" width="183" height="191">
                                                                                </td>
                                                                                <td valign="top" align="center"><input type="file" name="image_small[]" id="image_small[]" value="<?php echo $_POST['image_small'][0]; ?>" onchange="showMyImage(this.files,'small_img_preview','smallimagepreview',this)">
                                                                                <img style="display:none" src="" id="small_img_preview" border="0" width="183" height="191">
                                                                                </td>
                                                                                <td valign="top" align="center"><input type="text" name="discount[]" id="discount[]" value="<?php echo $_POST['discount'][0]; ?>"></td>
                                                                                <td valign="top" align="center"><input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo $_POST['discount_description'][0]; ?>"></td>
                                                                            </tr>
                                                                            <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                                <th><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span>
                                                                                    <span class="help"><a href="#" title="<?php echo PWEIGHT_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                                <th><?php echo LENGTH; ?> <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                                                                    <span class="help"><a href="#" title="<?php echo PLEN_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                                <th><?php echo WIDTH; ?> <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                                                                    <span class="help"><a href="#" title="<?php echo PWIDTH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                                <th><?php echo HEIGHT; ?> <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                                                                    <span class="help"><a href="#" title="<?php echo PHEIGHT_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                </th>
                                                                            </tr>
                                                                            <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                                <td align="center"><input type="text" class="clsShippingWeight jQNumeric" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $_POST['product_shipping_weight'][0]; ?>"></td>
                                                                                <td align="center"><input type="text" class="clsProductlength jQNumeric"  name="product_length[]" id="product_length[]" value="<?php echo $_POST['product_length'][0]; ?>"></td>
                                                                                <td align="center"><input type="text" class="clsProductwidth jQNumeric" name="product_width[]" id="product_width[]" value="<?php echo $_POST['product_width'][0]; ?>"></td>
                                                                                <td align="center"><input type="text" class="clsProductheight jQNumeric" name="product_height[]" id="product_height[]" value="<?php echo $_POST['product_height'][0]; ?>"></td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                </tr>




                                                                    <?php
                                                                    for ($i = 1; $i < $options_count; $i++) {
                                                                        ?>
                                                                <tr class="option_block">
                                                                    <td>
                                                                        <table cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC" width="100%">
                                                                            <tr>
                                                                                <th><?php echo DEFAULT_OPT; ?></th>
                                                                                <th><?php echo ADD_PRICE; ?>&nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th>
                                                                                <th><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></th>
                                                                                <th><?php echo REORDER_LEVEL; ?>&nbsp;</th>
                                                                            </tr>
                                                                                    <?php
                                                                                    $dchecked = "";
                                                                                    if ($_POST['default_option'][$i] == "1") {
                                                                                        $dchecked = "checked";
                                                                                    }
                                                                                    ?>
                                                                            <tr>
                                                                                <td align="center">
                                                                                    <span class="default_setting_box">
                                                                                        <input type="radio" name="default" id="default" onclick="setDefaultOption(this);" <?php echo $dchecked ?>>
                                                                                        <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $_POST['default_option'][$i] ?>">
                                                                                                <?php
                                                                                                $options_arr = getOptionsFromCategory($catid);
                                                                                                $num_of_options = count($options_arr);
                                                                                                if ($num_of_options != "") {
                                                                                                    foreach ($options_arr AS $eachoption) {
                                                                                                        echo "<br><span class='category_option_label'>" . $eachoption['option_name'] ."</span>";
                                                                                                        ?>
                                                                                        <span class='category_option_field'><input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $_POST['option_' . $eachoption['option_id']][$i]; ?>"></span>
                                                                                                        <?php
                                                                                                    }
                                                                                                }
                                                                                                ?>
                                                                                    </span>
                                                                                </td>
                                                                                <td align="center"><input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $_POST['additional_price'][$i] ?>" class="jqPrice jQNumeric"></td>
                                                                                <td align="center"><input type="text" class="clsProductStock jQNumeric" name="product_stock[]" id="product_stock[]" value="<?php echo $_POST['product_stock'][$i] ?>"></td>
                                                                                <td align="center"><input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $_POST['reorder_level'][$i] ?>" class="jQNumeric"></td></tr>
                                                                                <tr>
                                                                                    <th><?php echo SMALL_IMG?>&nbsp;<span class="required">*</span></th>
                                                                                    <th><?php echo BIG_IMG?>&nbsp;<span class="required">*</span></th>
                                                                                    <th><?php echo DISCOUNT?> (%)</th>
                                                                                    <th><?php echo DISCOUNT_DESC?></th>
                                                                                </tr>

                                                                            <tr>
                                                                                <td align="center"><input type="file" name="image_big[]" id="image_big[]"  onchange="showBigImages(this.files,'<?php echo $i?>',this)" value="<?php echo $_POST['image_big'][$i] ?>">
                                                                                <img style="display:none" src="" id="big_img_preview_<?php echo $i?>" border="0" width="183" height="191"></td>
                                                                                <td align="center"><input type="file" name="image_small[]" id="image_small[]"  onchange="showSmallImages(this.files,'<?php echo $i?>',this)" value="<?php echo $_POST['image_small'][$i] ?>">
                                                                                <img style="display:none" src="" id="small_img_preview_<?php echo $i?>" border="0" width="183" height="191">
                                                                                </td>
                                                                                
                                                                                <td align="center"><input type="text" name="discount[]" id="discount[]" value="<?php echo $_POST['discount'][$i] ?>"></td>
                                                                                <td align="center"><input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo $_POST['discount_description'][$i] ?>"></td>
                                                                            </tr>
                                                                            <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                                <th><?php echo SW_LBS; ?> &nbsp;<span class="required">*</span></th>
                                                                                <th><?php echo LENGTH; ?> <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?> </th>
                                                                                <th><?php echo WIDTH; ?> <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?> </th>
                                                                                <th>Height <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?> </th>
                                                                            </tr>
                                                                            <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                                <td align="center"><input type="text" class="clsShippingWeight jQNumeric" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $_POST['product_shipping_weight'][$i] ?>"></td>
                                                                                <td align="center"><input type="text" class="clsProductlength jQNumeric" name="product_length[]" id="product_length[]" value="<?php echo $_POST['product_length'][$i] ?>"></td>
                                                                                <td align="center"><input type="text" class="clsProductwidth jQNumeric" name="product_width[]" id="product_width[]" value="<?php echo $_POST['product_width'][$i] ?>"></td>
                                                                                <td align="center"><input type="text" class="clsProductheight jQNumeric" name="product_height[]" id="product_height[]" value="<?php echo $_POST['product_height'][$i] ?>">&nbsp;<img border="0" title="Delete Option" src="../images/btn_del.gif" alt="Delete Option" class="delete_option" onclick="javascript:delete_option(this);"></td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                                        <?php
                                                                    }
                                                                    ?>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                        <?php
                                                        $options_arr = getOptionsFromCategory($catid);
                                                        $num_of_options = count($options_arr);
                                                        if ($num_of_options >= 1) {
                                                            ?>
                                                    <tr>
                                                        <td colspan="3">
                                                            <input type="button" name="add_more_options" value="<?php echo ADD_OPTIONS;?>" id="add_more_options"/>
                                                            <input type="hidden" name="add_value" id="add_value" value="0">
                                                        </td>
                                                    </tr>
                                                            <?php
                                                        }
                                                        ?>
                                                    <tr>
                                                        <td colspan="3">
                                                            <div id="canshipBlock" class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                <table cellpadding="2" cellspacing="2" border="0" width="100%">
                                                                    <tr>
                                                                        <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo TXT_SMALL_IMG; ?> - 400  X 300 </strong></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo TXT_BIG_IMG; ?> - 500 X 350 </strong></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo TXT_CP; ?> </strong></td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><?php echo MORE_IMG; ?> (jpg/gif/png) </td>
                                                        <td colspan="2">
                                                                <?php
                                                                $moreImagesql = "SELECT nproduct_image_id, nimage_productid,
                vimage_name, vimage_description, vproduct_image_delete_status
           FROM " . $tableprefix . "product_view_images
          WHERE nimage_productid= :productid";

                                                                $result = $pdo->pdoQuery($moreImagesql, array("productid" => $productid))->results();
                                                                if (count($result) != 0) {

                                                                }

                                                                $moreImageMaxLImit = getSettingsValue('more_image_limit');
                                                                if ($moreImageMaxLImit > 0) {
                                                                    for ($iCount = 0; $iCount < $moreImageMaxLImit; $iCount++) {
                                                                        ?>
                                                            <div class="jqMoreImageContainer" style="padding:5px;border:1px solid #D3D1D1;margin:10px 1px 10px 1px;float:left;width:200px;">
                                                                <div style="width:180px;float:left;margin-bottom: 4px;"><b><?php echo MORE_IMAGE; ?> <?php echo $newCount = $iCount + 1; ?></b></div>
                                                                <input type="file" name="productMoreImage[]"  onchange="showMyImage(this.files,'more_img_preview_<?php echo $newCount?>','<?php echo $newCount;?>',this)"/>
                                                                <img style="display:none" src="" id="more_img_preview_<?php echo $newCount?>" border="0" width="183" height="191">
                                                            </div>
                                                                        <?php
                                                                    }
                                                                }
                                                                ?>

                                                        </td>
                                                    </tr>

                                                    <tr><td colspan="3">&nbsp;</td></tr>
                                                    <tr><td colspan="3" align="center"><input type="submit" value="<?php echo BTN_ADD_PROD; ?>" name="btnAddProduct" class="button" onClick="return validateProductForm();"></td></tr>
                                                    <tr>
                                                        <td colspan="3">
                                                            <div align='left' class='linksCopy2'></div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                            <?php } else {
                            ?>
                        <table>
                            <tr>
                                <td colspan="3" class=''><?php echo TXT_SUBCAT; ?></td>
                            </tr>
                        </table>
                            <?php }
                        ?>
                        <tr><td colspan="3">&nbsp;</td></tr>
                    </table>
                </form>
            </div>
            <!--content area end-->
        </div>
        <div align="left" class="clear_float"><img src="<?php echo $imagefolder; ?>/clear.gif" alt="" width="1" height="1" /></div>
        <!--main body end -->
    </div>
    <?php
    include "../includes/footer.php";
    ?>
    <script type="text/javascript">
        var msgProductName = "<?php echo MSG_PRODUCT_NAME; ?>";
        var msgProductPrice = "<?php echo MSG_PRODUCT_PRICE; ?>";
    </script>
    <script src="../js/product-check.js"  type="text/javascript"></script>