<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Santhosh thomas Alexander<santhosh.thomas@armiasystems.com> |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com ï¿½ 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php 
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include('../includes/class.upload.php');
include_once('../includes/S3.php');
/* * **** Including resize library ****** */
include_once('../classes/cls_utils.php');
include_once('../classes/cls_store.php');
include_once('../classes/cls_products.php');

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

$cdn_enabled = "N";
if (ENABLE_AMAZON_S3_IMAGES == "Y") {
    $cdn_enabled = "Y";
}

if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
    $adminname = $_SESSION["sess_adminname"];
} else {
    header("Location:login.php");
    exit;
}

$action = isset($_GET['action']) ? trim($_GET['action']) : '';
switch ($action) {
    case "delmoreimage":
        $id = isset($_POST['id']) ? trim($_POST['id']) : '';
        $image = isset($_POST['image']) ? trim($_POST['image']) : '';
       
        $pdo->delete($tableprefix."product_view_images",array("nproduct_image_id"=>$id))->affectedRows();
        deleteCDNImagesMore($image);
        if (is_file("../products" . $image) && file_exists("../products" . $image)) {
            @unlink("../products" . $image);
        }
        echo json_encode(array('success' => MSG_MORE_IMAGE_DELETED_SUCCESSFULLY));
        exit;
        break;
}

$maximagesizestringinPHP = ini_get("upload_max_filesize");

$maximagesizeinPHP = $maximagesizestringinPHP * (1024 * 1024);



if (isset($_GET["productid"]) and $_GET["productid"] != "") {
    $productid = $_GET["productid"];
} else if (isset($_POST["productid"]) and $_POST["productid"] != "") {
    $productid = $_POST["productid"];
} else {
    header("Location:catalog.php");
    exit;
}

$shipping_product_display = "";
$txtProductName = $_POST["txtProductName"];
$txtProductCode = $_POST["txtProductCode"];
$txtDescription = $_POST["txtDescription"];
$txtPrice = $_POST["txtPrice"];
$ddlArtist = $_POST["ddlArtist"];
$ddlCategory = $_POST["txtCategory"];
$txtSearchTags = $_POST["txtProductTags"];
(isset($_POST['chkAllowFreeShipping'])) ? $chkAllowFreeShipping = $_POST['chkAllowFreeShipping'] : $chkAllowFreeShipping = 'N';
(isset($_POST['chkAllowSubscription'])) ? $chkAllowSubscription = $_POST['chkAllowSubscription'] : $chkAllowSubscription = 'N';
$rdSubscriptionMode = $_POST["rdSubscriptionMode"];
$rdPublishStatus = $_POST["rdPublishStatus"];
if ($rdPublishStatus == "N") {
    //published time in 24_hour_format
    $selected_time = ($_POST['publishtime'] != '') ? $_POST['publishtime'] : '12:00am';
    $formatteDate = dateFormat($_POST['publishdate'], "m-d-Y", "Y-m-d");
    $publishDate = date("Y-m-d H:i:s", strtotime($formatteDate . $selected_time));
} else {
    $publishDate = "0000-00-00 00:00:00";
}

if (getSettingsValue('enable_product_scheduled_publishing') == 'N') {
    $rdPublishStatus = 'Y';
}

$prodimagedir = "../products/";
(isset($_POST['txtDigitalProduct'])) ? $txtDigitalProduct = $_POST['txtDigitalProduct'] : $txtDigitalProduct = 'N';

$sql = "SELECT * FROM " . $tableprefix . "settings ";
$result = $pdo->pdoQuery($sql)->results();
if (count($result) > 0) {
    $row = ($result[0]);
    $chkcanship = $row["enable_canadapost"];
}
$sql_digital = "SELECT * FROM " . $tableprefix . "products WHERE product_id= :productid and product_artist_id = :artistid  ";
$result_digital = $pdo->pdoQuery($sql_digital, array("productid" => $productid, "artistid" => $artistid))->results();
if (count($result_digital) != 0) {
    $rr = ($result_digital[0]);
    $txtDigitalproduct = $rr['vdigital_product'];
}
if ($txtDigitalproduct == "Y") {
    $canshipblock = "none";
} else {
    $canshipblock = "";
}
if (isset($_POST["btnSaveChanges"])) {
    $message = "";

    if (!isNotNull($txtProductName)) {
        $message .= PRO_NAME_EMPTY . "<br>";
    } else {
        $qry = "SELECT  product_name FROM  " . $tableprefix . "products WHERE product_name= :txtProductName
		and product_artist_id= :ddlArtist and product_category = :ddlCategory and product_id <> :productid  ";
        $Count = $pdo->pdoQuery($qry, array("txtProductName" => $txtProductName, "ddlArtist" => $ddlArtist, "ddlCategory" => $ddlCategory, "productid" => $productid))->results();
        if (count(($Count)) > 0) {
            $message .= PRO_WITH_SAME_NAME . "<br>";
        }
    }
    if ($txtDescription == '') {
        $message .= PRO_DESC_EMPTY . "<br>";
    }
    if (!isNotNull($txtProductCode)) {
        //$message .= "* Product Code cannot be empty! <br>";
    } else {
        $qry = "SELECT  product_code FROM  " . $tableprefix . "products WHERE product_code= :txtProductCode
		 and product_artist_id= :ddlArtist and product_category = :ddlCategory and product_id <> :productid  ";
        $Count = $pdo->pdoQuery($qry, array("txtProductCode" => $txtProductCode, "ddlArtist" => $ddlArtist, "ddlCategory" => $ddlCategory, "productid" => $productid))->results();
        if (count(($Count)) > 0) {
            $message .= PRO_WITH_SAME_CODE . "<br>";
        }
    }

    if (!isNotNull($ddlArtist)) {
        $message .= SELLER_EMPTY . "<br>";
    }
    $txtPrice = doubleval($txtPrice);
    if ($txtPrice <= 0 || !is_numeric($txtPrice)) {
        $message .= PRO_PRICE_EMPTY . "<br>";
    } else {
        if ($txtPrice <= 0) {
            $message .= PRO_PRICE_POSITIVE . "<br>";
        }
    }

    if ($txtDigitalProduct != "Y") {
        if ($txtShippingWeight != '') {
            if (!is_numeric($txtShippingWeight) || $txtShippingWeight == 0) {
                $message .= ENTER_VALID_PRO_SHPNG_WEIGHT . "<br>";
            }
        }
    }


    /* ----Digital Product Block Starts------- */

    if (isNotNull($_FILES['txtProductZip']['name'])) {
        $uploadfile = ReplaceArrayImage($_FILES['txtProductZip']['name']);
        //$types = array('gif','jpg','png','zip', 'pdf', 'rar', 'psd', 'opf', 'azw', 'lit', 'pdb', 'pkg', 'mp3', 'mpeg', 'mp4', 'avi', 'mpg', 'wma');
        preg_match('/\.([a-zA-Z0-9]+?)$/', $uploadfile, $matches);
        if (!in_array(strtolower($matches[1]), $digital_product_types)) { // check file format is valid or not
            $message .= INVALID_FILE_FORMAT . "<br>";
        } // end format check
    }

    if (!in_array('1', $_POST['default_option'])) {
        $message .= SEL_DEFAULT_OPTION . "<br>";
    }

    $options_count = count($_POST['additional_price']);
    for ($i = 0; $i < $options_count; $i++) {
        $product_option_id = $_POST['product_option_id'][$i];
        $default_option = $_POST['default_option'][$i];
        $additional_price = $_POST['additional_price'][$i];
        $product_stock = $_POST['product_stock'][$i];
        $reorder_level = $_POST['reorder_level'][$i];
        $product_shipping_weight = $_POST['product_shipping_weight'][$i];

        $discount = $_POST['discount'][$i];
        $discount_description = $_POST['discount_description'][$i];
        $product_length = $_POST['product_length'][$i];
        $product_width = $_POST['product_width'][$i];
        $product_height = $_POST['product_height'][$i];

        $prodimagedir = "../products/";

        $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
        $picsmallorgname = $_FILES['image_small']['name'][$i];
        $picsmalltempname = $_FILES['image_small']['tmp_name'][$i];
        $picsmalltype = $_FILES['image_small']['type'][$i];

        $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
        $picbigtype = $_FILES['image_big']['type'][$i];
        $picbigorgname = $_FILES['image_big']['name'][$i];
        $picbigtempname = $_FILES['image_big']['tmp_name'][$i];

        if ($picbigname != "") {
            $final_image_big = "productlarge_" . $i . time() . $picbigname;
        } else {
            $final_image_big = "";
        }

        if ($picsmallname != "") {
            $final_image_small = "productsmall_" . $i . time() . $picsmallname;
        } else {
            $final_image_small = "";
        }

        $picsmalldest = $prodimagedir . $final_image_small;
        $picbigdest = $prodimagedir . $final_image_big;

        $picsmallname = $final_image_small;
        $picbigname = $final_image_big;

        if (!is_readable($prodimagedir) || !is_writable($prodimagedir)) {
            $error = true;
            $message .= CHANGE_PERMISSION . "<br>";
        }

        if ($picsmalltype != "") {
            if (!isValidWebImageType($picsmalltype, $picsmallorgname, $picsmalltempname)) {
                $message .= SMALL_PICTURE . " " . $i . "<br>";
                $error = true;
            } else {
                if (file_exists($picsmalldest)) {
                    $message .= SMALL_PIC_EXISTS . " " . $i . "<br>";
                    $error = true;
                }
            }
        }
        if ($picbigtype != "") {
            if (!isValidWebImageType($picbigtype, $picbigorgname, $picbigtempname)) {
                $message .= BIG_PICTURE . " " . $i . "<br>";
                $error = true;
            } else {
                if (file_exists($picbigdest)) {
                    $message .= BIG_PIC_EXISTS . " " . $i . "<br>";
                    $error = true;
                }
            }
        }


        $product_stock = doubleval($product_stock);
        if ($product_stock == "") {
            $message .= PRO_STOCK_EMPTY . " " . ($i + 1) . " ! <br>";
        }
        if ($product_stock < 0 || !is_numeric($product_stock)) {
            if ($product_stock < 0) {
                $message .= PRO_STOCK_POSITIVE . " " . ($i + 1) . " ! <br>";
            }
        }

        if ($additional_price != "") {
            if ($additional_price < 0 || !is_numeric($additional_price)) {
                $message .= ADDITIONAL_PRICE_POSITIVE . " " . ($i + 1) . "! <br>";
            }
        }

        if ($discount != "") {
            if ($discount >= 100) {
                $message .= DISCOUNT_VALIDATION . " " . ($i + 1) . "! <br>";
            }
        }


        if ($chkcanship == "Y" && $txtDigitalProduct != "Y") {
            if ($product_length == "") {
                $message .= PRO_LEN_EMPTY . " " . ($i + 1) . " !<br>";
            }
            if ($product_width == "") {
                $message .= PRO_WIDTH_EMPTY . " " . ($i + 1) . " !<br>";
            }
            if ($product_height == "") {
                $message .= PRO_HEIGHT_EMPTY . " " . ($i + 1) . " !<br>";
            }
            if ($txtDigitalProduct != "Y") {
                if ($product_shipping_weight == "") {
                    $message .= PRO_SHIPPING_EMPTY . " " . ($i + 1) . "!<br>";
                }
            }
        }

        if ($product_length != '') {
            if (!is_numeric($product_length)) {
                $message .= ENTER_VALID_PRO_LEN . " " . ($i + 1) . "! <br>";
            }
        }

        if ($product_width != '') {
            if (!is_numeric($product_width)) {
                $message .= ENTER_VALID_PRO_WID . " " . ($i + 1) . "! <br>";
            }
        }

        if ($product_height != '') {
            if (!is_numeric($product_height)) {
                $message .= ENTER_VALID_PRO_HEIGHT . " " . ($i + 1) . "! <br>";
            }
        }

        if ($txtDigitalProduct != "Y") {
            if (!is_numeric($product_shipping_weight) || $product_shipping_weight == 0) {
                $message .= ENTER_VALID_PRO_SHPNG_WEIGHT . " " . ($i + 1) . "! <br>";
            }
        }
        $product_shipping_weight = doubleval($product_shipping_weight);

        if ($product_shipping_weight < 0) {
            $message .= PRO_WEIGHT_POSITIVE . " " . ($i + 1) . "! <br>";
        }
        $reorder_level = doubleval($reorder_level);
        if ($reorder_level != "") {
            if ($reorder_level < 0 || !is_numeric($reorder_level)) {
                $message .= PRO_LEVEL_POSITIVE . " " . ($i + 1) . "! <br>";
            } else if ($reorder_level > $product_stock) {
                $message .= PRO_LEVEL_LESS . " " . ($i + 1) . "! <br>";
            }
        }
    }
    /*
     * More Images Validation
     */

    if (isset($_FILES['productMoreImage']['name']) && !empty($_FILES['productMoreImage']['name'])) {
        foreach ($_FILES['productMoreImage']['name'] as $key => $moreImage) {
            if ($moreImage != '') {
                $type = $_FILES['productMoreImage']['type'][$key];
                if (!isValidWebImageType($type)) {
                    $message .= INVALID_MORE_IMG . " " . ($key + 1) . "<br>";
                }
            }
        }
    }

    $moreFiles = array();
    foreach ($_FILES['productMoreImage'] as $k => $l) {
        foreach ($l as $j => $v) {
            if (!array_key_exists($j, $moreFiles)) {
                $moreFiles[$j] = array();
            }
            $moreFiles[$j][$k] = $v;
        }
    }



//default published if settings disabled 

    if (getSettingsValue('enable_product_scheduled_publishing') == 'N') {
        $rdPublishStatus = 'Y';
    }
// get the seller information and set vacation mode status in product 
    $sellerCartObj = Store::get_seller_account_info($ddlArtist);
//echopre($sellerCartObj);
    if ($sellerCartObj->status == SUCCESS) {
        $sellerCartObjVal = $sellerCartObj->data;
        $seller_vacation_mode = $sellerCartObjVal->is_vacation_mode;
    }

    /* ----Digital Product Block Ends------- */

    if ($message != "") { // error
        $message = "<br>" . MSG_CORRECT_THE_ERRORS . "<br>" . $message;
    } else { // no error so insert user details
        if ($_POST['product_name_old'] != $txtProductName) {
            //Generate Alias name for product
            $aliasname = Utils::generateAlias($tableprefix . "products", $txtProductName);
        }

        $product_category = $_POST['txtCategory'];
        
        $data = array(
			"product_name" => $txtProductName,
			"product_code" => $txtProductCode,
            "product_category" => $product_category,
			"product_description" => $txtDescription,
			"product_price" => $txtPrice,
                        "publish_status" => $rdPublishStatus,
                        "publish_scheduled_date" => $publishDate,                             
                        "product_tags" => $txtSearchTags,
                        "allow_subscription" => $chkAllowSubscription,
                        "subscription_mode" => $rdSubscriptionMode,
                        "allow_free_shipping" => $chkAllowFreeShipping,
                        "seller_vacation_mode" => $seller_vacation_mode
                        );
        if ($aliasname != NULL)
            $data["alias"] = $aliasname;
        $data["product_artist_id"] = $ddlArtist;
        //echo $sql;
        $pdo->update($tableprefix.'products', $data, array("product_id" => $productid))->affectedRows();


        //Options area comes here
        //checking whether any option deleted
        $options_deleted = array();
        $queryOptionsAlready = "SELECT product_option_id FROM " . $tableprefix . "product_options WHERE product_id = :productid";
        $queryOptionsAlreadyQ = $pdo->pdoQuery($queryOptionsAlready, array("productid" => $productid))->results();
        foreach ($queryOptionsAlreadyQ as $optionsAlreadyObj) { $optionsAlreadyObj = (object)$optionsAlreadyObj;
            if (!in_array($optionsAlreadyObj->product_option_id, $_POST['product_option_id'])) {
                array_push($options_deleted, $optionsAlreadyObj->product_option_id);
            }
        }
        if (count($options_deleted)) {
            $options_delStr = implode(',', $options_deleted);
            list($qarr,$qstr) = getInQueryString($options_delStr);
            $query_option_value_delete = "DELETE FROM " . $tableprefix . "product_option_values WHERE product_option_id IN (" . $qstr . ")";
            $pdo->pdoQuery($query_option_value_delete, $qarr)->results();
            $query_option_delete = "DELETE FROM " . $tableprefix . "product_options WHERE product_option_id IN (" . $options_delStr . ")";
            $pdo->pdoQuery($query_option_delete, $qarr)->results();
        }

        $options_available_now_array = $_POST['product_option_id'];
        //Product Options Insertion here Santhosh thomas Alexander
        for ($i = 0; $i < $options_count; $i++) {

            $default_option = $_POST['default_option'][$i];
            $product_option_id = $_POST['product_option_id'][$i];
            $additional_price = $_POST['additional_price'][$i];
            $product_stock = $_POST['product_stock'][$i];
            $reorder_level = $_POST['reorder_level'][$i];
            $product_shipping_weight = $_POST['product_shipping_weight'][$i];
            $discount = $_POST['discount'][$i];
            $discount_description = $_POST['discount_description'][$i];
            $product_length = $_POST['product_length'][$i];
            $product_width = $_POST['product_width'][$i];
            $product_height = $_POST['product_height'][$i];
            $default_option_actual = "NO";
            if ($default_option == 1) {
                $default_option_actual = "YES";
            }
            $small_image_name_after_upload = "";
            $big_image_name_after_upload = "";

            $dir_dest = "../products";
            //small Image Upload

            $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);

            $final_image_small = "";

//************************************************Multicart3.0 Image Upload Modifications******************************

            if ($picsmallname != "") {
                $picSmallArr = explode('.', $picsmallname);
                $cntCountParamsSmall = count($picSmallArr);
                $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
                $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
            } else {

                // Save and resize Big Image to small size if small image not uploaded
                if ($_FILES['image_big']['name'][$i] != '') {
                    $picsmallname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
                    $picSmallArr = explode('.', $picsmallname);
                    $cntCountParamsSmall = count($picSmallArr);
                    $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
                    $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
                }
            }

            $picsmallname = $final_image_small;

            $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);

            $final_image_big = "";
            if ($picbigname != "") {
                $picBigArr = explode('.', $picbigname);
                $cntCountParamsBig = count($picBigArr);
                $name_big_with_out_extension = str_replace('.' . $picBigArr[$cntCountParamsBig - 1], '', $picbigname);
                $final_image_big = "productbig_" . $productid . "_" . $i . "_" . time() . $name_big_with_out_extension;
            }
            $picbigname = $final_image_big;

            /*             * ****************************************************Saving the original image**************** */

            /* if ($_FILES['image_small']['name'][$i] != "") {
              $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
              $imagecontent = file_get_contents($_FILES['image_small']['tmp_name'][$i]);
              $file_extn              = end(explode(".",$picsmallname));
              //Save Small image
              $original_image_name_after_upload      = "productoriginal_".$productid."_".time().$picsmallname;
              $imageOriginal                        = "../products/".$original_image_name_after_upload;
              $imageOriginalSave                     = fopen($imageOriginal,'x');
              fwrite($imageOriginalSave, $imagecontent);
              fclose($imageOriginalSave);
              } */
            /*             * ************************************************Saving the original image**************** */
            // then we check if the file has been uploaded properly
            // in its *temporary* location in the server (often, it is /tmp)
            // Save Samll Images

            if ($_FILES['image_small']['name'][$i] != "") {
                //Commenting the previous code
                $files = array();
                foreach ($_FILES['image_small'] as $k => $l) {
                    foreach ($l as $j => $v) {
                        if (!array_key_exists($j, $files))
                            $files[$j] = array();
                        $files[$j][$k] = $v;
                    }
                }

                for ($x = 0; $x < count($files); $x++) {
                    if ($x == $i) {
                        $handle = new Upload($files[$x]);
                        if ($handle->uploaded) {
                            // Modification resize
                            //   $info = getimagesize($inputFileName);
                            $handle->image_resize = true;
                            $handle->image_ratio = true;
                            $handle->image_x = 387;
                            $handle->image_y = 260;
                            $handle->file_new_name_body = $picsmallname;
                            $handle->Process($dir_dest);
                            $small_image_name_after_upload = $handle->file_dst_name;
                            $imagepath = "../products/" . $small_image_name_after_upload;
                            moveImageToCDN($imagepath, 'products/' . $small_image_name_after_upload);
                        }
                    }
                }
                /*                 * ************image resizing maintaining then aspect ratio **************** */
                /* $imagecontent = file_get_contents($_FILES['image_small']['tmp_name'][$i]);
                  $file_extn              = end(explode(".",$picsmallname));
                  //Save Small image
                  // $small_image_name_after_upload      = "productsmall_".$productid."_".time().$picsmallname;
                  $small_image_name_after_upload = str_replace('productoriginal_','productsmall_',$original_image_name_after_upload);
                  $imageSmall                         = "../products/".$small_image_name_after_upload;
                  $imageSmallSave                     = fopen($imageSmall,'x');
                  fwrite($imageSmallSave, $imagecontent);
                  fclose($imageSmallSave);
                  reSizeImageFromFolder($imageSmall,191,183); */
                /*                 * ************image resizing maintaining then aspect ratio **************** */
            }
            //small image upload end
            //big Image Upload
            // then we check if the file has been uploaded properly
            // in its *temporary* location in the server (often, it is /tmp)
            // Save Big Images

            if ($picbigname != "") {
                //Commenting the previous code
                $files = array();
                foreach ($_FILES['image_big'] as $k => $l) {
                    foreach ($l as $j => $v) {
                        if (!array_key_exists($j, $files))
                            $files[$j] = array();
                        $files[$j][$k] = $v;
                    }
                }
                for ($x = 0; $x < count($files); $x++) {
                    if ($x == $i) {
                        $handle = new Upload($files[$x]);
                        if ($handle->uploaded) {

                            $handle->image_resize = true;
                            $handle->image_ratio = true;
                            $handle->image_x = 489;
                            $handle->image_y = 328;
                            $handle->file_new_name_body = $picbigname;
                            $handle->Process($dir_dest);
                            $big_image_name_after_upload = $handle->file_dst_name;
                            $imagepath = "../products/" . $big_image_name_after_upload;
                            moveImageToCDN($imagepath, 'products/' . $big_image_name_after_upload);

                            $main_thumb_file_name = "thumb_" . $picbigname;
                            $handle->file_new_name_body = $main_thumb_file_name;
                            $handle->image_resize = true;
                            $handle->image_x = 82;
                            $handle->image_y = 79;
                            $handle->image_ratio = true;
                            $handle->Process($dir_dest);
                            $main_thumb_file_name_after_upload = $handle->file_dst_name;
                            $imagethubpath = "../products/" . $main_thumb_file_name_after_upload;
                            moveImageToCDN($imagethubpath, 'products/' . $main_thumb_file_name_after_upload);
                        }




                        /*  // Create thumbnail Image and save to thumb folder
                          $big_file_name                  =    "thumb_".$picbigname;
                          $handle->file_new_name_body     =    $big_file_name;
                          $handle->image_resize           = true;
                          $handle->image_x                = 82;
                          $handle->image_y                = 79;
                          $handle->image_ratio            = true;
                          $handle->Process($dir_dest);

                          echo $imagethumbpath  = "../products/".$big_file_name;
                          moveImageToCDN($imagethumbpath,'products/'.$big_file_name); */


                        // Resize  Small images in listing if small image  not uploaded
                        if ($_FILES['image_small']['name'][$i] == '') {
                            $small_file_name = $picsmallname;
                            $handle->file_new_name_body = $small_file_name;
                            $handle->image_resize = true;
                            $handle->image_x = 387;
                            $handle->image_y = 260;
                            $handle->image_ratio = true;
                            $handle->Process($dir_dest);
                            $small_image_name_after_upload = $handle->file_dst_name;
                            $imagepath = "../products/" . $small_image_name_after_upload;
                            moveImageToCDN($imagepath, 'products/' . $small_image_name_after_upload);
                        }
                    }
                }
            }
            /*             * ************image resizing maintaining then aspect ratio **************** */
            /* $imagecontent = file_get_contents($_FILES['image_big']['tmp_name'][$i]);
              $file_extn              = end(explode(".",$picbigname));
              //$big_image_name_after_upload      = "productbig_".$productid."_".time().$picbigname;
              $big_image_name_after_upload = str_replace('productoriginal_','productbig_',$original_image_name_after_upload);
              $imageSmall             = "../products/".$big_image_name_after_upload;
              $imageSmallSave         = fopen($imageSmall,'x');
              fwrite($imageSmallSave, $imagecontent);
              fclose($imageSmallSave);
              reSizeImageFromFolder($imageSmall,283,269); */
            /*             * ************image resizing maintaining then aspect ratio **************** */

            //big image upload end
            //Product option Images upload end
            //updating already existing options and inserting new ones
            if ($product_option_id == "") {

                $data = array (
            			"product_id" => $productid,
            			"additional_price" => $additional_price,
            			"product_stock" => $product_stock,
            			"reorder_level" => $reorder_level,
            			"product_shipping_weight" => $product_shipping_weight,
            			"image_small" => $small_image_name_after_upload,
            			"image_big" => $big_image_name_after_upload,
            			"discount" => $discount,
            			"discount_description" => $discount_description,
                        "product_length" => $product_length,
                        "product_width" => $product_width,
                        "product_height" => $product_height,
                        "default_option" => $default_option_actual,
                        "cdn_images_moved" => $cdn_enabled
                        );
                $product_option_id = $pdo->insert($tableprefix."product_options", $data)->lastInsertId();
            } else {

                $data = array(
                			"product_id" => $productid,
                			"additional_price" => $additional_price,
                			"product_stock" => $product_stock,
                			"reorder_level" => $reorder_level,
                			"product_shipping_weight" => $product_shipping_weight
                            );
                if ($small_image_name_after_upload != "") {
                    $data["image_small"] = $small_image_name_after_upload;
                }
                if ($big_image_name_after_upload != "") {
                    $data["image_big"] = $big_image_name_after_upload;
                }
                $data["discount"] = $discount;
                $data["discount_description"] = $discount_description;
                $data["product_length"] = $product_length;
                $data["product_width"] = $product_width;
                $data["product_height"] = $product_height;
                $data["default_option"] = $default_option_actual;

                $pdo->update($tableprefix.'product_options', $data, array("product_option_id" => $product_option_id))->affectedRows();

                // echo $sqlOptions;exit;
            }
            $queryDeleteOption = "DELETE FROM " . $tableprefix . "product_option_values WHERE product_option_id = :product_option_id";
            $pdo->pdoQuery($queryDeleteOption, array("product_option_id" => $product_option_id))->results();
            $options_arr = getOptionsFromCategory($ddlCategory);
            $num_of_options = count($options_arr);
            if ($num_of_options != "") {
                foreach ($options_arr AS $eachoption) {

                    $option_Id = $eachoption['option_id'];
                    $option_value = $_POST["option_" . $option_Id][$i];
                    if ($option_value != "") {

                        $data = array(
                                                "product_option_id" => $product_option_id,
                                                "option_id" => $option_Id,
                                                "value" => $option_value
                                                );
                        $pdo->insert($tableprefix."product_option_values", $data)->lastInsertId();
                    }
                }
            }
        }

        //*************************************Multicart3.0 Scalability Modifications*******************************************
        // Save product default option values to product  table
        if (getSettingsValue('enable_scalability_settings') == 'Y') {
            $objDefaultOptionVo = new stdClass();
            $objOptionVo = Products::getProduct_Default_Option_Values($productid);
            $objDefaultOptionVo->default_image_small = $objOptionVo->image_small;
            $objDefaultOptionVo->default_stock = $objOptionVo->product_stock;
            $objDefaultOptionVo->default_additional_price = $objOptionVo->additional_price;
            $objDefaultOptionVo->default_shipping_weight = $objOptionVo->product_shipping_weight;
            $objDefaultOptionVo->default_discount = $objOptionVo->discount;
            $objDefaultOptionVo->default_discount_description = $objOptionVo->discount_description;
            $objDefaultOptionVo->default_option_id = $objOptionVo->product_option_id;
            $objDefaultOptionVo->product_id = $productid;

            // Save default option values to product table
            $productinfoUpdate = Products::updateProduct_Default_Option_Value($objDefaultOptionVo);
        }
// echopre($objDefaultOptionVo);
        //exit;
        //*************************************Multicart3.0 Scalability Modifications End *******************************************
        //Options area ends here
        // Updating Digital Products

        if ($txtDigitalProduct == 'Y') {
            $txtDownloadTry = $_POST['txtDownloadTry'];

            $txtDownloadExpiry = $_POST['txtDownloadExpiry'];
            $data = array(
						"ndownload_try" => $txtDownloadTry,
						"ndownload_expiry_days" => $txtDownloadExpiry
                        );
            $rs_digital_product = $pdo->update($tableprefix.'digital_product', $data, array("ndigital_productid" => $productid, "ndigital_orderid" => '0'))->affectedRows();
        }

        /* -----------Digital Product Block Starts----------------- */

        if ($_FILES['txtProductZip']['name'] != '' && $message == "") {

            $digitalproductname = preg_replace("/^[^a-z0-9.-]?(.*?)[^a-z0-9]?$/i", "$1", $_FILES['txtProductZip']['name']);
            $digitalproductname = trim(str_replace(' ', '_', $digitalproductname));

            $assignedname = randomDigitalProduct() . "_" . $digitalproductname;

            if (move_uploaded_file($_FILES['txtProductZip']['tmp_name'], "../digital_product/" . $assignedname)) {

                chmod("../digital_product/$assignedname", 0777);

                $update_digital_product = "UPDATE " . $tableprefix . "digital_product
										   SET vdigital_product_name = :assignedname
											WHERE ndigital_productid = :productid ";

                $pdo->pdoQuery($update_digital_product, array("assignedname" => $assignedname, "productid" => $productid))->results();

                @unlink("../digital_product/" . $_POST['digital_image_buffer']);
            } else {
                $message .= COULDNT_UPLOAD . " " . "<br>";
            }
        }



        /* -----------Digital Product Block Ends----------------- */


        /*
         * Update Product more images By Binu Chandran.E
         */
        $moreFiles = array();
        foreach ($_FILES['productMoreImage'] as $k => $l) {
            foreach ($l as $j => $v) {
                if (!array_key_exists($j, $moreFiles)) {
                    $moreFiles[$j] = array();
                }
                $moreFiles[$j][$k] = $v;
            }
        }

        $dir_dest = "../products";

        for ($x = 0; $x < count($moreFiles); $x++) {
            $moreImageName = ReplaceArrayImage($moreFiles[$x]['name']);
            if ($moreImageName != "") {
                /*                 * ******** Image resizing maintaining aspect ratio begin********** */

                $moreImageName = "productmore_" . $x . time() . $moreImageName;
                $moreImageName_Upload = substr($moreImageName, 0, strrpos($moreImageName, '.'));
                $handle = new Upload($moreFiles[$x]);
                if ($handle->uploaded) {

                    $handle->image_resize = true;
                    $handle->image_x = 489;
                    $handle->image_y = 328;
                    $handle->image_ratio = true;
                    $handle->file_new_name_body = $moreImageName_Upload;
                    $handle->Process($dir_dest);
                    $moreImageNameAfterupload = $handle->file_dst_name;
                    $moreimagepath = "../products/" . $moreImageNameAfterupload;
                    moveImageToCDN($moreimagepath, 'products/' . $moreImageNameAfterupload);

                    // Save More Image Thubnail to thumb folder
                    $more_thumb_file_name = "thumb_" . $moreImageName_Upload;
                    $handle->file_new_name_body = $more_thumb_file_name;
                    $handle->image_resize = true;
                    $handle->image_x = 82;
                    $handle->image_y = 79;
                    $handle->image_ratio = true;
                    $handle->process($dir_dest);
                    $more_thumb_file_name_after_upload = $handle->file_dst_name;
                    $imagethubpath = "../products/" . $more_thumb_file_name_after_upload;
                    moveImageToCDN($imagethubpath, 'products/' . $more_thumb_file_name_after_upload);

                    $alreadyAddedID = isset($_POST['productMoreImageID'][$x]) ? ($_POST['productMoreImageID'][$x]) : 0;
                    $alreadyAddedImage = isset($_POST['productMoreImageName'][$x]) ? ($_POST['productMoreImageName'][$x]) : 0;

                    if ($alreadyAddedID > 0) {
                        $updateMImageQuery = "UPDATE " . $tableprefix . "product_view_images
                                                                  SET vimage_name = :moreImageNameAfterupload,
                                                                       cdn_images_moved = :cdn_enabled
                                                                      WHERE nproduct_image_id = :alreadyAddedID";
                        $pdo->pdoQuery($updateMImageQuery, array("moreImageNameAfterupload" => $moreImageNameAfterupload, "cdn_enabled" => $cdn_enabled, "alreadyAddedID" => $alreadyAddedID))->results();
                        if (is_file("../products" . $alreadyAddedImage) && file_exists("../products" . $alreadyAddedImage)) {
                            unlink("../products" . $alreadyAddedImage);
                        }
                    } else {
                        $insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                                                                  SET nimage_productid = :productid,
                                                                      vimage_name= :moreImageNameAfterupload,
                                                                      vproduct_image_delete_status 	='N',
                                                                      cdn_images_moved = :cdn_enabled";
                        $pdo->pdoQuery($insertMImageQuery, array("productid" => $productid, "moreImageNameAfterupload" => $moreImageNameAfterupload, "cdn_enabled" => $cdn_enabled))->results();
                    }
                }
            }
        }
        if ($message == '') {
            $message = CHANGES_SAVED_SUCCESSFULLY . "<br>";
        }
        if ($_POST["from"] == "list") {
            header("Location:listProducts.php?message=" . $message);
            exit;
        } else {

            header("Location:catalog.php?catid=" . $ddlCategory . "&message=" . $message);
            exit;
        }
    }
} else if ($_POST["btnDelete"] == "Delete") {
    $sql = "DELETE FROM  " . $tableprefix . "products
			WHERE product_id = :productid";
    $pdo->pdoQuery($sql, array("productid" => $productid))->results();

    $select_product_images = "SELECT p.image_small,p.image_big
							  FROM " . $tableprefix . "product_options p WHERE p.product_id = :productid";

    $result_product_images = $pdo->pdoQuery($select_product_images, array("productid" => $productid))->results();


    if (count($result_product_images) > 0) {
        foreach ($result_product_images as $product_images_row) {

            $imagesmall_thumb = $product_images_row['image_small'];

            $imagelarge_thumb = $product_images_row['image_big'];

            @unlink("../products/" . $imagesmall_thumb);
            @unlink("../products/" . $imagelarge_thumb);



            /* -------Category count update patch------------ */
        }
    }
    $sql_options = "DELETE FROM " . $tableprefix . "product_options WHERE product_id = :productid ";
    $del_options = $pdo->pdoQuery($sql_options, array("productid" => $productid))->results();
    $select_product_images_more = "SELECT im.vimage_name
							  				FROM " . $tableprefix . "product_view_images im  WHERE im.nimage_productid = :productid";
    $rs_product_image_more = $pdo->pdoQuery($select_product_images_more, array("productid" => $productid))->results();

    if (count($rs_product_image_more) > 0) {

        foreach ($rs_product_image_more as $prows) {
            $moreimage = $prows['vimage_name'];

            $moreimage_thumb = "thumb_" . $prows['vimage_name'];

            @unlink("../products/bulk_images/" . $moreimage);

            @unlink("../products/bulk_images/" . $moreimage_thumb);
        }
    }
    $sql_product_images_more = "DELETE FROM " . $tableprefix . "product_view_images WHERE nimage_productid = :productid ";
    $del_product_images_more = $pdo->pdoQuery($sql_product_images_more, array("productid" => $productid))->results();


    header("Location:catalog.php?catid=$ddlCategory");
    exit;
}

$catlist = make_selectlist(0, 0);
$artistlist = makeArtistList();

$sql = "SELECT * FROM " . $tableprefix . "products WHERE product_id= :productid ";
$result = $pdo->pdoQuery($sql, array("productid" => $productid))->results();
if (count($result) != 0) {
    $row = ($result[0]);
    $txtProductName = $row["product_name"];
    $txtProductCode = $row["product_code"];
    $txtDescription = $row["product_description"];
    $txtPrice = $row["product_price"];
    $ddlCategory = $row["product_category"];
    $ddlArtist = $row["product_artist_id"];
    $oldcategory = $ddlCategory;
    $txtSearchTags = $row["product_tags"];
    $chkAllowFreeShipping = $row["allow_free_shipping"];
    $chkAllowSubscription = $row["allow_subscription"];
    $rdSubscriptionMode = $row["subscription_mode"];
    $rdPublishStatus = $row["publish_status"];
    if ($rdPublishStatus == "N" || $rdPublishStatus == '') {
        //published time in 24_hour_format
        $publishDate = $row["publish_scheduled_date"];
        $publishTime = date('h:i a', strtotime($publishDate));

        $publishDate = date('m-d-Y', strtotime($publishDate));
    } else {
        $publishDate = "";
        $publishTime = "";
    }


    /* -------Product shipping weight starts------ */

    $txtShippingWeight = $row["nproduct_shipping_weight"];

    /* -------Product shipping weight ends------ */

    /* -----------Digital Product Block Starts----------------- */

    if ($row["vdigital_product"] == "Y") {
        $digital_product_display = "";

        $canshipblock = "none";

        $shipping_product_display = "none";


        $select_digital_product_zip = "SELECT vdigital_product_name,ndownload_expiry_days,ndownload_try FROM " . $tableprefix . "digital_product
									   WHERE ndigital_productid = :product_id ";
        $result_digital_product_zip = $pdo->pdoQuery($select_digital_product_zip, array("product_id" => $row["product_id"]))->results();

        if (count($result_digital_product_zip) > 0) {

            $digital_product_zip_row = ($result_digital_product_zip[0]);
            $digital_product_display = $digital_product_zip_row["vdigital_product_name"];
        }
    } else {
        $digital_product_display = "none";
        $canshipblock = "";
    }

    /* -----------Digital Product Block Ends----------------- */
}
if ($imgsmall == '') {
    $imgsmall = 'noimage.jpg';
}

if ($imgbig == '') {
    $imgbig = 'noimage.jpg';
}


include "../includes/htmltop.php";


/// Vacation Mode settings
$sellerObj = Store::get_seller_account_info($ddlArtist);
$seller_vacation_mode = 'N';
if ($sellerObj->status == SUCCESS) {
    $sellerObjVal = $sellerObj->data;
    $seller_vacation_mode = $sellerObjVal->is_vacation_mode;
}
?>
<link rel="stylesheet" href="<?php echo $site_url; ?>/style/jquery-ui.css">
<script src="<?php echo $site_url; ?>/js/jquery-1.11.2.js"></script>
<script src="<?php echo $site_url; ?>/js/jquery-ui.js"></script>
<link href="<?php echo $site_url; ?>/style/jquery.timepicker.css" rel="stylesheet" type="text/css">
<link href="<?php echo $site_url; ?>/style/jquerysctipttop.css" rel="stylesheet" type="text/css">

<!-- CSS Stylesheet -->

<style type="text/css">
    .brd_pc_stls .mn_pcs{
        margin:0 0 2px 0;
        border:5px solid #DEDEB5;


    }
</style>


<SCRIPT>
    function confirmDelete() {
        if (confirm("<?php echo ARE_YOU_SURE_DELETE_RECORD; ?>")) {
            return true;
        }
        return false;
    }

    function openWindow(id)
    {
        var url = "../viewimage.php?id=" + id;
        window.open(url, "Image", "height=500,width=500,scrollbars=yes");
    }
    function checkDigitalProduct()
    {

        if (document.frmProductDetails.txtDigitalProduct.checked == true)
        {

            document.getElementById("digitalProductBlock").style.display = "";
            $(".canshipBlock").hide();

        }
        else
        {

            document.getElementById("digitalProductBlock").style.display = "none";
            $(".canshipBlock").show();

        }

    }

    function deleteMoreImage()
    {
        if (confirm('<?php echo DEL_IMG_CONFIRM; ?>'))
        {
            var id = $(this).parents('.jqMoreImageContainer').find('.jqMoreImageID').val();
            var image = $(this).parents('.jqMoreImageContainer').find('.jqMoreImageName').val();
            var delLink = $(this);
            $.ajax({url: 'editproduct.php?action=delmoreimage',
                data: {id: id, image: image},
                type: 'post',
                dataType: 'json',
                success: function (reply) {
                    if (reply)
                    {
                        if (reply.success)
                        {
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImageZoom').remove();
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImage').remove();
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImageDelete').remove();




                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImageID').val('');
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImageName').val('');
                        }
                    }
                }
            });
        }
    }
</SCRIPT>
<script type="text/javascript" src="<?php echo SITE_URL ?>/ckeditor/ckeditor.js"></script>



<?php
$options_arr = getOptionsFromCategory($ddlCategory);
$num_of_options = count($options_arr);
$StrOptions = "";
if ($num_of_options != "") {
    foreach ($options_arr AS $eachoption) {
        $StrOptions .='<br><br>' . $eachoption['option_name'];
        $StrOptions .='<input type="text" name="option_' . $eachoption['option_id'] . '[]" value="">';
    }
}
?>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL ?>/js/jquery.timepicker.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL ?>/js/dateselector.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL ?>/js/dateselector.min.js"></script>
<link rel="stylesheet" href="<?php echo SITE_URL ?>/style/thickbox.css" type="text/css" media="screen" />
<script type="text/javascript" src="<?php echo SITE_URL ?>/js/thickbox.js"></script>
<script type="text/javascript">
    window.onload = function ()
    {
        var editor = CKEDITOR.replace('editor1'
                , {
                    filebrowserBrowseUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html',
                    filebrowserImageBrowseUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Images',
                    filebrowserFlashBrowseUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Flash',
                    filebrowserUploadUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                    filebrowserImageUploadUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                    filebrowserFlashUploadUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'
                });
        CKFinder.setupCKEditor(editor, '<?php echo SITE_URL ?>/ckeditor/ckfinder/');
    };
    $(document).ready(function () {
        
        
        var ProductCategory = '<?php echo $ddlCategory;?>';
       
        $("#txtCategory").val(ProductCategory);
        

        $('#txtPrice').keyup(function (e) {
            var price = parseFloat($('#txtPrice').val());
            var newVal = $('#txtPrice').val().replace(/[^\d.]/, '');
            var number = (newVal.split('.'));
            $('#txtPrice').val(newVal);
            if (typeof (number[1]) != "undefined") {
                if (number[1].length > 2)
                {
                    $("#txtPrice").val(price.toFixed(2));
                }
            }

        });
        $('.jqPrice').keyup(function (e) {
            var price = parseFloat($(this).val());
            var newVal = $(this).val().replace(/[^\d.]/, '');
            var number = (newVal.split('.'));
            $(this).val(newVal);
            if (typeof (number[1]) != "undefined") {
                if (number[1].length > 2)
                {
                    $(this).val(price.toFixed(2));
                }
            }

        });

        $(".jqMoreImageDelete").click(deleteMoreImage);



        $("#add_more_options").click(function () {
            var addVal = $("#add_value").val();
            $("#add_value").val(parseInt(addVal) + 1);
            var block = '<tr class="option_block"><td><table cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC"><tr><th><?php echo DEFAULT_OPT; ?></th><th><?php echo ADD_PRICE; ?>&nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th><th><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></th><th><?php echo REORDER_LEVEL; ?>&nbsp;</th></tr><tr><td><span class="default_setting_box"><input type="radio" name="default" id="default" onclick="setDefaultOption(this);"><input type="hidden" name="product_option_id[]" value=""><input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value=""><?php echo $StrOptions ?></span></td><td><input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="" class="jqPrice jQNumeric"></td><td><input type="text" name="product_stock[]" id="product_stock[]"  class="jQNumeric" value=""></td><td><input type="text" name="reorder_level[]" id="reorder_level[]" class="jQNumeric" value=""></td></tr><tr> <th><?php echo BIG_IMG; ?>&nbsp;<span class="required">*</span></th><th><?php echo SMALL_IMG; ?>&nbsp;</th><th><?php echo DISCOUNT_PERC; ?></th><th><?php echo DISCOUNT_DESC; ?></th></tr><tr><td><input type="file" name="image_big[]" id="image_big_'+addVal+'" onchange="showBigImages(this.files,' + addVal + ',this);" value=""><img src="" style="display:none" width="183" height="191" id="big_img_preview_' + addVal + '"></td><td><input type="file" name="image_small[]" id="image_small_'+addVal+'" onchange="showSmallImages(this.files,' + addVal + ',this);" value=""><img src="" style="display:none" width="183" height="191" id="small_img_preview_' + addVal + '"></td><td><input type="text" name="discount[]" id="discount[]" value="" class="jQNumeric"></td><td><input type="text" name="discount_description[]" id="discount_description[]" value=""></td></tr><tr class="canshipBlock"><th><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></th><th><?php echo LENGTH; ?><span class="required">*</span> (cm) </th><th><?php echo WIDTH; ?> <span class="required">*</span>(cm) </th><th><?php echo HEIGHT; ?><span class="required">*</span> (cm) </th></tr><tr class="canshipBlock"><td><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="" class="jQNumeric"></td><td><input type="text" name="product_length[]" id="product_length[]" value="" class="jQNumeric"></td><td><input type="text" name="product_width[]" id="product_width[]" value=""></td><td><input type="text" name="product_height[]" id="product_height[]" value="" class="jQNumeric">&nbsp;<img border="0" title="Delete Option" src="../images/btn_del.gif" alt="Delete Option" class="delete_option" onclick="javascript:delete_option(this);"></td></tr></table></td></tr>';
            $("#options_window").append(block);
            $('.jqPrice').keyup(function (e) {
                var price = parseFloat($(this).val());
                var newVal = $(this).val().replace(/[^\d.]/, '');
                var number = (newVal.split('.'));
                $(this).val(newVal);
                if (typeof (number[1]) != "undefined") {
                    if (number[1].length > 2)
                    {
                        $(this).val(price.toFixed(2));
                    }
                }

            });
            checkDigitalProduct();
        });

        $('.rdPublishStatus').click(function () {

            if ($('input[name=rdPublishStatus]:checked').val() == "N") {
                $("#publish_time").show();
            } else if ($('input[name=rdPublishStatus]:checked').val() == "Y") {
                $("#publish_time").hide();
            }

        });


        //Datepicker    
        //var dateToday = "<?php echo $publishDate; ?>";
<?php if ($publishDate != '') { ?>
            var dateToday = "<?php echo $publishDate; ?>";
<?php } else { ?>
            var dateToday = new Date(Date.now());
<?php } ?>

        $("#publishdate").datepicker({
            dateFormat: 'mm-dd-yy',
            minDate: dateToday
        }).datepicker('setDate', dateToday)

        $('#chkAllowSubscription').click(function (e) {
            if ($('input[name=chkAllowSubscription]:checked').val()) {
                $('#subscription_mode').show();
            } else {
                $('#subscription_mode').hide();
            }

        });

        //   $(".thickbox").thickbox();

        $("#publishtime").timepicker();
        $('#publishtime').on('changeTime', function () {

            $('#publishtimeval').val($(this).val());
        });


    });
    
    
    function checkOptionsSame(categoryId,existCategory)
        {
            var Site_Url = '<?php echo SITE_URL;?>';
            var dataString = 'catID='+ categoryId +"&existCagoryId="+existCategory;
           
                $.ajax({
                type: "POST",
                url: Site_Url+"/getCategoryOptions.php",
                data: dataString,
                dataType: 'json',
                cache: true,
                success: function(response)
                {	
                    if(response.status=='1')
                    {
                        alert(INVALID_CATEGORY_OPTIONS);
                        $("#txtCategory").val(existCategory);
                    }
                       
                }
                });
        }
        
    function setDefaultOption(obj) {

        $(".default_option").val("");
        $(obj).parents(".default_setting_box").find(".default_option").val("1");


    }
    function delete_option(obj) {

        $(obj).parents(".option_block").hide("slow");
        $(obj).parents(".option_block").html("");
    }


    var _URL = window.URL || window.webkitURL;

    function showMyImage(files, imageId, dbImagePreview, fileInput) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;
        img.onload = function () {
            
            if(imageId == 'small_img_preview'){
                img_width = 200;
                img_height = 150;
            }
            else{

                img_width = 350;
                img_height = 245;
            }


            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {
                var imageType = /image.*/;
                $(".jqMoreImagefromDb_" + dbImagePreview).remove();
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }


        }
        img.src = _URL.createObjectURL(file);
    }
   

    function showBigImages(files, value, fileInput ) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;
 
        img.onload = function () {

            img_width = 350;
            img_height = 245;

            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {


                var imageType = /image.*/;
            
                var imageId = 'big_img_preview_' + value;
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }
        }
        img.src = _URL.createObjectURL(file);
    }

    function showSmallImages(files, value, fileInput) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;
    
        img.onload = function () {

            img_width = 200;
            img_height = 150;

            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {
                var imageType = /image.*/;
                var imageId = 'small_img_preview_' + value;
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }
        }
        img.src = _URL.createObjectURL(file);
    }
</script>
<body>
<center>
    <div align="left" id="layout">
        <!--header area start -->
<?php
include_once("../includes/topheader_admin.php")
?>
        <!--header area end -->
        <div align="left" class="main_body">
            <!--main body start -->
<?php
include_once("../includes/admintopmenu.php")
?>
            <div align="left" class="content_area">
                <!--content area start -->
                <div align="left" class="page_title"><?php echo EDIT_PRODUCT; ?></div>
                <div align="center" class="text_information grey_tr"><?php echo $message ?></div>
                <br>
                <div align="left">
                    <form name="frmProductDetails" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="productid" value="<?php echo $productid; ?>" >
                        <input type="hidden" name="oldcategory" value="<?php echo $oldcategory; ?>" >
                        <!--<input type="hidden" name="txtCategory" value="<?php echo $ddlCategory ?>">-->
                        <input name="from" type="hidden" id="from" value="<?php echo $_GET["from"] ?>" >
                        <table cellpadding="0" cellspacing="0" width="100%" class="manage_table">
                            <tr><td colspan="3">&nbsp;</td></tr>
                            <?php 
                                     $optionCount = Products::getOptionsCount($productid);
                                    
                                   // if($optionCount==1) {
                            ?>
                                  <tr><td align="left" width="25%"><?php echo SELECT_CATEGORY; ?> &nbsp; <span class="required">*</span></td>
                                
                                <td width="5%">&nbsp;</td><td width="70%" align="left">
                                   <select name="txtCategory" class="textarea" id="txtCategory" onChange="checkOptionsSame(this.value,'<?php echo $ddlCategory;?>');">
 
                                    <?php getSelectBoxList($ddlCategory); ?>
 
                                    </select>
                                   </td></tr>
                            
                                    <?php //} else { 
                                           //  echo "<input type='hidden' name='txtCategory' value=".$ddlCategory.">";
                                   // } 
                                    ?>
                            
                            <tr><td align="left" width="25%"><?php echo PRODUCT_NAME; ?> &nbsp; <span class="required">*</span></td><td width="5%">&nbsp;</td><td width="70%" align="left"><input class="textarea" type="text" value="<?php echo Utils::html_entity($txtProductName); ?>" name="txtProductName" size="50" maxlength="100"></td></tr>
                            <tr><td align="left" width="25%"><?php echo PRODUCT_CODE; ?> &nbsp; </td><td width="5%">&nbsp;</td><td align="left"><input class="textarea" type="text" value="<?php echo stripslashes($txtProductCode); ?>" name="txtProductCode" size="50" maxlength="100"></td></tr>
                            <tr><td align="left" ><?php echo SELLER; ?>&nbsp;<span class="required">*</span></td><td >&nbsp;</td>
                                <td align="left">
<?php
echo makeDropDownList("ddlArtist", $artistlist, $ddlArtist, false, "textarea", $properties, $behaviors);
?>
                                </td>
                            </tr>
                            <!--
                             <tr><td align="left" >Category&nbsp;<span class="required">*</span></td><td align="left">&nbsp;</td>
                                     <td align="left">
<?php // echo makeDropDownList("ddlCategory", $catlist, $ddlCategory, true,"textarea", $properties, $behaviors) ?>
                                                    </td>
                                            </tr>
                            -->
                            <tr>
                                <td align="left" valign="top"><?php echo DESCRIPTION; ?>&nbsp;<span class="required">*</span></td><td >&nbsp;</td><td align="left">
                                    <textarea id="editor1" name="txtDescription"><?php echo Utils::html_entity($txtDescription); ?></textarea>
                                </td>
                            </tr>
                            <tr>
                                <td align="left"><?php echo PRICE; ?>&nbsp;<span class="required">*</span></td>
                                <td>&nbsp;</td>
                                <td align="left"><input type="text" class="textarea"  onpaste="return false;" value="<?php echo Utils::html_entity($txtPrice); ?>" name="txtPrice" size="30" maxlength="100" id="txtPrice">&nbsp;<b><?php echo $adminCurrency['currency_code']; ?></b></td>
                            </tr>
                            <tr><td align="right" ><?php echo TEXT_SEARCH_TAGS; ?>&nbsp;</td>
                                <td >:</td>
                                <td align='left'><textarea id="txtProductTags" name="txtProductTags" cols="50" class="textarea2" rows="10"><?php echo htmlentities($txtSearchTags); ?></textarea>                                                                        
                                    &nbsp;
                                    <span class="help"><a href="#" title="<?php echo PROD_TAGS_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                </td>
                            </tr>                                                                
                            <tr>
                                <td align="right"><?php echo TEXT_ALLOW_FREE_SHIPPING; ?>&nbsp;</td>
                                <td>:</td>
                                <td align='left'><input type="checkbox" id="chkAllowFreeShipping"  name="chkAllowFreeShipping" <?php if ($chkAllowFreeShipping == "Y") {
                echo "checked";
            } ?>  value="Y" <?php echo $chkAllowFreeShipping; ?>>
                                    <span class="help"><a href="#" title="<?php echo FREE_SHIPPING_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                </td>
                            </tr>

                            <!--<?php if (getSettingsValue('enable_subscription_products') == 'Y') { ?>
                                <tr>
                                    <td align="right"><?php echo TEXT_ALLOW_SUBSCRIPTION; ?>&nbsp;</td>
                                    <td>:</td>
                                    <td align='left'><input type="checkbox" id="chkAllowSubscription"  name="chkAllowSubscription" <?php if ($chkAllowSubscription == "Y") {
                    echo "checked";
                } ?> value="Y" <?php echo $chkAllowSubscription; ?>>
                                        <span class="help"><a href="#" title="<?php echo ALLOW_SUBSCRIPTION_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                    </td>
                                </tr>
                                <tr id="subscription_mode" <?php if ($chkAllowSubscription == "N") { ?> style="display: none;" <?php } ?>>
                                    <td align="right"><?php echo TEXT_SUBSCRIPTION_MODE; ?>&nbsp;</td>
                                    <td>:</td>
                                    <td align='left'>
                                        <input type="radio" name="rdSubscriptionMode" value="Daily" <?php if ($rdSubscriptionMode == "Daily") {
                                        echo "checked";
                                    } ?>><?php echo TEXT_DAILY; ?>                                   
                                        <input type="radio" name="rdSubscriptionMode" value="Monthly" <?php if ($rdSubscriptionMode == "Monthly") {
                                        echo "checked";
                                    } ?>><?php echo TEXT_MONTHLY; ?>
                                        <input type="radio" name="rdSubscriptionMode" value="Yearly" <?php if ($rdSubscriptionMode == "Yearly") {
                                        echo "checked";
                                    } ?>><?php echo TEXT_YEARLY; ?>
                                        <span class="help"><a href="#" title="<?php echo SUBSCRIPTION_MODE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                    </td>
                                </tr>

<?php } ?>-->
<?php if (getSettingsValue('enable_product_scheduled_publishing') == 'Y') { ?>
                                <tr>
                                    <td align="right"><?php echo TEXT_PUBLISH_STATUS; ?>&nbsp;</td>
                                    <td>:</td>
                                    <td align='left'>
    <?php if ($seller_vacation_mode == 'N') { ?>
                                            <input type="radio" name="rdPublishStatus" class="rdPublishStatus" value="Y" <?php if ($rdPublishStatus == "Y") {
            echo "checked";
        } elseif ($rdPublishStatus == NULL) {
            echo "checked";
        } ?>><?php echo TEXT_PUBLISH_NOW; ?>      
    <?php } ?>
                                        <input type="radio" name="rdPublishStatus" class="rdPublishStatus" value="N" <?php if ($rdPublishStatus == "N") {
        echo "checked";
    } ?>><?php echo TEXT_PUBLISH_LATER; ?>
                                        <span class="help"><a href="#" title="<?php echo PUBLISH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                    </td>
                                </tr>    
                                <tr id="publish_time" <?php if ($rdPublishStatus == "Y") { ?>style="display: none;"<?php } ?>>
                                    <td align="right"><?php echo TEXT_PUBLISH_DATE; ?>&nbsp;</td>
                                    <td>:</td>
                                    <td align='left'><table><tr><td><input type="text" id="publishdate" name="publishdate" value="<?php echo $publishDate; ?>"></td>
                                                <td><?php echo TEXT_PUBLISH_TIME; ?></td>
                                                <td><input type="text" id="publishtime" name="publishtime" class="publishtime" value="<?php echo $publishTime; ?>" style="width: 54px;"></td>
                                            <input type="hidden" id="publishtimeval" name="publishtimeval"  value="<?php echo $publishTime; ?>" style="width: 54px;">

                                            <td><span class="help"><a href="#" title="<?php echo TEXT_PUBLISH_TIME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></td>
                                </tr>                                                                        
                            </table>                                                                        
                            </td>
                            </tr>   

<?php } ?>
                        <!--Digital Product Block Starts-->

                        <tr>
                            <td colspan="3">
                                <div id="digitalProductBlock" style="display:<?php echo $digital_product_display ?>">
                                    <table width="100%" border="0" cellpadding="2" cellspacing="2" bgcolor="#FFFFFF">
                                        <tr>
                                            <td colspan="3" align="left"><strong><?php echo DIG_PRO_DETAILS; ?> </strong></td>
                                        </tr>
                                        <tr>
                                            <td width="30%" align="left"><?php echo UPLOAD_DIGPRO; ?>&nbsp;</td>
                                            <td width="33%" align='left'>
                                                <input type="file" class="textarea" name="txtProductZip">
                                                <input type="hidden" name="digital_image_buffer" value="<?php echo $digital_product_zip_row['vdigital_product_name'] ?>">
                                                <input type="hidden" name="txtDigitalProduct" value="<?php echo $row["vdigital_product"] ?>">
<?php echo $digital_product_zip_row['vdigital_product_name'] ?>

                                            </td>
                                            <td width="37%" class="text_information" align="left"> &nbsp;<?php echo MAX_UPLOAD_SIZE; ?>  <?php echo $maximagesizestringinPHP; ?> </td>
                                        </tr>

                                        <tr><td colspan="4" class="text_information" ><?php echo ALLOWED_DIGITAL_FORMATS; ?> :  <?php echo implode(",", $digital_product_types); ?> &nbsp; </td></tr>

                                        <tr>
                                            <td width="30%" align="left"><?php echo DWNLD_TRY; ?>&nbsp;</td>
                                            <td width="33%" align='left'>
                                                <select name="txtDownloadTry" class="textarea">
<?php
for ($i = 1; $i <= 10; $i++) {
    ?>
                                                        <option value="<?php echo $i ?>" <?php
                            if ($digital_product_zip_row['ndownload_try'] == $i) {
                                echo "selected";
                            }
                            ?>><?php echo $i ?></option>
    <?php
}
?>
                                                </select>&nbsp;<?php echo TIME; ?>
                                            </td>
                                            <td width="37%" class="text_information" align="left">&nbsp;</td>
                                        </tr>

                                        <tr>
                                            <td width="30%" align="left"><?php echo D_EXPIRY; ?>&nbsp;</td>
                                            <td width="33%" align='left'>
                                                <select name="txtDownloadExpiry" class="textarea">
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    ?>
                                                        <option value="<?php echo $i ?>" <?php if ($digital_product_zip_row['ndownload_expiry_days'] == $i) {
                                                        echo "selected";
                                                    } ?>><?php echo $i ?></option>
    <?php
}
?>
                                                </select>&nbsp;<?php echo DAY; ?>
                                            </td>
                                            <td width="37%" class="text_information" align="left">&nbsp;</td>
                                        </tr>

                                    </table>
                                </div>
                            </td>
                        </tr>
                        <!-- Options come here -->

                        <tr>
                            <td></td>
                            <td colspan="2">
                                <table cellpadding="2" cellspacing="2" border="0" id="options_window">
<?php
$queryDefaultOption = "SELECT * FROM " . $tableprefix . "product_options WHERE product_id = :productid AND default_option = 'YES'";
$defaultOptionQ = $pdo->pdoQuery($queryDefaultOption, array("productid" => $productid))->results();
$defaultOptionObj = (object)($defaultOptionQ[0]);
?>
                                    <tr>
                                        <td>
                                            <table cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC">
                                                <tr>
                                                    <th><?php echo DEFAULT_OPT; ?></th>
                                                    <th><?php echo ADD_PRICE; ?> &nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th>
                                                    <th><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></th>
                                                    <th><?php echo REORDER_LEVEL; ?>&nbsp;</th>
                                                </tr>
<?php
$dchecked = "";
$default = "";
if (count($_POST['default_option']) == 0) {
    $dchecked = "checked";
    $default = "1";
}
if ($_POST['default_option'][0] == "1") {
    $dchecked = "checked";
    $default = $_POST['default_option'][0];
}
?>
                                                <tr>
                                                    <td>
                                                        <span class="default_setting_box">
                                                            <input type="radio" name="default" id="default" onclick="setDefaultOption(this);" <?php echo $dchecked; ?>>
                                                            <input type="hidden" name="product_option_id[]" value="<?php echo $defaultOptionObj->product_option_id; ?>">
                                                            <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>">

<?php
$options_arr = getOptionsFromCategory($ddlCategory);
$num_of_options = count($options_arr);
if ($num_of_options != "") {
    foreach ($options_arr AS $eachoption) {
        echo "<br><br>" . $eachoption['option_name'];
        //getting the value of the option assigned
        $query_option_value = "SELECT value
                                                                                            FROM " . $tableprefix . "product_option_values
                                                                                            WHERE product_option_id = :product_option_id AND option_id = :option_id";
        $query_option_valueQ = $pdo->pdoQuery($query_option_value, array("product_option_id" => $defaultOptionObj->product_option_id, "option_id" => $eachoption['option_id']))->results();
        $option_value_obj = (object)($query_option_valueQ);
        ?>
                                                                    <input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $option_value_obj->value; ?>">
                                                        <?php
                                                    }
                                                }
                                                ?>
                                                        </span>
                                                    </td>
                                                    <td><input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $defaultOptionObj->additional_price; ?>" class="jqPrice jQNumeric"></td>
                                                    <td><input type="text" name="product_stock[]" id="product_stock[]" value="<?php echo $defaultOptionObj->product_stock; ?>" class="jQNumeric"></td>
                                                    <td><input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $defaultOptionObj->reorder_level; ?>" class="jQNumeric"></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo BIG_IMG; ?>&nbsp; <span class="required"> * </span></th>
                                                    <th><?php echo SMALL_IMG; ?>&nbsp;</th>

                                                    <th><?php echo DISCOUNT_PERC; ?></th>
                                                    <th><?php echo DISCOUNT_DESC; ?></th>
                                                </tr>
                                                            <?php
                                                            $image_small = "";
                                                            $image_big = "";
                                                            $product_image_path = "../products/";
                                                            if ($defaultOptionObj->image_small != "") {
                                                                if (strstr($defaultOptionObj->image_small, "http://")) {
                                                                    $image_small = $defaultOptionObj->image_small;
                                                                } else {
                                                                    $image_small = $product_image_path . $defaultOptionObj->image_small;
                                                                }
                                                            }
                                                            if ($defaultOptionObj->image_big != "") {
                                                                if (strstr($defaultOptionObj->image_big, "http://")) {
                                                                    $image_big = $defaultOptionObj->image_big;
                                                                } else {
                                                                    $image_big = $product_image_path . $defaultOptionObj->image_big;
                                                                }
                                                            }
                                                            ?>
                                                <tr valign="top">
                                                    <td valign="top">
                                                        <input type="file" name="image_big[]" id="image_big" value=""  onchange="showMyImage(this.files, 'big_img_preview', 'bigimagepreview', this)" value="<?php echo $_POST['image_big'][0]; ?>">
                                                        <img style="display:none" src="" id="big_img_preview" border="0" width="183" height="191">
<?php
if ($image_big != "") {
    ?>
                                                            <img src="<?php echo $image_big ?>" id="bigimagepreview" border="0" width="183" height="191">
    <?php
}
?>
                                                    </td>
                                                    <td valign="top">
                                                        <input type="file" name="image_small[]" id="image_small[]" value="" onchange="showMyImage(this.files, 'small_img_preview', 'smallimagepreview', this)">
                                                        <img style="display:none" src="" id="small_img_preview" border="0" width="183" height="191">
                                                <?php
                                                if ($image_small != "") {
                                                    ?>
                                                            <img id="smallimagepreview" src="<?php echo $image_small ?>" border="0" width="183" height="191">
                                                    <?php
                                                }
                                                ?>
                                                    </td>

                                                    <td valign="top"><input type="text" name="discount[]" id="discount[]" value="<?php echo $defaultOptionObj->discount; ?>" class="jQNumeric"></td>
                                                    <td valign="top"><input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo stripslashes($defaultOptionObj->discount_description); ?>"></td>
                                                </tr>
                                                <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>" align="left">
                                                    <th><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></th>
                                                    <th><?php echo LENGTH; ?><span class="required">*</span> (<?php echo CM; ?>) </th>
                                                    <th><?php echo WIDTH; ?><span class="required">*</span> (<?php echo CM; ?>) </th>
                                                    <th><?php echo HEIGHT; ?><span class="required">*</span> (<?php echo CM; ?>) </th>
                                                </tr>
                                                <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                    <td><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $defaultOptionObj->product_shipping_weight; ?>" class="jQNumeric"></td>
                                                    <td><input type="text" name="product_length[]" id="product_length[]" value="<?php echo $defaultOptionObj->product_length; ?>" class="jQNumeric"></td>
                                                    <td><input type="text" name="product_width[]" id="product_width[]" value="<?php echo $defaultOptionObj->product_width; ?>" class="jQNumeric"></td>
                                                    <td><input type="text" name="product_height[]" id="product_height[]" value="<?php echo $defaultOptionObj->product_height; ?>" class="jQNumeric"></td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
<?php
$queryOtherOption = "SELECT * FROM " . $tableprefix . "product_options WHERE product_id = :productid AND default_option != 'YES'";
$otherOptionQ = $pdo->pdoQuery($queryOtherOption, array("productid" => $productid))->results();
foreach ($otherOptionQ as $otherOptionObj) { $otherOptionObj = (object)$otherOptionObj;
    ?>


                                        <tr class="option_block">
                                            <td>
                                                <table cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC">
                                                    <tr>
                                                        <th><?php echo DEFAULT_OPT; ?></th>
                                                        <th><?php echo ADD_PRICE; ?>&nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th>
                                                        <th><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></th>
                                                        <th><?php echo REORDER_LEVEL; ?>&nbsp;</th>
                                                    </tr>
    <?php
    $dchecked = "";
    $default = "";
    ?>
                                                    <tr>
                                                        <td>
                                                            <span class="default_setting_box">
                                                                <input type="radio" name="default" id="default" onclick="setDefaultOption(this);" <?php echo $dchecked; ?>>
                                                                <input type="hidden" name="product_option_id[]" value="<?php echo $otherOptionObj->product_option_id; ?>">
                                                                <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>">

    <?php
    $options_arr = getOptionsFromCategory($ddlCategory);
    $num_of_options = count($options_arr);
    if ($num_of_options != "") {
        $k = 0;
        foreach ($options_arr AS $eachoption) {
            echo "<br>" . $eachoption['option_name'];
            //getting the value of the option assigned
            $query_option_value = "SELECT value FROM " . $tableprefix . "product_option_values WHERE product_option_id = :product_option_id AND option_id = :option_id";
            $query_option_valueQ = $pdo->pdoQuery($query_option_value, array("product_option_id" => $otherOptionObj->product_option_id, "option_id" => $eachoption['option_id']))->results();
            $option_value_obj = (object)($query_option_valueQ[0]);
            ?>
                                                                        <input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $option_value_obj->value; ?>">
            <?php
        }
    }
    ?>
                                                            </span>
                                                        </td>
                                                        <td><input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $otherOptionObj->additional_price; ?>" class="jqPrice"></td>
                                                        <td><input type="text" name="product_stock[]" id="product_stock[]" value="<?php echo $otherOptionObj->product_stock; ?>"></td>
                                                        <td><input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $otherOptionObj->reorder_level; ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <th><?php echo BIG_IMG; ?>&nbsp;</th>
                                                        <th><?php echo SMALL_IMG; ?>&nbsp;</th>
                                                        <th><?php echo DISCOUNT_PERC; ?></th>
                                                        <th><?php echo DISCOUNT_DESC; ?></th>
                                                    </tr>
                                                                <?php
                                                                $image_small = "";
                                                                $image_big = "";
                                                                $product_image_path = "../products/";
                                                                if ($otherOptionObj->image_small != "") {
                                                                    if (strstr($otherOptionObj->image_small, "http://")) {
                                                                        $image_small = $otherOptionObj->image_small;
                                                                    } else {
                                                                        $image_small = $product_image_path . $otherOptionObj->image_small;
                                                                    }
                                                                }
                                                                if ($otherOptionObj->image_big != "") {
                                                                    if (strstr($otherOptionObj->image_big, "http://")) {
                                                                        $image_big = $otherOptionObj->image_big;
                                                                    } else {
                                                                        $image_big = $product_image_path . $otherOptionObj->image_big;
                                                                    }
                                                                }
                                                                ?>
                                                    <tr valign="top">
                                                        <td>
                                                            <input type="file" name="image_big[]" id="image_big[]" value="" onchange="showBigImages(this.files, '<?php echo $k ?>',this);">
    <?php
    if ($image_big != "") {
        ?>
                                                                <img src="<?php echo $image_big ?>" id="big_img_preview_<?php echo $k ?>" border="0" width="183" height="191">
        <?php
    }
    ?>
                                                        </td>
                                                        <td>
                                                            <input type="file" name="image_small[]" id="image_small[]" value="" onchange="showSmallImages(this.files, '<?php echo $k ?>',this);">
                                                    <?php
                                                    if ($image_small != "") {
                                                        ?>
                                                                <img src="<?php echo $image_small ?>" border="0" width="183" height="191" id="small_img_preview_<?php echo $k ?>">
                                                        <?php
                                                    }
                                                    ?>
                                                        </td>

                                                        <td><input type="text" name="discount[]" id="discount[]" value="<?php echo $otherOptionObj->discount; ?>"></td>
                                                        <td><input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo stripslashes($otherOptionObj->discount_description); ?>"></td>
                                                    </tr>
                                                    <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                        <th><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></th>
                                                        <th><?php echo LENGTH; ?> (<?php echo CM; ?>) </th>
                                                        <th><?php echo WIDTH; ?> (<?php echo CM; ?>) </th>
                                                        <th><?php echo HEIGHT; ?> (<?php echo CM; ?>) </th>
                                                    </tr>
                                                    <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                        <td><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $otherOptionObj->product_shipping_weight; ?>"></td>
                                                        <td><input type="text" name="product_length[]" id="product_length[]" value="<?php echo $otherOptionObj->product_length; ?>"></td>
                                                        <td><input type="text" name="product_width[]" id="product_width[]" value="<?php echo $otherOptionObj->product_width; ?>"></td>
                                                        <td><input type="text" name="product_height[]" id="product_height[]" value="<?php echo $otherOptionObj->product_height; ?>">&nbsp;<img border="0" title="Delete Option" src="../images/btn_del.gif" alt="Delete Option" class="delete_option" onclick="javascript:delete_option(this);"></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                                            <?php
                                                        }
                                                        ?>

                                                        <?php
                                                        for ($i = 1; $i < $options_count; $i++) {

                                                            if ($_POST['product_option_id'] == "") {
                                                                ?>
                                            <tr class="option_block">
                                                <td>
                                                    <table cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC">
                                                        <tr>
                                                            <th><?php echo DEFAULT_OPT; ?></th>
                                                            <th><?php echo ADD_PRICE; ?>&nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th>
                                                            <th><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></th>
                                                            <th><?php echo REORDER_LEVEL; ?>&nbsp;</th>
                                                        </tr>
        <?php
        $dchecked = "";
        if ($_POST['default_option'][$i] == "1") {
            $dchecked = "checked";
        }
        ?>
                                                        <tr>
                                                            <td>
                                                                <span class="default_setting_box">
                                                                    <input type="radio" name="default" id="default" onclick="setDefaultOption(this);" <?php echo $dchecked ?>>
                                                                    <input type="hidden" name="product_option_id[]" value="">
                                                                    <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $_POST['default_option'][$i] ?>">
        <?php
        $options_arr = getOptionsFromCategory($ddlCategory);
        $num_of_options = count($options_arr);
        if ($num_of_options != "") {
            foreach ($options_arr AS $eachoption) {
                echo "<br><br>" . $eachoption['option_name'];
                ?>
                                                                            <input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $_POST['option_' . $eachoption['option_id']][$i]; ?>">
                                                    <?php
                                                }
                                            }
                                            ?>
                                                                </span>
                                                            </td>
                                                            <td><input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $_POST['additional_price'][$i] ?>" class="jqPrice jQNumeric"></td>
                                                            <td><input type="text" name="product_stock[]" id="product_stock[]" value="<?php echo $_POST['product_stock'][$i] ?>" class="jQNumeric"></td>
                                                            <td><input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $_POST['reorder_level'][$i] ?>" class="jQNumeric"></td></tr>
                                                        <tr>
                                                            <th><?php echo BIG_IMG; ?>&nbsp;;<span class="required">*</span></th>
                                                            <th><?php echo SMALL_IMG; ?>&nbsp;</th>
                                                            <th><?php echo DISCOUNT_PERC; ?></th>
                                                            <th><?php echo DISCOUNT_DESC; ?></th></tr>
                                                        <tr>
                                                            <td><input type="file" name="image_big[]" id="image_big[]" onchange="showBigImages(this.files,'<?php echo $i ?>',this)" value="<?php echo $_POST['image_big'][$i] ?>">
                                                                <img src="" style="display:none" width="183" height="191" id="big_img_preview_<?php echo ($i - 1) ?>"></td>
                                                            <td><input type="file" name="image_small[]" id="image_small[]" onchange="showSmallImages(this.files,'<?php echo $i ?>',this)" value="<?php echo $_POST['image_small'][$i] ?>">
                                                                <img style="display:none" src="" id="small_img_preview_<?php echo $i ?>" border="0" width="183" height="191"></td>
                                                            <td><input type="text" name="discount[]" id="discount[]" value="<?php echo $_POST['discount'][$i] ?>" class="jQNumeric"></td>
                                                            <td><input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo stripslashes($_POST['discount_description'][$i]) ?>"></td>
                                                        </tr>
                                                        <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                            <th><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></th>
                                                            <th><?php echo LENGTH; ?></th>
                                                            <th><?php echo WIDTH; ?></th>
                                                            <th><?php echo HEIGHT; ?></th>
                                                        </tr>
                                                        <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                            <td><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $_POST['product_shipping_weight'][$i] ?>" class="jQNumeric"></td>
                                                            <td><input type="text" name="product_length[]" id="product_length[]" value="<?php echo $_POST['product_length'][$i] ?>" class="jQNumeric"></td>
                                                            <td><input type="text" name="product_width[]" id="product_width[]" value="<?php echo $_POST['product_width'][$i] ?>" class="jQNumeric"></td>
                                                            <td><input type="text" name="product_height[]" id="product_height[]" value="<?php echo $_POST['product_height'][$i] ?>" class="jQNumeric">&nbsp;<img border="0" title="Delete Option" src="../images/btn_del.gif" alt="Delete Option" class="delete_option" onclick="javascript:delete_option(this);"></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
        <?php
    }//end of if
}//end of for
?>

                                </table>
                            </td>
                        </tr>
<?php
$options_arr = getOptionsFromCategory($ddlCategory);
$num_of_options = count($options_arr);
if ($num_of_options >= 1) {
    ?>
                            <tr>
                                <td></td>
                                <td colspan="2" align="left">
                                    <input type="button" name="add_more_options" value="<?php echo ADD_OPTIONS; ?>" id="add_more_options"/>
                                    <input type="hidden" name="add_value" id="add_value" value="<?php echo ($num_of_options - 1); ?>">
                                </td>
                            </tr>
    <?php
}
?>
                        <tr>
                            <td><?php echo MORE_IMG; ?> (jpg/gif/png)</td>
                            <td colspan="3">
<?php
$moreImages = array();
$moreImagesql = "SELECT nproduct_image_id, nimage_productid,
                        vimage_name, vimage_description, vproduct_image_delete_status
                   FROM " . $tableprefix . "product_view_images
                  WHERE nimage_productid= :productid";

$result = $pdo->pdoQuery($moreImagesql, array("productid" => $productid))->results();
if (count($result) != 0) {
    foreach ($result as $imRow) { $imRow = (object)$imRow;
        $moreImages[] = array('Name' => $imRow->vimage_name, "ID" => $imRow->nproduct_image_id);
    }
}

$moreImageMaxLImit = getSettingsValue('more_image_limit');
if ($moreImageMaxLImit > 0) {
    for ($iCount = 0; $iCount < $moreImageMaxLImit; $iCount++) {
        ?>
                                        <div class="jqMoreImageContainer brd_pc_stls" style="padding:5px;border:0px solid #D3D1D1;margin:10px; position:relative; float:left;width:200px;">
                                <?php
                                if (array_key_exists($iCount, $moreImages)) {
                                    if (strstr($moreImages[$iCount]['Name'], "http://")) {
                                        $image = $moreImages[$iCount]['Name'];
                                    } else {
                                        $image = '../products/' . $moreImages[$iCount]['Name'];
                                    }
                                    ?>
                                                <div class="jqMoreImagefromDb_<?php echo $iCount ?>">      
                                                    <div style="width:22px; position:absolute; top:18px; left:16px; height:22px;">
                                                        <a href="<?php echo $image; ?>" class="jqMoreImageZoom thickbox"><img border="0" src="../images/srh_btn.png" title="Zoom" /></a>
                                                    </div>
                                                    <div style="width:22px; position:absolute; top:18px; right:26px; height:22px;">
                                                        <a href="javascript:;" class="jqMoreImageDelete" ><img border="0" src="../images/dlt_btn.png" title="delete this image" /></a>
                                                    </div>

                                                    <img   class="jqMoreImage mn_pcs" src="<?php echo $image; ?>" height="180"/>  <br/>
                                                </div>                 
                                            <?php
                                        }
                                        ?>                              <div style="width:180px;float:left;margin-bottom: 4px;">
                                                <input class="jqMoreImageFile" type="file" name="productMoreImage[]"  onchange="showMyImage(this.files, 'more_img_preview_<?php echo $iCount ?>', '<?php echo $iCount ?>', this)"/>
                                                <img style="display:none" src="" id="more_img_preview_<?php echo $iCount ?>" border="0" width="183" height="191">
                                                <input class="jqMoreImageName" type="hidden" name="productMoreImageName[]" value="<?php echo $moreImages[$iCount]['Name'] ?>"/>
                                                <input class="jqMoreImageID" type="hidden" name="productMoreImageID[]" value="<?php echo $moreImages[$iCount]['ID'] ?>"/>
                                            </div> 
                                        </div>
                                        <?php
                                    }
                                }
                                ?>

                            </td>
                        </tr>

                        <!--Digital Product Block Ends
                        <tr>
                                <td>Product Images [Bulk Upload]</td>
                                <td></td>
                                <td><a style="cursor:pointer" href="product_viewimages_add.php" title="Bulk Upload"><img src="../images/bulk_upload.jpg" border="0"></a>
                                <input type="hidden" name="enable_canadapost" value="<?php echo $chkcanship; ?>">
                                </td>
                                        </tr>-->
                        <tr><td colspan="3">

                                <table cellpadding="2" cellspacing="2" border="0" width="100%">
                                    <tr>
                                        <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo TXT_SMALL_IMG; ?>  -  400  X 300 </strong></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo TXT_BIG_IMG; ?> - 500 X 350 </strong></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo TXT_CP; ?> </strong></td>
                                    </tr>
                                </table>

                            </td></tr>
                        <tr><td colspan="3" align="center">
                                <input type="hidden" name="product_name_old" value="<?php echo $txtProductName; ?>">
                                <input type="submit" value="<?php echo BTN_SAVE_CHANGES; ?>" name="btnSaveChanges" class="button">&nbsp;&nbsp;
                                <input type="submit" class="button" value="<?php echo DELETE; ?>" name="btnDelete" onClick="return confirmDelete();" >&nbsp;&nbsp;
                                <input type="button" class="button" value="<?php echo BACK_CAT; ?>" name="btnBack" onClick="window.location.href = 'catalog.php?catid=<?php echo $ddlCategory ?>';" >&nbsp;&nbsp;
                                <input type="button" class="button" value="<?php echo BACK_PDT_LIST; ?>" name="btnBack" onClick="window.location.href = 'listProducts.php?page=<?php echo $_GET['page'] ?>';" >
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3" align="left">
                                <div align="left" class="blackbartextCopy">
                                    <br>
                                    <br>
                                    <br>
                                </div>
                            </td>
                        </tr>
                        </table>
                    </form>
                </div>
                <!--content area end-->
            </div>
            <div align="left" class="clear_float"><img src="<?php echo $imagefolder; ?>/clear.gif" alt="" width="1" height="1" /></div>
            <!--main body end -->
        </div>
<?php
include "../includes/footer.php";
?>
