<?php
ob_start();
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include_once('../classes/cls_utils.php');
include_once('../classes/cls_store.php');
include_once('../classes/cls_products.php');

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
    $adminname = $_SESSION["sess_adminname"];
} else {
    header("Location:login.php");
    exit;
}


include "../includes/htmltop.php";

$artistlist = makeArtistList();

if (isset($_POST['add'])) {


    /* check whether gift coupon with the same name exists in the database */



    $select_coupon = "SELECT * FROM " . $tableprefix . "products WHERE LOWER(product_name) =:couponname ";

      $result_coupon = $pdo->pdoQuery($select_coupon,array('couponname'=>$_POST['txtGiftCouponName']))->result();  

  
    if (!empty($result_coupon)) {

        $message = GC_NAME_EXIST." !!";
    } else {

        $couponfiletype = $_FILES['txtCouponImage']['type'];
        $couponfilename = $_FILES['txtCouponImage']['name'];
        $coupontempname = $_FILES['txtCouponImage']['tmp_name'];

        if ($_FILES['txtCouponImage']['name'][0] != "") {
            if (!isValidWebImageType($couponfiletype, $couponfilename, $coupontempname)) {

                $message .= " * ".INVALID_IMG_FORMAT."<br>";
            } else {


                $imagewidth_height_type_array = explode(":", ImageTypeBanner($_FILES['txtCouponImage']['tmp_name']));
                $imagetype = $imagewidth_height_type_array[0];

                $assignedname_small = "gift_coupon_small" . time() . "." . $imagetype;

                $assignedname_large = "gift_coupon_large" . time() . "." . $imagetype;

                if (move_uploaded_file($_FILES['txtCouponImage']['tmp_name'], "../products/" . $assignedname_large)) {

                    chmod("../products/$assignedname_large", 0777);

                    /* taken from the general site settings table */

                    $gift_image_size = '400,400';
                    $gift_size = preg_split(',', $gift_image_size);

                    resizeImg("../products/" . $assignedname_large, 489, 328, false, 100, 0, "_thumb");

                    //generateThumbNail("../products/".$assignedname_large,"../products/".$assignedname_large,400,400);

                    @copy("../products/$assignedname_large", "../products/$assignedname_small");

                    resizeImg("../products/" . $assignedname_small, 387, 260, false, 100, 0, "_thumb");

                    //generateThumbNail("../products/".$assignedname_small,"../products/".$assignedname_small,120,150);
                    //$gift_coupon_code = "GC".randomGiftCouponKey();	

                      $coupon_row = $pdo->select($tableprefix.'categories',array('category_id'),array("gift_certificate_flag"=>'Y'))->result();
                    
                   
                    //Generate Alias name for product
                    $aliasname = Utils::generateAlias($tableprefix . "products", $_POST['txtGiftCouponName']);

                    $sellerCartObj      =    Store::get_seller_account_info($_POST['ddlArtist']);
//echopre($sellerCartObj);
                    if($sellerCartObj->status==SUCCESS)
                            {
                                 $sellerCartObjVal      =   $sellerCartObj->data;
                                 $seller_vacation_mode  =   $sellerCartObjVal->is_vacation_mode;
                            }

     $date =  date('Y-m-d');                       

    $data =  array("product_name"=>$_POST['txtGiftCouponName'],
                    "product_code"=>$_POST['txtGiftCouponCode'],
                    "product_description"=>$_POST['txtCouponDescription'],
                    "product_price"=>$_POST['txtCouponDescription'],
                    "product_artist_id"=>$_POST['ddlArtist'],
                    "product_category"=>$coupon_row['category_id'],
                    "date_added"=>$date,
                    "deleted"=>'N',
                    "vapproved"=>'Y',
                    "payment_status"=>'COMPLETED',
                    "alias"=>$aliasname,
                    "vdigital_product"=>'N',
                    "publish_status"=>'Y',
                    "allow_free_shipping"=>'N',
                    "seller_vacation_mode"=>$seller_vacation_mode
                    );
                    
$insert_id  = $pdo->insert($tableprefix."products",$data)->lastInsertId();


    $options = array("product_id"=>$insert_id,
                       "product_stock"=>$_POST['txtCouponStock'],
                       "reorder_level"=>$_POST['txtStockReorder'],
                       "image_small"=>$assignedname_small,
                       "image_big"=>$assignedname_large,
                       "default_option"=>'YES');

    $insert_options_id  = $pdo->insert($tableprefix."product_options",$options)->lastInsertId(); 

    $coupon = array("ngift_product_id"=>$insert_id,
                    "ngift_coupon_amount"=>$_POST['txtCouponAmount'],
                    "vgift_currency"=>'USD',
                    "vgift_delete_status"=>'N');    


$insert_gift_id  = $pdo->insert($tableprefix."giftcoupon_master",$coupon)->lastInsertId(); 
                                  
        //Scalabity Modifications for Gift Certificates

            $objDefaultOptionVo                                     =    new stdClass();
            $objOptionVo                                            =    Products::getProduct_Default_Option_Values($insert_id);
            $objDefaultOptionVo->default_image_small                =   $objOptionVo->image_small;
           // $objDefaultOptionVo->default_stock                      =   $objOptionVo->product_stock;
            $objDefaultOptionVo->default_additional_price           =   $objOptionVo->additional_price;
            $objDefaultOptionVo->default_shipping_weight            =   $objOptionVo->product_shipping_weight;
            $objDefaultOptionVo->default_discount                   =   $objOptionVo->discount;
            $objDefaultOptionVo->default_discount_description       =   $objOptionVo->discount_description;
            $objDefaultOptionVo->default_option_id                  =   $objOptionVo->product_option_id;
            $objDefaultOptionVo->product_id                         =   $insert_id;
            // Save default option values to product table
            $productinfoUpdate                                      =   Products::updateProduct_Default_Option_Value($objDefaultOptionVo);

                    header('Location:gift_coupon.php?msg='.GC_ADD_SUCCESS);
                }
            }
        }
    }
}
?>
<script>
    function checkAddCouponForm()
    {

        var form_name = new Array('txtGiftCouponName','txtGiftCouponCode','txtCouponImage','txtCouponAmount','ddlArtist');		
        var display_name = new Array('<?php echo GC_NAME;?>','<?php echo GC_CODE;?>','<?php echo GC_IMAGE;?>','<?php echo GC_AMOUNT;?>','<?php echo SELLER;?>');
        var count = 5;	

        if(check_fields('frmAddGiftCoupon',form_name,display_name,count))	
        {
            var Couponstock   =    parseInt($('#txtCouponStock').val());

            var reOrder   =    parseInt($('#txtStockReorder').val());

            if(reOrder > Couponstock)
            {
	 
                alert("<?php echo STOCK_REORDR_ERROR_MSG;?>");
                document.frmAddGiftCoupon.txtStockReorder.focus();
                return false;		 
	 
            }
            if(!check_numeric(trimSpaces(document.frmAddGiftCoupon.txtCouponAmount.value)))
            {
	 
                alert("<?php echo PLS_NUMBER;?>");
                document.frmAddGiftCoupon.txtCouponAmount.focus();
                return false;		 
	 
            }
   
        }
        else
        {
  
            return false;
  
        }
   
    }

</script>

<body>

<center>

    <div align="left" id="layout">




        <!--header area start -->
        <?php
        include_once("../includes/topheader_admin.php")
        ?>

        <!--header area end -->




        <div align="left" class="main_body">
            <!--main body start -->



            <?php
            include_once("../includes/admintopmenu.php")
            ?>		


            <div align="left" class="content_area">

                <!--content area start -->

                <div align="left" class="page_title"><?php echo ADD_GIFT;?> </div>
                <div align="center" class="text_information grey_tr"><?php echo $message ?></div>
                <br>

                <div align="left">									

                    <form name="frmAddGiftCoupon" action="#" method="POST" enctype="multipart/form-data" onSubmit="return checkAddCouponForm();">

                        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="manage_table">

                            <tr><td colspan="3">&nbsp;</td></tr>

                            <tr><td colspan="3" align="right"><span class="required">*</span>&nbsp;<?php echo FIELDS_ARE_MANDATORY;?></td></tr>
                            <tr><td width="21%" align="left" valign=top><?php echo GC_NAME;?>&nbsp;<span class="required">*</span></td><td width="2%" >&nbsp;</td>
                                <td width="77%" align="left" valign=top><input class="textarea2"  type="text" name="txtGiftCouponName" value="<?php echo stripslashes($_POST['txtGiftCouponName']); ?>" size="25" maxlength="150"></td>
                            </tr>
                            <tr><td width="21%" align="left" valign=top><?php echo GC_CODE;?>&nbsp;<span class="required">*</span></td><td width="2%" >&nbsp;</td>
                                <td width="77%" align="left" valign=top><input class="textarea2" type="text" name="txtGiftCouponCode" value="<?php echo stripslashes($_POST['txtGiftCouponCode']); ?>" size="25" maxlength="20"></td>
                            </tr>
                            <tr>
                                <td align="left" valign=top><?php echo DESCRIPTION;?>&nbsp;</td>
                                <td >&nbsp;</td>
                                <td valign=top align="left">
                                    <textarea name="txtCouponDescription" rows="8" cols="30" class="textarea2"><?php echo stripslashes($_POST['txtCouponDescription']); ?></textarea>
                                </td>
                            </tr>
                            <tr><td align="left" valign=top><?php echo CERT_IMAGE;?>&nbsp;<span class="required">*</span></td><td >&nbsp;</td>
                                <td valign=top align="left"><input type="file" name="txtCouponImage">
                                    &nbsp;<b><?php echo FILE_TYPES;?></b>: <?php echo JPG_GIF_PNG;?> &nbsp; <b><?php echo SIZE;?></b>: 500 x 350</td>
                            </tr>
                            <tr><td align="left" valign=top><?php echo CERT_AMOUNT;?>&nbsp;<span class="required">*</span></td><td >&nbsp;</td>
                                <td valign=top align="left"><input type="text" name="txtCouponAmount" class="textarea2" value="<?php echo stripslashes($_POST['txtCouponAmount']); ?>">&nbsp;<b><?php echo $adminCurrency['currency_code']; ?> </b></td>
                            </tr>
                            <tr>
                                <td align="left" valign=top><?php echo SELLER;?>&nbsp;<span class="required">*</span></td><td >&nbsp;</td>
                                <td align="left">
                                    <?php $ddlArtist = $_POST['ddlArtist'] ?>

                                    <?php echo makeDropDownList("ddlArtist", $artistlist, $ddlArtist, false, 'textarea', $properties, $behaviors) ?></td>
                            </tr>
                            <tr><td align="left" valign=top><?php echo STOCK_AVAILABLE;?>&nbsp;<span class="required">*</span></td>
                                <td>&nbsp;</td>
                                <td valign="top" align="left">
                                    <select name="txtCouponStock" class="textarea2" id="txtCouponStock">
                                        <?php
                                        for ($i = 1; $i <= 50; $i++) {
                                            ?>										
                                            <option value="<?php echo $i ?>" <?php
                                        if ($_POST['txtCouponStock'] == $i) {
                                            echo SELECTED;
                                        }
                                            ?>><?php echo $i ?></option>								

                                            <?php
                                        }
                                        ?>									
                                    </select>			
                                </td>
                            </tr>
                            <tr><td align="left" valign=top><?php echo STOCK_REORDER_LEVEL;?>&nbsp;<span class="required">*</span></td>
                                <td>&nbsp;</td>
                                <td valign="top" align="left">
                                    <select name="txtStockReorder" class="textarea2" id="txtStockReorder">
                                        <?php
                                        for ($i = 1; $i <= 50; $i++) {
                                            ?>										
                                            <option value="<?php echo $i ?>" <?php
                                        if ($_POST['txtStockReorder'] == $i) {
                                            echo SELECTED;
                                        }
                                            ?>><?php echo $i ?></option>								

                                            <?php
                                        }
                                        ?>									
                                    </select>
                                    <b><?php echo STOCK_REORDR_MSG;?>.</b>			
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3" align="center">
                                    
                                    <input type="button" class="button" name="back" value="&nbsp;<?php echo BACK;?>&nbsp;" onClick="Javascript:history.go(-1)">
                                    <input type="submit" value="&nbsp;<?php echo ADD_TEXT;?>&nbsp;" name="add" class="button">
                                </td>
                            </tr>
                            <tr><td colspan="3">&nbsp;</td></tr>
                        </table>

                    </form>

                </div>

                <!--content area end-->

            </div>


            <div align="left" class="clear_float"><img src="<?php echo $imagefolder; ?>/clear.gif" alt="" width="1" height="1" /></div>
            <!--main body end -->
        </div>


        <?php
        include "../includes/footer.php";

        ob_end_flush();
        ?>