<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>                            |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";

if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
    $adminname = $_SESSION["sess_adminname"];
} else {
    header("Location:login.php");
    exit;
}

if (isset($_GET["txtSearch"]) and $_GET["txtSearch"] != "") {
    $txtSearch = $_GET["txtSearch"];
    $cmbSearchType = $_GET["cmbSearchType"];
} else if (isset($_POST["txtSearch"]) and $_POST["txtSearch"] != "") {
    $txtSearch = $_POST["txtSearch"];
    $cmbSearchType = $_POST["cmbSearchType"];
}

if (isset($_POST['gotoPage'])) {
    header("Location:" . $_SERVER['PHP_SELF'] . "?page=" . $_POST['gotoPage']);
}

$qryopt = "";
$qryoptArr=array();
if (isset($_POST['cmbSearchType']) && $_POST['cmbSearchType'] != "all") {
    $qryopt = " WHERE product_id = :cmbSearchType";
    $qryoptArr['cmbSearchType']=$_POST['cmbSearchType'];
}

$sql = " SELECT product_name,product_id, sum(product_quantity) AS purchase_count
        FROM " . $tableprefix . "order_details " . $qryopt . " GROUP BY product_id ORDER BY product_name";

if (!(isset($pagenum))) {
    $pagenum = 1;
}

$limit = getSettingsValue('npagination_limit');
$page = isset($_GET['page']) ? trim($_GET['page']) : 1;

if (empty($page)) {
    $page = 1;
}

$result = $pdo->pdoQuery($sql,$qryoptArr)->results();
$totalrows = count($result);
$limitvalue = ($page - 1) * $limit;
$query_string = " LIMIT $limitvalue, $limit";

$sql = $sql . $query_string;
$rs = $pdo->pdoQuery($sql,$qryoptArr)->results();
$numofpages = ceil($totalrows / $limit);

include "../includes/htmltop.php";
?>
<script language="JavaScript" type="text/JavaScript">
    function clickSearch() {
        document.frmProductPurchased.submit();
    }
</script>

<body>
<center>

    <div align="left" id="layout">

        <?php include_once("../includes/topheader_admin.php"); ?>

        <div align="left" class="main_body">

            <?php include_once("../includes/admintopmenu.php"); ?>      

            <div align="left" class="content_area">
                <div align="left" class="page_title"><?php echo PPR;?></div>
                <div align="center" class="text_information grey_tr"><?php echo $message ?></div>
                <br>

                <div align="left">

                    <form action="" method="post" name="frmProductPurchased">
                        <table width="100%" border="0" cellpadding="0" cellspacing="0">
                            <tr><td height="35"><?php include_once("../includes/reportmenu.php") ?></td>

                            </tr>
                            <tr>
                                <td width="100%" align=left valign="baseline" class=""><?php echo PRODUCT;?> ::
                                    <select name="cmbSearchType" class="textarea">
                                        <option value="all"><?php echo ALL_PRODUCTS;?></option>
                                        <?php
                                        $select_product = "SELECT ord.product_id,ord.product_name  FROM " . $tableprefix . "order_details ord  GROUP BY ord.product_id ORDER BY ord.product_name ASC";
                                        $result_product = $pdo->pdoQuery($select_product,"")->results();

                                        if (count($result_product) != 0) {
                                            foreach ($result_product as $product_row) {
                                                if ($product_row['product_id'] == $_POST['cmbSearchType']) {
                                                    $product_checked = "selected";
                                                } else {
                                                    $product_checked = "";
                                                }
                                                ?>      
                                                <option value="<?php echo $product_row['product_id'] ?>" <?php echo $product_checked ?>><?php echo stripslashes($product_row['product_name']) ?></option>
                                                <?php
                                            }
                                        }
                                        ?>      
                                    </select>
                                    &nbsp;
                                    <a onClick="return clickSearch();" class="search_button"><?php echo BTN_SEARCH; ?></a>
                                </td>
                            </tr>
                        </table>
                    </form>
                </div>

                <div align="left">
                    <form action="" method="post" name="frmProductPurchased1">
                        <table width="970" border="0" cellpadding="0" cellspacing="0" class="manage_table">
                            <tr class="page_title2">
                                <th width="37" align="left">#</th>
                                <th width="232" align="left"><?php echo PRODUCT_NAME;?></th>
                                <th width="379" align="left"><?php echo QTYS;?></th>
                                <th width="322" align="left"><?php echo NO_ORD;?></th>
                            </tr>
                            <?php
                            $i = 1;

                            if (count($result) > 0) {
                                foreach ($rs as $row) {
                                    $sql_orders = " SELECT COUNT(order_id) AS no_of_orders FROM ( SELECT order_id
                                                    FROM " . $tableprefix . "order_details WHERE product_id = product_id GROUP BY order_id ) AS tbl_no_orders";

                                    $res_orders = $pdo->pdoQuery($sql_orders,array("product_id"=>$row["product_id"]))->results();
                                    $res_ordersObj = ($res_orders[0]);
                                    ?>
                                    <tr>
                                        <td><?php echo (($page * $limit) + $i - $limit) ?></td>
                                        <td align="left"><?php echo (stripslashes($row["product_name"])) ?></td>
                                        <td align="left"><?php echo $row["purchase_count"]; ?></td>
                                        <td align="left"><?php echo $res_ordersObj['no_of_orders']; ?></td>
                                    </tr>
                                    <?php
                                    $i++;
                                }
                            } else {
                                ?>

                                <tr>
                                    <td align="center" valign="middle" colspan="5" class="text_information"><?php echo NO_RECORDS_FOUND;?> !!</td>
                                </tr>
                            </table>

                            <?php
                        }

                        if ($page > 1) {
                            $pageprev = $page - 1;
                            $previous_page = "<a href=" . $_SERVER['PHP_SELF'] . "?page=$pageprev alt='Previous' border='0' class='small_gray_button'>".TEXT_PREV."</a>";
                        }

                        if ($page < $numofpages) {
                            $pagenext = ($page + 1);
                            $next = "<a href=" . $_SERVER['PHP_SELF'] . "?page=$pagenext alt='Next' border='0' class='small_gray_button'>".TEXT_NEXT."</a>";
                        }

                        if ($page < $numofpages || $page > 1) {  ?>
                            <tr>    
                                <td class="page_nos" colspan="4" align="center">
                                    <table width="100%" border="0" cellspacing="10" cellpadding="0">
                                        <tr align="left" valign="middle">
                                            <td width="21%" align="right"><?php echo $previous_page ?></td>
                                            <td width="23%" align="right">
                                                <?php echo PAGE."(".S.")";?> <?php echo $page ?>/<?php echo $numofpages ?>&nbsp;&nbsp;
                                                <?php echo GO_TO;?>
                                            </td>
                                            <td width="8%" align="right">
                                                <select class="textarea2" name="gotoPage" style="padding:4px 5px; margin-bottom:1px; ">
                                                    <?php
                                                    for ($i = 1; $i <= $numofpages; $i++) {
                                                    if ($i == $_GET['page']) {
                                                    $page_selected = "selected";
                                                    } else {
                                                    $page_selected = "";
                                                    }
                                                    ?>                                  
                                                    <option value="<?php echo $i ?>" <?php echo $page_selected ?>><?php echo $i ?></option>
                                                    <?php
                                                    }
                                                    ?>                                  
                                                </select>
                                            </td>
                                            <td width="7%">
                                                <a onClick="Javascript:document.frmProductPurchased1.submit();" class="go_button_2"><?php echo GO; ?></a>
                                            </td>
                                            <td width="41%" align="center"><?php echo $next ?></td>
                                        </tr>
                                    </table>
                                </td>
                                </tr>
                            <?php
                                }
                            ?>
                        </table>
                    </form>                                         
                </div>
            </div>

            <div align="left" class="clear_float"><img src="<?php echo $imagefolder; ?>/clear.gif" alt="" width="1" height="1" /></div>
        </div>

        <?php
        include "../includes/footer.php";
        ?>


