<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of User class
 * Use for user relarated functionlities
 * @author Asha
 */
class User {

    //put your code here

    public static function is_seller_account_activated($buyerId) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        if (!empty($buyerId)) {
            $whereConditions = array('user_id' => $buyerId);
            $result = $pdo->select($tableprefix . 'users', array('is_seller', 'seller_id'), $whereConditions)->results();
            if (!empty($result[0])) {
                $objResult->status = SUCCESS;
                $objResult->data = $result[0]; // Assign user record  to object
            } else {
                $objResult->status = ERROR;
            }
        }
        return $objResult;
    }

    // Check product already added to favourites list
    public static function user_favourites_count($userID, $productID, $productOptionID) {
        global $tableprefix, $pdo;
        $favourites_count = 0;
        if (!empty($productOptionID)) {
            $QueryWishItems = "SELECT count(f.nId) as favouritesCount
                FROM " . $tableprefix . "favourites f
                INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = f.nProductOptionId
                INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
                WHERE f.nUserId =:nUserId AND f.nProductId = :productID AND f.nProductOptionId = :nProductOptionId ";
            $resSet = $pdo->pdoQuery($QueryWishItems, array("nUserId" => $userID, "productID" => $productID, "nProductOptionId" => $productOptionID))->results();
            if (!empty($resSet))
                $favourites_count = $resSet[0]['favouritesCount'];
            else
                $favourites_count = 0;
        }
        return $favourites_count;
    }

    //Function to Insert Favourites details 

    public static function add_to_favourites_list($objProductVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $dataArray = array('nProductId' => $objProductVo->nProductId,
            'nProductOptionId' => $objProductVo->nProductOptionId,
            'nUserId' => $objProductVo->nUserId,
            'seller_id' => $objProductVo->seller_id,
            'dDate' => $objProductVo->dDate);
        $favouriteId = $pdo->insert($tableprefix . "favourites", $dataArray)->lastInsertId();
        if ($favouriteId) {
            $objResult->status = SUCCESS;
            $objResult->data = $favouriteId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // function to delete user favourites list 
    public static function delete_user_favourite_list($wishId, $userid) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $affectedRows = $pdo->delete($tableprefix . "favourites", array("nId" => $wishId, "nUserId" => $userid))->affectedRows();
        if ($affectedRows > 0) {
            $objResult->status = SUCCESS;
            $objResult->data = $affectedRows;
        } else {
            $objResult->status = ERROR;
        }
        return $objResult;
    }

    //  // Check seller  already added to favourites list
    public static function seller_favourites_count($userID, $sellerID) {
        global $tableprefix, $pdo;

        $favourites_count = 0;

        if (!empty($userID)) {
            $resSet = $pdo->select($tableprefix . "seller_favourites", array("count(nId) as favouritesCount"), array("nUserId" => $userID, "nSellerId" => $sellerID))->results();
            if (!empty($resSet))
                $favourites_count = $resSet[0]['favouritesCount'];
            else
                $favourites_count = 0;
        }
        return $favourites_count;
    }

    //Function to Insert seller Favourites details

    public static function add_seller_to_favourites_list($objProductVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $dataArray = array('nSellerId' => $objProductVo->nSellerId,
            'nUserId' => $objProductVo->nUserId, 'dDate' => $objProductVo->dDate);
        $sellerfavouriteId = $pdo->insert($tableprefix . "seller_favourites", $dataArray)->lastInsertId();
        if ($sellerfavouriteId) {
            $objResult->status = SUCCESS;
            $objResult->data = $sellerfavouriteId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

// Total seller favourites count 
    public static function total_seller_favourites_count($userID) {
        global $tableprefix, $pdo;

        $favourites_count = 0;

        if (!empty($userID)) {
            $data = $pdo->select($tableprefix . "seller_favourites", array('count(nId) as favouritesCount'), array('nUserId' => $userID))->results();
            $favourites_count = $data[0]['favouritesCount'];
        }

        return $favourites_count;
    }

    //
    // Total product  favourites count
    public static function total_product_favourites_count($userID) {
        global $pdo;
        global $tableprefix;
        $count = 0;
        if (!empty($userID))
            $count = $pdo->count($tableprefix . "favourites", "nUserId ='" . $userID . "'");
        return $count;
    }

    // function to delete seller  favourites list of a selected user

    public static function delete_favourite_seller_list($wishId, $userid) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        $affectedRows = $pdo->delete($tableprefix . "seller_favourites", array("nId" => $wishId, "nUserId" => $userid))->affectedRows();
        if ($affectedRows > 0) {
            $objResult->status = SUCCESS;
            $objResult->data = $affectedRows;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    public static function getUserInfo($userid) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        if (!empty($userid)) {
            $objResultRow = $pdo->select($tableprefix . "users", '', array('user_id' => $userid))->results();

            if (!empty($objResultRow)) {
                $objResult->status = SUCCESS;
                $objResult->data = $objResultRow[0]; // Assign user record  to object
            } else {
                $objResult->status = ERROR;
            }
        }
        return $objResult;
    }

    //
    // Update user seller account status 

    public static function  updateSellerAccountActivation($userObjVo) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        $userId = $pdo->update($tableprefix . 'users', array('is_seller' => 'Y', 'seller_id' => $userObjVo->sellerid), array('user_id' => $userObjVo->userid))->affectedRows();
        if ($userId) {
            $objResult->status = SUCCESS;
            $objResult->data = $userId;
        } else {
            $objResult->status = ERROR;
        }
        return $objResult;
    }

    // Update Buyer Password
    public static function updateBuyerPassword($userObjVo) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        $buyerId = $pdo->update($tableprefix . 'users', array('password' => $userObjVo->password), array('user_id' => $userObjVo->buyer_id))->affectedRows();
        if ($buyerId) {
            $objResult->status = SUCCESS;
            $objResult->data = $buyerId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // check user account exists

    public static function getBuyerAccountExists($buyerId) {
        global $pdo;
        global $tableprefix;
        $selectFields = array('deleted');
        $whereConditions = array('user_id' => $buyerId);
        $result = $pdo->select($tableprefix . 'users', $selectFields, $whereConditions)->results();
        if ($result)
            return $result[0]['deleted'];
        else
            return '';
    }

    // Save user ip address and account details

    public static function saveUserIpInfo($objIpVO) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        $userId = $pdo->update($tableprefix . 'users', array('ip_address' => $objIpVO->ip_address, 'ip_location' => $objIpVO->ip_location), array("user_id" => $objIpVO->user_id))->affectedRows();
        if ($userId) {
            $objResult->status = SUCCESS;
            $objResult->data = $userId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // Select Distint Ip Adrrress

    public static function getAllIpAddress($ip) {
        global $tableprefix,$pdo;
        $objResult  = new stdClass();
        $selectCase =  '';
        
        $selectArr = array();
        if($ip!='') {
            $selectCase  =  "ip_address = :ip ";
            $selectArr['ip'] = $ip;
        } else {
            $selectCase =  "ip_address != :null  ";
            $selectArr['null'] = "NULL";
        }
        $sql = "select DISTINCT(ip_address) from ".$tableprefix."users where ".$selectCase;
        $objResultRows =  $pdo->pdoQuery($sql,$selectArr)->results();
        foreach($objResultRows as $row) {
            $objResultRow[] = (object)$row;
        }
        //DbHelper::selectResult($tableName,'DISTINCT(ip_address)',$selectCase);
        return $objResultRow;
    }

    public static function check_user_email_exists($email) {
        global $pdo, $tableprefix;
        $objResultRow = $pdo->select($tableprefix . "users", '', array("email" => $email))->results();
        return $objResultRow[0];
    }

    public static function check_user_name_exists($username) {
        global $pdo, $tableprefix;
        $objResultRow = $pdo->select($tableprefix . "users", '', array("user_name" => $username))->results();
        return $objResultRow[0];
    }

    public static function is_buyer_account_exists($artistid) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        if (!empty($artistid)) {
            $objResultRow = $pdo->select($tableprefix . "users", array("user_id"), array("seller_id" => $artistid))->results();
            if ($objResultRow) {
                $objResult->status = SUCCESS;
                $objResult->data = $objResultRow[0]; // Assign user record  to object
            } else {
                $objResult->status = ERROR;
            }
        }

        return $objResult;
    }

    public static function updateUserProfileInformation($userObjVo) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        $updateArray = array('first_name' => $userObjVo['first_name'],
            'last_name' => $userObjVo['last_name'],
            'address1' => $userObjVo['address1'],
            'address2' => $userObjVo['address2'],
            'city' => $userObjVo['city'],
            'state' => $userObjVo['state'],
            'country' => $userObjVo['country'],
            'zip' => $userObjVo['zip'],
            'email' => $userObjVo['email'],
            'phone' => $userObjVo['phone'],
            'fax' => $userObjVo['fax']);
        $sellerId = $pdo->update($tableprefix . 'users', $updateArray, array("user_id" => $userObjVo['user_id']))->affectedRows();
        if ($sellerId) {
            $objResult->status = SUCCESS;
            $objResult->data = $sellerId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

}

?>
