<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com  2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
include_once 'class.pager.php';
include_once 'classes/cls_cart.php';
include_once 'classes/cls_products.php';
//define("DIGITAL_FILE_TYPES",'gif,jpg,png,zip,pdf,rar,wma,psd,opf,azw,lit,pdb,pkg,mp3,mpeg,mp4,avi,3gp,act,aac,flac,m4a,m4p,mpc,wav,wv,ra,rm,tiff,mov,mxf');
$digital_product_types = array('gif', 'jpg', 'png', 'zip', 'pdf', 'rar', 'psd', 'opf', 'azw', 'lit', 'pdb', 'pkg', 'mp3', 'mpeg', 'mp4', 'avi', 'mpg', 'wma', '3gp', 'act', 'aac', 'flac', 'm4a', 'm4p', 'mpc', 'wv', 'ra', 'rm', 'tiff', 'mov', 'mxf');
$authorize_currencies = array('AUD', 'USD', 'CAD', 'EUR', 'GBP', 'NZD');

function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
    $theValue = (!get_magic_quotes_gpc()) ? addslashes($theValue) : $theValue;

    switch ($theType) {
        case "text":
            $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
            break;
        case "long":
        case "int":
            $theValue = ($theValue != "") ? intval($theValue) : "''";
            break;
        case "double":
            $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "''";
            break;
        case "date":
            $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
            break;
        case "defined":
            $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
            break;
    }
    return $theValue;
}

function getSellerCurrency($product_id) {
    global $tableprefix;

    $select_artist_currency = "SELECT cm.nexchange_price
							   FROM " . $tableprefix . "products prd
							   JOIN " . $tableprefix . "currency_master cm
							   JOIN " . $tableprefix . "artists art
							   WHERE cm.vcurrency_code = art.vseller_currency
							    AND prd.product_artist_id = art.artist_id
								AND prd.product_id = " . addslashes($product_id);


    $result_artist_currency = mysql_query($select_artist_currency) or die(mysql_error);

    if (mysql_num_rows($result_artist_currency) > 0) {
        $artist_row_currency = mysql_fetch_assoc($result_artist_currency);
    }
    $artist_row_currency['nexchange_price'];
    return $artist_row_currency['nexchange_price'];
}

//Select Dealer Name from dealer table



// end function

function getCurrencySybol($currencyid) {
    global $tableprefix, $pdo;
    $result_artist_currency = $pdo->select($tableprefix . "currency_master", array("vcurrency_symbol"), array("vcurrency_code" => $currencyid))->results();

    if (!empty($result_artist_currency)) {
        $artist_row_currency = $result_artist_currency[0];
    }
    return $artist_row_currency['vcurrency_symbol'];
}

function getCurrencyrate($currency) {
    global $tableprefix,$pdo;
    $result_artist_currency =$pdo->select($tableprefix."currency_master",array("nexchange_price"),array("vcurrency_code"=>$currency))->results();

    if (!empty($result_artist_currency)) {
        $artist_row_currency = $result_artist_currency[0];
    }
    return $artist_row_currency['nexchange_price'];
}


function getSellerCurrencySybol($artistID) {

    global $tableprefix, $pdo;

    $select_artist_currency = "SELECT vseller_currency
							   FROM " . $tableprefix . "artists
							   where artist_id= :artistID ";

    $result_artist_currency = $pdo->pdoQuery($select_artist_currency,array("artistID"=>$artistID))->results();

    if (count($result_artist_currency) > 0) {
        $artist_row_currency = ($result_artist_currency[0]);
    }
    return $artist_row_currency['vseller_currency'];
}

function is_number($str) {
    if (preg_match("/^[0-9]*\.?[0-9]+$/", $str) && !empty($str)) {
        return true;
    }
    return false;
}

function getPaginationLimit() {

    global $tableprefix, $pdo;
    $rs = $pdo->select($tableprefix . 'settings', 'npagination_limit')->results();

    if (!empty($rs[0])) {

        $limit = $rs[0]['npagination_limit'];
    } // end if
    else {

        $limit = 0;
    }

    return $limit;
}

// end function

/* ----------function to get the seller rating count--------------- */

function getSellerRating($rating_id, $seller_id) {
    global $tableprefix, $pdo;

    $select_rating = "SELECT COUNT(nrating_id) AS rating_count
					  FROM " . $tableprefix . "record_ratings
					   WHERE nrating_id = :rating_id AND nrseller_id = :seller_id";
    $result_rating = $pdo->pdoQuery($select_rating,array("rating_id"=>$rating_id, "seller_id"=>$seller_id))->results();

    if (count($result_rating) > 0) {
        $rating_count_row = ($result_rating[0]);
    }

    return $rating_count_row['rating_count'];
}

//=============================================================================

function ArrayKeyVal($arrVal, $chkVal) {
    foreach ($arrVal as $key => $val) {
        if ($chkVal == $val) {
            return ($key);
        }//end if
    }//end foreach
}

//end funciton

function CheckValue($Array) {
    foreach ($Array as $key => $val) {
        if ($key == 'mailservice') {
            return ($val);
        }//end if
    }//end foreach
}

//end funciton

function CheckValuePrice($Array) {
    foreach ($Array as $key => $val) {
        if ($key == 'rate') {
            return ($val);
        }//end if
    }//end foreach
}

//end funciton
// function for getting array value

function RearrangeArray($headeArray, $chkVal, $newArray) {

    if (in_array(trim($chkVal), $headeArray)) {

        $resultArray = $newArray[$chkVal];
    }//end if

    return $resultArray;
}


// end function
// Function for getting current PAges

function GetCurrentPageName() {
    $currentFile = $_SERVER["PHP_SELF"];
    $parts = Explode('/', $currentFile);
    $currentpage = $parts[count($parts) - 1];
    return $currentpage;
}

// Function for finding Duplicate VAlues in an array

function findDuplicates($data, $dupval) {
    $nb = 0;
    foreach ($data as $key => $val)
        if ($val == $dupval)
            echo "yes";
    $nb++;
    return $nb;
}

//=============================================== Function For Preview Templates
//========================================================================



/* ----------function to check whether the seller gift certiicate is used to purchase only his products--------------- */


function checkGiftCertificateSeller($certificate_code) {
    global $_SESSION, $tableprefix;


    $gift_certificate_flag = 0;

    $select_cart_products = "SELECT product_id FROM " . $tableprefix . "cart
							 WHERE user_id = " . $_SESSION['sess_userid'];

    //echo $select_cart_products."<br>";

    $result_cart_products = mysql_query($select_cart_products) or die(mysql_error());

    if (mysql_num_rows($result_cart_products) > 0) {

        while ($cart_row = mysql_fetch_array($result_cart_products)) {


            /* ----------selecting the seller------------ */

            $cart_product_seller = getSellerName($cart_row['product_id']);


            /* --------------------------------- */

            $select_gift_certificate = "SELECT ngift_product_id
								FROM " . $tableprefix . "giftcoupon_master
								WHERE vgift_coupon_code = '" . $certificate_code . "'";

            //echo $select_gift_certificate."<br>";

            $result_gift_certificate = mysql_query($select_gift_certificate) or die(mysql_error());

            if (mysql_num_rows($result_gift_certificate) > 0) {

                $gift_certificate_seller_row = mysql_fetch_assoc($result_gift_certificate);

                $gift_certificate_seller = getSellerName($gift_certificate_seller_row['ngift_product_id']);
            }


            if ($cart_product_seller != $gift_certificate_seller) {
                $gift_certificate_flag = 1;

                break;
            }


            /* -------------------------------------- */
        }
    }




    return $gift_certificate_flag;
}

function getSellerName($product_id) {
    global $tableprefix;


    $select_seller_product = "SELECT product_artist_id FROM " . $tableprefix . "products
							  WHERE product_id = " . $product_id;
    $result_seller_product = mysql_query($select_seller_product) or die(mysql_error());

    if (mysql_num_rows($result_seller_product) > 0) {
        $seller_product_row = mysql_fetch_assoc($result_seller_product);
    }

    return $seller_product_row['product_artist_id'];
}

/* ----------function to check whether the seller gift certiicate is used to purchase only his products--------------- */


/* --------function to get the country name-----------------
  paramter is country code
 */

function getCountryName($country_code) {
    global $tableprefix,$pdo;
    $result_country = $pdo->select($tableprefix."countries",array("country_name"),array("country_iso_code_2"=>$country_code))->results();

    if (count($result_country) > 0) {
        $country_row = $result_country[0];

        $country_name = $country_row['country_name'];
    }

    return $country_name;
}

/* -------function to manage the user/admin/seller/affiliate sessions----------- */

function manageSession($category, $sellerid = '') {
    global $_SESSION;

    /*
      1 - Admin
      2 - Seller
      3 - User
      4 - Affiliate
     */

    if ($category == 1) { // Admin Category
        if ($_SESSION['sess_affiliateid'] != "") {
            $_SESSION['sess_affiliateid'] = "";
        }
        if ($_SESSION['sess_artistid'] != "") {
            $_SESSION['sess_artistid'] = "";
        }
        if ($_SESSION['sess_userid'] != "") {
            $_SESSION['sess_userid'] = "";
        }
    } else if ($category == 2) { // Seller Category
        if ($_SESSION['sess_affiliateid'] != "") {
            $_SESSION['sess_affiliateid'] = "";
        }
        if ($_SESSION['sess_adminname'] != "") {
            $_SESSION['sess_adminname'] = "";
        }
        if ($_SESSION['sess_userid'] != "") {
            $_SESSION['sess_userid'] = "";
        }
    } else if ($category == 3) { // User Category
        if ($_SESSION['sess_affiliateid'] != "") {
            $_SESSION['sess_affiliateid'] = "";
        }
        if ($_SESSION['sess_adminname'] != "") {
            $_SESSION['sess_adminname'] = "";
        }

        if ($sellerid == '') {
            if ($_SESSION['sess_artistid'] != "") {
                $_SESSION['sess_artistid'] = "";
            }
        }
    } else if ($category == 4) { // Affiliate Category
        if ($_SESSION['sess_artistid'] != "") {
            $_SESSION['sess_artistid'] = "";
        }
        if ($_SESSION['sess_adminname'] != "") {
            $_SESSION['sess_adminname'] = "";
        }
        if ($_SESSION['sess_userid'] != "") {
            $_SESSION['sess_userid'] = "";
        }
    }
}

/* ------function to read the email templates----------- */

function readEmailTemplate($template_name, $table_name = "", $email_address = "") {
    global $tableprefix, $_SESSION, $pdo;

    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];
    $whereConditions = array('vtemplate_name' => $template_name);
    $resultTemplate = $pdo->select($tableprefix . 'email_templates', array("vemail_body"), $whereConditions)->results();
    if ($email_address != "") {
        $whereConditions = array('email' => $email_address);
        $userResult = $pdo->select($tableprefix . 'users', array("first_name", "last_name"), $whereConditions)->results();
    } else if ($table_name == "" && $email_address == "") {
        if (!empty($_SESSION["sess_userid"]))
            $whereConditions = array('user_id' => $_SESSION["sess_userid"]);
        else
            $whereConditions = '';
        $userResult = $pdo->select($tableprefix . 'users', array("first_name", "last_name"), $whereConditions)->results();
    }
    else {
        if ($table_name == "artists") {
            if ($_SESSION["sess_artistid"] != "") {
                $whereC1 = array('artist_id' => $_SESSION["sess_artistid"]);
                $userResult = $pdo->select($tableprefix . 'artists', array("first_name", "last_name"), $whereC1)->results();
            }
        } else if ($table_name == "affiliates") {
            if ($_SESSION["sess_affiliateid"] != "" || $_SESSION["sess_affiliateid_new"] != "") {
                if ($_SESSION["sess_affiliateid_new"] != "")
                    $UserId = $_SESSION["sess_affiliateid_new"];
                if ($_SESSION["sess_affiliateid"] != "")
                    $UserId = $_SESSION["sess_affiliateid"];
                $whereC1 = array('affiliate_id' => $UserId);
                $userResult = $pdo->select($tableprefix . 'affiliates', array("first_name", "last_name"), $whereC1)->results();
            }
        }
        else if ($table_name == "orders") {
            $whereC1 = array('order_id' => $_SESSION["orderid_new"], 'artist_id' => $_SESSION["artist_new"]);
            $orderResult = $pdo->select($tableprefix . 'affiliates', array("order_details", "product_name", "product_code", "product_price", "product_discount", "product_quantity"), $whereC1)->results();
            if (!empty($orderResult[0])) {

                $txtOrdrId = $orderResult[0]['order_id'];
                $txtPdtName = stripslashes($orderResult[0]['product_name']);
                $txtPdtCode = $orderResult[0]['product_code'];
                $rate = $orderResult[0]["product_price"];
                $qty = $orderResult[0]["product_quantity"];
                $price = $rate * $qty;
                if ($orderResult[0]["product_discount"] != "0") {
                    $price = $price - ($price * $orderResult[0]["product_discount"] / 100);
                }
                $txtPdtPrice = $currency_attributes[0] . ' ' . $price;
                $txtPdtQty = $orderResult[0]['product_quantity'];
            }
        }
    }
    if (!empty($userResult[0])) {
        $txtFirstName = ucwords($userResult[0]['first_name']);
        $txtLastName = ucwords($userResult[0]['last_name']);
    }



    if (!empty($resultTemplate[0])) {
        $email_body = $resultTemplate[0]['vemail_body'];
        if ($txtFirstName)
            $email_body = str_replace('[first_name]', $txtFirstName, $email_body);
        if ($txtLastName)
            $email_body = str_replace('[last_name]', $txtLastName, $email_body);
        if ($template_name != 'refund_registration_seller') {
            $email_body = str_replace('[seller_first_name]', $txtFirstName, $email_body);
            $email_body = str_replace('[seller_last_name]', $txtLastName, $email_body);
        }
        $email_body = str_replace('[site_name]', SITE_NAME, $email_body);
        if ($txtOrdrId)
            $email_body = str_replace('[order_id]', $txtOrdrId, $email_body);
        if ($txtPdtName)
            $email_body = str_replace('[product_name]', $txtPdtName, $email_body);
        if ($txtPdtCode)
            $email_body = str_replace('[product_code]', $txtPdtCode, $email_body);
        if ($txtPdtDiscount)
            $email_body = str_replace('[product_discount]', $txtPdtDiscount, $email_body);
        if ($txtPdtPrice)
            $email_body = str_replace('[product_price]', $txtPdtPrice, $email_body);
        $email_body = str_replace('[product_qty]', $txtPdtQty, $email_body);
    }

    $email_body = str_replace("\r\n\r\n", '<br>', $email_body);
    return $email_body;
}

// function validate Donmain name

function check_domain($site = "") {
    $flag = true;
    //$normal = "^[a-z0-9_\+-]+(\.[a-z0-9_\+-]+)*.[a-z0-9-]+(\.[a-z0-9-]+)*\.([a-z]{2,4})$";
    $normal = '^[a-z0-9_\./:+-]+\.[a-zA-Z.]{2,5}$';
    if (!eregi($normal, $site))
        $flag = false;
    return $flag;
}

// end of check_email
// end function
// function to validate Phone

function check_phone($phone, $country = 'US') {
    //$exp = "/^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$/";

    $pattern = '/^[0-9-(+)]+$/';

    if (preg_match($pattern, $phone)) {
        return true;
    } else {
        return false;
    }
}

// end function
// function for subdomian creation
// create subdomain
// create subdomain
function subd($host, $port, $ownername, $passw, $request, $domain, $subdm, $skin) {

    $sock = fsockopen('localhost', 2082);
    if (!$sock) {
        print('Socket error');
        exit();
    } // end if
    //new line code added
    //checking whether the subdomain is exists
    $subdomain = $subdm . "." . $domain;
    $path = "http://" . $ownername . ":" . $passw . "@" . $domain . ":2082/frontend/" . $skin . "/subdomain/index.html";
    $f = fopen($path, "r");
    if (!$f) {
        $result .='<br>Can\'t open cPanel';
    }//end if
    //check if the account exists
    while (!feof($f)) {
        $line = fgets($f, 1024);
        if (ereg($subdomain, $line, $out)) {
            $result .='<br>Such subdomain already exists.';
        }//end if
    }//end while
    fclose($f); //close the file resource
    //subdomain does not already exist. So proceed to creating it
    $path = "http://" . $ownername . ":" . $passw . "@" . $domain . ":2082/frontend/" . $skin . "/subdomain/doadddomain.html?domain=" . $subdm . "&rootdomain=" . $domain;
    $f = fopen($path, "r");
    if (!$f) {
        $result .='<br>Can\'t open cPanel.';
    }//end if
    //check if the subdomain added
    while (!feof($f)) {
        $line = fgets($f, 1024);
        if (ereg("has been added.", $line, $out)) {
            if (trim($result) == '') {
                $authstr = "$ownername:$passw";
                $pass = base64_encode($authstr);
                $in = "GET $request\r\n";
                $in .= "HTTP/1.0\r\n";
                $in .= "Host:$host\r\n";
                $in .= "Authorization: Basic $pass\r\n";
                $in .= "\r\n";

                fputs($sock, $in);

                /* while (!feof($sock))
                  {
                  $result2 .= fgets ($sock,128);
                  }//end while */
                fclose($sock);

                $result .='<br>Subdomain created successfully';
                //chmod($_SERVER['DOCUMENT_ROOT'].$subdm,0777);
            }//end if
        }//end if
    }//end while
    fclose($f); //close the file resource
    //new line code added
    return $result;
}

//end function
/* ------function to read the email templates----------- */

/* -----function to replace the pattern in the css files----- */

function showRegForm($sample_filename, $sample_fields = "") {
    $sample_handle = fopen($sample_filename, "r");

    if (filesize($sample_filename) > 0) {
        $sample_contents = fread($sample_handle, filesize($sample_filename));
    } else {
        $sample_contents = "";
    }
    if ($sample_fields == '') {
        $sample_fields['dd'] = '';
    }
    foreach ($sample_fields as $sample_key => $sample_value) {
        $sample_contents = str_replace("--$sample_key--", $sample_value, $sample_contents);
    }

    $sample_pattern = "/--(\w+)--/i";
    $sample_contents = preg_replace($sample_pattern, "", $sample_contents);
    fclose($sample_handle);
    return $sample_contents;
}

/* ----------function to display the content management details---------- */

function displayCMS($cms_name) {
    global $tableprefix, $pdo;
    $cms_array = array();
    $result_cms = $pdo->select($tableprefix . 'content_management', array('content_heading', 'content_text'), array('content_name' => $cms_name))->results();

    if (!empty($result_cms[0])) {
        foreach ($result_cms as $key => $cms_row) {
            array_push($cms_array, $cms_row['content_heading'], $cms_row['content_text']);
        }
    }

    return $cms_array;
}

/* * ******* */

/* ------function to hide the shipping when cart contains digital product or gift coupon---- */

function hideShipping() {
    global $tableprefix, $_SESSION,$pdo;

    $hide_shipping_division = 1;
    /*     * *******CART TOTAL*********** */
    if ($_SESSION["sess_userid"] != '') {

        $select_cart_total = "SELECT ct.cart_id FROM " . $tableprefix . "cart ct," . $tableprefix . "products prd
									WHERE ct.product_id = prd.product_id
									AND ct.user_id = :user_id";
        $dataArr = array("user_id"=> $_SESSION["sess_userid"]);
    } else {
        $select_cart_total = "SELECT ct.cart_id FROM " . $tableprefix . "cart ct," . $tableprefix . "products prd
									WHERE ct.product_id = prd.product_id
									AND ct.visitor_cart_id = :visitor_cart_id";
         $dataArr = array("visitor_cart_id"=> session_id());
    }


    $result_cart_total = $pdo->pdoQuery($select_cart_total,$dataArr)->results();
    $cart_total = count($result_cart_total);

    /*     * *******CART TOTAL*********** */
    if ($_SESSION["sess_userid"] != '') {

        $select_cart_digital = "SELECT ct.cart_id FROM " . $tableprefix . "cart ct," . $tableprefix . "products prd
									WHERE ct.product_id = prd.product_id
									AND vdigital_product = 'Y'
									AND ct.user_id = :user_id";
        $dataArr = array("user_id"=> $_SESSION["sess_userid"]);
    } else {
        $select_cart_digital = "SELECT ct.cart_id FROM " . $tableprefix . "cart ct," . $tableprefix . "products prd
									WHERE ct.product_id = prd.product_id
									AND vdigital_product = 'Y'
									AND ct.visitor_cart_id = :visitor_cart_id";
        $dataArr = array("visitor_cart_id"=> session_id());
    }

    $result_cart_digital = $pdo->pdoQuery($select_cart_digital,$dataArr)->results();
    $cart_digital = count($result_cart_digital);

    if ($_SESSION["sess_userid"] != '') {

        $select_cart_gift = "SELECT ct.cart_id FROM " . $tableprefix . "cart ct," . $tableprefix . "products prd," . $tableprefix . "categories ctry
							  WHERE ct.product_id = prd.product_id
							   AND prd.product_category = ctry.category_id
							   AND ctry.gift_certificate_flag = 'Y'
							 AND ct.user_id = :user_id";
        $dataArr = array("user_id"=> $_SESSION["sess_userid"]);
    } else {
        $select_cart_gift = "SELECT ct.cart_id FROM " . $tableprefix . "cart ct," . $tableprefix . "products prd," . $tableprefix . "categories ctry
							  WHERE ct.product_id = prd.product_id
							   AND prd.product_category = ctry.category_id
							   AND ctry.gift_certificate_flag = 'Y'
							  AND ct.visitor_cart_id = :visitor_cart_id";
        $dataArr = array("visitor_cart_id"=> session_id());
    }

    $result_cart_gift = $pdo->pdoQuery($select_cart_gift,$dataArr)->results();
    $cart_gift = count($result_cart_gift);

    if (((int) $cart_digital + (int) $cart_gift) > 0) {
        if ((int) $cart_total == ((int) $cart_digital + (int) $cart_gift)) {
            $hide_shipping_division = 0;
        }
    }

    /*
      if(mysql_num_rows($result_cart_digital) == 0 && mysql_num_rows($result_cart_gift) == 0)
      {

      $hide_shipping_division = 1;

      } */

    return $hide_shipping_division;
}

function cartClearDigital($user_id) {
    global $_SESSION, $tableprefix,$pdo;


    $select_gift_check = "SELECT crt.cart_id
						  FROM " . $tableprefix . "categories ctry," . $tableprefix . "cart crt," . $tableprefix . "products prd
						   WHERE ctry.category_id = prd.product_category
						    AND crt.product_id = prd.product_id
							AND ctry.gift_certificate_flag != 'Y'
							AND  prd.vdigital_product != 'Y' AND crt.user_id=:user_id GROUP BY crt.cart_id";

    $result_gift_check = $pdo->pdoQuery($select_gift_check,array("user_id"=>$user_id))->results();
    if (!empty($result_gift_check)) {
        foreach ($result_gift_check as $rows) {
           $pdo->delete($tableprefix."cart",array("cart_id"=>$rows['cart_id']))->affectedRows();
        }
    }
}

function checkGiftProductsExistsinCart($user_id) {
    global $_SESSION, $tableprefix, $pdo;

    $giftProducts = false;

    $select_gift_check = "SELECT crt.cart_id FROM " . $tableprefix . "categories ctry," . $tableprefix . "cart crt," . $tableprefix . "products prd WHERE ctry.category_id = prd.product_category AND crt.product_id = prd.product_id AND ctry.gift_certificate_flag = 'Y' AND crt.user_id=:user_id GROUP BY crt.cart_id";
    if (!empty($user_id))
        $result_gift_check = $pdo->pdoQuery($select_gift_check, array('user_id' => $user_id))->results();


    if (!empty($result_gift_check[0])) {
        $giftProducts = true;
    } else {
        $giftProducts = false;
    }


    return $giftProducts;
}

function digitalProductsCartCount($user_id) {

    global $_SESSION, $tableprefix, $pdo;

    $digitalCount = 0;

    $digital_product_exists = 0;

    $select_gift_check1 = "SELECT count(crt.cart_id ) AS digitalcnt
										FROM " . $tableprefix . "cart crt
										INNER JOIN " . $tableprefix . "products p ON p.product_id = crt.product_id
										WHERE crt.user_id=:user_id AND p.vdigital_product = 'Y' ";

    $result_gift_check1 = $pdo->pdoQuery($select_gift_check1, array("user_id" => $user_id))->results();

    if (!empty($result_gift_check1)) {

        $digitalObj = $result_gift_check1[0];
        $digitalCount = $digitalObj['digitalcnt'];
    }


    if ($digitalCount > 0) {
        $digital_product_exists = 1;
    }

    return $digital_product_exists;
}

function giftProductsCartCount($user_id) {
    global $_SESSION, $tableprefix, $pdo;

    $giftProducts = 0;

    $select_gift_check = "SELECT crt.cart_id
						  FROM " . $tableprefix . "categories ctry," . $tableprefix . "cart crt," . $tableprefix . "products prd
						   WHERE ctry.category_id = prd.product_category
						    AND crt.product_id = prd.product_id
							AND ctry.gift_certificate_flag = 'Y'
							AND crt.user_id=:user_id GROUP BY crt.cart_id";

    $result_gift_check = $pdo->pdoQuery($select_gift_check, array("user_id" => $user_id))->results();

    if (!empty($result_gift_check)) {
        $giftProducts = 1;
    }



    return $giftProducts;
}

function checkDigitalProductsExistsinCart($user_id) {
    global $_SESSION, $tableprefix;

    $giftProducts = false;

    $cartCount = 0;

    $digitalCount = 0;

    $select_gift_check = "SELECT count(*)as cartcnt
						 		 FROM " . $tableprefix . "cart crt
						   WHERE
							 crt.user_id='" . $user_id . "' ";

    $result_gift_check = mysql_query($select_gift_check) or die(mysql_error());

    if (mysql_num_rows($result_gift_check) > 0) {

        $cartObj = mysql_fetch_object($result_gift_check);
        $cartCount = $cartObj->cartcnt;
    }

    $select_gift_check1 = "SELECT count(crt.cart_id ) AS digitalcnt
										FROM " . $tableprefix . "cart crt
										LEFT JOIN " . $tableprefix . "products p ON p.product_id = crt.product_id
										WHERE crt.user_id='" . $user_id . "'
										AND p.vdigital_product = 'Y' ";

    $result_gift_check1 = mysql_query($select_gift_check1) or die(mysql_error());




    if (mysql_num_rows($result_gift_check1) > 0) {

        $digitalObj = mysql_fetch_object($result_gift_check1);
        $digitalCount = $digitalObj->digitalcnt;
    }

    /*     * ***************** */
    $select_cart_gift = "SELECT count(ct.cart_id ) AS giftcnt FROM " . $tableprefix . "cart ct," . $tableprefix . "products prd," . $tableprefix . "categories ctry
							  WHERE ct.product_id = prd.product_id
							   AND prd.product_category = ctry.category_id
							   AND ctry.gift_certificate_flag = 'Y' AND ct.user_id='" . $user_id . "'";
    $result_gift = mysql_query($select_cart_gift) or die(mysql_error());
    if (mysql_num_rows($result_gift) > 0) {

        $digitalObj = mysql_fetch_object($result_gift);
        $giftCount = $digitalObj->giftcnt;
    }
    /*     * ***************** */

    if (((int) $digitalCount + (int) $giftCount) > 0) {
        if ((int) $cartCount != ((int) $digitalCount + (int) $giftCount)) {
            $giftProducts = true;
        }
    }

    /* if(	$cartCount>0 and $digitalCount>0)
      {
      if($cartCount !=$digitalCount)
      {
      $giftProducts = true;
      }
      else
      {
      $giftProducts	=false;
      }

      }
      else
      {
      $giftProducts	=false;
      } */


    return $giftProducts;
}

/* function to extract the extension of a file */

function findexts($filename) {
    $filename = strtolower($filename);
    $exts = split("[/\\.]", $filename);
    $n = count($exts) - 1;
    $exts = $exts[$n];
    return $exts;
}

/* Report to display the number of times each product viewed from the user side */

function productViewedReport($product_id, $customer_id) {
    global $tableprefix, $pdo;

    $select_product = "SELECT nreport_id,dproduct_view_date FROM " . $tableprefix . "report_product
					   WHERE nreport_product_id = :product_id AND nreport_customerid = :customer_id AND dproduct_view_date != NOW()";

    $result_product = $pdo->pdoQuery($select_product, array('product_id' => $product_id, 'customer_id' => $customer_id))->results();

    if (!empty($result_product)) {
        $product_update = $pdo->update($tableprefix . "report_product", array("nproduct_view_count" => "nproduct_view_count + 1", "dproduct_view_date" => 'NOW()'), array("nreport_customerid" => $customer_id))->affectedRows();
    } else {

        $select_product = "SELECT nreport_id,dproduct_view_date FROM " . $tableprefix . "report_product
					   	   WHERE nreport_product_id = :product_id  AND nreport_customerid = :customer_id";

        $result_product = $pdo->pdoQuery($select_product, array('product_id' => $product_id, 'customer_id' => $customer_id))->results();

        if (!empty($result_product)) {
            $pdo->insert($tableprefix . "report_product", array("nreport_product_id" => $product_id, "nreport_customerid" => $customer_id, "nproduct_view_count" => 1, "dproduct_view_date" => "NOW()"));
        }
    }
}

/* displays the rating star in userside */

function SellerRatingStar($prd_id, $units = '', $static = '') {
    global $tableprefix, $_SESSION,$pdo;
    //echo $prd_id;
    //exit;
    //set some variables
    //$ip = $_SERVER['REMOTE_ADDR'];
    if (!$units) {
        $units = 10;
    }
    if (!$static) {
        $static = FALSE;
    }
    $rating_unitwidth = 30;

    $query =  $pdo->select($tableprefix."record_ratings",array("nrating_id","ntotal_ratings"),array("nrseller_id"=>$prd_id,"nruser_id"=>$_SESSION['sess_userid']))->results();
    if (!empty($query)) {
        $numbers = $query[0];
    }

    if ($numbers['ntotal_ratings'] < 1) {
        $count = 0;
    } else {
        $count = $numbers['ntotal_ratings']; //how many votes total
    }
    $current_rating = $numbers['ntotal_ratings']; //total number of rating added together and stored
    $tense = ($count == 1) ? "vote" : "votes"; //plural form votes/vote
    // determine whether the user has voted, so we know how to draw the ul/li


    $votedRes = $pdo->select($tableprefix."record_ratings",array("nrts_id"),array("nrseller_id"=>$prd_id,"nruser_id"=>$_SESSION['sess_userid']))->results();
    $voted = count($votedRes);
    // now draw the rating bar
    $rating_width = @number_format($numbers['nrating_id']) * $rating_unitwidth;

    $rating1 = @number_format($current_rating / $count, 1);
    $rating2 = @number_format($current_rating / $count, 2);


    $result_seller_rating =  $pdo->select($tableprefix."rating",array("nrat_id","vrating"),'')->results();
    $units = count($result_seller_rating);

    $rater = '';
    $rater.='<div class="ratingblock">';
    $rater.='<div id="unit_long' . $prd_id . '">';
    $rater.='<ul id="unit_ul' . $prd_id . '" class="unit-rating" style="width:' . $rating_unitwidth * $units . 'px;">';
    $ncount = 1;

    foreach ($result_seller_rating as $rating_row) {

        $rater.='<li class="current-rating" style="width:' . $rating_width . 'px;">Currently ' . $rating2 . '/' . $units . '</li>';
        $rating_id = $rating_row['nrat_id'];


        if (!$voted) {

            // if the user hasn't yet voted, draw the voting stars
            $rater.='<li><a href="#?q=' . $prd_id . '&amp;rating=' . $rating_id . '&amp;c=' . $units . '"title="' . $rating_row['vrating'] . '" class="r' . $ncount . '-unit rater" rel="nofollow">' . $ncount . '</a></li>';
        }

        $ncount++;
    }

    $select_rating_count = $pdo->select($tableprefix."record_ratings",array("ROUND(SUM(nrating_id)/COUNT(nrating_id)) AS average_rating"),array("nrseller_id"=>$prd_id))->results();
    if(!empty($select_rating_count))$rating_count = $select_rating_count[0];
    $type_rate = $pdo->select($tableprefix."rating",array("vrating"),array("nrat_id"=>$rating_count['average_rating']))->results();
    if(!empty($type_rate)) $rating_type =$type_rate[0];

    $ncount = 0; // resets the count
    $rater.='  </ul>';
    $rater.='  <p';
    if ($voted) {
        $rater.=' class="voted"';
    }
    $rater.='>Current Rating :' . $rating_type['vrating'];
    $rater.='  </p>';
    $rater.='  </td></tr></table>';
    $rater.='</div>';
    $rater.='</div>';
    return $rater;
}

/* function to get the site general settings */

function getSiteGeneralSettings($field_array) {
    global $tableprefix, $pdo;

    $settings_array = array();
    $result_array = join($field_array, ',');

    $select_settings_fields = "SELECT " . $result_array . " FROM " . $tableprefix . "settings WHERE 1";
    $result_settings_fields = $pdo->select($tableprefix . 'settings', $result_array, '')->results();
    $settings_row = $result_settings_fields[0];
    for ($i = 0; $i < count($field_array); $i++) {
        array_push($settings_array, $settings_row[$field_array[$i]]);
    }
    return $settings_array;
}

/* function to restrict the unauthorized access */

function checkDownloadAuthorize() {
    global $_SESSION;

    if (!isset($_SESSION['SESS_download'])) {

        header('Location:digital_product_download.php');
        exit;
    }
}

/* function to check whether shipping is enabled or not */

function checkShippingEnable() {
    global $tableprefix;
    global $pdo;
    $shippingmode = 'N';
    $result = $pdo->select($tableprefix . "settings", "*")->results();
    if (!empty($result)) {
        $fedexmode = $result[0]['enable_fedexshipping'];
        $upsmode = $result[0]['enable_shipping'];
        $uspsmode = $result[0]['enable_uspsshipping'];
        $canadapost = $result[0]['enable_canadapost'];
        $australiapost = $result[0]['enable_australiapost'];
        $flatrate = $result[0]['enable_flatrate'];
    }
    if ($upsmode != 'N' || $fedexmode != 'N' || $uspsmode != 'N' || $canadapost != 'N' || $australiapost != 'N' || $flatrate == "Y") { // check whether shipping Enabled or Not
        $shippingmode = "Y";
    } // end Shipping Check

    return $shippingmode;
}

/* function to activate the template */


/* function to display the currency symbol and calculate the price based on the exchange price */

function displayCurrencyType() {
    global $tableprefix, $_SESSION, $pdo;

    $currency_array = array();

    if (isset($_SESSION['SESS_currency_type']) or $_SESSION['SESS_currency_type'] != "") {
        $whereConditions = array('vcurrency_code' => $_SESSION['SESS_currency_type']);
        $result_currency_type = $pdo->select($tableprefix . 'currency_master', array('vcurrency_symbol', 'nexchange_price', 'vcurrency_code'), $whereConditions)->results();
    } else {
        $admin_currency = getSettingsValue('admin_currency');
        $whereConditions = array('vcurrency_code' => $admin_currency, 'vactive' => 'Y');
        $result_currency_type = $pdo->select($tableprefix . 'currency_master', array('vcurrency_symbol', 'nexchange_price', 'vcurrency_code'), $whereConditions)->results();
    }

    

    $currencySymbol = $result_currency_type[0]['vcurrency_symbol'];

    array_push($currency_array, $result_currency_type[0]['vcurrency_symbol'], $result_currency_type[0]['nexchange_price'], $result_currency_type[0]['vcurrency_code']);

    return $currency_array;
}

function MyUnzip($zipfile) {
    // echo $zipfile;
    global $userid;
    include('pclzip.lib.php');
    $archive = new PclZip("../products/" . $zipfile);
    if ($archive->extract(PCLZIP_OPT_PATH, "../products/zip") == 0) {
        // die("Error : " . $archive->errorInfo(true));
        // $message
        return false;
    }
    return true;
}

/* ------------------- */

//=============================================================

function Unzip($dir, $file, $destiny = "") {
    $dir .= DIRECTORY_SEPARATOR;
    $path_file = $dir . $file;

    $zip = zip_open($path_file);
    $_tmp = array();
    $count = 0;
    if ($zip) {
        while ($zip_entry = zip_read($zip)) {
            $_tmp[$count]["filename"] = zip_entry_name($zip_entry);
            $_tmp[$count]["stored_filename"] = zip_entry_name($zip_entry);
            $_tmp[$count]["size"] = zip_entry_filesize($zip_entry);
            $_tmp[$count]["compressed_size"] = zip_entry_compressedsize($zip_entry);
            $_tmp[$count]["mtime"] = "";
            $_tmp[$count]["comment"] = "";
            $_tmp[$count]["folder"] = dirname(zip_entry_name($zip_entry));
            $_tmp[$count]["index"] = $count;
            $_tmp[$count]["status"] = "ok";
            $_tmp[$count]["method"] = zip_entry_compressionmethod($zip_entry);

            if (zip_entry_open($zip, $zip_entry, "r")) {
                $buf = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));
                if ($destiny) {
                    $path_file = str_replace("/", DIRECTORY_SEPARATOR, $destiny . zip_entry_name($zip_entry));
                } else {
                    $path_file = str_replace("/", DIRECTORY_SEPARATOR, $dir . zip_entry_name($zip_entry));
                }
                $new_dir = dirname($path_file);
                // Create Recursive Directory
                mkdirr($new_dir);

                $fp = fopen($dir . zip_entry_name($zip_entry), "w");
                fwrite($fp, $buf);
                fclose($fp);

                zip_entry_close($zip_entry);
            }
            echo "\n</pre>";
            $count++;
        }

        zip_close($zip);
    }
}

/* ------------------ */

function delDir($dirName) {
    if (empty($dirName)) {
        return;
    }
    if (file_exists($dirName)) {
        $dir = dir($dirName);
        while ($file = $dir->read()) {
            if ($file != '.' && $file != '..') {
                if (is_dir($dirName . '/' . $file)) {
                    delDir($dirName . '/' . $file);
                } else {
                    @unlink($dirName . '/' . $file) or die('File ' . $dirName . '/' . $file . ' couldn\'t be deleted!');
                }
            }
        }
        @rmdir($dirName . '/' . $file) or die('Folder ' . $dirName . '/' . $file . ' couldn\'t be deleted!');
    } else {
        echo 'Folder "<b>' . $dirName . '</b>" doesn\'t exist.';
    }
}

function delFiles($dirName) {
    if (empty($dirName)) {
        return;
    }
    if (file_exists($dirName)) {
        $dir = dir($dirName);
        while ($file = $dir->read()) {
            if ($file != '.' && $file != '..') {
                if (is_dir($dirName . '/' . $file)) {
                    delDir($dirName . '/' . $file);
                } else {
                    @unlink($dirName . '/' . $file) or die('File ' . $dirName . '/' . $file . ' couldn\'t be deleted!');
                }
            }
        }
    } else {
        echo 'Folder "<b>' . $dirName . '</b>" doesn\'t exist.';
    }
}

/* function to display the active template */

function displayTemplate() {
    $tableprefix = "";
    global $tableprefix, $_SESSION, $pdo;


    $template_array = array();
    $whereConditions = array('vactive_status' => 'Y');
    $result_template = $pdo->select($tableprefix . 'template_master', array('vtop_filename', 'vleft_filename', 'vbottom_filename', 'vimages_folder', 'vcss_name', 'vtemplate_name'), $whereConditions)->results();

    $template_row = $result_template[0];
    array_push($template_array, $template_row['vtop_filename'], $template_row['vleft_filename'], $template_row['vbottom_filename'], $template_row['vimages_folder'], $template_row['vcss_name'], $template_row['vtemplate_name']);

    return $template_array;
}

/* function to get the general site settings value */

function getSettingsValue($field_name) {
    global $tableprefix;
    global $pdo;
    $result = $pdo->select($tableprefix . 'settings', array($field_name))->results();
    if (!empty($result[0]))
        if(key($result[0]) == 'npagination_limit'){
            return (int) $result[0][$field_name];
        } else {
            return $result[0][$field_name];
        }
    else
        return '';
}

/* function to generate a random gift coupon code */

function randomGiftCouponKey() {
    global $tableprefix, $pdo;

    $string = "";
    $possible_charactors = "PaNbIuJcMOfgnTopRUjkXlSmFxGqrdeKsLvzAwyBZDtEhiHQVWCY";

    while (strlen($string) < 2) {
        $string .= substr($possible_charactors, rand() % (strlen($possible_charactors)), 2);
    }
    $string .= gmdate("mdYHis") . substr(microtime(), 2, 6);
    $string = str_replace("-", "", $string);
    $string = str_replace(":", "", $string);
    $string = str_replace(" ", "", $string);
    $result_gift_coupon = $pdo->select($tableprefix . "giftcoupon_master", array("ngift_id"), array("vgift_coupon_code" => $string))->results();
    if (!empty($result_gift_coupon)) {
        $string = randomKey();
    }

    return($string);
}

/* function to generate a random digital product zip file name */

function randomDigitalProduct() {
    global $tableprefix, $pdo;

    $string = "";
    $possible_charactors = "PaNbIuJcMOfgnTopRUjkXlSmFxGqrdeKsLvzAwyBZDtEhiHQVWCY";

    while (strlen($string) < 2) {
        $string .= substr($possible_charactors, rand() % (strlen($possible_charactors)), 2);
    }
    $string .= gmdate("mdYHis") . substr(microtime(), 2, 6);
    $string = str_replace("-", "", $string);
    $string = str_replace(":", "", $string);
    $string = str_replace(" ", "", $string);
    $result_digital_product = $pdo->select($tableprefix . "digital_product", array("ndigital_id"), array("vdigital_product_name" => $string))->results();
    if (!empty($result_digital_product)) {
        $string = randomKey();
    }

    return($string);
}

/* function to display banner in the home page */

function displayBannerHome($bannner_id) {
    global $tableprefix, $pdo;

    $update_banner_display_count = "UPDATE " . $tableprefix . "banners
									SET nbanner_display_count = nbanner_display_count + 1
									WHERE nbanner_id = :banner";
    $pdo->pdoQuery($update_banner_display_count, array("banner" => $bannner_id));
}

function ImageTypeBanner($image) {
    list($width, $height, $type, $attr) = @getimagesize($image);
    switch ($type) {
        case 1 :
            $returntype = "gif";
            break;
        case 2 :
            $returntype = "jpg";
            break;
        case 3 :
            $returntype = "png";
            break;
        case 4 :
            $returntype = "swf";
            break;
        case 5 :
            $returntype = "psd";
            break;
        case 6 :
            $returntype = "bmp";
            break;
        case 7 :
            $returntype = "tiff";
            break;
        case 8 :
            $returntype = "tiff";
            break;
        default :
            $returntype = "notsupportted";
            break;
    }

    return $returntype . ":$width:$height";
}

/* ----------------function to resize the image starts----------------------- */

function generateThumbNail($src, $dest, $x, $y) {
    global $save_to_file, $image_quality, $image_type, $max_x, $max_y, $from_name, $to_name;

    // Below are default values (if parameter is not passed)
    // save to file (true) or output to browser (false)
    $save_to_file = true;

    // quality
    $image_quality = 100;

    // resulting image type (1 = GIF, 2 = JPG, 3 = PNG)
    // enter code of the image type if you want override it
    // or set it to -1 to determine automatically
    $image_type = -1;

    // maximum thumb side size
    $max_x = 100;
    $max_y = 100;


    ///////////////////////////////////////////////////
    /////////////// DO NOT EDIT BELOW
    ///////////////////////////////////////////////////

    $to_name = '';
    $from_name = str_replace(" ", "%20", $src);
    $to_name = $dest;
    $max_x = $x;
    $max_y = $y;



// generate
    return GenerateThumbFile($from_name, $to_name, $max_x, $max_y);
}

function SaveImage($type, $im, $filename, $quality, $to_file = true) {

    $res = null;

    // ImageGIF is not included into some GD2 releases, so it might not work
    // output png if gifs are not supported
    if (!function_exists('imagegif'))
        $type = 3;

    switch ($type) {

        case 1:
            if ($to_file) {
                $res = ImageGIF($im, $filename);
            } else {
                header("Content-type: image/gif");
                $res = ImageGIF($im);
            }
            break;
        case 2:
            if ($to_file) {
                $res = ImageJPEG($im, $filename, $quality);
            } else {
                header("Content-type: image/jpeg");
                $res = ImageJPEG($im, '', $quality);
            }
            break;
        case 3:
            if ($to_file) {
                $res = ImagePNG($im, $filename);
            } else {
                header("Content-type: image/png");
                $res = ImagePNG($im, '', $quality);
            }
            break;
    }

    return $res;
}

function ImageCreateFromType($type, $filename) {

    $im = null;
    switch ($type) {
        case 1:
            $im = @imagecreatefromgif($filename);
            break;
        case 2:
            $im = @imagecreatefromjpeg($filename);
            break;
        case 3:
            $im = @imagecreatefrompng($filename);
            break;
    }

    //header("Content-Type: image/png");
//$img = LoadPNG("bogus.image");
    return $im;
}

// generate thumb from image and save it
function GenerateThumbFile($from_name, $to_name, $max_x, $max_y) {
    global $save_to_file, $image_type, $image_quality;


    $image_flag = 0;
    $resize_flag = 0;

    // get source image size (width/height/type)
    // orig_img_type 1 = GIF, 2 = JPG, 3 = PNG
    list($orig_x, $orig_y, $orig_img_type, $img_sizes) = GetImageSize($from_name);


    /* echo "original x =".$orig_x."<br>";
      echo "original y =".$orig_y."<br>";
      echo "image sizes =".$img_sizes."<br>";

      echo "max x =".$max_x."<br>";
      echo "max y =".$max_y."<br>";

      exit; */

    //$a = GetImageSize($from_name);
    // should we override thumb image type?
    $image_type = ($image_type != -1 ? $image_type : $orig_img_type);

    // check for allowed image types
    if ($orig_img_type < 1 or $orig_img_type > 3)
        die("Image type not supported");


    if ($orig_x < $max_x and $orig_y < $max_y) {

        $resize_flag = 1;

        //header('Location:'.$_SERVER['HTTP_REFERER']);
        // exit;
        //return $resize_flag;
    }

    if ($resize_flag != 1) {


        if ($orig_x > $max_x or $orig_y > $max_y) {



            /* -------if original image size is less than the specified size to resize no need to resize------------- */



            /* $per_x = $orig_x / $max_x;
              $per_y = $orig_y / $max_y;
              if ($per_y > $per_x)
              {
              $max_x = $orig_x / $per_y;
              }
              else
              {
              $max_y = $orig_y / $per_x;
              } */
        } else {
            // keep original sizes, i.e. just copy
            if ($save_to_file) {
                @copy($from_name, $to_name);

                // echo "testing";
                //exit;
            } else {

                switch ($image_type) {
                    case 1:
                        header("Content-type: image/gif");
                        include($from_name);
                        break;
                    case 2:
                        header("Content-type: image/jpeg");
                        include($from_name);
                        break;
                    case 3:
                        header("Content-type: image/png");
                        include($from_name);
                        break;
                }
            }
            return;
        }


        //if($resize_flag == 0)
        //{


        if ($image_type == 1) {
            // should use this function for gifs (gifs are palette images)
            $ni = imagecreate($max_x, $max_y);

            //echo "1ni=".$ni;
            //exit;
        } else {
            // Create a new true color image
            $ni = ImageCreateTrueColor($max_x, $max_y);

            //echo "2ni=".$ni;
            //exit;
        }


        // Fill image with white background (255,255,255)
        $white = imagecolorallocate($ni, 255, 255, 255);
        imagefilledrectangle($ni, 0, 0, $max_x, $max_y, $white);
        // Create a new image from source file

        $im = ImageCreateFromType($orig_img_type, $from_name);

        if (!$im) {

            $image_flag = 1;
        } else {

            //imagepng($im);
            // Copy the palette from one image to another
            imagepalettecopy($ni, $im);
            // Copy and resize part of an image with resampling

            imagecopyresampled(
                    $ni, $im, // destination, source
                    0, 0, 0, 0, // dstX, dstY, srcX, srcY
                    $max_x, $max_y, // dstW, dstH
                    $orig_x, $orig_y);    // srcW, srcH
            // save thumb file



            SaveImage($image_type, $ni, $to_name, $image_quality, $save_to_file);
            // }
        }
    }

    return $image_flag;
}

/* ----------------function to resize the image ends----------------------- */

function stripslashes_deep($value) {
    if (is_array($value)) {
        array_map('stripslashes_deep', $value);
    } else if (is_object($value)) {
        $value = $value;
    } else {
        stripslashes($value);
    }
//    $value = is_array($value) ? array_map('stripslashes_deep', $value) : stripslashes($value);
    return $value;
}

function isValidEmail($email) {
    $email = trim($email);
    if ($email == "") {
        return false;
    }
    $pattern = '/^(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){255,})(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){65,}@)(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22))(?:\\.(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\\]))$/iD';
    return preg_match($pattern, $email);
}

function isValidUsername($str) {
    if (trim($str) != "") {
        if (preg_match('/^\d*$/', $str) == 1) {//check whether user name is haivng just numbers
            return false;
        }
        if (eregi("[^0-9a-zA-Z+_]", $str)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function isValidsubdomain($str) {
    if (trim($str) != "") {
        if (eregi("[^0-9a-zA-Z+_]", $str)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function duplicatesubdomain($str) {
    $documentroot = str_replace("/resellers", "", dirname($_SERVER['PHP_SELF']));
    $fullpath = $_SERVER['DOCUMENT_ROOT'];
    if (trim($str) != "") {
        if (is_dir($fullpath . "/" . $str)) {// chek folder name exists with same domain name
            return false;
        } // end if
        else {
            return true;
        }// end else
    } // end if empty check
    else {
        return false;
    }
}

function onlyChars($str) {
    if (eregi("[^a-zA-Z]", $str)) {
        return false;
    } else {
        return true;
    }
}

function isNotNull($value) {
    if (is_array($value)) {
        if (sizeof($value) > 0) {
            return true;
        } else {
            return false;
        }
    } else {
        if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {
            return true;
        } else {
            return false;
        }
    }
}

function pageBrowser($totalrows, $numLimit, $amm, $queryStr, $numBegin, $start, $begin, $num) {
    $larrow = "&nbsp;<<&nbsp;"; //You can either have an image or text, eg. Previous
    $rarrow = "&nbsp;>>&nbsp;"; //You can either have an image or text, eg. Next
    $wholePiece = ""; //This appears in front of your page numbers
    if ($totalrows > 0) {
        $numSoFar = 1;
        $cycle = ceil($totalrows / $amm);
        if (!isset($numBegin) || $numBegin < 1) {
            $numBegin = 1;
            $num = 1;
        }
        if (!isset($start) || $start < 0) {
            $minus = $numBegin - 1;
            $start = $minus * $amm;
        }
        if (!isset($begin)) {
            $begin = $start;
        }
        $preBegin = $numBegin - $numLimit;
        $preStart = $amm * $numLimit;
        $preStart = $start - $preStart;
        $preVBegin = $start - $amm;
        $preRedBegin = $numBegin - 1;
        if ($start > 0 || $numBegin > 1) {
            $wholePiece .= "<a class='links sel_pagination' href='?num=" . $preRedBegin
                    . "&start=" . $preStart
                    . "&numBegin=" . $preBegin
                    . "&begin=" . $preVBegin
                    . $queryStr . "'><font class=navigate>"
                    . $larrow . "</a></font>\n";
        }
        for ($i = $numBegin; $i <= $cycle; $i++) {
            if ($numSoFar == $numLimit + 1) {
                $piece = "<a class='links sel_pagination' href='?numBegin=" . $i
                        . "&num=" . $i
                        . "&start=" . $start
                        . $queryStr . "'><font class=navigate>"
                        . $rarrow . "</font></a>\n";
                $wholePiece .= $piece;
                break;
            }
            $piece = "<a  class='links sel_pagination' href='?begin=" . $start
                    . "&num=" . $i
                    . "&numBegin=" . $numBegin
                    . $queryStr
                    . "'>";
            if ($num == $i) {
                $piece .= "<b><font id=navigate class=navigate>$i</font></b>";
            } else {
                $piece .= "<font id=navigate class=navigate>$i</font>";
            }
            $piece .= "</a>\n";
            $start = $start + $amm;
            $numSoFar++;
            $wholePiece .= $piece;
        }
        $wholePiece .= "\n";
        $wheBeg = $begin + 1;
        $wheEnd = $begin + $amm;
        $wheToWhe = "<b>" . $wheBeg . "</b> - <b>";
        if ($totalrows <= $wheEnd) {
            $wheToWhe .= $totalrows . "</b>";
        } else {
            $wheToWhe .= $wheEnd . "</b>";
        }
        if(!is_int($begin)) $begin = 0;
        $sqlprod = " LIMIT " . $begin . ", " . $amm;
    } else {
        $wholePiece = "<p align=center class=text_information><font size='2'>" . NO_RECORDS_DISPLAY_MSG . "</font><br>&nbsp;</p>";
        $wheToWhe = "<b>0</b> - <b>0</b>";
    }

    return array($sqlprod, $wheToWhe, $wholePiece);
}

if (!function_exists('array_combine')) {

    function array_combine($a1, $a2) {
        if (count($a1) != count($a2))
            return false;
        if (count($a1) <= 0)
            return false;
        $a1 = array_values($a1);
        $a2 = array_values($a2);
        $output = array();
        for ($i = 0; $i < count($a1); $i++) {
            $output[$a1[$i]] = $a2[$i];
        }
        return $output;
    }

}

function dateFormat($input_date, $input_format, $output_format) {

    @preg_match("/^([\w]*)/i", $input_date, $regs);
    $sep = @substr($input_date, strlen($regs[0]), 1);
    $label = @explode($sep, $input_format);
    $value = @explode($sep, $input_date);
    $array_date = @array_combine($label, $value);
    if (@in_array('Y', $label)) {
        $year = $array_date['Y'];
    } elseif (@in_array('y', $label)) {
        $year = $year = $array_date['y'];
    } else {
        return false;
    }

    $output_date = @date($output_format, @mktime(0, 0, 0, $array_date['m'], $array_date['d'], $year));
    return $output_date;
}

function datediff($interval, $datefrom, $dateto, $using_timestamps = false) {
    /*
      $interval can be:
      yyyy - Number of full years
      q - Number of full quarters
      m - Number of full months
      y - Difference between day numbers
      (eg 1st Jan 2004 is "1", the first day. 2nd Feb 2003 is "33". The datediff is "-32".)
      d - Number of full days
      w - Number of full weekdays
      ww - Number of full weeks
      h - Number of full hours
      n - Number of full minutes
      s - Number of full seconds (default)
     */
    if (!$using_timestamps) {
        $datefrom = strtotime($datefrom, 0);
        $dateto = strtotime($dateto, 0);
    }
    $difference = $dateto - $datefrom; // Difference in seconds
    switch ($interval) {
        case 'yyyy': // Number of full years
            $years_difference = floor($difference / 31536000);
            if (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom), date("j", $datefrom), date("Y", $datefrom) + $years_difference) > $dateto) {
                $years_difference--;
            }
            if (mktime(date("H", $dateto), date("i", $dateto), date("s", $dateto), date("n", $dateto), date("j", $dateto), date("Y", $dateto) - ($years_difference + 1)) > $datefrom) {
                $years_difference++;
            }
            $datediff = $years_difference;
            break;
        case "q": // Number of full quarters
            $quarters_difference = floor($difference / 8035200);
            while (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom) + ($quarters_difference * 3), date("j", $dateto), date("Y", $datefrom)) < $dateto) {
                $months_difference++;
            }
            $quarters_difference--;
            $datediff = $quarters_difference;
            break;
        case "m": // Number of full months
            $months_difference = floor($difference / 2678400);
            while (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom) + ($months_difference), date("j", $dateto), date("Y", $datefrom)) < $dateto) {
                $months_difference++;
            }
            $months_difference--;
            $datediff = $months_difference;
            break;
        case 'y': // Difference between day numbers
            $datediff = date("z", $dateto) - date("z", $datefrom);
            break;
        case "d": // Number of full days
            $datediff = floor($difference / 86400);
            break;
        case "w": // Number of full weekdays
            $days_difference = floor($difference / 86400);
            $weeks_difference = floor($days_difference / 7); // Complete weeks
            $first_day = date("w", $datefrom);
            $days_remainder = floor($days_difference % 7);
            $odd_days = $first_day + $days_remainder; // Do we have a Saturday or Sunday in the remainder?
            if ($odd_days > 7) { // Sunday
                $days_remainder--;
            }
            if ($odd_days > 6) { // Saturday
                $days_remainder--;
            }
            $datediff = ($weeks_difference * 5) + $days_remainder;
            break;
        case "ww": // Number of full weeks
            $datediff = floor($difference / 604800);
            break;
        case "h": // Number of full hours
            $datediff = floor($difference / 3600);
            break;
        case "n": // Number of full minutes
            $datediff = floor($difference / 60);
            break;
        default: // Number of full seconds (default)
            $datediff = $difference;
            break;
    }
    return $datediff;
}

function makeDropDownList($ddlname, $list, $selectedindex, $emptyrequired, $class, $properties, $behaviors, $id = NULL) {

    $ddl = "";
    $properties = trim($properties);
    $class = trim($class);
    $properties = trim($properties);
    $behaviors = trim($behaviors);
    if ($id != '') {
        $id = $id;
    } else {
        $id = 'cmbSeller';
    }
    $ddl .= "<select  name=\"$ddlname\" class=\"$class\" id=\"$id\" ";
    if ($properties != "") {
        $ddl .= "  $properties  ";
    }
    if ($behaviors != "") {
        $ddl .= " $behaviors ";
    }
    $ddl .= " >";
    if ($emptyrequired) {
        $ddl .= "<option value=''";
        $ddl .= ">All</option>\n";
    }
    if (count($list) > 0) {
        foreach ($list as $key => $value) {
            $ddl .= "<option value= \"" . htmlentities($key) . "\" ";
            if (is_array($selectedindex)) {

                if (in_array($key, $selectedindex)) {
                    $ddl .= " selected=\"selected\"";
                }
            } else {
                if ($selectedindex == $key) {
                    $ddl .= " selected=\"selected\"";
                }
            }
            if (strlen($value) > 200)
                $value = substr($value, 0, 200) . "......";

            $ddl .= ">" . ($value) . "</option>\n";
        }
    }
    $ddl .= "</select>";
    return $ddl;
}

function makeCountryList() {
    global $tableprefix, $pdo;
    static $options;
    $sql = " SELECT country_iso_code_2 as val, country_name FROM " . $tableprefix . "countries ";
    $resoptions = $pdo->pdoQuery($sql, array())->results();

    $numoptions = count($resoptions);
    $i = 0;
    //list($stid, $stname) = mysql_fetch_row($resoptions)
    if ($numoptions > 0) {
        while ($i < $numoptions) {
            $options[$resoptions[$i]["val"]] = $resoptions[$i]["country_name"];
            $i++;
        }
    }
    return $options;
}

function makeArtistList() {
    global $tableprefix, $pdo;
    static $options;
    $sql = " SELECT artist_id,artist_name,storename FROM " . $tableprefix . "artists  where vapproved ='Y' AND deleted ='N'  AND plan_expired = 'N'  ORDER BY artist_name";
    $resoptions = $pdo->pdoQuery($sql)->results();
    if (!empty($resoptions)) {
        foreach ($resoptions as $key => $val) {
            $stid = $val['artist_id'];
            $stname = $val['artist_name'];
            $storename = $val['storename'];
            $options[$stid] = $stname . " (" . $storename . ") ";
        }
    }
    return $options;
}

function makeProductList() {
    global $tableprefix, $pdo;
    static $options;
    $sql = " SELECT product_id,product_name FROM " . $tableprefix . "products  where vapproved = 'Y' ORDER BY product_name";
    $resoptions = $pdo->pdoQuery($sql)->results();
    $numoptions = count($resoptions);
    if ($numoptions > 0) {
        foreach ($resoptions as $resoption) {
            $stid = $resoption['product_id'];
            $stname = $resoption['product_name'];
            $options[$stid] = $stname;
        }
    }
    return $options;
}

function makeSellerNameList() {
    global $tableprefix, $pdo;
    static $options;
    $sql = " SELECT artist_id, CONCAT(first_name,' ',last_name) AS artist_name FROM " . $tableprefix . "artists ORDER BY artist_name";
    $resoptions = $pdo->pdoQuery($sql)->results();
    $numoptions = count($resoptions);
    if ($numoptions > 0) {
        foreach ($resoptions as $var) {
            $options[$var['artist_id']] = $var['artist_name'];
        }
    }
    return $options;
}

function makeUserNameList() {
    global $tableprefix, $pdo;
    static $options;
    $sql = " SELECT user_id, CONCAT(first_name,' ',last_name) AS user_name  FROM " . $tableprefix . "users ORDER BY user_name";
    $resoptions = $pdo->pdoQuery($sql)->results();
    $numoptions = count($resoptions);
    if ($numoptions > 0) {
        foreach ($resoptions as $var) {
            $options[$var['user_id']] = $var['user_name'];
        }
    }
    return $options;
}

function makeUserList() {
    global $tableprefix;
    static $options;
    $sql = " SELECT user_id,user_name  FROM " . $tableprefix . "users ORDER BY user_name";
    $resoptions = mysql_query($sql);
    $numoptions = mysql_num_rows($resoptions);
    if ($numoptions > 0) {
        while (list($stid, $stname) = mysql_fetch_row($resoptions)) {
            $options[$stid] = $stname;
        }
    }
    return $options;
}

function getNewslettersubscribersList($emailSubject, $emailMessage) {
    global $tableprefix,$pdo;
    static $options;

    //$sql = " SELECT site_url FROM " . $tableprefix . "settings";
    $res = $pdo->select($tableprefix."settings",array("site_url"),"")->results();
    $dat_set=($res[0]);


    //$sql = " SELECT user_id,user_name,email  FROM " . $tableprefix . "users Where newsLetter='Y'";
    $resoptions = $pdo->select($tableprefix."users",array("user_id","user_name","email"),array("newsLetter"=>'Y'))->results();
    $numoptions = count($resoptions);
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_EMAIL . "<" . SITE_EMAIL . ">" . "\r\n";
    //$headers .= 'Bcc: ';
    //$bcc_copies = substr($bcc_copies,1);
    //$headers .= $bcc_copies;
    //Update Newsletter table before blassting the email
    $newsLetterId=$pdo->insert($tableprefix."newsletters",array("nl_subject"=>$emailSubject,"nl_message"=>$emailMessage))->lastInsertId();
    $unSubscribeURL = "";
    $mailcontent = "";

    if ($numoptions > 0) {
         foreach ($resoptions as $resoption) {
            $siteURL = $dat_set['site_url'] . "/unsubscribe.php?doIt=" . base64_encode($stid);
            $stid = $resoption['user_id']; $stname = $resoption['user_name']; $email = $resoption['email'];

            $mail_header = "<p>" . MAIL_ORDER_TEXT_DEAR . " " . $stname . "<p>";
            $mailcontent = $mail_header . nl2br(stripslashes($emailMessage));
            $mailcontent .= "<br>" . MAIL_NEWSLETTER_MSG_1 . "<br>";
            $mailcontent .= "<br><a href='" . $siteURL . "'>" . MAIL_NEWSLETTER_LINK_UNSUBSCRIBE . "</a>";
            $mail_footer = "<p>" . MAIL_ADMIN_TEXT_THANKS_AND_REGARDS . ",<p>";
            $mail_footer .= "<p>" . MAIL_SUBSCRIPTION_SIGNATURE_ADMIN . ",<br>" . SITE_NAME . "<p>";
            $mailcontent .= $mail_footer;

            $mailcontent = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="./themes/' . $active_template[4] . ' rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="125" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';


            /* $qString=base64_encode($stid);
              $unSubscribeURL="<a href='".$siteURL.$qString."'>Click here to unsubscribe</a>";
              $emailMessage.="<br><br><br>".$unSubscribeURL."<br>"; */

            $emailSubject = stripslashes($emailSubject);
            //	Pushing to email queue
            // echo  "<br>". $mailcontent;

            mail($email, $emailSubject, $mailcontent, $headers);

            // inserting subscribers to show in archives
            $pdo->insert($tableprefix."subscribers",array("user_id"=>$stid,"nl_id"=>$newsLetterId))->lastInsertId();
            $message = NL_EMAIL_SUCCESS . "<br>";
        }
    } else {
        $message = NL_RETRY;
        "<br>";
    }

    return $message;
}

function makeAffiliateNameList() {
    global $tableprefix, $pdo;
    static $options;
    $sql = " SELECT affiliate_id,CONCAT(first_name,' ',last_name) AS affiliate_name  FROM " . $tableprefix . "affiliates ORDER BY affiliate_name";
    $resoptions = $pdo->pdoQuery($sql)->results();
    $numoptions = count($resoptions);
    if ($numoptions > 0) {
        foreach ($resoptions as $var) {
            $options[$var['affiliate_id']] = $var['affiliate_name'];
        }
    }
    return $options;
}

function makeAffiliateList() {
    global $tableprefix;
    static $options;
    $sql = " SELECT affiliate_id,affiliate_name FROM " . $tableprefix . "affiliates ORDER BY affiliate_name";
    $resoptions = mysql_query($sql);
    $numoptions = mysql_num_rows($resoptions);
    if ($numoptions > 0) {
        while (list($stid, $stname) = mysql_fetch_row($resoptions)) {
            $options[$stid] = $stname;
        }
    }
    return $options;
}

// //
// Break a word in a string if it is longer than a specified length ($len)
function break_string($string, $len, $break_char = '-') {
    $l = 0;
    $output = '';
    for ($i = 0, $n = strlen($string); $i < $n; $i++) {
        $char = substr($string, $i, 1);
        if ($char != ' ') {
            $l++;
        } else {
            $l = 0;
        }
        if ($l > $len) {
            $l = 1;
            $output .= $break_char;
        }
        $output .= $char;
    }

    return $output;
}

function sanitize_string($string) {
    $string = ereg_replace(' +', ' ', trim($string));

    return preg_replace("/[<>]/", '_', $string);
}

function replace_string($string) {
    $returnval = preg_replace("/[<>]/&.", '+', $string);
}

function getCategoryLink($baseurl, $catid) {
    global $tableprefix,$pdo;
    $link = "<a class='links sel_pagination' href='" . $baseurl . "' class=boldtextblack>" . CATEGORY . "</a> ";
    if ($catid != "") {
        $link .= "<font class=\"links\">></font>";
        $result =$pdo->select($tableprefix."categories",'',array("category_id"=>$catid))->results();
        if (!empty($result)) {
            $row = $result[0];
            $currcatid = $row["category_id"];
            $currcatname = stripslashes($row["category_name"]);
            $subcats = $row["route"];
        }
        if ($subcats == "") {
            $lastcat = "<a class='links sel_pagination' href='" . $baseurl . "?catid=" . $currcatid . "'><b>" . (stripslashes($currcatname)) . "</b></a>";
        } elseif($subcats != '') {
            list($qarr,$qstr) = getInQueryString($subcats);
            //$result = $pdo->select($tableprefix."categories",'',$qarr)->results();
            $sql = "SELECT * FROM `" . $tableprefix . "categories` where category_id in ($subcats) ";
            $result = $pdo->pdoQuery($sql)->results();
            if (!empty($result)) {
                foreach ($result as $row) {
                    $subcatname = stripslashes($row["category_name"]);
                    $subcatid = $row["category_id"];
                    $link .= " <a class='links sel_pagination' href='" . $baseurl . "?catid=" . $subcatid . "'  >" . (stripslashes($subcatname)) . "</a><font class=boldtextblack> ></font>";
                }
            }
            $link = substr($link, 0, -35);
        }
    }

    $link .= $lastcat;
    return $link;
}

function getCategoryLinkNew($baseurl, $catid) {
    global $tableprefix, $pdo;

    if ($catid != "") {
        $result = $pdo->select($tableprefix . "categories", '', array("category_id" => $catid))->results();

        if (!empty($result)) {
            $row = $result[0];
            $currcatid = $row["category_id"];
            $currcatname = stripslashes($row["category_name"]);
            $alias = stripslashes($row["alias"]);
            $subcats = $row["route"];
        }

        if ($subcats == "") {
            if ($type == 0)
                $lastcat = "<a href='" . $baseurl . "?catid=" . $currcatid . "'>" . (stripslashes($currcatname)) . "</a>";
            else {

                $lastcat = "<a href='" . $alias . "'>" . (stripslashes($currcatname)) . "</a>";
            }
        } else {
            list($qarr, $qstr) = getInQueryString($subcats);
            $sql = "SELECT * FROM " . $tableprefix . "categories where category_id in ($qstr) order by parent_id asc ";
            $result = $pdo->pdoQuery($sql, $qarr)->results();

            if (!empty($result)) {
                foreach ($result as $key => $row) {
                    $subcatname = stripslashes($row["category_name"]);
                    $subcatid = $row["category_id"];
                    $subalias = $row["alias"];
                    if ($type == 0)
                        $link .= " <a  href='" . $baseurl . "?catid=" . $subcatid . "'>" . (stripslashes($subcatname)) . "</a>";
                    else {
                        $link .= " <a  href='" . $subalias . "'>" . (stripslashes($subcatname)) . "</a>";
                    }
                }
            }
        }
    }

    $link .= $lastcat;


    return $link;
}


function categoryHasProducts($catid) {
    global $tableprefix, $pdo;
    $sql = "SELECT product_category FROM `" . $tableprefix . "products` where product_category = :catid ";
    $result = $pdo->pdoQuery($sql, array("catid" => $catid))->results();
    if (count($result) != 0) {
        return true;
    }
    return false;
}

function categoryHasChildren($catid) {
    global $tableprefix, $pdo;
    $sql = "SELECT category_id FROM `" . $tableprefix . "categories` where parent_id  = :catid";
    $result = $pdo->pdoQuery($sql, array("catid" => $catid))->results();
    if (count($result) != 0) {
        return true;
    }
    return false;
}

function make_selectlist($current_cat_id, $count) {
    global $tableprefix, $pdo;
    static $option_results;
    if (!isset($current_cat_id)) {
        $current_cat_id = 0;
    }
    $count = $count + 1;
    $sql = "SELECT category_id as id, category_name as name,gift_certificate_flag FROM " . $tableprefix . "categories WHERE parent_id = :current_cat_id ORDER BY name ASC ";
    $get_options = $pdo->pdoQuery($sql, array("current_cat_id" => $current_cat_id))->results();
    $num_options = count($get_options);
    if ($num_options > 0) {
        foreach ($get_options as $get_option) {
            //(list($cat_id, $cat_name, $gift_flag) = mysql_fetch_row($get_options)) {
            $cat_id = $get_option['id'];
            $cat_name = $get_option['name'];
            $gift_flag = $get_option['gift_certificate_flag'];
            /* -------Multicart 2.0 Upgradation------------ */

            if ($gift_flag == "Y") {

                /* $select_gift_products = "SELECT product_id FROM ".$tableprefix."products
                  WHERE product_category = ".$cat_id; */

                $result_gift_products = $pdo->select($tableprefix . "products", array("product_id"), array("product_category" => $cat_id))->results();

                if (count($result_gift_products) > 0) {

                    if ($current_cat_id != 0) {
                        $indent_flag = "   ";
                        for ($x = 2; $x <= $count; $x++) {
                            $indent_flag .= " > ";
                        }
                    }
                    $cat_name = $indent_flag . stripslashes($cat_name);
                    $option_results[$cat_id] = stripslashes($cat_name);
                    make_selectlist($cat_id, $count);
                }
            } else {

                if ($current_cat_id != 0) {
                    $indent_flag = "   ";
                    for ($x = 2; $x <= $count; $x++) {
                        $indent_flag .= " > ";
                    }
                }
                $cat_name = $indent_flag . stripslashes($cat_name);
                $option_results[$cat_id] = stripslashes($cat_name);
                make_selectlist($cat_id, $count);
            }
        }
    }
    return $option_results;
}

function getCategoryDescendants($catid) {
    global $tableprefix, $pdo;
    static $option_results;
    static $i = 0;
    $option_results[$i] = $catid;
    $i++;

    /* ---Mulicart 2.0 Upgradation------- */

    $result = $pdo->select($tableprefix . "categories", array("category_id"), array("parent_id" => $catid))->results();

    /* ---Mulicart 2.0 Upgradation------- */

    if (!empty($result)) {
        foreach ($result as $row) {
            getCategoryDescendants($row["category_id"]);
        }
    }
    return $option_results;
}

function categoryExists($catname, $parentcatid) {
    global $tableprefix, $pdo;
    $sql = "SELECT category_id FROM `" . $tableprefix . "categories` where category_name = :catname AND parent_id = :parentcatid";
    $result = $pdo->pdoQuery($sql, array("catname" => $catname, "parentcatid" => $parentcatid))->results();
    if (count($result) != 0) {
        return true;
    } else {
        return false;
    }
}

function getProductStock($poId) {
    global $tableprefix, $pdo;
    $result = $pdo->select($tableprefix . "product_options", array("product_stock"), array("product_option_id" => $poId))->results();

    if (!empty($result)) {
        return $result[0]["product_stock"];
    }
    return 0;
}

function adjustQuantities($userid) {
    global $tableprefix, $pdo;


    $sql = "SELECT * FROM " . $tableprefix . "cart WHERE user_id = :user_id ";
    $result = $pdo->select($tableprefix . "cart", '', array("user_id" => $userid))->results();
    $parr = array();
    $itemcount = 0;
    if (!empty($result)) {
        foreach ($result as $row) {
            $parr[$itemcount]["cartid"] = $row["cart_id"];
            $parr[$itemcount]["productid"] = $row["product_id"];
            $parr[$itemcount]["product_option_id"] = $row["product_option_id"];
            $parr[$itemcount]["quantity"] = $row["quantity"];
            $itemcount++;
        }
    }
    $qtyadjusted = false;
    for ($i = 0; $i < $itemcount; $i++) {
        $cartid = $parr[$i]["cartid"];
        $productid = $parr[$i]["productid"];
        $product_option_id = $parr[$i]["product_option_id"];
        $value = $parr[$i]["quantity"];
        $qtyavailable = getProductStock($product_option_id);
        if ($qtyavailable == 0) { // soldout, so delete the item from the cart
            $sql = "DELETE FROM " . $tableprefix . "cart WHERE cart_id='" . addslashes($cartid) . "' ";
            $pdo->pdoQuery($sql);
            $qtyadjusted = true;
        } else if ($value > $qtyavailable) {
            $sql = "UPDATE " . $tableprefix . "cart SET quantity = '" . addslashes($qtyavailable) . "' WHERE cart_id='" . addslashes($cartid) . "' ";
            $pdo->pdoQuery($sql);
            $qtyadjusted = true;
            $qtyavailable = 0;
        }
    }
    return $qtyadjusted;
}

function adjustStock($userid, $mode) {

    global $tableprefix, $pdo;
    $itemcount = 0;
    if ($userid) {
        $result = $pdo->select($tableprefix . 'cart', '', array('user_id' => $userid))->results();
        $parr = array();
        if (!empty($result)) {
            foreach ($result as $key => $row) {
                $parr[$itemcount]["cartid"] = $row["cart_id"];
                $parr[$itemcount]["productid"] = $row["product_id"];
                $parr[$itemcount]["product_option_id"] = $row["product_option_id"];
                $parr[$itemcount]["quantity"] = $row["quantity"];
                $itemcount++;
            }
        }
    }
    $stockadjusted = false;
    for ($i = 0; $i < $itemcount; $i++) {
        $cartid = $parr[$i]["cartid"];
        $productid = $parr[$i]["productid"];
        $product_option_id = $parr[$i]["product_option_id"];
        $value = $parr[$i]["quantity"];
        $qtyavailable = getProductStock($product_option_id);

        if ($mode == "+") {
            $newstock = $qtyavailable + $value;
            $sqlstatus = "UPDATE  " . $tableprefix . "product_options SET product_stock='" . $newstock . "' WHERE product_option_id = '" . addslashes($product_option_id) . "' ";
        } else if ($mode == "-") {
            $newstock = $qtyavailable - $value;
            $sqlstatus = "UPDATE  " . $tableprefix . "product_options SET product_stock='" . $newstock . "' WHERE product_option_id = '" . addslashes($product_option_id) . "' ";
        }
        $pdo->pdoQuery($sqlstatus);

        //*****************************Multicart3.0 Scalability  Update Product main stock

        $cartqtyobj = Cart::getCartItemQuantity($userid);

        if (!empty($cartqtyobj)) {
            foreach ($cartqtyobj as $cartVals) {
                $item_id = $cartVals['product_id'];
                $item_qty = $cartVals['cartQuantity'];
                $data = Products::updateProduct_Stock($item_id, $item_qty);
            }
        }
        //*****************************Multicart3.0 Scalability  End Update Product main stock
    }



    return $stockadjusted;
}

function getCheckoutExpiredUsers() {
    global $tableprefix, $pdo;
    $timenow = time();
    $oneday = 86400;

    $timeyday = $timenow - $oneday;
    $sql = "SELECT DISTINCT user_id FROM " . $tableprefix . "cart  WHERE datetime_added < :timeyday AND status='1' ";
    $result = $pdo->pdoQuery($sql, array('timeyday' => $timeyday))->results();
    $eusers = "";
    if (!empty($result[0])) {
        foreach ($result as $key => $row) {
            $eusers .="," . $row["user_id"];
        }
        $eusers = substr($eusers, 1);
    }
    return $eusers;
}

function getCartTotalcouponCode($userid, $couponCode) {
    global $tableprefix,$pdo;
    $sql = "SELECT c.*, (p.product_price+po.additional_price) AS product_price,p.product_artist_id,po.discount
            FROM " . $tableprefix . "cart c
            INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
            INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
            WHERE c.user_id = :user_id";

    $result = $pdo->pdoQuery($sql,array("user_id"=>$userid))->results();
    $total = 0;
    $itemcount = 0;
    $currency_attributes = displayCurrencyType();

    if (!empty($result)) {
        foreach ($result as $row) {


            $converted_price = $row['product_price'];

            $converted_price = number_format($converted_price, 2, ".", "");

            $rate = $converted_price;
            $qty = $row["quantity"];
            $price = $qty * $rate;
            $discountstr = "";
            $discountprice = 0;
            if ($row["discount"] != "0") {
                $price = number_format($price, 2, ".", "");
                $discountprice = $rate - ($rate * $row["discount"]) / 100;
                $discountprice = number_format($discountprice, 2, ".", "");
                $discountrate = ($discountprice * $qty);
                $price = $discountrate;
            }
            $total += $price;
        }
    }

    $total = number_format($total, 2, ".", "");
    if ($couponCode['ccDiscount'] <> "") {
        $total = $total - ($total * $couponCode['ccDiscount']) / 100;
    }

    return $total;
}

function getUserCouponcodeCartTotal($userid, $couponCode) {
    global $tableprefix;

    $currency_attributes = displayCurrencyType();

    $sql = "SELECT c.*, (p.product_price+po.additional_price) AS product_price,p.product_artist_id,po.discount
            FROM " . $tableprefix . "cart c
            INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
            INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
            WHERE c.user_id = '" . addslashes($userid) . "' ";
    $result = mysql_query($sql);
    $total = 0;
    $itemcount = 0;
    $currency_attributes = displayCurrencyType();
    if (mysql_num_rows($result) != 0) {
        while ($row = mysql_fetch_array($result)) {

            $conversionRate = ConvertedCurrencyRate($currency_attributes[2]);
            $converted_price = $row['product_price'] * $conversionRate;

            $rate = $converted_price;


            $qty = $row["quantity"];
            $price = $qty * $rate;
            $discountstr = "";
            $discountprice = 0;
            if ($row["discount"] != "0") {
                $price = number_format($price, 2, ".", "");
                $discountprice = $rate - ($rate * $row["discount"]) / 100;
                $discountprice = number_format($discountprice, 2, ".", "");
                $discountrate = ($discountprice * $qty);
                $price = $discountrate;
            }
            $total += $price;
        }
    }

    $total = number_format($total, 2, ".", "");
    if ($couponCode['ccDiscount'] <> "") {
        $total = $total - ($total * $couponCode['ccDiscount']) / 100;
    }

    return $total;
}

function getCartTotal($userid) {
    global $tableprefix, $pdo;

    $sql = "SELECT c.*, (p.product_price+po.additional_price) AS product_price,p.product_artist_id,po.discount
           FROM " . $tableprefix . "cart c
           INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
           INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
           WHERE c.user_id = '" . addslashes($userid) . "' ";
    $result = $pdo->pdoQuery($sql, array("user_id" => $userid))->results();
    $total = 0;
    $itemcount = 0;
    if (!empty($result)) {
        foreach ($result as $row) {
            $converted_price = $row['product_price'];

            $converted_price = number_format($converted_price, 2, ".", "");

            $rate = $converted_price;


            $qty = $row["quantity"];
            $price = $qty * $rate;
            $discountstr = "";
            $discountprice = 0;
            if ($row["discount"] != "0") {
                $price = number_format($price, 2, ".", "");
                $discountprice = $rate - ($rate * $row["discount"]) / 100;
                $discountprice = number_format($discountprice, 2, ".", "");
                $discountrate = ($discountprice * $qty);
                $price = $discountrate;
            }
            $total += $price;
        }
    }
    return $total;
}

function getUserCurrencyCartTotal($userid) {
    global $tableprefix, $pdo;

    $currency_attributes = displayCurrencyType();

    $sql = "SELECT c.*, (p.product_price+po.additional_price) AS product_price,p.product_artist_id,po.discount
        FROM " . $tableprefix . "cart c
        INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
        INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
        WHERE c.user_id = :user_id ";
    $result = $pdo->pdoQuery($sql, array("user_id" => $userid))->results();
    $total = 0;
    $itemcount = 0;
    $currency_attributes = displayCurrencyType();
    if (!empty($result)) {
        foreach ($result as $row) {

            $conversionRate = ConvertedCurrencyRate($currency_attributes[2]);
            $converted_price = $row['product_price'] * $conversionRate;

            $rate = $converted_price;


            $qty = $row["quantity"];
            $price = $qty * $rate;
            $discountstr = "";
            $discountprice = 0;
            if ($row["discount"] != "0") {
                $price = number_format($price, 2, ".", "");
                $discountprice = $rate - ($rate * $row["discount"]) / 100;
                $discountprice = number_format($discountprice, 2, ".", "");
                $discountrate = ($discountprice * $qty);
                $price = $discountrate;
            }
            $total += $price;
        }
    }

    return $total;
}

function emptyCart($userid) {
    global $tableprefix,$pdo;
    $result = $pdo->delete($tableprefix."cart",array("user_id"=>$userid))->affectedRows();
    return;
}

function isCartEmpty($userid) {
    global $tableprefix, $pdo;
    $result = $pdo->select($tableprefix . "cart", array("cart_id"), array("user_id" => $userid))->results();
    if (!empty($result)) {
        return false;
    }
    return true;
}

function isVisitorCartEmpty($visitorid) {
    global $tableprefix, $pdo;
    $whereConditions = array('visitor_cart_id' => $visitorid);
    $result = $pdo->select($tableprefix . 'cart', array('cart_id'), $whereConditions)->result();
    if (!empty($result)){
        return false;
    }else{
        return true;
    }
}

function mergeVisitorCartToUserCart($visitorid, $userid) {
    global $tableprefix, $pdo;
    $usercart = array();
    $visitorcart = array();
    $whereConditions = array('visitor_cart_id' => $visitorid);
    $result = $pdo->select($tableprefix . 'cart', array('cart_id', 'product_id', 'product_option_id', 'quantity'), $whereConditions)->results();
    if (!empty($result[0])) {
        $todelete = "";
        $vcartid = $result[0]["cart_id"];
        $productid = $result[0]["product_id"];
        $product_option_id = $result[0]["product_option_id"];
        $quantity = $result[0]["quantity"];
        $whereConditions = array('user_id' => $userid, 'product_id' => $productid, 'product_option_id' => $product_option_id);
        $resultnew = $pdo->select($tableprefix . 'cart', array('cart_id', 'product_id', 'product_option_id', 'quantity'), $whereConditions)->results();
        if (!empty($resultnew[0])) {//the same product is present in usercart
            $todelete .="," . $vcartid;
            $usercartid = $resultnew[0]["cart_id"];
            $userquantity = $resultnew[0]["quantity"];
            $newqty = $userquantity + $quantity;
            $aWhere = array('cart_id' => $usercartid);
            $q = $pdo->update($tableprefix . 'cart', array('visitor_cart_id' => 0, 'quantity' => $newqty), $aWhere)->affectedRows();
        } else {
            $aWhere = array('cart_id' => $vcartid);
            $q = $pdo->update($tableprefix . 'cart', array('visitor_cart_id' => 0, 'quantity' => $quantity, 'user_id' => $userid), $aWhere)->affectedRows();
        }


        $todelete = substr($todelete, 1);
        if ($todelete != "") {
            $objResultRow = $pdo->pdoQuery("DELETE FROM " . $tableprefix . "cart  WHERE cart_id IN (" . addslashes($todelete) . ") ", '');
        }
    }

    return true;
}

function getStatusList() {
    global $tableprefix, $pdo;
    static $options;
    $sql = " SELECT order_status_id, order_status FROM " . $tableprefix . "order_status ";
    $resoptions = $pdo->pdoQuery($sql)->results();
    $numoptions = count($resoptions);
    if ($numoptions > 0) {
        foreach ($resoptions as $resoption) {
            $stid = $resoption['order_status_id'];
            $stname = $resoption['order_status'];
            $options[$stid] = $stname;
        }
    }
    return $options;
}

function getOrderArtists($oid) {
    global $tableprefix, $pdo;
    $artists = array();
    $cnt = 0;
    $resoptions = $pdo->select($tableprefix . 'order_details', array('artist_id'), array('order_id' => $oid))->results();
    foreach ($resoptions as $key => $val) {
        $artists[$cnt] = $val["artist_id"];
        $cnt++;
    }
    // $artists = array_unique(array_values($artists));
    $artists = array_unique($artists);
    return implode(",", $artists);
}

function getArtistName($sid) {
    global $tableprefix, $pdo;
    $result = $pdo->select($tableprefix . 'artists', array('artist_name'), array('artist_id' => $sid))->results();
    if (!empty($result)) {
        return $result[0]["artist_name"];
    }
    return "";
}

function getArtistCompanyName($sid) {
    global $tableprefix,$pdo;
    $result =$pdo->select($tableprefix."artists",array("company"),array("artist_id"=>$sid))->results();
    if (!empty($result)) {
        $rw = $result[0];
        return $rw["company"];
    }
    return "";
}

function getArtistName_Location($sid) {
    global $tableprefix, $pdo;
    global $enable_seller_friendly;
    $result = $pdo->select($tableprefix . "artists", array('CONCAT(first_name," ",last_name) AS sellername', 'artist_name', 'phone', 'storename', 'state', 'country', 'address1', 'city'), array('artist_id' => $sid))->results();
    if (!empty($result[0])) {
        $rw = $result[0];
        $seller_name = (!empty($rw['sellername'])) ? ucfirst($rw['sellername']) : ucfirst($rw['artist_name']);
        $seller_state = getCodeValue($rw['state'], 2, $rw['country']);
        $seller_country = getCodeValue($rw['country'], 1);

        if ($enable_seller_friendly == "Y") {
            $sellerLink = (!empty($rw['storename'])) ? SITE_URL . "/stores/" . $rw['storename'] : SITE_URL . "/store/" . $rw['artist_name'];
        } else {
            $sellerLink = (!empty($rw['storename'])) ? SITE_URL . "/showportfolio.php?storename=" . $rw['storename'] : SITE_URL . "/showportfolio.php?artistid=" . $sid;
        }
        $shopURL = "<a href='$sellerLink'>" . $rw['storename'] . "</a>";
        /*         * ********* */

        $sellerLocationString = $seller_name;

        if ($rw['phone'] != '') {
            $sellerLocationString.= "&nbsp;&nbsp;Phone-" . $rw['phone'];
        }

        if ($shopURL != '') {
            $sellerLocationString.= "&nbsp;&nbsp;" . $shopURL;
        }
        if ($rw['address1'] != '') {
            $sellerLocationString.= ",&nbsp;&nbsp;" . $rw['address1'];
        }
        if ($rw['city'] != '') {
            $sellerLocationString.= ",&nbsp;&nbsp;" . $rw['city'];
        }
        return $sellerLocationString . ",&nbsp;&nbsp;" . $seller_state . ",&nbsp;&nbsp;" . $seller_country;
    }

    return "";
}


function getAffiliateName($aid) {
    global $tableprefix, $pdo;
    $sql = "SELECT affiliate_name FROM `" . $tableprefix . "affiliates` where affiliate_id = :aid ";
    $result = $pdo->pdoQuery($sql, array("aid" => $aid ))->results();
    if (count($result) != 0) {
        $rw = ($result[0]);
        return $rw["affiliate_name"];
    }
    return "";
}

function getArtistOrderStatus($oid, $sid) {
    global $tableprefix, $pdo;
    $sql = "SELECT s.order_status FROM " . $tableprefix . "order_details od
            INNER JOIN " . $tableprefix . "order_status s ON od.item_status = s.order_status_id
            AND od.artist_id = :sid WHERE order_id = :oid ";
    $objResultRow = $pdo->pdoQuery($sql, array('sid' => $sid, 'oid' => $oid))->results();
    if ($objResultRow[0])
        return $objResultRow[0]['order_status'];
}

function getOrderStatus($oid) {
    global $tableprefix, $pdo;
    $cnt = 0;
    $statuses = array();

    $sql = "SELECT s.order_status FROM " . $tableprefix . "order_details od INNER JOIN " . $tableprefix . "order_status s ON od.item_status = s.order_status_id WHERE order_id = :oid ";
    $resoptions = $pdo->pdoQuery($sql, array("oid" => $oid))->results();
    if (!empty($resoptions)) {
        foreach ($resoptions as $key => $val) {
            $statuses[$cnt] = $val["order_status"];
            $cnt++;
        }
    }
    $statuses = array_unique(array_values($statuses));
    if (count($statuses) == 1) {
        return $statuses[0];
    } else {
        if (in_array("Pending", $statuses)) {
            $status = "Pending";
        } else {
            $status = implode(" / ", $statuses);
        }
        return $status;
    }
}

function getClientIP() {
    // Get REMOTE_ADDR as the Client IP.
    $client_ip = (!empty($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : ((!empty($_ENV['REMOTE_ADDR'])) ? $_ENV['REMOTE_ADDR'] : $REMOTE_ADDR);
    // Check for headers used by proxy servers to send the Client IP. We should look for HTTP_CLIENT_IP before HTTP_X_FORWARDED_FOR.
    if ($_SERVER["HTTP_CLIENT_IP"])
        $proxy_ip = $_SERVER["HTTP_CLIENT_IP"];
    elseif ($_SERVER["HTTP_X_FORWARDED_FOR"])
        $proxy_ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
    // Proxy is used, see if the specified Client IP is valid. Sometimes it's 10.x.x.x or 127.x.x.x... Just making sure.
    if ($proxy_ip) {
        if (preg_match("/^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/", $proxy_ip, $ip_list)) {
            $private_ip = array('/^0\./', '/^127\.0\.0\.1/', '/^192\.168\..*/', '/^172\.16\..*/', '/^10.\.*/', '/^224.\.*/', '/^240.\.*/');
            $client_ip = preg_replace($private_ip, $client_ip, $ip_list[1]);
        }
    }
    // Return the Client IP.
    return $client_ip;
}

function isValidWebImageType($mimetype) {

    if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/x-png") || ($mimetype == "image/png") || ($mimetype == "image/gif")) {
        return true;
    } else {
        return false;
    }
}

function NewimageCreatefromtype($image) {
    list($width, $height, $type, $attr) = @getimagesize($image);
    if ($type == "1") {  //gif
        $returnimage = @imagecreatefromgif($image);
    } else if ($type == "2") { //jpeg
        $returnimage = @imagecreatefromjpeg($image);
    } else if ($type == "3") { //png
        $returnimage = @imagecreatefrompng($image);
    } else {
        $returnimage = "Not Supported";
    }
    return $returnimage;
}

function Imagetype($newImage, $newfile, $editimagefile) {
    list($width, $height, $type, $attr) = @getimagesize($editimagefile);
    $jpgCompression = "60";
    if ($type == "1") {  //gif
        $returnimage = @imagegif($newImage, '');
    } else if ($type == "2") { //jpeg
        $returnimage = @imagejpeg($newImage, '', $jpgCompression);
        ;
    } else if ($type == "3") { //png
        $returnimage = @imagepng($newImage, '');
    } else {
        $returnimage = "Not Supported";
    }
    return $returnimage;
}

/* function getResizedImage($file,$img_height) {
  $img_temp = NewimageCreatefromtype($file);
  $black = @imagecolorallocate ($img_temp, 0, 0, 0);
  $white = @imagecolorallocate ($img_temp, 255, 255, 255);
  $font = 2;
  $img_width=@imagesx($img_temp)/imagesy($img_temp)*$img_height;
  $img_thumb=@imagecreatetruecolor($img_width,$img_height);
  @imagecopyresampled($img_thumb,$img_temp,0,0,0,0,$img_width,$img_height,@imagesx ($img_temp),@imagesy($img_temp));
  $originx = @imagesx($img_thumb) - 100;
  $originy = @imagesy($img_thumb) - 15;
  header ("Content-type: image/jpeg");
  imagejpeg($img_thumb, '', 60);
  } */

function getResizedImage($file, $img_height) {
    list($originalwidth, $originalheight, $originaltype) = getimagesize($file);
    $img_temp = NewimageCreatefromtype($file);
    $black = @imagecolorallocate($img_temp, 0, 0, 0);
    $white = @imagecolorallocate($img_temp, 255, 255, 255);
    $font = 2;
    $img_width = @imagesx($img_temp) / imagesy($img_temp) * $img_height;
    if ($originaltype == "1") { // gif
        $newwidth = $img_width;
        $newheight = $img_height;
        $tpcolor = imagecolorat($img_temp, 0, 0);
        // in the real world, you'd better test all four corners, not just one!
        $img_thumb = imagecreate($newwidth, $newheight);
        // $dest automatically has a black fill...
        imagepalettecopy($img_thumb, $img_temp);
        imagecopyresized($img_thumb, $img_temp, 0, 0, 0, 0, $newwidth, $newheight, @imagesx($img_temp), @imagesy($img_temp));
        $pixel_over_black = imagecolorat($img_thumb, 0, 0);
        // ...but now make the fill white...
        $bg = imagecolorallocate($img_thumb, 255, 255, 255);
        imagefilledrectangle($img_thumb, 0, 0, $newwidth, $newheight, $bg);
        imagecopyresized($img_thumb, $img_temp, 0, 0, 0, 0, $newwidth, $newheight, @imagesx($img_temp), @imagesy($img_temp));
        $pixel_over_white = imagecolorat($img_thumb, 0, 0);
        // ...to test if transparency causes the fill color to show through:
        if ($pixel_over_black != $pixel_over_white) {
            // Background IS transparent
            imagefilledrectangle($img_thumb, 0, 0, $newwidth, $newheight, $tpcolor);
            imagecopyresized($img_thumb, $img_temp, 0, 0, 0, 0, $newwidth, $newheight, @imagesx($img_temp), @imagesy($img_temp));
            imagecolortransparent($img_thumb, $tpcolor);
            imagegif($img_thumb);
        } else // Background (most probably) NOT transparent
            imagegif($img_thumb);
    } else {
        $img_thumb = @imagecreatetruecolor($img_width, $img_height);
        @imagecopyresampled($img_thumb, $img_temp, 0, 0, 0, 0, $img_width, $img_height, @imagesx($img_temp), @imagesy($img_temp));
        $originx = @imagesx($img_thumb) - 100;
        $originy = @imagesy($img_thumb) - 15;
        header("Content-type: image/jpeg");
        imagejpeg($img_thumb, '', 60);
    }
}

function getCategory($baseurl, $catid) {
    global $tableprefix;
    $link = "";
    $append = "NO";
    if ($catid != "") {
        $link .= "<font class=boldtextblack>></font>";
        $sql = "SELECT * FROM `" . $tableprefix . "categories` where category_id = '" . $catid . "'";
        $result = mysql_query($sql);
        if (mysql_num_rows($result) != 0) {
            $row = mysql_fetch_array($result);
            $currcatid = $row["category_id"];
            $currcatname = stripslashes($row["category_name"]);
            $subcats = $row["route"];
        }
        if ($subcats == "") {
            $lastcat = "<b>" . htmlentities($currcatname) . "</b>";
        } else {
            $sql = "SELECT * FROM `" . $tableprefix . "categories` where category_id in ($subcats) ";
            $result = mysql_query($sql);
            if (mysql_num_rows($result) != 0) {
                while ($row = mysql_fetch_array($result)) {
                    $subcatname = stripslashes($row["category_name"]);
                    $subcatid = $row["category_id"];
                    $link .= "<b>" . htmlentities($subcatname) . "</b>";
                    $link = $link . "<font class=boldtextblack> ></font>";
                }
            }
            $link = substr($link, 0, -35);
        }
    }

    $link .= $lastcat;
    $link = substr($link, 37);

    return $link;
}

function makeDropDownList_search($ddlname, $list, $selectedindex, $emptyrequired, $class, $properties, $behaviors) {
    //remove ' from selected category
    $selectedindex = str_replace("'", '', $selectedindex);
    $selectedindex = trim($selectedindex);

    $ddl = "";
    $properties = trim($properties);
    $class = trim($class);
    $properties = trim($properties);
    $behaviors = trim($behaviors);

    $ddl .= "<select  name=\"$ddlname\" class=\"$class\" ";
    if ($properties != "") {
        $ddl .= "  $properties  ";
    }
    if ($behaviors != "") {
        $ddl .= " $behaviors ";
    }
    $ddl .= " >";
    if ($emptyrequired) {
        $ddl .= "<option value=''";
        $ddl .= "> " . ALL_TEXT . "</option>\n";
    }
    if (count($list) > 0) {
        foreach ($list as $key => $value) {
            $ddl .= "<option value= \"" . htmlentities($key) . "\" ";
            if (is_array($selectedindex)) {
                if (in_array("$key", $selectedindex)) {
                    $ddl .= " selected=\"selected\"";
                }
            } else {
                if ($selectedindex == "$key") {
                    $ddl .= " selected=\"selected\"";
                }
            }
            $title = stripslashes($value);
            if (strlen($value) > 20)
                $value = substr($value, 0, 20) . "...";

            $ddl .= " title='" . $title . "'>" . stripslashes($value) . "</option>\n";
        }
    }
    $ddl .= "</select>";
    return $ddl;
}

function ReplaceArray($name) { // function for replace quotes in image
    $name = str_replace(' ', '_', $name);
    $name = str_replace("'", '_', $name);
    $name = str_replace(".", '_', $name);
    return ($name);
}

//end fucnction

function ReplaceArrayImage($name) { // function for replace quotes in image
    $name = trim(strip_tags($name));
    $name = str_replace(' ', '_', $name);
    $name = str_replace("'", '_', $name);
    return ($name);
}

//end fucnction
//function for display state name
function stateName($Country, $cState) {
    $state = "US:AK:Alaska,
US:AL:Alabama,
US:AR:Arkansas,
US:AS:American Samoa,
US:AZ:Arizona,
US:CA:California,
US:CO:Colorado,
US:CT:Connecticut,
US:DC:D.C.,
US:DE:Delaware,
US:FL:Florida,
US:FM:Micronesia,
US:GA:Georgia,
US:GU:Guam,
US:HI:Hawaii,
US:IA:Iowa,
US:ID:Idaho,
US:IL:Illinois,
US:IN:Indiana,
US:KS:Kansas,
US:KY:Kentucky,
US:LA:Louisiana,
US:MA:Massachusetts,
US:MD:Maryland,
US:ME:Maine,
US:MH:Marshall Islands,
US:MI:Michigan,
US:MN:Minnesota,
US:MO:Missouri,
US:MP:Marianas,
US:MS:Mississippi,
US:MT:Montana,
US:NC:North Carolina,
US:ND:North Dakota,
US:NE:Nebraska,
US:NH:New Hampshire,
US:NJ:New Jersey,
US:NM:New Mexico,
US:NV:Nevada,
US:NY:New York,
US:OH:Ohio,
US:OK:Oklahoma,
US:OR:Oregon,
US:PA:Pennsylvania,
US:PR:Puerto Rico,
US:PW:Palau,
US:RI:Rhode Island,
US:SC:South Carolina,
US:SD:South Dakota,
US:TN:Tennessee,
US:TX:Texas,
US:UT:Utah,
US:VA:Virginia,
US:VI:Virgin Islands,
US:VT:Vermont,
US:WA:Washington,
US:WI:Wisconsin,
US:WV:West Virginia,
US:WY:Wyoming,
US:AA:Military Americas,
US:AE:Military Europe/ME/Canada,
US:AP:Military Pacific,
CA:AB:Alberta,
CA:MB:Manitoba,
CA:AB:Alberta,
CA:BC:British Columbia,
CA:MB:Manitoba,
CA:NB:New Brunswick,
CA:NL:Newfoundland and Labrador,
CA:NS:Nova Scotia,
CA:NT:Northwest Territories,
CA:NU:Nunavut,
CA:ON:Ontario,
CA:PE:Prince Edward Island,
CA:QC:Quebec,
CA:SK:Saskatchewan,
CA:YT:Yukon Territory,
AU:AAT:Australian Antarctic Territory,
AU:ACT:Australian Capital Territory,
AU:NT:Northern Territory,
AU:NSW:New South Wales,
AU:QLD:Queensland,
AU:SA:South Australia,
AU:TAS:Tasmania,
AU:VIC:Victoria,
AU:WA:Western Australia,
BR:AC:Acre,
BR:AL:Alagoas,
BR:AM:Amazonas,
BR:AP:Amapa,
BR:BA:Baia,
BR:CE:Ceara,
BR:DF:Distrito Federal,
BR:ES:Espirito Santo,
BR:FN:Fernando de Noronha,
BR:GO:Goias,
BR:MA:Maranhao,
BR:MG:Minas Gerais,
BR:MS:Mato Grosso do Sul,
BR:MT:Mato Grosso,
BR:PA:Para,
BR:PB:Paraiba,
BR:PE:Pernambuco,
BR:PI:Piaui,
BR:PR:Parana,
BR:RJ:Rio de Janeiro,
BR:RN:Rio Grande do Norte,
BR:RO:Rondonia,
BR:RR:Roraima,
BR:RS:Rio Grande do Sul,
BR:SC:Santa Catarina,
BR:SE:Sergipe,
BR:SP:Sao Paulo,
BR:TO:Tocatins,
NL:DR:Drente,
NL:FL:Flevoland,
NL:FR:Friesland,
NL:GL:Gelderland,
NL:GR:Groningen,
NL:LB:Limburg,
NL:NB:Noord Brabant,
NL:NH:Noord Holland,
NL:OV:Overijssel,
NL:UT:Utrecht,
NL:ZH:Zuid Holland,
NL:ZL:Zeeland,
UK:AVON:Avon,
UK:BEDS:Bedfordshire,
UK:BERKS:Berkshire,
UK:BUCKS:Buckinghamshire,
UK:CAMBS:Cambridgeshire,
UK:CHESH:Cheshire,
UK:CLEVE:Cleveland,
UK:CORN:Cornwall,
UK:CUMB:Cumbria,
UK:DERBY:Derbyshire,
UK:DEVON:Devon,
UK:DORSET:Dorset,
UK:DURHAM:Durham,
UK:ESSEX:Essex,
UK:GLOUS:Gloucestershire,
UK:GLONDON:Greater London,
UK:GMANCH:Greater Manchester,
UK:HANTS:Hampshire,
UK:HERWOR:Hereford & Worcestershire,
UK:HERTS:Hertfordshire,
UK:HUMBER:Humberside,
UK:IOM:Isle of Man,
UK:IOW:Isle of Wight,
UK:KENT:Kent,
UK:LANCS:Lancashire,
UK:LEICS:Leicestershire,
UK:LINCS:Lincolnshire,
UK:MERSEY:Merseyside,
UK:NORF:Norfolk,
UK:NHANTS:Northamptonshire,
UK:NTHUMB:Northumberland,
UK:NOTTS:Nottinghamshire,
UK:OXON:Oxfordshire,
UK:SHROPS:Shropshire,
UK:SOM:Somerset,
UK:STAFFS:Staffordshire,
UK:SUFF:Suffolk,
UK:SURREY:Surrey,
UK:SUSS:Sussex,
UK:WARKS:Warwickshire,
UK:WMID:West Midlands,
UK:WILTS:Wiltshire,
UK:YORK:Yorkshire,
EI:CO ANTRIM:County Antrim,
EI:CO ARMAGH:County Armagh,
EI:CO DOWN:County Down,
EI:CO FERMANAGH:County Fermanagh,
EI:CO DERRY:County Londonderry,
EI:CO TYRONE:County Tyrone,
EI:CO CAVAN:County Cavan,
EI:CO DONEGAL:County Donegal,
EI:CO MONAGHAN:County Monaghan,
EI:CO DUBLIN:County Dublin,
EI:CO CARLOW:County Carlow,
EI:CO KILDARE:County Kildare,
EI:CO KILKENNY:County Kilkenny,
EI:CO LAOIS:County Laois,
EI:CO LONGFORD:County Longford,
EI:CO LOUTH:County Louth,
EI:CO MEATH:County Meath,
EI:CO OFFALY:County Offaly,
EI:CO WESTMEATH:County Westmeath,
EI:CO WEXFORD:County Wexford,
EI:CO WICKLOW:County Wicklow,
EI:CO GALWAY:County Galway,
EI:CO MAYO:County Mayo,
EI:CO LEITRIM:County Leitrim,
EI:CO ROSCOMMON:County Roscommon,
EI:CO SLIGO:County Sligo,
EI:CO CLARE:County Clare,
EI:CO CORK:County Cork,
EI:CO KERRY:County Kerry,
EI:CO LIMERICK:County Limerick,
EI:CO TIPPERARY:County Tipperary,
EI:CO WATERFORD:County Waterford,
';

// Country data table
//
//
// To edit the list, just delete a line or add a line.  Order is important.  The order
// displayed is the order it appears on the drop down.
//
var country = '
AF:Afghanistan,
AL:Albania,
DZ:Algeria,
AS:American Samoa,
AD:Andorra,
AO:Angola,
AI:Anguilla,
AQ:Antarctica,
AG:Antigua and Barbuda,
AR:Argentina,
AM:Armenia,
AW:Aruba,
AU:Australia,
AT:Austria,
AZ:Azerbaijan,
AP:Azores,
BS:Bahamas,
BH:Bahrain,
BD:Bangladesh,
BB:Barbados,
BY:Belarus,
BE:Belgium,
BZ:Belize,
BJ:Benin,
BM:Bermuda,
BT:Bhutan,
BO:Bolivia,
BA:Bosnia And Herzegowina,
XB:Bosnia-Herzegovina,
BW:Botswana,
BV:Bouvet Island,
BR:Brazil,
IO:British Indian Ocean Territory,
VG:British Virgin Islands,
BN:Brunei Darussalam,
BG:Bulgaria,
BF:Burkina Faso,
BI:Burundi,
KH:Cambodia,
CM:Cameroon,
CA:Canada,
CV:Cape Verde,
KY:Cayman Islands,
CF:Central African Republic,
TD:Chad,
CL:Chile,
CN:China,
CX:Christmas Island,
CC:Cocos (Keeling) Islands,
CO:Colombia,
KM:Comoros,
CG:Congo,
CD:Congo, The Democratic Republic O,
CK:Cook Islands,
XE:Corsica,
CR:Costa Rica,
CI:Cote d` Ivoire (Ivory Coast),
HR:Croatia,
CU:Cuba,
CY:Cyprus,
CZ:Czech Republic,
DK:Denmark,
DJ:Djibouti,
DM:Dominica,
DO:Dominican Republic,
TP:East Timor,
EC:Ecuador,
EG:Egypt,
SV:El Salvador,
GQ:Equatorial Guinea,
ER:Eritrea,
EE:Estonia,
ET:Ethiopia,
FK:Falkland Islands (Malvinas),
FO:Faroe Islands,
FJ:Fiji,
FI:Finland,
FR:France (Includes Monaco),
FX:France, Metropolitan,
GF:French Guiana,
PF:French Polynesia,
TA:French Polynesia (Tahiti),
TF:French Southern Territories,
GA:Gabon,
GM:Gambia,
GE:Georgia,
DE:Germany,
GH:Ghana,
GI:Gibraltar,
GR:Greece,
GL:Greenland,
GD:Grenada,
GP:Guadeloupe,
GU:Guam,
GT:Guatemala,
GN:Guinea,
GW:Guinea-Bissau,
GY:Guyana,
HT:Haiti,
HM:Heard And Mc Donald Islands,
VA:Holy See (Vatican City State),
HN:Honduras,
HK:Hong Kong,
HU:Hungary,
IS:Iceland,
IN:India,
ID:Indonesia,
IR:Iran,
IQ:Iraq,
IE:Ireland,
EI:Ireland (Eire),
IL:Israel,
IT:Italy,
JM:Jamaica,
JP:Japan,
JO:Jordan,
KZ:Kazakhstan,
KE:Kenya,
KI:Kiribati,
KP:Korea, Democratic People'S Repub,
KW:Kuwait,
KG:Kyrgyzstan,
LA:Laos,
LV:Latvia,
LB:Lebanon,
LS:Lesotho,
LR:Liberia,
LY:Libya,
LI:Liechtenstein,
LT:Lithuania,
LU:Luxembourg,
MO:Macao,
MK:Macedonia,
MG:Madagascar,
ME:Madeira Islands,
MW:Malawi,
MY:Malaysia,
MV:Maldives,
ML:Mali,
MT:Malta,
MH:Marshall Islands,
MQ:Martinique,
MR:Mauritania,
MU:Mauritius,
YT:Mayotte,
MX:Mexico,
FM:Micronesia, Federated States Of,
MD:Moldova, Republic Of,
MC:Monaco,
MN:Mongolia,
MS:Montserrat,
MA:Morocco,
MZ:Mozambique,
MM:Myanmar (Burma),
NA:Namibia,
NR:Nauru,
NP:Nepal,
NL:Netherlands,
AN:Netherlands Antilles,
NC:New Caledonia,
NZ:New Zealand,
NI:Nicaragua,
NE:Niger,
NG:Nigeria,
NU:Niue,
NF:Norfolk Island,
MP:Northern Mariana Islands,
NO:Norway,
OM:Oman,
PK:Pakistan,
PW:Palau,
PS:Palestinian Territory, Occupied,
PA:Panama,
PG:Papua New Guinea,
PY:Paraguay,
PE:Peru,
PH:Philippines,
PN:Pitcairn,
PL:Poland,
PT:Portugal,
PR:Puerto Rico,
QA:Qatar,
RE:Reunion,
RO:Romania,
RU:Russian Federation,
RW:Rwanda,
KN:Saint Kitts And Nevis,
SM:San Marino,
ST:Sao Tome and Principe,
SA:Saudi Arabia,
SN:Senegal,
XS:Serbia-Montenegro,
SC:Seychelles,
SL:Sierra Leone,
SG:Singapore,
SK:Slovak Republic,
SI:Slovenia,
SB:Solomon Islands,
SO:Somalia,
ZA:South Africa,
GS:South Georgia And The South Sand,
KR:South Korea,
ES:Spain,
LK:Sri Lanka,
NV:St. Christopher and Nevis,
SH:St. Helena,
LC:St. Lucia,
PM:St. Pierre and Miquelon,
VC:St. Vincent and the Grenadines,
SD:Sudan,
SR:Suriname,
SJ:Svalbard And Jan Mayen Islands,
SZ:Swaziland,
SE:Sweden,
CH:Switzerland,
SY:Syrian Arab Republic,
TW:Taiwan,
TJ:Tajikistan,
TZ:Tanzania,
TH:Thailand,
TG:Togo,
TK:Tokelau,
TO:Tonga,
TT:Trinidad and Tobago,
XU:Tristan da Cunha,
TN:Tunisia,
TR:Turkey,
TM:Turkmenistan,
TC:Turks and Caicos Islands,
TV:Tuvalu,
UG:Uganda,
UA:Ukraine,
AE:United Arab Emirates,
UK:United Kingdom,
GB:Great Britain,
US:United States,
UM:United States Minor Outlying Isl,
UY:Uruguay,
UZ:Uzbekistan,
VU:Vanuatu,
XV:Vatican City,
VE:Venezuela,
VN:Vietnam,
VI:Virgin Islands (U.S.),
WF:Wallis and Furuna Islands,
EH:Western Sahara,
WS:Western Samoa,
YE:Yemen,
YU:Yugoslavia,
ZR:Zaire,
ZM:Zambia,
ZW:Zimbabwe";

    $StateArray = split(',', $state);

    foreach ($StateArray as $val) {
        list($fist, $sName) = split($Country . ':' . $cState . ':', $val);
        if (trim($sName) != '') {
            return($sName);
        }//end if
    }//end if
}

//end fucntion
//fucntion for remove comma from an array
function ArrayRemove($arrVal, $chkVal) {
    foreach ($arrVal as $val) {
        if ($val != $chkVal) {
            $val = str_replace(",", "", trim($val));
            $arrNewVal[] = $val;
        }//end if
    }//end foreach
    return($arrNewVal);
}

//end function
//fucntion for remove comma from an array
function ArrayRemoveBlank($arrVal) {
    foreach ($arrVal as $val) {
        if (trim($val) != '') {
            $val = $val;
            $arrNewVal[] = $val;
        }//end if
    }//end foreach
    return($arrNewVal);
}

//end function
//function to reassign key
function ReassignKey($kArray, $vArray) {
    $i = 0;
    foreach ($kArray as $val) {
        $name = 'labels' . $val;
        if (trim($_POST[$name]) != '') {
            $name = $_POST[$name];
            $arrNewVal[$name] = $vArray[$i];
        }//end if
        else {
            $arrNewVal[$val] = $vArray[$i];
        }//end else
        $i++;
    }//end foreach
    return($arrNewVal);
}

//end function
// function for getting user selected currency exchange valeu



// end function
// Function for copying  files from a folder to another folder
function copydir($source, $destination) {
    if (!is_dir($destination)) {
        $oldumask = umask(0);
        mkdir($destination, 0755); // so you get the sticky bit set
        umask($oldumask);
    }
    $dir_handle = @opendir($source);
    while ($file = @readdir($dir_handle)) {
        if ($file != "." && $file != ".." && !is_dir("$source/$file"))
            copy("$source/$file", "$destination/$file");
    }
    @closedir($dir_handle);
}

// End Function

function resizeImg2($imgPath, $maxWidth, $maxHeight, $directOutput = true, $quality = 90, $verbose, $imageType, $imgPath2) {
    // get image size infos (0 width and 1 height,
    //     2 is (1 = GIF, 2 = JPG, 3 = PNG)

    $size = @getimagesize($imgPath);

    // break and return false if failed to read image infos
    if (!$size) {
        if ($verbose && !$directOutput)
            echo "<br />Not able to read image infos.<br />";
        return false;
    }

    // relation: width/height
    $relation = $size[0] / $size[1];
    // maximal size (if parameter == false, no resizing will be made)
    $maxSize = array($maxWidth ? $maxWidth : $size[0], $maxHeight ? $maxHeight : $size[1]);
    // declaring array for new size (initial value = original size)
    $newSize = $size;
    // width/height relation
    $relation = array($size[1] / $size[0], $size[0] / $size[1]);


    if (($newSize[0] > $maxWidth)) {
        $newSize[0] = $maxSize[0];
        $newSize[1] = $newSize[0] * $relation[0];
    }



    /*
      if(($newSize[1] > $maxHeight))
      {
      $newSize[1]=$maxSize[1];
      $newSize[0]=$newSize[1]*$relation[1];
      }
     */

    // create image

    switch ($size[2]) {
        case 1:
            if (@function_exists("imagecreatefromgif")) {
                $originalImage = @imagecreatefromgif($imgPath);
            } else {
                if ($verbose && !$directOutput)
                    echo "<br />No GIF support in this php installation, sorry.<br />";
                return false;
            }
            break;
        case 2: $originalImage = @imagecreatefromjpeg($imgPath);
            break;
        case 3: $originalImage = @imagecreatefrompng($imgPath);
            break;
        default:
            if ($verbose && !$directOutput)
                echo "<br />No valid image type.<br />";
            return false;
    }


    // create new image

    $resizedImage = @imagecreatetruecolor($newSize[0], $newSize[1]);

    @imagecopyresampled($resizedImage, $originalImage, 0, 0, 0, 0, $newSize[0], $newSize[1], $size[0], $size[1]);

    $rz = $imgPath;

    // output or save
    if ($directOutput) {
        @imagejpeg($resizedImage);
    } else {

        $rz = preg_replace("/\.([a-zA-Z]{3,4})$/", "" . $imageType . ".jpg", $imgPath2);
        @imagejpeg($resizedImage, $rz, $quality);
    }
    // return true if successfull
    return $rz;
}



// end function
//fucntion for display file path nmae
function ClientFilePathName($PhpSelf) {
    $fpath = split("/", $PhpSelf);
    $fpath = $fpath[count($fpath) - 1];
    return ($fpath);
}

//end function
// Finding Domain name
function find_base_domain($url = false) {
    if ($url == false) {
        $url = (@is_array($_SERVER)) ? $_SERVER['SERVER_NAME'] : ((@is_array($HTTP_SERVER_VARS)) ? $HTTP_SERVER_VARS['SERVER_NAME'] : $SERVER_NAME );
//If $_SERVER is an array, give the server name, if $HTTP_SERVER_VARS is an array, give the server name from that, if not, then just use the old old $SERVER_NAME variable;
    }
//Continue with the rest of the function;
    $url = str_replace("http://", "", $url);
    $domainExt = substr($url, strrpos($url, "."));

    $domain = substr($url, 0, strrpos($url, "."));

    if (strstr($domain, ".")) {
        $base_domain = substr($domain, strrpos($domain, ".") + 1);
    } else {
        $base_domain = $domain;
    }
    return $base_domain . $domainExt;
}

// Function for Getting Dealer Currency Symbol
function getproductCount($parent_id) {
    global $tableprefix,$pdo;
    $result_artist_currency = $pdo->select($tableprefix."categories",array("category_id"),array("parent_id"=>$parent_id))->results();
    $catid = array();
    if (!empty($result_artist_currency)) {
        while ($rs1 = $result_artist_currency[0]) {
            $catid[] = $rs1['category_id'];
        }
        $idstring = implode("','", $catid);
        list($qarr,$qstr) = getInQueryString($idstring);
        $sql_cnt = "Select count(*) as cnt from " . $tableprefix . "products where product_category   IN ($qstr)";
        $rs_cnt = $pdo->pdoQuery($sql_cnt,$qarr)->results();
        $procount = $rs_cnt[0]['cnt'];
    } else {
        $procount = 0;
    }
    return $procount;
}

// end functio
// Resize Thumbnails

function resizeImg($imgPath, $maxWidth, $maxHeight, $directOutput = true, $quality = 90, $verbose, $imageType) {
    $size = getimagesize($imgPath);
    //print_r($size);exit;
    // break and return false if failed to read image infos
    if (!$size) {
        if ($verbose && !$directOutput)
            echo "<br />Not able to read image infos.<br />";

        return false;
    }

    // relation: width/height
    $relation = $size[0] / $size[1];
    // maximal size (if parameter == false, no resizing will be made)
    $maxSize = array($maxWidth ? $maxWidth : $size[0], $maxHeight ? $maxHeight : $size[1]);
    // declaring array for new size (initial value = original size)
    $newSize = $size;
    // width/height relation
    $relation = array($size[1] / $size[0], $size[0] / $size[1]);
    //print_r($size);
    //echo "<br>";
    //print_r($relation);exit;

    if (($newSize[0] > $maxWidth)) {
        $newSize[0] = $maxSize[0];
        $newSize[1] = $newSize[0] * $relation[0];
    }




    if (($newSize[1] > $maxHeight)) {
        $newSize[1] = $maxSize[1];
        $newSize[0] = $newSize[1] * $relation[1];
    }


    // create image
    switch ($size[2]) {
        case 1:
            if (function_exists("imagecreatefromgif")) {
                $originalImage = imagecreatefromgif($imgPath);
            } else {
                if ($verbose && !$directOutput)
                    echo "<br />No GIF support in this php installation, sorry.<br />";
                return false;
            }
            break;
        case 2: $originalImage = imagecreatefromjpeg($imgPath);
            break;
        case 3: $originalImage = imagecreatefrompng($imgPath);
            break;
        default:
            if ($verbose && !$directOutput)
                echo "<br />No valid image type.<br />";
            return false;
    }

    // create new image

    $resizedImage = imagecreatetruecolor($newSize[0], $newSize[1]);

    imagecopyresampled($resizedImage, $originalImage, 0, 0, 0, 0, $newSize[0], $newSize[1], $size[0], $size[1]);

    $rz = $imgPath;

    // output or save
    if ($directOutput) {
        imagejpeg($resizedImage);
    } else {

        $exp = explode(".", $imgPath);
        $extension = $exp[count($exp) - 1];
        $newimage = $imageType . "." . $extension;
        $rz = preg_replace("/\.([a-zA-Z]{3,4})$/", $newimage, $imgPath);
        imagejpeg($resizedImage, $rz, $quality);
    }
    // return true if successfull
    return $rz;
}

// End function Resize Image
// End function Resize Image
// check file extension of an image

function get_image_extension($filename) {
    if (@function_exists('exif_imagetype')) {
        switch (@exif_imagetype($filename)) {
            case 1:
                return 'gif';
            case 2:
                return 'jpg';
            case 3:
                return 'png';
            case 4:
                return 'swf';
            case 5:
                return 'psd';
            case 6:
                return 'bmp';
            case 7:
                return 'tiff';
            case 8:
                return 'tiff';
            case 9:
                return 'jpc';
            case 10:
                return 'jp2';
            case 11:
                return 'jpx';
            case 12:
                return 'jb2';
            case 13:
                return 'swc';
            case 14:
                return 'iff';
            case 15:
                return 'wbmp';
            case 16:
                return 'xbm';
            default:
                return false;
        }
    }
    else
        return false;
}

// end shipping method

function getAdminEmail() {
    global $tableprefix,$pdo;
    $result = $pdo->select($tableprefix."settings",array("site_email"),'')->results();
    if (!empty($result)) {
        $row = $result[0];
        $var_site_email = stripslashes($row["site_email"]);
    }
    return $var_site_email;
}

function getLicense() {
    global $tableprefix,$pdo;
    $sql = "SELECT vLicenceKey FROM " . $tableprefix . "settings";
    $result = $pdo->select($tableprefix."settings",array("vLicenceKey"))->results();

    if (!empty($result)) {
        $row = $result[0];
        $var_licencekey = stripslashes($row["vLicenceKey"]);
    }
    return $var_licencekey;
}

function checkValiditycouponCode($couponCode, $userId = NULL) {
    global $tableprefix, $pdo;
    $currentDate = date('Y-m-d');
    $sql = "SELECT * FROM " . $tableprefix . "couponcode WHERE ccCode=:ccCode AND ccStatus='Y' AND subscriptionStatus='Y' AND ccStartDate<=:ccStartDate AND  ccEndDate>=:ccStartDate";

    $result = $pdo->pdoQuery($sql, array("ccCode" => $couponCode, "ccStartDate" => $currentDate))->results();
    $successFlag = 0;
    $inValidSeller = 0;
    if (!empty($result)) {

        $row = $result[0];
        $couponCode_det['ccID'] = $row['ccID'];
        $couponCode_det['ccCode'] = $row['ccCode'];
        $couponCode_det['ccDiscount'] = $row['ccDiscount'];

        $cartItems = Cart::getAllCartitemsWithCategoryandSellerInfo($userId);


        $appliedSeller = $row['sellerId'];
        $appliedarray = array();
        $appliedProductArray = array();
        $appliedCatNameArray = array();
        $appliedProductNameArray = array();
        $productNames = "";
        if ($row['coupon_type'] == 'category') {

            $appliedCategory = explode(',', $row['categoryId']);

            foreach ($cartItems->data as $value) {

                if (in_array($value['product_category'], $appliedCategory) && $appliedSeller == $value['seller_id']) {
                    $successFlag = 1;
                    $inValidSeller = 0;
                    $appliedarray[] = $value['product_category'];
                    $appliedCatNameArray[] = $value['category_name'];
                    $productNames = implode(',', $appliedCatNameArray);
                    $appliedProductArray[] = $value['product_id'];
                    $couponCode_det['product_id'] = $appliedProductArray;
                    // $objResultRow                =  DbHelper::selectResult($tableprefix."products",'product_name',"product_id =".$value->product_id);
                    //$objResultCatRow             =  DbHelper::selectResult($tableprefix."categories",'category_name',"category_id =".$appliedCategory);
                    //$couponCode_det['product_name']=$objResultRow[0]->product_name;

                    $couponCode_det['seller_id'] = $value['seller_id'];
                    $couponCode_det['coupon_type'] = $row['coupon_type'];
                    $couponCode_det['appliedCategory'] = $appliedarray;
                } elseif (in_array($value['product_category'], $appliedCategory) && $appliedSeller != $value['seller_id']) {
                    $inValidSeller = 1;
                }
            }
            if ($successFlag == 1) {
                $couponCode_det['product_name'] = "Category " . $productNames;
            }
            if ($successFlag == 0)
                $inValidType = "category";
        }elseif ($row['coupon_type'] == 'product') {
            $appliedProduct = explode(',', $row['productId']);

            foreach ($cartItems->data as $value) {
                if (in_array($value['product_id'], $appliedProduct) && $appliedSeller == $value['seller_id']) {
                    $appliedarray[] = $value['product_id'];
                    $appliedProductNameArray[] = $value['product_name'];
                    $productNames = implode(',', $appliedProductNameArray);
                    $successFlag = 1;
                    $inValidSeller = 0;
                    $couponCode_det['product_id'] = $appliedarray;
                    //$objResultRow                  =  DbHelper::selectResult($tableprefix."products",'product_name',"product_id =".$value->product_id);

                    $couponCode_det['seller_id'] = $value['seller_id'];
                    $couponCode_det['coupon_type'] = $row['coupon_type'];
                    $couponCode_det['appliedProduct'] = $appliedarray;
                } else if (in_array($value['product_id'], $appliedProduct) && $appliedSeller != $value['seller_id']) {
                    $inValidSeller = 1;
                }
            }
            if ($successFlag == 1) {
                $couponCode_det['product_name'] = $productNames;
            }
            if ($successFlag == 0)
                $inValidType = "product";
        }elseif ($row['coupon_type'] == 'seller') {
            foreach ($cartItems->data as $value) {
                if ($appliedSeller == $value['seller_id']) {
                    $successFlag = 1;
                    $couponCode_det['product_id'] = $value['product_id'];
                    //$objResultRow                =  DbHelper::selectResult($tableprefix."products",'product_name',"product_id =".$value->product_id);
                    $objResultArtistRow = $pdo->select($tableprefix . "artists", array("artist_name"), array("artist_id" => $appliedSeller))->results();
                    $couponCode_det['product_name'] = "products of seller " . $objResultArtistRow[0]['artist_name'];
                    $couponCode_det['seller_id'] = $value['seller_id'];
                    $couponCode_det['coupon_type'] = $row['coupon_type'];
                    $couponCode_det['appliedSeller'] = $appliedSeller;
                    break;
                }
            }
            if ($successFlag == 0)
                $inValidType = "seller";
        }
        if ($successFlag) {
            $_SESSION['couponCode_det'] = $couponCode_det;
            $retVal['data'] = $couponCode_det;
            $retVal['status'] = 1;
            return $retVal;
        } else {
            if ($inValidType == "seller") {
                $error_message = INVALID_SELLER_COUPON_CODE_TEXT;
            } elseif ($inValidType == "product") {
                if ($inValidSeller)
                    $error_message = INVALID_SELLER_FOR_PRODUCT_COUPON_CODE_TEXT;
                else
                    $error_message = INVALID_PRODUCT_COUPON_CODE_TEXT;
            }elseif ($inValidType == "category") {
                if ($inValidSeller)
                    $error_message = INVALID_SELLER_FOR_CATEGORY_COUPON_CODE_TEXT;
                else
                    $error_message = INVALID_CATEGORY_COUPON_CODE_TEXT;
            }
            unset($_SESSION['couponCode_det']);
            $retVal['message'] = $error_message;
            $retVal['status'] = 0;
            return $retVal;
        }
    }else {
        $resArr = $pdo->select($tableprefix . "couponcode", array("ccEndDate"), array("ccCode" => $couponCode))->results();
        if ($currentDate > $resArr[0]['ccEndDate']) {
            unset($_SESSION['couponCode_det']);
            $retVal['message'] = EXPIRED_COUPON_CODE_TEXT;
            $retVal['status'] = 0;
            return $retVal;
        } else {
            unset($_SESSION['couponCode_det']);
            $retVal['message'] = INVALID_COUPON_CODE_TEXT;
            $retVal['status'] = 0;
            return $retVal;
        }
    }
}

// end function

function showExpireMessage($artID) {
    global $tableprefix,$pdo;
    unset($_SESSION['SES_PLANDET']);
    $currentDate = date('Y-m-d');
    /* 	$sql  = "SELECT max(artMem.artist_memID), max( artMem.artist_memEndDate ) as artist_memEndDate,plan_Id, (To_days( max( artMem.artist_memEndDate )) - TO_DAYS('".$currentDate."')) as difference FROM ".$tableprefix."artists AS art
      LEFT JOIN ".$tableprefix."artists_membershipDetails AS artMem ON artMem.artist_id  = art.artist_id
      WHERE art.artist_id=".$artID."  GROUP BY art.artist_name";
     */
    $sql = "SELECT max(artMem.artist_memID), max( artMem.artist_memEndDate ) as artist_memEndDate,plan_Id, (To_days( max( artMem.artist_memEndDate )) - TO_DAYS(:currentDate)) as difference
				 FROM " . $tableprefix . "artists_membershipDetails AS artMem
				 WHERE artMem.artist_id=:artist_id GROUP BY artist_memID ORDER BY `artist_memID` DESC LIMIT 0 , 1";


    $result = $pdo->pdoQuery($sql,array("artist_id"=>$artID,"currentDate"=>$currentDate))->results();
    if (!empty($result)) {
        $row = $result[0];
        $dataArray['EndDate'] = $row['artist_memEndDate'];
        $dataArray['difference'] = $row['difference'];
        $dataArray['PlanID'] = $row['plan_Id'];
        $DATA_getplanName = $pdo->select($tableprefix."sellerPlans",array("plan_Title","plan_Period"),array("plan_Id"=>$dataArray['PlanID']))->results();
        $DATA_getplanName = $DATA_getplanName[0];
        $dataArray['PlanTitle'] = $DATA_getplanName['plan_Title'];
        $dataArray['PlanPeriod'] = $DATA_getplanName['plan_Period'];
        $_SESSION['SES_PLANDET'] = $dataArray;
        return $dataArray;
    }
}

function getArtistID($userID) {
    global $tableprefix, $pdo;
    $sql = "SELECT p.product_artist_id
        FROM " . $tableprefix . "cart c
        INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
        INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
        WHERE c.user_id = :user_id ";
    $result = $pdo->pdoQuery($sql, array("user_id" => $userID))->results();
    $total = 0;
    $itemcount = 0;
    $currency_attributes = displayCurrencyType();
    if (!empty($result)) {
        foreach ($result as $row) {
            return $row["product_artist_id"];
        }
    }
}

//fucntion for disaply style array
function ShowTemplates($style) {
    $StylewArray = array();
    //create array
    foreach (showThemes() as $key => $val) {
        $StylewArray[$val['theme_file']] = $key;
    }//end foreach

    asort($StylewArray);
    echo '<select name="style" class="textbox" onChange="showHint(this.value);">';
    foreach ($StylewArray as $key => $value) {
        ?>
        <option value="<?php echo ($key) ?>" <?php
        if ($key == $style) {
            echo 'selected';
        }
        ?>><?php echo $value ?></option>
        <?php
    }//end foreach
    echo '</select>';
}

//end function
//fuction for listing themes from themes folder
function showThemes() {
    $theme_root = '../themes/';
    $themes_dir = @ opendir($theme_root);
    while (($theme_dir = readdir($themes_dir)) !== false) {
        if (is_dir($theme_root . '/' . $theme_dir) && is_readable($theme_root . '/' . $theme_dir)) {
            if ($theme_dir{0} == '.' || $theme_dir == 'CVS')
                continue;

            $stylish_dir = @opendir($theme_root . '/' . $theme_dir);
            $found_stylesheet = false;

            while (($theme_file = readdir($stylish_dir)) !== false) {
                if ($theme_file == 'style.css') {
                    $theme_files[$theme_dir] = array('theme_file' => $theme_dir . '/' . $theme_file, 'theme_root' => $theme_root);
                    $found_stylesheet = true;
                    break;
                }//end if
            }//end while loop
            @closedir($stylish_dir);
        }//end first if
    }//end whil loop
    if (is_dir($theme_dir))
        @closedir($theme_dir);
    return $theme_files;
}

//end function
//function for template preview
function TemplatePreview($stylePath) {
    //split style path
    $styleFolder = @preg_split("[/]", $stylePath);

    $theme_root = '../themes/' . $styleFolder[0];
    $themes_dir = @opendir($theme_root);
    while (($preview_file = readdir($themes_dir)) !== false) {
        if ($preview_file == 'preview.gif') {
            $preview_file = $theme_root . '/' . $preview_file;
            break;
        }//end if
        @closedir($stylish_dir);
    }//end whil loop
    if (is_dir($theme_dir))
        @closedir($theme_dir);
    return $preview_file;
}

//end functionn for listing themes from themes folder

function ProductRatingStar($pid, $units = '', $static = '') {
    global $tableprefix, $_SESSION, $pdo;

    if ($pid != '') {
        $rating_result = $pdo->select($tableprefix . "record_ratings", array('ROUND(SUM(nrating_id)/COUNT(nrating_id)) AS average_rating'), array('vType' => 'p', 'nrseller_id' => $pid))->results();

        $average_rating_count = 0;

        if (!empty($rating_result)) {

            $rating_count = $rating_result[0];
            if ($rating_count['average_rating'] != '') {
                $average_rating_count = $rating_count['average_rating'];
            } else {
                $average_rating_count = 0;
            }
        }
    }
    return $average_rating_count;
}

// Check Selected Category is a Gift Certicate or not
function CheckGiftCertificateCategory($gcatid) {
    global $tableprefix, $pdo;
    if (empty($gcatid) && $catid == NULL)
        return '';
    $rs_gift_cat = $pdo->select($tableprefix . 'categories', array("gift_certificate_flag"), array('category_id' => $gcatid))->results();
    if (!empty($rs_gift_cat)) {
        $giftRow = $rs_gift_cat[0];
    }

    return $giftRow['gift_certificate_flag'];
}

// end shipping method

function sendBuyerEmail($order_id, $user_id, $usertype = 'user') {
    global $tableprefix, $_SESSION, $pdo;

    $currency_attributes = displayCurrencyType();

    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];

    $orderQ = $pdo->select($tableprefix . "orders", array("*", "DATE_FORMAT(order_date,'%m-%d-%Y') as order_dateF"), array("order_id" => $order_id))->results();
    $orderObj = $orderQ[0];
    $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
    $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		<tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
                <td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_TYPE . '</td>
		</tr>';

    // Shipping Cost
    $totalshippingcost = Order::orderShippingCost($order_id);
    // Shipping Cost

   $orderDetailQ =$pdo->select($tableprefix."order_details",'',array("order_id"=>$order_id),"ORDER BY artist_id")->results();

    $itemTotal = 0;
    $digitalFlag = 0;
    $inc = 1;
    foreach ($orderDetailQ as $orderDetailObj) {
        $optionStr = "";

        if ($giftCheckVal) {
            $giftCertificateCode = "<font color='#ff0000'><br>" . MAIL_ORDER_TEXT_GIFT_COUPON_CODE . " " . $orderDetailObj['vgift_coupon_code'] . "</font>";
        }
        $productname = stripslashes($orderDetailObj['product_name']);
        $couponCodeDiscount = $orderObj['couponCodeDiscount'];
        $productname.= $optionStr;

        $converted_price = $orderDetailObj['product_price'];

        $rate = number_format(($converted_price), 2, ".", "");
        // End currency Conversion
        /* ------------Multicart 2.0 Upgradation------------ */

        $qty = $orderDetailObj['product_quantity'];
        $price = $qty * $rate;
        $discountstr = "";
        if ($orderDetailObj['product_discount'] != "0") {
            $price = $price - ($price * $orderDetailObj['product_discount']) / 100;

            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
        }

        if ($orderDetailObj['digital_product_flag'] == 'Y') {

            $productType = MAIL_TEXT_DIGITAL_TYPE;
        } else if ($orderDetailObj['gift_product_flag'] == 'Y') {

            $productType = MAIL_TEXT_GIFT_TYPE;
        } else {

            $productType = MAIL_TEXT_PHYSICAL_TYPE;
        }

        //$productPrice = number_format(($currency_attributes[1] * $productPrice),2,".","");


        $itemTotal+=$price;
        if ($orderDetailObj['digital_product_flag'] == "Y") {
            $digitalFlag = 1;
        } else {
            $product_shipping_cost = ($orderDetailObj['product_shipping_price'] != 0) ? $currency_attributes[0] . '&nbsp;' . number_format($orderDetailObj['product_shipping_price'], 2, ".", "") : $currency_attributes[0] . '&nbsp;0.00';
            $shippingName = ($orderDetailObj['product_shipping_price'] != 0) ? $orderDetailObj['product_shipping_name'] : FREE_SHIP_TEXT;
        }
        if ($orderDetailObj['artist_id'] != $previous_seller_id) {
            $mailContent.='<tr style="background-color:#F1E6E6;padding-bottom:5px;" height="50"> <td colspan=7 style="text-align: left;"><b>' . SELLER_TEXT1 . "</b>: " . getArtistName_Location($orderDetailObj['artist_id']) . '</td></tr>';
        }

        $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . ' </td>
		<td align="left" valign="top">' . $orderDetailObj['product_code'] . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($rate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($price, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
                <td align="left" valign="top">' . $productType . '</td>
                      
		</tr>';


//Digital Product section to show link and download details
        if ($orderDetailObj['digital_product_flag'] == 'Y') {

            $mailContent .='<tr>
                                <td  align="left" valign="top" style="padding:5px 15px 15px 15px; " colspan="7" width="100%">
                                <table width="100%" cellpadding="2" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000;font-color:blue; ">';

            $rs_digital = $pdo->select($tableprefix."digital_product",array("DATE_FORMAT(ndownload_expiry,'%m-%d-%Y') as ndownload_expiry" ,"vdigital_product_code","ndownload_try","ndownload_expiry_days"),array("ndigital_productid"=>$orderDetailObj['product_id'],"ndigital_orderid"=>$order_id))->results();


            $product_download_details = "";

            if (!empty($rs_digital)) {
                $product_download_details_link = "";
                $download_link = "";

                $cnt = 1;

                foreach($rs_digital as $orderDetailObjdigital) {

                    $product_download_try = $orderDetailObjdigital['ndownload_try'];
                    $download_expiry_date = $orderDetailObjdigital['ndownload_expiry'];
                    $expiry_days = $orderDetailObjdigital['ndownload_expiry_days'];
                    $product_download_trydetails = "";
                    $product_download_trydetails .= "<br>Product Download Try - $product_download_try Time(s)\r\n";
                    $product_download_trydetails .= "<br>Download Expiry Date - $download_expiry_date\r\n";

                    $valid_date_upto = date("Y-m-d H:s:m", mktime(date("H"), date("i"), date("s"), date("m"), date("d") + $expiry_days, date("Y")));

                    $mailContent .='<tr><td align="left" valign="top" style="font-size:13px; color:#991818; font-weight:bold; ">
                                        Download Link  ' . $cnt . ' -
                                </td>
                                </tr>

                                <tr>
                                <td align="left" valign="top" style="color:blue;">
                                        Product Download Try - ' . $product_download_try . ' Time(s)
                                </td>
                                </tr>

                                 <tr>
                                <td align="left" valign="top" style="color:blue;">
                                        Download Expiry Date - ' . $download_expiry_date . '
                                </td>
                                </tr>
                                <tr>
                                <td align="left" valign="top" style="color:blue;">
                                        Link  - ' . SITE_URL . '/digital_product_download.php?download_code=' . $orderDetailObjdigital['vdigital_product_code'] . '
                                </td>
                                </tr>';

                    $cnt++;
                }
            }
            $mailContent .='</table></td></tr>';
        } // End Digital Check
        //Digital Product section ends
        if ($orderDetailObj['gift_product_flag'] == 'Y') {
            if ($enable_seller_friendly == "Y") {

                $select_seller_name = "SELECT artist_name,storename FROM " . $tableprefix . "artists WHERE artist_id = " . $orderDetailObj['artist_id'];
                $result_seller_name = mysql_query($select_seller_name) or die(mysql_error());

                if (mysql_num_rows($result_seller_name) > 0) {

                    $seller_name_row = mysql_fetch_assoc($result_seller_name);
                    $txtSellerName = $seller_name_row['artist_name'];
                }
                $friendly_url = (!empty($seller_name_row['storename'])) ? SITE_URL . "/stores/" . $seller_name_row['storename'] : SITE_URL . "/store/" . $seller_name_row['artist_name'];
                //$friendly_url = SITE_URL."/store/".$txtSellerName;
            }  //end of if User Friendly URL checking condition
            else {
                $friendly_url = SITE_URL . "/showportfolio.php?artistid=" . $orderDetailObj['artist_id'];
            }


            $mailContent .='<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; " colspan="7" width="100%" >
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top" colspan="2">
			' . MAIL_GIFT_CERTIFICATE_NOTE . '
		</td>
		</tr>';
            $mailContent .='<tr> <td width="30%">' . MAIL_GIFT_CERTIFICATE_CODE . ' :  </td>
		<td  align="left" valign="top" width="70%">
			<b>' . stripslashes($orderDetailObj['vgift_coupon_code']) . '</b>
		</td>
		</tr>';
            $mailContent .='<tr> <td>' . MAIL_GIFT_SELLER_STORE_URL . ' :  </td>
		<td  align="left" valign="top" >
			<b><a href=' . $friendly_url . ' target="_blank">' . $friendly_url . '</a></b>
		</td>
		</tr></table></td></tr>';
        }


        $inc++;
        $previous_seller_id = $orderDetailObj['artist_id'];
    }
    $mailContent.='</table>
		</td>
		</tr>';


    $ItemTotalPrice = 0;
    //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
    $ItemTotalPrice = $itemTotal;

    $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';

    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_ITEM_PRICE_TOTAL . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
		</tr>';


    // Modified ON 22-07-2015 // Asha
    if ($couponCodeDiscount > 0) {
        //echo "sdhjsdhasd";
        //$priceafterdiscount=$ItemTotalPrice-($ItemTotalPrice*$orderObj->couponCodeDiscount)/100;
        //$couponCodeDiscountAmount = ($ItemTotalPrice*$orderObj->couponCodeDiscount)/100;
        $couponCodeDiscountAmount = $orderObj['couponCodeDiscount'];

        $mailContent.='<tr>
		<td style="font-size:14px; color:#FF0000; font-weight:bold;">' . MAIL_ORDER_TEXT_COUPON_CODE . ' " ' . $orderObj['couponCode'] . ' " ' . MAIL_ORDER_TEXT_DISCOUNT_AMOUNT . '</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; "> ' . $currency_attributes[0] . '&nbsp; ' . number_format($couponCodeDiscountAmount, 2, ".", "") . '&nbsp;</td>
		</tr>';
    }


    if ($orderObj['vgiftcertificate_code'] != '' && $orderObj['nused_gift_amount'] > 0) {

        $giftDiscountAmount = $orderObj['nused_gift_amount'];
        $mailContent.='<tr>
		<td> ' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . ' : </td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $orderObj['vgiftcertificate_code'] . '  </td>
		</tr>
		<tr>
		<td> Gift Certificate Discount Amount :</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($orderObj['nused_gift_amount'], 2, ".", "") . ' </td>
		</tr>';
    }

    if ($orderObj['nused_gift_amount'] > 0 || $couponCodeDiscount > 0) {

        $TotalDiscount = $giftDiscountAmount + $couponCodeDiscountAmount;

        $priceafterdiscount = $ItemTotalPrice - $TotalDiscount;

        $ItemTotalPrice = $priceafterdiscount;

        $mailContent.='<tr>
		<td>Item Total Cost After  Discount:</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($priceafterdiscount, 2, ".", "") . '</td>
		</tr>';
    }



    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_TAXT_RATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . $orderObj['taxrate'] . '</td>
		</tr>';

    if ($totalshippingcost != 0) {
        //echo $orderObj->order_total_price;
        $mailContent .='<tr>
			<td width="40%">' . MAIL_ORDER_TEXT_SHIPPING_AND_HANDLING . ' </td>
			<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($totalshippingcost, 2, ".", "") . '</td>
			</tr>';
    }



    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_ORDER_TOTAL . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice + $totalshippingcost + $orderObj['taxrate'], 2, ".", "") . '</td>
			</tr>';



    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_AMOUNT_PAID . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($orderObj['namount_paid'], 2, ".", "") . '</td>
			</tr>';

    if ($orderObj['billing_address2']) {
        $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
    } else {
        $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
    }
    if ($giftCheckVal == "") {
        if ($orderObj['shipping_address2']) {
            $mailContent .='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_SHIPPING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">

		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['shipping_first_name'] . ' ' . $orderObj['shipping_last_name'] . '<br>
		' . $orderObj['shipping_address1'] . ',<br>
		' . $orderObj['shipping_address2'] . '<br>
		' . $orderObj['shipping_city'] . ', ' . $orderObj['shipping_state'] . ', ' . $orderObj['shipping_country'] . ' ' . $orderObj['shipping_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['shipping_phone'] . '<br>
		' . $orderObj['shipping_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
        } else {
            $mailContent .='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_SHIPPING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">

		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['shipping_first_name'] . ' ' . $orderObj['shipping_last_name'] . '<br>
		' . $orderObj['shipping_address1'] . ',<br>
		' . $orderObj['shipping_city'] . ', ' . $orderObj['shipping_state'] . ', ' . $orderObj['shipping_country'] . ' ' . $orderObj['shipping_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['shipping_phone'] . '<br>
		' . $orderObj['shipping_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
        }
    }

    if ($usertype == "guest") {
        $rs_Order = $pdo->select($tableprefix . "users", array("user_name", "email"), array("user_id" => $orderObj['user_id']))->results();
        if (!empty($rs_Order)) {
            $rs_Order_obj = $rs_Order[0];

            $guest_user_name = $rs_Order_obj['user_name'];

            $guest_user_password = $_SESSION["sess_guest_password"];

            $mailContent .='<tr><td>&nbsp;</td></tr>';

            $mailContent .='<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr><td> <I>' . MAIL_ORDER_TEXT_NOTE . ' </I> ' . str_replace('{store_login}', $orderObj['storename'] . ' ( ' . SITE_URL . ')', MAIL_ORDER_TEXT_NOTE_MSG) . '</td></tr>';

            $mailContent .='<tr><td>' . MAIL_ORDER_TEXT_USER_NAME . ' &nbsp;<b>' . $guest_user_name . '</b></td></tr>';

            $mailContent .='<tr><td>' . MAIL_ORDER_TEXT_PASSWORD . ' &nbsp;<b>' . $guest_user_password . '</b></td></tr>';

            $mailContent .='<tr><td>&nbsp;</td></tr></table>';
        }
    }

    $mailContent .='</table>';

    $mailcontent_buyer = readEmailTemplate('order_notification_buyer');

    if (stristr($mailcontent_buyer, "[buyer_first_name")) {
        $mailcontent_buyer = str_replace('[buyer_first_name]', $orderObj['billing_first_name'], $mailcontent_buyer);
    }
    if (stristr($mailcontent_buyer, "[buyer_last_name")) {
        $mailcontent_buyer = str_replace('[buyer_last_name]', $orderObj['billing_last_name'], $mailcontent_buyer);
    }


    $mailcontent_buyer = str_replace('[order_details]', $mailContent, $mailcontent_buyer);


    $mail_send_details_buyer = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_buyer . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>

</body>
</html>';

    //echo $mail_send_details_buyer;exit;

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_ORDER_SUBJECT . " " . SITE_NAME;

    //echo $mail_send_details_buyer;
    //$orderObj->billing_email = 'armiatester@gmail.com';
    $mailsent = mail($orderObj['billing_email'], $ordersubject, $mail_send_details_buyer, $headers);

    // echo $mailContent;
}
function sendSellerEmail($order_id, $user_id) {
    global $tableprefix,$pdo;

    $adminCurrency = GetAdminCurrency();

    $currencySymbol = $adminCurrency['currency_symbol'];

    $orderQ = $pdo->select($tableprefix . "orders", array("*", "DATE_FORMAT(order_date,'%m-%d-%Y') as order_dateF"), array("order_id" => $order_id))->results();
    $orderObj = $orderQ[0];

    $couponCodeDiscount = $orderObj['couponCodeDiscount'];
    $couponCodeSeller = $orderObj['couponCodeSeller_Id'];

    $queryOrderDetail_seller = "SELECT DISTINCT od.artist_id,s.*
  										FROM " . $tableprefix . "order_details od
										INNER JOIN " . $tableprefix . "artists s ON s.artist_id=od.artist_id
										WHERE od.order_id =:order_id";
    $orderDetailQ_seller = $pdo->pdoQuery($queryOrderDetail_seller,array("order_id"=>$order_id))->results();

    foreach($orderDetailQ_seller as $orderobjseller) {

        $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
        $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		<tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_TYPE . '</td>
		</tr>';


        $orderDetailQ = $pdo->select($tableprefix."order_details",'',array("order_id"=>$order_id,"artist_id"=>$orderobjseller['artist_id']))->results();
        $itemTotal = 0;
        $inc = 1;
        $totalshippingcost = 0;
        $taxTotal = 0;
        $productlist_fillstock = array();
        if ($orderDetailObj['digital_product_flag'] == "Y") {
            $digitalFlag = 1;
        }

        foreach ($orderDetailQ as $orderDetailObj) {
            $optionStr = "";

            if ($orderDetailObj['digital_product_flag'] == 'Y') {

                $productType = MAIL_TEXT_DIGITAL_TYPE;
            } else if ($orderDetailObj['gift_product_flag'] == 'Y') {

                $productType = MAIL_TEXT_GIFT_TYPE;
            } else {

                $productType = MAIL_TEXT_PHYSICAL_TYPE;
            }
            if ($giftCheckVal) {
                $giftCertificateCode = "<font color='#ff0000'><br>" . MAIL_ORDER_TEXT_GIFT_COUPON_CODE . " " . $orderDetailObj['vgift_coupon_code'] . "</font>";
            }
            $productname = stripslashes($orderDetailObj['product_name']);
            $couponCodeDiscount = $orderObj['couponCodeDiscount'];
            $productname.= $optionStr;
            // Shipping Cost
            $totalshippingcost = Order::orderShippingCost($order_id, $orderobjseller['artist_id']);
            // Shipping Cost

        $converted_price = $orderDetailObj['product_price'];

            $rate = number_format(($converted_price), 2, ".", "");
            // End currency Conversion
            /* ------------Multicart 2.0 Upgradation------------ */

        $qty = $orderDetailObj['product_quantity'];
            $price = $qty * $rate;
            $discountstr = "";
        if ($orderDetailObj['product_discount'] != "0") {
            $price = $price - ($price * $orderDetailObj['product_discount']) / 100;

                $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
            }



            //$productPrice = number_format(($currency_attributes[1] * $productPrice),2,".","");


            $itemTotal+=$price;

            $taxTotal+=$orderDetailObj['product_tax'];

            $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . ' </td>
		<td align="left" valign="top">' . $orderDetailObj['product_code'] . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $currencySymbol . '&nbsp;' . number_format($rate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currencySymbol . '&nbsp;' . number_format($price, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
                <td align="left" valign="top">' . $productType . '</td> 
		</tr>';
            $inc++;
        }
        $mailContent.='</table>
		</td>
		</tr>';



        $ItemTotalPrice = 0;
        //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
        $ItemTotalPrice = $itemTotal;
        $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';

        $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_ITEM_PRICE_TOTAL . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currencySymbol . ' &nbsp;' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
		</tr>';

        // Modified ON 06-05-2015 // Asha
        $couponFlag = 0;
        if ($couponCodeSeller == $orderobjseller['artist_id']) {
            $couponFlag = 1;
            //$couponCodeDiscountAmount = ($ItemTotalPrice*$orderObj->couponCodeDiscount)/100;
            $couponCodeDiscountAmount = $orderObj['couponCodeDiscount'];
            $mailContent.='<tr>
		<td style="font-size:14px; color:#FF0000; font-weight:bold;">' . MAIL_ORDER_TEXT_COUPON_CODE . ' " ' . $orderObj['couponCode'] . ' " ' . MAIL_ORDER_TEXT_DISCOUNT_AMOUNT . '</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; "> ' . $currencySymbol . '&nbsp; ' . number_format($couponCodeDiscountAmount, 2, ".", "") . '&nbsp;</td>
		</tr>';
        }

        if ($orderObj['vgiftcertificate_code'] != '' && $orderObj['nused_gift_amount'] > 0) {

            $giftDiscountAmount = $orderObj['nused_gift_amount'];
            $mailContent.='<tr>
		<td> ' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . ' : </td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $orderObj['vgiftcertificate_code'] . '  </td>
		</tr>
		<tr>
		<td> ' . MAIL_GIFT_CERTIFICATE_TEXT . ':</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currencySymbol . '&nbsp; ' . number_format($orderObj['nused_gift_amount'], 2, ".", "") . ' </td>
		</tr>';
        }

        if ($orderObj['nused_gift_amount'] > 0 || $couponFlag == 1) {

            $TotalDiscount = $giftDiscountAmount + $couponCodeDiscountAmount;

            $priceafterdiscount = $ItemTotalPrice - $TotalDiscount;

            $ItemTotalPrice = $priceafterdiscount;

            $mailContent.='<tr>
		<td>Item Total Cost After  Discount:</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currencySymbol . '&nbsp; ' . number_format($priceafterdiscount, 2, ".", "") . '</td>
		</tr>';
        }
        $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_TAXT_RATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currencySymbol . ' &nbsp; ' . $taxTotal . '</td>
		</tr>';

        if ($totalshippingcost != 0) {
            //echo $orderObj->order_total_price;
            $mailContent .='<tr>
			<td width="40%">' . MAIL_ORDER_TEXT_SHIPPING_AND_HANDLING . ' </td>
			<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . $currencySymbol . ' &nbsp; ' . number_format($totalshippingcost, 2, ".", "") . '</td>
			</tr>';
        }

        $mailContent .='<tr>
			<td>Order Total Price:</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currencySymbol . ' &nbsp; ' . number_format($ItemTotalPrice + $totalshippingcost + $taxTotal, 2, ".", "") . '</td>
			</tr>';




    if ($orderObj['billing_address2']) {
            $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
        } else {
            $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
        }
        if ($giftCheckVal == "") {
        if ($orderObj['shipping_address2']) {
                $mailContent .='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_SHIPPING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">

		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['shipping_first_name'] . ' ' . $orderObj['shipping_last_name'] . '<br>
		' . $orderObj['shipping_address1'] . ',<br>
		' . $orderObj['shipping_address2'] . '<br>
		' . $orderObj['shipping_city'] . ', ' . $orderObj['shipping_state'] . ', ' . $orderObj['shipping_country'] . ' ' . $orderObj['shipping_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['shipping_phone'] . '<br>
		' . $orderObj['shipping_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
            } else {
                $mailContent .='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_SHIPPING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">

		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['shipping_first_name'] . ' ' . $orderObj['shipping_last_name'] . '<br>
		' . $orderObj['shipping_address1'] . ',<br>
		' . $orderObj['shipping_city'] . ', ' . $orderObj['shipping_state'] . ', ' . $orderObj['shipping_country'] . ' ' . $orderObj['shipping_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['shipping_phone'] . '<br>
		' . $orderObj['shipping_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
            }
        }

        $mailContent .='</table>';

        $mailcontent_seller = readEmailTemplate('order_notification_mail_seller');

        //  echo $mailcontent_seller;

        $mailcontent_seller = str_replace('[order_details]', $mailContent, $mailcontent_seller);

        $mail_send_details_seller = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>
<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA" >
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td bgcolor="#EAEAEA" ><img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
			<tr>
			<td align="left"> ' . MAIL_ORDER_TEXT_DEAR . ' ' . $orderobjseller->first_name . '&nbsp;' . $orderobjseller->last_name . ', </td>
			<tr>
			<tr>
			<td align="left">' . MAIL_ORDER_TEXT_NEW_ORDER_PLACED_IN . ' ' . SITE_NAME . '. ' . MAIL_ORDER_TEXT_THE_DETAILS_ARE_AS_FOLLOWS . '</td>
			</tr>

			<tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left">' . $mailcontent_seller . '</td>
                </tr>

              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

//echo "<br>".$mail_send_details_seller;

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
        $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
        $headers .= "Organization: " . SITE_NAME . "\r\n";

        $ordersubject = MAIL_ORDER_SUBJECT . " " . SITE_NAME;

        //$orderobjseller->email='armiatester@gmail.com';
        //echo $ordersubject,$mail_send_details_seller;

        $mailsent = mail($orderobjseller['email'], $ordersubject, $mail_send_details_seller, $headers);

        // Send Stock reorder Mail
    } // end while loop of artists
    // echo $mailContent;
}

function checkSellerStock($product_option_id, $quantity = 0) {
    global $tableprefix, $pdo;
    $stockDetailQ = $pdo->select($tableprefix . "product_options", array("product_stock", "reorder_level"), array("product_option_id" => $product_option_id))->results();

    $reorderStatus = 0;
    if (!empty($stockDetailQ)) {
        $rowObj = $stockDetailQ[0];
        $productstock = $rowObj['product_stock'];
        $newStock = $productstock - $quantity;
        $reorderlevel = $rowObj['reorder_level'];
        if ($newStock <= $reorderlevel) {
            $reorderStatus = 1;
        }
    }

    return $reorderStatus;
}

function sendStockreordermail($product_option_id, $quantity = 0) {
    global $tableprefix, $pdo;

    $queryOrderDetail = "SELECT p.*,s.*,po.product_stock
                                    FROM " . $tableprefix . "product_options po
                                    INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
                                    INNER JOIN " . $tableprefix . "artists s ON s.artist_id = p.product_artist_id
                                    WHERE po.product_option_id=:product_option_id ";
    $orderDetailQ = $pdo->pdoQuery($queryOrderDetail, array("product_option_id" => $product_option_id))->results();
    $optionVal = getProductOptionsName($product_option_id);



    if (!empty($orderDetailQ)) {

        $productObj = $orderDetailQ[0];

        $currentStock = $productObj['product_stock'] - $quantity;

        $mailcontent = '<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_STOCK_RE_ORDER_INFO . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
        $mailcontent .= '<tr>
		<td >' . MAIL_ORDER_TEXT_PRODUCT_NAME . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . stripslashes($productObj['product_name']) . " " . $optionVal . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_STOCK_RE_ORDER_CURRENT_STOCK . ' </td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currentStock . '</td>
		</tr>
		<tr>
		</table>
		</td>
		</tr></table>';

        $mailcontent_reorder = readEmailTemplate('stock_reorder');
        $mailcontent_reorder = str_replace('[product_details]', $mailcontent, $mailcontent_reorder);

        //   echo $mailcontent_reorder;



        $mail_send_details_seller = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>
<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA" >
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td bgcolor="#EAEAEA" ><img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
			<tr>
			<td align="left" height="50"> ' . MAIL_ORDER_TEXT_DEAR . ' ' . $productObj['first_name'] . '&nbsp;' . $productObj['last_name'] . ', </td>
			<tr>
			<tr>
			<td align="left">' . MAIL_STOCK_RE_ORDER_NOTE . ' - ' . SITE_NAME . '. ' . MAIL_ORDER_TEXT_THE_DETAILS_ARE_AS_FOLLOWS . '</td>
			</tr>

			<tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left">' . $mailcontent_reorder . '</td>
                </tr>

              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>
</body>
</html>';

        // echo $mail_send_details_seller;
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
        $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
        $headers .= "Organization: " . SITE_NAME . "\r\n";
        $ordersubject_fillstock = MAIL_STOCK_RE_ORDER_SUBJECT . " " . SITE_NAME;
        //echo $productObj->email;
        //$productObj->email="asha.s@armiasystems.com";

        $mailsent = mail($productObj['email'], $ordersubject_fillstock, $mail_send_details_seller, $headers);
    }

    //$productlist_fillstock
}

function sendgiftCertificateMail_Buyer($order_id, $user_id, $usertype = '') {
    global $tableprefix, $_SESSION, $pdo;
    include "config.php";

    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];

    $orderQ = $pdo->select($tableprefix . "orders", array("*", "DATE_FORMAT(order_date,'%m-%d-%Y') as order_dateF"), array("order_id" => $order_id))->results();
    $orderObj = $orderQ[0];
    $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
    $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>

		</tr>';
    $queryOrderDetail = "SELECT od.*,gc.vgift_coupon_code
  						FROM " . $tableprefix . "order_details od
						INNER JOIN " . $tableprefix . "giftcertificates gc ON gc.ngift_product_id=od.product_id AND gc.ngift_order_id=:order_id
						WHERE od.order_id =:order_id";
    $orderDetailQ = $pdo->pdoQuery($queryOrderDetail, array("order_id" => $order_id))->results();
    $itemTotal = 0;
    $inc = 1;
    foreach ($orderDetailQ as $orderDetailObj) {
        $optionStr = "";

        if ($giftCheckVal) {
            $giftCertificateCode = "<font color='#ff0000'><br>" . MAIL_ORDER_TEXT_GIFT_COUPON_CODE . " " . $orderDetailObj['vgift_coupon_code'] . "</font>";
        }
        $productname = stripslashes($orderDetailObj['product_name']);


        $productRate = $orderDetailObj['product_price'];
        $productPrice = $productRate * $orderDetailObj['product_quantity'];
        $discountstr = "";
        if ($orderDetailObj['product_discount'] != 0) {
            $productPrice = $productPrice - ($productPrice * $orderDetailObj['product_discount']) / 100;
            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
        }


        $converted_price = $productPrice;

        $productPrice = number_format($converted_price, 2, ".", "");


        $itemTotal+=$productPrice;

        $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $orderDetailObj['vgift_coupon_code'] . '</td>
		<td align="left" valign="top"> ' . $currency_attributes[0] . '&nbsp;' . number_format($productRate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($productPrice, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
		</tr>';

        if ($enable_seller_friendly == "Y") {

            $result_seller_name = $pdo->select($tableprefix . "artists", array("artist_name"), array("artist_id" => $orderDetailObj['artist_id']))->results();

            if (!empty($result_seller_name)) {

                $seller_name_row = $result_seller_name[0];
                $txtSellerName = $seller_name_row['artist_name'];
            }

            $friendly_url = SITE_URL . "/store/" . $txtSellerName;
        }  //end of if User Friendly URL checking condition
        else {
            $friendly_url = SITE_URL . "/showportfolio.php?artistid=" . $orderDetailObj['artist_id'];
        }


        $mailContent .='<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; " colspan="6">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
			' . MAIL_GIFT_COUPON_NOTE . '
		</td>
		</tr>';
        $mailContent .='<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			' . $friendly_url . '
		</td>
		</tr></table></td></tr>';

        $inc++;
    }
    $mailContent.='</table>
		</td>
		</tr>';

    $ItemTotalPrice = 0;
    //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
    $ItemTotalPrice = $itemTotal;

    $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';

    $mailContent .='<tr>
			<td>Gift Certificate Dicount Amount:</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp;' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
			</tr>';
    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_TAXT_RATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . $orderObj->taxrate . '</td>
		</tr>';

    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_ORDER_TOTAL . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice + $orderObj->taxrate, 2, ".", "") . '</td>
			</tr>';

    if ($orderObj['billing_address2']) {
        $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
    } else {
        $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
    }

    if ($usertype == "guest") {
        $rs_Order = $pdo->select($tableprefix . "users", array("user_name", "email"), array("user_id" => $orderObj['user_id']))->results();
        if (!empty($rs_Order)) {
            $rs_Order_obj = $rs_Order[0];

            $guest_user_name = $rs_Order_obj['user_name'];

            $guest_user_password = $_SESSION["sess_guest_password"];

            $mailContent .='<tr><td>&nbsp;</td></tr>';

            $mailContent .='<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr><td> <I>' . MAIL_ORDER_TEXT_NOTE . ' </I> ' . str_replace('{store_login}', $orderObj['storename'] . ' ( ' . SITE_URL . ')', MAIL_ORDER_TEXT_NOTE_MSG) . '</td></tr>';

            $mailContent .='<tr><td>' . MAIL_ORDER_TEXT_USER_NAME . ' &nbsp;<b>' . $guest_user_name . '</b></td></tr>';

            $mailContent .='<tr><td>' . MAIL_ORDER_TEXT_PASSWORD . ' &nbsp;<b>' . $guest_user_password . '</b></td></tr>';

            $mailContent .='<tr><td>&nbsp;</td></tr></table> </TD></TR>';
        }
    }


    $mailContent .='</table>';


    $mailcontent_buyer = readEmailTemplate('gift_coupon');

    if (stristr($mailcontent_buyer, "[buyer_first_name")) {
        $mailcontent_buyer = str_replace('[buyer_first_name]', $orderObj['billing_first_name'], $mailcontent_buyer);
    }
    if (stristr($mailcontent_buyer, "[buyer_last_name")) {
        $mailcontent_buyer = str_replace('[buyer_last_name]', $orderObj['billing_last_name'], $mailcontent_buyer);
    }

    $mailcontent_buyer = str_replace('[coupon_details]', $mailContent, $mailcontent_buyer);


    $mail_send_details_buyer = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_buyer . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

//echo $mail_send_details_buyer;

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_GIFT_COUPON_SUBJECT . " " . SITE_NAME;

    $mailsent = mail($orderObj['billing_email'], $ordersubject, $mail_send_details_buyer, $headers);
}

function sendAdminEmail($order_id, $user_id) {
    global $tableprefix,$pdo;


    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];

   $orderQ = $pdo->select($tableprefix . "orders", array("*", "DATE_FORMAT(order_date,'%m-%d-%Y') as order_dateF"), array("order_id" => $order_id))->results();
    $orderObj = $orderQ[0];
    $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
    $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		<tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
                <td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_TYPE . '</td>
		</tr>';

     $orderDetailQ =$pdo->select($tableprefix."order_details",'',array("order_id"=>$order_id),"ORDER BY artist_id")->results();
    $itemTotal = 0;
    $inc = 1;
    foreach ($orderDetailQ as $orderDetailObj) {
        $optionStr = "";

        if ($giftCheckVal) {
            $giftCertificateCode = "<font color='#ff0000'><br>" . MAIL_ORDER_TEXT_GIFT_COUPON_CODE . " " . $orderDetailObj['vgift_coupon_code'] . "</font>";
        }
        $productname = stripslashes($orderDetailObj['product_name']);
        $couponCodeDiscount = $orderObj['couponCodeDiscount'];
        $productname.= $optionStr;

        if ($orderDetailObj['digital_product_flag'] == 'Y') {

            $productType = MAIL_TEXT_DIGITAL_TYPE;
        } else if ($orderDetailObj['gift_product_flag'] == 'Y') {

            $productType = MAIL_TEXT_GIFT_TYPE;
        } else {

            $productType = MAIL_TEXT_PHYSICAL_TYPE;
        }

        // Shipping Cost

        $totalshippingcost = Order::orderShippingCost($order_id);

        /* if($orderDetailObj->nshipping_cost!=0) {
          $totalshippingcost += $orderDetailObj->nshipping_cost;
          } */
        // Shipping Cost

        $converted_price = $orderDetailObj['product_price'];

        $rate = number_format(($converted_price), 2, ".", "");
        // End currency Conversion
        /* ------------Multicart 2.0 Upgradation------------ */

        $qty = $orderDetailObj['product_quantity'];
        $price = $qty * $rate;
        $discountstr = "";
        if ($orderDetailObj['product_discount'] != "0") {
            $price = $price - ($price * $orderDetailObj['product_discount']) / 100;

            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
        }



        //$productPrice = number_format(($currency_attributes[1] * $productPrice),2,".","");


        $itemTotal+=$price;
        if ($orderDetailObj['digital_product_flag'] == "Y") {
            $product_shipping_cost = $currency_attributes[0] . '&nbsp;0.00';
            ;
            $shippingName = NO_SHIPPING;
        } else {
            $product_shipping_cost = ($orderDetailObj['product_shipping_price'] != 0) ? $currency_attributes[0] . '&nbsp;' . number_format($orderDetailObj['product_shipping_price'], 2, ".", "") : $currency_attributes[0] . '&nbsp;0.00';
            $shippingName = ($orderDetailObj['product_shipping_price'] != 0) ? $orderDetailObj['product_shipping_name'] : FREE_SHIP_TEXT;
        }

        if ($orderDetailObj['artist_id'] != $previous_seller_id) {
            $mailContent.='<tr style="background-color:#F1E6E6;padding-bottom:5px;" height="50"><td colspan=7 style="text-align: left;"><b>' . SELLER_TEXT1 . "</b>: " . getArtistName_Location($orderDetailObj['artist_id']) . '</td></tr>';
        }
        $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . ' </td>
		<td align="left" valign="top">' . $orderDetailObj['product_code'] . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($rate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($price, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
                <td align="left" valign="top">' . $productType . '</td>
		</tr>';


        $inc++;
        $previous_seller_id = $orderDetailObj['artist_id'];
    }
    $mailContent.='</table>
		</td>
		</tr>';

    $ItemTotalPrice = 0;
    //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
    $ItemTotalPrice = $itemTotal;

    $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';

    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_ITEM_PRICE_TOTAL . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
		</tr>';



    // Modified ON 22-07-2010 // Asha
    if ($couponCodeDiscount > 0) {
        //echo "sdhjsdhasd";
        //$priceafterdiscount=$ItemTotalPrice-($ItemTotalPrice*$orderObj->couponCodeDiscount)/100;
        //$ItemTotalPrice=$priceafterdiscount;
        $couponCodeDiscountAmount = $orderObj['couponCodeDiscount'];
        $mailContent.='<tr>
		<td style="font-size:14px; color:#FF0000; font-weight:bold;">' . MAIL_ORDER_TEXT_COUPON_CODE . ' " ' . $orderObj['couponCode'] . ' " ' . MAIL_ORDER_TEXT_DISCOUNT_AMOUNT . '</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; "> ' . $currency_attributes[0] . '&nbsp; ' . number_format($couponCodeDiscountAmount, 2, ".", "") . '&nbsp;</td>
		</tr>';
    }
    if ($orderObj['vgiftcertificate_code'] != '' && $orderObj['nused_gift_amount'] > 0) {

        $giftDiscountAmount = $orderObj['nused_gift_amount'];
        $mailContent.='<tr>
		<td> ' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . ' : </td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $orderObj['vgiftcertificate_code'] . '  </td>
		</tr>
		<tr>
		<td> ' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_AMOUNT . '</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($orderObj['nused_gift_amount'], 2, ".", "") . ' </td>
		</tr>';
    }

    if ($orderObj['nused_gift_amount'] > 0 || $couponCodeDiscount > 0) {

        $TotalDiscount = $giftDiscountAmount + $couponCodeDiscountAmount;

        $priceafterdiscount = $ItemTotalPrice - $TotalDiscount;

        $ItemTotalPrice = $priceafterdiscount;

        $mailContent.='<tr>
		<td>Item Total Cost After  Discount:</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($priceafterdiscount, 2, ".", "") . '</td>
		</tr>';
    }

    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_TAXT_RATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . $orderObj['taxrate'] . '</td>
		</tr>';

    if ($totalshippingcost != 0) {
        //echo $orderObj->order_total_price;
        $mailContent .='<tr>
			<td width="40%">' . MAIL_ORDER_TEXT_SHIPPING_AND_HANDLING . ' </td>
			<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($totalshippingcost, 2, ".", "") . '</td>
			</tr>';
    }


    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_ORDER_TOTAL . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice + $totalshippingcost + $orderObj['taxrate'], 2, ".", "") . '</td>
			</tr>';




    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_AMOUNT_PAID . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($orderObj['namount_paid'], 2, ".", "") . '</td>
			</tr>';


    if ($orderObj['billing_address2']) {
        $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
    } else {
        $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
    }
    if ($giftCheckVal == "") {
        if ($orderObj['shipping_address2']) {
            $mailContent .='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_SHIPPING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">

		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['shipping_first_name'] . ' ' . $orderObj['shipping_last_name'] . '<br>
		' . $orderObj['shipping_address1'] . ',<br>
		' . $orderObj['shipping_address2'] . '<br>
		' . $orderObj['shipping_city'] . ', ' . $orderObj['shipping_state'] . ', ' . $orderObj['shipping_country'] . ' ' . $orderObj['shipping_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['shipping_phone'] . '<br>
		' . $orderObj['shipping_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
        } else {
            $mailContent .='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_SHIPPING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">

		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['shipping_first_name'] . ' ' . $orderObj['shipping_last_name'] . '<br>
		' . $orderObj['shipping_address1'] . ',<br>
		' . $orderObj['shipping_city'] . ', ' . $orderObj['shipping_state'] . ', ' . $orderObj['shipping_country'] . ' ' . $orderObj['shipping_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['shipping_phone'] . '<br>
		' . $orderObj['shipping_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
        }
    }

    $mailContent .='</table>';

    $mailcontent_admin = readEmailTemplate('order_notification_admin');

    //echo $orderObj->billing_first_name.$orderObj->billing_last_name;
    //echo "<br>";

    $mailcontent_admin = str_replace('[buyer_first_name]', $orderObj['billing_first_name'], $mailcontent_admin);

    $mailcontent_admin = str_replace('[buyer_last_name]', $orderObj['billing_last_name'], $mailcontent_admin);

    $mailcontent_admin = str_replace('[order_details]', $mailContent, $mailcontent_admin);


    $mail_send_details_admin = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_admin . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

//echo $mail_send_details_admin;exit;

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_ORDER_SUBJECT . " " . SITE_NAME;

    //$orderObj->billing_email='asha.s@armiasystems.com';
    //echo $mail_send_details_admin;

    $adminemail = getSettingsValue('site_email');
    //$adminemail     =   'armiatester@gmail.com';
    $mailsent = mail($adminemail, $ordersubject, $mail_send_details_admin, $headers);

    // echo $mailContent;
}

function dopagingbypdo($sql, $numrecords = 0, $limit = 15, $valueArray, $pdo) {


    global $clspg;
    global $pages;
    global $num;
    global $tableprefix;
    $clspg = new Pager;
    $numrows = $pdo->pdoQuery($sql, $valueArray)->iAffectedRows;
    $start = $clspg->findStart($limit, $numrows);
    if ($numrecords == 0)
        $pages = $clspg->findPages($numrows, $limit);
    else {
        if ($numrows > $numrecords)
            $pages = $clspg->findPages($numrecords, $limit);
        else
            $pages = $clspg->findPages($numrows, $limit);
    }
    if ($numrecords == 0)
        $sql1 = $sql . " LIMIT " . $start . ", " . $limit;
    else {
        if (($start + $limit) > $numrecords)
            $sql1 = $sql . " LIMIT " . $start . ", " . ($numrecords - $start);
        else
            $sql1 = $sql . " LIMIT " . $start . ", " . $limit;
    }


    return $sql1;
}

//***************************************************function for paging
function dopaging($sql, $numrecords = 0, $limit = 15) {


    global $clspg;
    global $pages;
    global $num;
    $clspg = new Pager;
    $temp = mysql_query($sql) or die(mysql_error());
    $numrows = mysql_num_rows($temp);
    $start = $clspg->findStart($limit, $numrows);
    if ($numrecords == 0)
        $pages = $clspg->findPages($numrows, $limit);
    else {
        if ($numrows > $numrecords)
            $pages = $clspg->findPages($numrecords, $limit);
        else
            $pages = $clspg->findPages($numrows, $limit);
    }
    if ($numrecords == 0)
        $sql1 = $sql . " LIMIT " . $start . ", " . $limit;
    else {
        if (($start + $limit) > $numrecords)
            $sql1 = $sql . " LIMIT " . $start . ", " . ($numrecords - $start);
        else
            $sql1 = $sql . " LIMIT " . $start . ", " . $limit;
    }


    return $sql1;
}

function leftpaging() {
    global $clspg;
    global $pages;
    $pagelist = "";
//checking version
    $version = substr(phpversion(), 0, 1);

    if ($version < 5) {
        if (trim($clspg) != "")
            if ($pages > 1)
                $pagelist = $clspg->pageList($_GET['page'], $pages);
    }
    else {
        if ($clspg != "")
            if ($pages > 1)
                $pagelist = $clspg->pageList($_GET['page'], $pages);
    }
    return $pagelist;
}

function rightpaging() {

    global $clspg;
    global $pages;
    $pagelist = "";

//checking version
    $version = substr(phpversion(), 0, 1);

    if ($version < 5) {

        if (trim($clspg) != "")
            if ($pages > 1)
                $pagelist = $clspg->pageList($_GET['page'], $pages);
    }
    else {
        if ($clspg != "")
            if ($pages > 1)
                $pagelist = $clspg->pageList($_GET['page'], $pages);
    }

    return $pagelist;
}

///************************************************************end of paging

function formatPrice($price) {
    //$price=ceil($price);
    $price = number_format($price, 2, '.', '');
    return $price;
}

// Function To Get Count of Cart Items of a Particular User
function GetUserCartCount($userid) {
    global $tableprefix, $pdo;
    $sql_cart = "SELECT count(c.cart_id) as cartCount
	 			FROM " . $tableprefix . "cart  c
                                INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
                                INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
			    WHERE c.user_id=:userid";
    $resultdate = $pdo->pdoQuery($sql_cart, array("userid" => $userid))->results();
    $cartCount = $resultdate[0]['cartCount'];
    if (!$cartCount) {
        $cartCount = 0;
    }
    return $cartCount;
}

// Function To Get Count of Cart Items of a Particular Visitor User
function GetVisitorCartCount($visitorid) {
    global $tableprefix, $pdo;

    $sql_cart = "SELECT count(c.cart_id) as cartCount
			   FROM " . $tableprefix . "cart  c
                            INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
                            INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
			   WHERE c.visitor_cart_id=:cart_id ";

    $rs_cart = $pdo->pdoQuery($sql_cart, array('cart_id' => $visitorid))->results();
    ;
    if (!empty($rs_cart[0]))
        $cartCount = $rs_cart[0]['cartCount'];
    if (!$cartCount) {
        $cartCount = 0;
    }
    return $cartCount;
}

function generatePassword($length = 6, $level = 2) {

    list($usec, $sec) = explode(' ', microtime());
    srand((float) $sec + ((float) $usec * 100000));

    $validchars[1] = "0123456789abcdfghjkmnpqrstvwxyz";
    $validchars[2] = "0123456789abcdfghjkmnpqrstvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $validchars[3] = "abcdfghjkmnpqrstvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    $password = "";
    $counter = 0;

    while ($counter < $length) {
        $actChar = substr($validchars[$level], rand(0, strlen($validchars[$level]) - 1), 1);

        // All character must be different
        if (!strstr($password, $actChar)) {
            $password .= $actChar;
            $counter++;
        }
    }

    return $password;
}

function generateUsername($length = 6, $level = 2) {

    list($usec, $sec) = explode(' ', microtime());
    srand((float) $sec + ((float) $usec * 100000));

    $validchars[1] = "0123456789abcdfghjkmnpqrstvwxyz";
    $validchars[2] = "0123456789abcdfghjkmnpqrstvwxyz";
    $validchars[3] = "abcdfghjkmnpqrstvwxyz";

    $username = "";
    $counter = 0;

    while ($counter < $length) {
        $actChar = substr($validchars[$level], rand(0, strlen($validchars[$level]) - 1), 1);

        // All character must be different
        if (!strstr($password, $actChar)) {
            $username .= $actChar;
            $counter++;
        }
    }

    return $username;
}

function getAdminMenus($parentid) {
    global $tableprefix, $pdo;
    $arr1 = array();
    $qry = "select b.* from " . $tableprefix . "admin_menu b where  ";
    $qry .=" b.parent_id= :parentid and b.status ='ACTIVE' ORDER BY b.display_order";

    // echo $qry;die();
    $res = $pdo->pdoQuery($qry,array("parentid"=>$parentid))->results();
    if (count($res) != 0) {
        $i = 0;
        foreach ($res as $rws) {
            $arr1[$i]["menu_id"] = $rws["menu_id"];
            $arr1[$i]["page_name"] = $rws["page_name"];
            $arr1[$i]["link"] = SITE_URL . "/admin/" . $rws["link"];
            $arr1[$i]["divname"] = $rws["divname"];
            $arr1[$i]["title"] = $rws["title"];
            $ChildNodeExists = whetherAdminChildNodeExist($rws["menu_id"]);
            if ($ChildNodeExists === TRUE) {
                $arr1[$i]['subpage'] = getAdminMenus($rws["menu_id"]);
                $i++;
            } else {
                $i++;
            }
        }
    }
    return $arr1;
}

function whetherAdminChildNodeExist($pageId) {
    global $tableprefix, $pdo;
    $Qry = "SELECT COUNT(*) AS TotCount FROM " . $tableprefix . "admin_menu WHERE parent_id = :pageId and status='ACTIVE'";
    //$Row		=	$this->db->get_row($Qry, ARRAY_A);
    $res = $pdo->pdoQuery($Qry,array("pageId"=>$pageId))->results();
    if (count($res) != 0) {
        $rws = ($res[0]);
    }
    $TotCount = $rws['TotCount'];
    if ($TotCount > 0)
        return TRUE;
    else
        return FALSE;
}

function sendgiftCertificateMail_Seller($order_id, $user_id) {

    global $tableprefix, $pdo;


    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];

    $orderQ = $pdo->select($tableprefix . "orders", array("*", "DATE_FORMAT(order_date,'%m-%d-%Y') as order_dateF"), array("order_id" => $order_id))->results();
    $orderObj = $orderQ[0];

    $queryOrderDetail_seller = "SELECT DISTINCT od.artist_id,s.* FROM " . $tableprefix . "order_details od
										INNER JOIN " . $tableprefix . "artists s ON s.artist_id=od.artist_id
										WHERE od.order_id =:order_id";
    $orderDetailQ_seller = $pdo->pdoQuery($queryOrderDetail_seller, array("order_id" => $order_id))->results();

    foreach ($orderDetailQ_seller as $orderobjseller) {

        $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
        $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		<tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
		</tr>';

        $queryOrderDetail = "SELECT od.*,gc.vgift_coupon_code
  						FROM " . $tableprefix . "order_details od
						INNER JOIN " . $tableprefix . "giftcertificates gc ON gc.ngift_product_id=od.product_id AND gc.ngift_order_id=:order_id
						WHERE od.order_id =:order_id";
        $orderDetailQ = $pdo->pdoQuery($queryOrderDetail, array("order_id" => $order_id))->results();
        $itemTotal = 0;
        $inc = 1;
        $totalshippingcost = 0;
        $productlist_fillstock = array();
        foreach ($orderDetailQ as $orderDetailObj) {
            $optionStr = "";

            if ($giftCheckVal) {
                $giftCertificateCode = "<font color='#ff0000'><br>" . MAIL_ORDER_TEXT_GIFT_COUPON_CODE . " " . $orderDetailObj->vgift_coupon_code . "</font>";
            }
            $productname = stripslashes($orderDetailObj['product_name']);


            $productRate = $orderDetailObj['product_price'];
            $productPrice = $productRate * $orderDetailObj['product_quantity'];
            $discountstr = "";
            if ($orderDetailObj['product_discount'] != 0) {
                $productPrice = $productPrice - ($productPrice * $orderDetailObj['product_discount']) / 100;
                $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
            }


            $converted_price = $productPrice;

            $productPrice = number_format($converted_price, 2, ".", "");


            $itemTotal+=$productPrice;

            $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $orderDetailObj['vgift_coupon_code'] . '</td>
		<td align="left" valign="top"> ' . $currency_attributes[0] . '&nbsp;' . number_format($productRate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($productPrice, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
		</tr>';


            $inc++;
        }


        $ItemTotalPrice = 0;
        //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
        $ItemTotalPrice = $itemTotal;

        $mailContent.='</table>
		</td>
		</tr>';

        $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';

        $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_AMOUNT . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; "> ' . $currency_attributes[0] . '&nbsp;' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
			</tr>';
        $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_TAXT_RATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . $orderObj['taxrate'] . '</td>
		</tr>';

        $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_ORDER_TOTAL . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice + $orderObj->taxrate, 2, ".", "") . '</td>
			</tr>';

        if ($orderObj['billing_address2']) {
            $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
        } else {
            $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
        }

        $mailContent .='</table>';

        $mailcontent_seller = readEmailTemplate('gift_couponmail_seller');

        //  echo $mailcontent_seller;
        $mailcontent_seller = str_replace('[coupon_details]', $mailContent, $mailcontent_seller);

        $mail_send_details_seller = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>
<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA" >
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td bgcolor="#EAEAEA" ><img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
			<tr>
			<td align="left"> ' . MAIL_ORDER_TEXT_DEAR . ' ' . $orderobjseller['first_name'] . '&nbsp;' . $orderobjseller['last_name'] . ', </td>
			<tr>
			<tr>
			<td align="left">' . MAIL_ORDER_TEXT_NEW_ORDER_PLACED_IN . ' ' . SITE_NAME . '. ' . MAIL_ORDER_TEXT_THE_DETAILS_ARE_AS_FOLLOWS . '</td>
			</tr>

			<tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left">' . $mailcontent_seller . '</td>
                </tr>

              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

//echo "<br>".$mail_send_details_seller;

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
        $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
        $headers .= "Organization: " . SITE_NAME . "\r\n";

        $ordersubject = MAIL_GIFT_CERTIFICATE_SELLER_SUBJECT . " " . SITE_NAME;

        //echo  "<br>".$mail_send_details_seller;
        //echo $ordersubject,$mail_send_details_seller;

        $mailsent = mail($orderobjseller['email'], $ordersubject, $mail_send_details_seller, $headers);

        // Send Stock reorder Mail
    } // end while loop of artists
}

function sendgiftCertificateMail_Admin($order_id, $user_id) {

    global $tableprefix, $pdo;
    include "config.php";

    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];

    $orderQ = $pdo->select($tableprefix . "orders", array("*", "DATE_FORMAT(order_date,'%m-%d-%Y') as order_dateF"), array("order_id" => $order_id))->results();
    $orderObj = $orderQ[0];
    $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
    $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>

		</tr>';
    $queryOrderDetail = "SELECT od.*,gc.vgift_coupon_code
  						FROM " . $tableprefix . "order_details od
						INNER JOIN " . $tableprefix . "giftcertificates gc ON gc.ngift_product_id=od.product_id AND gc.ngift_order_id=:order_id
						WHERE od.order_id =:order_id";
    $orderDetailQ = $pdo->pdoQuery($queryOrderDetail, array("order_id" => $order_id))->results();
    $itemTotal = 0;
    $inc = 1;
    foreach ($orderDetailQ as $orderDetailObj) {
        $optionStr = "";

        if ($giftCheckVal) {
            $giftCertificateCode = "<font color='#ff0000'><br>" . MAIL_ORDER_TEXT_GIFT_COUPON_CODE . " " . $orderDetailObj['vgift_coupon_code'] . "</font>";
        }
        $productname = stripslashes($orderDetailObj['product_name']);


        $productRate = $orderDetailObj['product_price'];
        $productPrice = $productRate * $orderDetailObj['product_quantity'];
        $discountstr = "";
        if ($orderDetailObj['product_discount'] != 0) {
            $productPrice = $productPrice - ($productPrice * $orderDetailObj['product_discount']) / 100;
            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
        }


        $converted_price = $productPrice;

        $productPrice = number_format($converted_price, 2, ".", "");


        $itemTotal+=$productPrice;

        $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $orderDetailObj['vgift_coupon_code'] . '</td>
		<td align="left" valign="top"> ' . $currency_attributes[0] . '&nbsp;' . number_format($productRate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($productPrice, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
		</tr>';

        if ($enable_seller_friendly == "Y") {

            $result_seller_name = $pdo->select($tableprefix . "artists", array("artist_name"), array("artist_id" => $orderDetailObj['artist_id']))->results();

            if (!empty($result_seller_name)) {

                $seller_name_row = $result_seller_name[0];
                $txtSellerName = $seller_name_row['artist_name'];
            }

            $friendly_url = SITE_URL . "/store/" . $txtSellerName;
        }  //end of if User Friendly URL checking condition
        else {
            $friendly_url = SITE_URL . "/showportfolio.php?artistid=" . $orderDetailObj['artist_id'];
        }


        $mailContent .='<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; " colspan="6">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
			' . MAIL_GIFT_CERTIFICATE_ADMIN_MESSAGE . '
		</td>
		</tr>';
        $mailContent .='<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			' . $friendly_url . '
		</td>
		</tr></table></td></tr>';

        $inc++;
    }
    $mailContent.='</table>
		</td>
		</tr>';

    $ItemTotalPrice = 0;
    //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
    $ItemTotalPrice = $itemTotal;

    $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';

    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_AMOUNT . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">$ ' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
			</tr>';

    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_TAXT_RATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . $orderObj->taxrate . '</td>
		</tr>';

    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_ORDER_TOTAL . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice + $orderObj->taxrate, 2, ".", "") . '</td>
			</tr>';

    if ($orderObj['billing_address2']) {
        $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
    } else {
        $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
    }


    $mailContent .='</table>';


    $mailcontent_admin = readEmailTemplate('gift_couponmail_admin');


    $mailcontent_admin = str_replace('[buyer_first_name]', $orderObj['billing_first_name'], $mailcontent_admin);

    $mailcontent_admin = str_replace('[buyer_last_name]', $orderObj['billing_last_name'], $mailcontent_admin);

    $mailcontent_admin = str_replace('[coupon_details]', $mailContent, $mailcontent_admin);


    $mail_send_details_admin = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_admin . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

//echo $mail_send_details_buyer;

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_GIFT_CERTIFICATE_SELLER_SUBJECT . " " . SITE_NAME;

    //$orderObj->billing_email='asha.s@armiasystems.com';
    //echo $mail_send_details_admin;

    $adminemail = getSettingsValue('site_email');


    $mailsent = mail($adminemail, $ordersubject, $mail_send_details_admin, $headers);
}

function GetAdminCurrency() {
    global $tableprefix, $pdo;
    $result = $pdo->select($tableprefix . 'settings', array("admin_currency"), '')->result();
    if (!empty($result)) {

        switch ($result['admin_currency']) {
            case "USD": {
                    $adminCurrencySymbol = '&#36;';
                    break;
                }
            case "EUR": {
                    $adminCurrencySymbol = '€';
                    break;
                }
            case "GBP": {
                    $adminCurrencySymbol = '£';
                    break;
                }
            case "INR": {
                    $adminCurrencySymbol = 'INR';
                    break;
                }
            default :
                $adminCurrencySymbol = '&#36;';
                break;
        }
        $admin_currency = array("currency_code" => $result['admin_currency'],
            "currency_symbol" => $adminCurrencySymbol);

        return $admin_currency;
    }
}

function GetAdminLanguage() {
    global $tableprefix, $pdo;

    $sql = "SELECT admin_language FROM " . $tableprefix . "settings ";
    $result = $pdo->pdoQuery($sql)->results();
    if (count($result) > 0) {

        $rsLanguageObj = (object)($result[0]);

        /* switch($rsLanguageObj->admin_language)
          {
          case "USD":
          {
          $adminCurrencySymbol	= '&#36;';
          break;
          }
          case "EUR":
          {
          $adminCurrencySymbol	= '€';
          break;
          }
          case "GBP":
          {
          $adminCurrencySymbol	= '£';
          break;
          }
          default :
          $adminCurrencySymbol	= '&#36;';
          break;

          }

          $admin_currency= array("currency_code"=>$rsCurrencyObj->admin_currency,
          "currency_symbol"=>$adminCurrencySymbol);
         */
        return $rsLanguageObj->admin_language;
    }
}

function ConvertedCurrencyRate($currenyCode) {

    global $tableprefix, $pdo;
    $rr_settings = $pdo->select($tableprefix . 'currency_master', array('nexchange_price'), array('vcurrency_code' => $currenyCode))->results();
    if (!empty($rr_settings[0])) {
        $userCurrencyRate = $rr_settings[0]['nexchange_price'];
    } else {
        $userCurrencyRate = 1;
    }
    return $userCurrencyRate;
}

function ConvertUSDollorToUserCurrency($currencyCode) {
    global $tableprefix, $pdo;

    $adminCurrency = GetAdminCurrency();

    if ($currencyCode != 'USD') {

        $sql = "SELECT usdollar_rate FROM `" . $tableprefix . "currency_master`  where vcurrency_code='" . $currencyCode . "' ";
        $result = $pdo->select($tableprefix . "categories", array("category_id"), array("alias" => $categoryAlias))->results();

        if (!empty($result)) {
            $currencyObj = $result[0];

            $userCurrencyRate = ($currencyObj['usdollar_rate']);
        }

        $convertedRate = $userCurrencyRate;
    } else {
        $convertedRate = 1;
    }

    return $convertedRate;
}


function sendDigitalCertificateMail_Buyer($order_id, $user_id, $usertype = '') {
    global $tableprefix, $_SESSION,$pdo;
    $mailContent = "";

    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];


    $queryOrder = "SELECT o.* ,DATE_FORMAT(o.order_date,'%m-%d-%Y') as order_dateF from " . $tableprefix . "orders o  where order_id=:order_id ";
    $orderQ =$pdo->pdoQuery($queryOrder,array("order_id"=>$order_id))->results();
    $orderObj = $orderQ[0];
    $mailContent = '<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
    $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		</table>
		</td>
		</tr>';

    $product_download_details = "";

    $product_download_details = "<font color='#FF0000'>Note: If you do not have pop-ups enabled on your browser, the product download may not work properly.So please enable pop-ups before downloading !!</font>";


    $mailContent .='<tr>
				<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
				<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
				<tr>
				<td align="left" valign="top">
					' . $product_download_details . '
				</td>
				</tr>
				<tr><td><b> <br>' . MAIL_DIGITAL_PRODUCT_MESSAGE . '</b></td></tr>

				</table></td></tr>';

    $mailContent .='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_DIGITAL_PRODUCT_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
		</tr>';

    $queryOrderDetail = "SELECT od.*,DATE_FORMAT(gc.ndownload_expiry,'%m-%d-%Y') as ndownload_expiry,gc.vdigital_product_code,gc.ndownload_try,gc.ndownload_expiry_days
  						FROM " . $tableprefix . "order_details od
						INNER JOIN " . $tableprefix . "digital_product gc ON od.product_id = gc.ndigital_productid AND od.order_id=gc.ndigital_orderid
						WHERE od.order_id =:order_id GROUP BY gc.ndigital_productid ";


    $orderDetailQ =$pdo->pdoQuery($queryOrderDetail,array("order_id"=>$order_id))->results();
    $itemTotal = 0;
    $inc = 1;
    foreach ($orderDetailQ as $orderDetailObj) {
        $optionStr = "";

        $productname = stripslashes($orderDetailObj['product_name']);
        $productRate = $orderDetailObj['product_price'];
        $productPrice = $productRate * $orderDetailObj['product_quantity'];
        $discountstr = "";
        if ($orderDetailObj['product_discount'] != 0) {
            $productPrice = $productPrice - ($productPrice * $orderDetailObj['product_discount']) / 100;
            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
        }


        $converted_price = $productPrice;

        $productPrice = number_format($converted_price, 2, ".", "");


        $itemTotal+=$productPrice;

        $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $orderDetailObj['product_code'] . '</td>
		<td align="left" valign="top"> ' . $currency_attributes[0] . '&nbsp;' . number_format($productRate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($productPrice, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
		</tr>';

        $product_download_try = $orderDetailObj['ndownload_try'];

        $download_expiry_date = $orderDetailObj['ndownload_expiry'];


        /* if($orderDetailObj->ndownload_expiry!='')
          {
          $download_expiry_date  	= dateFormat($orderDetailObj->ndownload_expiry, "Y-m-d", "m-d-Y");
          }

          $download_expiry_date  	= $orderDetailObj->ndownload_expiry; */
        $expiry_days = $orderDetailObj['ndownload_expiry_days'];

        /* if($orderDetailObj->ndownload_expiry_days!='')
          {
          $expiry_days = 	dateFormat($orderDetailObj->ndownload_expiry_days, "Y-m-d", "m-d-Y");
          } */

        $product_download_trydetails = "";


        $product_download_trydetails .= "<br><br>" . MAIL_PRODUCT_DOWNLOAD_PRODUCT_DOWNLOAD_TRY . " - $product_download_try " . MAIL_PRODUCT_DOWNLOAD_TIMES . "\r\n";
        $product_download_trydetails .= "<br><br>" . MAIL_PRODUCT_DOWNLOAD_EXPIRY_DATE . " - $download_expiry_date\r\n";

        $valid_date_upto = date("Y-m-d H:s:m", mktime(date("H"), date("i"), date("s"), date("m"), date("d") + $expiry_days, date("Y")));

        $mailContent .='<tr>
				<td  align="left" valign="top" style="padding:5px 15px 15px 15px; " colspan="6" width="100%">
				<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
				<tr>
				<td align="left" valign="top">
					' . $product_download_trydetails . '
				</td>
				</tr>

				</table></td></tr>';


         $rs_digital = $pdo->select($tableprefix."digital_product",array("vdigital_product_code","ndownload_try","ndownload_expiry","ndownload_expiry_days"),array("ndigital_productid"=>$orderDetailObj['product_id'],"ndigital_orderid"=>$order_id))->results();

        $product_download_details = "";

        $couponCodeDiscount = $orderObj['couponCodeDiscount'];

        if (!empty($rs_digital)) {
            $product_download_details_link = "";
            $download_link = "";

            $cnt = 1;

            foreach ($rs_digital as $orderDetailObjdigital) {

                $download_link = "<a href='" . SITE_URL . "/digital_product_download.php?download_code=".$orderDetailObjdigital['vdigital_product_code']."'><br><br>Download Link" . $cnt . "</a> ";
                //$download_link = " <br><br>Download Link  ".$cnt." - ".SITE_URL."/digital_product_download.php?download_code=$orderDetailObjdigital->vdigital_product_code\r\n";
                $product_download_details_link = $download_link;

                $mailContent .='<tr>
				<td  align="left" valign="top" style="padding:5px 15px 15px 15px; " colspan="6">
				<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
				<tr>
				<td align="left" valign="top">
					' . $product_download_details_link . '
				</td>
				</tr></table></td></tr>';

                $cnt++;
            }
        }




        $inc++;
    }


    $mailContent .='</table></td></tr>';

    $ItemTotalPrice = 0;
    //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
    $ItemTotalPrice = $itemTotal;

    $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; " width="100%">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';
    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_ITEM_PRICE_TOTAL . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
		</tr>';



    if ($couponCodeDiscount > 0) {
        //echo "sdhjsdhasd";
        //$priceafterdiscount=$ItemTotalPrice-($ItemTotalPrice*$orderObj->couponCodeDiscount)/100;

        $couponCodeDiscountAmount = ($ItemTotalPrice * $orderObj['couponCodeDiscount']) / 100;

        $mailContent.='<tr>
		<td style="font-size:14px; color:#FF0000; font-weight:bold;">' . MAIL_ORDER_TEXT_COUPON_CODE . ' " ' . $orderObj['couponCode'] . ' " ' . MAIL_ORDER_TEXT_DISCOUNT_AMOUNT . '</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; "> ' . $currency_attributes[0] . '&nbsp; ' . number_format($couponCodeDiscountAmount, 2, ".", "") . '&nbsp;&nbsp; ( ' . ($orderObj['couponCodeDiscount']) . ' %  ' . MAIL_ORDER_TEXT_OF_ITEM_PRICE_TOTAL . ')</td>
		</tr>';
    }
    if ($orderObj['vgiftcertificate_code'] != '' && $orderObj['nused_gift_amount'] > 0) {

        $giftDiscountAmount = $orderObj['nused_gift_amount'];
        $mailContent.='<tr>
		<td> ' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . ' : </td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $orderObj['vgiftcertificate_code'] . '  </td>
		</tr>
		<tr>
		<td> Gift Certificate Discount Amount :</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($orderObj['nused_gift_amount'], 2, ".", "") . ' </td>
		</tr>';
    }
    if ($orderObj['nused_gift_amount'] > 0 || $couponCodeDiscount > 0) {

        $TotalDiscount = $giftDiscountAmount + $couponCodeDiscountAmount;

        $priceafterdiscount = $ItemTotalPrice - $TotalDiscount;

        $ItemTotalPrice = $priceafterdiscount;

        $mailContent.='<tr>
		<td>Item Total Cost After  Discount:</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($priceafterdiscount, 2, ".", "") . '</td>
		</tr>';
    }

    /* $mailContent .='<tr>
      <td>Tax Rate:</td>
      <td  style="font-size:13px; color:#991818; font-weight:bold; ">'.$currency_attributes[0].'&nbsp; '.$orderObj->taxrate.'</td>
      </tr>'; */

    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_ORDER_TOTAL . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp;' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
			</tr>';

    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_AMOUNT_PAID . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
			</tr>';
//number_format($orderObj->namount_paid,2,".","")
    $mailContent .='<tr>
			<td colspan="2">&nbsp;</td>
			</tr>';
    $mailContent .='<tr>
			<td colspan="2">&nbsp;</td>
			</tr></table></td></tr>';
    if ($orderObj['billing_address2']) {
        $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
    } else {
        $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
    }


    if ($usertype == "guest") {
        $rs_Order = $pdo->select($tableprefix."users",array("user_name","email"),array("user_id"=>$orderObj['user_id']))->results();
        if (!empty($rs_Order)) {
            $rs_Order_obj = $rs_Order[0];

            $guest_user_name = $rs_Order_obj['user_name'];

            $guest_user_password = $_SESSION["sess_guest_password"];

            $mailContent .='<tr><td>&nbsp;</td></tr>';

            $mailContent .='<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr><td> <I>' . MAIL_ORDER_TEXT_NOTE . ' </I> ' . str_replace('{store_login}', $orderObj['storename'] . ' ( ' . SITE_URL . ')', MAIL_ORDER_TEXT_NOTE_MSG) . '</td></tr>';

            $mailContent .='<tr><td>' . MAIL_ORDER_TEXT_USER_NAME . ' &nbsp;<b>' . $guest_user_name . '</b></td></tr>';

            $mailContent .='<tr><td>' . MAIL_ORDER_TEXT_PASSWORD . ' &nbsp;<b>' . $guest_user_password . '</b></td></tr>';

            $mailContent .='<tr><td>&nbsp;</td></tr></table> </TD></TR>';
        }
    }


    $mailContent .='</table>';


    $mailcontent_buyer = readEmailTemplate('digital_product');

    $mailcontent_buyer = str_replace('[buyer_first_name]', $orderObj['billing_first_name'], $mailcontent_buyer);

    $mailcontent_buyer = str_replace('[buyer_last_name]', $orderObj['billing_last_name'], $mailcontent_buyer);

    if (stristr($mailcontent_buyer, "[first_name")) {
        $mailcontent_buyer = str_replace('[first_name]', $orderObj['billing_first_name'], $mailcontent_buyer);
    }
    if (stristr($mailcontent_buyer, "[last_name")) {
        $mailcontent_buyer = str_replace('[last_name]', $orderObj['billing_last_name'], $mailcontent_buyer);
    }


    $mailcontent_buyer = str_replace('[order_details]', $mailContent, $mailcontent_buyer);

    $mail_send_details_buyer = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_buyer . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>
</body>
</html>';
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_PRODUCT_DOWNLOAD_SUBJECT . " " . SITE_NAME;

    $mailsent = mail($orderObj['billing_email'], $ordersubject, $mail_send_details_buyer, $headers);
}

function sendDigitalCertificateMail_Seller($order_id, $user_id) {

    global $tableprefix,$pdo;


    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];



    $queryOrder = "SELECT o.* ,DATE_FORMAT(o.order_date,'%m-%d-%Y') as order_dateF from " . $tableprefix . "orders o  where order_id=:order_id ";
    $orderQ = $pdo->pdoQuery($queryOrder,array("order_id"=>$order_id))->results();
    $orderObj = $orderQ[0];
    $couponCodeDiscount = $orderObj['couponCodeDiscount'];
    $queryOrderDetail_seller = "SELECT DISTINCT od.artist_id,s.*
  										FROM " . $tableprefix . "order_details od
										INNER JOIN " . $tableprefix . "artists s ON s.artist_id=od.artist_id
										WHERE od.order_id =:order_id";
    $orderDetailQ_seller = $pdo->pdoQuery($queryOrderDetail_seller,array("order_id"=>$order_id))->results();

    foreach ($orderDetailQ_seller as $orderobjseller) {

        $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
        $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		<tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_DIGITAL_PRODUCT_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
		</tr>';


        $queryOrderDetail = "SELECT od.*,gc.vdigital_product_code,gc.ndownload_try,gc.ndownload_expiry,gc.ndownload_expiry_days
  						FROM " . $tableprefix . "order_details od
						INNER JOIN " . $tableprefix . "digital_product gc ON gc.ndigital_productid=od.product_id  AND od.order_id=gc.ndigital_orderid
						WHERE od.order_id =:order_id AND od.artist_id=:artist_id GROUP BY gc.ndigital_productid ";

        $orderDetailQ = $pdo->pdoQuery($queryOrderDetail,array("order_id"=>$order_id,"artist_id"=>$orderobjseller['artist_id']))->results();
        $itemTotal = 0;
        $taxTotal = 0;
        $inc = 1;
        foreach ($orderDetailQ as $orderDetailObj) {
            $optionStr = "";


            $productname = stripslashes($orderDetailObj['product_name']);
            $productRate = $orderDetailObj['product_price'];
            $productPrice = $productRate * $orderDetailObj['product_quantity'];
            $discountstr = "";
            if ($orderDetailObj['product_discount'] != 0) {
                $productPrice = $productPrice - ($productPrice * $orderDetailObj['product_discount']) / 100;
                $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
            }



            $converted_price = $productPrice;

            $productPrice = number_format($converted_price, 2, ".", "");

            $taxTotal+=$orderDetailObj['product_tax'];

            $itemTotal+=$productPrice;

            $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $orderDetailObj['product_code'] . '</td>
		<td align="left" valign="top"> ' . $currency_attributes[0] . '&nbsp;' . number_format($productRate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($productPrice, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
		</tr>';

            $inc++;
        }

        $mailContent.='</table>
		</td>
		</tr>';



        $ItemTotalPrice = 0;
        //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
        $ItemTotalPrice = $itemTotal;



        $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';
        $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_ITEM_PRICE_TOTAL . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
		</tr>';
        /* $mailContent .='<tr>
          <td>Tax Rate:</td>
          <td  style="font-size:13px; color:#991818; font-weight:bold; ">'.$currency_attributes[0].'&nbsp; '.$taxTotal.'</td>
          </tr>'; */


        if ($couponCodeDiscount > 0) {

            $couponCodeDiscountAmount = ($ItemTotalPrice * $orderObj['couponCodeDiscount']) / 100;

            $mailContent.='<tr>
		<td style="font-size:14px; color:#FF0000; font-weight:bold;">' . MAIL_ORDER_TEXT_COUPON_CODE . ' " ' . $orderObj['couponCode'] . ' " ' . MAIL_ORDER_TEXT_DISCOUNT_AMOUNT . '</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; "> ' . $currency_attributes[0] . '&nbsp; ' . number_format($couponCodeDiscountAmount, 2, ".", "") . '&nbsp;&nbsp; ( ' . ($orderObj['couponCodeDiscount']) . ' %  ' . MAIL_ORDER_TEXT_OF_ITEM_PRICE_TOTAL . ')</td>
		</tr>';
        }

        if ($orderObj['vgiftcertificate_code'] != '' && $orderObj['nused_gift_amount'] > 0) {

            $giftDiscountAmount = $orderObj['nused_gift_amount'];
            $mailContent.='<tr>
		<td> ' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . ' : </td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $orderObj['vgiftcertificate_code'] . '  </td>
		</tr>
		<tr>
		<td> Gift Certificate Discount Amount :</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($orderObj['nused_gift_amount'], 2, ".", "") . ' </td>
		</tr>';
        }

        if ($orderObj['nused_gift_amount'] > 0 || $couponCodeDiscount > 0) {

            $TotalDiscount = $giftDiscountAmount + $couponCodeDiscountAmount;

            $priceafterdiscount = $ItemTotalPrice - $TotalDiscount;

            $ItemTotalPrice = $priceafterdiscount;

            $mailContent.='<tr>
		<td>Item Total Cost After  Discount:</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($priceafterdiscount, 2, ".", "") . '</td>
		</tr>';
        }
        $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_ORDER_TOTAL . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp;' . number_format($ItemTotalPrice + $taxTotal, 2, ".", "") . '</td>
			</tr>';

        /* $mailContent .='<tr>
          <td>'.MAIL_ORDER_TEXT_AMOUNT_PAID.'</td>
          <td  style="font-size:16px; color:#FF0000; font-weight:bold; ">'.$currency_attributes[0].'&nbsp; '.number_format($orderObj->namount_paid,2,".","").'</td>
          </tr>'; */
        $mailContent .='<tr>
			<td colspan="2">&nbsp;</td>
			</tr></table></td></tr>';
        if ($orderObj['billing_address2']) {
            $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
        } else {
            $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
        }

        $mailContent .='</table>';

        $mailcontent_seller = readEmailTemplate('digital_product_seller');

        $mailcontent_seller = str_replace('[first_name]', $orderObj['billing_first_name'], $mailcontent_seller);

        $mailcontent_seller = str_replace('[last_name]', $orderObj['billing_last_name'], $mailcontent_seller);

        $mailcontent_seller = str_replace('[order_details]', $mailContent, $mailcontent_seller);


        $mail_send_details_seller = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>
<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA" >
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td bgcolor="#EAEAEA" ><img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
			<tr>
			<td align="left"> ' . MAIL_SALUTATION . ' ' . $orderobjseller['first_name'] . '&nbsp;' . $orderobjseller['last_name'] . ', </td>
			<tr>

			<tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left">' . $mailcontent_seller . '</td>
                </tr>

              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

//echo "<br>".$mail_send_details_seller;

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
        $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
        $headers .= "Organization: " . SITE_NAME . "\r\n";

        $ordersubject = MAIL_DIGITAL_PRODUCT_SUBJECT . " " . SITE_NAME;

        //echo  "<br>".$mail_send_details_seller;
        //echo $ordersubject,$mail_send_details_seller;

        $mailsent = mail($orderobjseller['email'], $ordersubject, $mail_send_details_seller, $headers);

        // Send Stock reorder Mail
    } // end while loop of artists
}

function sendDigitalCertificateMail_Admin($order_id, $user_id) {
    global $tableprefix,$pdo;


    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];


    $queryOrder = "SELECT o.* ,DATE_FORMAT(o.order_date,'%m-%d-%Y') as order_dateF from " . $tableprefix . "orders o  where order_id=:order_id ";
    $orderQ = $pdo->pdoQuery($queryOrder,array("order_id"=>$order_id))->results();
    $orderObj = $orderQ[0];

    $couponCodeDiscount = $orderObj['couponCodeDiscount'];

    $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_ORDER_DETAILS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_ORDER_TEXT_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . SITE_NAME . '(' . SITE_URL . ')</td>
		</tr>';
    $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_id'] . '</td>
		</tr>
		<tr>
		<tr>
		<td >' . MAIL_ORDER_TEXT_ORDER_DATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj['order_dateF'] . '</td>
		</tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_PRODUCTS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_DIGITAL_PRODUCT_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>

		</tr>';
    $queryOrderDetail = "SELECT od.*,gc.vdigital_product_code,gc.ndownload_try,gc.ndownload_expiry,gc.ndownload_expiry_days
  						FROM " . $tableprefix . "order_details od
						INNER JOIN " . $tableprefix . "digital_product gc ON gc.ndigital_productid=od.product_id AND gc.ndigital_orderid=:order_id
						WHERE od.order_id =:order_id GROUP BY gc.ndigital_productid ";


    $orderDetailQ = $pdo->pdoQuery($queryOrderDetail,array("order_id"=>$order_id))->results();
    $itemTotal = 0;
    $inc = 1;
    foreach ($orderDetailQ as $orderDetailObj) {
        $optionStr = "";

        $productname = stripslashes($orderDetailObj['product_name']);
        $productRate = $orderDetailObj['product_price'];
        $productPrice = $productRate * $orderDetailObj['product_quantity'];
        $discountstr = "";
        if ($orderDetailObj['product_discount'] != 0) {
            $productPrice = $productPrice - ($productPrice * $orderDetailObj['product_discount']) / 100;
            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
        }


        $converted_price = $productPrice;

        $productPrice = number_format($converted_price, 2, ".", "");

        $itemTotal+=$productPrice;

        $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . '</td>
		<td align="left" valign="top">' . $productname . '</td>
		<td align="left" valign="top">' . $orderDetailObj['product_code'] . '</td>
		<td align="left" valign="top"> ' . $currency_attributes[0] . '&nbsp;' . number_format($productRate, 2, ".", "") . '</td>
		<td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
		<td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($productPrice, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
		</tr>';


        $inc++;
    }

    $mailContent .='</table></td></tr>';

    $ItemTotalPrice = 0;
    //Modified ON 03-12-2010 // Remove Set Price Total from Total Price
    $ItemTotalPrice = $itemTotal;

    $mailContent.='<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_CHARGES . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; " width="100%">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';
    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_ITEM_PRICE_TOTAL . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
		</tr>';
    if ($couponCodeDiscount > 0) {
        //echo "sdhjsdhasd";
        //$priceafterdiscount=$ItemTotalPrice-($ItemTotalPrice*$orderObj->couponCodeDiscount)/100;
        //$ItemTotalPrice=$priceafterdiscount;
        $couponCodeDiscountAmount = ($ItemTotalPrice * $orderObj['couponCodeDiscount']) / 100;
        $mailContent.='<tr>
		<td style="font-size:14px; color:#FF0000; font-weight:bold;">' . MAIL_ORDER_TEXT_COUPON_CODE . ' " ' . $orderObj['couponCode'] . ' " ' . MAIL_ORDER_TEXT_DISCOUNT_AMOUNT . '</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; "> ' . $currency_attributes[0] . '&nbsp; ' . number_format($couponCodeDiscountAmount, 2, ".", "") . '&nbsp;&nbsp; ( ' . ($orderObj['couponCodeDiscount']) . ' %  ' . MAIL_ORDER_TEXT_OF_ITEM_PRICE_TOTAL . ')</td>
		</tr>';
    }
    if ($orderObj['vgiftcertificate_code'] != '' && $orderObj['nused_gift_amount'] > 0) {

        $giftDiscountAmount = $orderObj['nused_gift_amount'];
        $mailContent.='<tr>
		<td> ' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_CODE . ' : </td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $orderObj['vgiftcertificate_code'] . '  </td>
		</tr>
		<tr>
		<td> ' . MAIL_ORDER_TEXT_GIFT_CERTIFICATE_AMOUNT . '</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($orderObj['nused_gift_amount'], 2, ".", "") . ' </td>
		</tr>';
    }

    if ($orderObj['nused_gift_amount'] > 0 || $couponCodeDiscount > 0) {

        $TotalDiscount = $giftDiscountAmount + $couponCodeDiscountAmount;

        $priceafterdiscount = $ItemTotalPrice - $TotalDiscount;

        $ItemTotalPrice = $priceafterdiscount;

        $mailContent.='<tr>
		<td>Item Total Cost After  Discount:</td>
		<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($priceafterdiscount, 2, ".", "") . '</td>
		</tr>';
    }

    $mailContent .='<tr>
		<td>' . MAIL_ORDER_TEXT_TAXT_RATE . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . $orderObj['taxrate'] . '</td>
		</tr>';

    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_ORDER_TOTAL . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp;' . number_format($ItemTotalPrice, 2, ".", "") . '</td>
			</tr>';

    $mailContent .='<tr>
			<td>' . MAIL_ORDER_TEXT_AMOUNT_PAID . '</td>
			<td  style="font-size:16px; color:#FF0000; font-weight:bold; ">' . $currency_attributes[0] . '&nbsp; ' . number_format($orderObj['namount_paid'], 2, ".", "") . '</td>
			</tr>';

    $mailContent .='<tr>
			<td colspan="2">&nbsp;</td>
			</tr></table></td></tr>';
    if ($orderObj['billing_address2']) {
        $mailContent .='<tr></table>
			</td>
			</tr>
			<tr>
			<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
			' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
			</td>
			</tr>
			<tr>
			<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
			<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
			<tr>
			<td align="left" valign="top">
			' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
			' . $orderObj['billing_address1'] . ',<br>
			' . $orderObj['billing_address2'] . ',<br>
			' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
			' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
			' . $orderObj['billing_email'] . '
			</td>
			</tr>
			</table>
			</td>
			</tr>';
    } else {
        $mailContent .='<tr></table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_ORDER_TEXT_BILLING_ADDRESS . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td align="left" valign="top">
		' . $orderObj['billing_first_name'] . ' ' . $orderObj['billing_last_name'] . '<br>
		' . $orderObj['billing_address1'] . ',<br>
		' . $orderObj['billing_city'] . ', ' . $orderObj['billing_state'] . ', ' . $orderObj['billing_country'] . ' ' . $orderObj['billing_zip'] . '<br>
		' . MAIL_ORDER_TEXT_PHONE . ' ' . $orderObj['billing_phone'] . '<br>
		' . $orderObj['billing_email'] . '
		</td>
		</tr>
		</table>
		</td>
		</tr>';
    }


    $mailContent .='</table>';


    $mailcontent_admin = readEmailTemplate('digital_product_admin');

    $mailcontent_admin = str_replace('[first_name]', $orderObj['billing_first_name'], $mailcontent_admin);

    $mailcontent_admin = str_replace('[last_name]', $orderObj['billing_last_name'], $mailcontent_admin);

    $mailcontent_admin = str_replace('[order_details]', $mailContent, $mailcontent_admin);


    $mail_send_details_admin = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_admin . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

//echo $mail_send_details_buyer;

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_PRODUCT_DOWNLOAD_SUBJECT . " " . SITE_NAME;

    $adminemail = getSettingsValue('site_email');

    $mailsent = mail($adminemail, $ordersubject, $mail_send_details_admin, $headers);
}

function getCurrPagename($url) {
    global $tableprefix, $pdo;

    $curr_page_url_sql = "SELECT page_name
							 FROM " . $tableprefix . "admin_menu
							WHERE link= :url";
    $curr_page_url_result = $pdo->pdoQuery($curr_page_url_sql,array("url"=>$url))->results();
    foreach ($curr_page_url_result as $curr_page_url_row) {
        $curr_page_name = $curr_page_url_row['page_name'];
    }
    return $curr_page_name;
}

function getFilenameWithoutExt($file) {
    $file_name = rtrim($file, strrchr($file, '.'));
    return $file_name;
}

function get_file_extension($file_name) {
    return substr(strrchr($file_name, '.'), 1);
}

function GetSellerPlanDetails($sellerid) {
    global $tableprefix, $pdo;
    $seller_plan_details = array();

     $sql_date_check = "SELECT ar . * , am . *,s.*
							FROM " . $tableprefix . "artists_membershipDetails am
							INNER JOIN " . $tableprefix . "artists ar ON ar.artist_id = am.artist_id
							INNER JOIN " . $tableprefix . "sellerPlans s ON s.plan_Id = ar.sellerPlanID AND  s.plan_Id = am.plan_Id
							WHERE  ar.artist_id= '".$sellerid."'  ORDER BY am.artist_memEndDate  DESC LIMIT 1";
    $rs_date_check =$pdo->pdoQuery($sql_date_check)->result();
    if (count($rs_date_check) > 0) {
        $seller_plan_details = array("Plan_name" => $rs_date_check['plan_Title'],
            "Plan_description" => $rs_date_check['plan_Description'],
            "Plan_amount" => $rs_date_check['plan_SubscriptionCharge'],
            "Plan_startDate" => $rs_date_check['artist_memStartDate'],
            "Plan_expiry" => $rs_date_check['artist_memEndDate']);
    }

    return $seller_plan_details;
}

function checkSkuQuantity($order_id, $productid) {
    global $tableprefix,$pdo;
   $refundmQ = $pdo->select($tableprefix."refunds",'',array("order_id"=>$order_id,"product_id"=>$productid))->results();
    $refundRows = count($refundmQ);

    if (!empty($refundmQ)) {
        foreach ($refundmQ as $refundObj) {
            $txtQty+=$refundObj['quantity'];
        }
        // Refund sku found
    } else {
        $txtQty = 0;
    }


    return $txtQty;
}

// end function

function checkRefundStatus($order_id, $productid) {
    global $tableprefix,$pdo;
    $refundmQ = $pdo->select($tableprefix."refunds",'',array("order_id"=>$order_id,"product_id"=>$productid))->results();

    if (!empty($refundmQ)) {
        $chekRefundStatus = 1;
        // Refund sku found
    } else {
        $chekRefundStatus = 0;
    }


    return $chekRefundStatus;
}

// end function
function checkAllProductsRefunded($orderid) {


    global $tableprefix,$pdo;

    $allproductsRefunded = false;

    $sql = "SELECT  sum(od.product_quantity) as productqty
			      FROM " . $tableprefix . "order_details od
			     WHERE od.order_id=:order_id AND od.item_status=4  ";

    $rs = $pdo->pdoQuery($sql,array("order_id"=>$orderid))->results();

    $totalProductCount = 0;


    if (!empty($rs)) {

        $rsObj = $rs[0];

        $totalProductCount = $rsObj['productqty'];
    }


    $sql1 = "SELECT sum(r.quantity) as refundqty
			      			FROM " . $tableprefix . "refunds r
			     	WHERE r.order_id=:order_id";

    $rs1 = $pdo->pdoQuery($sql1,array("order_id"=>$orderid))->results();
    //$pdo->select($tableprefix."refunds",array("sum(r.quantity) as refundqty"),array("order_id"=>$orderid))->results();

    $totalRefundCount = 0;


    if (!empty($rs1)) {

        $rsObj1 = $rs1[0];

        $totalRefundCount = $rsObj1['refundqty'];
    }



    if ($totalProductCount == $totalRefundCount) {
        $allproductsRefunded = true;
    }

    return $allproductsRefunded;
}

function checkProductRatingStatus($userid, $productid) {

    global $tableprefix, $pdo;
    $ratingCount = 0;
    $productCount = 0;
    $RatingStatus = 1;
    if ($productid != '') {
        $prodStatus = "select od.product_name from " . $tableprefix . "orders o left join " . $tableprefix . "order_details od
							on o.order_id=od.order_id where user_id=:user_id and product_id=:product_id";

        $prodStatus = $pdo->pdoQuery($prodStatus, array("product_id" => $productid, "user_id" => $userid))->results();
        if (!empty($prodStatus)) {
            $productCount = 1;
        }
        $result_rating = $pdo->select($tableprefix . "record_ratings", array("ntotal_ratings"), array("nrseller_id" => $productid, "vType" => 'p', "nruser_id" => $userid))->results();

        if (!empty($result_rating)) {

            $ratingCount = 1;
        }
        if ($productCount == 1 && $ratingCount == 0) {
            $RatingStatus = 0;
        }
    }
    return $RatingStatus;
}

function checkSellerRatingStatus($sellerid, $userid, $productid) {

    global $tableprefix, $pdo;

    $productCount = 0;

    $sellerRatingStatus = 0;

    // Check Product Alreday purchsed by the user

    if ($productid != '') {
        $query = "select od.product_name from " . $tableprefix . "orders o left join " . $tableprefix . "order_details od
							on o.order_id=od.order_id where user_id=:userid and
							product_id=:product_id";
        $prodStatus = $pdo->pdoQuery($query, array("userid" => $userid, "product_id" => $productid))->results();
        if (!empty($prodStatus)) {
            $productCount = 1;
        }
    }



    if ($sellerid != '' && $userid != '') {
        $select_seller_rating = $pdo->select($tableprefix . "artist_feedbacks", array("rating"), array("artist_id" => $sellerid, "user_id" => $userid))->results();
        if (!empty($select_seller_rating)) {
            $sellerRatingStatus = 1;
        } else {
            if ($productCount == 1) {
                $sellerRatingStatus = 0;
            } else {
                $sellerRatingStatus = 1;
            }
        }
    }
    return $sellerRatingStatus;
}

function GetSellerRatingStar($feedback_id) {
    global $tableprefix, $_SESSION,$pdo;
    //echo $prd_id;
    //exit;
    //set some variables
    //$ip = $_SERVER['REMOTE_ADDR'];

    $sellerRating = 0;

    $select_rating_count = $pdo->pdoQuery("SELECT rating FROM " . $tableprefix . "artist_feedbacks WHERE artist_feedback_id=:feedback_id ",array("feedback_id"=>$feedback_id))->results();

    if (count($select_rating_count) > 0) {

        $rating_count = ($select_rating_count[0]);

        $sellerRating = $rating_count['rating'];
    }

    return $sellerRating;
}

function digitalCart($user_id) {


    global $tableprefix, $_SESSION,$pdo;

    $digital_cart_count = 0;

    $select_gift_check1 = "SELECT * FROM " . $tableprefix . "cart crt
										INNER JOIN " . $tableprefix . "products p ON p.product_id = crt.product_id
										WHERE crt.user_id=:user_id AND p.vdigital_product = 'Y' ";
    $result_gift_check1 = $pdo->pdoQuery($select_gift_check1,array("user_id"=>$user_id))->results();
    if (!empty($result_gift_check1)) {
        $digital_cart_count = 1;
    }
    return $digital_cart_count;
}

function getCartTotalcouponCodeDicountamount($userid, $couponCode) {
    global $tableprefix, $pdo;

    $sql = "SELECT c.*,p.product_id,p.product_category,(p.product_price+po.additional_price) AS product_price,p.product_artist_id,po.discount
        FROM " . $tableprefix . "cart c
        INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id            
        INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id        
        WHERE c.user_id = :user_id ";


    $result = $pdo->pdoQuery($sql, array("user_id" => $userid))->results();
    $total = 0;
    $itemcount = 0;
    $currency_attributes = displayCurrencyType();

    $couponTotalAmt = 0;
    if (!empty($result)) {
        $totprice = 0;
        $discountprice = 0;
        $totalProductPrice = 0;
        $sellerType = false;
        foreach ($result as $row) {
            $converted_price = $row['product_price'];
            $rate = number_format($converted_price, 2, ".", "");

            $qty = $row["quantity"];
            $totprice = $qty * $rate;
            $discountstr = "";
            $discountprice = 0;
            if ($couponCode['coupon_type'] == 'product') {

                if (in_array($row["product_id"], array_values($couponCode['product_id']))) {
                    $totprice = number_format($totprice, 2, ".", "");
                    $discountprice = $rate - ($rate * $row["discount"]) / 100;
                    $discountprice = number_format($discountprice, 2, ".", "");
                    $discountrate = ($discountprice * $qty);
                    $totalProductPrice = $totalProductPrice + $discountrate;
                    $CoupontotalDisc = ($discountrate * $couponCode['ccDiscount']) / 100;
                    //echo $row["product_category"].'Rate'.$discountrate.'Discount'.$CoupontotalDisc.'<br />';
                    $CoupontotalAmt = $CoupontotalAmt + $CoupontotalDisc;
                }
            } elseif ($couponCode['coupon_type'] == 'seller') {
                $sellerType = true;
                if ($row["product_artist_id"] == $couponCode['appliedSeller']) {
                    $totprice = number_format($totprice, 2, ".", "");
                    $discountprice = $rate - ($rate * $row["discount"]) / 100;
                    $discountprice = number_format($discountprice, 2, ".", "");
                    $discountrate = ($discountprice * $qty);
                    $totalProductPrice = $totalProductPrice + $discountrate;
                }
            } elseif ($couponCode['coupon_type'] == 'category') {

                if (in_array($row["product_category"], array_values($couponCode['appliedCategory']))) {
                    $totprice = number_format($totprice, 2, ".", "");
                    $discountprice = $rate - ($rate * $row["discount"]) / 100;

                    $discountprice = number_format($discountprice, 2, ".", "");
                    $discountrate = ($discountprice * $qty);
                    $totalProductPrice = $totalProductPrice + $discountrate;


                    $CoupontotalDisc = ($discountrate * $couponCode['ccDiscount']) / 100;
                    // echo $row["product_category"].'Rate'.$discountrate.'Discount'.$CoupontotalDisc.'<br />';
                    $CoupontotalAmt = $CoupontotalAmt + $CoupontotalDisc;
                }
            }
        }
    }


    $product_price = number_format($totalProductPrice, 2, ".", ""); // rate X qty

    if ($sellerType == true) {
        if ($couponCode['ccDiscount'] > 0) {
            $Coupontotal = ($product_price * $couponCode['ccDiscount']) / 100;
            $_SESSION['couponCode_det']['discount_amount'] = $Coupontotal;
        } else {
            $Coupontotal = 0;
        }
    } else {
        if ($CoupontotalAmt > 0) {
            $Coupontotal = $CoupontotalAmt;
            $_SESSION['couponCode_det']['discount_amount'] = $CoupontotalAmt;
        } else {
            $Coupontotal = 0;
        }
    }

    return $Coupontotal;
}

/* ------------------------New Functions for Seller Profile, Metatags, Product Details Breadcrumb Page------------------ */

function getSellerProfileLink($baseurl, $sellerid, $catid) {
    global $tableprefix,$pdo;

    $baseurl.="?artistid=" . $sellerid;

    $link = "<a href='" . $baseurl . "'>" . STORE_HOME_TEXT . "</a> ";

    if ($catid != "") {
        $result = $pdo->select($tableprefix."categories",'',array("category_id"=>$catid))->results();

        if (!empty($result)) {
            $row = $result[0];
            $currcatid = $row["category_id"];
            $currcatname = stripslashes($row["category_name"]);
            $subcats = $row["route"];
        }
        if ($subcats == "") {
            $lastcat = "<a href='" . $baseurl . "&catid=" . $currcatid . "'>" . (stripslashes($currcatname)) . "</a>";
        } else {
            list($qarr,$qstr) = getInQueryString($subcats);
            $sql = "SELECT * FROM " . $tableprefix . "categories where category_id in ($qstr) ";
            $result = $pdo->pdoQuery($sql,$qarr)->results();
            if (!empty($result)) {
                foreach ($result as $row) {
                    $subcatname = stripslashes($row["category_name"]);
                    $subcatid = $row["category_id"];
                    $link .= " <a  href='" . $baseurl . "&catid=" . $subcatid . "' >" . (stripslashes($subcatname)) . "</a>";
                }
            }
            // $link = substr($link, 0, -35);
        }
    }

    $link .= $lastcat;
    return $link;
}

//Function to check Subcategories Exists for a categfory
function checkSubCategoryCount($catid) {
    global $tableprefix,$pdo;
    $result_parent_category = $pdo->select($tableprefix."categories",array("count(category_id) as pcount"),array("parent_id"=>$catid))->results();

    $count = 0;
    if (!empty($result_parent_category)) {
        $rw_parent_category = $result_parent_category[0];
        $count = $rw_parent_category['pcount'];
    }

    return $count;
}

// end function
// Get Seller Average Rating

function GetSellerAverageRating($sellerid) {
    global $tableprefix, $_SESSION, $pdo;
    $sellerRating = 0;

    $rs_rating = $pdo->select($tableprefix . 'artist_feedbacks', array("(SUM(rating)/ count(artist_feedback_id)) as rating", "count(artist_feedback_id) as countrate"), array("artist_id" => $sellerid, "published" => 'Y'))->results();
    if (!empty($rs_rating)) {
        $sellerRating = round($rs_rating[0]['rating']);
    }

    return $sellerRating;
}

function GetSeoTags($pagename, $artistid = '', $enable_seller_friendly = NULL) {
    global $tableprefix, $pdo;
    $page_title = '';
    $page_keywords = '';
    $page_description = '';
    $product_og_image = '';
    if ($pagename != '') {

        $rs_meta_tags = $pdo->select($tableprefix . 'metatags', '', array('vPageName' => $pagename))->results();
        if (!empty($rs_meta_tags)) {

            $page_title = stripslashes($rs_meta_tags[0]['vTitle']);

            $page_keywords = stripslashes($rs_meta_tags[0]['vKeywords']);

            $page_description = stripslashes($rs_meta_tags[0]['vDescription']);
        }


        switch ($pagename) {
            case "productdetails.php":
                $productId = $_REQUEST['productid'];

                $productAlias = end(explode("/", $_SERVER['REQUEST_URI']));
                $arrProductid = $pdo->select($tableprefix . 'products', array('product_id'), array('alias' => $productAlias))->results();
                $productidFromAlias = $arrProductid[0]['product_id'];
                $product_id = ($productidFromAlias != NULL) ? $productidFromAlias : $productId;

                if (isset($_SESSION['og_product_id']) && ($_SESSION['og_product_id']) != "") {
                    $_SESSION['og_product_id'] = "";
                }
                $seo_product_page = GetCategory_productName($product_id);

                $page_title = generalMethods::formatText($seo_product_page['product_title']);

                $page_keywords = generalMethods::formatText($seo_product_page['product_keyword']);

                $page_description = $seo_product_page['product_description'];

                $product_og_description = generalMethods::formatText($seo_product_page['product_og_description']);

                $product_og_url = $seo_product_page['product_og_url'];

                if ($seo_product_page['product_og_image'] != '') {
                    $product_og_image = $seo_product_page['product_og_image'];
                }
                $product_og_title = $seo_product_page['product_og_title'];

                break;

            case "showportfolio.php":

                if ($artistid != '') {
                    $querySeller = "SELECT ap.*, a.artist_name,a.first_name,a.storename,a.last_name,a.company,a.state, a.country ,a.theme_banner,a.theme_color,a.theme_numcols,a.theme_numrows
                                FROM " . $tableprefix . "artists a LEFT JOIN " . $tableprefix . "artist_portfolios ap ON a.artist_id = ap.artist_id  
                            WHERE a.artist_id = :artistid";
                    $resultSeller = $pdo->pdoQuery($querySeller, array("artistid" => $artistid))->results();
                    if (!empty($resultSeller))
                        $objRow = $resultSeller[0];
                    // print_r($objRow);
                    //echo $enable_seller_friendly;
                    if ($enable_seller_friendly == "Y") {
                        $sellerLink = (!empty($objRow['storename'])) ? SITE_URL . "/stores/" . $objRow['storename'] : SITE_URL . "/store/" . $objRow['artist_name'];
                    } else {
                        $sellerLink = (!empty($objRow['storename'])) ? SITE_URL . "/showportfolio.php?storename=" . $objRow['storename'] : SITE_URL . "/showportfolio.php?artistid=" . $objRow['artist_id'];
                    }

                    $sellerLinkName = (!empty($objRow['storename'])) ? ucfirst($objRow['storename']) : ucfirst($objRow['artist_name']);


                    $profileTitle = SITE_NAME . "-Profile -" . $sellerLinkName;
                    $profileKeyWords = SITE_NAME . "-Store -" . $objRow['storename'];

                    if (strlen($objRow['artist_description']) > 200) {
                        $Profiledescription = substr($objRow['artist_description'], 0, 200);
                    } else {
                        $Profiledescription = $objRow['artist_description'];
                    }



                    $page_title = generalMethods::formatText($profileTitle);
                    $page_keywords = generalMethods::formatText($profileKeyWords);
                    $page_description = generalMethods::formatText($Profiledescription);
                    $product_og_description = generalMethods::formatText($Profiledescription);
                    $product_og_url = $sellerLink;
                    $og_image = "";
                    if (($objRow['artist_photo'] != '')) {
                        $og_image = SITE_URL . "/portfolios/" . $objRow['artist_photo'];
                    } else {
                        $og_image = SITE_URL . "/portfolios/noimage.jpg";
                    }
                    $product_og_image = $og_image;
                    $product_og_title = $profileTitle;
                }

                break;

            case "categorydetail.php":

                if ($_REQUEST['catid'] != '') {

                    $category_id = $_REQUEST['catid'];

                    $seo_product_page = GetCategory_metaName($category_id);

                    $page_title = html_entity_decode($seo_product_page['product_title']);

                    $page_keywords = html_entity_decode($seo_product_page['product_keyword']);

                    $page_description = $seo_product_page['product_description'];
                }

                break;
        }


        $page_meta_tags = array("meta_title" => $page_title,
            "meta_keywords" => $page_keywords,
            "meta_description" => $page_description,
            "og_title" => $product_og_title,
            "og_description" => $product_og_description,
            "og_image" => $product_og_image,
            "og_url" => $product_og_url);


        return $page_meta_tags;
    }
}

function GetCategory_productName($productid) {

    global $tableprefix, $pdo;

    $sql_meta_product = "SELECT p.product_name,c.category_name,c.category_id,p.product_description,(p.product_price + p.default_additional_price) as product_price,po.image_big as default_image,p.alias from " . $tableprefix . "products p 
                                        INNER JOIN " . $tableprefix . "product_options po ON (po.product_id = p.product_id AND po.default_option='YES') INNER JOIN " . $tableprefix . "categories c
	 								ON c.category_id=p.product_category  where p.product_id=:product_id ";

    $rs_meta_prodcuct = $pdo->pdoQuery($sql_meta_product, array("product_id" => $productid))->results();

    if (!empty($rs_meta_prodcuct)) {
        $productObj = $rs_meta_prodcuct[0];

        $product_name = generalMethods::formatText($productObj['product_name']);

        $category_name = generalMethods::formatText($productObj['category_name']);

        $category_id = $productObj['category_id'];
        $image_name = SITE_URL . "/products/" . $productObj['default_image'];

        $SEOFriendlyLink = getOptimisedLink(SITE_URL, $productObj['category_id'], $productObj['alias']);

        // Item Description
        if (strlen($productObj['product_description']) > 200) {
            $description = substr($productObj['product_description'], 0, 200);
        } else {
            $description = $productObj['product_description'];
        }

// End Item Description

        $price = $productObj['product_price'];

        $adminCurrency = GetAdminCurrency();

        $description = strip_tags($description);

        $description.= "  Price :: " . $adminCurrency['currency_symbol'] . " " . number_format($price, 2, ".", "");

        $product_meta_description = $description;
    }

    $keywordTag = $product_name . ", " . getCategorynames($category_id) . SITE_NAME;

    $titleTag = $product_name . ", " . getCategorynames($category_id) . SITE_NAME;

    $descriptionTag = $description;


    $product_description = array("product_title" => $titleTag,
        "product_keyword" => $keywordTag,
        "product_description" => $descriptionTag,
        "product_og_description" => $product_meta_description,
        "product_og_title" => $product_name,
        "product_og_image" => $image_name,
        "product_og_url" => $SEOFriendlyLink);

    return $product_description;
}

function GetCategory_metaName($categoryid) {
    global $tableprefix, $pdo;
    $rs_meta_category = $pdo->select($tableprefix . "categories", array("category_name"), array("category_id" => $categoryid))->results();

    if (!empty($rs_meta_category)) {
        $category_name = $rs_meta_category[0]['category_name'];
    }
    $keywordTag = $category_name . "  -  " . SITE_NAME;

    $titleTag = $category_name . "  -  " . SITE_NAME;

    $descriptionTag = $category_name . "  -  " . SITE_NAME;


    $product_description = array("product_title" => $titleTag,
        "product_keyword" => $keywordTag,
        "product_description" => $descriptionTag);

    return $product_description;
}

function getProductPageLink($baseurl, $catid, $productname) {
    global $tableprefix, $pdo;

    $baseurl = SITE_URL . "/" . $baseurl;
    $link = "<a href='" . SITE_URL . "/index.php'> " . HOME_LINK . " </a> ";
    if ($catid != "") {

        $sql = "SELECT * FROM " . $tableprefix . "categories where category_id = " . $catid;
        $result = $pdo->select($tableprefix . "categories", '', array("category_id" => $catid))->results();
        if (!empty($result)) {
            $row = $result[0];
            $currcatid = $row["category_id"];
            $currcatname = stripslashes($row["category_name"]);
            $subcats = $row["route"];
        }
        if ($subcats == "") {
            $lastcat = "<a href='" . $baseurl . "?catid=" . $currcatid . "'>" . (stripslashes($currcatname)) . "</a>";
        } else {
            list($qarr, $qstr) = getInQueryString($subcats);
            $sql = "SELECT * FROM " . $tableprefix . "categories where category_id in ($qstr) ";
            $result = $pdo->pdoQuery($sql, $qarr)->results();
            if (!empty($result)) {
                foreach ($result as $row) {
                    $subcatname = stripslashes($row["category_name"]);
                    $subcatid = $row["category_id"];
                    $link .= " <a  href='" . $baseurl . "?catid=" . $subcatid . "' >" . (stripslashes($subcatname)) . "</a>";
                }
            }
            // $link = substr($link, 0, -35);
        }
    }

    $link .= $lastcat;

    $prodctlink .= " <a  href='#' >" . $productname . "</a>";
    $newlink = $link . $prodctlink;
    return $newlink;
}

function getOptimisedLink($baseurl, $catid, $productname) {
    global $tableprefix, $pdo;

    $link = '';
    if ($catid != "") {

        $result = $pdo->select($tableprefix . 'categories', '', array('category_id' => $catid))->results();
        if (!empty($result[0])) {
            $row = $result[0];
            $currcatid = $row["category_id"];
            $currcatname = str_replace(" ", "", stripslashes($row["alias"]));
            $subcats = $row["route"];
        }
        if ($subcats == "") {
            $optimisedlink = "<a href='" . $baseurl . "/" . stripslashes($currcatname) . "/" . stripslashes($productname) . ">$productname</a>";
            $optimisedURL = $baseurl . "/" . stripslashes($currcatname) . "/" . stripslashes($productname);
        } else {
            list($qarr, $qstr) = getInQueryString($subcats);
            $sql = "SELECT * FROM " . $tableprefix . "categories where category_id in ($qstr) ";
            $result = $pdo->pdoQuery($sql, $qarr)->results();
            if (!empty($result[0])) {
                foreach ($result as $key => $row) {
                    $subcatname = str_replace(" ", "", stripslashes($row["alias"]));
                    $subcatid = $row["category_id"];
                    //$link .= " <a  href='" . $baseurl . "?catid=" . $subcatid . "' >" . (stripslashes($subcatname)) . "</a>";
                    $link .= "/" . stripslashes(strtolower($subcatname));
                }
            }
            $optimisedlink = "<a href='" . $baseurl . $link . "/" . stripslashes(strtolower($productname)) . ">" . $productname . "</a>";
            $optimisedURL = $baseurl . $link . "/" . stripslashes(strtolower($productname));
        }
    }
    //echo $optimisedlink;exit;
    //echo $baseurl . $link. "/". stripslashes(strtolower($productname));exit;
    return $optimisedURL;
}

function getCategorynames($catid) {
    global $tableprefix, $pdo;

    $link = "";

    if ($catid != "") {
        $result = $pdo->select($tableprefix . "categories", '', array("category_id" => $catid))->results();
        if (!empty($result)) {
            $row = $result[0];
            $currcatid = $row["category_id"];
            $currcatname = stripslashes($row["category_name"]);
            $subcats = $row["route"];
        }
        if ($subcats == "") {
            $lastcat = htmlentities(stripslashes($currcatname));
        } else {
            list($qarr, $qstr) = getInQueryString($subcats);
            $sql = "SELECT * FROM " . $tableprefix . "categories where category_id in ($qstr) ";
            $result = $pdo->pdoQuery($sql, $qarr)->results();
            if (!empty($result)) {
                foreach ($result as $key => $row) {
                    $subcatname = stripslashes($row["category_name"]);
                    $subcatid = $row["category_id"];
                    $link .= htmlentities(stripslashes($subcatname)) . " :: ";
                }
            }
            // $link = substr($link, 0, -35);
        }
    }

    $link .= $lastcat;

    return $link;
}

//function to get Product Options -written by Santhosh Thomas Alexander
function getProductOptions($productId, $selectedOption = '', $arr = array(), $selectBoxname, $class = '', $i = 0) {
    global $tableprefix, $pdo;
    $query_product_more_optionsQ = $pdo->select($tableprefix . "product_options", array("product_option_id"), array("product_id" => $productId))->results();
    $product_more_options_count = count($query_product_more_optionsQ);

    if ($product_more_options_count > 1) {
//checking what all options are available for the default Option
        $option .= "1~";
        $option .= "<select name='" . $selectBoxname . "' class='" . $class . "' onChange='changeOption(this);' id='" . $selectBoxname . "'>";

        foreach ($query_product_more_optionsQ as $product_options_obj) {
            $query_available_options = "SELECT GROUP_CONCAT(concat(o.option_name, '-', pov.value) ORDER BY o.option_name ASC SEPARATOR ', ') AS option_val FROM " . $tableprefix . "product_option_values pov
	INNER JOIN " . $tableprefix . "options o ON o.option_id = pov.option_id WHERE pov.product_option_id = :product_option_id ORDER BY o.option_name";
            $query_available_optionsQ = $pdo->pdoQuery($query_available_options, array("product_option_id" => $product_options_obj['product_option_id']))->results();

            foreach ($query_available_optionsQ as $product_options_val_obj) {
                $sel = '';
                if ($selectedOption == $product_options_obj['product_option_id']) {
                    $sel = 'SELECTED';
                }
                $option .= "<option value=" . $product_options_obj['product_option_id'] . " " . $sel . ">" . $product_options_val_obj['option_val'] . "</option>";
            }
        }
        $option .= "</select>";
    } else {
        $product_options_obj = $query_product_more_optionsQ[0];
        $option .= "0~";
        $option .= "<input type='hidden' name='" . $selectBoxname . "'  id='" . $selectBoxname . "' value='" . $product_options_obj['product_option_id'] . "'>";
        $query_available_options = "SELECT GROUP_CONCAT(concat(o.option_name, '-', pov.value) ORDER BY o.option_name ASC SEPARATOR ', ') AS option_val FROM " . $tableprefix . "product_option_values pov
	INNER JOIN " . $tableprefix . "options o ON o.option_id = pov.option_id WHERE pov.product_option_id = :product_option_id ORDER BY o.option_name";
        $query_available_optionsQ = $pdo->pdoQuery($query_available_options, array("product_option_id" => $product_options_obj['product_option_id']))->results();

        foreach ($query_available_optionsQ as $product_options_val_obj) {
            $option .= "<div style='width:150px;' class='selectbox'>";
            $option .= $product_options_val_obj['option_val'];
            $option .= "</div>";
        }
    }
    return $option;
}

function getOptionsFromCategory($catid) {
    $options_arr = array();
    global $tableprefix, $pdo;
    if ($catid != "") {
        $query_cat_options = "SELECT o.option_id,o.option_name
                            FROM " . $tableprefix . "options o
                                INNER JOIN " . $tableprefix . "category_options co ON co.option_id = o.option_id AND co.category_id = :category_id ORDER BY o.option_name";
        //$cat_optionsQ = mysql_query($query_cat_options);
        $qryoptArr['category_id'] = $catid;
	$cat_optionsQ = $pdo->pdoQuery($query_cat_options,$qryoptArr)->results();
        //while ($optionsObj = mysql_fetch_object($cat_optionsQ)) {
        foreach($cat_optionsQ as $optionsObj){
            $options_arr[] = array("option_id" => $optionsObj['option_id'], "option_name" => $optionsObj['option_name']);
        }
    }
    return $options_arr;
}

function getProductOptionsName($productOptionId, $arr = array()) {
    global $tableprefix, $pdo;
    $option .= "";
    $query_available_options = "SELECT GROUP_CONCAT(concat(o.option_name, '-', pov.value) ORDER BY o.option_name ASC SEPARATOR ', ') AS option_val FROM " . $tableprefix . "product_option_values pov
	INNER JOIN " . $tableprefix . "options o ON o.option_id = pov.option_id WHERE pov.product_option_id = :product_option_id ORDER BY o.option_name";
    $query_available_optionsQ = $pdo->pdoQuery($query_available_options, array("product_option_id" => $productOptionId))->results();
    foreach ($query_available_optionsQ as $product_options_val_obj) {
        $option .= $product_options_val_obj['option_val'];
    }
    return $option;
}

// Paypal Parallel Payment Data Retrievel
function decodePayPalIPN($raw_post) {
    if (empty($raw_post)) {
        return array();
    } # else:
    $post = array();
    $pairs = explode('&', $raw_post);
    foreach ($pairs as $pair) {
        list($key, $value) = explode('=', $pair, 2);
        $key = urldecode($key);
        $value = urldecode($value);
        # This is look for a key as simple as 'return_url' or as complex as 'somekey[x].property'
        preg_match('/(\w+)(?:\[(\d+)\])?(?:\.(\w+))?/', $key, $key_parts);
        switch (count($key_parts)) {
            case 4:
                # Original key format: somekey[x].property
                # Converting to $post[somekey][x][property]
                if (!isset($post[$key_parts[1]])) {
                    $post[$key_parts[1]] = array($key_parts[2] => array($key_parts[3] => $value));
                } else if (!isset($post[$key_parts[1]][$key_parts[2]])) {
                    $post[$key_parts[1]][$key_parts[2]] = array($key_parts[3] => $value);
                } else {
                    $post[$key_parts[1]][$key_parts[2]][$key_parts[3]] = $value;
                }
                break;
            case 3:
                # Original key format: somekey[x]
                # Converting to $post[somkey][x]
                if (!isset($post[$key_parts[1]])) {
                    $post[$key_parts[1]] = array();
                }
                $post[$key_parts[1]][$key_parts[2]] = $value;
                break;
            default:
                # No special format
                $post[$key] = $value;
                break;
        }#switch
    }#foreach

    return $post;
}

#decodePayPalIPN()
//Function to check Subcategories Exists for a categfory
function checkProductStock($productid) {
    global $tableprefix,$pdo;
    $product_count = 0;
    $result_product_stock = $pdo->select($tableprefix."product_options",array("sum(product_stock ) AS product_stock"),array("product_id"=>$productid))->results();

    if (!empty($result_product_stock)) {
        $rw_product_count = $result_product_stock[0];
        $product_count = $rw_product_count['product_stock'];
    }
    return $product_count;
}

// end function
//Function to check Digital Product Order
function checkDigitalOrder($orderid, $artistid) {
    global $tableprefix, $pdo;

    $digital_count = false;

    /* $select_digital_count = "SELECT d.ndigital_id  FROM ".$tableprefix."digital_product d
      INNER JOIN ".$tableprefix."orders o  ON o.order_id=d.ndigital_orderid
      where d.ndigital_orderid='".$orderid."'"; */
    $qryoptArr=array();
    $select_digital_count = "SELECT order_detail_id  FROM " . $tableprefix . "order_details
                             where order_id= :orderid AND digital_product_flag ='Y'";
    $qryoptArr['orderid'] = $orderid;
    if ($artistid > 0) {
        $select_digital_count .= " AND artist_id= :artistid";
        $qryoptArr['artistid'] = $artistid;
    }
    $result_digital_count = $pdo->pdoQuery($select_digital_count, $qryoptArr)->results();

    if (count($result_digital_count) != 0) {
        //$rw_product_count = mysql_fetch_array($result_digital_count);
        //$digital_count=$rw_product_count['product_stock'];
        $digital_count = true;
    }

    return $digital_count;
}

// end function

function count_digit($number) {
    return strlen((string) $number);
}

function bulkuploadText() {


    $txtArray = array("product_name" => TXT_PD_NAME,
        "product_category" => TXT_PD_CAT,
        "product_code" => TXT_PD_CODE,
        "product_description" => TXT_PD_DESC,
        "product_price" => TXT_PD_PRICE,
        "options" => TXT_PD_OPT,
        "additional_price" => TXT_PD_PRICE,
        "product_stock" => TXT_PD_STOCK,
        "reorder_level" => TXT_PD_LEVEL,
        "small_image" => TXT_PD_SMALLIMG,
        "big_image" => TXT_PD_BIGIMG,
        "more_images" => TXT_PD_IMG,
        "discount" => TXT_PD_DISCOUNT,
        "discount_description" => TXT_PD_DESC,
        "shipping_weight" => TXT_PD_WEIGHT,
        "product_length" => TXT_PD_LENGTH,
        "product_width" => TXT_PD_WIDTH,
        "product_height" => TXT_PD_HEIGHT);
    return $txtArray;
}

/* * ******************** Copy a Folder & its Contents ************************ */

function recurse_copy($src, $dst) {

    $dir = opendir($src);

    @mkdir($dst);

    while (false !== ( $file = readdir($dir))) {

        if (( $file != '.' ) && ( $file != '..' )) {

            if (is_dir($src . '/' . $file)) {

                recurse_copy($src . '/' . $file, $dst . '/' . $file);
            } else {

                copy($src . '/' . $file, $dst . '/' . $file);
            }
        }
    }

    closedir($dir);
}

function getStoreAlias($storename, $storenameOrig, $artistid = NULL) {
    global $tableprefix,$pdo;
    $whereArr = array();
    if (empty($artistid)) {
        $whereArr['storename'] = $storename;
        $sql = "select storename from  " . $tableprefix . "artists where storename=:storename";
    } else {
        $whereArr['storename'] = $storename;
        $whereArr['artist_id'] = $artistid;
        $sql = "select storename from  " . $tableprefix . "artists where storename=:storename AND artist_id <> :artist_id ";
    }

    $result = $pdo->pdoQuery($sql,$whereArr)->results();
    if (!empty($result)) {
        $storename = $storenameOrig . "-" . rand_str(4);
        $storename = getStoreAlias($storename, $storenameOrig, $artistid);
    }
    return $storename;
}

function rand_str($length = 32, $chars = 'abcdefghijklmnopqrstuvwxyz1234567890') {
    // Length of character list
    $chars_length = (strlen($chars) - 1);

    // Start our string
    $string = $chars{rand(0, $chars_length)};

    // Generate random string
    for ($i = 1; $i < $length; $i = strlen($string)) {
        // Grab a random character from our list
        $r = $chars{rand(0, $chars_length)};

        // Make sure the same two characters don't appear next to each other
        if ($r != $string{$i - 1})
            $string .= $r;
    }

    // Return the string
    return $string;
}

/* backup the db OR just a table */

function backup_tables($tables = '*') {

    global $pdo;

    //get all of the tables
    if($tables == '*') {
        $tables = array();
        $result = $pdo->pdoQuery('SHOW TABLES','')->results();
        foreach($result as $row) {
            $tables[] = $row[0];
        }
    } else {
        $tables = is_array($tables) ? $tables : explode(',',$tables);
    }

    //cycle through
    foreach($tables as $table)
    {
        $result = $pdo->pdoQuery('SELECT * FROM '.$table)->results();
        $num_fields = count($result[0]);

        $return.= 'DROP TABLE '.$table.';';
        $tres = $pdo->pdoQuery('SHOW CREATE TABLE '.$table)->results();
        $row2 = ($tres[0]);
        $return.= "\n\n".$row2['Create Table'].";\n\n";

        for ($i = 0; $i < $num_fields; $i++)
        {
            foreach($result as $row)
            {   
                $trow=array();
                foreach ($row as $key => $value) {
                    array_push($trow, $value);
                }
                $row=$trow;
                $return.= 'INSERT INTO '.$table.' VALUES(';
                for($j=0; $j<$num_fields; $j++)
                {
                    $row[$j] = addslashes($row[$j]);
                    $row[$j] = preg_replace_callback('/[\n\r]/','\\n',$row[$j]);
                    if (isset($row[$j])) { $return.= '"'.$row[$j].'"' ; } else { $return.= '""'; }
                    if ($j<($num_fields-1)) { $return.= ','; }
                }
                $return.= ");\n";
            }
        }
        $return.="\n\n\n";
    }

    //save file


        $filename = 'db'.time().'.sql';
    $handle = fopen('../dbbackups/'.$filename,'w+');
    fwrite($handle,$return);
    fclose($handle);

    return $filename;
}

function remove_comments(&$output) {
    $lines = explode("\n", $output);
    $output = "";

    // try to keep mem. use down
    $linecount = count($lines);

    $in_comment = false;
    for ($i = 0; $i < $linecount; $i++) {
        if (preg_match("/^\/\*/", preg_quote($lines[$i]))) {
            $in_comment = true;
        }

        if (!$in_comment) {
            $output .= $lines[$i] . "\n";
        }

        if (preg_match("/\*\/$/", preg_quote($lines[$i]))) {
            $in_comment = false;
        }
    }

    unset($lines);
    return $output;
}

//
// remove_remarks will strip the sql comment lines out of an uploaded sql file
//
function remove_remarks($sql) {
    $lines = explode("\n", $sql);

    // try to keep mem. use down
    $sql = "";

    $linecount = count($lines);
    $output = "";

    for ($i = 0; $i < $linecount; $i++) {
        if (($i != ($linecount - 1)) || (strlen($lines[$i]) > 0)) {
            if (isset($lines[$i][0]) && $lines[$i][0] != "#") {
                $output .= $lines[$i] . "\n";
            } else {
                $output .= "\n";
            }
            // Trading a bit of speed for lower mem. use here.
            $lines[$i] = "";
        }
    }

    return $output;
}

function splitsqlfile($sql, $delimiter) {
// Split up our string into "possible" SQL statements.
    $tokens = explode($delimiter, $sql);
// try to save mem.
    $sql = "";
    $output = array();
// we don't actually care about the matches preg gives us.
    $matches = array();
// this is faster than calling count($oktens) every time thru the loop.
    $token_count = count($tokens);
    for ($i = 0; $i < $token_count; $i++) {
// Don't wanna add an empty string as the last thing in the array.
        if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0))) {
// This is the total number of single quotes in the token.
            $total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
// Counts single quotes that are preceded by an odd number of backslashes,
// which means they're escaped quotes.
            $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);

            $unescaped_quotes = $total_quotes - $escaped_quotes;
// If the number of unescaped quotes is even, then the delimiter did NOT occur inside a string literal.
            if (($unescaped_quotes % 2) == 0) {
// It's a complete sql statement.
                $output[] = $tokens[$i];
// save memory.
                $tokens[$i] = "";
            } else {
// incomplete sql statement. keep adding tokens until we have a complete one.
// $temp will hold what we have so far.
                $temp = $tokens[$i] . $delimiter;
// save memory..
                $tokens[$i] = "";
// Do we have a complete statement yet?
                $complete_stmt = false;

                for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++) {
// This is the total number of single quotes in the token.
                    $total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
// Counts single quotes that are preceded by an odd number of backslashes,
// which means they're escaped quotes.
                    $escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);

                    $unescaped_quotes = $total_quotes - $escaped_quotes;

                    if (($unescaped_quotes % 2) == 1) {
// odd number of unescaped quotes. In combination with the previous incomplete
// statement(s), we now have a complete statement. (2 odds always make an even)
                        $output[] = $temp . $tokens[$j];
// save memory.
                        $tokens[$j] = "";
                        $temp = "";
// exit the loop.
                        $complete_stmt = true;
// make sure the outer loop continues at the right point.
                        $i = $j;
                    } else {
// even number of unescaped quotes. We still don't have a complete statement.
// (1 odd and 1 even always make an odd)
                        $temp .= $tokens[$j] . $delimiter;
// save memory.
                        $tokens[$j] = "";
                    }
                } // for..
            } // else
        }
    }
    return $output;
}

//Check Product is Digital Or Not

function isDigital($productid) {
    global $tableprefix, $pdo;

    $digitalFlag = 'N';

    if (!empty($productid)) {
        $data = $pdo->select($tableprefix . "products", array("vdigital_product"), array("product_id" => $productid))->results();
        if (!empty($data)) {
            $rsObj = $data[0];

            $digitalFlag = $rsObj['vdigital_product'];
        }
    }
    return $digitalFlag;
}

function isSellerApproved($txtEmail) {
    global $tableprefix,$pdo;

    $approvalFlag = 'Y';

    if (!empty($txtEmail)) {
        $sql = "SELECT vapproved, artist_id FROM " . $tableprefix . "artists WHERE email = '" . $txtEmail . "' ";
        $rsObj = $pdo->pdoQuery($sql)->result();
        if (!empty($rsObj)) {
//            $rsObj = mysql_fetch_object($res);

            $approvalFlag = $rsObj->vapproved;
        }
    }
    return $approvalFlag;
}

//Send Order Staus Change Mail To Buyer

function sendOrderStatusChangeMailToBuyer($order_id, $artistid, $orderstatus, $from = 'A', $cancelFlag = false) {
    global $tableprefix, $pdo;


    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];


    if ($from == 'S') {
        $senderName = SELLER_CAPTION . " " . getorderSellerName($artistid);


        if ($cancelFlag) {
            $sellerCaption = 'The  ' . $senderName . '  has   <span style="font-size:12px; color:#991818; font-weight:bold; "> ' . $orderstatus . '  </span> ' . ORDER_STATUS_CHANGE_CAPTION_SELLER . '  ' . SITE_NAME . '  (' . SITE_URL . ')';
        } else {
            $sellerCaption = 'The ' . $senderName . '  ' . ORDER_STATUS_CHANGE_CAPTION . '<span style="font-size:12px; color:#991818; font-weight:bold; "> ' . $orderstatus . '  </span> ' . ORDER_STATUS_CHANGE_TEXT . '  ' . SITE_NAME . '  (' . SITE_URL . ')';
        }
    } else {

        $senderName = SITE_NAME;


        if ($cancelFlag) {
            $sellerCaption = 'The ' . $senderName . ' has   <span style="font-size:12px; color:#991818; font-weight:bold; "> ' . $orderstatus . '  </span>  ' . ORDER_STATUS_CHANGE_CAPTION_ADMIN . '  ' . getorderSellerName($artistid) . ' ' . ORDER_STATUS_CHANGE_ORDER_TEXT . ' ' . SITE_NAME . '  (' . SITE_URL . ') ';
        } else {

            $sellerCaption = 'The ' . $senderName . ' ' . ORDER_STATUS_CHANGE_CAPTION . '  <span style="font-size:12px; color:#991818; font-weight:bold; "> ' . $orderstatus . '  </span>  ' . ORDER_STATUS_CHANGE_SELLER_TEXT . '  ' . getorderSellerName($artistid) . ' ' . ORDER_STATUS_CHANGE_ORDER_TEXT . ' ' . SITE_NAME . '  (' . SITE_URL . ') ';
        }
    }


    if ($cancelFlag) {
        $Date_Text = ORDER_CANCELLATION_DATE;
    } else {
        $Date_Text = ORDER_STATUS_CHANGE_DATE;
    }

    $currentDate = date('m-d-Y :H:i:s');

    $queryOrder = "SELECT o.* ,concat(o.billing_first_name,' ',billing_last_name) AS buyername , o.billing_email as buyeremail , DATE_FORMAT(o.order_date,'%m-%d-%Y') as order_dateF from " . $tableprefix . "orders o  where order_id=" . $order_id . " ";
    $orderQ = $pdo->pdoQuery($queryOrder)->result();
    $orderObj = (object)($orderQ);
    $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';
    $mailContent .= '<tr>
		<td colspan="2">' . MAIL_SALUTATION . '  ' . $orderObj->buyername . ', </td>
		</tr><tr>
		<td colspan="2"> ' . $sellerCaption . ' </td>
		</tr>
		<tr>
		<tr>';

    $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj->order_id . '</td>
		</tr>
		<tr>
		<td >' . $Date_Text . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currentDate . '</td>
		</tr>
		<tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . PRODUCT_DETAILS_INFO . ' 	
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
		</tr>';

    $queryOrderDetail = "SELECT od.* FROM " . $tableprefix . "order_details od 
                                                WHERE od.order_id =" . $order_id . " AND od.artist_id='" . $artistid . "' ";

    $orderDetailQ = $pdo->pdoQuery($queryOrderDetail)->results();
    $orderDetailQ  = (object)$orderDetailQ;
    $itemTotal = 0;
    $inc = 1;
    foreach($orderDetailQ as $orderDetailObj) {
           $optionStr = "";


        $productname = stripslashes($orderDetailObj->product_name);
        $couponCodeDiscount = $orderObj->couponCodeDiscount;
        $productname.= $optionStr;



        $converted_price = $orderDetailObj->product_price;

        $rate = number_format(($converted_price), 2, ".", "");


        $qty = $orderDetailObj->product_quantity;
        $price = $qty * $rate;
        $discountstr = "";
        if ($orderDetailObj->product_discount != "0") {
            $price = $price - ($price * $orderDetailObj->product_discount) / 100;

            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj->product_discount . "%)";
        }



        //$productPrice = number_format(($currency_attributes[1] * $productPrice),2,".","");


        $itemTotal+=$price;

        $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . ' </td>            
		<td align="left" valign="top">' . $orderDetailObj->product_code . '</td>              
		<td align="left" valign="top">' . $productname . '</td>                    
		<td align="left" valign="top">' . formatChar($currency_attributes[0]) . '&nbsp;' . number_format($rate, 2, ".", "") . '</td>                    
		<td align="left" valign="top">&nbsp;' . $orderDetailObj->product_quantity . '</td>
		<td align="left" valign="top">' . formatChar($currency_attributes[0]) . '&nbsp;' . number_format($price, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
	         </tr>';


        $inc++;
    }
    $mailContent.='<tr><td colspan="6">&nbsp;</td></tr></table>
		</td>
		</tr>';


    $mailContent .='</table>';

    $mailcontent_admin = readEmailTemplate('order_statuschange_buyer_seller');

    //echo $orderObj->billing_first_name.$orderObj->billing_last_name;
    //echo "<br>";



    $mailcontent_admin = str_replace('[order_details]', $mailContent, $mailcontent_admin);


    $mail_send_details_admin = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">
         
         <table width="95%" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_admin . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

    //echo $mail_send_details_admin;

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_ORDER_STATUS_SUBJECT_1 . " " . SITE_NAME . " " . MAIL_ORDER_STATUS_SUBJECT_2;

    //$orderObj->billing_email='asha.s@armiasystems.com';
    //echo $mail_send_details_admin;

    $buyeremail = $orderObj->buyeremail;


    //$buyeremail     =   'armiatester@gmail.com';

    $mailsent = mail($buyeremail, $ordersubject, $mail_send_details_admin, $headers);

// 	 echo $mailContent;
// 		exit;
}

function getorderSellerName($sellerid) {
   

    global $tableprefix,$pdo;

    $seller_rw = $pdo->select($tableprefix."artists",array("concat(first_name,' ',last_name) AS name"),array("artist_id"=>$sellerid))->result();
   
    return ucwords($seller_rw);

    
}

function getorderSellerInfo($sellerid) {
    global $tableprefix,$pdo;

    $seller_rs = $pdo->select($tableprefix."artists",array("concat(first_name,' ',last_name) AS name","email"),array("artist_id"=>$sellerid))->results();
    $seller_rw = $seller_rs[0];
    return $seller_rw;
}

function checkShippingDimensionEnable() {
    global $tableprefix,$pdo;

    $shippingmode = 'N';

    $select_settings = "SELECT * FROM " . $tableprefix . "settings WHERE 1";
    $result_settings = $pdo->pdoQuery($select_settings)->results();

    //$result_settings = mysql_query($select_settings) or die(mysql_error());
    $row = $result_settings['0'];
    $fedexmode = $row['enable_fedexshipping'];
    $upsmode = $row['enable_shipping'];
    $uspsmode = $row['enable_uspsshipping'];
    $canadapost = $row['enable_canadapost'];
    $australiapost = $row['enable_australiapost'];
    $flatrate = $row['enable_flatrate'];
    if ($fedexmode != 'N' || $canadapost != 'N') { // check whether shipping Enabled or Not
        $shippingmode = "Y";
    } // end Shipping Check

    return $shippingmode;
}


function chekOtherGiftCertificateSellerItems($txtGiftCode, $userid) {
    global $tableprefix, $pdo;


    $otherSellerItems = 0;

    $rs_code = $pdo->select($tableprefix . "giftcertificates", '', array("vgift_coupon_code" => $txtGiftCode))->results();

    if (!empty($rs_code)) {
        $rsobj = $rs_code[0];

        $sellerid = $rsobj['seller_id'];

        $sql_select_products = "SELECT p.product_id,p.product_name
                                                      FROM " . $tableprefix . "product_options po
                                                      INNER JOIN " . $tableprefix . "products p ON po.product_id = p.product_id
                                                      INNER JOIN " . $tableprefix . "cart c ON c.product_option_id=po.product_option_id
                                                      WHERE c.user_id=:user_id and p.product_artist_id!=:product_artist_id ";
        $rs_select_products = $pdo->pdoQuery($sql_select_products, array("user_id" => $userid, "product_artist_id" => $sellerid))->results();

        if (!empty($rs_select_products)) {
            foreach ($rs_select_products as $rows) {
                $productids[] = $rows['product_id'];
            }

            if (count($productids) > 0) {
                $otherSellerItems = 1;
            }

            //$products	=join(",",$productids);
        }
    }

    return $otherSellerItems;
}

// Copy images from url to server
function getimg($url) {
    $headers[] = 'Accept: image/gif, image/x-bitmap, image/jpeg, image/pjpeg, image/png';
    $headers[] = 'Connection: Keep-Alive';
    $headers[] = 'Content-type: application/x-www-form-urlencoded;charset=UTF-8';
    $user_agent = 'php';
    $process = curl_init($url);
    curl_setopt($process, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($process, CURLOPT_HEADER, 0);
    curl_setopt($process, CURLOPT_USERAGENT, $useragent);
    curl_setopt($process, CURLOPT_TIMEOUT, 30);
    curl_setopt($process, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($process, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($process, CURLOPT_SSL_VERIFYPEER, false);
    $return = curl_exec($process);
    curl_close($process);
    return $return;
}

function format_csv_des($string) {

    //Make alphanumeric (removes all other characters)
    $string = preg_replace("/[^A-Za-z0-9_\s-]/", "", $string);
    //Clean up multiple dashes or whitespaces
    $string = preg_replace("/[\s-]+/", " ", $string);
    //Convert whitespaces and underscore to dash
    $string = preg_replace("/[\s_]/", "-", $string);
    return $string;
}

function reSizeImageFromFolder($smallImagename, $newWidth = '', $newHeight = '') {
    $validExtensions = array('.jpg', '.jpeg', '.gif', '.png');
    // get extension of the uploaded file
    $fileExtension = strrchr($smallImagename, ".");

    if (in_array($fileExtension, $validExtensions) && isset($smallImagename)) {

        list($currentWidth, $currentHeight, $type, $attr) = getimagesize($smallImagename);



        if ($currentHeight > $newHeight && $currentWidth > $newWidth) {
            $aspect = $currentWidth / $currentHeight;

            if ($currentWidth >= $currentHeight) {
                $newWidth = $newWidth;
                $newHeight = $newWidth / $aspect;
                $option = 'exact';
            } else {
                $newHeight = $newHeight;
                $newWidth = $newHeight * $aspect;
                $option = 'exact';
            }

            $resizeObject = new ResizeComponent();
            $resizeObject->index($smallImagename);
            //$resizeObject->resizeImage($newWidth, $newHeight, $option);
            $resizeObject->saveImage($smallImagename, 100);
        }
    }
}

function getcategoryList($catid) {
    global $tableprefix, $pdo;

    $link = "";

    $sep = "/";

    if ($catid != "") {

        $sql = "SELECT * FROM " . $tableprefix . "categories where category_id = :catid";
        $result = $pdo->pdoQuery($sql, array("catid" => $catid))->results();
        if (count($result) != 0) {
            $row = ($result[0]);
            $currcatid = $row["category_id"];
            $currcatname = stripslashes($row["category_name"]);
            $subcats = $row["route"];
        }
        if ($subcats == "") {
            $lastcat = "<a href='#'>" . (stripslashes($currcatname)) . "</a>";
        } else {
            list($qarr,$qstr) = getInQueryString($subcats);
            $sql = "SELECT * FROM " . $tableprefix . "categories where category_id in ($qstr) ";
            if(count($qarr) > 0)
                $result = $pdo->pdoQuery($sql, $qarr)->results();
            if (count($result) != 0) {
                foreach ($result as $row) {
                    $subcatname = stripslashes($row["category_name"]);
                    $subcatid = $row["category_id"];
                    $link .= " <a  href='#' >" . (stripslashes($subcatname)) . "</a> " . $sep;
                }
            }
            $link = rtrim($link, " /");
        }
    }

    $link .= $lastcat;

    // $prodctlink .= " <a  href='#' >" . $productname . "</a>";
    $newlink = $link;
    return $newlink;
}

function echopre($printArray) {
    echo "<pre>";
    print_r($printArray);
    echo "</pre>";
}

function echopre1($printArray) {
    echo "<pre>";
    print_r($printArray);
    echo "</pre>";
    exit();
}

//--Get State Country from Code--//
function getCodeValue($code, $flag, $countryCode = NULL) {
// Flag 1 - country, 2-state
// countryCode is required for fetching state, not mandatory for fetching country
    $country = array("AF" => "Afghanistan",
        "AL" => "Albania",
        "DZ" => "Algeria",
        "AS" => "American Samoa",
        "AD" => "Andorra",
        "AO" => "Angola",
        "AI" => "Anguilla",
        "AQ" => "Antarctica",
        "AG" => "Antigua and Barbuda",
        "AR" => "Argentina",
        "AM" => "Armenia",
        "AW" => "Aruba",
        "AU" => "Australia",
        "AT" => "Austria",
        "AZ" => "Azerbaijan",
        "AP" => "Azores",
        "BS" => "Bahamas",
        "BH" => "Bahrain",
        "BD" => "Bangladesh",
        "BB" => "Barbados",
        "BY" => "Belarus",
        "BE" => "Belgium",
        "BZ" => "Belize",
        "BJ" => "Benin",
        "BM" => "Bermuda",
        "BT" => "Bhutan",
        "BO" => "Bolivia",
        "BA" => "Bosnia And Herzegowina",
        "XB" => "Bosnia-Herzegovina",
        "BW" => "Botswana",
        "BV" => "Bouvet Island",
        "BR" => "Brazil",
        "IO" => "British Indian Ocean Territory",
        "VG" => "British Virgin Islands",
        "BN" => "Brunei Darussalam",
        "BG" => "Bulgaria",
        "BF" => "Burkina Faso",
        "BI" => "Burundi",
        "KH" => "Cambodia",
        "CM" => "Cameroon",
        "CA" => "Canada",
        "CV" => "Cape Verde",
        "KY" => "Cayman Islands",
        "CF" => "Central African Republic",
        "TD" => "Chad",
        "CL" => "Chile",
        "CN" => "China",
        "CX" => "Christmas Island",
        "CC" => "Cocos (Keeling) Islands",
        "CO" => "Colombia",
        "KM" => "Comoros",
        "CG" => "Congo",
        "CD" => "Congo, The Democratic Republic O",
        "CK" => "Cook Islands",
        "XE" => "Corsica",
        "CR" => "Costa Rica",
        "CI" => "Cote d` Ivoire (Ivory Coast)",
        "HR" => "Croatia",
        "CU" => "Cuba",
        "CY" => "Cyprus",
        "CZ" => "Czech Republic",
        "DK" => "Denmark",
        "DJ" => "Djibouti",
        "DM" => "Dominica",
        "DO" => "Dominican Republic",
        "TP" => "East Timor",
        "EC" => "Ecuador",
        "EG" => "Egypt",
        "SV" => "El Salvador",
        "GQ" => "Equatorial Guinea",
        "ER" => "Eritrea",
        "EE" => "Estonia",
        "ET" => "Ethiopia",
        "FK" => "Falkland Islands (Malvinas)",
        "FO" => "Faroe Islands",
        "FJ" => "Fiji",
        "FI" => "Finland",
        "FR" => "France (Includes Monaco)",
        "FX" => "France, Metropolitan",
        "GF" => "French Guiana",
        "PF" => "French Polynesia",
        "TA" => "French Polynesia (Tahiti)",
        "TF" => "French Southern Territories",
        "GA" => "Gabon",
        "GM" => "Gambia",
        "GE" => "Georgia",
        "DE" => "Germany",
        "GH" => "Ghana",
        "GI" => "Gibraltar",
        "GR" => "Greece",
        "GL" => "Greenland",
        "GD" => "Grenada",
        "GP" => "Guadeloupe",
        "GU" => "Guam",
        "GT" => "Guatemala",
        "GN" => "Guinea",
        "GW" => "Guinea-Bissau",
        "GY" => "Guyana",
        "HT" => "Haiti",
        "HM" => "Heard And Mc Donald Islands",
        "VA" => "Holy See (Vatican City State)",
        "HN" => "Honduras",
        "HK" => "Hong Kong",
        "HU" => "Hungary",
        "IS" => "Iceland",
        "IN" => "India",
        "ID" => "Indonesia",
        "IR" => "Iran",
        "IQ" => "Iraq",
        "IE" => "Ireland",
        "EI" => "Ireland (Eire)",
        "IL" => "Israel",
        "IT" => "Italy",
        "JM" => "Jamaica",
        "JP" => "Japan",
        "JO" => "Jordan",
        "KZ" => "Kazakhstan",
        "KE" => "Kenya",
        "KI" => "Kiribati",
        "KP" => "Korea, Democratic People'S Repub",
        "KW" => "Kuwait",
        "KG" => "Kyrgyzstan",
        "LA" => "Laos",
        "LV" => "Latvia",
        "LB" => "Lebanon",
        "LS" => "Lesotho",
        "LR" => "Liberia",
        "LY" => "Libya",
        "LI" => "Liechtenstein",
        "LT" => "Lithuania",
        "LU" => "Luxembourg",
        "MO" => "Macao",
        "MK" => "Macedonia",
        "MG" => "Madagascar",
        "ME" => "Madeira Islands",
        "MW" => "Malawi",
        "MY" => "Malaysia",
        "MV" => "Maldives",
        "ML" => "Mali",
        "MT" => "Malta",
        "MH" => "Marshall Islands",
        "MQ" => "Martinique",
        "MR" => "Mauritania",
        "MU" => "Mauritius",
        "YT" => "Mayotte",
        "MX" => "Mexico",
        "FM" => "Micronesia, Federated States Of",
        "MD" => "Moldova, Republic Of",
        "MC" => "Monaco",
        "MN" => "Mongolia",
        "MS" => "Montserrat",
        "MA" => "Morocco",
        "MZ" => "Mozambique",
        "MM" => "Myanmar (Burma)",
        "NA" => "Namibia",
        "NR" => "Nauru",
        "NP" => "Nepal",
        "NL" => "Netherlands",
        "AN" => "Netherlands Antilles",
        "NC" => "New Caledonia",
        "NZ" => "New Zealand",
        "NI" => "Nicaragua",
        "NE" => "Niger",
        "NG" => "Nigeria",
        "NU" => "Niue",
        "NF" => "Norfolk Island",
        "MP" => "Northern Mariana Islands",
        "NO" => "Norway",
        "OM" => "Oman",
        "PK" => "Pakistan",
        "PW" => "Palau",
        "PS" => "Palestinian Territory, Occupied",
        "PA" => "Panama",
        "PG" => "Papua New Guinea",
        "PY" => "Paraguay",
        "PE" => "Peru",
        "PH" => "Philippines",
        "PN" => "Pitcairn",
        "PL" => "Poland",
        "PT" => "Portugal",
        "PR" => "Puerto Rico",
        "QA" => "Qatar",
        "RE" => "Reunion",
        "RO" => "Romania",
        "RU" => "Russian Federation",
        "RW" => "Rwanda",
        "KN" => "Saint Kitts And Nevis",
        "SM" => "San Marino",
        "ST" => "Sao Tome and Principe",
        "SA" => "Saudi Arabia",
        "SN" => "Senegal",
        "XS" => "Serbia-Montenegro",
        "SC" => "Seychelles",
        "SL" => "Sierra Leone",
        "SG" => "Singapore",
        "SK" => "Slovak Republic",
        "SI" => "Slovenia",
        "SB" => "Solomon Islands",
        "SO" => "Somalia",
        "ZA" => "South Africa",
        "GS" => "South Georgia And The South Sand",
        "KR" => "South Korea",
        "ES" => "Spain",
        "LK" => "Sri Lanka",
        "NV" => "St. Christopher and Nevis",
        "SH" => "St. Helena",
        "LC" => "St. Lucia",
        "PM" => "St. Pierre and Miquelon",
        "VC" => "St. Vincent and the Grenadines",
        "SD" => "Sudan",
        "SR" => "Suriname",
        "SJ" => "Svalbard And Jan Mayen Islands",
        "SZ" => "Swaziland",
        "SE" => "Sweden",
        "CH" => "Switzerland",
        "SY" => "Syrian Arab Republic",
        "TW" => "Taiwan",
        "TJ" => "Tajikistan",
        "TZ" => "Tanzania",
        "TH" => "Thailand",
        "TG" => "Togo",
        "TK" => "Tokelau",
        "TO" => "Tonga",
        "TT" => "Trinidad and Tobago",
        "XU" => "Tristan da Cunha",
        "TN" => "Tunisia",
        "TR" => "Turkey",
        "TM" => "Turkmenistan",
        "TC" => "Turks and Caicos Islands",
        "TV" => "Tuvalu",
        "UG" => "Uganda",
        "UA" => "Ukraine",
        "AE" => "United Arab Emirates",
        "UK" => "United Kingdom",
        "GB" => "Great Britain",
        "US" => "United States",
        "UM" => "United States Minor Outlying Isl",
        "UY" => "Uruguay",
        "UZ" => "Uzbekistan",
        "VU" => "Vanuatu",
        "XV" => "Vatican City",
        "VE" => "Venezuela",
        "VN" => "Vietnam",
        "VI" => "Virgin Islands (U.S.)",
        "WF" => "Wallis and Furuna Islands",
        "EH" => "Western Sahara",
        "WS" => "Western Samoa",
        "YE" => "Yemen",
        "YU" => "Yugoslavia",
        "ZR" => "Zaire",
        "ZM" => "Zambia",
        "ZW" => "Zimbabwe");

    $state = array("US" => array("AK" => "Alaska",
            "AL" => "Alabama",
            "AR" => "Arkansas",
            "AS" => "American Samoa",
            "AZ" => "Arizona",
            "CA" => "California",
            "CO" => "Colorado",
            "CT" => "Connecticut",
            "DC" => "D.C.",
            "DE" => "Delaware",
            "FL" => "Florida",
            "FM" => "Micronesia",
            "GA" => "Georgia",
            "GU" => "Guam",
            "HI" => "Hawaii",
            "IA" => "Iowa",
            "ID" => "Idaho",
            "IL" => "Illinois",
            "IN" => "Indiana",
            "KS" => "Kansas",
            "KY" => "Kentucky",
            "LA" => "Louisiana",
            "MA" => "Massachusetts",
            "MD" => "Maryland",
            "ME" => "Maine",
            "MH" => "Marshall Islands",
            "MI" => "Michigan",
            "MN" => "Minnesota",
            "MO" => "Missouri",
            "MP" => "Marianas",
            "MS" => "Mississippi",
            "MT" => "Montana",
            "NC" => "North Carolina",
            "ND" => "North Dakota",
            "NE" => "Nebraska",
            "NH" => "New Hampshire",
            "NJ" => "New Jersey",
            "NM" => "New Mexico",
            "NV" => "Nevada",
            "NY" => "New York",
            "OH" => "Ohio",
            "OK" => "Oklahoma",
            "OR" => "Oregon",
            "PA" => "Pennsylvania",
            "PR" => "Puerto Rico",
            "PW" => "Palau",
            "RI" => "Rhode Island",
            "SC" => "South Carolina",
            "SD" => "South Dakota",
            "TN" => "Tennessee",
            "TX" => "Texas",
            "UT" => "Utah",
            "VA" => "Virginia",
            "VI" => "Virgin Islands",
            "VT" => "Vermont",
            "WA" => "Washington",
            "WI" => "Wisconsin",
            "WV" => "West Virginia",
            "WY" => "Wyoming",
            "AA" => "Military Americas",
            "AE" => "Military Europe/ME/Canada",
            "AP" => "Military Pacific"),
        "CA" => array("AB" => "Alberta",
            "MB" => "Manitoba",
            "AB" => "Alberta",
            "BC" => "British Columbia",
            "MB" => "Manitoba",
            "NB" => "New Brunswick",
            "NL" => "Newfoundland and Labrador",
            "NS" => "Nova Scotia",
            "NT" => "Northwest Territories",
            "NU" => "Nunavut",
            "ON" => "Ontario",
            "PE" => "Prince Edward Island",
            "QC" => "Quebec",
            "SK" => "Saskatchewan",
            "YT" => "Yukon Territory"),
        "AU" => array("AAT" => "Australian Antarctic Territory",
            "ACT" => "Australian Capital Territory",
            "NT" => "Northern Territory",
            "NSW" => "New South Wales",
            "QLD" => "Queensland",
            "SA" => "South Australia",
            "TAS" => "Tasmania",
            "VIC" => "Victoria",
            "WA" => "Western Australia"),
        "BR" => array("AC" => "Acre",
            "AL" => "Alagoas",
            "AM" => "Amazonas",
            "AP" => "Amapa",
            "BA" => "Baia",
            "CE" => "Ceara",
            "DF" => "Distrito Federal",
            "ES" => "Espirito Santo",
            "FN" => "Fernando de Noronha",
            "GO" => "Goias",
            "MA" => "Maranhao",
            "MG" => "Minas Gerais",
            "MS" => "Mato Grosso do Sul",
            "MT" => "Mato Grosso",
            "PA" => "Para",
            "PB" => "Paraiba",
            "PE" => "Pernambuco",
            "PI" => "Piaui",
            "PR" => "Parana",
            "RJ" => "Rio de Janeiro",
            "RN" => "Rio Grande do Norte",
            "RO" => "Rondonia",
            "RR" => "Roraima",
            "RS" => "Rio Grande do Sul",
            "SC" => "Santa Catarina",
            "SE" => "Sergipe",
            "SP" => "Sao Paulo",
            "TO" => "Tocatins"),
        "NL" => array("DR" => "Drente",
            "FL" => "Flevoland",
            "FR" => "Friesland",
            "GL" => "Gelderland",
            "GR" => "Groningen",
            "LB" => "Limburg",
            "NB" => "Noord Brabant",
            "NH" => "Noord Holland",
            "OV" => "Overijssel",
            "UT" => "Utrecht",
            "ZH" => "Zuid Holland",
            "ZL" => "Zeeland"),
        "UK" => array("AVON" => "Avon",
            "BEDS" => "Bedfordshire",
            "BERKS" => "Berkshire",
            "BUCKS" => "Buckinghamshire",
            "CAMBS" => "Cambridgeshire",
            "CHESH" => "Cheshire",
            "CLEVE" => "Cleveland",
            "CORN" => "Cornwall",
            "CUMB" => "Cumbria",
            "DERBY" => "Derbyshire",
            "DEVON" => "Devon",
            "DORSET" => "Dorset",
            "DURHAM" => "Durham",
            "ESSEX" => "Essex",
            "GLOUS" => "Gloucestershire",
            "GLONDON" => "Greater London",
            "GMANCH" => "Greater Manchester",
            "HANTS" => "Hampshire",
            "HERWOR" => "Hereford & Worcestershire",
            "HERTS" => "Hertfordshire",
            "HUMBER" => "Humberside",
            "IOM" => "Isle of Man",
            "IOW" => "Isle of Wight",
            "KENT" => "Kent",
            "LANCS" => "Lancashire",
            "LEICS" => "Leicestershire",
            "LINCS" => "Lincolnshire",
            "MERSEY" => "Merseyside",
            "NORF" => "Norfolk",
            "NHANTS" => "Northamptonshire",
            "NTHUMB" => "Northumberland",
            "NOTTS" => "Nottinghamshire",
            "OXON" => "Oxfordshire",
            "SHROPS" => "Shropshire",
            "SOM" => "Somerset",
            "STAFFS" => "Staffordshire",
            "SUFF" => "Suffolk",
            "SURREY" => "Surrey",
            "SUSS" => "Sussex",
            "WARKS" => "Warwickshire",
            "WMID" => "West Midlands",
            "WILTS" => "Wiltshire",
            "YORK" => "Yorkshire"),
        "EI" => array("CO ANTRIM" => "County Antrim",
            "CO ARMAGH" => "County Armagh",
            "CO DOWN" => "County Down",
            "CO FERMANAGH" => "County Fermanagh",
            "CO DERRY" => "County Londonderry",
            "CO TYRONE" => "County Tyrone",
            "CO CAVAN" => "County Cavan",
            "CO DONEGAL" => "County Donegal",
            "CO MONAGHAN" => "County Monaghan",
            "CO DUBLIN" => "County Dublin",
            "CO CARLOW" => "County Carlow",
            "CO KILDARE" => "County Kildare",
            "CO KILKENNY" => "County Kilkenny",
            "CO LAOIS" => "County Laois",
            "CO LONGFORD" => "County Longford",
            "CO LOUTH" => "County Louth",
            "CO MEATH" => "County Meath",
            "CO OFFALY" => "County Offaly",
            "CO WESTMEATH" => "County Westmeath",
            "CO WEXFORD" => "County Wexford",
            "CO WICKLOW" => "County Wicklow",
            "CO GALWAY" => "County Galway",
            "CO MAYO" => "County Mayo",
            "CO LEITRIM" => "County Leitrim",
            "CO ROSCOMMON" => "County Roscommon",
            "CO SLIGO" => "County Sligo",
            "CO CLARE" => "County Clare",
            "CO CORK" => "County Cork",
            "CO KERRY" => "County Kerry",
            "CO LIMERICK" => "County Limerick",
            "CO TIPPERARY" => "County Tipperary",
            "CO WATERFORD" => "County Waterford"));


    if ($flag == 1) {
        //Find country
        return $country[$code];
    } elseif ($flag == 2) { //Find State
        foreach ($state[$countryCode] as $key => $value) {
            if ($key == $code) {
                return $state[$countryCode][$key];
            } else {
                continue;
            }
        }
    }
}

// function to downmoad imgae from url and saving to folder
function DownloadImageFromUrl($imagepath) {
    $imagepath = str_replace(" ", "%20", $imagepath);
    $ch = curl_init($imagepath);

    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_BINARYTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $raw = curl_exec($ch);
    curl_close($ch);

    return $raw;
}

function makeTimeZoneList($class = 'textarea', $txtTimeZone = '') {

    $timezones = array(
        'Pacific/Midway' => "(GMT-11:00) Midway Island",
        'US/Samoa' => "(GMT-11:00) Samoa",
        'US/Hawaii' => "(GMT-10:00) Hawaii",
        'US/Alaska' => "(GMT-09:00) Alaska",
        'US/Pacific' => "(GMT-08:00) Pacific Time (US &amp; Canada)",
        'America/Tijuana' => "(GMT-08:00) Tijuana",
        'US/Arizona' => "(GMT-07:00) Arizona",
        'US/Mountain' => "(GMT-07:00) Mountain Time (US &amp; Canada)",
        'America/Chihuahua' => "(GMT-07:00) Chihuahua",
        'America/Mazatlan' => "(GMT-07:00) Mazatlan",
        'America/Mexico_City' => "(GMT-06:00) Mexico City",
        'America/Monterrey' => "(GMT-06:00) Monterrey",
        'Canada/Saskatchewan' => "(GMT-06:00) Saskatchewan",
        'US/Central' => "(GMT-06:00) Central Time (US &amp; Canada)",
        'US/Eastern' => "(GMT-05:00) Eastern Time (US &amp; Canada)",
        'US/East-Indiana' => "(GMT-05:00) Indiana (East)",
        'America/Bogota' => "(GMT-05:00) Bogota",
        'America/Lima' => "(GMT-05:00) Lima",
        'America/Caracas' => "(GMT-04:30) Caracas",
        'Canada/Atlantic' => "(GMT-04:00) Atlantic Time (Canada)",
        'America/La_Paz' => "(GMT-04:00) La Paz",
        'America/Santiago' => "(GMT-04:00) Santiago",
        'Canada/Newfoundland' => "(GMT-03:30) Newfoundland",
        'America/Buenos_Aires' => "(GMT-03:00) Buenos Aires",
        'Greenland' => "(GMT-03:00) Greenland",
        'Atlantic/Stanley' => "(GMT-02:00) Stanley",
        'Atlantic/Azores' => "(GMT-01:00) Azores",
        'Atlantic/Cape_Verde' => "(GMT-01:00) Cape Verde Is.",
        'Africa/Casablanca' => "(GMT) Casablanca",
        'Europe/Dublin' => "(GMT) Dublin",
        'Europe/Lisbon' => "(GMT) Lisbon",
        'Europe/London' => "(GMT) London",
        'Africa/Monrovia' => "(GMT) Monrovia",
        'Europe/Amsterdam' => "(GMT+01:00) Amsterdam",
        'Europe/Belgrade' => "(GMT+01:00) Belgrade",
        'Europe/Berlin' => "(GMT+01:00) Berlin",
        'Europe/Bratislava' => "(GMT+01:00) Bratislava",
        'Europe/Brussels' => "(GMT+01:00) Brussels",
        'Europe/Budapest' => "(GMT+01:00) Budapest",
        'Europe/Copenhagen' => "(GMT+01:00) Copenhagen",
        'Europe/Ljubljana' => "(GMT+01:00) Ljubljana",
        'Europe/Madrid' => "(GMT+01:00) Madrid",
        'Europe/Paris' => "(GMT+01:00) Paris",
        'Europe/Prague' => "(GMT+01:00) Prague",
        'Europe/Rome' => "(GMT+01:00) Rome",
        'Europe/Sarajevo' => "(GMT+01:00) Sarajevo",
        'Europe/Skopje' => "(GMT+01:00) Skopje",
        'Europe/Stockholm' => "(GMT+01:00) Stockholm",
        'Europe/Vienna' => "(GMT+01:00) Vienna",
        'Europe/Warsaw' => "(GMT+01:00) Warsaw",
        'Europe/Zagreb' => "(GMT+01:00) Zagreb",
        'Europe/Athens' => "(GMT+02:00) Athens",
        'Europe/Bucharest' => "(GMT+02:00) Bucharest",
        'Africa/Cairo' => "(GMT+02:00) Cairo",
        'Africa/Harare' => "(GMT+02:00) Harare",
        'Europe/Helsinki' => "(GMT+02:00) Helsinki",
        'Europe/Istanbul' => "(GMT+02:00) Istanbul",
        'Asia/Jerusalem' => "(GMT+02:00) Jerusalem",
        'Europe/Kiev' => "(GMT+02:00) Kyiv",
        'Europe/Minsk' => "(GMT+02:00) Minsk",
        'Europe/Riga' => "(GMT+02:00) Riga",
        'Europe/Sofia' => "(GMT+02:00) Sofia",
        'Europe/Tallinn' => "(GMT+02:00) Tallinn",
        'Europe/Vilnius' => "(GMT+02:00) Vilnius",
        'Asia/Baghdad' => "(GMT+03:00) Baghdad",
        'Asia/Kuwait' => "(GMT+03:00) Kuwait",
        'Africa/Nairobi' => "(GMT+03:00) Nairobi",
        'Asia/Riyadh' => "(GMT+03:00) Riyadh",
        'Europe/Moscow' => "(GMT+03:00) Moscow",
        'Asia/Tehran' => "(GMT+03:30) Tehran",
        'Asia/Baku' => "(GMT+04:00) Baku",
        'Europe/Volgograd' => "(GMT+04:00) Volgograd",
        'Asia/Muscat' => "(GMT+04:00) Muscat",
        'Asia/Tbilisi' => "(GMT+04:00) Tbilisi",
        'Asia/Yerevan' => "(GMT+04:00) Yerevan",
        'Asia/Kabul' => "(GMT+04:30) Kabul",
        'Asia/Karachi' => "(GMT+05:00) Karachi",
        'Asia/Tashkent' => "(GMT+05:00) Tashkent",
        'Asia/Kolkata' => "(GMT+05:30) India/Kolkata",
        'Asia/Kathmandu' => "(GMT+05:45) Kathmandu",
        'Asia/Yekaterinburg' => "(GMT+06:00) Ekaterinburg",
        'Asia/Almaty' => "(GMT+06:00) Almaty",
        'Asia/Dhaka' => "(GMT+06:00) Dhaka",
        'Asia/Novosibirsk' => "(GMT+07:00) Novosibirsk",
        'Asia/Bangkok' => "(GMT+07:00) Bangkok",
        'Asia/Jakarta' => "(GMT+07:00) Jakarta",
        'Asia/Krasnoyarsk' => "(GMT+08:00) Krasnoyarsk",
        'Asia/Chongqing' => "(GMT+08:00) Chongqing",
        'Asia/Hong_Kong' => "(GMT+08:00) Hong Kong",
        'Asia/Kuala_Lumpur' => "(GMT+08:00) Kuala Lumpur",
        'Australia/Perth' => "(GMT+08:00) Perth",
        'Asia/Singapore' => "(GMT+08:00) Singapore",
        'Asia/Taipei' => "(GMT+08:00) Taipei",
        'Asia/Ulaanbaatar' => "(GMT+08:00) Ulaan Bataar",
        'Asia/Urumqi' => "(GMT+08:00) Urumqi",
        'Asia/Irkutsk' => "(GMT+09:00) Irkutsk",
        'Asia/Seoul' => "(GMT+09:00) Seoul",
        'Asia/Tokyo' => "(GMT+09:00) Tokyo",
        'Australia/Adelaide' => "(GMT+09:30) Adelaide",
        'Australia/Darwin' => "(GMT+09:30) Darwin",
        'Asia/Yakutsk' => "(GMT+10:00) Yakutsk",
        'Australia/Brisbane' => "(GMT+10:00) Brisbane",
        'Australia/Canberra' => "(GMT+10:00) Canberra",
        'Pacific/Guam' => "(GMT+10:00) Guam",
        'Australia/Hobart' => "(GMT+10:00) Hobart",
        'Australia/Melbourne' => "(GMT+10:00) Melbourne",
        'Pacific/Port_Moresby' => "(GMT+10:00) Port Moresby",
        'Australia/Sydney' => "(GMT+10:00) Sydney",
        'Asia/Vladivostok' => "(GMT+11:00) Vladivostok",
        'Asia/Magadan' => "(GMT+12:00) Magadan",
        'Pacific/Auckland' => "(GMT+12:00) Auckland",
        'Pacific/Fiji' => "(GMT+12:00) Fiji",
    );
    asort($timezones);

    $str = '<select name="txtTimeZone" class="' . $class . '" id=txtTimeZone">';
    foreach ($timezones as $key => $value) {
        if ($txtTimeZone == $key)
            $selected = 'selected="selected"';
        else
            $selected = "";
        $str .='<option value="' . $key . '"' . $selected . '>' . $value . '</option>';
    }

    $str .='</select>';

    return $str;
}

function timepicker($selectedTime) {
    $time = array("12:00am" => "12:00am",
        "12:30am" => "12:30am",
        "01:00am" => "1:00am",
        "01:30am" => "1:30am",
        "02:00am" => "2:00am",
        "02:30am" => "2:30am",
        "03:00am" => "3:00am",
        "03:30am" => "3:30am",
        "04:00am" => "4:00am",
        "04:30am" => "4:30am",
        "05:00am" => "5:00am",
        "05:30am" => "5:30am",
        "06:00am" => "6:00am",
        "06:30am" => "6:30am",
        "07:00am" => "7:00am",
        "07:30am" => "7:30am",
        "08:00am" => "8:00am",
        "08:30am" => "8:30am",
        "09:00am" => "9:00am",
        "09:30am" => "9:30am",
        "10:00am" => "10:00am",
        "10:30am" => "10:30am",
        "11:00am" => "11:00am",
        "11:30am" => "11:30am",
        "12:00pm" => "12:00pm",
        "12:30pm" => "12:30pm",
        "01:00pm" => "1:00pm",
        "01:30pm" => "1:30pm",
        "02:00pm" => "2:00pm",
        "02:30pm" => "2:30pm",
        "03:00pm" => "3:00pm",
        "03:30pm" => "3:30pm",
        "04:00pm" => "4:00pm",
        "04:30pm" => "4:30pm",
        "05:00pm" => "5:00pm",
        "05:30pm" => "5:30pm",
        "06:00pm" => "6:00pm",
        "06:00pm" => "6:30pm",
        "07:00pm" => "7:00pm",
        "07:30pm" => "7:30pm",
        "08:00pm" => "8:00pm",
        "08:30pm" => "8:30pm",
        "09:00pm" => "9:00pm",
        "09:30pm" => "9:30pm",
        "10:00pm" => "10:00pm",
        "10:30pm" => "10:30pm",
        "11:00pm" => "11:00pm",
        "11:30pm" => "11:30pm"
    );

    $str = '<select name="publishtime" style="width: 77px;" id="publishtime">';
    $selectedTime = str_replace(" ", "", $selectedTime);
    foreach ($time as $key => $value) {
        if ($selectedTime == $key)
            $selected = 'selected="selected"';
        else
            $selected = "";
        $str .='<option value="' . $key . '"' . $selected . '>' . $value . '</option>';
    }

    $str .='</select>';

    return $str;
}

function checkFileExists($url) {
    // Initialize the handle
    $ch = curl_init();
    // Set the URL to be executed
    curl_setopt($ch, CURLOPT_URL, $url);
    // Set the curl option to include the header in the output
    curl_setopt($ch, CURLOPT_HEADER, true);
    // Set the curl option NOT to output the body content
    curl_setopt($ch, CURLOPT_NOBODY, true);
    /* Set to TRUE to return the transfer
      as a string of the return value of curl_exec(),
      instead of outputting it out directly */
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // Execute it
    $data = curl_exec($ch);
    // Finally close the handle
    curl_close($ch);
    /* In this case, weâ€™re interested in
      only the HTTP status code returned, therefore we
      use preg_match to extract it, so in the second element
      of the returned array is the status code */
    preg_match("/HTTP\/1\.[1|0]\s(\d{3})/", $data, $matches);

    if ($matches[1] != '200') {
        return false;
    }else
        return true;
}

$settings = $pdo->select($tableprefix . 'settings')->results();
define("AMAZON_BUCKET_NAME", $settings[0]["amazon_bucket_name"]);
define("AMAZON_ACCESS_KEY", $settings[0]["amazon_access_key"]);
define("AMAZON_SECRET_KEY", $settings[0]["amazon_secret_key"]);
define("ENABLE_AMAZON_S3_IMAGES", $settings[0]["enable_amazon_cdn_images"]);
define("AMAZON_S3_DOMAIN_URL", 'http://' . AMAZON_BUCKET_NAME . '.s3.amazonaws.com/');

function moveImageToCDN($imagePath, $imageName) {

    if (ENABLE_AMAZON_S3_IMAGES == "Y") {
        $s3 = new S3(AMAZON_ACCESS_KEY, AMAZON_SECRET_KEY);
        $size = getimagesize($imagePath);
        $content_type = $size['mime'];
        $requestHeaders = array(
            'Cache-Control' => 'max-age=2692000',
            'Expires' => gmdate('D, d M Y H:i:s T', strtotime('+1 year')),
            'Content-Type' => $content_type,
        );

        if ($s3->putObjectFile($imagePath, AMAZON_BUCKET_NAME, $imageName, S3::ACL_PUBLIC_READ, '', $requestHeaders)) {

            return true;
        } else {
            return false;
        }
    }
    return false;
}

function deleteCDNImagesMore($mageName) {
    if (ENABLE_AMAZON_S3_IMAGES == "Y") {
        $s3 = new S3(AMAZON_ACCESS_KEY, AMAZON_SECRET_KEY);
        //echo $imageSmall.'sdfs'.$final_image_small;exit;
        $imageName1 = 'products/' . $mageName;
        $imageName2 = 'products/big_' . $mageName;
        $imageName3 = 'products/thumb/' . $mageName;
        $imageName4 = 'products/orig/' . $mageName;
        $s3->deleteObject(AMAZON_BUCKET_NAME, $imageName1);
        $s3->deleteObject(AMAZON_BUCKET_NAME, $imageName2);
        $s3->deleteObject(AMAZON_BUCKET_NAME, $imageName3);
        $s3->deleteObject(AMAZON_BUCKET_NAME, $imageName4);
    }
    return false;
}

function deleteCDNImagesall($smallmageName, $bigImageName) {
    if (ENABLE_AMAZON_S3_IMAGES == "Y") {
        $s3 = new S3(AMAZON_ACCESS_KEY, AMAZON_SECRET_KEY);
        $smallmageName = 'products/' . $smallmageName;
        $bigImageName = 'products/' . $bigImageName;
        $s3->deleteObject(AMAZON_BUCKET_NAME, $smallmageName);
        $s3->deleteObject(AMAZON_BUCKET_NAME, $bigImageName);
    }
    return false;
}

function deleteCDNImage($imageName) {
    if (ENABLE_AMAZON_S3_IMAGES == "Y") {
        $s3 = new S3(AMAZON_ACCESS_KEY, AMAZON_SECRET_KEY);
        $s3->deleteObject(AMAZON_BUCKET_NAME, $imageName);
    }
}

function checkArtistExpired($artistId) {
    global $tableprefix,$pdo;
    $sql = "SELECT plan_expired FROM " . $tableprefix . "artists  WHERE artist_id='" . $artistId . "'  AND deleted = 'N' AND vapproved='Y' ";
    $res = $pdo->pdoQuery($sql)->results();
    $row = ($res[0]);
    if ($row['plan_expired'] == 'Y') {
        return true;
    } else {
        return false;
    }
}

function getSellerWiseShipping($artistid, $orderid) {
    global $tableprefix,$pdo;
    $shipCost = 0;
    $sql = "SELECT sum(nshipping_cost) as shipping_cost FROM " . $tableprefix . "shipping_details  
                    WHERE seller_id='" . $artistid . "'  AND norder_id='" . $orderid . "' ";
    //$res = mysql_query($sql);
    //$row = mysql_fetch_array($res);
    $res = $pdo->pdoQuery($sql)->results();
    $row = ($res[0]);

    $shipCost = $row['shipping_cost'];
    return $shipCost;
}

function getorderBuyerName($buyerid) {
    global $tableprefix,$pdo;
    $buyer_rs = $pdo->select($tableprefix."users",array("concat(first_name,' ',last_name) AS name"),array("user_id"=>$buyerid))->results();
    $buyer_rw = $buyer_rs[0];
    $buyer_name = ucwords($buyer_rw["name"]);
    return $buyer_name;
}

function sendOrderStatusChangeMailToSeller($order_id, $artistid, $buyerid, $orderstatus) {
    global $tableprefix,$pdo;


    $adminCurrency = GetAdminCurrency();

    $currency_attributes[0] = $adminCurrency['currency_symbol'];

    $senderName = getorderBuyerName($buyerid);

    $senderCaption = 'The ' . $senderName . ' ' . ORDER_STATUS_CHANGE_CAPTION . '<span style="font-size:12px; color:#991818; font-weight:bold; "> ' . $orderstatus . '  </span> ' . ORDER_STATUS_CHANGE_TEXT . '  ' . SITE_NAME . '  (' . SITE_URL . ')';



    $sellerInfo = getorderSellerInfo($artistid);

    $sellerName = ucwords($sellerInfo['name']);


    $currentDate = date('m-d-Y :H:i:s');

    $queryOrder = "SELECT o.* ,concat(o.billing_first_name,' ',billing_last_name) AS buyername , o.billing_email as buyeremail , DATE_FORMAT(o.order_date,'%m-%d-%Y') as order_dateF from " . $tableprefix . "orders o  where order_id=:order_id";
    $orderQ =$pdo->pdoQuery($queryOrder,array("order_id"=>$order_id))->results();
    $orderObj = $orderQ[0];
    $mailContent = '
    <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
        <tr>
        <td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
        <table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';
    $mailContent .= '<tr>
        <td colspan="2">' . MAIL_SALUTATION . '  ' . $sellerName . ' , </td>
        </tr><tr>
        <td colspan="2"> ' . $senderCaption . ' </td>
        </tr>
        <tr>
        <tr>';

    $mailContent .= '<tr>
        <td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
        <td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj->order_id . '</td>
        </tr>
        <tr>
        <td >Status Change  Date</td>
        <td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currentDate . '</td>
        </tr>
        <tr>
        </table>
        </td>
        </tr>
        <tr>
        <td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
        ' . PRODUCT_DETAILS_INFO . '    
        </td>
        </tr>
        <tr>
        <td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
        <table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
        <tr style="background-color:#D2D2D2; font-weight:bold; ">
        <td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
        <td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
        <td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_NAME . '</td>
        <td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
        <td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
        <td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
        </tr>';
    $orderDetailQ = $pdo->select($tableprefix."order_details",'',array("order_id"=>$order_id,"artist_id"=>$artistid))->results();
    $itemTotal = 0;
    $inc = 1;
    foreach ($orderDetailQ as $orderDetailObj) {
        $optionStr = "";


        $productname = stripslashes($orderDetailObj['product_name']);
        $couponCodeDiscount = $orderObj['couponCodeDiscount'];
        $productname.= $optionStr;



        $converted_price = $orderDetailObj['product_price'];

        $rate = number_format(($converted_price), 2, ".", "");


        $qty = $orderDetailObj['product_quantity'];
        $price = $qty * $rate;
        $discountstr = "";
        if ($orderDetailObj['product_discount'] != "0") {
            $price = $price - ($price * $orderDetailObj['product_discount']) / 100;

            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj['product_discount'] . "%)";
        }



        //$productPrice = number_format(($currency_attributes[1] * $productPrice),2,".","");


        $itemTotal+=$price;

        $mailContent.='<tr>
        <td align="left" valign="top">' . $inc . ' </td>            
        <td align="left" valign="top">' . $orderDetailObj['product_code'] . '</td>              
        <td align="left" valign="top">' . $productname . '</td>                    
        <td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($rate, 2, ".", "") . '</td>                    
        <td align="left" valign="top">&nbsp;' . $orderDetailObj['product_quantity'] . '</td>
        <td align="left" valign="top">' . $currency_attributes[0] . '&nbsp;' . number_format($price, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
             </tr>';


        $inc++;
    }
    $mailContent.='<tr><td colspan="6">&nbsp;</td></tr></table>
        </td>
        </tr>';


    $mailContent .='</table>';

    $mailcontent_admin = readEmailTemplate('order_statuschange_buyer_to_seller');

    //echo $orderObj->billing_first_name.$orderObj->billing_last_name;
    //echo "<br>";



    $mailcontent_admin = str_replace('[order_details]', $mailContent, $mailcontent_admin);


    $mail_send_details_admin = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">
         
         <table width="95%" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_admin . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

// echo $mail_send_details_admin;

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_ORDER_STATUS_SUBJECT_1 . " " . SITE_NAME . " " . MAIL_ORDER_STATUS_SUBJECT_2;

    //$orderObj->billing_email='asha.s@armiasystems.com';
    //echo $mail_send_details_admin;

    $selleremail = $sellerInfo['email'];


    //$buyeremail     =   'armiatester@gmail.com';

    $mailsent = mail($selleremail, $ordersubject, $mail_send_details_admin, $headers);

    /* echo $mail_send_details_admin;
      exit; */
}

function generateDwollaPaymentScript($amount, $redirecturl) {

    global $tableprefix, $pdo;

    $result = $pdo->select($tableprefix . "settings", '', '')->results();
    if (!empty($result)) {
        $row = $result[0];
    }
    $dwolla_test_mode = $row["dwolla_payment_test_mode"];
    $dwollakey = trim($row["dwolla_key"]);
    $dwollasecretkey = trim($row["dwolla_secretkey"]);
    $dwolla_js = SITE_URL . "/js/dwolla_live.js";
    $dwolla_test = "false";
    if ($dwolla_test_mode == 'Y') {
        $dwolla_test = "true";
        $dwolla_js = SITE_URL . "/js/dwolla_test.js";
    }
    $redirectUrl = SITE_URL . '/' . $redirecturl;

    $payemtgenerate = '<script src="' . $dwolla_js . '" class="dwolla_button" type="text/javascript"
                          data-key="' . $dwollakey . '"
                          data-redirect="' . $redirectUrl . '"
                          data-label="Dwolla Payment"
                          data-name="Product"
                          data-description="Description"
                          data-amount="' . $amount . '"
                          data-guest-checkout="true"
                          data-type="simple">
                        </script>';
    return $payemtgenerate;
}

function generateDwollaPaymentSellerScript($amount, $redirecturl) {

    global $tableprefix, $pdo;

    $result = $pdo->select($tableprefix . "settings", '', '')->results();
    if (!empty($result)) {
        $row = $result[0];
    }
    $dwolla_test_mode = $row["dwolla_payment_test_mode"];
    $dwollakey = trim($row["dwolla_key"]);
    $dwollasecretkey = trim($row["dwolla_secretkey"]);
    $dwolla_js = SITE_URL . "/js/dwolla_live.js";
    $dwolla_test = "false";
    if ($dwolla_test_mode == 'Y') {
        $dwolla_test = "true";
        $dwolla_js = SITE_URL . "/js/dwolla_test.js";
    }
    $redirectUrl = SITE_URL . '/' . $redirecturl;

    $payemtgenerate = '<script src="' . $dwolla_js . '" class="dwolla_button" type="text/javascript"
                          data-key="' . $dwollakey . '"
                          data-redirect="' . $redirectUrl . '"
                          data-label="Dwolla Payment"
                          data-name="Product"
                          data-description="Description"
                          data-amount="' . $amount . '"
                          data-guest-checkout="true"
                          data-type="simple">
                        </script><a class="d-btn d-btn-simple" data-key="' . $dwollakey . '" data-redirect="' . $redirectUrl . '" data-label="Dwolla Payment" data-name="Product" data-description="Description" data-amount="' . $amount . '" data-guest-checkout="true" data-type="simple"><span class="d-btn-text">Dwolla Payment</span><span class="d-btn-icon"></span></a>';
    return $payemtgenerate;
}

function sendAffliateReferralRegisterMail($detailsArray) {
    global $tableprefix, $pdo;

    $mailcontent = readEmailTemplate('referral_registration');
    $mailcontent = str_replace('[fisrt_name]', $detailsArray['user_first'], $mailcontent);
    $mailcontent = str_replace('[last_name]', $detailsArray['user_last'], $mailcontent);
    $mailcontent = str_replace('[affiliate_name]', $detailsArray['affliate_name'], $mailcontent);

    $to = $detailsArray['affliate_email'];


    $subject = MAIL_REFERRAL_USER_REGISTRATION_TITLE;

    $from = "From: " . SITE_EMAIL . "\n";
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_EMAIL . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";
    $mailcontent = nl2br($mailcontent);

    $mail_send_details = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title>' . SITE_NAME . ' - ' . MAIL_REFERRAL_USER_REGISTRATION_TITLE . '</title>
</head>
<body>

<table width="103%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">
         
         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

    //echo $subject.'mail Details<br />'.$mail_send_details.'Subject <br />'.$to;exit;
    //$mail_send_details = "<html><head><link href='".SITE_URL."/style/template1-admin.css' rel='stylesheet' type='text/css'></head><body><center><div align='left' id='layout'><div align='left' class='header'><div align='left' class='logo'><img src=".$logofolder."/".$logoimage." width='125' height='39'/></div></div><div>".$mailcontent."</div></div><div align='left' class='clear_float'><img src=".$imagefolder."/clear.gif width=1 height=1/></div></div></div></center></body></html>";

    $mailsent = mail($to, $subject, $mail_send_details, $headers);
}

function sendReferralPurchaseMailtoAffliate($affliate_id) {

    global $tableprefix, $pdo;

    $result_aff = $pdo->select($tableprefix . "affiliates", array("first_name", "last_name", "email"), array("affiliate_id" => $affliate_id))->results();
    if (!empty($result_aff)) {
        $row = $result_aff[0];
        $affliate_name = $row['first_name'] . ' ' . $row['last_name'];
        $mailcontent = readEmailTemplate('referral_user_purchase');
        $mailcontent = str_replace('[affliate_name]', $affliate_name, $mailcontent);
        $to = $row['email'];


        $subject = MAIL_REFERRAL_USER_PURCHASED_TITLE;

        $from = "From: " . SITE_EMAIL . "\n";
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
        $headers .= "From: " . SITE_EMAIL . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Return-Path: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Organization: " . SITE_NAME . "\r\n";
        $mailcontent = nl2br($mailcontent);

        $mail_send_details = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title>' . SITE_NAME . ' - ' . MAIL_REFERRAL_USER_PURCHASED_TITLE . '</title>
</head>
<body>

<table width="103%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">
         
         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';


        $mailsent = mail($to, $subject, $mail_send_details, $headers);
    }
}

function formatChar($string) {
    return html_entity_decode(mb_convert_encoding(stripslashes($string), "HTML-ENTITIES", 'UTF-8'));
}


// Get all Category List

function get_cat_selectlist($current_cat_id, $count) {

    global $tableprefix, $pdo;
    static $option_results;
// if there is no current category id set, start off at the top level (zero)
    if (!isset($current_cat_id)) {
        $current_cat_id = 0;
    }
// increment the counter by 1
    $count = $count + 1;

// query the database for the sub-categories of whatever the parent category is
    $sql = "SELECT category_id,category_name from " . $tableprefix . "categories where parent_id = :current_cat_id AND gift_certificate_flag!='Y' ";
    $sql .= " order by category_name asc ";

    $get_options = $pdo->pdoQuery($sql, array("current_cat_id" => $current_cat_id))->results();
    $num_options = count($get_options);

// our category is apparently valid, so go ahead €¦
    if ($num_options > 0) {
        foreach ($get_options as $get_option) {
            $cat_id = $get_option['category_id'];
            $cat_name = $get_option['category_name'];
            // if its not a top-level category, indent it to
//show that its a child category

            if ($current_cat_id != 0) {
                $indent_flag = '--';
                for ($x = 2; $x <= $count; $x++) {
                    $indent_flag .= ' >';
                }
            }
            $cat_name = $indent_flag . $cat_name;
            $option_results[$cat_id] = $cat_name;
// now call the function again, to recurse through the child categories
            get_cat_selectlist($cat_id, $count);
        }
    }
    return $option_results;
}

function getSelectBoxList($selecteditem = '') {

    $get_options = get_cat_selectlist(0, 0);
    if (count($get_options) > 0) {

        $categories = $selecteditem;
        foreach ($get_options as $key => $value) {

            if (checkSubcategoryExists($key)) {
                $disabledFlag = 'disabled=disabled';
            } else {
                $disabledFlag = '';
            }
            $options .="<option value=\"$key\" " . $disabledFlag . " ";

            // show the selected items as selected in the listbox
            if ($categories == "$key") {
                $options .=" selected=\"selected\"  ";
            }
            $options .=">$value</option>\n";
        }
    }
    echo $options;
}

function checkSubcategoryExists($categoryid) {
    global $tableprefix, $pdo;
    $subCategoryCount = false;
    $sql_route = "SELECT category_id from " . $tableprefix . "categories cat  where cat.route REGEXP :exp ";
    $exp = $categoryid . ",|,^" . $categoryid . "|," . $categoryid . ",|," . $categoryid . "$|^" . $categoryid . "$'  AND cat.category_id!='" . $categoryid ;
    $rs_route = $pdo->pdoQuery($sql_route, array("exp" => $exp))->results();
    $current_catlist_catalog = array();
    if (count($rs_route) > 0) {
        foreach ($rs_route as $List_catlog) {
            $current_catlist_catalog[] = $List_catlog['category_id'];
        }
    }

    if (!empty($current_catlist_catalog)) {
        $subCategoryCount = true;
    }

    return $subCategoryCount;
}

// Send Order Staus change mail to admin

function sendOrderCancellationMailToSeller($order_id, $artistid, $orderstatus, $cancelFlag = false) {
    global $tableprefix, $pdo;


    $adminCurrency = GetAdminCurrency();

    $sellerDetails = getSellerDetails($artistid);

    $currency_attributes[0] = $adminCurrency['currency_symbol'];

    $senderName = SITE_NAME;

    if ($cancelFlag) {
        $Date_Text = ORDER_CANCELLATION_DATE;
        $sellerCaption = 'The ' . $senderName . ' has   <span style="font-size:12px; color:#991818; font-weight:bold; "> ' . $orderstatus . '  </span>     ' . ORDER_STATUS_CHANGE_CAPTION_SELLER . ' ' . SITE_NAME . '  (' . SITE_URL . ') ';
    } else {
        $Date_Text = ORDER_STATUS_CHANGE_DATE;
        $sellerCaption = 'The ' . $senderName . ' ' . ORDER_STATUS_CHANGE_CAPTION . '  <span style="font-size:12px; color:#991818; font-weight:bold; "> ' . $orderstatus . '  </span>     ' . ORDER_STATUS_CHANGE_ORDER_TEXT . ' ' . SITE_NAME . '  (' . SITE_URL . ') ';
    }


    $currentDate = date('m-d-Y :H:i:s');

    $queryOrder = "SELECT o.* ,concat(o.billing_first_name,' ',billing_last_name) AS buyername , o.billing_email as buyeremail , DATE_FORMAT(o.order_date,'%m-%d-%Y') as order_dateF from " . $tableprefix . "orders o  where order_id= :order_id";
    $orderQ = $pdo->pdoQuery($queryOrder, array("order_id" => $order_id))->result();
    $orderObj = (object)($orderQ);
    $mailContent = '
	<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">';
    $mailContent .= '<tr>
		<td colspan="2">' . MAIL_SALUTATION . '  ' . $sellerDetails['first_name'] . " " . $sellerDetails['last_name'] . ', </td>
		</tr><tr>
		<td colspan="2"> ' . $sellerCaption . ' </td>
		</tr>
		<tr>
		<tr>';

    $mailContent .= '<tr>
		<td>' . MAIL_ORDER_TEXT_ORDER_ID . '</td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $orderObj->order_id . '</td>
		</tr>
		<tr>
		<td >' . $Date_Text . ' </td>
		<td  style="font-size:13px; color:#991818; font-weight:bold; ">' . $currentDate . '</td>
		</tr>
		<tr>
		</table>
		</td>
		</tr>
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . PRODUCT_DETAILS_INFO . ' 	
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr style="background-color:#D2D2D2; font-weight:bold; ">
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_SL_NO . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_CODE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRODUCT_NAME . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_RATE . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_QUANTITY . '</td>
		<td align="left" valign="top">' . MAIL_ORDER_TEXT_PRICE . '</td>
		</tr>';

    $queryOrderDetail = "SELECT od.* FROM " . $tableprefix . "order_details od 
                                                WHERE od.order_id = :order_id AND od.artist_id= :artistid";

    $orderDetailQ = $pdo->pdoQuery($queryOrderDetail, array("order_id" => $order_id, "artistid" => $artistid))->results();
    $itemTotal = 0;
    $inc = 1;
    foreach ($orderDetailQ as $orderDetailObj) {$orderDetailObj = (object)$orderDetailObj;
        $optionStr = "";


        $productname = stripslashes($orderDetailObj->product_name);
        $couponCodeDiscount = $orderObj->couponCodeDiscount;
        $productname.= $optionStr;



        $converted_price = $orderDetailObj->product_price;

        $rate = number_format(($converted_price), 2, ".", "");


        $qty = $orderDetailObj->product_quantity;
        $price = $qty * $rate;
        $discountstr = "";
        if ($orderDetailObj->product_discount != "0") {
            $price = $price - ($price * $orderDetailObj->product_discount) / 100;

            $discountstr = "<br>" . strtolower(MAIL_ORDER_TEXT_DISCOUNT) . "(" . $orderDetailObj->product_discount . "%)";
        }



        //$productPrice = number_format(($currency_attributes[1] * $productPrice),2,".","");


        $itemTotal+=$price;

        $mailContent.='<tr>
		<td align="left" valign="top">' . $inc . ' </td>            
		<td align="left" valign="top">' . $orderDetailObj->product_code . '</td>              
		<td align="left" valign="top">' . $productname . '</td>                    
		<td align="left" valign="top">' . formatChar($currency_attributes[0]) . '&nbsp;' . number_format($rate, 2, ".", "") . '</td>                    
		<td align="left" valign="top">&nbsp;' . $orderDetailObj->product_quantity . '</td>
		<td align="left" valign="top">' . formatChar($currency_attributes[0]) . '&nbsp;' . number_format($price, 2, ".", "") . '&nbsp;&nbsp;' . $discountstr . '</td>
	         </tr>';


        $inc++;
    }
    $mailContent.='<tr><td colspan="6">&nbsp;</td></tr></table>
		</td>
		</tr>';


    $mailContent .='</table>';

    $mailcontent_admin = readEmailTemplate('order_statuschange_buyer_seller');

    //echo $orderObj->billing_first_name.$orderObj->billing_last_name;
    //echo "<br>";



    $mailcontent_admin = str_replace('[order_details]', $mailContent, $mailcontent_admin);


    $mail_send_details_admin = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>

<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">
         
         <table width="95%" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="70" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent_admin . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

    //echo $mail_send_details_admin;

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
    $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
    $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
    $headers .= "Organization: " . SITE_NAME . "\r\n";

    $ordersubject = MAIL_ORDER_STATUS_SUBJECT_1 . " " . SITE_NAME . " " . MAIL_ORDER_STATUS_SUBJECT_2;

    $selleremail = $sellerDetails['email'];

    //$buyeremail     =   'armiatester@gmail.com';

    $mailsent = mail($selleremail, $ordersubject, $mail_send_details_admin, $headers);

// 	 echo $mailContent;
// 		exit;
}

function getSellerDetails($sellerid) {
    global $tableprefix, $pdo;
    $seller_sql = "select * from " . $tableprefix . "artists where artist_id=$sellerid";
    $seller_rw = $pdo->pdoQuery($seller_sql)->result();
    return $seller_rw;
}

function getInQueryString($grinds, $prefix = '') {
    if (!$prefix)
        $prefix = "q";
    if (!empty($grinds)) {
        $array = explode(",", $grinds);
        $qstring = '';
        $arr = array();
        foreach ($array as $key => $val) {
            if ($qstring)
                $qstring .= ",:" . $prefix . $key;
            else
                $qstring .= ":" . $prefix . $key;
            $arr[$prefix . $key] = $val;
        }
    }
    return array($arr, $qstring);
}

function getResultObj($table,$field=array(),$where=array()) {
    global $tableprefix,$pdo;
    $getRs = $pdo->select($tableprefix.$table,$field,$where)->results();

    foreach($getRs as $row)
    {
            $getRsObj[] = (object)$row;
    }

    return $getRsObj;
}

/**
 * Pretty prints PHP debug data to js console
 *
 * @param $debugContent
 * @return void
 */

function clog($debugContent){
    echo "<script>
			console.log(" . json_encode($debugContent) . ");
		</script>";
}
?>