<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors:Santhosh Thomas Alexander<santhosh.thomas@armiasystems.com>  |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include('../includes/class.upload.php');
include_once('../includes/S3.php');
//including resize library
include_once('../includes/resize.php');
include_once('../api/pemfile/iphonepush.php');
include_once('../classes/cls_utils.php');
include_once('../classes/cls_store.php');
include_once('../classes/cls_products.php');

$maximagesizestringinPHP = ini_get("upload_max_filesize");

$maximagesizeinPHP = $maximagesizestringinPHP * (1024 * 1024);

$cdn_enabled = "N";
if(ENABLE_AMAZON_S3_IMAGES=="Y"){
    $cdn_enabled  = "Y";
}

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}
if (isset($_SESSION["sess_artistid"]) and $_SESSION["sess_artistid"] != "") {
    $artistid = $_SESSION["sess_artistid"];
} else {
    header("Location:login.php");
    exit;
}
if(checkArtistExpired($artistid)){
    header("Location:seller_plan_upgrade.php?sellerid=".$artistid);
    exit;
}


//Get Seller Information
$sellerCartObj      =    Store::get_seller_account_info($artistid);
//echopre($sellerCartObj);
if($sellerCartObj->status==SUCCESS)
        {
             $sellerCartObjVal      =   $sellerCartObj->data;
             $seller_vacation_mode  =   $sellerCartObjVal->is_vacation_mode;
        }

if (isset($_GET["catid"]) and $_GET["catid"] != "") {
    $catid = $_GET["catid"];
} else if (isset($_POST["catid"]) and $_POST["catid"] != "") {
    $catid = $_POST["catid"];
}

if ($_GET["begin"] == "") {
    $begin = 0;
    $num = 1;
    $numBegin = 1;
} else {
    $begin = $_GET["begin"];
    $num = $_GET["num"];
    $numBegin = $_GET["numBegin"];
    ;
}

$shipping_display_block = "";

$sql = "SELECT * FROM " . $tableprefix . "settings ";
//$result = mysql_query($sql);
$result = $pdo->pdoQuery($sql)->results();

if (count($result) > 0) {
    $row = $result['0'];
    $chkcanship = $row["enable_canadapost"];
    $aproveproducts = $row['approve_products'];
    $adminemail = $row['site_email'];
    if ($aproveproducts == "1") { // check producta are approved automatically
        $txtapproveProducts = "Y";
    } // end if
    if ($aproveproducts == "2") { // check producta are approved by Admin
        $txtapproveProducts = "N";
    } // end if
}

(isset($_POST['txtDigitalProduct'])) ? $txtDigitalProduct = $_POST['txtDigitalProduct'] : $txtDigitalProduct = 'N';

if ($txtDigitalProduct == "Y") {
    $digitalBlock = "";
    $chkDigitalProduct = "checked";
    $canshipblock = "none";
    $shipping_display_block = "none";
} else {
    $digitalBlock = "none";
    $chkDigitalProduct = "";
    $canshipblock = "";
    $shipping_display_block = "";
}

if (isset($_GET["txtSearch"]) and $_GET["txtSearch"] != "") {
    $txtSearch = $_GET["txtSearch"];
    $cmbSearchType = $_GET["cmbSearchType"];
} else if (isset($_POST["txtSearch"]) and $_POST["txtSearch"] != "") {
    $txtSearch = $_POST["txtSearch"];
    $cmbSearchType = $_POST["cmbSearchType"];
}

$txtProductName = $_POST["txtProductName"];
$txtProductCode = $_POST["txtProductCode"];
$txtDescription = $_POST["txtDescription"];
$txtPrice = $_POST["txtPrice"];
$ddlArtist = $_POST["ddlArtist"];
$productlist = $_POST["chkproducts"];
$txtSearchTags = $_POST["txtProductTags"];

(isset($_POST['chkAllowFreeShipping'])) ? $chkAllowFreeShipping = $_POST['chkAllowFreeShipping'] : $chkAllowFreeShipping = 'N';
(isset($_POST['chkAllowSubscription'])) ? $chkAllowSubscription = $_POST['chkAllowSubscription'] : $chkAllowSubscription = 'N';

$rdSubscriptionMode   = $_POST["rdSubscriptionMode"];
$txtStock = $_POST["txtStock"];
$txtReorderLevel = $_POST["txtReorderLevel"];

$txtDiscount = $_POST["txtDiscount"];
$txtDiscountDesc = $_POST["txtDiscountDesc"];
$txtShippingWeight = $_POST['txtShippingWeight'];

$txtlength = $_POST['txtlength'];
$txtheight = $_POST['txtheight'];
$txtwidth = $_POST['txtwidth'];

(isset($_POST['txtDigitalProduct'])) ? $txtDigitalProduct = $_POST['txtDigitalProduct'] : $txtDigitalProduct = 'N';
(isset($_POST['txtFeaturedRequest'])) ? $txtFeaturedRequest = $_POST['txtFeaturedRequest'] : $txtFeaturedRequest = 'N';

/* ----------Selecting the Artist Currency------------- */

$select_seller_currency = "SELECT vseller_currency FROM " . $tableprefix . "artists
						   WHERE artist_id = :artist_id";
$qryoptArr1['artist_id'] = $_SESSION["sess_artistid"];
$result_seller_currency = $pdo->pdoQuery($select_seller_currency,$qryoptArr1)->results();
//$result_seller_currency = mysql_query($select_seller_currency) or die(mysql_error());

/* ----------Selecting the Artist Currency------------- */


if (isset($_POST["btnAddProduct"])) {

    $message = "";
    $checkleafcategory = " select *  FROM  " . $tableprefix . "categories where parent_id= :parent_id";
    $qryoptArr2['parent_id'] = $catid;
    $checkleafcategory = $pdo->pdoQuery($checkleafcategory,$qryoptArr2)->results();

    if (count($checkleafcategory) > 0) {
        $message .= MSG_SEL_SUBCATEG."<br>";
    }
    if (!isNotNull($txtProductName)) {
        $message .= VAL_MSG_PROD_NAME."<br>";
    } else {
        $qry = "SELECT  product_name FROM  " . $tableprefix . "products WHERE product_name= :product_name and product_artist_id= :product_artist_id and product_category = :product_category";
        $qryoptArr3['product_name'] = addslashes($txtProductName);
        $qryoptArr3['product_artist_id'] = $artistid;
        $qryoptArr3['product_category'] = addslashes($catid);
        $qry = $pdo->pdoQuery($qry,$qryoptArr3)->results();
        if (count($qry) > 0) {
            $message .= VAL_MSG_PNAME_EXIST."<br>";
        }
    }
    if (!isNotNull($txtProductCode)) {
        // $message .= "* Product Code cannot be empty! <br>";
    } else {
        $qry = "SELECT  product_code FROM  " . $tableprefix . "products WHERE product_code= :product_code and product_artist_id= :product_artist_id and product_category = :product_category";

        $qryoptArr4['product_code'] = addslashes($txtProductCode);
        $qryoptArr4['product_artist_id'] = $artistid;
        $qryoptArr4['product_category'] = addslashes($catid);
        $qry = $pdo->pdoQuery($qry,$qryoptArr4)->results();

        if (count($qry) > 0) {
            $message .= VAL_MSG_PCODE_EXIST."<br>";
        }
    }

    if ($txtDescription == "") {
        $message .= VAL_MSG_PROD_DESC."<br>";
    }
    $txtSearchTags = $_POST["txtProductTags"];
    $chkAllowFreeShipping = $_POST["chkAllowFreeShipping"];
    $chkAllowSubscription = $_POST["chkAllowSubscription"];
    $rdSubscriptionMode   = $_POST["rdSubscriptionMode"];
    $rdPublishStatus      = $_POST["rdPublishStatus"];

    if($rdPublishStatus=="N"){
        //published time in 24_hour_format
        $selected_time = ($_POST['publishtime']!='')?$_POST['publishtime']:'12:00am';
        $publishDate   = date("Y-m-d H:i:s", strtotime($_POST['publishdate'].$selected_time));
        //Get seller time zone
        //$arrSellerTimezone = DbHelper::getResult('artists', "seller_time_zone", "artist_id =".$_SESSION['sess_artistid']);
        $arrSellerTimezone = getResultObj('artists', array('seller_time_zone'),array('artist_id'=>$_SESSION['sess_artistid']));
        $sellertimezone = $arrSellerTimezone[0]->seller_time_zone;
    }else{
        $publishDate   = "0000-00-00 00:00:00";
        $sellertimezone = "";
    }
     //default published if settings disabled

    if(getSettingsValue('enable_product_scheduled_publishing')=='N')
    {
        $rdPublishStatus    = 'Y';
    }
    $priceposted = $txtPrice;
    $txtPrice = doubleval($txtPrice);
    if (!isNotNull($txtPrice) && !isNotNull($priceposted)) {
        $message .= VAL_MSG_PROD_PRICE_EMP."<br>";
    } else if ($txtPrice <= 0 || !is_numeric($txtPrice)) {
        $message .= VAL_MSG_PROD_PRICE_POS."<br>";
    }

    if ($txtDigitalProduct == "Y") {
        $chkAllowFreeShipping = "Y";
        if (!isNotNull($_FILES['txtProductZip']['name'])) {
            $message .= VAL_MSG_DPROD_EMPTY."<br>";
        }

        $uploadfile = ReplaceArrayImage($_FILES['txtProductZip']['name']);
       // $types = array('gif','jpg','png','zip', 'pdf', 'rar', 'psd', 'opf', 'azw', 'lit', 'pdb', 'pkg', 'mp3', 'mpeg', 'mp4', 'avi', 'mpg', 'wma');


        //preg_match('/\.([a-zA-Z]+?)$/', $uploadfile, $matches);
        $matches = explode(".", $uploadfile);

        $matches_cnt = count($matches);

        if (!in_array(strtolower($matches[$matches_cnt - 1]), $digital_product_types)) { // check file format is valid or not
            $message .= VAL_MSG_INVAL_FILE."<br>";
        } // end format check
    }


    if (!in_array('1', $_POST['default_option'])) {
        $message .= VAL_MSG_SEL_DEF."<br>";
    }

    $options_count = count($_POST['additional_price']);



    for ($i = 0; $i < $options_count; $i++) {
        $default_option = $_POST['default_option'][$i];
        $additional_price = $_POST['additional_price'][$i];
        $product_stock = $_POST['product_stock'][$i];
        $reorder_level = $_POST['reorder_level'][$i];
        $product_shipping_weight = $_POST['product_shipping_weight'][$i];

        $discount = $_POST['discount'][$i];
        $discount_description = $_POST['discount_description'][$i];
        $product_length = $_POST['product_length'][$i];
        $product_width = $_POST['product_width'][$i];
        $product_height = $_POST['product_height'][$i];

        $prodimagedir = "../products/";

        $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
        $picsmallorgname = $_FILES['image_small']['name'][$i];
        $picsmalltempname = $_FILES['image_small']['tmp_name'][$i];
        $picsmalltype = $_FILES['image_small']['type'][$i];

        $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
        $picbigtype = $_FILES['image_big']['type'][$i];
        $picbigorgname = $_FILES['image_big']['name'][$i];
        $picbigtempname = $_FILES['image_big']['tmp_name'][$i];

        if ($picbigname != "") {
            $final_image_big = "productlarge_" . $i . time() . $picbigname;
        } else {
            $final_image_big = "";
        }

        if ($picsmallname != "") {
            $final_image_small = "productsmall_" . $i . time() . $picsmallname;
        } else {
            $final_image_small = "";
        }

        $picsmalldest = $prodimagedir . $final_image_small;
        $picbigdest = $prodimagedir . $final_image_big;

        $picsmallname = $final_image_small;
        $picbigname = $final_image_big;

        if($picbigname=='')
            {
                    $message .= VAL_MSG_PIC_BIG_NULL." " . $i . "<br>";
                    $error = true;
           }

        if (!is_readable($prodimagedir) || !is_writable($prodimagedir)) {
            $error = true;
            $message .= VAL_MSG_CHANGE_PERM."<br>";
        }

        if ($picsmalltype != "") {
            if (!isValidWebImageType($picsmalltype, $picsmallorgname, $picsmalltempname)) {
                $message .= VAL_MSG_INVAL_PIC_SMALL." " . $i . "<br>";
                $error = true;
            } else {
                if (file_exists($picsmalldest)) {
                    $message .= VAL_MSG_PIC_EXIST_SMALL." " . $i . "<br>";
                    $error = true;
                }
            }
        }



        if ($picbigtype != "") {
            if (!isValidWebImageType($picbigtype, $picbigorgname, $picbigtempname)) {
                $message .= VAL_MSG_INVAL_PIC_BIG." " . $i . "<br>";
                $error = true;
            } else {
                if (file_exists($picbigdest)) {
                    $message .= VAL_MSG_PIC_EXIST_BIG." " . $i . "<br>";
                    $error = true;
                }
            }
        }


        $product_stock = doubleval($product_stock);
        if ($product_stock == "") {
            $message .= VAL_MSG_PSTOCK_EMPTY." " . ($i + 1) . " ! <br>";
        }
        if ($product_stock < 0 || !is_numeric($product_stock)) {
            if ($product_stock < 0) {
                $message .= VAL_MSG_PSTOCK_POS." " . ($i + 1) . " ! <br>";
            }
        }

        if($discount != ""){
            if($discount >= 100){
                $message .= VAL_MSG_DISCOUNT_VALIDATION." ".($i+1)."! <br>";
            }
        }

        if ($additional_price != "") {
            if ($additional_price < 0 || !is_numeric($additional_price)) {
                $message .= VAL_MSG_ADDPRIC_POS." " . ($i + 1) . "! <br>";
            }
        }


        if ($chkcanship == "Y" && $txtDigitalProduct != "Y") {
            if ($product_length == "") {
                $message .= VAL_MSG_PLEN_EMP." " . ($i + 1) . " !<br>";
            }
            if ($product_width == "") {
                $message .= VAL_MSG_PWID_EMP." " . ($i + 1) . " !<br>";
            }
            if ($product_height == "") {
                $message .= VAL_MSG_PHEI_EMP." " . ($i + 1) . " !<br>";
            }
            if ($txtDigitalProduct != "Y") {
                if ($product_shipping_weight == "") {
                    $message .= VAL_MSG_PSHIP_EMP." " . ($i + 1) . "!<br>";
                }
            }
        }

        if ($product_length != '') {
            if (!is_numeric($product_length)) {
                $message .= VAL_MSG_PLEN." " . ($i + 1) . "! <br>";
            }
        }

        if ($product_width != '') {
            if (!is_numeric($product_width)) {
                $message .= VAL_MSG_PWID." " . ($i + 1) . "! <br>";
            }
        }

        if ($product_height != '') {
            if (!is_numeric($product_height)) {
                $message .= VAL_MSG_PHEI." " . ($i + 1) . "! <br>";
            }
        }

        if ($txtDigitalProduct != "Y") {
            if (!is_numeric($product_shipping_weight) || $product_shipping_weight == 0) {
                $message .= VAL_MSG_PSHIP_WEI." " . ($i + 1) . "! <br>";
            }
        }
        $product_shipping_weight = doubleval($product_shipping_weight);

        if ($product_shipping_weight < 0) {
            $message .= VAL_MSG_PSHIP_WEI_POS." " . ($i + 1) . "! <br>";
        }
        $reorder_level = doubleval($reorder_level);
        if ($reorder_level != "") {
            if ($reorder_level < 0 || !is_numeric($reorder_level)) {
                $message .= VAL_MSG_PREC_LEV_POS." " . ($i + 1) . "! <br>";
            } else if ($reorder_level > $product_stock) {
                $message .= VAL_MSG_PREC_LEV_LESS." " . ($i + 1) . "! <br>";
            }
        }
    }
    /*
     * More Images Validation
    */

    if (isset($_FILES['productMoreImage']['name']) && !empty($_FILES['productMoreImage']['name'])) {
        foreach ($_FILES['productMoreImage']['name'] as $key => $moreImage) {
            if ($moreImage != '') {
                $type = $_FILES['productMoreImage']['type'][$key];
                if (!isValidWebImageType($type)) {
                    $message .= VAL_MSG_INVAL_MIMG." " . ($key + 1) . "<br>";
                }
            }
        }
    }

    $moreFiles = array();
    foreach ($_FILES['productMoreImage'] as $k => $l) {
        foreach ($l as $j => $v) {
            if (!array_key_exists($j, $moreFiles)) {
                $moreFiles[$j] = array();
            }
            $moreFiles[$j][$k] = $v;
        }
    }






    /*
     * More Images Validation - End
    */
    if ($message != "") { // error
        $message = "<br>".VAL_MSG_PLS_CORRECT."<br>" . $message;
    } else { // no error so insert user details
        $digital_product_upload = 0;

        $digitalproductname = preg_replace("/^[^a-z0-9.-]?(.*?)[^a-z0-9]?$/i", "$1", $_FILES['txtProductZip']['name']);
        $digitalproductname = trim(str_replace(' ', '_', $digitalproductname));

        $assignedname = randomDigitalProduct() . "_" . $digitalproductname;

        if (@file_exists("../digital_product/" . $assignedname)) {
            $message .= VAL_MSG_DIG_PROD_EXIST." " . "<br>";
        }

        if ($txtDigitalProduct == "Y" && $_FILES['txtProductZip']['size'] > $maximagesizeinPHP) {
            $message.= VAL_MSG_FILE_EXCEED." $maximagesizestringinPHP. <br>";
        }


        if ($txtDigitalProduct == "Y" && $message == '') {

            if (move_uploaded_file($_FILES['txtProductZip']['tmp_name'], "../digital_product/" . $assignedname)) {
                $digital_product_upload = 1;
                chmod("../digital_product/$assignedname", 0777);
            } else {
                $message .= VAL_MSG_DPROD_TRY." " . "<br>";
            }
        }

        $productListingFee = getSettingsValue('product_listing_fee');
        //Generate Alias name for product
        $aliasname = Utils::generateAlias($tableprefix . "products", $txtProductName);

        $payment_status = 'COMPLETED';
        if ($productListingFee > 0) {
            $payment_status = 'PENDING';
        }
        $txtProductapproval = getSettingsValue('approve_products');


        if ($txtProductapproval == 1) {

            $vapproved = 'Y';
        } else {
            $vapproved = 'N';
        }

        if ($message == '') {

            /*$sql = "INSERT INTO " . $tableprefix . "products (
			product_name ,
			product_code ,
			product_description,
			product_price,
			vdigital_product,
			product_category,
			product_artist_id,
			date_added,
			vapproved,
                        payment_status,
                        seller_viewed_status,
                        alias,
                        publish_status,
                        publish_scheduled_date,
                        product_tags,
                        allow_subscription,
                        subscription_mode,
                        publish_timezone,
                        allow_free_shipping,
                        seller_vacation_mode
			) VALUES (
			'" . addslashes($txtProductName) . "',
			'" . addslashes($txtProductCode) . "',
			'" . addslashes($txtDescription) . "',
			'" . addslashes($txtPrice) . "',
			'" . $txtDigitalProduct . "',
			'" . addslashes($catid) . "',
			'" . addslashes($artistid) . "',
			now(),
                        '" . $vapproved . "',
                        '" . addslashes($payment_status) . "',
                        1,
                        '".addslashes($aliasname)."',
                        '".$rdPublishStatus."',
                        '".$publishDate."',
                        '".addslashes($txtSearchTags)."',
                        '".$chkAllowSubscription ."',
                        '".$rdSubscriptionMode."',
                        '".addslashes($sellertimezone)."',
                        '".$chkAllowFreeShipping."',
                        '".$seller_vacation_mode."'
			)";*/

            $fieldsProducts = array('product_name'=>addslashes($txtProductName),
                                 'product_code'=>addslashes($txtProductCode),
			         'product_description'=>addslashes($txtDescription),
			         'product_price'=>addslashes($txtPrice),
			         'vdigital_product'=>$txtDigitalProduct,
			         'product_category'=>addslashes($catid),
			         'product_artist_id'=>addslashes($artistid),
			         'date_added'=>date('Y-m-d H:i:s'),
			         'vapproved'=>$vapproved,
                                 'payment_status'=>addslashes($payment_status),
                                 'seller_viewed_status'=>1,
                                 'alias'=>addslashes($aliasname),
                                 'publish_status'=>$rdPublishStatus,
                                 'publish_scheduled_date'=>$publishDate,
                                 'product_tags'=>addslashes($txtSearchTags),
                                 'allow_subscription'=>$chkAllowSubscription,
                                 'subscription_mode'=>$rdSubscriptionMode,
                                 'publish_timezone'=>addslashes($sellertimezone),
                                 'allow_free_shipping'=>$chkAllowFreeShipping,
                                 'seller_vacation_mode'=>$seller_vacation_mode
                           );

            $product_insert_id = $pdo->insert($tableprefix."products",$fieldsProducts)->lastInsertId();

            //mysql_query($sql) or die(mysql_error());
            /* ------------Digital Product Block Starts----------------- */
            //$product_insert_id = mysql_insert_id();

            //Product Options Insertion here Santhosh thomas Alexander
            for ($i = 0; $i < $options_count; $i++) {

                $default_option = $_POST['default_option'][$i];
                $additional_price = $_POST['additional_price'][$i];
                $product_stock = $_POST['product_stock'][$i];
                $reorder_level = $_POST['reorder_level'][$i];
                $product_shipping_weight = $_POST['product_shipping_weight'][$i];
                $discount = $_POST['discount'][$i];
                $discount_description = $_POST['discount_description'][$i];
                $product_length = $_POST['product_length'][$i];
                $product_width = $_POST['product_width'][$i];
                $product_height = $_POST['product_height'][$i];
                $default_option_actual = "NO";
                if ($default_option == 1) {
                    $default_option_actual = "YES";
                }
                $small_image_name_after_upload = "";
                $big_image_name_after_upload = "";

                 $dir_dest = "../products";

  //*********************************************Multicart3.0 Image Upload Modifications*************************//

                $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);

                $final_image_big = "";
                if ($picbigname != "") {
                    $picBigArr = explode('.', $picbigname);
                    $cntCountParamsBig = count($picBigArr);
                    $name_big_with_out_extension = str_replace('.' . $picBigArr[$cntCountParamsBig - 1], '', $picbigname);
                    $final_image_big = "productbig_" . $productid . "_" . $i . "_" . time() . $name_big_with_out_extension;
                }
                $picbigname = $final_image_big;

                $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);

                $final_image_small = "";

                if ($picsmallname != "") {
                    $picSmallArr = explode('.', $picsmallname);
                    $cntCountParamsSmall = count($picSmallArr);
                    $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
                    $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
                }else{
                        // Save and resize Big Image to small size if small image not uploaded
                        if($_FILES['image_big']['name'][$i]!='')
                            {
                                $picsmallname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
                                $picSmallArr = explode('.', $picsmallname);
                                $cntCountParamsSmall = count($picSmallArr);
                                $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
                                $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
                            }
                }
                $picsmallname = $final_image_small;

                 /**************Saving the original image*****************/
                /*if($_FILES['image_small']['name'][$i] !=''){

                    $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
                    $imagecontent = file_get_contents($_FILES['image_small']['tmp_name'][$i]);

                    $file_extn              = end(explode(".",$picsmallname));
                    //Save Small image
                    $original_image_name_after_upload      = "productoriginal_".$product_insert_id."_".time().$picsmallname;
                    $imageOriginal                        = "../products/".$original_image_name_after_upload;
                    $imageOriginalSave                     = fopen($imageOriginal,'x');
                    fwrite($imageOriginalSave, $imagecontent);
                    fclose($imageOriginalSave);

                }*/

                /**************Saving the original image*****************/
                // Save small Images


                if ($_FILES['image_small']['name'][$i] != "") {
                    //Commenting the previous code
                    $files = array();
                    foreach ($_FILES['image_small'] as $k => $l) {
                        foreach ($l as $j => $v) {
                            if (!array_key_exists($j, $files))
                                $files[$j] = array();
                            $files[$j][$k] = $v;
                        }
                    }

                    for ($x = 0; $x < count($files); $x++) {
                        if ($x == $i) {
                            $handle = new Upload($files[$x]);
                            if ($handle->uploaded) {
                                // Modification resize
                                //   $info = getimagesize($inputFileName);
                                $handle->image_resize = true;
                                $handle->image_ratio = true;
                                $handle->image_x = 387;
                                $handle->image_y = 260;
                                $handle->file_new_name_body = $picsmallname;
                                $handle->Process($dir_dest);
                                $small_image_name_after_upload = $handle->file_dst_name;
                                $imagepath             = "../products/".$small_image_name_after_upload;
                                moveImageToCDN($imagepath,'products/'.$small_image_name_after_upload);
                            }
                        }
                    }
               }
      /********** Image resizing maintaining aspect ratio begin***********/
                    /*$imagecontent           = file_get_contents($_FILES['image_small']['tmp_name'][$i]);
                    $file_extn              = end(explode(".",$picsmallname));

                    // $small_image_name_after_upload      = "productsmall_".$product_insert_id."_".time().$picsmallname;

                    $small_image_name_after_upload = str_replace('productoriginal_','productsmall_',$original_image_name_after_upload);
                    $imageSmall             = "../products/".$small_image_name_after_upload;
                    $imageSmallSave         = fopen($imageSmall,'x');
                    fwrite($imageSmallSave, $imagecontent);
                    fclose($imageSmallSave);
                    reSizeImageFromFolder($imageSmall,191,183);*/
                    /********** Image resizing maintaining aspect ratio end***********/

                //small image upload end


                //*****************big Image Upload**************************

                if ($picbigname != "") {
                    //Commenting the previous code
                    $files = array();
                    foreach ($_FILES['image_big'] as $k => $l) {
                        foreach ($l as $j => $v) {
                            if (!array_key_exists($j, $files))
                                $files[$j] = array();
                            $files[$j][$k] = $v;
                        }
                    }
                    for ($x = 0; $x < count($files); $x++) {
                        if ($x == $i) {
                            $handle = new Upload($files[$x]);
                            if ($handle->uploaded) {

                                $handle->image_resize = true;
                                $handle->image_ratio = true;
                                $handle->image_x = 489;
                                $handle->image_y = 328;
                                $handle->file_new_name_body = $picbigname;
                                $handle->Process($dir_dest);
                                $big_image_name_after_upload = $handle->file_dst_name;
                                $imagepath             = "../products/".$big_image_name_after_upload;
                                moveImageToCDN($imagepath,'products/'.$big_image_name_after_upload);


                                $main_thumb_file_name           =    "thumb_".$picbigname;
                                $handle->file_new_name_body     =    $main_thumb_file_name;
                                $handle->image_resize           = true;
                                $handle->image_x                = 82;
                                $handle->image_y                = 79;
                                $handle->image_ratio            = true;
                                $handle->Process($dir_dest);
                                $main_thumb_file_name_after_upload = $handle->file_dst_name;
                                $imagethubpath             = "../products/".$main_thumb_file_name_after_upload;
                                moveImageToCDN($imagethubpath,'products/'.$main_thumb_file_name_after_upload);
                            }

                            /* // Create thumbnail Image and save to thumb folder
                            $big_file_name                  =    "thumb_".$picbigname;
                            $handle->file_new_name_body     =    $big_file_name;
                            $handle->image_resize           = true;
                            $handle->image_x                = 82;
                            $handle->image_y                = 79;
                            $handle->image_ratio            = true;
                            $handle->process($dir_dest);
                            $image_thumb_path = '../products/'.$big_file_name;
                            moveImageToCDN($image_thumb_path,'products/'.$big_file_name);*/


                            // Resize  Small images in listing if small image  not uploaded
                               if($_FILES['image_small']['name'][$i]=='') {
                                            $small_file_name                =    $picsmallname;
                                            $handle->file_new_name_body     =    $small_file_name;
                                            $handle->image_resize           =    true;
                                            $handle->image_x                =    387;
                                            $handle->image_y                =    260;
                                            $handle->image_ratio            =    true;
                                            $handle->process($dir_dest);
                                            $small_image_name_after_upload  = $handle->file_dst_name;
                                            $imagepath             = "../products/".$small_image_name_after_upload;
                                            moveImageToCDN($imagepath,'products/'.$small_image_name_after_upload);
                               }


                        }
                    }


                }


      //*********************************Multicart3.0 Scalability Image Upload Modifications End************



                /*$sqlOptions = "INSERT INTO " . $tableprefix . "product_options (
			product_id,
			additional_price,
			product_stock,
			reorder_level,
			product_shipping_weight,
                        image_small,
                        image_big,
                        discount,
                        discount_description,
                        product_length,
                        product_width,
                        product_height,
                        default_option,
                        cdn_images_moved
			) VALUES (
			'" . addslashes($product_insert_id) . "',
			'" . addslashes($additional_price) . "',
			'" . addslashes($product_stock) . "',
			'" . addslashes($reorder_level) . "',
			'" . addslashes($product_shipping_weight) . "',
			'" . addslashes($small_image_name_after_upload) . "',
			'" . addslashes($big_image_name_after_upload) . "',
			'" . addslashes($discount) . "',
			'" . addslashes($discount_description) . "',
                        '" . addslashes($product_length) . "',
                        '" . addslashes($product_width) . "',
                        '" . addslashes($product_height) . "',
                        '" . addslashes($default_option_actual) . "',
                        '" . addslashes($cdn_enabled) . "'
                        )";
                mysql_query($sqlOptions) or die(mysql_error());*/

                $fieldsOptions = array('product_id'=>addslashes($product_insert_id),
                                      'additional_price'=>addslashes($additional_price),
                                      'product_stock'=>addslashes($product_stock),
                                      'reorder_level'=>addslashes($reorder_level),
                                      'product_shipping_weight'=>addslashes($product_shipping_weight),
                                      'image_small'=>addslashes($small_image_name_after_upload),
                                      'image_big'=>addslashes($big_image_name_after_upload),
                                      'discount'=>addslashes($discount),
                                      'discount_description'=>addslashes($discount_description),
                                      'product_length'=>addslashes($product_length),
                                      'product_width'=>addslashes($product_width),
                                      'product_height'=>addslashes($product_height),
                                      'default_option'=>addslashes($default_option_actual),
                                      'cdn_images_moved'=>addslashes($cdn_enabled)
                           );

            $product_option_id = $pdo->insert($tableprefix."product_options",$fieldsOptions)->lastInsertId();

                //$product_option_id = mysql_insert_id();
                $options_arr = getOptionsFromCategory($catid);
                $num_of_options = count($options_arr);
                if ($num_of_options != "") {
                    foreach ($options_arr AS $eachoption) {

                        $option_Id = $eachoption['option_id'];
                        $option_value = $_POST["option_" . $option_Id][$i];
                        if ($option_value != "") {

                            /*$query_option_insert = "INSERT INTO " . $tableprefix . "product_option_values
                                                (
                                                product_option_id,
                                                option_id,
                                                value
                                                )
                                                VALUES
                                                (
                                                '" . $product_option_id . "',
                                                '" . $option_Id . "',
                                                '" . $option_value . "'
                                                )";
                            mysql_query($query_option_insert);*/


                           $fieldsOptionsval = array('product_option_id'=>$product_option_id,
                                                'option_id'=>$option_Id,
                                                'value'=>$option_value
                           );

                           $pdo->insert($tableprefix."product_option_values",$fieldsOptionsval);

                        }
                    }
                }
            }


              //*************************************Multicart3.0 Scalability Modifications*******************************************

   // Save product default option values to product  table
if(getSettingsValue('enable_scalability_settings')=='Y')
        {
            $objDefaultOptionVo                                     =    new stdClass();
            $objOptionVo                                            =    Products::getProduct_Default_Option_Values($product_insert_id);

            $objDefaultOptionVo->default_image_small                =   $objOptionVo->image_small;

            $objDefaultOptionVo->default_additional_price           =   $objOptionVo->additional_price;
            $objDefaultOptionVo->default_shipping_weight            =   $objOptionVo->product_shipping_weight;
            $objDefaultOptionVo->default_discount                   =   $objOptionVo->discount;
            $objDefaultOptionVo->default_discount_description       =   $objOptionVo->discount_description;
            $objDefaultOptionVo->default_option_id                  =   $objOptionVo->product_option_id;
            $objDefaultOptionVo->product_id                         =   $product_insert_id;

            // Save default option values to product table
            $productinfoUpdate                                      =   Products::updateProduct_Default_Option_Value($objDefaultOptionVo);

        }
// echopre($objDefaultOptionVo);
            //exit;

 //*************************************Multicart3.0 Scalability Modifications End *******************************************



            if ($txtDigitalProduct == "Y" && $digital_product_upload == '1') {

                $expiry_days = $_POST['txtDownloadExpiry'];
                //$valid_date_upto = date("Y-m-d H:s:m",mktime(date("H"),date("i"),date("s"),date("m"),date("d")+$expiry_days,date("Y")));

                /*$insert_digital_product = "INSERT INTO " . $tableprefix . "digital_product(ndigital_productid,vdigital_product_name,ndownload_try
							  		  ,ndownload_expiry_days)VALUES(" . $product_insert_id . ","
                        . GetSQLValueString($assignedname, "text") . ",
									  " . $_POST['txtDownloadTry'] . ",
									  '" . $expiry_days . "')";

                mysql_query($insert_digital_product) or die(mysql_error());*/

                $digitalProductArr = array('ndigital_productid'=>$product_insert_id,
                                        'vdigital_product_name'=>$assignedname,
                                        'ndownload_try'=>$_POST['txtDownloadTry'],
                                        'ndownload_expiry_days'=>$expiry_days
                           );

                $pdo->insert($tableprefix."digital_product",$digitalProductArr);
            }

            /*
             * Product more images By Binu Chandran.E
            */
            $moreFiles = array();
            foreach ($_FILES['productMoreImage'] as $k => $l) {
                foreach ($l as $j => $v) {
                    if (!array_key_exists($j, $moreFiles)) {
                        $moreFiles[$j] = array();
                    }
                    $moreFiles[$j][$k] = $v;
                }
            }
            $dir_dest = "../products";
            for ($x = 0; $x < count($moreFiles); $x++) {
                $moreImageName = ReplaceArrayImage($moreFiles[$x]['name']);
                if ($moreImageName != "") {

                    /********** Image resizing maintaining aspect ratio begin***********/
                    /* $imagecontent = file_get_contents($_FILES['productMoreImage']['tmp_name'][$x]);
                     $file_extn              = end(explode(".",$moreImageName));

                    $moreImageNameAfterupload = "productmore_" . $x . time() . $moreImageName;
                    $imageMore             = "../products/".$moreImageNameAfterupload;
                    $imageMoreSave         = fopen($imageMore,'x');
                    fwrite($imageMoreSave, $imagecontent);
                    fclose($imageMoreSave);
                    reSizeImageFromFolder($imageMore,283,269);/*
                    /********** Image resizing maintaining aspect ratio begin***********/

                     $handle = new Upload($moreFiles[$x]);
                    if ($handle->uploaded) {

                        $moreImageName = "productmore_" . $x . time() . $moreImageName;
                        $moreImageName_Upload       =   substr($moreImageName, 0, strrpos($moreImageName, '.'));
                        $handle->image_resize = true;
                        $handle->image_x = 489;
                        $handle->image_y = 328;
                        $handle->image_ratio= true;
                        $handle->file_new_name_body = $moreImageName_Upload;
                        $handle->Process($dir_dest);
                        $moreImageNameAfterupload = $handle->file_dst_name;
                        $imagepath             = "../products/".$moreImageNameAfterupload;
                        moveImageToCDN($imagepath,'products/'.$moreImageNameAfterupload);

                        // Save More Image Thubnail to thumb folder

                            $more_thumb_file_name           =    "thumb_".$moreImageName_Upload;
                            $handle->file_new_name_body     =    $more_thumb_file_name;
                            $handle->image_resize           = true;
                            $handle->image_x                = 82;
                            $handle->image_y                = 79;
                            $handle->image_ratio            = true;
                            $handle->process($dir_dest);
                            $more_thumb_file_name_after_upload = $handle->file_dst_name;
                            $imagethubpath             = "../products/".$more_thumb_file_name_after_upload;
                            moveImageToCDN($imagethubpath,'products/'.$more_thumb_file_name_after_upload);

                        /*$insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                                                      SET nimage_productid = '" . mysql_real_escape_string($product_insert_id) . "',
                                                          vimage_name= '" . mysql_real_escape_string($moreImageNameAfterupload) . "',
                                                          vproduct_image_delete_status 	='N',
                                                           cdn_images_moved = '".mysql_real_escape_string($cdn_enabled)."'";
                        mysql_query($insertMImageQuery) or die(mysql_error());*/

                        $imageProductArr = array('nimage_productid'=> $product_insert_id,
                                        'vimage_name'=> $moreImageNameAfterupload,
                                        'vproduct_image_delete_status'=>'N',
                                        'cdn_images_moved'=> $cdn_enabled
                           );

                       $pdo->insert($tableprefix."product_view_images",$imageProductArr);
                    }

                }
            }
            // Send push notification
            //$devicesql = "Select device_id from " . $tableprefix . "artists where artist_id ='$artistid'"; //Get seller device ID
            //$result = mysql_query($devicesql);
            //$device_row = mysql_fetch_assoc($result);

            $devicesql = "Select device_id from " . $tableprefix . "artists where artist_id = :artist_id";
            $deviceArr['artist_id'] = $artistid;

            $device_row = $pdo->pdoQuery($devicesql,$deviceArr)->results();


            $msg = "New Product - '".$txtProductName."' added at ".SITE_NAME. ", please check.";
            send_push_nofication($msg,SITE_NAME,"armia",$device_row['device_id'],"Product");//Message,From,passphrase,device token,type-->product,order...
            //-------------------------//
            //=================================================Send Mail to Admin =============================================================
            if (!empty($product_insert_id)) { // check if product added to data base
                /*$select_seller_name = "SELECT p .*,po.*,(p.product_price+po.additional_price) AS product_price,po.discount,po.product_shipping_weight,po.product_stock, c.category_name, a.artist_name,a.first_name,a.last_name
                                                FROM " . $tableprefix . "products p
                                                INNER JOIN " . $tableprefix . "product_options po ON po.product_id = p.product_id AND po.default_option = 'YES'
                                                INNER JOIN " . $tableprefix . "artists a ON a.artist_id = p.product_artist_id
                                                INNER JOIN " . $tableprefix . "categories c ON c.category_id = p.product_category
                                                WHERE p.product_id =" . $product_insert_id . "
                                                AND p.product_artist_id =" . $artistid . "
                                                LIMIT 0 , 1";*/
                $select_seller_name = "SELECT p .*,po.*,(p.product_price+po.additional_price) AS product_price,po.discount,po.product_shipping_weight,po.product_stock, c.category_name, a.artist_name,a.first_name,a.last_name
                                                FROM " . $tableprefix . "products p
                                                INNER JOIN " . $tableprefix . "product_options po ON po.product_id = p.product_id AND po.default_option = 'YES'
                                                INNER JOIN " . $tableprefix . "artists a ON a.artist_id = p.product_artist_id
                                                INNER JOIN " . $tableprefix . "categories c ON c.category_id = p.product_category
                                                WHERE p.product_id = :product_id
                                                AND p.product_artist_id = :product_artist_id
                                                LIMIT 0 , 1";

                $sellNameArr['product_id'] = $product_insert_id;
                $sellNameArr['product_artist_id'] = $artistid;

                $result_seller_name = $pdo->pdoQuery($select_seller_name,$sellNameArr)->results();
                $numrows = count($result_seller_name);
                //$result_seller_name = mysql_query($select_seller_name) or die(mysql_error());
                //$numrows = mysql_num_rows($result_seller_name);
                if ($numrows > 0) { // check number of rows
                    //$rs = mysql_fetch_array($result_seller_name);
                    $rs = $result_seller_name['0'];
                    $seller_username = $rs['artist_name'];
                    $seller_name = stripslashes($rs['first_name']) . "&nbsp" . stripslashes($rs['last_name']);
                    $category_name = stripslashes($rs['category_name']);
                    $txtPrice = $rs['product_price'];
                    $txtStock = $rs['product_stock'];
                    $txtShippingWeight = $rs['product_shipping_weight'];
                    $txtDiscount = $rs['discount'];
                    if ($rs["image_small"] != "") {
                        $product_image = SITE_URL . "/products/" . $rs['image_small'];
                    }  // end if product image null check
                    else {
                        $product_image = SITE_URL . "/products/noimage.jpg";
                    } // end if
                } // end if

                $to = $adminemail;
                $date = date("F d,Y");
                $product_code = stripslashes($txtProductCode);
                $product_name = stripslashes($txtProductName);
                $product_price = $adminCurrency['currency_symbol'] . "&nbsp;&nbsp;" . number_format($txtPrice, 2, ".", "");
                $stock_available = $txtStock;
                $shipping_weight = $txtShippingWeight . " lbs";
                //===========================For showing product images====================================
                /* if($small_image_name_after_upload=="") { // check if thumnail image is not avilabe select images from
                  if(!empty($big_image_name_after_upload)) { // check if big image is uploaded or not

                  $product_image=SITE_URL."/products/$big_image_name_after_upload";
                  }else { // if images not in the table
                  $product_image=SITE_URL."/products/noimage.jpg";

                  }	 // end if

                  }else {
                  $product_image=SITE_URL."/products/$small_image_name_after_upload";
                  } */
                $imageurl = '<img src="' . $product_image . '" width="120" height="150" border="0" >';
                //==================================End display product image===============================
                $link = "<a href=" . SITE_URL . "/admin/editproduct.php?productid=$product_insert_id>".TXT_CLICK_HERE_TO_VIEW_THE_PRODUCT."</a>";
                /* ---------Multicart Seller Account Acivation Email Confirmation to seller------------ */
                $subject = MAIL_CATALOGUE_SUBJECT_NEW_PRODUCT_ADDED." - " . stripslashes(SITE_NAME);
                /* ---------Email Template Reading Fuction Call---------------------------------------- */
                $mailcontent = readEmailTemplate('new_product_approval', 'products');


                $mailcontent = str_replace('[seller_username]', $seller_username, $mailcontent);
                $mailcontent = str_replace('[seller_name]', $seller_name, $mailcontent);
                $mailcontent = str_replace('[date]', $date, $mailcontent);
                $mailcontent = str_replace('[product_name]', $product_name, $mailcontent);
                $mailcontent = str_replace('[product_code]', $txtProductCode, $mailcontent);
                $mailcontent = str_replace('[product_price]', $product_price, $mailcontent);
                $mailcontent = str_replace('[product_discount]', $txtDiscount, $mailcontent);
                $mailcontent = str_replace('[product_image]', $imageurl, $mailcontent);
                $mailcontent = str_replace('[shipping_weight]', $shipping_weight, $mailcontent);
                $mailcontent = str_replace('[link]', $link, $mailcontent);
                $mailcontent = str_replace('[stock_available]', $stock_available, $mailcontent);
                $mailcontent = str_replace('[category_name]', $category_name, $mailcontent);
                $headers = "MIME-Version: 1.0" . "\r\n";
                $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
                $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
                $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
                $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
                $headers .= "Organization: " . SITE_NAME . "\r\n";

                $mailcontent = nl2br($mailcontent);

                //$mail_send_details = "<html><head><link href='".SITE_URL."/style/template1-admin.css' rel='stylesheet' type='text/css'></head><body><center><div align='left' id='layout'><div align='left' class='header'><div align='left' class='logo'><img src=".$logofolder."/".$logoimage." width='125' height='39'/></div></div><div>".$mailcontent."</div></div><div align='left' class='clear_float'><img src=".$imagefolder."/clear.gif width=1 height=1/></div></div></div></center></body></html>";

                $mail_send_details = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >'.SITE_NAME.'</title>
  <link href="./themes/' . $active_template[4] . ' rel="stylesheet" type="text/css">
</head>
<body>

<table width="103%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA">
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td  bgcolor="#EAEAEA" > <img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="125" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
            <tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left"><p>' . $mailcontent . '</p>
                  </td>
                </tr>
              </table></td>
            </tr>
            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>


</body>
</html>';

                $mailsent = mail($to, $subject, $mail_send_details, $headers);
            } // end if
//==============================================End MAil To Admin=================================================================



            /* --------------Digital Product Block Ends---------------- */




            $txtSearch = "";
            $message = MSG_PROD_ADDED;
            $txtProductName = "";
            $txtProductCode = "";
            $txtDescription = "";
            $txtPrice = "";
            $txtStock = "";
            $txtReorderLevel = "";
            $txtDiscount = "";
            $txtDiscountDesc = "";
            $txtShippingWeight = "";

            //update count
            //$routesql = "Select route from " . $tableprefix . "categories where category_id ='$catid'";

            //echo $routesql;
            //$result = mysql_query($routesql);
            //$row = mysql_fetch_array($result);
            //$route = $row["route"];

            $routesql = "Select route from " . $tableprefix . "categories where category_id = :category_id";
            $qryRoutArr['category_id'] = $catid;
            $routerow = $pdo->pdoQuery($routesql,$qryRoutArr)->results();
            $route = $routerow['0']["route"];

            list($qarr,$qstr) = $route;
            //$qryupdatecatcount = "update " . $tableprefix . "categories set count=count+1 where category_id in($route)";
            $qryupdatecatcount = "update " . $tableprefix . "categories set count=count+1 where category_id in($qstr)";
            $pdo->pdoQuery($qryupdatecatcount,$qarr);
            //mysql_query($qryupdatecatcount);

            if ($productListingFee > 0) {
                header("Location:product-listing-payment.php?&pid=" . $product_insert_id);
                exit;
            }
            header("Location:mycatalog.php?message=$message&catid=$catid");
            exit;
        }
    }
} else if ($_POST["btnDeleteSelected"]) {
    if (!isNotNull($productlist)) {
        $message .= VAL_MSG_SEL_PROD_DEL." <br>";
    } else {
        $cnt = count($productlist);
        $plist = implode(",", $productlist);
        list($qarr,$qstr) = $plist;
        //$sql = "DELETE FROM " . $tableprefix . "products WHERE product_id IN ($plist) ";
        //$res = mysql_query($sql);
        $deleteQ = "DELETE FROM " . $tableprefix . "products WHERE product_id IN(" . $qstr . ")";
        $pdo->pdoQuery($deleteQ,$qarr)->results();

        $select_product_images = "SELECT image_small,image_big
							  FROM " . $tableprefix . "product_options WHERE product_id IN(" . $plist . ")";
        $result_product_images = $pdo->pdoQuery($select_product_images)->results();

        //$result_product_images = mysql_query($select_product_images) or die(mysql_error());

        if (count($result_product_images) > 0) {
            //while ($product_images_row = mysql_fetch_array($result_product_images)) {
            foreach($result_product_images as $key=>$product_images_row){
                $imagesmall_thumb = $product_images_row['image_small'];

                $imagelarge_thumb = $product_images_row['image_big'];

                @unlink("../products/" . $imagesmall_thumb);
                @unlink("../products/" . $imagelarge_thumb);
            }
        }
        $sql_options = "DELETE FROM " . $tableprefix . "product_options WHERE product_id IN ($qstr) ";
        //$del_options = mysql_query($sql_options);
        $pdo->pdoQuery($sql_options,$qarr)->results();

        $select_product_images_more = "SELECT im.vimage_name
                                               FROM " . $tableprefix . "product_view_images im
                                               WHERE im.nimage_productid IN(" . $plist . ")";
        //$rs_product_image_more = mysql_query($select_product_images_more) or die(mysql_error());
        $rs_product_image_more = $pdo->pdoQuery($select_product_images_more)->results();

        if (count($rs_product_image_more) > 0) {

            //while ($prows = mysql_fetch_array($rs_product_image_more)) {
            foreach($rs_product_image_more as $key=>$prows){
                $moreimage = $prows['vimage_name'];

                $moreimage_thumb = "thumb_" . $prows['vimage_name'];

                @unlink("../products/bulk_images/" . $moreimage);

                @unlink("../products/bulk_images/" . $moreimage_thumb);
            }
        }

        $sql_product_images_more = "DELETE FROM " . $tableprefix . "product_view_images WHERE nimage_productid IN ($qstr) ";
        $pdo->pdoQuery($sql_product_images_more,$qarr)->results();
        //$del_product_images_more = mysql_query($sql_product_images_more);
    }
}

if (isset($_POST['gotoPage'])) {

    header("Location:" . $_SERVER['PHP_SELF'] . "?page=" . $_POST['gotoPage'] . "&catid=" . $_POST['catid']);
}


$qryopt = "";
if ($txtSearch != "") {
    if ($cmbSearchType == "dateadded") {
        $dt = $txtSearch;
        $arrdt = explode("/", $dt);
        $day = $arrdt[1];
        $month = $arrdt[0];
        $year = $arrdt[2];
        $dt = $year . "-" . $month . "-" . $day;
        //$qryopt .= "  AND  p.date_added like '" . addslashes($dt) . "%'";

        $qryopt .= "  AND  p.date_added like :dt";
        $qryoptArr['dt'] = addslashes($dt)."%";
    } else if ($cmbSearchType == "productname") {
        //$qryopt .= "  AND  p.product_name like '" . addslashes($txtSearch) . "%'";
        $qryopt .= "  AND  p.product_name like :txtSearch";
        $qryoptArr['txtSearch'] = addslashes($txtSearch)."%";
    }
}

/*$sql = " SELECT p.*,(p.product_price+p.default_additional_price) AS product_price
       FROM " . $tableprefix . "products p WHERE p.product_category = '" . addslashes($catid) . "' and p.product_artist_id ='" . addslashes($artistid) . "' " . $qryopt . " ORDER BY p.product_name  ";*/
$sql = " SELECT p.*,(p.product_price+p.default_additional_price) AS product_price
       FROM " . $tableprefix . "products p WHERE p.product_category = :product_category and p.product_artist_id = :product_artist_id " . $qryopt . " ORDER BY p.product_name  ";

if (!(isset($pagenum))) {
    $pagenum = 1;
}

$limit = getSettingsValue('npagination_limit');

$page = isset($_GET['page']) ? trim($_GET['page']) : 1;


if (empty($page)) {
    $page = 1;
}

$qryoptArr['product_category'] = addslashes($catid);
$qryoptArr['product_artist_id'] = addslashes($artistid);
$result = $pdo->pdoQuery($sql,$qryoptArr)->results();
//$result = mysql_query($sql) or die(mysql_error());

$totalrows = count($result);

$limitvalue = ($page - 1) * $limit;

$query_string = " LIMIT $limitvalue, $limit";

$sql = $sql . $query_string;

//$rs = mysql_query($sql) or die(mysql_error());
$rs = $pdo->pdoQuery($sql,$qryoptArr)->results();

$numofpages = ceil($totalrows / $limit);

$shipping_Dimension_Required    =   checkShippingDimensionEnable();




include "../includes/htmltop.php";
?>
<link rel="stylesheet" href="<?php echo SITE_URL?>/style/jquery-ui.css">
<!--<script src="http://code.jquery.com/jquery-1.11.2.min.js"></script>-->
<script src="<?php echo SITE_URL?>/js/jquery-ui.js"></script>
<link href="<?php echo SITE_URL; ?>/style/jquery.timepicker.css" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_URL; ?>/style/jquerysctipttop.css" rel="stylesheet" type="text/css">
		<!-- CSS Stylesheet -->
<link rel="stylesheet" href="<?php echo SITE_URL; ?>/style/dateselector.css" type="text/css" />


<style>
    /*.tooltip {
        display:none;
        background:transparent url(../images/tooltip/black_arrow.png);
        font-size:12px;
        height:70px;
        width:160px;
        padding:25px;
        color:#fff;
    }*/

    .tooltip {
        background-color: black;;
        filter: alpha(opacity=75)-moz-opacity:0.75;
        opacity: 0.75;
        border: 2px solid #FFFFFF;

        border-radius:5px 5px 5px 5px;
        color: white;
        font-size: 1.2em;
        left: -12px;
        padding: 10px;
        position: relative;
        top: 21px;
        width: 200px;
    }
    .tooltip:after, .tooltip:before
    {
        top: 100%;
        border: solid transparent;
        content: " ";
        height: 0;
        width: 0;
        position: absolute;
        pointer-events: none;
    }
    .tooltip:after
    {
        border-color: rgba(10, 13, 15, 0);
        border-top-color: #0a0d0f;
        border-width: 10px;
        left: 50%;
        margin-left: -10px;
    } .tooltip:before

    {
        border-color: rgba(245, 245, 245, 0);
        border-top-color: #f5f5f5;
        border-width: 16px;
        left: 50%;
        margin-left: -16px;
    }
</style>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/jquery.timepicker.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/dateselector.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/dateselector.min.js"></script>

<script language="JavaScript" type="text/JavaScript">
    $(document).ready(function(){
        $(".help a[title]").tooltip();
        $('#txtSearch').keypress(function(e){

            if(e.keyCode==13){

                clickSearch();
            }
        });

        $('#txtPrice').keyup(function(e){
            var price = parseFloat($('#txtPrice').val());
            var newVal = $('#txtPrice').val().replace(/[^\d.]/, '');
         if(newVal>0) {
             $('#txtPrice').val(newVal);
            /*var number = (newVal.split('.'));

                if (number[1].length > 2)
                {
                    $("#txtPrice").val( price.toFixed(2));
                }*/
        }

        });
        $('.jqPrice').keyup(function(e){
            var price = parseFloat($(this).val());
            var newVal = $(this).val().replace(/[^\d.]/, '');
            var number = (newVal.split('.'));

            $(this).val(newVal);
            /*
            if (typeof(number[1]) != "undefined"){
                if (number[1].length > 2)
                {
                    $(this).val( price.toFixed(2));
                }

         }*/
        });

        $('#chkAllowSubscription').click(function(e){
           if ($('input[name=chkAllowSubscription]:checked').val() ) {
               $('#subscription_mode').show();
           }else{$('#subscription_mode').hide();}

        });

      <?php if($seller_vacation_mode=='Y')
      {
          ?>
               $("#publish_time").show();
               $('#jqPublish_N').prop('checked', true);
      <?php } ?>
        // hide publish now if seller in vacation mode

        //end
    $('.rdPublishStatus').click(function(){

        if($('input[name=rdPublishStatus]:checked').val()=="N"){
            $("#publish_time").show();
        }else if($('input[name=rdPublishStatus]:checked').val()=="Y"){
            $("#publish_time").hide();
        }

    });

    $("#publishtime").timepicker();
      //Datepicker
   var dateToday = new Date(Date.now());
    $("#publishdate").datepicker({
        //dateFormat: 'mm-dd-yy',
        minDate: dateToday
    }).datepicker('setDate', dateToday)

    })
    function clickSearch()
    {
        document.frmCatalog1.submit();
    }
    function confirmDelete(){
        if(confirm("<?php echo QTN_DEL_SEL_REC; ?>") ){
            return true;
        }
        return false;
    }
    function checkDigitalProduct()
    {



        if(document.frmCatalog4.txtDigitalProduct.checked == true)
        {

            document.getElementById("digitalProductBlock").style.display = "";
            $(".canshipBlock").hide();
            $("#allow_free_shipping").hide();
            //$('#chkAllowFreeShipping').prop('checked', true);

        }
        else
        {

            document.getElementById("digitalProductBlock").style.display = "none";
            $(".canshipBlock").show();
            $("#allow_free_shipping").show();
            $('#chkAllowFreeShipping').prop('checked', false);
        }

    }

      var _URL = window.URL || window.webkitURL;

    function showMyImage(files, imageId, dbImagePreview, fileInput) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;
        img.onload = function () {

            if(imageId == 'small_img_preview'){
                img_width = 200;
                img_height = 150;
            }
            else{

                img_width = 350;
                img_height = 245;
            }


            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {
                var imageType = /image.*/;
                $(".jqMoreImagefromDb_" + dbImagePreview).remove();
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }


        }
        img.src = _URL.createObjectURL(file);
    }


    function showBigImages(files, value, fileInput ) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;

        img.onload = function () {

            img_width = 350;
            img_height = 245;

            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {


                var imageType = /image.*/;

                var imageId = 'big_img_preview_' + value;
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }
        }
        img.src = _URL.createObjectURL(file);
    }

    function showSmallImages(files, value, fileInput) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;

        img.onload = function () {

            img_width = 200;
            img_height = 150;

            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {
                var imageType = /image.*/;
                var imageId = 'small_img_preview_' + value;
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }
        }
        img.src = _URL.createObjectURL(file);
    }
</script>
<body>
    <center>
        <div align="left" id="layout">
            <!--header area start -->
            <?php
            include_once("../includes/topheader_seller.php")
                    ?>
            <!--header area end -->
            <div align="left" class="main_body">
                <!--main body start -->
                <?php
                include_once("../includes/artisttopmenu.php")
                        ?>
                <div align="left" class="content_area">

                    <!--content area start -->

                    <div align="left" class="page_title"><?php echo TEXT_MY_CATALOG; ?></div>
                    <div align="center" class="text_information grey_tr">
                        <?php
                        if ($_GET['message'] != '') {
                            $message = $_GET['message'];
                        }
                        ?><?php echo $message ?></div>
                    <br>

                    <div align="left">


                        <table cellpadding="2" cellspacing="2" width="95%" class="">

                            <tr><td colspan="3">&nbsp;</td></tr>
                            <tr>
                                <td colspan="3">
                                    <div class="mycatalog_fld">
                                        <fieldset>



                                            <form name="frmCatalog" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data">
                                                <input type="hidden" name="catid" value="<?php echo htmlentities($catid); ?>" >

                                                <table width="100%" border=0>

                                                    <tr><td  class="hd_background" colspan="2" align="left" style='word-break:break-all;'><?php echo stripslashes(getCategoryLink("mycatalog.php", $catid)); ?></td></tr>
                                                    <tr><td colspan="2">
                                                            <table width="100%">
                                                                <?php

                                                                if (!isset($catid) || $catid == "") {
                                                                    $catid = 0;
                                                                }

                                                                $sql = "SELECT * FROM " . $tableprefix . "categories WHERE parent_id = :parent_id AND gift_certificate_flag != 'Y' ORDER BY category_name ";
                                                                $qryoptArrs['parent_id'] = addslashes($catid);
                                                                $res = $pdo->pdoQuery($sql,$qryoptArrs)->results();
                                                                //$res = mysql_query($sql);
                                                                $odd = true;
                                                                if (count($res) != 0) {
                                                                    //while ($row = mysql_fetch_array($res)) {
                                                                    foreach($res as $key=>$row){
                                                                        if ($odd == true) {
                                                                            echo "<tr><td align='left' style='word-break:break-all;'><a href='mycatalog.php?catid=" . $row["category_id"] . "' class='links'>" . stripslashes($row["category_name"]) . "</a></td>";
                                                                            $odd = false;
                                                                        } else {
                                                                            echo "<td align='left' style='word-break:break-all;'><a href='mycatalog.php?catid=" . $row["category_id"] . "' class='links'>" . stripslashes($row["category_name"]) . "</a></td></tr>";
                                                                            $odd = true;
                                                                        }
                                                                    }
                                                                } else {
                                                                    echo MSG_NO_CATEGORIES;
                                                                }
                                                                ?>
                                                            </table>
                                                        </td></tr>
                                                    <tr><td colspan="2">&nbsp;</td></tr>
                                                </table>
                                            </form>
                                        </fieldset>
                                        <div class="clear"></div>
                                    </div>

                                </td>
                            </tr>
                            <tr><td colspan="3">&nbsp;</td></tr>
                            <?php
                            $checkleafcategory = " select *  FROM  " . $tableprefix . "categories where parent_id=:parent_id";
                            $qryoptArrLeaf['parent_id'] = addslashes($catid);
                            $res1 = $pdo->pdoQuery($sql,$qryoptArrLeaf)->results();
                            $showproductadd = true;
//                            if (mysql_num_rows($res1) > 0) {
                            if(!empty($res1)){
                                $showproductadd = false;
                            }
                            if (isset($catid) and $catid != "" and $showproductadd) {
                                ?>
                            <tr>
                                <td colspan="3">
                                    <div class="mycatalog_fld">
                                        <fieldset>

                                            <legend class='toplinksCopy'><?php echo MSG_MY_PROD; ?></legend>
                                            <table width="100%" border=0>
                                                <tr>
                                                    <td colspan="2">
                                                        <!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
                                                        <table width="100%"  border="0" cellpadding="2" cellspacing="1" class="maintext">
                                                            <tr bgcolor="#FFFFFF" valign="top">
                                                                <td align="right" colspan="7" valign="top" >
                                                                    <form name="frmCatalog1" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data">
                                                                        <input type="hidden" name="catid" value="<?php echo htmlentities($catid); ?>" >
                                                                        <table width="100%" border="0" class="manage_table">

                                                                            <tr>
                                                                                <td width="80%" align=right  ><?php echo TEXT_SEARCH;?> ::
                                                                                    <select name="cmbSearchType" class="textarea">
                                                                                        <option value="productname"  <?php
                                                                                            if ($cmbSearchType == "productname" || $cmbSearchType == "") {
                                                                                                echo("selected");
                                                                                            }
                                                                                                    ?>><?php echo TXT_PRODUCT_NAME; ?></option>
                                                                                        <option value="dateadded"  <?php if ($cmbSearchType == "dateadded") {
        echo("selected");
    } ?>><?php echo TEXT_DATE_ADDED; ?> <?php echo TEXT_MM_DD_YY; ?></option>
                                                                                    </select> &nbsp;
                                                                                    <input type="text" name="txtSearch" id="txtSearch" size="20" maxlength="50" value="<?php echo stripslashes($txtSearch); ?>" class="textarea">
                                                                                </td>
                                                                                <td width="20%" align=left >
                                                                                    <a href="javascript:clickSearch();" class="go_button"><?php echo BTN_SEARCH; ?></a>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </form>
                                                                </td>
                                                            </tr>


                                                            <tr>
                                                                <td>
                                                                    <form name="frmCatalog3" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data">
                                                                        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="manage_table">
                                                                            <input type="hidden" name="catid" value="<?php echo htmlentities($catid); ?>" >


                                                                            <tr class="hd_background">
                                                                                <th>&nbsp;</th>
                                                                                <th><?php echo TXT_PRODUCT_NAME; ?></th>
                                                                                <th><?php echo TXT_PRODUCT_CODE; ?></th>
                                                                                <th><?php echo TEXT_PRICE; ?></th>
                                                                                <th align="center"><?php echo TXT_ADDED_ON; ?> <?php echo TEXT_MM_DD_YY; ?></th>
                                                                                <th colspan="2"><?php echo TXT_PRODUCT_IMAGE; ?></th>
                                                                            </tr>
                                                                                <?php
                                                                                if (count($result) > 0) {
                                                                                    $i = 1;

                                                                                    //while ($row = mysql_fetch_array($rs)) {
                                                                                    foreach($rs as $key=>$row){

                                                                                        $link = "<a class=links href='editmyproduct.php?productid=" . $row["product_id"] . "' class='smalllink'>";
                                                                                        $check = "<input type='checkbox' class='checkbox' name='chkproducts[]' value='" . $row["product_id"] . "' > ";

                                                                                        if ($row["default_image_small"] == "") {
                                                                                            $display_product_thumb = "../products/noimage.jpg";
                                                                                        } else {

                                                                                            if (strstr($row["default_image_small"], "http://")) {
                                                                                                $display_product_thumb = $row["default_image_small"];
                                                                                            } else {
                                                                                                //$prdImage = $prodimagedir.urlencode($product_image);
                                                                                                $display_product_thumb = "../products/".$row["default_image_small"];
                                                                                            }

                                                                                           // echo "sdasdasd<br>".$display_product_thumb;

                                                                                            //$display_product_thumb = "../products/".$row["image_small"];
            }
            ?>
                                                                            <tr>
                                                                                <td><?php echo $check; ?></td>
                                                                                <td align="left" style='word-break:break-all;' class=boxalternatecolor2><?php echo $link . stripslashes($row["product_name"]) . "</a>"; ?></td>
                                                                                <td align="left" ><?php echo $link . $row["product_code"] . "</a>"; ?></td>
                                                                                <td align="left"><?php echo $adminCurrency['currency_symbol']; ?> <?php echo $link . htmlentities(number_format($row["product_price"], 2, '.', '')) . "</a>"; ?></td>
                                                                                <td align="left"><?php echo $link . dateFormat($row["date_added"], "Y-m-d", "m/d/Y") . "</a>"; ?></td>
                                                                                <td colspan="2"><?php echo $link ?><img border="0" src="<?php echo $display_product_thumb ?>" height="30" width="30"><?php echo "</a>" ?></td>
                                                                            </tr>
                                                                                        <?php
                                                                                        $i++;
                                                                                    }
    } else {
        ?>
                                                                            <tr>
                                                                                <td align="center" valign="middle" colspan="6"  class="text_information"><?php echo TEXT_NO_RECORD; ?></td>
                                                                            </tr>
                                                                                    <?php
    }
    ?>


                                                                                <?php
    if (isNotNull($check)) {
        ?>
                                                                            <tr>
                                                                                <td colspan="7" align="center"><input type="submit" name="btnDeleteSelected" value="<?php echo BTN_DEL_SEL; ?>" onClick="return confirmDelete();" class="button" ></td>
                                                                            </tr>
                                                                                    <?php
                                                                                }

                                                                                if ($page > 1) {
                                                                                    $pageprev = $page - 1;

                                                                                    $previous_page = "<a href=" . $_SERVER['PHP_SELF'] . "?page=$pageprev&catid=$catid alt='Previous' border='0' class='small_gray_button'>".TEXT_PAGES_PREV."</a>";
                                                                                }


                                                                                if ($page < $numofpages) {
                                                                                    $pagenext = ($page + 1);

                                                                                    $next = "<a href=" . $_SERVER['PHP_SELF'] . "?page=$pagenext&catid=$catid alt='Next' border='0' class='small_gray_button'>".TEXT_PAGES_NEXT."</a>";
                                                                                }


    if ($page < $numofpages || $page > 1) {
        ?>


                                                                            <tr>
                                                                                <td class="page_nos"  align="center" colspan="7">
																					<table width="100%" border="0" cellspacing="10" cellpadding="0">
																						<tr align="left" valign="middle">
																							<td width="21%" align="right"><?php echo $previous_page ?></td>
																							<td width="23%" align="right">
																								<?php echo TEXT_PAGES; ?> <?php echo $page ?>/<?php echo $numofpages ?>&nbsp;&nbsp;<?php echo TEXT_GOTO; ?>
																							</td>
																							<td width="8%" align="right">
																								<select  class="textarea2" name="gotoPage" style="padding:4px 5px; margin-bottom:1px; ">
                                                                                                <?php
                                                                                                for ($i = 1; $i <= $numofpages; $i++) {


                                                                                                    if ($i == $_GET['page']) {
                                                                                                        $page_selected = "selected";
                                                                                                    } else {
                                                                                                        $page_selected = "";
            }
            ?>
                                                                                        <option value="<?php echo $i ?>" <?php echo $page_selected ?>><?php echo $i ?></option>

                                                                                                    <?php
        }
        ?>
                                                                                    </select>
																							</td>
																							<td width="7%">
																								<a onClick="Javascript:document.frmCatalog3.submit();" class="go_button_2"><?php echo BTN_GO; ?></a>
																							</td>
																							<td width="41%" align="center"><?php echo $next ?></td>
																						</tr>
																					</table>

                                                                                 </td>
                                                                            </tr>

                                                                                    <?php
    }
    ?>


                                                                        </table>

                                                                    </form>

                                                                </td>
                                                            </tr>



                                                        </table>



                                                        <!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

                                                    </td>
                                                </tr>
                                                <tr><td colspan="2">&nbsp;</td></tr>
                                                <tr>
                                                    <td  colspan="2">
                                                        <script type="text/javascript" src="<?php echo SITE_URL ?>/ckeditor/ckeditor.js"></script>
                                                            <?php
                                                            $options_arr = getOptionsFromCategory($catid);
                                                            $num_of_options = count($options_arr);
                                                            $StrOptions = "";
                                                            if ($num_of_options != "") {
                                                                foreach ($options_arr AS $eachoption) {
                                                                    $StrOptions .='<br><br><span class="category_option_label">' . $eachoption['option_name'] .'</span>';
                                                                    $StrOptions .='<span class="category_option_field"><input type="text" name="option_' . $eachoption['option_id'] . '[]" value=""></span>';
                                                                }
    }
    ?>
                                                        <script type="text/javascript">
                                                            window.onload = function()
                                                            {
                                                                var editor =  CKEDITOR.replace( 'editor1', {
                                                                    filebrowserBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html',
                                                                    filebrowserImageBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Images',
                                                                    filebrowserFlashBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Flash',
                                                                    filebrowserUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                                                                    filebrowserImageUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                                                                    filebrowserFlashUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'
                                                                    });
                                                               CKFinder.setupCKEditor( editor, '<?php echo SITE_URL ?>/ckeditor/ckfinder/' );
                                                                       $('#datetimepicker2').datetimepicker({
                                                                        language: 'en',
                                                                        pick12HourFormat: true
                                                                          });

                                                            };
                                                            //Santhosh thomas Alexander coded this
                                                            //This is to do dynamic options add
                                                            $(document).ready(function(){

                                                                $("#add_more_options").click(function() {
var addVal = $("#add_value").val();
                                                            $("#add_value").val(parseInt(addVal)+1);
                                                                   // var block = '<tr class="option_block"><td><table width="100%" cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC"><tr><th><?php echo TEXT_DEF_OPTION; ?></th><th><?php echo TEXT_ADD_PRICE; ?>&nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th><th><?php echo TEXT_PROD_STOCK; ?>&nbsp;<span class="required">*</span></th><th><?php echo TEXT_REC_LEVEL; ?>&nbsp;</th></tr><tr><td><span class="default_setting_box"><input type="radio" name="default" id="default" onclick="setDefaultOption(this);"><input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value=""><?php echo $StrOptions ?></span></td><td><input type="text" name="additional_price[]"  onpaste="return false;" id="additional_price[]" class="jqPrice " value=""></td><td><input type="text" name="product_stock[]" id="product_stock[]" value="" class="clsProductStock" ></td><td><input type="text" name="reorder_level[]" id="reorder_level[]" value=""></td></tr><tr><th><?php echo TXT_SMALL_IMAGE; ?>&nbsp;</th><th><?php echo TXT_BIG_IMAGE; ?>&nbsp;</th><th><?php echo TEXT_DISCOUNT;?> (%)</th><th><?php echo TXT_DISCOUNT_DESCRIPTION; ?></th></tr><tr><td><input type="file" name="image_small[]" id="image_small[]" value=""></td><td><input type="file" name="image_big[]" id="image_big[]" value=""></td><td><input type="text" name="discount[]" id="discount[]" value=""></td><td><input type="text" name="discount_description[]" id="discount_description[]" value=""></td></tr><tr class="canshipBlock"><th><?php echo TEXT_SHIP_WEIGHT; ?>&nbsp;<span class="required">*</span></th><th><?php echo TEXT_LENGTH;?> <?php echo TEXT_CM;?>&nbsp;<span class="required">*</span> </th><th><?php echo TEXT_WIDTH;?><?php echo TEXT_CM;?>&nbsp;<span class="required">*</span> </th><th><?php echo TEXT_HEIGHT;?> <?php echo TEXT_CM;?>&nbsp;<span class="required">*</span> </th></tr><tr class="canshipBlock"><td><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="" class="clsShippingWeight" ></td><td><input type="text" name="product_length[]" id="product_length[]" value=""></td><td><input type="text" name="product_width[]" id="product_width[]" value=""></td><td><input type="text" name="product_height[]" id="product_height[]" value=""></td></tr><tr><td colspan="4" align="right">&nbsp;<img border="0" title="Delete Option" src="../images/btn_del.gif" alt="Delete Option" class="delete_option" onclick="javascript:delete_option(this);"></td></tr></table></td></tr>';
                                                                   // $("#options_window").append(block);
                                                                    var block = '<tr class="option_block"><td><table width="100%" cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC"><tr><th><?php echo TEXT_DEF_OPTION; ?></th><th><?php echo TEXT_ADD_PRICE; ?> &nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th><th><?php echo TEXT_PROD_STOCK; ?>&nbsp;<span class="required">*</span></th><th><?php echo TEXT_REC_LEVEL; ?>&nbsp;</th></tr><tr><td><span class="default_setting_box"><input type="radio" name="default" id="default" onclick="setDefaultOption(this);"><input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value=""><?php echo $StrOptions ?><br></span></td><td><input type="text" name="additional_price[]"  onpaste="return false;" id="additional_price[]" value="" class="jqPrice jQNumeric"></td><td><input type="text" name="product_stock[]" id="product_stock[]" value="" class="clsProductStock jQNumeric"></td><td><input type="text" name="reorder_level[]" id="reorder_level[]" value="" class="jQNumeric"></td></tr><tr><th><?php echo TXT_BIG_IMAGE; ?>&nbsp;<span class="required">*</span></th><th><?php echo TXT_SMALL_IMAGE; ?>&nbsp;</th><th><?php echo TEXT_DISCOUNT; ?> (%)</th><th><?php echo TXT_DISCOUNT_DESCRIPTION; ?></th></tr><tr><td><input type="file" name="image_big[]" id="image_big_'+addVal+'" value="" class="image_big" onchange="showBigImages(this.files,'+addVal+',this);return validateFileExtension(this);"><img src="" style="display:none" width="183" height="191" id="big_img_preview_'+addVal+'"></td> <td><input type="file" name="image_small[]" id="image_small_'+addVal+'" onChange="showSmallImages(this.files,'+addVal+',this);" value=""><img src="" style="display:none" width="183" height="191" id="small_img_preview_'+addVal+'"></td><td><input type="text" name="discount[]" id="discount[]" value="" class="jQNumeric"></td><td><input type="text" name="discount_description[]" id="discount_description[]" value=""></td></tr><tr class="canshipBlock"><th><?php echo TEXT_SHIP_WEIGHT; ?>&nbsp;<span class="required">*</span></th><th><?php echo TEXT_LENGTH; ?> <?php echo TEXT_CM;?></th><th><?php echo TEXT_WIDTH; ?> </th><th><?php echo TEXT_HEIGHT; ?>  </th></tr><tr class="canshipBlock"><td><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="" class="jQNumeric"></td><td><input type="text" name="product_length[]" id="product_length[]" value="" class="jQNumeric"></td><td><input type="text" name="product_width[]" id="product_width[]" value="" class="jQNumeric"></td><td><input type="text" name="product_height[]" id="product_height[]" value="" class="jQNumeric">&nbsp;<img border="0" title="<?php echo TITLE_DELETE_OPTION; ?>" src="../images/btn_del.gif" alt="<?php echo TITLE_DELETE_OPTION; ?>" class="delete_option" onclick="javascript:delete_option(this);"></td></tr></table></td></tr>';
                                                                    $("#options_window").append(block);
                                                                    $('.jqPrice').keyup(function(e){
                                                                        var price = parseFloat($(this).val());
                                                                        var newVal = $(this).val().replace(/[^\d.]/, '');
                                                                        var number = (newVal.split('.'));
                                                                        $(this).val(newVal);
                                                                        if (typeof(number[1]) != "undefined"){
                                                                            if (number[1].length > 2)
                                                                            {
                                                                                $(this).val( price.toFixed(2));
                                                                            }
                                                                        }

                                                                    });
                                                                    checkDigitalProduct();
                                                                });

                                                            });
                                                            function setDefaultOption(obj) {

                                                                $(".default_option").val("");
                                                                $(obj).parents(".default_setting_box").find(".default_option").val("1");


                                                            }
                                                            function delete_option(obj) {

                                                                $(obj).parents(".option_block").hide("slow");
                                                                $(obj).parents(".option_block").html("");
                                                            }
                                                        </script>

                                                        <!-- ***************************************************************** -->
                                                        <form name="frmCatalog4" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data">
                                                            <input type="hidden" name="sellerid" id="clsSeller" value="<?php echo $artistid;?>">
                                                             <input type="hidden" name="txtShippingDimension" id="clsShippingdimension" value="<?php echo $shipping_Dimension_Required;?>">

                                                            <input type="hidden" name="catid" value="<?php echo htmlentities($catid); ?>" >
                                                            <table cellpadding="2" class="bx_bg" cellspacing="2" width="100%" border="0">
                                                                <tr><td colspan="3" align="left" class="page_title2"><b><?php echo MSG_ADD_NEW_PROD; ?></b></tr>
                                                                <tr><td colspan="3"></tr>
                                                                <tr><td align="right" width="33%"><?php echo TXT_PRODUCT_NAME; ?> &nbsp; <span class="required">*</span></td>
                                                                    <td width="3%" align='left'>:</td>
                                                                    <td width="64%" align='left'><input name="txtProductName" type="text" class="textarea" id="txtProductName" value="<?php echo $txtProductName; ?>" size="30" maxlength="100">
                                                                        <span class="help"><a href="#" title="<?php echo PRODNAME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td></tr>
                                                                <tr><td align="right" width="33%"><?php echo TXT_PRODUCT_CODE; ?>&nbsp; </td>
                                                                    <td width="3%" align='left'>:</td>
                                                                    <td  align='left'><input name="txtProductCode"  type="text" class="textarea" id="txtProductCode" value="<?php echo $txtProductCode; ?>" size="20" maxlength="20">
                                                                        <span class="help"><a href="#" title="<?php echo PRODID_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td></tr>
                                                                <tr><td align="right" valign="top"><?php echo TEXT_DESC; ?>&nbsp;<span class="required">*</span></td>
                                                                    <td valign="top" >:</td>
                                                                    <td align='left'>
                                                                        <textarea id="editor1" name="txtDescription"><?php echo stripslashes($_POST['txtDescription']); ?></textarea>

                                                                    </td></tr>

                                                                <tr><td align="right" ><?php echo TEXT_PRICE; ?>&nbsp;<span class="required">*</span></td>
                                                                    <td >:</td>
                                                                    <td align='left'><input name="txtPrice"  type="text" class="textarea"  onpaste="return false;" id="txtPrice" value="<?php echo htmlentities($txtPrice); ?>" size="30" maxlength="100">
                                                                        &nbsp;<b><?php echo $adminCurrency['currency_code']; ?></b>
                                                                        <span class="help"><a href="#" title="<?php echo PROD_PRICE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td>
                                                                </tr>
                                                                <tr><td align="right" ><?php echo TEXT_SEARCH_TAGS; ?>&nbsp;</td>
                                                                    <td >:</td>
                                                                    <td align='left'>
                                                                        <textarea id="txtProductTags" name="txtProductTags" cols="50" class="textarea2" rows="10"><?php echo htmlentities($txtSearchTags); ?></textarea>
                                                                        &nbsp;
                                                                        <span class="help"><a href="#" title="<?php echo PROD_TAGS_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td>
                                                                </tr>
                                                                <tr id="allow_free_shipping">
                                                                    <td align="right"><?php echo TEXT_ALLOW_FREE_SHIPPING; ?>&nbsp;</td>
                                                                    <td>:</td>
                                                                    <td align='left'><input type="checkbox" id="chkAllowFreeShipping"  name="chkAllowFreeShipping" value="Y" <?php echo $chkAllowFreeShipping; ?>>
                                                                        <span class="help"><a href="#" title="<?php echo FREE_SHIPPING_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td>
                                                                </tr>

                                                                <!--<?php if(getSettingsValue('enable_subscription_products')=='Y') { ?>
                                                                <tr>
                                                                    <td align="right"><?php echo TEXT_ALLOW_SUBSCRIPTION; ?>&nbsp;</td>
                                                                    <td>:</td>
                                                                    <td align='left'><input type="checkbox" id="chkAllowSubscription"  name="chkAllowSubscription" value="Y" <?php echo $chkAllowSubscription; ?>>
                                                                        <span class="help"><a href="#" title="<?php echo ALLOW_SUBSCRIPTION_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td>
                                                                </tr>
                                                                <tr id="subscription_mode" style="display: none;">
                                                                    <td align="right"><?php echo TEXT_SUBSCRIPTION_MODE; ?>&nbsp;</td>
                                                                    <td>:</td>
                                                                    <td align='left'>
                                                                        <input type="radio" name="rdSubscriptionMode" value="Daily" <?php if ($rdSubscriptionMode    == "Daily")   {   echo "checked"; }?>><?php echo TEXT_DAILY;?>
                                                                        <input type="radio" name="rdSubscriptionMode" value="Monthly" <?php if ($rdSubscriptionMode  == "Monthly") {   echo "checked"; }?>><?php echo TEXT_MONTHLY;?>
                                                                        <input type="radio" name="rdSubscriptionMode" value="Yearly" <?php if ($rdSubscriptionMode   == "Yearly")  {   echo "checked"; }?>><?php echo TEXT_YEARLY;?>
                                                                        <span class="help"><a href="#" title="<?php echo SUBSCRIPTION_MODE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td>
                                                                </tr>
                                                            <?php } ?>-->

                                                                 <?php if(getSettingsValue('enable_product_scheduled_publishing')=='Y') {?>
                                                                <tr>
                                                                    <td align="right"><?php echo TEXT_PUBLISH_STATUS; ?>&nbsp;</td>
                                                                    <td>:</td>
                                                                    <td align='left'>
                                                                        <?php if($seller_vacation_mode=='N') { ?>
                                                                            <input type="radio"  id="jqPublish_Y" name="rdPublishStatus" class="rdPublishStatus" value="Y" <?php if ($rdPublishStatus  == "Y") {   echo "checked"; } elseif($rdPublishStatus==NULL){echo "checked";}?>><?php echo TEXT_PUBLISH_NOW;?>
                                                                        <?php } ?>
                                                                            <input type="radio"  id="jqPublish_N" name="rdPublishStatus" class="rdPublishStatus" value="N" <?php if ($rdPublishStatus  == "N") {   echo "checked"; }?>><?php echo TEXT_PUBLISH_LATER;?>
                                                                        <span class="help"><a href="#" title="<?php echo PUBLISH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td>
                                                                </tr>
                                                                <tr id="publish_time" style="display: none;">
                                                                    <td align="right"><?php echo TEXT_PUBLISH_DATE; ?>&nbsp;</td>
                                                                    <td>:</td>
                                                                    <td align='left'><table><tr><td><input type="text" id="publishdate" name="publishdate"></td>
                                                                                <td><?php echo TEXT_PUBLISH_TIME; ?></td>
                                                                                <td><input type="text" id="publishtime" name="publishtime" style="width: 54px;"></td>
                                                                                <td><span class="help"><a href="#" title="<?php echo TEXT_PUBLISH_TIME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                </tr>

                                                                 <?php } ?>
                                                                <tr>
                                                                    <td align="right"><?php echo TEXT_DIG_PROD; ?>&nbsp;</td>
                                                                    <td>:</td>
                                                                    <td align='left'><input type="checkbox" id="txtDigitalProduct"  name="txtDigitalProduct" value="Y" onClick="checkDigitalProduct();" <?php echo $chkDigitalProduct; ?>>
                                                                        <span class="help"><a href="#" title="<?php echo DWNLD_PROD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td align="left"><?php echo MSG_PROD_OPTIONS; ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <td colspan="3">
                                                                        <div id="digitalProductBlock" style="display:<?php echo $digitalBlock; ?>">
                                                                            <table cellpadding="2" cellspacing="2" width="100%" border="0">
                                                                                <tr>
                                                                                    <td width="39%" align="right"><?php echo TEXT_UPLD_DIGPROD; ?>&nbsp;<span class="required">*</span></td>
                                                                                    <td width="3%" align="left">:</td>
                                                                                    <td width="21%" align='left'><input type="file" class="textarea" name="txtProductZip" id="txtProductZip"></td>
                                                                                    <td width="37%" class="text_information" align="left">    <?php echo TEXT_MAX_ALLOW_SIZE; ?>   <b><?php echo $maximagesizestringinPHP; ?></b>
                                                                                    </td>
                                                                                </tr>
                                                                                  <tr>
                                                                                      <td colspan="4" class="text_information" ><?php echo ALLOWED_DIGITAL_FORMATS;?> :  <?php echo implode(",",$digital_product_types);?> &nbsp; <span class="help"><a href="#" title="<?php echo FILE_EXTN_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></td></tr>
                                                                                <tr>
                                                                                    <td width="39%" align="right"><?php echo TEXT_PROD_DWLD_TRY; ?>&nbsp;</td>
                                                                                    <td width="3%" align="left">:</td>
                                                                                    <td colspan="2" align="left">
                                                                                        <select name="txtDownloadTry" class="textarea" id="txtDownloadTry">
                                                                                                <?php
    for ($i = 1; $i <= 10; $i++) {
                                                                                                    ?>
                                                                                            <option value="<?php echo $i ?>"><?php echo $i ?></option>
                                                                                                    <?php
    }
    ?>
                                                                                        </select><span>&nbsp;<?php echo TEXT_TIME; ?></span>
                                                                                        <span class="help"><a href="#" title="<?php echo NO_DWNLD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td width="39%" align="right"><?php echo TEXT_PROD_DWLD_EXP; ?>&nbsp;</td>
                                                                                    <td width="3%" align="left">:</td>
                                                                                    <td colspan="2" align="left">
                                                                                        <select name="txtDownloadExpiry" class="textarea" id="txtDownloadExpiry">
                                                                                                <?php
    for ($i = 1; $i <= 10; $i++) {
                                                                                                    ?>
                                                                                            <option value="<?php echo $i ?>"><?php echo $i ?></option>
                                                                                                    <?php
    }
    ?>
                                                                                        </select>&nbsp;<?php echo TEXT_DAY; ?>
                                                                                        <span class="help"><a href="#" title="<?php echo LINK_EXPIRE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    </td>
                                                                </tr>


                                                                <tr>

                                                                    <td colspan="3">
                                                                        <table cellpadding="2" cellspacing="2" border="0" id="options_window" width="100%">
                                                                            <tr>
                                                                                <td>
                                                                                    <table width="100%" cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC">
                                                                                        <tr>
                                                                                            <th><?php echo TEXT_DEF_OPTION; ?><span class="help"><a href="#" title="<?php echo MUL_PROD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                            <th><?php echo TEXT_ADD_PRICE; ?>&nbsp;(<?php echo $adminCurrency['currency_code']; ?>)<span class="help"><a href="#" title="<?php echo EXTRA_PRICE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                            <th><?php echo TEXT_PROD_STOCK; ?>&nbsp;<span class="required">*</span><span class="help"><a href="#" title="<?php echo AVAIL_STK_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                            <th><?php echo TEXT_REC_LEVEL; ?>&nbsp;<span class="help"><a href="#" title="<?php echo STK_LEVEL_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                        </tr>
                                                                                            <?php
                                                                                            $dchecked = "";
                                                                                            $default = 1;
                                                                                            if (count($_POST['default_option']) == 0) {
                                                                                                $dchecked = "checked";
                                                                                            }
                                                                                            if ($_POST['default_option'][0] == "1") {
                                                                                                $dchecked = "checked";
                                                                                                $default = $_POST['default_option'][0];
    }
    ?>
                                                                                        <tr>
                                                                                            <td align="center">
                                                                                                <span class="default_setting_box">
                                                                                                    <input type="radio" name="default" id="default" onclick="setDefaultOption(this);" <?php echo $dchecked; ?>>
                                                                                                    <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>">

                                                                                                        <?php
                                                                                                        $options_arr = getOptionsFromCategory($catid);
                                                                                                        $num_of_options = count($options_arr);
                                                                                                        if ($num_of_options != "") {
                                                                                                            foreach ($options_arr AS $eachoption) {
                                                                                                        echo "<br><br><span class='category_option_label'>" . $eachoption['option_name'] . '</span>';
                                                                                                                ?>
                                                                                                    <span class='category_option_field'><input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $_POST['option_' . $eachoption['option_id']][0]; ?>"></span>
                                                                                                                <?php
                                                                                                            }
                                                                                                        }
                                                                                                        ?>
                                                                                                </span>
                                                                                            </td>
                                                                                            <td align="center"><input type="text" name="additional_price[]"  onpaste="return false;" id="additional_price[]" value="<?php echo $_POST['additional_price'][0]; ?>" class="jqPrice"></td>
                                                                                            <td align="center"><input type="text" class="clsProductStock jQNumeric" name="product_stock[]" id="product_stock[]" value="<?php echo $_POST['product_stock'][0]; ?>"></td>
                                                                                            <td align="center"><input type="text" class="jQNumeric" name="reorder_level[]" id="reorder_level[]" value="<?php echo $_POST['reorder_level'][0]; ?>"></td>
                                                                                        </tr>
                                                                                        <tr>
                                                                                            <th><?php echo TXT_BIG_IMAGE; ?>&nbsp;<span class="required">*</span><span class="help"><a href="#" title="<?php echo IMG_DISP_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                            <th><?php echo TXT_SMALL_IMAGE; ?>&nbsp;<span class="help"><a href="#" title="<?php echo IMGLIST_TOOLTIP ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                            <th><?php echo TEXT_DISCOUNT; ?> (%)<span class="help"><a href="#" title="<?php echo DISC_PERC_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                            <th><?php echo TXT_DISCOUNT_DESCRIPTION; ?><span class="help"><a href="#" title="<?php echo EX_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                        </tr>
                                                                                        <tr>
                                                                                            <td valign="top" align="center"><input type="file" name="image_big[]" id="image_big[]" class="image_big" value="<?php echo $_POST['image_big'][0]; ?>" onchange="showMyImage(this.files,'big_img_preview','bigimagepreview',this);return validateFileExtension(this);">
                                                                                            <img style="display:none" src="" id="big_img_preview" border="0" width="183" height="191"></td>
                                                                                            <td valign="top" align="center"><input type="file" name="image_small[]" id="image_small[]" value="<?php echo $_POST['image_small'][0]; ?>" onchange="showMyImage(this.files,'small_img_preview','smallimagepreview',this);">
                                                                                            <img style="display:none" src="" id="small_img_preview" border="0" width="183" height="191"></td>
                                                                                            <td valign="top" align="center"><input type="text" name="discount[]" id="discount[]" class="jQNumeric" value="<?php echo $_POST['discount'][0]; ?>"></td>
                                                                                            <td valign="top" align="center"><input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo $_POST['discount_description'][0]; ?>"></td>
                                                                                        </tr>
                                                                                        <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                                            <th><?php echo TEXT_SHIP_WEIGHT; ?>&nbsp;<span class="required">*</span>
                                                                                                <span class="help"><a href="#" title="<?php echo PWEIGHT_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                            </th>
                                                                                            <th><?php echo TEXT_LENGTH; ?> <?php echo TEXT_CM;?> &nbsp; <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                                                                                <span class="help"><a href="#" title="<?php echo PLEN_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                            </th>
                                                                                            <th><?php echo TEXT_WIDTH; ?>&nbsp;<?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                                                                                <span class="help"><a href="#" title="<?php echo PWIDTH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                            </th>
                                                                                            <th><?php echo TEXT_HEIGHT; ?>&nbsp;<?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                                                                                <span class="help"><a href="#" title="<?php echo PHEIGHT_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                            </th>
                                                                                        </tr>
                                                                                        <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                                            <td align="center"><input type="text" class="clsShippingWeight jQNumeric" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $_POST['product_shipping_weight'][0]; ?>"></td>
                                                                                            <td align="center"><input type="text" class="clsProductlength jQNumeric" name="product_length[]" id="product_length[]" value="<?php echo $_POST['product_length'][0]; ?>"></td>
                                                                                            <td align="center"><input type="text" class="clsProductwidth jQNumeric" name="product_width[]" id="product_width[]" value="<?php echo $_POST['product_width'][0]; ?>"></td>
                                                                                            <td align="center"><input type="text" class="clsProductheight jQNumeric" name="product_height[]" id="product_height[]" value="<?php echo $_POST['product_height'][0]; ?>"></td>
                                                                                        </tr>
                                                                                    </table>
                                                                                </td>
                                                                            </tr>




                                                                                <?php
    for ($i = 1; $i < $options_count; $i++) {
        ?>
                                                                            <tr class="option_block">
                                                                                <td>
                                                                                    <table width="100%" cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC">
                                                                                        <tr>
                                                                                            <th><?php echo TEXT_DEF_OPTION; ?></th>
                                                                                            <th><?php echo TEXT_ADD_PRICE; ?>&nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th>
                                                                                            <th><?php echo TEXT_PROD_STOCK; ?>&nbsp;<span class="required">*</span></th>
                                                                                            <th><?php echo TEXT_REC_LEVEL; ?>&nbsp;</th>
                                                                                        </tr>
                                                                                                <?php
                                                                                                $dchecked = "";
                                                                                                if ($_POST['default_option'][$i] == "1") {
                                                                                                    $dchecked = "checked";
        }
        ?>
                                                                                        <tr>
                                                                                            <td align="center">
                                                                                                <span class="default_setting_box">
                                                                                                    <input type="radio" name="default" id="default" onclick="setDefaultOption(this);" <?php echo $dchecked ?>>
                                                                                                    <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $_POST['default_option'][$i] ?>">
                                                                                                            <?php
                                                                                                            $options_arr = getOptionsFromCategory($catid);
                                                                                                            $num_of_options = count($options_arr);
                                                                                                            if ($num_of_options != "") {
                                                                                                                foreach ($options_arr AS $eachoption) {
                echo "<br>" . $eachoption['option_name'];
                                                                                                                    ?>
                                                                                                    <span class='category_option_field'><input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $_POST['option_' . $eachoption['option_id']][$i]; ?>"></span>
                                                                                                                    <?php
                                                                                                                }
        }
        ?>
                                                                                                </span>
                                                                                            </td>
                                                                                            <td align="center"><input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $_POST['additional_price'][$i] ?>" class="jqPrice"></td>
                                                                                            <td align="center"><input type="text" class="clsProductStock" name="product_stock[]" id="product_stock[]" value="<?php echo $_POST['product_stock'][$i] ?>"></td>
                                                                                            <td align="center"><input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $_POST['reorder_level'][$i] ?>"></td></tr>
                                                                                        <tr>

                                                                                            <th><?php echo TXT_BIG_IMAGE; ?>&nbsp; <span class="required">*</span></th>
                                                                                            <th><?php echo TXT_SMALL_IMAGE; ?>&nbsp;</th>
                                                                                            <th><?php echo TEXT_DISCOUNT; ?> (%)</th>
                                                                                            <th><?php echo TXT_DISCOUNT_DESCRIPTION; ?></th></tr>
                                                                                        <tr>
                                                                                            <td align="center"><input type="file" name="image_big[]" id="image_big[]" value="<?php echo $_POST['image_big'][$i] ?>" class="image_big" onchange="showBigImages(this.files,'<?php echo $i-1?>',this);return validateFileExtension(this);">
                                                                                            <img src="" style="display:none" width="183" height="191" id="big_img_preview_<?php echo ($i-1)?>"></td>
                                                                                            <td align="center"><input type="file" name="image_small[]" id="image_small[]" value="<?php echo $_POST['image_small'][$i] ?>" onchange="showSmallImages(this.files,'<?php echo $i-1?>',this);" >
                                                                                            <img src="" style="display:none" width="183" height="191" id="small_img_preview_<?php echo ($i-1)?>"></td>
                                                                                            <td align="center"><input type="text" name="discount[]" id="discount[]" value="<?php echo $_POST['discount'][$i] ?>"></td>
                                                                                            <td align="center"><input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo $_POST['discount_description'][$i] ?>"></td>
                                                                                        </tr>
                                                                                        <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                                            <th><?php echo TEXT_SHIP_WEIGHT; ?>&nbsp;<span class="required">*</span>

                                                                                            </th>
                                                                                            <th><?php echo TEXT_LENGTH; ?> <?php echo TEXT_CM;?><?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?> <?php echo TEXT_CM; ?>
                                                                                                <span class="help"><a href="#" title="Length of the product in centi meters"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                            </th>
                                                                                            <th><?php echo TEXT_WIDTH;?><?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?> <?php echo TEXT_CM; ?>
                                                                                                <span class="help"><a href="#" title="Width of the product in centi meters"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                                                                            </th>
                                                                                            <th><?php echo TEXT_HEIGHT;?><?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?> <?php echo TEXT_CM; ?><span class="help"><a href="#" title="Height of the product in centi meters"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></th>
                                                                                        </tr>
                                                                                        <tr class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                                            <td align="center"><input type="text" class="clsShippingWeight" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $_POST['product_shipping_weight'][$i] ?>"></td>
                                                                                            <td align="center"><input type="text" class="clsProductlength" name="product_length[]" id="product_length[]" value="<?php echo $_POST['product_length'][$i] ?>"></td>
                                                                                            <td align="center"><input type="text"  class="clsProductwidth" name="product_width[]" id="product_width[]" value="<?php echo $_POST['product_width'][$i] ?>"></td>
                                                                                            <td align="center"><input type="text" class="clsProductheight" name="product_height[]" id="product_height[]" value="<?php echo $_POST['product_height'][$i] ?>">&nbsp;<img border="0" title="Delete Option" src="../images/btn_del.gif" alt="Delete Option" class="delete_option" onclick="javascript:delete_option(this);"></td>
                                                                                        </tr>
                                                                                    </table>
                                                                                </td>
                                                                            </tr>
                                                                                    <?php
    }
    ?>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                                    <?php
                                                                    if($options_count=='' ||$options_count==null){
                                                                        $options_count = 0;
                                                                    }
                                                                    $options_arr = getOptionsFromCategory($catid);
                                                                    $num_of_options = count($options_arr);
    if ($num_of_options >= 1) {
        ?>
                                                                <tr>

                                                                    <td colspan="3"><input type="button" name="add_more_options" value="<?php echo TXT_ADD_MORE_OPTIONS; ?>" id="add_more_options"/>
                                                                    <input type="hidden" name="add_value" id="add_value" value="<?php echo $options_count?>"></td>
                                                                </tr>
                                                                        <?php
    }
    ?>
                                                                <tr>
                                                                    <td colspan="3">
                                                                        <div id="canshipBlock" class="canshipBlock" style="display:<?php echo $canshipblock; ?>">
                                                                            <table cellpadding="2" cellspacing="2" border="0" width="100%">
                                                                                <tr>
                                                                                    <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo MSG_SMALL_IMG; ?> - 400 X 300 </strong></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo MSG_BIG_IMG; ?> - 500 X 350 </strong></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td colspan="3"><span class="required"><strong>*</strong></span><strong> <?php echo MSG_SHIP; ?> </strong></td>
                                                                                </tr>

                                                                            </table>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td><?php echo TEXT_MORE_IMG; ?> (jpg/gif/png) </td>
                                                                    <td colspan="2">
                                                                            <?php
                                                                            $moreImagesql = "SELECT nproduct_image_id, nimage_productid,
                        vimage_name, vimage_description, vproduct_image_delete_status
                   FROM " . $tableprefix . "product_view_images
                  WHERE nimage_productid=:nimage_productid ";

                                                          $qryoptArrMorImg['nimage_productid'] = addslashes($productid);
				$result = $pdo->pdoQuery($moreImagesql,$qryoptArrMorImg)->results();
                                                                            //$result = mysql_query($moreImagesql);
                                                                            if (count($result) != 0) {

                                                                            }

                                                                            $moreImageMaxLImit = getSettingsValue('more_image_limit');
                                                                            if ($moreImageMaxLImit > 0) {
        for ($iCount = 0; $iCount < $moreImageMaxLImit; $iCount++) {
            ?>
                                                                        <div class="jqMoreImageContainer" style="padding:5px;border:1px solid #D3D1D1;margin:10px 1px 10px 1px;float:left;width:200px;">
                                                                            <div style="width:180px;float:left;margin-bottom: 4px;"><b><?php echo TEXT_MORE_IMG; ?> <?php echo $iCount + 1; ?></b></div>
                                                                            <input type="file" name="productMoreImage[]" onchange="showMyImage(this.files,'more_img_preview_<?php echo $iCount+1?>','<?php echo $iCount+1;?>',this)"/>
                                                                            <img style="display:none" src="" id="more_img_preview_<?php echo $iCount+1?>" border="0" width="183" height="191">
                                                                        </div>
                                                                                    <?php
                                                                                }
    }
    ?>

                                                                    </td>
                                                                </tr>
                                                                <?php /*<tr>
                                                                    <td>
                                                                     <div class="well">
                                                                <div id="datetimepicker2" class="input-append">
                                                                  <input data-format="MM/dd/yyyy HH:mm:ss PP" type="text"></input>
                                                                  <span class="add-on">
                                                                    <i data-time-icon="icon-time" data-date-icon="icon-calendar">
                                                                    </i>
                                                                  </span>
                                                                </div>
                                                              </div>
                                                                </td></tr>*/?>
                                                                <tr><td colspan="3">&nbsp;</td></tr>
                                                                <tr><td colspan="3" align="center"><input type="submit" value="<?php echo BTN_ADD_PROD; ?>" name="btnAddProduct" class="button" onClick="return validateProductForm();"></td></tr>
                                                                <tr>
                                                                    <td colspan="3">
                                                                        <div align='left' class='linksCopy2'></div>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </form>

                                                        <!-- ***************************************************************** -->


                                                    </td>
                                                </tr>
                                            </table>
                                        </fieldset>

                                </td>
                            </tr>
    <?php } else {
    ?>
                            <table>
                                <tr>
                                    <td class='toplinksCopy' colspan="3"><?php echo TEXT_LEAF_LEVEL; ?></td>
                                </tr>
                            </table>

    <?php }
?>
                            <tr><td colspan="3">&nbsp;</td></tr>
                        </table>

                        </form>

                    </div>


                    <!--content area end-->

                </div>


                <div align="left" class="clear_float"><img src="<?php echo $imagefolder; ?>/clear.gif" alt="" width="1" height="1" /></div>
                <!--main body end -->
            </div>


            <?php
include "../includes/footer.php";
?>
            <script type="text/javascript">
                var msgProductName = "<?php echo MSG_PRODUCT_NAME; ?>";
                var msgProductPrice = "<?php echo MSG_PRODUCT_PRICE; ?>";
                var msgProductImage = "<?php echo MSG_PRODUCT_IMAGE;?>";

            </script>

            <script src="../js/product-check.js"  type="text/javascript"></script>
