<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 	   		 */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    |
// +----------------------------------------------------------------------+
// | Authors: Aswin<aswin.j@armiasystems.com>             		          |
// +----------------------------------------------------------------------+

App::import('Sanitize');
class CustomimagesController extends AppController {
    var $name = "Customimage";
    var $uses = array('Customimage','Cart','Coordinate','Imageregion','Customfield','Customfieldvalue','Product','Productdetail','Category','Cmspage','Savedimage', 'User', 'Setting', 'Currency','Newsletteruser','Cart','Itemcoordinate','ItemcoordinateSession','Font','Palette','Order','OrderDetail','Customimagetypes','Productpricetier','Ruler','Dynamicpage');
    var $helpers = array('Html', 'Form');
    var $components = array('RequestHandler','Resize','Customize', 'Textgen', 'Imagehandle');
 
    public $site_timezone;

    function index($calcuilcategoryID,$productID,$productdetailID) { 
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

        $imgCount_actual = $this->Customimagetypes->findCount("Customimagetypes.productid = $productID");
        $imgCount = $this->Customimage->findCount("productdetails_id = $productdetailID");

        
        $this->Session->write('catID', $categoryID);
        $this->Session->write('prodID', $productID);
        if($imgCount < ($imgCount_actual+1)) $this->redirect(array('controller' => 'Customimages','action'=>"add/$productdetailID/$productID"));
        else $this->redirect(array('controller' => 'Customimages','action'=>"edit/$productdetailID/$productID"));
    }

    function add($productdetailID,$productID) {    

    	
        $imgDetails = $this->Productdetail->findById($productdetailID);

        $customimagetypes= $this->Customimagetypes->find('all',array('conditions' => array('Customimagetypes.productid' => $productID)));
       // print_r($customimagetypes);
        $selArray["Select"]="Select";
        $selArray["Front"]="Front";
        
        if($imgDetails['Productdetail']['doublesided']=='Y' && !in_array("Rear",$customimagetypes['Customimagetypes']['type']))
        {
        	$selArray["Rear"]="Rear";
        	$insert['productid']=$productID;
        	$insert['type']="Rear";
        	$imgDetails['Productdetail']['doublesided']='X';
        	$this->Productdetail->save($imgDetails);
        	$this->Customimagetypes->create();
        	$this->Customimagetypes->save($insert);
        }
        
       
        

        
        if(!empty($customimagetypes))
        {
        	foreach($customimagetypes as $customimagetype)
        	{
        		$type=$customimagetype['Customimagetypes']['type'];
        		$selArray[$type]=$type;
        		
        	}
        }
        
      //  print_r($customimagetype);
       // exit();
        $customimagetypeswithimages = $this->Customimage->findallByproductdetails_id($productdetailID);
        
      
        
       // print_r($customimagetypeswithimages);
    
        if(!empty($customimagetypeswithimages))
        {
        	foreach($customimagetypeswithimages as $customimagetype)
        	{
        		$type=$customimagetype['Customimage']['type'];
        		if($selArray[$type]==$type)
        		{
        			unset($selArray[$type]);
        		}
        
        	}
        }
        

        
        $this->set("selArray",$selArray);       
     /*   if($imgDetails['Productdetail']['doublesided'] == 'N') {
            $this->redirect(array('controller' => 'Customimages','action'=>"edit/$productdetailID"));
            exit;
        }
*/
        if(empty($this->data)) {
            $regions = array();
            $img = $this->Customimage->findAllByProductdetailsId($productdetailID);
            if(is_array($img)) {
                foreach($img as $key=>$val) {
                    $regions[] = $img[$key]['Customimage']['type'];
                }
            }
            $sides = array('Y' => 'Double Sided', 'N' => 'Single Sided');

            $this->set('regions', $regions);
            $this->set('sides', $sides);
            $this->set('productdetail', $productdetailID);    
            $this->set('productid', $productID);
            $this->layout = 'adm';
        }
    }  
    
    function boxResize($path, $sourceFileName, $destFileName,$destination_path, $img_width, $img_height,$method,$bgcolor='FFFFFF')
    {
        
        $ObjImagehandle                         = new ImagehandleComponent();
        $ObjImagehandle->source_path            = $path.'/'.$sourceFileName;
        $ObjImagehandle->preserve_aspect_ratio  = true;
        $ObjImagehandle->enlarge_smaller_images = true;
        $ObjImagehandle->preserve_time          = true;  
        
        $ObjImagehandle->target_path = $destination_path.'/'.$destFileName;
        $ObjImagehandle =$ObjImagehandle->resize($img_width, $img_height,$method,$bgcolor);
        
    }     
       
    function uploadphoneOrder() {
    	 
    	
    	list($width,$height) = getimagesize($this->data['Customimage']['img_field']['tmp_name']);
    	 
    	$find = array(" ","(",")","{","}","!","&","*","#","[","]");
    	//$fileName = time().$this->data['Customimage']['img_field']['name'];
    	$fileName = time().str_replace($find, "_", $this->data['Customimage']['img_field']['name']);
    
    
    	/* if($width != $height ) {
    	 echo "ERROR: Image should be of Same Height and Width ";
    	exit;
    	}*/
    	if($width < 515 || $height < 515)
    	{
    		echo "ERROR: Image size should be atleast 515x515";
    		if($bulkupload)
    		{
    			$bulkupload_return['error_message']="Image size should be atleast 515x515";
    		}
    	}
    	else
    	{
    		
    		if(is_uploaded_file($this->data['Customimage']['img_field']['tmp_name']))
    		{
    			if(!move_uploaded_file($this->data['Customimage']['img_field']['tmp_name'], WWW_ROOT.IMAGES_URL.'customized_tshirts/'."$fileName") )
    			{
    				echo "ERROR: Sorry, an error occurred, please try again!";
    			}
    
    			else
    			{
    				 
    				$extension = strtolower(strrchr($fileName, '.'));
    				$filename_new=str_replace($extension,".png",$fileName);
    				 
    				system("convert -density 400 -units pixelsperinch ".WWW_ROOT.IMAGES_URL.'customized_tshirts/'.$fileName." ".WWW_ROOT.IMAGES_URL.'customized_tshirts/'.$filename_new);
    				 
    				if(!$extension==".png")
    				{
    					unlink(WWW_ROOT.IMAGES_URL.'customized_tshirts/'.$fileName);
    				}
    				$fileName=$filename_new;
    				$bulkupload_return['filename']=WWW_ROOT.IMAGES_URL.'customized_tshirts/'.$fileName;
    				/*$this->Resize->index( WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName");
    				 $this->Resize->resizeImage(515, 515, 'exact');
    				$this->Resize->saveImage( WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName", 100);
    				echo 'tshirts/'."$fileName";*/
    				$width = 515;  // changed to avoid white spaces
    				$height = 515;
    				$this->boxResize(WWW_ROOT.IMAGES_URL.'customized_tshirts/',$fileName,$fileName,WWW_ROOT.IMAGES_URL.'customized_tshirts/', $width, $height,"ZEBRA_IMAGE_BOXED");
    
    				
    					echo 'customized_tshirts/'."$fileName";
    				
    				}
    				}
    				
    			}
    			//----------ajax--------------//
    			Configure::write('debug', 0);
    			$this->autoRender = false;
    			exit;
    	}
    

    function upload($bulkupload=false,$imagedata=null) {
    	
    	$bulkupload_return['error_message']="sucess";

    	if($bulkupload)
    	{
    		$this->data['Customimage']['img_field']['tmp_name']=$imagedata['location'];
    		$this->data['Customimage']['img_field']['name']=" ".$imagedata['name'];
    		
    		
    	}
    	list($width,$height) = getimagesize($this->data['Customimage']['img_field']['tmp_name']);
               
        $find = array(" ","(",")","{","}","!","&","*","#","[","]");
        //$fileName = time().$this->data['Customimage']['img_field']['name'];
        $fileName = time().str_replace($find, "_", $this->data['Customimage']['img_field']['name']);
        
        
        /* if($width != $height ) {
            echo "ERROR: Image should be of Same Height and Width ";
            exit;
        }*/
        if($width < 515 || $height < 515) 
        	{
            	echo "ERROR: Image size should be atleast 515x515";
            	if($bulkupload)
            		{
            			$bulkupload_return['error_message']="Image size should be atleast 515x515";
            		}
        	}
        else
        	{
        		if($bulkupload)
        			{
        				copy($this->data['Customimage']['img_field']['tmp_name'], WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName");
        	
        			}
           				if(is_uploaded_file($this->data['Customimage']['img_field']['tmp_name']) || $bulkupload) 
           					{
                				if(!move_uploaded_file($this->data['Customimage']['img_field']['tmp_name'], WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName") && !($bulkupload)) 
                					{
                    					echo "ERROR: Sorry, an error occurred, please try again!";
                					}
                
                				else 
                					{ 
                	
                						$extension = strtolower(strrchr($fileName, '.'));
                						$filename_new=str_replace($extension,".png",$fileName);
                	
                						system("convert -density 400 -units pixelsperinch ".WWW_ROOT.IMAGES_URL.'tshirts/'.$fileName." ".WWW_ROOT.IMAGES_URL.'tshirts/'.$filename_new);
                	
                						if(!$extension==".png")
                							{
                								unlink(WWW_ROOT.IMAGES_URL.'tshirts/'.$fileName);
                							}
                						$fileName=$filename_new;
                	                	$bulkupload_return['filename']=WWW_ROOT.IMAGES_URL.'tshirts/'.$fileName;
                	/*$this->Resize->index( WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName");
                	$this->Resize->resizeImage(515, 515, 'exact');
                	$this->Resize->saveImage( WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName", 100);
                	echo 'tshirts/'."$fileName";*/ 
                   	$width = 515;  // changed to avoid white spaces
                    $height = 515;
                    $this->boxResize(WWW_ROOT.IMAGES_URL.'tshirts/',$fileName,$fileName,WWW_ROOT.IMAGES_URL.'tshirts/', $width, $height,"ZEBRA_IMAGE_BOXED");
                    
                    if(!$bulkupload)
                    {
                    echo 'tshirts/'."$fileName";  
                    }                
                }
            }
            if($bulkupload)
            {
            return $bulkupload_return;
            }
        }
        //----------ajax--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    function customupload($flag) {
        $sess_arr = $this->Session->read('Userlog');
        $uname = $sess_arr['uname'];
        if($uname==''){
              $admsess	=	$this->Session->read('Admin');
              $uname = $admsess['admin_name'];
        }
        if($uname == '') $uname = "temp";
        $udirectory = WWW_ROOT.IMAGES_URL."editorimages/$uname";

        // make a directory for the user [if there isnt one]
        if(!is_dir($udirectory)) mkdir($udirectory,0777);

        // upload the file
        list($width,$height) = getimagesize($this->data['Customimage']['user_image']['tmp_name']);
        $fileName = time().$this->data['Customimage']['user_image']['name'];
        
        if($width < 100 || $height < 100) {
            echo "ERROR: Image size should be atleast 100x100 for best results.";
        }
        else {
           $fileName = time().$this->data['Customimage']['user_image']['name'];

                // create a random png filename
                $pngName = time().rand(0, 9999).'.png';
            if(is_uploaded_file($this->data['Customimage']['user_image']['tmp_name'])){
                    
            	if($flag)
            	{
            	
            		system("convert ".$this->data['Customimage']['user_image']['tmp_name']." -filter point -fuzz 10% -transparent white ".$udirectory."/".$pngName);
            		system("convert ".$this->data['Customimage']['user_image']['tmp_name']." -filter point -fuzz 10% -transparent white  ".$udirectory."/tmb_".$pngName);
            	
            		 
            	}
            	else
            	{
            		system("convert ".$this->data['Customimage']['user_image']['tmp_name']." ".$udirectory."/".$pngName);
            		system("convert ".$this->data['Customimage']['user_image']['tmp_name']." ".$udirectory."/tmb_".$pngName);
            	}
                $session_images = $this->Session->read('session_images');
                if($uname == "temp")
                {
                    
                    $session_images[]="editorimages/temp/tmb_".$pngName;
                    $this->Session->write('session_images', $session_images);
                }
                
                    system("convert ".$udirectory."/tmb_".$pngName."  -resize 100x100! ".$udirectory."/1024_tmb_".$pngName);
                    //system("convert ".$udirectory."/tmb_".$pngName."  -resize 50x50! ".$udirectory."/tmb_".$pngName);
                    
                    
                    
                    $new_width = 50;  // changed to avoid white spaces
                    $new_height = 50;
                    if($width>$height){
                        $propHeight = $this->Resize->getHeightByFixedWidth($new_width, $width, $height);
                        $propWidth = $new_width;
                    }
                    else{
                        $propWidth = $this->Resize->getWidthByFixedHeight($new_height, $width, $height);
                        $propHeight = $new_height;
                    }

                    system("convert ".$udirectory."/tmb_".$pngName."  -resize ".$propWidth."x".$propHeight."! ".$udirectory."/tmb_".$pngName);
                    
                    
                    echo "editorimages/$uname/tmb_".$fileName;
		}
            
            
           
        }
        //----------ajax--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    function edit($productdetailID,$productID) {
        $imgDetails = $this->Productdetail->findById($productdetailID);
      //  $this->set('side', $imgDetails['Productdetail']['doublesided']);       

        if(empty($this->data)) {
            $regions = array();
            $customimagetypes= $this->Customimagetypes->find('all',array('conditions' => array('Customimagetypes.productid' => $productID)));
            $regions["Front"]="Front";
           
            

            if($imgDetails['Productdetail']['doublesided']=='Y' && !in_array("Rear",$customimagetypes['Customimagetypes']['type']))
            {
            	$regions["Rear"]="Rear";
            	$insert['productid']=$productID;
            	$insert['type']="Rear";
            	$imgDetails['Productdetail']['doublesided']='X';
            	$this->Productdetail->save($imgDetails);
            	$this->Customimagetypes->create();
            	$this->Customimagetypes->save($insert);
            }
            
            
            if(!empty($customimagetypes))
            {
            	foreach($customimagetypes as $customimagetype)
            	{
            		$type=$customimagetype['Customimagetypes']['type'];
            		$regions[$type]=$type;
            
            	}
            }
            $this->set('regions', $regions);
            $this->set('productdetail', $productdetailID);
            $this->set('productid',$productID);
            $this->layout = 'adm';            
        }
        else {
            $img = explode("/",$this->data["Customimage"]["image_path"]);
            $img1=end($img);
            $img2=explode(".",$img1);
            $imgNam=$img2[0];    
            $defaultVal     =($this->data["Customimage"]["image_type"]=="Front")?"Y":"N";
            $imgArray       = explode(".",$this->data["Customimage"]["image_path"]);
            $imgExt         = strtolower(end($imgArray));               
            $thumbfileName  = $imgNam."_thumb".".".$imgExt;
            $dispfileName   = $imgNam."_disp".".".$imgExt;          
            $fileName       = $imgNam.".".$imgExt;              
                   
            //-------------update customimages table------------------------//            
            //$this->Customimage->read(null, $this->data["Customimage"]["edit_id"]);
            //$this->Customimage->set('image', $this->data["Customimage"]["image_path"]);
            //$this->Customimage->save();
           
            //-------------update productimages table and productdetails table----//          
            
            //$thumbfileName = time()."_thumb".".".$imgExt;
            //$dispfileName = time()."_disp".".".$imgExt;
            //$fileName = time().".".$imgExt;  

            copy(WWW_ROOT.IMAGES_URL.$this->data["Customimage"]["image_path"],WWW_ROOT.IMAGES_URL."products/".$fileName);

            $this->Resize->index(WWW_ROOT.IMAGES_URL.$this->data["Customimage"]["image_path"]);
            $this->Resize->resizeImage(170, 170, 'exact');
            $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$dispfileName, 100);
            
            // changed to avoid white spaces
            /* $width  = 170;
             $height = 170;
             $this->boxResize(WWW_ROOT.IMAGES_URL.'products/',$fileName,$dispfileName,WWW_ROOT.IMAGES_URL.'products/', $width, $height,"ZEBRA_IMAGE_BOXED");*/

            $this->Resize->index(WWW_ROOT.IMAGES_URL.$this->data["Customimage"]["image_path"]);
            $this->Resize->resizeImage(48, 48, 'exact');
            $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$thumbfileName, 100);
             
             /*$width_thumb  = 48;   // changed to avoid white spaces
             $height_thumb = 48;
             $this->boxResize(WWW_ROOT.IMAGES_URL.'products/',$fileName,$thumbfileName,WWW_ROOT.IMAGES_URL.'products/', $width_thumb, $height_thumb,"ZEBRA_IMAGE_BOXED");*/
             
            $this->Customimage->updateCustomimages($this->data["Customimage"]["image_path"],$this->data["Customimage"]["edit_id"]);           
             if($defaultVal=="Y")
                $this->Customimage->updateProductDetails($fileName,$this->data["Customimage"]["proddetail_id"],$this->Session->read('prodID'));
            $this->Customimage->updateProductimages($this->Session->read('prodID'));    
            //------------update coordinates table-----------------------//
            $this->Customimage->updatecoords($this->data["Customimage"]["edit_id"],$this->data["Customimage"]["coord_top"],$this->data["Customimage"]["coord_left"]);

            $this->Session->setFlash('Image details have been updated.', 'default',array('class'=> 'success'));
            $prodid = $this->Session->read('prodID');
            $catid = $this->Session->read('catID');
            $this->Session->delete('prodID');
            $this->Session->delete('catID');
            $this->redirect(array('controller' => 'Products', 'action' => "edit/$prodid/$catid"));
        }
    }

    function editdetails($imgType,$productdetailID) {
        if ($this->RequestHandler->isAjax()) {
            $details = $this->Customimage->getData($imgType,$productdetailID);
            echo $details['Customimage']['image']."#".$details['Coordinate']['x1_axis'].','.$details['Coordinate']['y1_axis']."#".$details['Coordinate']['x2_axis'].','.$details['Coordinate']['y2_axis']."#".$details['Customimage']['id'];
            //-----------ajax features--------------//
            Configure::write('debug', 0);
            $this->autoRender = false;
            exit;
        }
    }

    function saveform() {
       
        if(!empty($this->data)) {
 
        	
            //---------------save to coordinates table-----------------------//
            $coords1 = explode(',',$this->data["Customimage"]["coord_top"]);
            $this->Coordinate->saveField('x1_axis',$coords1[0]);
            $this->Coordinate->saveField('y1_axis',$coords1[1]);

            $coords2 = explode(',',$this->data["Customimage"]["coord_left"]);
            $this->Coordinate->saveField('x2_axis',$coords2[0]);
            $this->Coordinate->saveField('y2_axis',$coords2[1]);
            $coordID = $this->Coordinate->id;

            //-------------save to customimages table------------------------//
            $this->Customimage->saveField('productdetails_id',$this->data["Customimage"]["proddetail_id"]);
            $this->Customimage->saveField('type',$this->data["Customimage"]["image_type"]);
            $this->Customimage->saveField('image',$this->data["Customimage"]["image_path"]);
            $custimgID = $this->Customimage->id;

            //--------------------save to imageregions table---------------//
            $this->Imageregion->saveField('customimages_id',$custimgID);
            $this->Imageregion->saveField('coordinates_id',$coordID);

            //---------------------update products table------------------//
           /* $imgArray = explode(".",$this->data["Customimage"]["image_path"]);
            $imgExt = strtolower(end($imgArray));
            $thumbfileName = time()."_thumb".".".$imgExt;
            $dispfileName = time()."_disp".".".$imgExt;
            $fileName = time().".".$imgExt;*/
            
            /*******************/
            $img = explode("/",$this->data["Customimage"]["image_path"]);
            $img1=end($img);
            $img2=explode(".",$img1);
            $imgNam=$img2[0];           
            $imgArray       = explode(".",$this->data["Customimage"]["image_path"]);
            $imgExt         = strtolower(end($imgArray));               
            $thumbfileName  = $imgNam."_thumb".".".$imgExt;
            $dispfileName   = $imgNam."_disp".".".$imgExt;  
            $sliderfileName   = $imgNam."_slider".".".$imgExt;
            $fileName       = $imgNam.".".$imgExt;             
            /**********************/

            copy(WWW_ROOT.IMAGES_URL.$this->data["Customimage"]["image_path"],WWW_ROOT.IMAGES_URL."products/".$fileName);

            $this->Resize->index(WWW_ROOT.IMAGES_URL.$this->data["Customimage"]["image_path"]);
            $this->Resize->resizeImage(170, 170, 'exact');
            $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$dispfileName, 100);
            
           /* $width  = 170;  // changed to avoid white spaces
            $height = 170;
            $this->boxResize(WWW_ROOT.IMAGES_URL.'products/',$fileName,$dispfileName,WWW_ROOT.IMAGES_URL.'products/', $width, $height,"ZEBRA_IMAGE_BOXED");*/
            

            $this->Resize->index(WWW_ROOT.IMAGES_URL.$this->data["Customimage"]["image_path"]);
            $this->Resize->resizeImage(48, 48, 'exact');
            $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$thumbfileName, 100);
            
            /*$width_thumb  = 48;  // changed to avoid white spaces
            $height_thumb = 48;
            $this->boxResize(WWW_ROOT.IMAGES_URL.'products/',$fileName,$thumbfileName,WWW_ROOT.IMAGES_URL.'products/', $width_thumb, $height_thumb,"ZEBRA_IMAGE_BOXED");*/
            
            $this->Customimage->updateProduct($this->data["Customimage"]["proddetail_id"], $this->data["Customimage"]["image_type"], $fileName);

            $this->Session->setFlash('Image details have been saved.', 'default',array('class'=> 'success'));

            $prod_detailid = $this->data["Customimage"]["proddetail_id"];

            //update the productdetail table
            $data['Productdetail']['doublesided']   = $this->data["Customimage"]["doublesided"];
            $data['Productdetail']['id']            = $this->data["Customimage"]["proddetail_id"];
            
            $this->Productdetail->save($data);

         

            // redirect to products page if both images have been added, else, send to add page itself
            $imgCount_actual = $this->Customimagetypes->findCount("Customimagetypes.productid = {$this->data['Customimage']['productid']}");
        	
           // echo $this->data['Customimage']['productid'];
          
            
            $imgCount = $this->Customimage->findCount("productdetails_id = {$this->data['Customimage']['proddetail_id']}");
            
            if($imgCount < ($imgCount_actual+1)) 
            {
               $this->redirect(array('controller' => 'Customimages', 'action' => "add/{$this->data['Customimage']['proddetail_id']}/{$this->data['Customimage']['productid']}"));
            }
            
            else {
                $prodid = $this->Session->read('prodID');
                $catid = $this->Session->read('catID');
                $this->Session->delete('prodID');
                $this->Session->delete('catID');
                $this->redirect(array('controller' => 'Products', 'action' => "edit/$prodid/$catid"));
            }
        }
    }
    

    function goback() {
        $prodid = $this->Session->read('prodID');
        $catid = $this->Session->read('catID');
        $this->Session->delete('prodID');
        $this->Session->delete('catID');
        $this->redirect(array('controller' => 'Products', 'action' => "edit/$prodid/$catid"));
    }

    function getimglink($combID) {
        if ($this->RequestHandler->isAjax()) {
            $regions = array("Front" => 'noimages.gif', "Rear" => 'noimages.gif');
            $img = $this->Customimage->findAllByProductdetailsId($combID);
            if(is_array($img)) {
                foreach($img as $key=>$val) {
                    $regions[$img[$key]['Customimage']['type']] = $img[$key]['Customimage']['image'];
                }
            }
            echo implode("#",$regions);
            //-----------ajax features--------------//
            Configure::write('debug', 0);
            $this->autoRender = false;
            exit;
        }
    }

    function rotateImage($combID, $frontRear, $timestamp) {
        /*
             * Depricated functionality
        */
    }

    function userdesigns($redirect = 0) {        
        Configure::write('debug', 0);
        
        $this->__validateLoginStatus('U');
        
        $sess_arr = $this->Session->read('Userlog');
        if(isset($sess_arr) && empty($sess_arr)===false){     
          $this->set('sus', $sess_arr);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sess_arr['id'])));  
        }  
        else {
          $this->set('sus', ''); 
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid))); 
        }
        $this->set('cartcount', count($citem));
        $uid = $sess_arr['id']; 
        //-----------fix to fill front/rear images in only 1 is present-------------//
        $this->Customimage->resetTable($uid);

        //-------------generate image for unsaved sides of images--------------//
        $imageArray = $this->Customimage->removeTemp($uid);     

        $facebookKeys='';
        if($this->Session->check('facebookKey')) {
            $facebookKeys=$this->Session->read('facebookKey');
        }
        $this->set('facebookKey', $facebookKeys);

        $twitterKeys='';
        if($this->Session->check('twitterKey')) {
            $twitterKeys=$this->Session->read('twitterKey');
        }
        $this->set('twitterKey', $twitterKeys);    
                
        if(is_array($imageArray)) {
            
            foreach($imageArray as $images) {
                
                if(!empty($images['design_items'])) {
                    //------------------background image--------------------//
                    $editedImg = $this->Customize->index($images['image_path']);
                    foreach($images['design_items'] as $designs) {
                        
                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);
                        
                    }

                    //--------------------foreground image-----------------//
                    $editedImg_blank = $this->Customize->index("blank.png", true);
                    
                    foreach($images['design_items'] as $designs) {
                        
                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);
                        
                    }
                }
                else {
                    $editedImg = $this->Customize->index($images['image_path']);
                    $editedImg_blank = $this->Customize->index("blank.png", true);
                    
                    copy(WWW_ROOT.IMAGES_URL.$images['image_path'], WWW_ROOT.IMAGES_URL.$editedImg);
                    copy(WWW_ROOT.IMAGES_URL."blank.png", WWW_ROOT.IMAGES_URL.$editedImg_blank);
                }
                
                $this->Customimage->updateSaveImage($editedImg, $editedImg_blank, $images['id']);
                
            }
            
        }

        if($redirect == 1) {
            $this->redirect(array('controller' => 'carts', 'action' => "show"));
            exit;
        }elseif($redirect == 2) {            
            $this->redirect(array('controller' => 'orders', 'action' => "myorder/sendtoadmin/sucess"));
            exit;
        }

        $perPage = 10;
        isset($_GET['page']) ? $cur = $_GET['page'] - 1 : $cur = 0;
        $totalRecs = $this->Customimage->userDesignImagesCount($uid);
        $max = ceil($totalRecs/$perPage);
        $pagingArray = array('cur' => $cur, 'max' => $max);
        $this->set("pagingArray", $pagingArray);
        $designOrder = array();
        $imgList = $this->Customimage->userImages($uid, $perPage, $cur); 

        $uneditableList = $this->Customimage->pendingorders($uid);
        if($uneditableList) {
            foreach($uneditableList as $val) $uneditableArray[] = $val['SAV']['id'];
        }
        else $uneditableArray[0] = 0;
        
        $cartimageList = $this->Customimage->designsincart($uid);
        
        if($cartimageList) {
            foreach($cartimageList as $val) $cartimageArray[] = $val ['PrintLogic_carts']['savedimages_id'];
        }
        else $cartimageArray[0] = 0;
         $designOrderList = $this->Customimage->designOrder($uid);
        if($designOrderList) {
            foreach($designOrderList as $val) $designOrder[] = $val ['odt']['savedimages_id'];
        }else $designOrder[0] = 0;
        //print_r($cartimageArray);exit;
        $this->set("imgList", $imgList);
      // echopre($imgList);
        $this->set("uneditableArray", $uneditableArray);
        $this->set("cartimageArray", $cartimageArray);
        $this->set("designOrder", $designOrder);
    }
    //**********Paint Bucket & Texture **************//
    
    // Function to display paint bucket
    function paintbucket(){
        $img        = $_GET['imgid'];
        $width1     = $_GET['width1'];
        $height1    = $_GET['height1'];
        $showTexture        = $_GET['showTexture'];
         if($img != '') {
            $img = str_replace('%20', ' ',$img);
            $parts = explode("/",$img);
            $image = '';

            $count = count($parts);

            $parentDir = $parts[$count - 2];
            $imageName = $parts[$count - 1];
            $imageName = '1024_'.$imageName;
        }

        $palette = $this->Palette->find('all', array('conditions' => array('Palette.status' => '1'), 'orderby' => array('Palette.id')));
        $palette_colors = '';
        foreach ($palette as $paletteVal) {
            $palette_colors .= "'" . $paletteVal['Palette']['color'] . "',";
        }

        $palette_colors = substr($palette_colors, 0, strlen($palette_colors) - 1);

        $textureImgArr = $this->getTexture(); //print_r($textureImgArr); exit;
        $this->set('textureImgs', $textureImgArr);
      //  die($parentDir);
        $this->set('imagename', $imageName);
        $this->set('showTexture', $showTexture);

       // $this->set('imagename', $image);
        $this->set('foldername', $parentDir);
        $this->set('width1', $width1);
        $this->set('height1', $height1);
        $this->set('palette_colors', $palette_colors);
        $this->layout = 'ajax';

    }

    // Fill the color to image in x y cordinatess
    function paintFloodFill(){
       extract($_POST);
       $res_image = rand(0,9999).'_'.$parentimg;

        if($fillColor != '' && $fillX != '' && $fillY != '') {

        if($isTexture){ // User selected texture
            $fillColor = WWW_ROOT.IMAGES_URL.'editorimages/Texture/'.$fillColor; // $fillColor is texture image name.
        }

        //system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/'.$folder.'/'.$img." -fuzz 10% -fill '$fillColor' -draw \"color $fillX,$fillY floodfill\" ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image);
        //system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$folder.'/'.$img.' -fuzz 10% -fill "'.$fillColor.'" -draw "color '.$fillX.','.$fillY.' floodfill" '.WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image);
        system("convert ".WWW_ROOT.IMAGES_URL."editorimages/$folder/$img -fuzz 10% -fill \"$fillColor\" -draw \"color $fillX,$fillY floodfill\" ".WWW_ROOT.IMAGES_URL."editorimages/customized/".$res_image);

        $response['folder'] =  'customized';
        $response['img'] =  $res_image;
        $cnfg           = Configure::read('Neutrino');
        $destLocation   = $cnfg["sitebasefolder"] . '/' . IMAGES_URL .'editorimages/customized/' . $res_image;
        $response['imgPath'] = $destLocation;
        } else {
            $response['img'] = 'fail';
        }
        echo json_encode($response); exit;
    }
    
    // Function to save image after flood fill
    function savefloodfillimage(){
        if (isset($_POST['btnFloodFill'])) {
            $image          = $_POST['imgname'];
            $signature      = explode(".", $_POST['parentimgname']);

            $parentDir      = $_POST['foldername'];

            $newimage_main  = $signature[0] . '_FLOOD_' . rand(0, 999) . '.png';

            $newimage_tmb   = 'tmb_' . $newimage_main;

            $width          = trim($_POST['width1']);
            $height         = trim($_POST['height1']);

            $modwidth       = $width/50;
            $modheight      = $height/50;
           
            $org_width      = ($modwidth*4)+50;
            $org_height     = ($modheight*4)+50;

            $org_width      = $width;
            $org_height     = $height;

            // copy image to floodfill folder
            system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/'.$parentDir.'/'.$image."   ".WWW_ROOT.IMAGES_URL.'editorimages/floodfill/'.$newimage_main);

            //resize the image to 50x50
            system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/'.$parentDir.'/'.$image."  -resize ".$org_width."x".$org_height."! ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb);

            system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb."  -resize ".($org_width*2)."x".($org_height*2)."! ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$newimage_tmb);

            $cnfg           = Configure::read('Neutrino');
            $destLocation   = $cnfg["sitebasefolder"] . '/' . IMAGES_URL .'editorimages/customized/' . $newimage_tmb;
            ?>
            <script>
            // call parent function to close the popup
            window.parent.closeFloodFillBox('<?php echo $destLocation;?>');
            </script>
            <?php
        }
    	exit;
    }
    //********* Paint Bucket & Texture ***********//
    
    // function to create image cropping
    function imagecropper() 
    {
        
    	$img = $_GET['imgid'];
        $color= $_GET['color'];
         $rotate= $_GET['rotate'];
        $width1= $_GET['width1'];
        $height1 = $_GET['height1'];
        
        
    	if($img != '') {            
            $img = str_replace('%20', ' ',$img);
            $parts = explode("/",$img);
            $image = '';

            $imgParts = explode("_",$parts[count($parts)-1]);
            for($i = 1; $i < count($imgParts); $i++) {
                if($i <> count($imgParts)-1) $image .= $imgParts[$i]."_";
                else $image .= $imgParts[$i];
            }
        
    	    $parentDir = $this->__findParentDir($image);
            $imageName = str_replace('tmb_', '', $image);
            $parentImage = $parentDir == 'cropimages' ? 'original_' . $imageName : '';
            
            $original = array('width' => '', 'height' => '');
            $crop     = array('width' => '', 'height' => '');
            
            /*list($crop['width'], $crop['height']) = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$parentDir.'/'.$imageName);
            if($parentImage <> ''){
                list($original['width'], $original['height']) = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$parentDir.'/'.$parentImage);
            }*/
            
            if(isset($_SESSION[$imageName])){
                $coords = $_SESSION[$imageName];
            }
            elseif(isset($_SESSION[$parentImage])){
                $coords = $_SESSION[$parentImage];
            }
            else{
                $coords = array();
            }
            
    	    $this->set('imagename', $imageName);
            $this->set('foldername', $parentDir);  
            $this->set('parentimagename', $parentImage);  
            //$this->set('imagesize', $crop);  
            //$this->set('originalimagesize', $original);  
            $this->set('coords', $coords);
            $this->set('color', $color);
            $this->set('rotate', $rotate);
            $this->set('width1', $width1);
            $this->set('height1', $height1);
    	}
        $this->layout = 'ajax';

    }    
    
    // function to create the crop image
    function savecropimage() {
        if (isset($_POST['btncropimg'])) {
            $image = $_POST['imgname'];
            $signature = explode(".", $image);

            $parentDir = $_POST['foldername'];

            $newimage_main = $signature[0] . 'CROP_IMG' . rand(0, 99999) . '.png';

            $newimage_tmb  = 'tmb_' . $newimage_main;
            $newimage_ref  = 'original_' . $newimage_main;
            
            $color  = $_POST['color'];
            $rotate  = $_POST['rotate'];
            $top    = trim($_POST['y']);
            $left   = trim($_POST['x']);
            $width  = trim($_POST['w']);
            $height = trim($_POST['h']);
           
            
            //$org_width = trim($_POST['width1']);
            //$org_height = trim($_POST['height1']);
            
            //copy the main file to crop folder
            system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/'.$parentDir.'/'.$image." ".WWW_ROOT.IMAGES_URL.'editorimages/cropimages/'.$newimage_main);
            
            //keep a copy of the original
            system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/cropimages/'.$newimage_main." ".WWW_ROOT.IMAGES_URL.'editorimages/cropimages/'.$newimage_ref);
            
            //crop the image
            system("convert -crop ".$width."x".$height."+".$left."+".$top." ".WWW_ROOT.IMAGES_URL.'editorimages/cropimages/'.$newimage_main." ".WWW_ROOT.IMAGES_URL.'editorimages/cropimages/'.$newimage_main);
            $_SESSION[$newimage_main]['left']    = $left;
            $_SESSION[$newimage_main]['top']     = $top;
            $_SESSION[$newimage_main]['width']   = $width;
            $_SESSION[$newimage_main]['height']  = $height;
            
            $modwidth = $width/50;
            $modheight = $height/50;
           
//            $org_width = ($modwidth*4)+50;
//            $org_height = ($modheight*4)+50;
            
            $org_width = $_POST['width1'];
            $org_height = $_POST['height1'];
            
            //resize the image to 50x50
            system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/cropimages/'.$newimage_main."  -resize ".$org_width."x".$org_height." -background None -rotate $rotate! ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb);
            
            
//echo "convert ".WWW_ROOT.IMAGES_URL.'editorimages/cropimages/'.$newimage_main."  -resize ".$org_width."x".$org_height."! ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb; exit;
           if($color!='000000'){
            system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb." -colorspace Gray -fill black  -tint 100 -modulate 110,100,100 ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb);
                system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb." +level-colors '#".$color."', ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb);
           }
            
           system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb."  -resize ".($org_width)."x".($org_height)."! ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$newimage_tmb);
           
           
          
//             system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage_tmb."   ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$newimage_tmb);
//             
               
           
           
           
            $cnfg           = Configure::read('Neutrino');
            $destLocation   = $cnfg["sitebasefolder"] . '/' . IMAGES_URL .'editorimages/customized/' . $newimage_tmb;
            ?>
            <script>
            // call parent function to close the popup
            window.parent.closeCropBox('<?php echo $destLocation;?>','<?php echo $org_width;?>','<?php echo $org_height;?>');
            </script>
            <?php  
        }
    	exit;
    }
    

    function userlogin() {
        if(!empty($this->data)) {
            $isValid = $this->Customimage->validateLogin($this->data['Customimage']['username'], md5($this->data['Customimage']['password']), $this->Session->id());

            if($isValid) {
                $this->Session->write('Userlog', $isValid);

                ?> 

<body onLoad="parent.onCloseSubmit()"></body>



                <?php
                //-----------ajax features--------------//
                Configure::write('debug', 0);
                $this->autoRender = false;
                exit;
            }
            else {
                $this->Session->setFlash('Sorry, Invalid Username / Password.', 'default',array('class'=> 'failure'));

                $this->redirect(array('controller' => 'Customimages', 'action' => "userlogin"));
                exit;
            }
        }
        $this->layout = 'ajax';

    }
    /********************/
    
    function addimagesides()
    {
    	
    	
    	//Validation Here
    	
       $productdetailID=$this->data['Customimage']["proddetail_id"];
       $productID=$this->data['Customimage']["productid"];
      
       
       
       $customimagetype= $this->Customimagetypes->find('all',array('conditions' => array('Customimagetypes.productid' => $this->data['Customimage']["productid"],
                            																			'Customimagetypes.type' => $this->data['Customimage']['image_side']
       																					)
       																)
       													);
       
				             // print_r($dups_val);
    	if(empty($customimagetype))
    	{
    		$data_customimage['productid']=$productID;
    		$data_customimage['type']=ucfirst($this->data['Customimage']['image_side']);
    		$this->Customimagetypes->create();
    		$this->Customimagetypes->save($data_customimage);
    		$this->Session->setFlash('Custome Side For Product added sucessfully', 'default',array('class'=> 'success'));
    		
    	}
    	else
    	{
    		  $this->Session->setFlash('Custome Side already Exist', 'default',array('class'=> 'failure'));
    		
    	}
    	
    	$imgCount_actual = $this->Customimagetypes->findCount("Customimagetypes.productid = $productID");
    	$imgCount = $this->Customimage->findCount("productdetails_id = $productdetailID");
    	
    	if($imgCount < ($imgCount_actual+1)) $this->redirect(array('controller' => 'Customimages','action'=>"add/$productdetailID/$productID"));
    	else $this->redirect(array('controller' => 'Customimages','action'=>"edit/$productdetailID/$productID"));
    	
    	exit();
    	
    }
    
    function userloginnew($productdetailId,$flag) {        
               //echo $flag.' dddd ';
       $productDetails = $this->Productdetail->findById($productdetailId);      
       $productId = $productDetails['Productdetail']['product_id'];
       $imageName = $productDetails['Productdetail']['pdctfile'];
       $prod = $this->Product->findById($productId);
       $productname= $prod['Product']['pname'];
       $this->set("imageName", $imageName);
       $this->set("productname", $productname);
       $this->set("product_detailId", $productdetailId);
       $this->set("flagz", $flag);
       
        if($_REQUEST['userid']=="new") { 
          /*************************/
            $usse = $this->User->findByEmail($_REQUEST['email']);
            
            if (!empty($usse['User']['uname'])) {

                //$this->Session->setFlash('Email Address Already Exists!', 'default',array('class'=> 'failure'));
                //$this->redirect(array('controller' => 'Customimages', 'action' => "userregister"));
                echo "Email already exists, Please click existing user link to login.";
                exit;

            }
            else {
                $this->data["Customimage"]["uname"]   = $_REQUEST["uname"];
                $this->data["Customimage"]["email"]   = $_REQUEST["email"];
                $this->data["Customimage"]["password"]=$this->data["Customimage"]["uname"]."1234";
                $this->data["Customimage"]["reg_date"]= date("Y-m-d");
                $this->data["Customimage"]["usertype"]= "retail";
                $this->data["Customimage"]["reg_status"]= "R";
                $this->data["Customimage"]["uphone"]= $_REQUEST["phone"];                
                $this->Customimage->toAdminSave($this->data);
                //----------------------------email-----------------------------------//
                $cnfg 			=	Configure::read('Neutrino');
                $subject 		= "Registration complete at ".$cnfg["site_name"];

                $headers 		= "MIME-Version: 1.0\r\n";
                $headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
                $headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
                $headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
                $headers        .= "Organization: ".$cnfg["site_name"]."\r\n";
                $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

                $pdt 			= 	$this->Cmspage->findByTitle('Registration confirm mail');
                $path			=	"SiteLogo_disp.gif";
                $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
		  		<tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr></table>";

                $cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";
                $logurl		= "Click <a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/users/login' target='_blank'>here </a>to login";

                $mailcontent	=	$mcont.$pdt["Cmspage"]["content"];
                $mailcontent 	= str_replace("[User_Name]", $this->data["Customimage"]["uname"], $mailcontent);
                $mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);
                $mailcontent 	= str_replace("[PASSWORD]", $this->data['Customimage']['password'], $mailcontent);
                $mailcontent 	= str_replace("[LOGIN_URL]", $logurl, $mailcontent);

                $pdtad 			= 	$this->Cmspage->findByTitle('Registration intimation mail to admin');
                $mailcontentad	=	$pdtad["Cmspage"]["content"];
                $mailcontentad 	= str_replace("[User_Name]", $this->data["Customimage"]["uname"], $mailcontentad);
                $mailcontentad 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontentad);

                $mailsent 		= mail($this->data["Customimage"]["email"],$subject,$mailcontent,$headers);
                $mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontentad,$headers);
                 //----------------------------email end----------------------------------//

                $isValid = $this->Customimage->validateLogin($this->data['Customimage']['uname'], md5($this->data['Customimage']['password']), $this->Session->id());
                $this->Session->write('Userlog', $isValid);
                $uname = $_REQUEST[uname];
               
            }
          /****************************/  
        }elseif($_REQUEST['userid']!=''){  
            $this->data["Customimage"]['username'] = $_REQUEST["uname"];
            $this->data['Customimage']['password'] = $_REQUEST["password"]; 
            $uname = $this->data["Customimage"]['username'];
            $isValid = $this->Customimage->validateLogin($this->data['Customimage']['username'], md5($this->data['Customimage']['password']), $this->Session->id());

            if($isValid) {
                $this->Session->write('Userlog', $isValid);
               }  
            else {
                echo "<div style='color:red'>Invalid Credentials</div>";
                exit;
                }
           /* $this->data["Customimage"]["uphone"]= $this->data["Customimage"]["phone"];  
            $this->Customimage->UpdateUserDetail($this->data);*/
            
            echo "<script type='text/javascript'>";         
            echo "parent.onCloseSubmit('$uname')";
            echo "</script>";
            echo " ";exit;  
        }    
        
        $this->layout = 'ajax';

    }
     /********* validate login for send to admin****/
    function orderuserlogin($productdetailId,$action=NULL) {       
       
       $productDetails = $this->Productdetail->findById($productdetailId);      
       $productId = $productDetails['Productdetail']['product_id'];
       $imageName = $productDetails['Productdetail']['pdctfile'];
       $prod = $this->Product->findById($productId);       
       $productname= $prod['Product']['pname'];
       $productDescription= $prod['Product']['descr'];
       $productPrice= $prod['Product']['price'];
       $this->set("imageName", $imageName);
       $this->set("productDescription", $productDescription);
       $this->set("productdetailId", $productdetailId);
       $this->set("productname", $productname);
       $this->set("userstatus", 0);
       /******************* combination images ***********************/             
            $prod_details = $this->Productdetail->findById($productdetailId);
            $prod = $this->Product->findById($prod_details['Productdetail']['product_id']); // u need to get the default attr
            $defaultattr = $prod['Product']['defaultattribute'];
            $custvalues = $this->Customfieldvalue->findAllByCustomfieldId($defaultattr);
            foreach($custvalues as $key => $val) {
                $cfArray[] = $val['Customfieldvalue']['id'];
            }
           
            $this->set('doublesided', $prod_details['Productdetail']['doublesided']);

            $tArray = explode(",", $prod_details['Productdetail']['customvalue_id']);
            foreach($tArray as $val) {
                if(in_array($val, $cfArray)) $setParam = $val;
            }
           
            $prod_comb = $this->Productdetail->findAllByProductId($prod_details['Productdetail']['product_id']);
           
            $paramVal = $this->Customfieldvalue->findById($setParam);
            
            $this->set('defaultvalue', $paramVal['Customfieldvalue']['custom_value']);
            foreach($prod_comb as $k => $v) {
                $name = '';

                $tArray2 = explode(",", $v['Productdetail']['customvalue_id']);               
                if(in_array($setParam, $tArray2)) {                   
                    $res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], 2);
                    
                    $j = 1;                    
                    foreach($res as $k2 => $v2) {
                        if(count($res) <> $j) $name .= $v2['CFV']['custom_value'].',';
                        else $name .= $v2['CFV']['custom_value'];
                        $j++;
                    }
                    $combArray[$v['Productdetail']['id']] = $name;
                    $stockArray[$v['Productdetail']['id']] = $v['Productdetail']['stock'];
                }
            }
         $this->set("combArray",$combArray);

        /***************combination images ends ********************/
       
        $first_imagecost = $this->Setting->findByFieldname('first_image');
        $addn_imagecost = $this->Setting->findByFieldname('addn_image');
        $first_textcost = $this->Setting->findByFieldname('first_text');
        $addn_textcost = $this->Setting->findByFieldname('addn_text');

        $this->set("first_imagecost",$first_imagecost['Setting']['value']);
        $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
        $this->set("first_textcost",$first_textcost['Setting']['value']);
        $this->set("addn_textcost",$addn_textcost['Setting']['value']);        
      
       
         //-------------------Get the entries from the settings table---------------------------------
        $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
        $curr	=	$this->Currency->findByCode($data["currency"] );
        $this->set('pcurr', $curr["Currency"]["logo"]);
        $this->set('action', $action);
       
            
     /* if(!empty($this->data)) {           
            
            $isValid = $this->Customimage->validateLogin($this->data['Customimage']['username'], md5($this->data['Customimage']['password']), $this->Session->id());

            if($isValid) {
                $this->Session->write('Userlog', $isValid);
                if($sendtoadmin==1){
                $this->redirect(array('controller' => 'Customimages', 'action' => "sendtoadmin/1"));
                exit;
                }                 
                

                ?> 

<body onLoad="parent.onCloseSubmit()"></body>



                <?php
                //-----------ajax features--------------//
                Configure::write('debug', 0);
                $this->autoRender = false;
                exit;
            }
            else {
                $this->Session->setFlash('Sorry, Invalid Username / Password.', 'default',array('class'=> 'failure'));

                $this->redirect(array('controller' => 'Customimages', 'action' => "userlogin"));
                exit;
            }
        }*/
        
        $this->layout = 'ajax';

    }
    /********** get quote*******************/
     function getquote($userstatus=NULL,$prodDetailId=NULL,$action=NULL,$savId=NULL){     
        
   // echo "<pre>";print_r($_REQUEST);exit;
     	$cnfg 			=	Configure::read('Neutrino');
     	$tieredprice	=	$cnfg['tiered_price'];
     	$this->set('allowtieredprice', $tieredprice);
         $this->set("action","getquote"); 
         $this->set("savId",$savId);
         $this->set("prodDetailId", $prodDetailId);  
         $extraPrice = array();
                    $customized = $this->Savedimage->findById($savId); // 
                    $this->set('customized',$customized);
           // print_r($customized);
      
        $sess_arr = $this->Session->read('Userlog');
        if($sess_arr['id'] != "") {
            $logged_in = 1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
        }

        if(!$logged_in) {
            $data['uname'] = $customized['Savedimage']['users_id'];
            // $data['email'] = $customized['Savedimage']['users_id'];
            $data['reg_date'] = date('Y-m-d h:i:s');
            $this->User->save($data); 

            $data['id'] = $this->User->getLastInsertId();
            $this->Session->write('Userlog', $data);
            $sus  = $this->Session->read('Userlog');
            $this->set('sus', $sus);
               
            $customized['Savedimage']['users_id'] =$data['id'];
            //print_r($customized);
        }       

        $this->set('userStatus', $logged_in);
        
        $addnCost = $this->calculateAmt($savId);

        //Setting the prices for whole sale and retail users..
        if(isset($sus) && empty($sus)===false) {
            if($sus["usertype"]=='wholesale') {
                if($pdet["Product"]["wholesale_price"] > 0) {
                    $dat["product_price"]	=	$pdet["Product"]["wholesale_price"];
                }
                else {
                    $dat["product_price"]	=	$pdet["Product"]["price"];
                }
                $dat["price_type"]	=	'W';
            }

            if($sus["usertype"]=='retail') {
                $dat["product_price"]	=	$pdet["Product"]["price"];
                $dat["price_type"]	=	'R';
            }
        }

        else {
            $dat["product_price"]	=	$pdet["Product"]["price"];
        }

        //Setting the prices for whole sale and retail users..

        $dat["discount_type"]	 =	$pdet["Product"]["discount_type"];

        $dat["discount"]	        =       $pdet["Product"]["discount"];        

        $dat["quantity"]		=	$qty;

        $dat["prodtype"]		=	$pdet["Product"]["prodtype"];

        $dat["type"]		    =	'P';

        $dat["savedimages_id"]		=	$custid;
        $productname                    = $pdet["Product"]["pname"];

        //------------------Apply the customization cost--------------------//
        $dat["extra_price"]	= $addnCost;

        
         
         
         
        if($prodDetailId==NULL)
            $prodDetailId=$_POST['productdetailId'];
        if($action==NULL)
            $action=$_POST['action']; 
        if($userstatus==NULL)
            $action=$_POST['userstatus'];
        
        $flg=0;        
    
    
         
        if($userstatus==1){
            
            $sess_arr = $this->Session->read('Userlog');
            if($sess_arr['id'] != "" && !$this->Session->read('Admin')) {
                $uid = $sess_arr['id'];
            }
            
            $arruser = $this->User->getEssentials($uid);
             if($prodDetailId!=NULL){
            $productDetails = $this->Productdetail->findById($prodDetailId);      
            $productId = $productDetails['Productdetail']['product_id'];
            $imageName = $productDetails['Productdetail']['pdctfile'];
            $prod = $this->Product->findById($productId);
            $productname= $prod['Product']['pname'];
            $productDescription= $prod['Product']['descr'];
            $productPrice= $prod['Product']['price'];
            $this->set("imageName", $imageName);
            $this->set("productname", $productname);   
            $this->set("productId", $productId);
            $this->set("productDescription", $productDescription);   
            $this->set("productPrice", $productPrice);   
            
             if($prod['Product']["discount_type"]=='per' && $prod['Product']["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $productPrice * $prod['Product']["discount"] / 100;

		  else if($prod['Product']["discount_type"]=='amnt' && $prod['Product']["discount"] > 0)

		  $dis_amnt=$prod['Product']["discount"];		
            $this->set("dis_amnt",$dis_amnt);
            $this->set("price", ($productPrice+$addnCost+$productDetails['Productdetail']['extraprice'])-$dis_amnt); 
            
            }
            
                     
            $first_imagecost = $this->Setting->findByFieldname('first_image');
            $addn_imagecost = $this->Setting->findByFieldname('addn_image');
            $first_textcost = $this->Setting->findByFieldname('first_text');
            $addn_textcost = $this->Setting->findByFieldname('addn_text');

            $this->set("first_imagecost",$first_imagecost['Setting']['value']);
            $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
            $this->set("first_textcost",$first_textcost['Setting']['value']);
            $this->set("addn_textcost",$addn_textcost['Setting']['value']);
             //-------------------Get the entries from the settings table---------------------------------
            $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr	=	$this->Currency->findByCode($data["currency"] );
            $this->set('pcurr', $curr["Currency"]["logo"]);
            
            if(!empty($arruser)){
                
            $userName=$arruser['users']['uname'];
            $usermail=$arruser['users']['email'];
            $userphone=$arruser['users']['uphone'];
            $this->set("userName", $userName);
            $this->set("usermail", $usermail);
            $this->set("userphone", $userphone);
            $this->set("userid", $uid);            
            $this->set("userstatus", $userstatus);    
            $this->set("action", $action);
            }            
        }
        else {
            $this->set("userid", 'new');
        }       
       
        /******************* combination images ***********************/             
            $prod_details = $this->Productdetail->findById($prodDetailId);
            $prod = $this->Product->findById($prod_details['Productdetail']['product_id']); // u need to get the default attr
            $defaultattr = $prod['Product']['defaultattribute'];
            $custvalues = $this->Customfieldvalue->findAllByCustomfieldId($defaultattr);
            foreach($custvalues as $key => $val) {
                $cfArray[] = $val['Customfieldvalue']['id'];
            }
           
            $this->set('doublesided', $prod_details['Productdetail']['doublesided']);

            $tArray = explode(",", $prod_details['Productdetail']['customvalue_id']);
            foreach($tArray as $val) {
                if(in_array($val, $cfArray)) $setParam = $val;
            }
           
            $prod_comb = $this->Productdetail->findAllByProductId($prod_details['Productdetail']['product_id']);
           
            $paramVal = $this->Customfieldvalue->findById($setParam);
            
            $this->set('defaultvalue', $paramVal['Customfieldvalue']['custom_value']);
            foreach($prod_comb as $k => $v) {
                $name = '';

                $tArray2 = explode(",", $v['Productdetail']['customvalue_id']);               
                if(in_array($setParam, $tArray2)) {                   
                    $res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], 2);
                    
                    $j = 1;                    
                    foreach($res as $k2 => $v2) {
                        if(count($res) <> $j) $name .= $v2['CFV']['custom_value'].',';
                        else $name .= $v2['CFV']['custom_value'];
                        $j++;
                    }
                    $combArray[$v['Productdetail']['id']] = $name;
                    $extraPrice[] = $v['Productdetail']['extraprice'];
                    $stockArray[$v['Productdetail']['id']] = $v['Productdetail']['stock'];
                }
            }
         $this->set("combArray",$combArray);
         $this->set("extraPrice",$extraPrice);
         $this->set("prodPrice",$productPrice);
         $this->set("addnCost",$addnCost);
         $this->set("userstatus", $userstatus);
        /***************combination images ends ********************/
        if(!$savId)
         {
             $this->set('image','tshirts/'.$productDetails['Productdetail']['pdctfile']);
             
         }else{
              $this->set('image','../img/'.$customized['Savedimage']['image']);
         }
         global $currency; 
		$curr		=	$this->Currency->findByCode($currency);
		$this->set('curlogo',$curr["Currency"]["logo"]);
       $this->layout = 'ajax';
    }
    /*************** get quote ****************/
    
    /*************validate login ends***********/
    function sendtoadmin($userstatus=NULL,$prodDetailId=NULL,$action=NULL,$savId = NULL){  
         $this->set("action","sendtoadmin"); 
         $this->set("savId",$savId);
         $this->set("prodDetailId", $prodDetailId); 
         $extraPrice = array();
        $sess_arr = $this->Session->read('Userlog');
        if($sess_arr['id'] != "") {
            $logged_in = 1;
            $userstatus=1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
            $userstatus=1;
        }
        $this->set('userStatus', $logged_in);
         
        /*         for custom image fetching and price  */
        $customized = $this->Savedimage->findById($savId); // 
           // print_r($customized);        
        
        $addnCost = $this->calculateAmt($savId);

        //Setting the prices for whole sale and retail users..
        if(isset($sus) && empty($sus)===false) {
            if($sus["usertype"]=='wholesale') {
                if($pdet["Product"]["wholesale_price"] > 0) {
                    $dat["product_price"]	=	$pdet["Product"]["wholesale_price"];
                }
                else {
                    $dat["product_price"]	=	$pdet["Product"]["price"];
                }
                $dat["price_type"]	=	'W';
            }

            if($sus["usertype"]=='retail') {
                $dat["product_price"]	=	$pdet["Product"]["price"];
                $dat["price_type"]	=	'R';
            }
        }

        else {
            $dat["product_price"]	=	$pdet["Product"]["price"];
        }

        //Setting the prices for whole sale and retail users..

        $dat["discount_type"]	 =	$pdet["Product"]["discount_type"];

        $dat["discount"]	        =       $pdet["Product"]["discount"];        

        $dat["quantity"]		=	$qty;

        $dat["prodtype"]		=	$pdet["Product"]["prodtype"];

        $dat["type"]		    =	'P';

        $dat["savedimages_id"]		=	$custid;
        $productname                    = $pdet["Product"]["pname"];

        //------------------Apply the customization cost--------------------//
        $dat["extra_price"]	= $addnCost;
      
        $this->set('customized',$customized);
        
         /*         for custom image fetching and price  End  */
        
  //  echo "<pre>";print_r($_REQUEST);exit;
        if($prodDetailId==NULL)
            $prodDetailId=$_POST['productdetailId'];
        if($action==NULL)
            $action=$_POST['action']; 
        if($userstatus==NULL)
            $action=$_POST['userstatus'];
        
        $this->set("prodDetailId", $prodDetailId);    
        
        $flg=0;
        if(isset($_POST))
        {    // echo "<pre>";print_r($_POST);exit;
            if($_POST['userid']=='existing'){  
                                    
            $isValid = $this->Customimage->validateLogin($this->data['Customimage']['uname'], md5($this->data['Customimage']['password']), $this->Session->id());
            $userId = $isValid['id'];
              
            if($isValid) {
                $this->Session->write('Userlog', $isValid);
               }  
            else {
                //echo "Invalid Credentials";
                $this->Session->setFlash('Invalid Credentials', 'default',array('class'=> 'success'));
                $flg=1;
                $this->redirect(array('controller' => 'Customimages', 'action' => "orderuserlogin/$prodDetailId/$action/"));
                }  
            }
           
            
            
            if(!$savId)
         {
             $this->set('image','../img/'.$prodDetailId);
             
         }
        //   echo "<pre>";print_r($this->data);exit;
            if($this->data["Customimage"]["userid"]!=''&& $this->data["Customimage"]["userstatus"]==1){      
                     
            $this->data["Customimage"]["uphone"]= $this->data["Customimage"]["phone"];
            $this->Customimage->UpdateUserDetail($this->data);          
           
            }
            
            
            if($_POST['action']=='addtocart' && $flg==0){  
                //print_r($_POST); exit;
            	//echo "addtocart";exit;
                $out_of_stock_flag = true;                 
                foreach($_POST['combination'] as $key => $val) { $savedID = 0;
                    if($val!=''){
                       if($_POST['hidden'][$key]!=$prodDetailId){
                        $ProductData = $this->Productdetail->findById($prodDetailId); 
                        //duplicate entries in the savedimages & itemcoordinates tables
                        $savedID = $this->Customimage->duplicateTblEntries($_POST['hidden'][$key], $_POST['savId']);
                       
                        
                        }else{
                            $ProductData = $this->Productdetail->findById($prodDetailId); 
                            $savedID = $_POST['savId'];
                        }
                        if((int)$val <> 0 && $savedID <> 0){ $prodDetId = $_POST['hidden'][$key];
                            $cart_add = $this->discreet_add($ProductData['Productdetail']['product_id'], $_POST['hidden'][$key], $savedID, (int)$val,$_POST['custome_info'][$prodDetId]);
                            if(!$cart_add){
                                $out_of_stock_flag = true;
                                 echo "<script type='text/javascript'>";       
                                // echo "alert('Product is out of stock!');";
                                 echo "parent.submitcloseSendadmin(4,1)";
                            echo "</script>";
                            }else{
                                echo "<script type='text/javascript'>";              
                                 echo "parent.submitcloseSendadmin(1,0)";
                            echo "</script>";
                            }
                            
                        }
                    }
                } 
              
                $this->__generateUserDesigns($this->data["Customimage"]["userid"]);
                
                
            }
           
            if($_POST['action']=='sendtoadmin' ){  
           
               $orderId = 0;
                 $out_of_stock_flag = true;                 
                foreach($_POST['combination'] as $key => $val) {
                    if($val!=''){ $prodDetId = $_POST['hidden'][$key];
                       if($_POST['hidden'][$key]!=$prodDetailId){$savedID = 0;
                        $ProductData = $this->Productdetail->findById($prodDetailId); 
                        //duplicate entries in the savedimages & itemcoordinates tables
                        $savedID = $this->Customimage->duplicateTblEntries($_POST['hidden'][$key], $_POST['savId']);
                        $orderId = $this->add_order($ProductData['Productdetail']['product_id'], $_POST['hidden'][$key], $savedID, (int)$val , $orderId,$_POST['custome_info'][$prodDetId]);
                      
                        
                        }else{
                            $ProductData = $this->Productdetail->findById($prodDetailId); 
                            $savedID = $_POST['savId'];
                            $orderId = $this->add_order($ProductData['Productdetail']['product_id'], $_POST['hidden'][$key], $savedID, (int)$val , $orderId,$_POST['custome_info'][$prodDetId]);
                           
                        }
                        if((int)$val <> 0 && $savedID <> 0){ 
                           
                            /*if(!$cart_add){ 
                                $out_of_stock_flag = true;
                            }else{ echo "ws";exit;*/
                                echo "<script type='text/javascript'>";              
                                 echo "parent.submitcloseSendadmin(2,0)";
                                echo "</script>";
                          /*  }*/
                            
                        }
                    }
                } 
                
                $this->sendOrderMail($orderId,$ProductData['Productdetail']['product_id']);
                
                $this->__generateUserDesigns($this->data["Customimage"]["userid"]);
              
            }            
            if($_POST['action']=='getquote' &&  $flg==0){  
               $out_of_stock_flag = true;                 
                $orderId = 0;
                foreach($_POST['combination'] as $key => $val) {
                   if($val!=''){$prodDetId = $_POST['hidden'][$key];
                      if($_POST['hidden'][$key]!=$prodDetailId){
                        $ProductData = $this->Productdetail->findById($prodDetailId); 
                        //duplicate entries in the savedimages & itemcoordinates tables
                        $savedID = $this->Customimage->duplicateTblEntries($_POST['hidden'][$key], $_POST['savId']);
                         $orderId = $this->add_quote($ProductData['Productdetail']['product_id'], $_POST['hidden'][$key], $savedID, (int)$val,$orderId,$_POST['custome_info'][$prodDetId]);
                        

                        }else{
                            $ProductData = $this->Productdetail->findById($prodDetailId); 
                            $savedID = $_POST['savId'];
                            $orderId = $this->add_quote($ProductData['Productdetail']['product_id'], $_POST['hidden'][$key], $savedID, (int)$val,$orderId,$_POST['custome_info'][$prodDetId]);
                      
                        }
                        if((int)$val <> 0 && $savedID <> 0){
                            //$cart_add = $this->add_quote($ProductData['Productdetail']['product_id'], $_POST['hidden'][$key], $savedID, (int)$val);
                            /*if(!$cart_add){
                                $out_of_stock_flag = true;
                            }else{*/
                                echo "<script type='text/javascript'>";              
                                 echo "parent.submitcloseSendadmin(3,0)";
                            echo "</script>";
                            //}
                           
                        }
                    } 
                } 
                
                $this->sendQuoteMail($orderId,$ProductData['Productdetail']['product_id']);
                
                $this->__generateUserDesigns($this->data["Customimage"]["userid"]);
              
            }
            
        }        
    
      /*  if($this->data["Customimage"]["userid"]!=''&& $this->data["Customimage"]["userstatus"]==1){         

            $this->data["Customimage"]["uphone"]= $_REQUEST["phone"];  
            $this->data["Customimage"]["userid"]= $_REQUEST["userid"];  
            $this->Customimage->UpdateUserDetail($this->data);
            $this->Session->write('admQty', $this->data["Customimage"]["quantity"]);
            echo "<script type='text/javascript'>";
            echo "parent.onCloseSubmit()";
            echo "</script>";
           // echo "Your order will be placed on confirmation.";exit;  
           
        }*/
         
        if($userstatus==1){
            
            $sess_arr = $this->Session->read('Userlog');
            if($sess_arr['id'] != "" && !$this->Session->read('Admin')) {
                $uid = $sess_arr['id'];
            }
            
            $arruser = $this->User->getEssentials($uid);
             if($prodDetailId!=NULL){
            $productDetails = $this->Productdetail->findById($prodDetailId);      
            $productId = $productDetails['Productdetail']['product_id'];
            $imageName = $productDetails['Productdetail']['pdctfile'];
            $prod = $this->Product->findById($productId);
            
            $productname= $prod['Product']['pname'];
            $productDescription= $prod['Product']['descr'];
            $productPrice= $prod['Product']['price'];
            $this->set("imageName", $imageName);
            $this->set("productname", $productname);   
            $this->set("productDescription", $productDescription);  
            $this->set("productId", $productId);
            $this->set("productPrice", $productPrice);   
   if($prod['Product']["discount_type"]=='per' && $prod['Product']["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $productPrice * $prod['Product']["discount"] / 100;

		  else if($prod['Product']["discount_type"]=='amnt' && $prod['Product']["discount"] > 0)

		  $dis_amnt=$prod['Product']["discount"];		
            $this->set("dis_amnt",$dis_amnt);
            $this->set("price", ($productPrice+$addnCost+$productDetails['Productdetail']['extraprice'])-$dis_amnt); 
            }
            
            /******************* combination images ***********************/             
            $prod_details = $this->Productdetail->findById($prodDetailId);
            $prod = $this->Product->findById($prod_details['Productdetail']['product_id']); // u need to get the default attr
            $defaultattr = $prod['Product']['defaultattribute'];
            $custvalues = $this->Customfieldvalue->findAllByCustomfieldId($defaultattr);
            foreach($custvalues as $key => $val) {
                $cfArray[] = $val['Customfieldvalue']['id'];
            }
           
            $this->set('doublesided', $prod_details['Productdetail']['doublesided']);

            $tArray = explode(",", $prod_details['Productdetail']['customvalue_id']);
            foreach($tArray as $val) {
                if(in_array($val, $cfArray)) $setParam = $val;
            }
           
            $prod_comb = $this->Productdetail->findAllByProductId($prod_details['Productdetail']['product_id']);
           
            $paramVal = $this->Customfieldvalue->findById($setParam);
            
            $this->set('defaultvalue', $paramVal['Customfieldvalue']['custom_value']);
            foreach($prod_comb as $k => $v) {
                $name = '';

                $tArray2 = explode(",", $v['Productdetail']['customvalue_id']);               
                if(in_array($setParam, $tArray2)) {                   
                    $res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], 2);
                    
                    $j = 1;                    
                    foreach($res as $k2 => $v2) {
                        if(count($res) <> $j) $name .= $v2['CFV']['custom_value'].',';
                        else $name .= $v2['CFV']['custom_value'];
                        $j++;
                    }
                    $combArray[$v['Productdetail']['id']] = $name;
                    $stockArray[$v['Productdetail']['id']] = $v['Productdetail']['stock'];
                }
            }
         $this->set("combArray",$combArray);

        /***************combination images ends ********************/
            
            $first_imagecost = $this->Setting->findByFieldname('first_image');
            $addn_imagecost = $this->Setting->findByFieldname('addn_image');
            $first_textcost = $this->Setting->findByFieldname('first_text');
            $addn_textcost = $this->Setting->findByFieldname('addn_text');
            $this->set("first_imagecost",$first_imagecost['Setting']['value']);
            $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
            $this->set("first_textcost",$first_textcost['Setting']['value']);
            $this->set("addn_textcost",$addn_textcost['Setting']['value']);
             //-------------------Get the entries from the settings table---------------------------------
            $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr	=	$this->Currency->findByCode($data["currency"] );
            $this->set('pcurr', $curr["Currency"]["logo"]);
            
            if(!empty($arruser)){
                
            $userName=$arruser['users']['uname'];
            $usermail=$arruser['users']['email'];
            $userphone=$arruser['users']['uphone'];
            $this->set("userName", $userName);
            $this->set("usermail", $usermail);
            $this->set("userphone", $userphone);
            $this->set("userid", $uid);            
            $this->set("userstatus", $userstatus);    
            $this->set("action", $action);
            }            
        }
        else {
            $this->set("userid", 'new');
        }       
       
        /******************* combination images ***********************/             
            $prod_details = $this->Productdetail->findById($prodDetailId);
            $prod = $this->Product->findById($prod_details['Productdetail']['product_id']); // u need to get the default attr
            $defaultattr = $prod['Product']['defaultattribute'];
            $custvalues = $this->Customfieldvalue->findAllByCustomfieldId($defaultattr);
            foreach($custvalues as $key => $val) {
                $cfArray[] = $val['Customfieldvalue']['id'];
            }
           
            $this->set('doublesided', $prod_details['Productdetail']['doublesided']);

            $tArray = explode(",", $prod_details['Productdetail']['customvalue_id']);
            foreach($tArray as $val) {
                if(in_array($val, $cfArray)) $setParam = $val;
            }
           
            $prod_comb = $this->Productdetail->findAllByProductId($prod_details['Productdetail']['product_id']);
           
            $paramVal = $this->Customfieldvalue->findById($setParam);
            
            $this->set('defaultvalue', $paramVal['Customfieldvalue']['custom_value']);
            foreach($prod_comb as $k => $v) {
                $name = '';

                $tArray2 = explode(",", $v['Productdetail']['customvalue_id']);               
                if(in_array($setParam, $tArray2)) {                   
                    $res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], 2);
                    
                    $j = 1;                    
                    foreach($res as $k2 => $v2) {
                        if(count($res) <> $j) $name .= $v2['CFV']['custom_value'].',';
                        else $name .= $v2['CFV']['custom_value'];
                        $j++;
                    }
                    $combArray[$v['Productdetail']['id']] = $name;
                     $extraPrice[] = $v['Productdetail']['extraprice'];
                    $stockArray[$v['Productdetail']['id']] = $v['Productdetail']['stock'];
                }
            }
         $this->set("combArray",$combArray);
           $this->set("extraPrice",$extraPrice);
         $this->set("userstatus", $userstatus);
         $this->set("prodPrice",$productPrice);
         $this->set("addnCost",$addnCost);
        /***************combination images ends ********************/
        if(!$savId)
         {
             $this->set('image','tshirts/'.$productDetails['Productdetail']['pdctfile']);
             
         }else{
              $this->set('image','../img/'.$customized['Savedimage']['image']);
         }
       $this->set('userStatus', $logged_in); 
       $this->set("userid",$uid);
       
       
       global $currency; 
		$curr		=	$this->Currency->findByCode($currency);
		$this->set('curlogo',$curr["Currency"]["logo"]);
       $this->layout = 'ajax';
    }
   
    /****************************/
    
    function  addnote($userstatus=0,$prodDetailId=NULL,$savId=NULL)
    {
        
      
       
       if($_POST['note'])
       {
           $id = $this->Customimage->updateNote($_POST);
           echo "Successfully added note";
           header("Refresh:1"); exit;
       }
         $customized = $this->Savedimage->findById($savId);

        $sess_arr = $this->Session->read('Userlog'); 
        if($sess_arr['id'] != "") {
            $logged_in = 1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
        }

         if(!$logged_in) {
            $data['uname'] = $customized['Savedimage']['users_id'];
            // $data['email'] = $customized['Savedimage']['users_id'];
            $data['reg_date'] = date('Y-m-d h:i:s');
            $this->User->save($data); 

            $data['id'] = $this->User->getLastInsertId();
            $this->Session->write('Userlog', $data);
            $sus  = $this->Session->read('Userlog');
            $this->set('sus', $sus);
               
            $customized['Savedimage']['users_id'] =$data['id'];
            //print_r($customized);
        }       

      
        $this->set("savId",$savId);
        $this->set("note",$customized['Savedimage']['note']);
        $this->set("prodDetailId", $prodDetailId);
        
         $this->layout = 'ajax';
        
    }



 function  saveImageee($userstatus=0,$prodDetailId=NULL,$savId=NULL)  {

        $customized = $this->Savedimage->findById($savId);

        $sess_arr = $this->Session->read('Userlog'); 
        if($sess_arr['id'] != "") {
            $logged_in = 1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
        }

         if(!$logged_in) {
            $data['uname'] = $customized['Savedimage']['users_id'];
            // $data['email'] = $customized['Savedimage']['users_id'];
            $data['reg_date'] = date('Y-m-d h:i:s');
            //$this->User->save($data); 

            $data['id'] = $this->User->getLastInsertId();
            $this->Session->write('Userlog', $data);
            $sus  = $this->Session->read('Userlog');
            $this->set('sus', $sus);
               
            $customized['Savedimage']['users_id'] =$data['id'];
            //echo '<pre>';print_r($customized); echo '</pre>';
        }       
       
       $productdetailId = $customized['Savedimage']['productdetails_id'];
       $productDetails = $this->Productdetail->findById($productdetailId);     
        //echo '<pre>';print_r($productDetails); echo '</pre>';
        echo '<pre>';print_r($sus); echo '</pre>';


       $productId = $productDetails['Productdetail']['product_id'];
       $imageName = $productDetails['Productdetail']['pdctfile'];
       $prod = $this->Product->findById($productId);
       $productname= $prod['Product']['pname'];

        $this->data["Customimage"]["uname"]   = $_REQUEST["uname"];
                $this->data["Customimage"]["email"]   = $_REQUEST["email"];
                $this->data["Customimage"]["password"]=$this->data["Customimage"]["uname"]."1234";
                $this->data["Customimage"]["reg_date"]= date("Y-m-d");
                $this->data["Customimage"]["usertype"]= "retail";
                $this->data["Customimage"]["reg_status"]= "R";
                $this->data["Customimage"]["uphone"]= $_REQUEST["phone"];                
                $this->Customimage->toAdminSave($this->data);

         $this->layout = 'ajax';
          echo "<script type='text/javascript'>";
            echo "parent.onCloseSubmit()";
            echo "</script>";
            echo " ";exit;  
        
        

   /* */
               
}



    function addtocart($userstatus=0,$prodDetailId=NULL,$savId=NULL){        
    
        //  -----          To Get Proice     ----     //
        
        $this->set("action","addtocart"); 
        $this->set("savId",$savId);
        $this->set("prodDetailId", $prodDetailId);    
        $customized = $this->Savedimage->findById($savId); 

        $sess_arr = $this->Session->read('Userlog'); 
        if($sess_arr['id'] != "") {
            $logged_in = 1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
        }
        
        if(!$logged_in) {
            $data['uname'] = $customized['Savedimage']['users_id'];
            // $data['email'] = $customized['Savedimage']['users_id'];
            $data['reg_date'] = date('Y-m-d h:i:s');
            $this->User->save($data); 

            $data['id'] = $this->User->getLastInsertId();
            $this->Session->write('Userlog', $data);
            $sus  = $this->Session->read('Userlog');
            $this->set('sus', $sus);
               
            $customized['Savedimage']['users_id'] =$data['id'];
            //print_r($customized);
        }      
        $cnfg 			=	Configure::read('Neutrino');
        $tieredprice	=	$cnfg['tiered_price'];
        $this->set('allowtieredprice', $tieredprice);

        $this->set('userStatus', $logged_in);
        $addnCost = $this->calculateAmt($savId);
        $extraPrice = array();
        //Setting the prices for whole sale and retail users..
        if(isset($sus) && empty($sus)===false) {
            if($sus["usertype"]=='wholesale') {
                if($pdet["Product"]["wholesale_price"] > 0) {
                    $dat["product_price"]	=	$pdet["Product"]["wholesale_price"];
                }
                else {
                    $dat["product_price"]	=	$pdet["Product"]["price"];
                }
                $dat["price_type"]	=	'W';
            }

            if($sus["usertype"]=='retail') {
                $dat["product_price"]	=	$pdet["Product"]["price"];
                $dat["price_type"]	=	'R';
            }
        }

        else {
            $dat["product_price"]	=	$pdet["Product"]["price"];
        }

        //Setting the prices for whole sale and retail users..

        $dat["discount_type"]	 =	$pdet["Product"]["discount_type"];
        $dat["discount"]	     =  $pdet["Product"]["discount"];        
        $dat["quantity"]		 =	$qty;
        $dat["prodtype"]		 =	$pdet["Product"]["prodtype"];
        $dat["type"]		     =	'P';
        $dat["savedimages_id"]	 =	$custid;
        $productname             =  $pdet["Product"]["pname"];

        //------------------Apply the customization cost--------------------//
        $dat["extra_price"]	= $addnCost;

        

       //  -----          To Get Proice     ----          //
             //----------customfieldvalues--------------//

        
            $prod_details = $this->Productdetail->findById($prodDetailId);
          

             $this->set("customized",$customized);
            $prod = $this->Product->findById($prod_details['Productdetail']['product_id']); // u need to get the default attr
            $defaultattr = $prod['Product']['defaultattribute'];
            $custvalues = $this->Customfieldvalue->findAllByCustomfieldId($defaultattr);         
             $dat["product_price"] = $this->getTieredPrice($prod_details['Productdetail']['product_id'],1,1);
            
            if(isset($dat["product_price"]))
               $productPrice = $dat["product_price"];
            else
               $productPrice = $prod['Product']['price'];
            $productDescription= $prod['Product']['descr'];  
          // print_r($prod);
            $this->set("productMinQtySold", $productMinQtySold);
            $productMinQtySold = $prod['Product']['min_qty'];
            $this->set("productDescription", $productDescription);
        if($prod['Product']["discount_type"]=='per' && $prod['Product']["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $productPrice * $prod['Product']["discount"] / 100;

		  else if($prod['Product']["discount_type"]=='amnt' && $prod['Product']["discount"] > 0)

		  $dis_amnt=$prod['Product']["discount"];		
          // echo $dis_amnt;
           
            $this->set("dis_amnt",$dis_amnt);
            $this->set("price", ($productPrice+$addnCost+$prod_details['Productdetail']['extraprice'])-$dis_amnt); 
            
            foreach($custvalues as $key => $val) {
                $cfArray[] = $val['Customfieldvalue']['id'];
            }
           
            $this->set('doublesided', $prod_details['Productdetail']['doublesided']);

            $tArray = explode(",", $prod_details['Productdetail']['customvalue_id']);
            foreach($tArray as $val) {
                if(in_array($val, $cfArray)) $setParam = $val;
            }
           
            $prod_comb = $this->Productdetail->findAllByProductId($prod_details['Productdetail']['product_id']);
           
            $paramVal = $this->Customfieldvalue->findById($setParam);
            
            $this->set('defaultvalue', $paramVal['Customfieldvalue']['custom_value']);
          
            foreach($prod_comb as $k => $v) {
                $name = '';

                $tArray2 = explode(",", $v['Productdetail']['customvalue_id']);
                //echo $v['Productdetail']['customvalue_id'];exit;
                if(in_array($setParam, $tArray2)) {
                    //$res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], $setParam);
                    $res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], 2);
                    
                    $j = 1;                    
                    foreach($res as $k2 => $v2) {
                        if(count($res) <> $j) $name .= $v2['CFV']['custom_value'].',';
                        else $name .= $v2['CFV']['custom_value'];
                        $j++;
                    }
                    $combArray[$v['Productdetail']['id']] = $name;
                  
                    $extraPrice[] = $v['Productdetail']['extraprice'];
                    $stockArray[$v['Productdetail']['id']] = $v['Productdetail']['stock'];
                }
            }
         //   echo "controller";print_r($combArray);
         $this->set("combArray",$combArray);
         $this->set("extraPrice",$extraPrice);
         $this->set("prodPrice",$productPrice);
         $this->set("addnCost",$addnCost);
        
       // print_r($combArray); exit;
         if(!empty($_REQUEST['userid']))
        {    
        
         if($_REQUEST['userid']=="new") 
        {           
            $usse = $this->User->findByEmail($_REQUEST['email']);
            
            if (!empty($usse['User']['uname'])) {               
                echo "Email already exists";
                exit;

            }
            else {
                $this->data["Customimage"]["uname"]   = $_REQUEST["uname"];
                $this->data["Customimage"]["password"]=$this->data["Customimage"]["uname"]."1234";
                $this->data["Customimage"]["reg_date"]= date("Y-m-d");
                $this->data["Customimage"]["usertype"]= "retail";
                $this->data["Customimage"]["reg_status"]= "R";
                $this->data["Customimage"]["uphone"]= $_REQUEST["phone"];                
                $this->Customimage->toAdminSave($this->data);
                $isValid = $this->Customimage->validateLogin($this->data['Customimage']['uname'], md5($this->data['Customimage']['password']), $this->Session->id());
                $this->Session->write('Userlog', $isValid);
                $this->Session->write('admQty', $_REQUEST['quantity']);
                echo "<script type='text/javascript'>";
                echo "parent.onCloseSubmit()";
                echo "</script>";
                echo "Product will be added to cart on confirmation";exit;
            }          
        }elseif($_REQUEST['userid']=='existing'){  
            $this->data["Customimage"]['username'] = $_REQUEST["uname"];
            $this->data['Customimage']['password'] = $_REQUEST["password"];            
            $isValid = $this->Customimage->validateLogin($this->data['Customimage']['username'], md5($this->data['Customimage']['password']), $this->Session->id());
            $userId = $isValid['id'];
              
            if($isValid) {
                $this->Session->write('Userlog', $isValid);
               }  
            else {
                echo "<div style='color:red'>Invalid Credentials</div>";
                exit;
                }                
            $this->set("action","addtocart");
            $this->Session->write('admQty', $_REQUEST['quantity']);
            echo "<script type='text/javascript'>";
            echo "parent.onCloseSubmit()";
            echo "</script>";
            echo " ";exit;  
           
        }
        
        
        }
        if($this->data["Customimage"]["userid"]!=''&& $this->data["Customimage"]["userstatus"]==1){         

          // echo "<pre>";print_r($_POST);exit;            
           $combinationQty = $_POST['combination'];
           $qty = json_encode($combinationQty);
           //print_r($combinationQty);exit;
            echo "<script type='text/javascript'>";              
            echo "parent.submitclose(".$qty.")";
            echo "</script>";
            echo "Product will be added on confirmation.";exit;  
           
        }         
        if($userstatus==1){ 
            $sess_arr = $this->Session->read('Userlog');
            if($sess_arr['id'] != "" && !$this->Session->read('Admin')) {
                $uid = $sess_arr['id'];
            }
            
            $arruser = $this->User->getEssentials($uid);
             if($prodDetailId!=NULL){
            $productDetails = $this->Productdetail->findById($prodDetailId);      
            $productId = $productDetails['Productdetail']['product_id'];
            $imageName = $productDetails['Productdetail']['pdctfile'];
            $prod = $this->Product->findById($productId);
            $productname= $prod['Product']['pname'];
            $this->set("imageName", $imageName);
            $this->set("productId", $productId);
            $this->set("productname", $productname);   
            }
                      
            
            $first_imagecost = $this->Setting->findByFieldname('first_image');
            $addn_imagecost = $this->Setting->findByFieldname('addn_image');
            $first_textcost = $this->Setting->findByFieldname('first_text');
            $addn_textcost = $this->Setting->findByFieldname('addn_text');

            $this->set("first_imagecost",$first_imagecost['Setting']['value']);
            $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
            $this->set("first_textcost",$first_textcost['Setting']['value']);
            $this->set("addn_textcost",$addn_textcost['Setting']['value']);
             //-------------------Get the entries from the settings table---------------------------------
            $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr	=	$this->Currency->findByCode($data["currency"] );
            $this->set('pcurr', $curr["Currency"]["logo"]);
            
            if(!empty($arruser)){
                
            $userName=$arruser['users']['uname'];
            $usermail=$arruser['users']['email'];
            $userphone=$arruser['users']['uphone'];
            $this->set("userName", $userName);
            $this->set("usermail", $usermail);
            $this->set("userphone", $userphone);
            $this->set("userid", $uid);            
            $this->set("userstatus", $userstatus);    
            }            
        }
        else {
            $this->set("userid", 'new');
        }       
             
            if(!$savId)
         {
             $this->set('image','tshirts/'.$productDetails['Productdetail']['pdctfile']);
             
         }else{
              $this->set('image','../img/'.$customized['Savedimage']['image']);
         }
         global $currency; 
		$curr		=	$this->Currency->findByCode($currency);
		$this->set('curlogo',$curr["Currency"]["logo"]);
       $this->layout = 'ajax';
    }
    
    /********** add to cart end ****************/
    
    /******add to cart Login ******/ 
     function addtocartlogin($productdetailId) { 
               
       $productDetails = $this->Productdetail->findById($productdetailId);      
       $productId = $productDetails['Productdetail']['product_id'];
       $imageName = $productDetails['Productdetail']['pdctfile'];
       $prod = $this->Product->findById($productId);
       $productname= $prod['Product']['pname'];
       $this->set("imageName", $imageName);
       $this->set("productname", $productname);
       $first_imagecost = $this->Setting->findByFieldname('first_image');
        $addn_imagecost = $this->Setting->findByFieldname('addn_image');
        $first_textcost = $this->Setting->findByFieldname('first_text');
        $addn_textcost = $this->Setting->findByFieldname('addn_text');

        $this->set("first_imagecost",$first_imagecost['Setting']['value']);
        $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
        $this->set("first_textcost",$first_textcost['Setting']['value']);
        $this->set("addn_textcost",$addn_textcost['Setting']['value']);
         //-------------------Get the entries from the settings table---------------------------------
        $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
        $curr	=	$this->Currency->findByCode($data["currency"] );
        $this->set('pcurr', $curr["Currency"]["logo"]);      
       
            
       /* if(!empty($this->data)) {           
            
            $isValid = $this->Customimage->validateLogin($this->data['Customimage']['username'], md5($this->data['Customimage']['password']), $this->Session->id());

            if($isValid) {
                $this->Session->write('Userlog', $isValid);
                if($sendtoadmin==1){
                $this->redirect(array('controller' => 'Customimages', 'action' => "sendtoadmin/1"));
                exit;
                }                 
                

                ?> 

<body onLoad="parent.onCloseSubmit()"></body>



                <?php
                //-----------ajax features--------------//
                Configure::write('debug', 0);
                $this->autoRender = false;
                exit;
            }
            else {
                $this->Session->setFlash('Sorry, Invalid Username / Password.', 'default',array('class'=> 'failure'));

                $this->redirect(array('controller' => 'Customimages', 'action' => "userlogin"));
                exit;
            }
        }*/
        $this->layout = 'ajax';

    }
    /********* add to cart login ends ********/
    function userregister() {

        if(!empty($this->data)) {
            $usse = $this->User->findByEmail($this->data['Customimage']['email']);
            $ussn = $this->User->findByUname($this->data['Customimage']['uname']);

            if (!empty($ussn['User']['uname'])) {

                $this->Session->setFlash('Username Already Exists!', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'Customimages', 'action' => "userregister"));
                exit;

            }
            elseif (!empty($usse['User']['uname'])) {

                $this->Session->setFlash('Email Address Already Exists!', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'Customimages', 'action' => "userregister"));
                exit;

            }
            else {
                $this->Customimage->customSave($this->data);

                //----------------------------email-----------------------------------//
                $cnfg 			=	Configure::read('Neutrino');

                $subject 		= "Registration complete at ".$cnfg["site_name"];

                $headers 		= "MIME-Version: 1.0\r\n";

                $headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

                $headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

                $headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";

                $headers        .= "Organization: ".$cnfg["site_name"]."\r\n";

                $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

                $pdt 			= 	$this->Cmspage->findByTitle('Registration confirm mail');

                $path			=	"SiteLogo_disp.gif";

                $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

		  		<tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr></table>";

                $cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

                $logurl			=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/users/login' target='_blank'>Click here to login</a>";

                $mailcontent	=	$mcont.$pdt["Cmspage"]["content"];

                $mailcontent 	= str_replace("[User_Name]", $this->data["Customimage"]["uname"], $mailcontent);

                $mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);

                $mailcontent 	= str_replace("[PASSWORD]", $this->data['Customimage']['password'], $mailcontent);

                $mailcontent 	= str_replace("[LOGIN_URL]", $logurl, $mailcontent);

                $pdtad 			= 	$this->Cmspage->findByTitle('Registration intimation mail to admin');

                $mailcontentad	=	$pdtad["Cmspage"]["content"];

                $mailcontentad 	= str_replace("[User_Name]", $this->data["Customimage"]["uname"], $mailcontentad);

                $mailcontentad 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontentad);

                $mailsent 		= mail($this->data["Customimage"]["email"],$subject,$mailcontent,$headers);

                $mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontentad,$headers);

                //----------------------------------------------------------------------------------------------------------//

                $isValid = $this->Customimage->validateLogin($this->data['Customimage']['uname'], md5($this->data['Customimage']['password']), $this->Session->id());

                if($this->data["Customimage"]["news_letter"]==1) {
                    $this->Newsletteruser->create($newsletteruser = array());
                    //$newsletteruser["id"]	=	$isValid['User']['id'];
                    $newsletteruser["uname"]	=	$this->data["Customimage"]["uname"];
                    $newsletteruser["email"]	=	$this->data["Customimage"]["email"];
                    $newsletteruser["sub_date"]	=	date('Y-m-d h:i:s');
                    $newsletteruser["status "]	=	'Y';

                    $dups = $this->Newsletteruser->findByEmail(trim($newsletteruser["email"]));
                    if (empty($dups['Newsletteruser']['email'])=== true)
                        $this->Newsletteruser->save($newsletteruser);
                    unset($newsletteruser);
                }

                else {
                    $this->Newsletteruser->create($newsletteruser = array());
                    //$newsletteruser["id"]	=	$isValid['User']['id'];
                    $newsletteruser["uname"]	=	$this->data["Customimage"]["uname"];
                    $newsletteruser["email"]	=	$this->data["Customimage"]["email"];
                    $newsletteruser["sub_date"]	=	date('Y-m-d h:i:s');
                    $newsletteruser["status"]	=	'N';

                    $dups = $this->Newsletteruser->findByEmail(trim($newsletteruser["email"]));
                    if (empty($dups['Newsletteruser']['email'])=== true)
                        $this->Newsletteruser->save($newsletteruser);
                    unset($newsletteruser);
                }

                $this->Session->write('Userlog', $isValid);

                ?>
<body onLoad="parent.onCloseSubmit()"></body>
                <?php
                //-----------ajax features--------------//
                Configure::write('debug', 0);
                $this->autoRender = false;
                exit;
            }
        }
        $this->layout = 'ajax';

    }

    function deletedesign($designRef,$flag='',$lastId='') {
        $id = $this->Savedimage->findAllByRefName($designRef);
        foreach($id as $val) {
            $this->Customimage->deleteCoordinates($val['Savedimage']['id']);
        }

        $this->Session->setFlash('Selected design deleted successfully!', 'default',array('class'=> 'failure'));
        
        if($flag=='admin')
        {    $this->Customimage->deleteTemplates($lastId); 
             $this->redirect(array('controller' => 'Products', 'action' => "templates"));
        }
        $this->redirect(array('controller' => 'Customimages', 'action' => "userdesigns"));
        exit;
    }

    function userpass() {
        if(!empty($this->data)) {
            $this->Setting->load();

            $chk	=	$this->User->findAll("uname='".$this->data['Customimage']['username']."' AND email='".$this->data['Customimage']['email']."'");
            if(empty($chk)==false) {

                $pword	=	time().$this->data['Customimage']['username'];                
                $this->User->pwordset($this->data['Customimage']['username'],$pword);

                $cnfg 			=	Configure::read('Neutrino');
                $subject 		= "Password reset at ".$cnfg["site_name"];
                $headers 		= "MIME-Version: 1.0\r\n";
                $headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
                $headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
                $headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
                $headers        .= "Organization: ".$cnfg["site_name"]."\r\n";
                $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";
                $pdt 			= 	$this->Cmspage->findByTitle('Forgot password mail');
                $path			=	"SiteLogo_disp.gif";
                $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
	  <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr></table>";

                $cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

                $mailcontent	=	$mcont.$pdt["Cmspage"]["content"];
                $mailcontent 	= str_replace("[User_Name]", $this->data['Customimage']['username'], $mailcontent);
                $mailcontent 	= str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);
                $mailcontent 	= str_replace("[PASSWORD]", $pword, $mailcontent);

                $mailsent 		= mail($this->data['Customimage']['email'],$subject,$mailcontent,$headers);

                if($mailsent	==	true) {
                    $this->Session->setFlash('Your Password has been reset and sent to your email address.', 'default',array('class'=> 'success'));
                }

                $this->redirect(array('controller' => 'Customimages', 'action' => "userlogin"));
                exit;

            }else {

                $this->Session->setFlash('You have entered an invalid username or email address!', 'default',array('class'=> 'failure'));

            }
        }
        $this->layout = 'ajax';
    }

    function __validateLoginStatus($typ='A') {
        if($typ == 'A') {
            if($this->Session->check('Admin') == false) {
                $this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'admins', 'action' => 'login'));
            }
        }else {
            if($this->Session->check('Userlog') == false) {
                $this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
                $this->Session->write('logurl', $_SERVER['REQUEST_URI']);
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
            }
        }
    }
//******* Paint bucket & texture *******//
    function getTexture(){
        $dirname = 'Texture';
        $image_file_path = WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/';
        $fileArray[0] = $image_file_path;

        $images = array();
        $file_sort = array();
        $allowedTypes = array("jpg","png","gif");

        //print_r($file_sort);
        foreach($fileArray as $fileDir){
            $file_handle = dir($fileDir);
            while (false !== ($entry = $file_handle->read())) {
                if($entry != '.' && $entry != '..' && !is_dir($fileDir.$entry)) {

                    $filetype = explode(".",$entry);

                    $ext = strtolower(end($filetype));

                    if(in_array($ext,$allowedTypes)) {


                        //------------show only images with size 50x50-------------------//

                        $time = filemtime(WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/'.$entry);

                        list($width, $height) = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/'.$entry);

                        if($width == 50 && $height == 50){

                          $realimg = WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/'.$entry;
                         // echo $realimg; exit;
                          $realimg1 = str_replace("tmb_", "1024_tmb_",$realimg);
                          $resizeimage = str_replace("tmb_", "", $realimg);
                          if(!file_exists($realimg1))
                          {
                         system("convert ".$resizeimage."  -resize ".($width*2)."x".($height*2)."! ".$realimg1);

                          }

                           $file_sort[] = 'editorimages/'.$dirname.'/'.$entry;

                            }
                    }
                }
            }
        }
        $file_handle->close();
        return $file_sort;
}

    function getclipart() {
        extract($_POST); 
        $image_file_path = WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/';
         
if($dirname){ 
        $image_file_path = WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/';
        $fileArray[0] = $image_file_path;
      
        $images = array();
        $file_sort = array();
         $allowedTypes = array("jpg","png","gif");
        if(!is_dir($image_file_path))
        { 
        $this->set('limit', 12);
        $this->set('page', 1);
        $this->set('dirname', $dirname);
        $this->set('images', NULL);
        $this->set('class', $class);
        $this->set('id', $id);
        echo "No Cliparts found";
        exit;
        }
        
        //print_r($file_sort);
        foreach($fileArray as $fileDir){ 
            $file_handle = dir($fileDir);
            while (false !== ($entry = $file_handle->read())) {
                if($entry != '.' && $entry != '..' && !is_dir($fileDir.$entry)) {
                   
                    $filetype = explode(".",$entry);
                   
                    $ext = strtolower(end($filetype));
                 
                    if(in_array($ext,$allowedTypes)) {
                       
                       
                        //------------show only images with size 50x50-------------------//
                      
                        $time = filemtime(WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/'.$entry);
                       
                        list($width, $height) = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/'.$entry);
                        //echo substr($entry,0,4);
                        if(substr($entry,0,4)=== 'tmb_'){ 
                           
                          $realimg = WWW_ROOT.IMAGES_URL.'editorimages/'.$dirname.'/'.$entry;
                         // echo $realimg; exit;
                          $realimg1 = str_replace("tmb_", "1024_tmb_",$realimg);
                          $resizeimage = str_replace("tmb_", "", $realimg);
                          if(!file_exists($realimg1))
                          {
                         system("convert ".$resizeimage."  -resize ".($width*2)."x".($height*2)."! ".$realimg1);
              
                          }
                            
                           $file_sort[rand(1,10000)] = 'editorimages/'.$dirname.'/'.$entry;
                          
                            }
                    }
                }
            }
        }
      //  print_r($file_sort);
        $file_handle->close();
       // krsort($file_sort);
              $sess_arr = $this->Session->read('Userlog');
        $uname = $sess_arr['uname'];
        if($dirname==$uname || $dirname=='temp')
        {
            
            $class = 'clipart_container_user';
            $id = 'contentScroll_user';
        }else{
            $class = 'clipart_container';
            $id = 'contentScroll';
        }
    foreach($file_sort as $key=>$val)
    {
       
        if($dirname=='temp')
        { $imagArray = $this->Session->read('session_images');
        if(in_array($val, $imagArray)){
           $images[] = $val;
        }
        }else{
        
        $images[] = $val;
        }
    }
    
   // print_r($images);
        $this->set('limit', 12);
        $this->set('page', $page);
        $this->set('dirname', $dirname);
        $this->set('images', $images);
        $this->set('class', $class);
        $this->set('id', $id);

        $this->layout = 'ajax'; 
    }else{  
        $image_folder_path = WWW_ROOT.IMAGES_URL.'editorimages/';
        $fileArray[0] = $image_file_path;
        $allowedTypes = array("jpg","png","gif");
        $images = array();
        $file_sort = array();
        $userarray = array();
        $user = $this->User->findAll();
        $sess_arr = $this->Session->read('Userlog');
        $uname = $sess_arr['uname'];
        foreach($user as $k => $v) {
             $userarray[] = $v['User']['uname'];
        }
         $results = scandir($image_folder_path);

            foreach ($results as $key=>$result) {
                if ($result === '.' or $result === '..' or $result == 'cropimages' or $result == 'customized' or $result == 'temp' or $result == 'admin') continue;

                if (is_dir($image_folder_path . $result)) {

                    $fileDir = $image_folder_path . $result.'/';
                    $file_handle = dir($fileDir);
            while (false !== ($entry = $file_handle->read())) { 
                if($entry != '.' && $entry != '..' && !is_dir($fileDir.$entry) && $entry!='temp' && !in_array($entry, $userarray)) { 
                    $filetype = explode(".",$entry);
                    $ext = strtolower(end($filetype));
                    if(in_array($ext,$allowedTypes)) {
                       
                        
                        //------------show only images with size 50x50-------------------//
                        $time = filemtime($fileDir.$entry);
                        list($width, $height) = getimagesize($fileDir.$entry);
                        
                        if($width == 50 && $height == 50){ 
                            
                           $realimg = $fileDir.$entry;
                       // echo $realimg; exit;
                          $realimg1 = str_replace("tmb_", "1024_tmb_",$realimg);
                          $resizeimage = str_replace("tmb_", "", $realimg);
                          if(!file_exists($realimg1))
                          {
                         system("convert ".$resizeimage."  -resize ".($width*2)."x".($height*2)."! ".$realimg1);
              
                          }
                            
                            $file_sort[rand(1,10000)] = 'editorimages/'.$result.'/'.$entry;
                            
                            }
                          
                    }
                }
            }
                    
              
                    

                }
            }

 
    //krsort($file_sort);
    foreach($file_sort as $key=>$val)
    {
        $images[] = $val;
    }
        $this->set('limit', 12);
        $this->set('page', $page);
        $this->set('dirname', $dirname);
        $this->set('images', $images);
        $this->set('class', 'clipart_container');
        $this->set('id', 'boxscroll2');
        $this->layout = 'ajax'; 
        
        
        
        
    }
    }
    function getuserclipart() {
        extract($_POST);

        $this->set('limit', 12);
        $this->set('page', $page);
        $clipArray = $this->__readDirectory();

        $this->set('clipArray', $clipArray);
        $this->layout = 'ajax';
    }

    function generateTextImage($msg, $font, $size, $rot, $fore, $outline = 'None', $outlinecolor = 'FFFFFF', $time, $frontRear, $curve, $fontalign, $fontshape, $fontshapesettings, $zindex , $productdetailid) {
        if (isset($msg)) $this->Textgen->msg = stripslashes(base64_decode(strtr($msg, '-_-,', '+/='))); // text to display      
        //print_r($this->Textgen->msg);exit;
        $nfont = explode("{",$font);
        if(!isset($nfont[0])) {
            $nfont[0] = "arial";
        } 
       
        
      


$coords = $this->Customimage->getcoords($productdetailid, $frontRear);
foreach($coords as $key=>$val) {
$imgleft = $coords[$key]['CRD']['x1_axis'];
$imgtop = $coords[$key]['CRD']['y1_axis'];

$imgright = $coords[$key]['CRD']['x2_axis'];
$imgbottom = $coords[$key]['CRD']['y2_axis'];
}

if (isset($imgleft)) $this->Textgen->imgleft = $imgleft;
if (isset($imgtop)) $this->Textgen->imgtop = $imgtop;
if (isset($imgright)) $this->Textgen->imgright = $imgright;
if (isset($imgbottom)) $this->Textgen->imgbottom = $imgbottom;

        if(file_exists(WWW_ROOT.IMAGES_URL."editorfonts/".$nfont[0].".ttf"))
        {
        $fontsm = WWW_ROOT.IMAGES_URL."editorfonts/".$nfont[0].".ttf";
        }else{
             $fontsm = WWW_ROOT.IMAGES_URL."editorfonts/".$nfont[0].".TTF";
        }
        if (isset($font)) $this->Textgen->font = $fontsm; // font to use (include directory if needed).
        if (isset($size)) $this->Textgen->size = $size; // size in points
        if (isset($rot)) $this->Textgen->rot = $rot; // rotation
        if (isset($outline)) $this->Textgen->outline = $outline; // outline if any.
        if (isset($fore)) $this->Textgen->fore = $fore; // text color
        if (isset($outlinecolor)) $this->Textgen->outlinecolor = $outlinecolor; // outlinecolor color.
        if (isset($curve)) $this->Textgen->curve = $curve;
        if (isset($fontalign)) $this->Textgen->allignment = $fontalign;
        if (isset($fontshape)) $this->Textgen->textShape = $fontshape;
        if (isset($fontshapesettings)) $this->Textgen->textShapeSettings = $fontshapesettings;


        $cnfg 				=	Configure::read('Neutrino');
        $sitefolder			=	$cnfg["sitebasefolder"];
        $httpHost	=	$_SERVER['HTTP_HOST'];
        $this->set('sitebase','http://'.$httpHost);
        $this->Textgen->sitefolder = 'http://'.$httpHost.$sitefolder;

        //---------Save the text to temporary table-----------//
        $data = array();
        $data['session_id'] = $this->Session->id();
        $data['x_axis'] = 0;
        $data['y_axis'] = 0;
        $data['content_type'] = 'Text';
        $data['content'] = $this->Textgen->msg;
        $data['font_color'] = $this->Textgen->fore.'{}'.$this->Textgen->outlinecolor;
        $data['font_size'] = $this->Textgen->size;
        $data['font_type'] = $nfont[0].'{}'.$this->Textgen->rot.'{}'.$this->Textgen->outline;
        $data['created_time'] = $time;
        $data['frontrear'] = $frontRear;
        $data['curve'] = $curve;
        $data['align'] = $fontalign;
        $data['shape'] = $fontshape;
        $data['shape_settings'] = $fontshapesettings;
        $data['zindex'] = $zindex;
      

        $isedited = $this->ItemcoordinateSession->findAllByCreatedTime($time);
        if($isedited) {
            //print_r($isedited);
            foreach($isedited as $key => $val) {
                if($val['ItemcoordinateSession']['session_id'] == $this->Session->id()) $data['id'] = $val['ItemcoordinateSession']['id'];
            }
        }

        $this->ItemcoordinateSession->save($data);

        $this->Textgen->draw(); // GO!!!!!
        exit;
    }

    function saveImgToSession() {
        $div_id     = $_REQUEST['div_id'];
        $img_path   = explode("editorimages/", $_REQUEST['img_path']);
        $front_rear = $_REQUEST['front_rear'];

        $if_exists = $this->ItemcoordinateSession->find('first', array('conditions' => array('font_type' => "$div_id", 'session_id' => $this->Session->id())));
        if($if_exists) {
            $data['id']             = $if_exists['ItemcoordinateSession']['id'];
            $data['content']        = $img_path[1];
            $data['flip_count']     = $_REQUEST['flip_count'];
            $data['flop_count']     = $_REQUEST['flop_count'];
            $data['zindex']         = $_REQUEST['zindex'];
            $data['font_color']     = $_REQUEST['font_color'];
            $this->ItemcoordinateSession->save($data);
        }
        else { 
            $data['font_type']      = $img_path;
            $data['frontrear']      = $front_rear;
            $data['content_type']   = 'Image';
            $data['content']        = $img_path[1];
            $data['font_type']      = $div_id;
            $data['session_id']     = $this->Session->id();
            $data['created_time']   = time();
            $data['flip_count']     = isset($_REQUEST['flip_count'])?$_REQUEST['flip_count']:0;
            $data['flop_count']     = isset($_REQUEST['flop_count'])?$_REQUEST['flop_count']:0;
            $data['zindex']         = isset($_REQUEST['zindex'])?$_REQUEST['zindex']:11;
            $data['font_color']     = isset($_REQUEST['font_color'])?$_REQUEST['font_color']:0;
            $this->ItemcoordinateSession->save($data);
         
          
        }

        $this->autoRender = false;
        exit;
    }

    function deleteCoordEntry($time) {
        $sid = $this->Session->id();
        $this->Customimage->delEntry($sid, $time);
        exit;
    }

    function urlEncoder() {
        extract($_POST);
        
        //we encode using javascript encodeURIComponent so revert using php urldecode
        $arrstring= explode("<br>", urldecode($str));
        
        foreach($arrstring as $key => $val){
            $arrResult[$key]=  trim($val);
        }
        $str = implode("\n", $arrResult);
        
        //$str = str_replace("<br>", "<br>", $str);
        //$str = str_replace("<br> ", "<br>", $str);
        //echo $str;exit;

        echo strtr(base64_encode(trim ($str)), '+/=', '-_-,');
        exit;
    }

    function getClipartAttr() {
        extract($_POST);
        $img = str_replace('%20', ' ',$img);
        $parts = explode("/",$img);

        list($width, $height) = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$parts[count($parts)-2].'/'.$parts[count($parts)-1]);
        echo $height."~~".$width;
        exit;
    }

   function resizeClipart() {
           extract($_POST);
        if($height == '' || $height < 20) $height = 20;
        //elseif($height > 200) $height = 200;

        if($width == '' || $width < 20) $width = 20;
        //elseif($width > 200) $width = 200;

        $img = str_replace('%20', ' ',$img);
        $parts = explode("/",$img);
        $image = '';

        //
        $ratio=2;
        
        
        $imgParts = explode("_",$parts[count($parts)-1]);
        for($i = 1; $i < count($imgParts); $i++) {
            if($i <> count($imgParts)-1) $image .= $imgParts[$i]."_";
            else $image .= $imgParts[$i];
        }
        $rand = rand(0,9999);
        $newimage = $rand."_".$image;

        // The original image has to be found if resize has to work perfectly
        // So search all root directories for the image and return the name
        // of the directory containing the image

        $parentDir = $this->__findParentDir($image);
        if($parentDir == '') {
            $parentDir  = 'customized';
            $newimage   = rand(0,9999).'_'.end($parts);
            $image      = end($parts);
        }

        //remove empty spaces in the name
        $newimage = str_replace(' ', '',$newimage);
   if(!$rotate)
   {
       $rotate = 1;
   }
        // No need to resize if the user hasnt changed the attributes
        list($cur_width, $cur_height) = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$parts[count($parts)-2].'/'.$parts[count($parts)-1]);

        if($cur_width == $width && $cur_height == $height && $color == '000000' && $flip == 0 && $flop == 0 && $rotate == 0) {
            echo $height.'~~'.$width.'~~'.'editorimages/'.$parts[count($parts)-2].'/'.$parts[count($parts)-1];
        }
        else {
        	
        	if(IMAGE_PROPRTION)
        	{
        	
             system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/'.$parentDir.'/'.$image."  -background None -rotate $rotate -resize ".$width*$ratio."x".$height*$ratio."! ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$newimage);
        	}
        	
         	system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/'.$parentDir.'/'.$image."  -background None -rotate $rotate -resize ".$width."x".$height."! ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage);       		
            
            
            //only png supports transparency so convert to png
            $img_parts = explode('.', $newimage);
            if(end($img_parts) <> 'png' ) {
                $res_image = time().rand(0, 9999).'.png';
            }
            else {
                $res_image = $newimage;
            }
            
            
            if(IMAGE_PROPRTION)
            {
            	system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$newimage." ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image);                    
             }
            
            system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage." ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image);                    
            
            // vertical flip the image if needed
            if($flip == 1){
            	if(IMAGE_PROPRTION)
            	{
            		system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image."  -flip  ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image);
            		 
            	}
                system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image."  -flip  ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image);
            }
            
            // horizontal flip the image if needed
            if($flop == 1){
            	
            	if(IMAGE_PROPRTION)
            	{
            		system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image."  -flop  ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$newimage);
             		 
            	}
            	
                system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image."  -flop  ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$newimage);
            }
            
                  if($color <> '000000') {
            	
            	if(IMAGE_PROPRTION)
            	{
            		 system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image." -colorspace Gray -fill black  -tint 100 -modulate 110,100,100 ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image);
                     system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image." +level-colors '#".$color."', ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image);
         	
            	}
            	
                system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image." -colorspace Gray -fill black  -tint 100 -modulate 110,100,100 ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image);
                system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image." +level-colors '#".$color."', ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image);
            }
            
            if($textureImg) { 
            // $textureImgPath = WWW_ROOT.IMAGES_URL.'editorimages/Texture/'.end(explode("/",$textureImg));
             $textureImgPath = WWW_ROOT.IMAGES_URL.'editorimages/Texture/'.$textureImg;
             $textureImgPath_1024 = WWW_ROOT.IMAGES_URL.'editorimages/Texture/1024_'.$textureImg;
             if(IMAGE_PROPRTION)
            	{
                   system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image." -tile $textureImgPath_1024  -draw 'color 0,0 reset' ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'."tmptexture_sample.png");
                   system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image." \( -clone 0 -alpha off ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'."tmptexture_sample.png  -composite \) -compose SrcIn -composite ".WWW_ROOT.IMAGES_URL.'editorimages/customized/1024_'.$res_image);
                }

                 system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image." -tile ".$textureImgPath."  -draw ".'"color 0,0 reset"'." ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'."tmptexture_sample.png");
              //   echo "convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image." -tile ".$textureImgPath."  -draw ".'"color 0,0 reset"'." ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'."tmptexture_sample.png".'<br>';
                 //system("convert ".WWW_ROOT.IMAGES_URL."editorimages/customized/$res_image -tile '$textureImgPath'  -draw 'color 0,0 reset' ".WWW_ROOT.IMAGES_URL."editorimages/customized/tmptexture_sample.png");
                 system("convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image." \( -clone 0 -alpha off ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'."tmptexture_sample.png  -composite \) -compose SrcIn -composite ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image);
          //  echo "convert ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image." \( -clone 0 -alpha off ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'."tmptexture_sample.png  -composite \) -compose SrcIn -composite ".WWW_ROOT.IMAGES_URL.'editorimages/customized/'.$res_image;
                 }
           

            echo $height.'~~'.$width.'~~'.'editorimages/customized/'.$res_image;
        }
        exit;
    }

    function __findParentDir($file) {
        Configure::write('debug', 0);
        $fileDir = WWW_ROOT.IMAGES_URL.'editorimages/';

        //--------------Find all directories---------------//
        $file_handle = dir($fileDir);
        while (false !== ($entry = $file_handle->read())) {
            if($entry != '.' && $entry != '..' && is_dir($fileDir.$entry) && $entry <> 'customized') {
                $dirs[] = $entry;
            }
        }
        $file_handle->close();

        //-----------Search each directory--------------//
        foreach($dirs as $dirNames) {
            $img_handle = dir(WWW_ROOT.IMAGES_URL.'editorimages/'.$dirNames.'/');
            while (false !== ($img_entry = $img_handle->read())) {
                if($img_entry != '.' && $img_entry != '..' && $img_entry == $file) {
                    return $dirNames;
                    exit;
                }
            }
        }

    }

    function __readDirectory() {
        Configure::write('debug', 0);
        $sess_arr = $this->Session->read('Userlog');
        $uname = $sess_arr['uname'];
        if($uname==''){
         $admin= $this->Session->read('Admin');
         $uname = $admin['admin_name'];
        }
        
        if($uname == '') $uname = "temp";
        $regEx = '/^tmb_/';

        //$image_file_path = WWW_ROOT.IMAGES_URL.'editorimages/default/';
        $user_file_path = WWW_ROOT.IMAGES_URL."editorimages/".$uname."/";
        if(is_dir($user_file_path)) $fileArray[0] = $user_file_path;
        //$fileArray[1] = $image_file_path;
        $allowedTypes = array("jpg","png","gif");

        if($fileArray) {
            $count = 1;
            foreach($fileArray as $fileDir) {
                $file_handle = dir($fileDir) or die("Wrong path: $fileDir");
                while (false !== ($entry = $file_handle->read())) {
                    if($entry != '.' && $entry != '..' && !is_dir($fileDir.$entry)) {
                        $filetype = explode(".",$entry);
                        $ext = strtolower(end($filetype));
                        if(in_array($ext,$allowedTypes)) {
                            if($count == 1 && preg_match($regEx,$entry)) {
                               // echo $entry;
                                if($uname=='temp')
        { $imagArray = $this->Session->read('session_images');
        if(in_array("editorimages/temp/".$entry, $imagArray)){
           $images[] = "$uname/".$entry;
        }
        }else{
                                    $images[] = "$uname/".$entry;
        }
                            }
                            elseif($count == 2) $images[] = "default/".$entry;
                        }
                    }
                }
                $count++;
            }
            $file_handle->close();
        }
        //print_r($images);
        return $images;
    }

    function __readCategory($dir = '') {
        if($dir == '')	$fileDir = WWW_ROOT.IMAGES_URL.'editorimages/';
        else $fileDir = WWW_ROOT.IMAGES_URL.'editorimages/'.$dir.'/';

        $user = $this->User->findAll();
        $sess_arr = $this->Session->read('Userlog');
        $uname = $sess_arr['uname'];

        foreach($user as $k => $v) {
             $userarray[] = $v['User']['uname'];
        }
        $file_handle = dir($fileDir) or die("Wrong path: $fileDir");
        while (false !== ($entry = $file_handle->read())) {
            if($entry != '.' && $entry != '..' && is_dir($fileDir.$entry) && !in_array($entry, $userarray) && $entry <> 'customized' && !in_array($entry, array('cropimages','customized')) && $entry <> 'temp' &&  $entry <> 'editorimages' &&  $entry <> 'admin') {
                $images[] = $entry;
            }
        }
        $file_handle->close();
        natcasesort ($images);
        return $images;
    }

    function discreet_add($pid='', $optid='', $custid = '', $qty,$customInfo = '') {
       /* echo "descreet<br>";
        echo $pid."<br>";
        echo $optid."<br>";
        echo $custid."<br>";
        echo $qty."<br>";*/
        $this->Cart->create();
        $sus			=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $dat["user_id"]		=	0;
        if(!empty($sus)===true) {
            $dat["user_id"]		=	$sus["id"];
        }
        $sessid	=	$this->Session->id();

        $dat["sess_id"]			=	$this->Session->id();
        $dat["product_id"]		=	$pid;
        $pdet		                =	$this->Product->findById($pid);

        //----------------Get the customization cost---------------------//
        $addnCost = $this->calculateAmt($custid);
        $price = $this->getTieredPrice($pid, $qty,1);
        //echo "price  ".$price;
        //Setting the prices for whole sale and retail users..
        if(isset($sus) && empty($sus)===false) { 
            if($sus["usertype"]=='wholesale') {
                if($pdet["Product"]["wholesale_price"] > 0) {
                    $dat["product_price"]	=	$pdet["Product"]["wholesale_price"];
                }
                else {
                    $dat["product_price"]	=	$pdet["Product"]["price"];
                }
                $dat["price_type"]	=	'W';
            }

            else{ //if($sus["usertype"]=='retail') {
                $dat["product_price"]	=	$pdet["Product"]["price"];
                $dat["price_type"]	=	'R';
            } 
        }

        else{
            $dat["product_price"]	=	$pdet["Product"]["price"];
        }
       if($price!=NULL) {
       	$dat["product_price"]	=$price;
       }
        //Setting the prices for whole sale and retail users..

        $dat["discount_type"]	 =	$pdet["Product"]["discount_type"];
        $dat["discount"]	    =	$pdet["Product"]["discount"];
        $dat["shipping_charge"]	=	$pdet["Product"]["shipping_price"];
        $dat["quantity"]		=	$qty;
        $dat["prodtype"]		=	$pdet["Product"]["prodtype"];
        $dat["type"]		    =	'P';
        $dat["savedimages_id"]		=	$this->Customimage->savedimageidfororder($custid);
        
        //------------------Apply the customization cost--------------------//
        $dat["extra_price"]	= $addnCost;
       if(count($customInfo)>0){
                $dat["custom_information"] = json_encode($customInfo);
       }
        if($optid<>'' && $optid<>0) {

            $dat["option_id"]=	$optid;
            $pcmdet=$this->Productdetail->findById($dat["option_id"]);
            $dat["extra_price"] += $pcmdet["Productdetail"]["extraprice"];            
        }        
      //  echo "data";print_r($dat);exit;
        if($optid <>'' && $optid <> 0) {
            if($pcmdet["Productdetail"]["stock"] < $dat["quantity"]) {

               return false;

             }else {

               $this->Cart->save($dat);
               return true;

             } 
        } else {         
           if($pdet["Product"]["stock"] < $dat["quantity"]) {
               
               return false;

           }else {                   

               $this->Cart->save($dat);
               return true;

           }
        }
             
    }
    
    /**************** get quote **********************/
     /**************************** Add to Orders (send to admin) **************************************/
    function add_order($pid='', $optid='', $custid = '', $qty,$orderId='',$custInfo='') {
       //echo $pid."detail".$optid."saveid".$custid."qty".$qty;exit;
        $this->Order->create();
        $this->OrderDetail->create();
        $sus			=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $dat["user_id"]		=	0;
        if(!empty($sus)===true) {
            $dat["user_id"]		=	$sus["id"];
        }
        $sessid	=	$this->Session->id();
        $orderData["user_id"] = $dat["user_id"];
        $orderData["date"]    = date('Y-m-d'); 
        $orderData["order_status_id"] = 8;        
        $dat["product_id"]		=	$pid;
        $pdet		                =	$this->Product->findById($pid);

        //----------------Get the customization cost---------------------//
        $addnCost = $this->calculateAmt($custid);
         $price = $this->getTieredPrice($pid, $qty,1);
        //Setting the prices for whole sale and retail users..
        if(isset($sus) && empty($sus)===false) {
            if($sus["usertype"]=='wholesale') {
                if($pdet["Product"]["wholesale_price"] > 0) {
                    $dat["product_price"]	=	$pdet["Product"]["wholesale_price"];
                }
                else {
                    $dat["product_price"]	=	$pdet["Product"]["price"];
                }
                $dat["price_type"]	=	'W';
            }

            if($sus["usertype"]=='retail') {
                $dat["product_price"]	=	$pdet["Product"]["price"];
                $dat["price_type"]	=	'R';
            }
        }

   		 else{
            $dat["product_price"]	=	$pdet["Product"]["price"];
        }
       if($price!=NULL) {
       	$dat["product_price"]	=$price;
       }

        //Setting the prices for whole sale and retail users..

        $dat["discount_type"]	 =	$pdet["Product"]["discount_type"];

        $dat["discount"]	        =       $pdet["Product"]["discount"];        

        $dat["quantity"]		=	$qty;

        $dat["prodtype"]		=	$pdet["Product"]["prodtype"];

        $dat["type"]		    =	'P';

        $dat["savedimages_id"]		=	$this->Customimage->savedimageidfororder($custid);
        $productname                    = $pdet["Product"]["pname"];

        //------------------Apply the customization cost--------------------//
        $dat["extra_price"]	= $addnCost;
        
        
          if($dat["discount_type"]=='per' && $dat["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $dat["product_price"] * $dat["discount"] / 100;

		  else if($dat["discount_type"]=='amnt' && $dat["discount"] > 0)

		  $dis_amnt=$dat["discount"];		

		  $dis_amnt=number_format($dis_amnt,2,'.','');
       
        if($optid<>'' && $optid<>0) {

            $dat["combination_id"]=	$optid;

            $pcmdet=$this->Productdetail->findById($dat["combination_id"]);

            $dat["extra_price"] += $pcmdet["Productdetail"]["extraprice"];            
        }

        else
            $optid='';

         $data1	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
        
   
        $orderData['currency_type'] = $data1["currency"];
        $netprice = ($dat["product_price"]+ $dat["extra_price"])-$dis_amnt;
        $orderData["total_price"] = $netprice * $qty ;
        
       
             if(count($custInfo)>0){
                $dat["custom_information"] = json_encode($custInfo);
                }   
             if($optid<>'' && $optid<>0) {
                /* if($pcmdet["Productdetail"]["stock"] < $dat["quantity"]) {
                 $this->Session->setFlash('Sorry,There is not enough stock available for the product you requested!', 'default',array('class'=> 'failure'));

                  }else {*/
             	//echo "<pre";print_r($orderData);exit;
                   if($orderId) {    
                  $dat['order_id'] = $orderId;       
                  $this->OrderDetail->save($dat);
                   $this->Order->updatePrice($orderData,$orderId);
                   }else{
                  $orderId=$this->Order->savetoAdmin($orderData);
                  $dat['order_id'] = $orderId;       
                  $this->OrderDetail->save($dat);
                       
                   } 
             } else {         
               /* if($pdet["Product"]["stock"] < $dat["quantity"]) {
                    $this->Session->setFlash('Sorry,There is not enough stock available for the product you requested!', 'default',array('class'=> 'failure'));

                }else {       */            
                     if(true) { 
                    $orderId=$this->Order->savetoAdmin($orderData);
                    $dat['order_id'] = $orderId;
                    $this->OrderDetail->save($dat);
                }
             }
     return $orderId;
					}			
    /*************** get quote  **/
    
    
    
    
    /**************************** Add to Orders (send to admin) **************************************/
    function add_quote($pid='', $optid='', $custid = '', $qty,$orderId='',$custInfo='') {
       //echo $pid."detail".$optid."saveid".$custid."qty".$qty;exit;
        $this->Order->create();
        $this->OrderDetail->create();
        $sus			=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $dat["user_id"]		=	0;
        if(!empty($sus)===true) {
            $dat["user_id"]		=	$sus["id"];
        }
        $sessid	=	$this->Session->id();
        $orderData["user_id"] = $dat["user_id"];
        $orderData["date"]    = date('Y-m-d'); 
        $orderData["order_status_id"] = 1;        
        $dat["product_id"]		=	$pid;
        $pdet		                =	$this->Product->findById($pid);

        //----------------Get the customization cost---------------------//
        $addnCost = $this->calculateAmt($custid);
        $price = $this->getTieredPrice($pid, $qty,1);
  $data1	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
        
   
        $orderData['currency_type'] = $data1["currency"];
        //Setting the prices for whole sale and retail users..
        if(isset($sus) && empty($sus)===false) {
            if($sus["usertype"]=='wholesale') {
                if($pdet["Product"]["wholesale_price"] > 0) {
                    $dat["product_price"]	=	$pdet["Product"]["wholesale_price"];
                }
                else {
                    $dat["product_price"]	=	$pdet["Product"]["price"];
                }
                $dat["price_type"]	=	'W';
            }

            if($sus["usertype"]=='retail') {
                $dat["product_price"]	=	$pdet["Product"]["price"];
                $dat["price_type"]	=	'R';
            }
        }

         else{
            $dat["product_price"]	=	$pdet["Product"]["price"];
        }
       if($price!=NULL) {
       	$dat["product_price"]	=$price;
       }

        //Setting the prices for whole sale and retail users..

        $dat["discount_type"]	 =	$pdet["Product"]["discount_type"];

        $dat["discount"]	        =       $pdet["Product"]["discount"];        

        $dat["quantity"]		=	$qty;

        $dat["prodtype"]		=	$pdet["Product"]["prodtype"];

        $dat["type"]		    =	'P';

        
        
        
        //SELECT `id` FROM `PrintLogic_savedimages` WHERE `ref_name`=(SELECT `ref_name` FROM `PrintLogic_savedimages` WHERE `id`=2653) ORDER BY `id` ASC
        
        $dat["savedimages_id"]		=	$this->Customimage->savedimageidfororder($custid);
        $productname                    = $pdet["Product"]["pname"];

        //------------------Apply the customization cost--------------------//
        $dat["extra_price"]	= $addnCost;
        
        
          if($dat["discount_type"]=='per' && $dat["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $dat["product_price"] * $dat["discount"] / 100;

		  else if($dat["discount_type"]=='amnt' && $dat["discount"] > 0)

		  $dis_amnt=$dat["discount"];		

		  $dis_amnt=number_format($dis_amnt,2,'.','');
       
        if($optid<>'' && $optid<>0) {

            $dat["combination_id"]=	$optid;

            $pcmdet=$this->Productdetail->findById($dat["combination_id"]);

            $dat["extra_price"] += $pcmdet["Productdetail"]["extraprice"];            
        }

        else
            $optid='';

        $netprice = ($dat["product_price"]+ $dat["extra_price"])-$dis_amnt;
        $orderData["total_price"] = $netprice * $qty ;
          if(count($custInfo)>0){
                $dat["custom_information"] = json_encode($custInfo);
                }   
             if($optid<>'' && $optid<>0) {
                /* if($pcmdet["Productdetail"]["stock"] < $dat["quantity"]) {
                 $this->Session->setFlash('Sorry,There is not enough stock available for the product you requested!', 'default',array('class'=> 'failure'));

                  }else {*/
                   if($orderId) {    
                  $dat['order_id'] = $orderId;       
                  $this->OrderDetail->save($dat);
                   $this->Order->updatePrice($orderData,$orderId);
                   }else{
                  $orderId=$this->Order->savetoAdmin($orderData);
                  $dat['order_id'] = $orderId;       
                  $this->OrderDetail->save($dat);
                       
                   } 
             } else {         
               /* if($pdet["Product"]["stock"] < $dat["quantity"]) {
                    $this->Session->setFlash('Sorry,There is not enough stock available for the product you requested!', 'default',array('class'=> 'failure'));

                }else {       */            
                     if(true) { 
                    $orderId=$this->Order->savetoAdmin($orderData);
                    $dat['order_id'] = $orderId;
                    $this->OrderDetail->save($dat);
                }
             }
     
return $orderId;

					}			
    /*****************************Add****************************************/
function files($path,&$files = array())
{
    $dir = opendir($path."/.");
    while($item = readdir($dir))
        if(is_file($sub = $path."/".$item))
            $files[] = $item;else
            if($item != "." and $item != "..")
                $this->files($sub,$files); 
    return($files);
}
    function calculateAmt($custID) {
        $addtionalCost = 0;
        if($custID == '') {
            return 0;
            exit;
        }

        // STEP 1: Find the front & read id's of the saved image
        $imgArr = $this->Savedimage->findById($custID);
        $images = $this->Savedimage->findAllByRefName($imgArr['Savedimage']['ref_name']);
        foreach($images as $val) {
            $img[] = $val['Savedimage']['id'];
        }

        // STEP 2: Get the entries from the settings table
        $first_imagecost = $this->Setting->findByFieldname('first_image');
        $addn_imagecost = $this->Setting->findByFieldname('addn_image');
        $first_textcost = $this->Setting->findByFieldname('first_text');
        $addn_textcost = $this->Setting->findByFieldname('addn_text');

        // STEP 3: Find the entries in coordinates tbl for each id
        $imgCount = $txtCount = 0;
        foreach($img as $imgkey => $imgval) {
            $coords = $this->Itemcoordinate->findAllBySavedimagesId($imgval);
            if($coords) {
                foreach($coords as $cval) {
                    switch($cval['Itemcoordinate']['content_type']) {
                        case "Image":
                            $customArray[$imgkey]['Image'][] = $cval['Itemcoordinate']['content'];
                            break;
                        case "Text":
                            $customArray[$imgkey]['Text'][] = $cval['Itemcoordinate']['font_color'];
                            break;
                    }
                }
            }
            if(!empty($customArray[$imgkey]['Text'])) {
                $chkArray = array('000000{}000000');
                foreach($customArray[$imgkey]['Text'] as $tk => $tv) { 
                    if(!in_array($tv, $chkArray)) {
                        array_push($chkArray, $tv);
                        if($txtCount == 0) $addtionalCost += intval($first_textcost['Setting']['value']);
                        else $addtionalCost += intval($addn_textcost['Setting']['value']);
                        $txtCount++;
                    }
                }
            }

            if(!empty($customArray[$imgkey]['Image'])) {
                $sus = $this->Session->read('Userlog');
                foreach($customArray[$imgkey]['Image'] as $ik => $iv) { 
                    $imgPath = explode('/', $iv);
                    $imgNamepatr = explode('_',$imgPath[1]);
                    $imgpatr = explode('.', $imgNamepatr[1]);
                  
                    $image_file_user_path = WWW_ROOT.IMAGES_URL.'editorimages/'.$sus['uname'].'/';
                    $files = implode('-',$this->files($image_file_user_path));
                   
                    $image_file_admin_path = WWW_ROOT.IMAGES_URL.'editorimages/admin/';
                    $admin_files = implode('-',$this->files($image_file_admin_path));
                    
                    $image_file_temp_path = WWW_ROOT.IMAGES_URL.'editorimages/temp/';
                    $temp_files = implode('-',$this->files($image_file_temp_path));
                    
                    
                    if(!stristr($iv, $sus['uname']) && !stristr($files,$imgpatr[0]) && !stristr($admin_files,$imgpatr[0]) && !stristr($temp_files,$imgpatr[0]) && !stristr($iv, 'temp')) {

                    }
                    else {
                        if($imgCount == 0) $addtionalCost += intval($first_imagecost['Setting']['value']);
                        else $addtionalCost += intval($addn_imagecost['Setting']['value']);
                        $imgCount++;
                    }
                }
            }

        }

        return $addtionalCost;
        exit;
    }

    function custominvitation($savID = null)
    {        
        $this->set('savID', $savID);

        $success_msg = NULL; // Success Message

        //User Name
        $user_name = NULL;
        $sus	=	$this->Session->read('Userlog');
        if(!empty($sus)===true) {
            $user_id = $sus["id"];
            $user_name=$sus["uname"]; // logged in user name
        }


        if(isset($_POST['sendInvitation'])) {

            $recipients = $_POST['uEmail'];
            
            if(!empty($recipients)) {
                $i=0;
                foreach($recipients as $rk => $rw) {
                    if(!empty($_POST['savID']) && trim($rw) <> '') {   

                        //-----------------------------------------Email Section-----------------------------------------//
                        $cnfg 			=	Configure::read('Neutrino');
                        $subject 		= (!empty($user_name)) ? "Your friend '".stripslashes($user_name)."' has sent you an invitation to view his/her design at ".$cnfg["site_name"] : "Your friend has sent you an invitation to view his/her design at ".$cnfg["site_name"];
                        $headers 		= "MIME-Version: 1.0\r\n";
                        $headers                .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
                        $headers                .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
                        $headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
                        $headers                .= "Organization: ".$cnfg["site_name"]."\r\n";
                        $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

                        $to			= $rw;
                        $friend_name            = $_POST['uFname'][$rk]." ".$_POST['uLname'][$rk];

                        $pictureLink            = 'http://'.$_SERVER['SERVER_NAME'].$cnfg["sitebasefolder"].'/img/SiteLogo_disp.gif'; //can be blank

                        $signatureLink          = 'http://'.$_SERVER['SERVER_NAME'].$cnfg["sitebasefolder"].'/customimages/generalview/'.$_POST['savID'];
$mailcontent = "<img src='".$pictureLink."' alt='".$cnfg["site_name"]."'/><br></br>";
                        $mailcontent		.= "Hi $friend_name,<br></br>";
                        $mailcontent		.= (!empty($user_name)) ? "Your friend '".stripslashes($user_name)."' has sent you an invitation to view his/her design at ".$cnfg["site_name"] : "Your friend has sent you an invitation to view his/her design at ".$cnfg["site_name"];
                        $mailcontent		.= ':</br></br>'.stripslashes($_POST['invtationMsg']).'</br></br>';

                        $mailcontent    .=  "<table width='100%' border='0' cellspacing='2' cellpadding='2' align='center' id='custom_invitation'>
				   <tr bgcolor='#FFFFFF'>
                                       
                                        <td><a href='".$signatureLink."' target='_blank'>Please click here to view the design.</a>
                                          
                                        </td>
                                   </tr>
				  </table>
                                  <br></br>
                                  <br></br>
                                  With Regards
                                 <br> </br>
                           
                                  ".$cnfg["site_name"]; 
                        
                        $mailsent = @mail($to,$subject,$mailcontent,$headers);
                    }
                    $i++;
                }
                if($mailsent) {
                    $success_msg='<font style="color:#4CC94E;">Your Invitation has been sent!!</font>';
                }
            }

        }
        $this->set('success_msg', $success_msg);
        $this->layout='custominvitation';
    }

    function generalview($savID = 0)
    {
       $saved_img = $this->Savedimage->findById($savID);
       if($savID <> 0 && $saved_img){
           $user = $this->User->findById($saved_img['Savedimage']['users_id']);
$imgArray = array();
           $image_name = $this->Savedimage->findAllByRefName($saved_img['Savedimage']['ref_name']);
           foreach($image_name as $image_val){
              
                   $imgArray[] = $image_val['Savedimage']['image'];
              
              
                  
              
           }

           $this->set('front_image', $front_image);
           $this->set('rear_image', $rear_image);
            $this->set('imgArray', $imgArray);
           $this->set('user_name', $user['User']['uname']);
       }
       else{
           $this->redirect(array('controller' => 'products', 'action' => 'allproducts'));
           exit;
       }
    }

    function beforeFilter() {
        if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }
        global $sitefolder;
        global $meta_description;
        global $meta_keywords;
        global $page_title;
        global $currency;
        $cnfg 				=	Configure::read('Neutrino');
        $sitefolder			=	$cnfg["sitebasefolder"];
        $currency			=	$cnfg["currency"];
        $meta_description               =	$cnfg["meta_description"];
        $meta_keywords                  =	$cnfg["meta_keywords"];
        $page_title			=	$cnfg["page_title"];
        global $style;
        $style				=	$cnfg["style"];
        $this->site_timezone		=	$cnfg["site_timezone"];

        $this->set('style', $style);
        $this->set('meta_description', $meta_description);
        $this->set('meta_keywords', $meta_keywords);
        $this->pageTitle = $page_title	;
        $this->set('cnfg',$cnfg);
        $this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.
        $this->set('sitefolder', $sitefolder);
        $httpHost	=	$_SERVER['HTTP_HOST'];
        $this->set('sitebase','http://'.$httpHost);
    }

    function beforeRender() {
        $lst	=	$this->Category->find('all',array('order' => array('position' => 'ASC')));
        if(empty($lst)===false) {
            foreach($lst as $det)
                $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);
            $this->set('menu_array', $menu_array);
        }
        $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
        $this->set('footerlinks', $footer_links);

        $sus			=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $pages =    $this->Dynamicpage->getpages();
        //echo "hello<pre>";print_r($pages);
        $this->set('pagesdynamic', $pages);
    }

    /*
         * delete all images that were created during design
    */
    function cleanUpImages() {
        $logoImages = array();

        //images from user designs
        $thumbs = $this->Itemcoordinate->find('all', array('conditions' => array("content_type" => "image")));
        if($thumbs) {
            foreach($thumbs as $thumbVal) {
                unset($image);
                $image = explode('/', $thumbVal['Itemcoordinate']['content']);
                $logoImages[] = end($image);
            }
        }

        $customizations = $this->Savedimage->find('all');
        if($customizations) {
            foreach($customizations as $custVal) {
                unset($image);
                $image = explode('/', $custVal['Savedimage']['foreground_image']);
                $logoImages[] = end($image);
            }
        }

        //get all the saved images
        $op = $this->__readDir();

        //echo'<pre>';print_r($logoImages);echo'</pre>';
        //echo'<pre>';print_r($op);echo'</pre>';

        /*
             * default is America/New_York - EDT need to set it in the installer
        */

        date_default_timezone_set($this->site_timezone);
        //date_default_timezone_set('Asia/Calcutta');
        $clearCacheTime = strtotime("-30 minutes", time());

        if(!empty($op[0])) {
            foreach($op[0] as $imgKey => $imgVal) {
                if(!in_array($imgVal, $logoImages)) {
                    //this image has not been saved
                    if($clearCacheTime > $op[2][$imgKey]) {
                        //this is an old image so remove it
                        if(is_file(WWW_ROOT.IMAGES_URL.$op[1][$imgKey].$imgVal)) {
                            @chmod(WWW_ROOT.IMAGES_URL.$op[1][$imgKey].$imgVal, 0777);
                            @unlink(WWW_ROOT.IMAGES_URL.$op[1][$imgKey].$imgVal);
                        }
                    }
                }
            }
        }

        exit;
    }

    function __readDir() {
        $directories = array('editorimages/customized/', 'customized_tshirts/', 'customized_tshirts_foreground/');
        $allowedTypes = array("jpg","png","gif","bmp");
        $savedImages = array();
        $savedimagePath = array();
        $savedimageModTime = array();

        foreach($directories as $fileDir) {
            $file_handle = dir(WWW_ROOT.IMAGES_URL.$fileDir);
            while(false !== ($entry = $file_handle->read())) {
                if($entry != '.' && $entry != '..' && !is_dir($fileDir.$entry)) {
                    $filetype = explode(".",$entry);
                    $ext = strtolower(end($filetype));
                    if(in_array($ext,$allowedTypes)) {
                        $savedImages[] = $entry;
                        $savedimagePath[] = $fileDir;
                        $savedimageModTime[] = filemtime(utf8_decode(WWW_ROOT.IMAGES_URL.$fileDir.$entry));
                    }
                }
            }
        }
        $file_handle->close();

        return array($savedImages, $savedimagePath, $savedimageModTime);
    }
    
   function saveMonogram(){
        $imageInBase64  =   $_POST['image'];
        if($imageInBase64){
            $decoded        =   base64_decode(str_replace('data:image/png;base64,', '', $imageInBase64));
            $pngName        =   date('YmdHis').'.png';
            $return         =   file_put_contents(WWW_ROOT.IMAGES_URL.'editorimages/temp/'.$pngName,$decoded);
            $return         =   file_put_contents(WWW_ROOT.IMAGES_URL.'editorimages/temp/tmb_'.$pngName,$decoded);
            if($return) echo  IMAGES_URL .'editorimages/temp/tmb_' .$pngName;
            else echo 'fail';
            exit;
        }
        echo 'fail'; exit;
        exit;
    }
   
    /****************************/
 //    function richeditor($combID, $frontRear = 'Front', $timestamp = '', $savID = 0, $rotID = 0, $swap = 0) {
     function richeditor($combID, $frontRear = 'Front', $timestamp = '', $savID = 0, $swap = 0) {
         
        // echo WWW_ROOT;
   /* echo "<pre>";print_r($this->data);
    echo "<br>";
    print_r($_POST);
    exit;*/
         $cnfg 				=	Configure::read('Neutrino');
    // echo $cnfg["sitebasefolder"]; exit;
    /* echo "<pre>";
     print_r($_SESSION);exit;*/ 

 		$sendAdmin =  $this->Session->read('sendadmin');        
     
                
              
        if( ($savID!=0 ) && ($savID!='') && ($timestamp!='' && $timestamp!=0)  )
        {
            
            $this->Session->write('ImgProp.savID', $savID);
            $this->Session->write('ImgProp.SideID', $frontRear);
            $this->Session->write('ImgProp.timestamp', $timestamp);
            
            
        }else{
            
         
            $this->Session->write('ImgProp.savID', '');
            $this->Session->write('ImgProp.SideID', '');
            $this->Session->write('ImgProp.timestamp', '');
        }
          /*          To Delete Customization on PAGE Reload                            */
        
        
        /* if($frontRear=='Front' && $timestamp=='' &&  $swap==''){
        $this->Customimage->delEntries($this->Session->id(), $frontRear); 
        }*/
        
          /**                 ******                  To Delete Customization on PAGE Reload    ****    */
        
       // print_r($_SESSION);
              $sess_arr = $this->Session->read('Userlog');
              if(isset($sess_arr) && empty($sess_arr)===false){     
              $this->set('sus', $sess_arr);
              $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sess_arr['id'])));  
              }  
              else {
              $this->set('sus', ''); 
              $sessid   =   $this->Session->id();
              $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid))); 
             }
              $this->set('cartcount', count($citem));
              $uname = $sess_arr['uname'];
              $this->set('uname', $uname);
        if(empty($this->data)) {            
          
          $divArray = $this->Customimage->findEntry($this->Session->id(), $frontRear);
              $this->set('divArray', $divArray);
            $regions = array("Front" => 'noimages.gif', "Rear" => 'noimages.gif');
            $img = $this->Customimage->findAllByProductdetailsId($combID);
  
            $prod = $this->Product->findById($combID);
            
               $prod_detailss = $this->Productdetail->findById($combID);
            
              // echo "<pre>";print_r($prod_detailss);exit;
            
            $productname= $prod['Product']['pname'];
          $product_id= $prod_detailss['Productdetail']['product_id'];
//            echo $product_id; exit;
            $this->set('product_id',$product_id);
            $ID = '';
            if(is_array($img)) {

                foreach($img as $key=>$val) {

                    $regions[$img[$key]['Customimage']['type']] = $img[$key]['Customimage']['image'];
                    $prod_detail = $this->Productdetail->findById($combID);
                    $imagethumparray["doublesided"]=$prod_detail['Productdetail']['doublesided'];
                    $imagetype=$img[$key]['Customimage']['type'];
                    $imagename=$img[$key]['Customimage']['image'];
                    $imagethumparray[$imagetype]=$imagename;
                    if($img[$key]['Customimage']['type'] == $frontRear) $ID = $img[$key]['Customimage']['productdetails_id'];
                }
            }

//Swap based on product compination
            $swapcomps_new=$this->Customimage->swapcomp($combID);

            foreach ($swapcomps_new as $swapcomp)
            {
            	
            	$customvalue_ids=explode(",",$swapcomp['c']['customvalue_id']);
        		
        		
            	foreach ($customvalue_ids as $customvalue_id)
            	{
            	
            	$combnstr=$this->Product->getpdctcmbn($customvalue_id);
            	
            		if(!empty($combnstr))
            			{
            				$combination[]=$combnstr;
            			}
            	}
            	
            	$combinations=implode(", ",$combination);
            	unset($combination);
            	$swapcomp['c']['combination']=$combinations;
            	$swapcomps[]=$swapcomp;
            }
           
           $this->set("swapcomps",$swapcomps);          
            
            

            if($imagethumparray['doublesided']==N)
            {
            	unset($imagethumparray['Rear']);
            }
		    unset($imagethumparray['doublesided']);
		    
          	$this->set("imagethumparray",$imagethumparray);
            
            
            if(!$ID) { 
                $prod_detail = $this->Productdetail->findById($combID);
                $prod        = $this->Product->findById($prod_detail['Productdetail']['product_id']);
                //echo "<pre>";print_r($prod);exit;

                if($this->Session->read('tempUser')) {
                    $this->Session->setFlash('Sorry, No customizable image is avaialable for this combination.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'products', 'action' => 'customize'));
                }
                else {
                    $this->Session->setFlash('Sorry, No customizable image is avaialable for this combination.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'products', 'action' => 'show/'.$prod['Product']['pname'].'/'.$prod['Product']['id']));
                }
                exit;
            }
            $coords = $this->Customimage->getcoords($ID, $frontRear);//print_r($coords);
            $fonts = $this->Font->find('list', array('fields' => array('Font.name', 'Font.name'), 'conditions' => array('Font.status' => 1)));
            $txtsize = array("4" => "4", "6" => "6", "8" => "8", "10" => "10", "12" => "12", "14" => "14", "16" => "16");
            $outline = array("None" => "None", "Thin" => "Thin", "Medium" => "Medium", "Thick" => "Thick");
            $txtcurve = array("0" => "None", "140" => "Small", "180" => "Medium", "220" => "Large");
            
            $txtshape = array("normal" => "Normal", "roof" => "Roof", "arc" => "Arch", "curve" => "Curve", "wedge" => "Wedge");
            
            $txtshapeSettings["normal"] = array('0' => 'None');
            
            $txtshapeSettings["roof"]   = array('1' => 'Top Small', 
                                                '2' => 'Top Medium', 
                                                '3' => 'Top Large', 
                                                '4' => 'Middle Small', 
                                                '5' => 'Middle Medium', 
                                                '6' => 'Middle Large', 
                                                '7' => 'Bottom Small', 
                                                '8' => 'Bottom Medium', 
                                                '9' => 'Bottom Large', 
                                                '10' => 'Left Small', 
                                                '11' => 'Left Medium', 
                                                '12' => 'Left Large', 
                                                '13' => 'Right Small', 
                                                '14' => 'Right Medium', 
                                                '15' => 'Right Large');
            
            $txtshapeSettings["wedge"]  = array('1' => 'Up Widen Slow', 
                                                '2' => 'Up Widen Medium', 
                                                '3' => 'Up Widen Fast', 
                                                '4' => 'Up Narrow Slow', 
                                                '5' => 'Up Narrow Medium', 
                                                '6' => 'Up Narrow Fast', 
                                                '7' => 'Middle Widen Slow', 
                                                '8' => 'Middle Widen Medium', 
                                                '9' => 'Middle Widen Fast', 
                                                '10' => 'Middle Widen Slow', 
                                                '11' => 'Middle Widen Medium', 
                                                '12' => 'Middle Widen Fast', 
                                                '13' => 'Down Widen Slow', 
                                                '14' => 'Down Widen Medium', 
                                                '15' => 'Down Widen Fast',
                                                '16' => 'Down Narrow Slow',
                                                '17' => 'Down Narrow Medium',
                                                '18' => 'Down Narrow Fast');
            
            $txtshapeSettings["arc"]    = array('1' => 'Up Very Small', 
                                                '2' => 'Up Small', 
                                                '3' => 'Up Medium', 
                                                '4' => 'Up Large', 
                                                '5' => 'Up Very Lage', 
                                                '6' => 'Down Very Small', 
                                                '7' => 'Down small', 
                                                '8' => 'Down Medium', 
                                                '9' => 'Down Large', 
                                                '10' => 'Down very Large');
            
            $txtshapeSettings["curve"]  = array('1' => 'Up Very Sharp', 
                                                '2' => 'Up Sharp', 
                                                '3' => 'Up Medium', 
                                                '4' => 'Up Slight', 
                                                '5' => 'Up Very Slight', 
                                                '6' => 'Up Super Slight', 
                                                '7' => 'Down Very Sharp', 
                                                '8' => 'Down Sharp', 
                                                '9' => 'Down Medium', 
                                                '10' => 'Down Slight',
                                                '11' => 'Down Very Slight', 
                                                '12' => 'Down Super Slight');
            
            $this->set('limit', 12);
            $this->set('page', 1);
            $clipArray = $this->__readDirectory();

            $imageArray = $this->__readCategory();

            $userclips = $this->Setting->findByFieldname('userclipart');
            $this->set('userclips', $userclips['Setting']['value']);

            //-------------------Get the entries from the settings table---------------------------------
            $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr			=	$this->Currency->findByCode($data["currency"] );
            $this->set('pcurr', $curr["Currency"]["logo"]);

            $first_imagecost = $this->Setting->findByFieldname('first_image');
            $addn_imagecost = $this->Setting->findByFieldname('addn_image');
            $first_textcost = $this->Setting->findByFieldname('first_text');
            $addn_textcost = $this->Setting->findByFieldname('addn_text');

            $this->set("first_imagecost",$first_imagecost['Setting']['value']);
            $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
            $this->set("first_textcost",$first_textcost['Setting']['value']);
            $this->set("addn_textcost",$addn_textcost['Setting']['value']);
            //---------------------------------------------------------------------------------------------

            $this->set('coords', $coords);
            $this->set('fonts', $fonts);
            $this->set('txtsize', $txtsize);
            $this->set('outline', $outline);
            $this->set('frontRear', $frontRear);
            $this->set('productdetailid', $combID);
            $this->set('image_front', $regions[$frontRear]);
            $this->set('imageArray', $imageArray);
            $this->set('clipArray', $clipArray);
            $this->set('txtcurve', $txtcurve);
            $this->set('txtshape', $txtshape);
            $this->set('txtshapeSettings', $txtshapeSettings);
            $palette = $this->Palette->find('all', array('conditions' => array('Palette.status' => '1'), 'orderby' => array('Palette.id')));
            $this->set('palette',$palette);
            $this->set('Productname', $productname);
            $this->set('product_id', $product_id);
            

            //---------------UID---------------//
            ($timestamp == '' || $timestamp == 0) ? $timestamp = time() : $timestamp;
            $this->set('timestamp', $timestamp);

            //----------------Edit details------------------------//
            
            if(!$savID)
            {
                //$savID = $_SESSION['ImgProp']['last_id'];
            }
            
            if($savID) {
                $divArray = $this->Customimage->findUserItems($savID);
                
                $this->set('divArray', $divArray);

                $this->set('rotID', $rotID);
            }

            //---------------If item is being swapped-----------//
          
            if($swap) {
                $divArray = $this->Customimage->findEntry($this->Session->id(), $frontRear);
                $this->set('divArray', $divArray);

                $this->set('rotID', $rotID);
            }
            $this->Customimage->delEntries($this->Session->id(), $frontRear); // clear the table as new entries will be created on page load

            
            
            
            $this->set('savID', $savID);

            //----------customfieldvalues--------------//
            $prod_details = $this->Productdetail->findById($combID);
            $prod = $this->Product->findById($prod_details['Productdetail']['product_id']); // u need to get the default attr
            $defaultattr = $prod['Product']['defaultattribute'];
            $custvalues = $this->Customfieldvalue->findAllByCustomfieldId($defaultattr);
            foreach($custvalues as $key => $val) {
                $cfArray[] = $val['Customfieldvalue']['id'];
            }
           
            $this->set('doublesided', $prod_details['Productdetail']['doublesided']);

            $tArray = explode(",", $prod_details['Productdetail']['customvalue_id']);
            foreach($tArray as $val) {
                if(in_array($val, $cfArray)) $setParam = $val;
            }
           
            $prod_comb = $this->Productdetail->findAllByProductId($prod_details['Productdetail']['product_id']);
           
            $paramVal = $this->Customfieldvalue->findById($setParam);
            
            $this->set('defaultvalue', $paramVal['Customfieldvalue']['custom_value']);
            foreach($prod_comb as $k => $v) {
                $name = '';

                $tArray2 = explode(",", $v['Productdetail']['customvalue_id']);
                //echo $v['Productdetail']['customvalue_id'];exit;
                if(in_array($setParam, $tArray2)) {
                    //$res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], $setParam);
                    $res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], 2);
                    //print_r($res);exit;
                    $j = 1;                    
                    foreach($res as $k2 => $v2) {
                        if(count($res) <> $j) $name .= $v2['CFV']['custom_value'].',';
                        else $name .= $v2['CFV']['custom_value'];
                        $j++;
                    }
                    $combArray[$v['Productdetail']['id']] = $name;
                    $stockArray[$v['Productdetail']['id']] = $v['Productdetail']['stock'];
                }
            }
            //echo "<pre>";print_r($combArray);exit;
            $this->set('stockArray', $stockArray);
            $this->set('combArray', $combArray);

            //--------------Category List--------------------//
            $lst	=	$this->Category->findAll();
            if(empty($lst)===false) {
                foreach($lst as $det)
                    $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
                $this->set('menu_array', $menu_array);
            }

            if($this->Session->read('tempUser')) {
                $adm_user = $this->Session->read('tempUser');
            }
            else {
                $adm_user = 0;
            }
           
            $this->set('adm_user', $adm_user);
        }

        $logged_in = 0;
        $sess_arr = $this->Session->read('Userlog');
        if($sess_arr['id'] != "") {
            $logged_in = 1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
        }
        $this->set('userStatus', $logged_in);

       
            $this->set('adminUser_flag', 0);
            
            
            global $currency; 
		$curr		=	$this->Currency->findByCode($currency);
		$this->set('curlogo',$curr["Currency"]["logo"]);
            
                
                $combnstr = array();
                $combinations = array();
                $cutomfieldarray = array();
                $allcutomfieldarray = array();
                $cunstomfield_name = array();
                 //----- Tiered price ----//
                 $prod1 = $this->Productdetail->findById($combID);
                $pcombndet	=	$this->Productdetail->findAllByProductId($prod1['Productdetail']['product_id']);
               // echo "<pre>";print_r($pcombndet);exit;
                
                $customfied = array();
               for($i=0;$i<count($pcombndet);$i++) {

                  $pcmbnids=$pcombndet[$i]["Productdetail"]["customvalue_id"];

                  $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                       if($val!='') { 
                           $combnstr[]=$this->Product->getpdctcmbn($val);
                           $this->Product->getpdctcmbn($val);
                           $combinations=implode(", ",$combnstr);
                           $pcombndet[$i]["Productdetail"]["combinations"]= $combinations;
                           $customfied[$key][$val] = $this->Product->getpdctcmbn($val);
                           $cunstomfield_name[$key] = $this->Product->getpdctcmbnfield($val);
                        }

                    }
                 
                   unset($combnstr);
                    unset($combinations);

                }
                //print_r($customfied);
                $this->set('pcombndet', $pcombndet);
                $this->set('customfied', $customfied);
                $this->set("cunstomfield_name",$cunstomfield_name);
              /*********** ***********************/
                
         
                $textureImgArr = $this->getTexture(); //print_r($textureImgArr); exit;
                $this->set('textureImgs', $textureImgArr);
                
                $ruler_data = $this->Ruler->findById($prod['Product']['vertical_ruler']);
                $this->set('vertical_ruler',$ruler_data['Ruler']['ruler_setting']);
                
                
                
            $this->layout = 'editor';
        
    }
    /******************************/
    
        
    
    
    
    
     /****************************/
     function admin_richeditor($combID, $frontRear = 'Front', $timestamp = '', $savID = 0, $swap = 0) {
   /* echo "<pre>";print_r($this->data);
    echo "<br>";
    print_r($_POST);
    exit;*/
     
    /* echo "<pre>";
     print_r($_SESSION);exit;*/ 

         
 $sendAdmin =  $this->Session->read('sendadmin');        
 $admin = $this->Session->read('Admin');
 
 $this->set('admin_name',$admin['admin_name']);
       if( ($savID!=0 ) && ($savID!='') && ($timestamp!='' && $timestamp!=0)  )
        {
            
            $this->Session->write('ImgProp.savID', $savID);
            $this->Session->write('ImgProp.SideID', $frontRear);
            $this->Session->write('ImgProp.timestamp', $timestamp);
            
            
        }else{
            
         
            $this->Session->write('ImgProp.savID', '');
            $this->Session->write('ImgProp.SideID', '');
            $this->Session->write('ImgProp.timestamp', '');
        }
          /*          To Delete Customization on PAGE Reload                            */
        
        
        /* if($frontRear=='Front' && $timestamp=='' &&  $swap==''){
        $this->Customimage->delEntries($this->Session->id(), $frontRear); 
        }*/
        
          /**                 ******                  To Delete Customization on PAGE Reload    ****    */
        
       // print_r($_SESSION);
              $sess_arr = $this->Session->read('Userlog');
              $uname = $sess_arr['uname'];
              $this->set('uname', $uname);
        if(empty($this->data)) {            
          
          $divArray = $this->Customimage->findEntry($this->Session->id(), $frontRear);
              $this->set('divArray', $divArray);
            $regions = array("Front" => 'noimages.gif', "Rear" => 'noimages.gif');
            $img = $this->Customimage->findAllByProductdetailsId($combID);
  
            $prod = $this->Product->findById($combID);
          //      echo "<pre>";print_r($img);exit;
            
            $productname= $prod['Product']['pname'];
            
               $prod_detailss = $this->Productdetail->findById($combID);
            
              // echo "<pre>";print_r($prod_detailss);exit;
            
        
          $product_id= $prod_detailss['Productdetail']['product_id'];
//            echo $product_id; exit;
            $this->set('product_id',$product_id);
            $ID = '';
            if(is_array($img)) {

                foreach($img as $key=>$val) {

                    $regions[$img[$key]['Customimage']['type']] = $img[$key]['Customimage']['image'];
                    $prod_detail = $this->Productdetail->findById($combID);
                    $imagethumparray["doublesided"]=$prod_detail['Productdetail']['doublesided'];
                    $imagetype=$img[$key]['Customimage']['type'];
                    $imagename=$img[$key]['Customimage']['image'];
                    $imagethumparray[$imagetype]=$imagename;
                    if($img[$key]['Customimage']['type'] == $frontRear) $ID = $img[$key]['Customimage']['productdetails_id'];
                }
            }
      $swapcomps_new=$this->Customimage->swapcomp($combID);

            foreach ($swapcomps_new as $swapcomp)
            {
            	
            	$customvalue_ids=explode(",",$swapcomp['c']['customvalue_id']);
        		
        		
            	foreach ($customvalue_ids as $customvalue_id)
            	{
            	
            	$combnstr=$this->Product->getpdctcmbn($customvalue_id);
            	
            		if(!empty($combnstr))
            			{
            				$combination[]=$combnstr;
            			}
            	}
            	
            	$combinations=implode(", ",$combination);
            	unset($combination);
            	$swapcomp['c']['combination']=$combinations;
            	$swapcomps[]=$swapcomp;
            }
           
           $this->set("swapcomps",$swapcomps);  
            if($imagethumparray['doublesided']==N)
            {
            	unset($imagethumparray['Rear']);
            }
		    unset($imagethumparray['doublesided']);
          $this->set("imagethumparray",$imagethumparray);
            if(!$ID) { 
                $prod_detail = $this->Productdetail->findById($combID);
                $prod        = $this->Product->findById($prod_detail['Productdetail']['product_id']);
                //echo "<pre>";print_r($prod);exit;

                if($this->Session->read('tempUser')) {
                    $this->Session->setFlash('Sorry, No customizable image is avaialable for this combination.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'products', 'action' => 'templates'));
                }
                else {
                    $this->Session->setFlash('Sorry, No customizable image is avaialable for this combination.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'products', 'action' => 'show/'.$prod['Product']['pname'].'/'.$prod['Product']['id']));
                }
                exit;
            }
            $coords = $this->Customimage->getcoords($ID, $frontRear);//print_r($coords);
            $fonts = $this->Font->find('list', array('fields' => array('Font.name', 'Font.name'), 'conditions' => array('Font.status' => 1)));
            $txtsize = array("4" => "4", "6" => "6", "8" => "8", "10" => "10", "12" => "12", "14" => "14", "16" => "16");
            $outline = array("None" => "None", "Thin" => "Thin", "Medium" => "Medium", "Thick" => "Thick");
            $txtcurve = array("0" => "None", "140" => "Small", "180" => "Medium", "220" => "Large");
            
            $txtshape = array("normal" => "Normal", "roof" => "Roof", "arc" => "Arch", "curve" => "Curve", "wedge" => "Wedge");
            
            $txtshapeSettings["normal"] = array('0' => 'None');
            
            $txtshapeSettings["roof"]   = array('1' => 'Top Small', 
                                                '2' => 'Top Medium', 
                                                '3' => 'Top Large', 
                                                '4' => 'Middle Small', 
                                                '5' => 'Middle Medium', 
                                                '6' => 'Middle Large', 
                                                '7' => 'Bottom Small', 
                                                '8' => 'Bottom Medium', 
                                                '9' => 'Bottom Large', 
                                                '10' => 'Left Small', 
                                                '11' => 'Left Medium', 
                                                '12' => 'Left Large', 
                                                '13' => 'Right Small', 
                                                '14' => 'Right Medium', 
                                                '15' => 'Right Large');
            
            $txtshapeSettings["wedge"]  = array('1' => 'Up Widen Slow', 
                                                '2' => 'Up Widen Medium', 
                                                '3' => 'Up Widen Fast', 
                                                '4' => 'Up Narrow Slow', 
                                                '5' => 'Up Narrow Medium', 
                                                '6' => 'Up Narrow Fast', 
                                                '7' => 'Middle Widen Slow', 
                                                '8' => 'Middle Widen Medium', 
                                                '9' => 'Middle Widen Fast', 
                                                '10' => 'Middle Widen Slow', 
                                                '11' => 'Middle Widen Medium', 
                                                '12' => 'Middle Widen Fast', 
                                                '13' => 'Down Widen Slow', 
                                                '14' => 'Down Widen Medium', 
                                                '15' => 'Down Widen Fast',
                                                '16' => 'Down Narrow Slow',
                                                '17' => 'Down Narrow Medium',
                                                '18' => 'Down Narrow Fast');
            
            $txtshapeSettings["arc"]    = array('1' => 'Up Very Small', 
                                                '2' => 'Up Small', 
                                                '3' => 'Up Medium', 
                                                '4' => 'Up Large', 
                                                '5' => 'Up Very Lage', 
                                                '6' => 'Down Very Small', 
                                                '7' => 'Down small', 
                                                '8' => 'Down Medium', 
                                                '9' => 'Down Large', 
                                                '10' => 'Down very Large');
            
            $txtshapeSettings["curve"]  = array('1' => 'Up Very Sharp', 
                                                '2' => 'Up Sharp', 
                                                '3' => 'Up Medium', 
                                                '4' => 'Up Slight', 
                                                '5' => 'Up Very Slight', 
                                                '6' => 'Up Super Slight', 
                                                '7' => 'Down Very Sharp', 
                                                '8' => 'Down Sharp', 
                                                '9' => 'Down Medium', 
                                                '10' => 'Down Slight',
                                                '11' => 'Down Very Slight', 
                                                '12' => 'Down Super Slight');
            
            $this->set('limit', 12);
            $this->set('page', 1);
            $clipArray = $this->__readDirectory();

            $imageArray = $this->__readCategory();

            $userclips = $this->Setting->findByFieldname('userclipart');
            $this->set('userclips', $userclips['Setting']['value']);

            //-------------------Get the entries from the settings table---------------------------------
            $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr			=	$this->Currency->findByCode($data["currency"] );
            $this->set('pcurr', $curr["Currency"]["logo"]);

            $first_imagecost = $this->Setting->findByFieldname('first_image');
            $addn_imagecost = $this->Setting->findByFieldname('addn_image');
            $first_textcost = $this->Setting->findByFieldname('first_text');
            $addn_textcost = $this->Setting->findByFieldname('addn_text');

            $this->set("first_imagecost",$first_imagecost['Setting']['value']);
            $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
            $this->set("first_textcost",$first_textcost['Setting']['value']);
            $this->set("addn_textcost",$addn_textcost['Setting']['value']);
            //---------------------------------------------------------------------------------------------

            $this->set('coords', $coords);
            $this->set('fonts', $fonts);
            $this->set('txtsize', $txtsize);
            $this->set('outline', $outline);
            $this->set('frontRear', $frontRear);
            $this->set('productdetailid', $combID);
            $this->set('image_front', $regions[$frontRear]);
            $this->set('imageArray', $imageArray);
            $this->set('clipArray', $clipArray);
            $this->set('txtcurve', $txtcurve);
            $this->set('txtshape', $txtshape);
            $this->set('txtshapeSettings', $txtshapeSettings);
            $palette = $this->Palette->find('all', array('conditions' => array('Palette.status' => '1'), 'orderby' => array('Palette.id')));
            $this->set('palette',$palette);
            $this->set('Productname', $productname);

            //---------------UID---------------//
            ($timestamp == '' || $timestamp == 0) ? $timestamp = time() : $timestamp;
            $this->set('timestamp', $timestamp);

            //----------------Edit details------------------------//
            
            if(!$savID)
            {
                //$savID = $_SESSION['ImgProp']['last_id'];
            }
            
            if($savID) {
                $divArray = $this->Customimage->findUserItems($savID);
                
                $this->set('divArray', $divArray);

                $this->set('rotID', $rotID);
            }

            //---------------If item is being swapped-----------//
          
            if($swap) {
                $divArray = $this->Customimage->findEntry($this->Session->id(), $frontRear);
                $this->set('divArray', $divArray);

                $this->set('rotID', $rotID);
            }
            $this->Customimage->delEntries($this->Session->id(), $frontRear); // clear the table as new entries will be created on page load

            
            
            
            $this->set('savID', $savID);

            //----------customfieldvalues--------------//
            $prod_details = $this->Productdetail->findById($combID);
            $prod = $this->Product->findById($prod_details['Productdetail']['product_id']); // u need to get the default attr
            $defaultattr = $prod['Product']['defaultattribute'];
            $custvalues = $this->Customfieldvalue->findAllByCustomfieldId($defaultattr);
            foreach($custvalues as $key => $val) {
                $cfArray[] = $val['Customfieldvalue']['id'];
            }
           
            $this->set('doublesided', $prod_details['Productdetail']['doublesided']);

            $tArray = explode(",", $prod_details['Productdetail']['customvalue_id']);
            foreach($tArray as $val) {
                if(in_array($val, $cfArray)) $setParam = $val;
            }
           
            $prod_comb = $this->Productdetail->findAllByProductId($prod_details['Productdetail']['product_id']);
           
            $paramVal = $this->Customfieldvalue->findById($setParam);
            
            $this->set('defaultvalue', $paramVal['Customfieldvalue']['custom_value']);
            foreach($prod_comb as $k => $v) {
                $name = '';

                $tArray2 = explode(",", $v['Productdetail']['customvalue_id']);
                //echo $v['Productdetail']['customvalue_id'];exit;
                if(in_array($setParam, $tArray2)) {
                    //$res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], $setParam);
                    $res = $this->Customimage->findcombinationqty($v['Productdetail']['customvalue_id'], 2);
                    //print_r($res);exit;
                    $j = 1;                    
                    foreach($res as $k2 => $v2) {
                        if(count($res) <> $j) $name .= $v2['CFV']['custom_value'].',';
                        else $name .= $v2['CFV']['custom_value'];
                        $j++;
                    }
                    $combArray[$v['Productdetail']['id']] = $name;
                    $stockArray[$v['Productdetail']['id']] = $v['Productdetail']['stock'];
                }
            }
            //echo "<pre>";print_r($combArray);exit;
            $this->set('stockArray', $stockArray);
            $this->set('combArray', $combArray);

            
              $combnstr = array();
                $combinations = array();
                $cutomfieldarray = array();
                $allcutomfieldarray = array();
                 //----- Tiered price ----//
                 $prod1 = $this->Productdetail->findById($combID);
                $pcombndet	=	$this->Productdetail->findAllByProductId($prod1['Productdetail']['product_id']);
               // echo "<pre>";print_r($pcombndet);exit;
                
                $customfied = array();
               for($i=0;$i<count($pcombndet);$i++) {

                  $pcmbnids=$pcombndet[$i]["Productdetail"]["customvalue_id"];

                  $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                       if($val!='') { 
                           $combnstr[]=$this->Product->getpdctcmbn($val);
                           $this->Product->getpdctcmbn($val);
                           $combinations=implode(", ",$combnstr);
                           $pcombndet[$i]["Productdetail"]["combinations"]= $combinations;
                           $customfied[$key][$val] = $this->Product->getpdctcmbn($val);
                        }

                    }
                 
                   unset($combnstr);
                    unset($combinations);

                }
                //print_r($customfied);
                $this->set('pcombndet', $pcombndet);
                $this->set('customfied', $customfied);
              
              /*********** ***********************/
            
            
            //--------------Category List--------------------//
            $lst	=	$this->Category->findAll();
            if(empty($lst)===false) {
                foreach($lst as $det)
                    $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
                $this->set('menu_array', $menu_array);
            }

            if($this->Session->read('tempUser')) {
                $adm_user = $this->Session->read('tempUser');
            }
            else {
                $adm_user = 0;
            }
           
            $this->set('adm_user', $adm_user);
        }
 
        $logged_in = 0;
        $sess_arr = $this->Session->read('Userlog');
        if($sess_arr['id'] != "") {
            $logged_in = 1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
        }
        $this->set('userStatus', $logged_in);

        if($this->Session->read('tempUser')) {
             $this->set('adminUser_flag', 1);
            $this->layout = 'adm_editor';
        }
        else {
            $this->set('adminUser_flag', 0);
            $this->layout = 'editor';
        } 
                $textureImgArr = $this->getTexture(); //print_r($textureImgArr); exit;
        $this->set('textureImgs', $textureImgArr);
        
        global $currency; 
		$curr		=	$this->Currency->findByCode($currency);
		$this->set('curlogo',$curr["Currency"]["logo"]);
    }
    
    /********************************/
     function richeditorAjaxSave() { 

        Configure::write('debug', 0);
        $this->autoRender = false;        
        $this->layout = 'ajax';

        $editedImg = 'temp'; //image value is temp if no design made
        $sendAdmin =  $this->Session->read('sendadmin');   
           
        //if editing happening changing image values with temp
        
        if($this->data["Customimage"]["edit_id"] <> 0){
            $this->Customimage->updateSavedimage($this->data["Customimage"]["edit_id"],$this->data["Customimage"]["productdetail_id"]);
        }

        $sess_arr = $this->Session->read('Userlog');
        if($sess_arr['id']) 
			{
            $uid = $sess_arr['id'];
        }
        else{
        	$uid = $this->Session->id();
        	}
      
        //Image sidename when clicked on multiside
        	
        $imgSide = $this->data['Customimage']['is_rotate'];
        
        
        
        if($this->data["Customimage"]["edit_id"] <> 0) 

        	{     if(!isset($this->data["Customimage"]["templates"])){    // for not delete template copied value to user    
            $this->Customimage->deleteItemCoordinates($this->data["Customimage"]["edit_id"]);
                }
           		 $this->Customimage->updateCustomization($this->data, $editedImg, $this->data["Customimage"]["edit_id"],$this->data["Customimage"]["productdetail_id"]);
            $lastID = $this->data["Customimage"]["edit_id"];            
          }
        else 
			{
           		 $lastID = $this->Customimage->saveCustomization($this->data, $editedImg, $uid);
           		// $this->Customimage->resetTable($uid,$this->data["Customimage"]["productdetail_id"]);
            }
        //---------------insert details of each element added------------------//
        $this->Customimage->itemCoordinates($this->data["Customimage"]["hid_coords_text"], $this->data["Customimage"]["hid_coords"], $lastID, $this->data['Customimage']['productdetail_id']);
        

        
        if($this->data["Customimage"]["is_rotate"]) {
            //send the details to move to the rotate page
            //get the id for the next side of the image
			$nextURLID = $this->Customimage->getFrontRearID($lastID,$imgSide);
			
			//returing next image url
            $returnArray['requestedFor'] = 'rotate';
            $returnArray['nextUrl']      = "richeditor/{$this->data['Customimage']['productdetail_id']}/$imgSide/{$this->data['Customimage']['hid_timestamp']}/$nextURLID";
            echo json_encode($returnArray);
            exit;
            
          //  $this->__generateUserDesigns($uid,$this->data["Customimage"]["productdetail_id"]);
            //$this->redirect(array('controller' => 'Customimages', 'action' => "richeditor/{$this->data['Customimage']['productdetail_id']}/$imgSide/{$this->data['Customimage']['hid_timestamp']}/$lastID"));
            
        }
        else {            
                    //send details to indicate that the design has been saved
                    $returnArray['requestedFor'] = 'save';
                     $returnArray['lastId'] = $lastID;
                    echo json_encode($returnArray);
                    
                    $this->__generateUserDesigns($uid,$this->data["Customimage"]["productdetail_id"]);
                    exit;
        }
    }
    
    
    /********************************/
    /******************************/
    
     function admin_richeditorAjaxSave()
    { 
      //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;        
        $this->layout = 'ajax';
        
        //-------------------check data here-------------------//
        //print_r($_REQUEST);exit;
        //-----------------------------------------------------//
        
        $editedImg = 'temp'; //image value is temp if no design made

        
        $sendAdmin =  $this->Session->read('sendadmin');    
           
        //if editing happening changing image values with temp
        
        if($this->data["Customimage"]["edit_id"] <> 0){
            $this->Customimage->updateSavedimage($this->data["Customimage"]["edit_id"],$this->data["Customimage"]["productdetail_id"],$templateName);
        }

        
       
		
            $uid = $this->Session->read('tempUser');
            $templateName = $this->Session->read('templateName');	
            $temaplateCombId  = $this->Session->read('temaplateCombId');	
            $published  = $this->Session->read('published');
            $product_id  = $this->Session->read('product_id');
        	
        $imgSide = $this->data['Customimage']['is_rotate'];
        
        
        
        if($this->data["Customimage"]["edit_id"] <> 0) 

        	{            
            	 $this->Customimage->deleteItemCoordinates($this->data["Customimage"]["edit_id"]);
           		 $this->Customimage->updateCustomization($this->data, $editedImg, $this->data["Customimage"]["edit_id"],$this->data["Customimage"]["productdetail_id"],$templateName);
            	    $lastID = $this->data["Customimage"]["edit_id"];     
                    $this->Customimage->editTemplate($lastID);
                     $this->Customimage->editTemplate($lastID,addslashes($templateName),$published);
       		}
        else 
			{
           		 $lastID = $this->Customimage->saveCustomization($this->data, $editedImg, $uid,  addslashes($templateName));
           		// $this->Customimage->resetTable($uid,$this->data["Customimage"]["productdetail_id"]);
            
                         $this->Customimage->addTemplate($lastID,$templateName,$temaplateCombId,$uid,$published,$product_id);
            }
       
            
        

        //---------------insert details of each element added------------------//
        $this->Customimage->itemCoordinates($this->data["Customimage"]["hid_coords_text"], $this->data["Customimage"]["hid_coords"], $lastID, $this->data['Customimage']['productdetail_id']);
       

        
        if($this->data["Customimage"]["is_rotate"]) {
            //send the details to move to the rotate page
            //get the id for the next side of the image
			$nextURLID = $this->Customimage->getFrontRearID($lastID,$imgSide);
			
			//returing next image url
 			$returnArray['requestedFor'] = 'rotate';
            $returnArray['nextUrl']      = "admin_richeditor/{$this->data['Customimage']['productdetail_id']}/$imgSide/{$this->data['Customimage']['hid_timestamp']}/$nextURLID";
            echo json_encode($returnArray);
            exit;
            
          //  $this->__generateUserDesigns($uid,$this->data["Customimage"]["productdetail_id"]);
            //$this->redirect(array('controller' => 'Customimages', 'action' => "richeditor/{$this->data['Customimage']['productdetail_id']}/$imgSide/{$this->data['Customimage']['hid_timestamp']}/$lastID"));
            
        }
        else {            
        
                    $returnArray['requestedFor'] = 'save';
                     $returnArray['lastId'] = $lastID;
                     $this->Session->setFlash('Template updated', 'default',array('class'=> 'success'));
                    echo json_encode($returnArray);
                    
                    $this->__generateUserDesigns($uid,$this->data["Customimage"]["productdetail_id"]);
                    exit;
                
                        
        }
    }
    
    function __generateUserDesigns($uid,$Productdetailid=null)
    {
        //-----------fix to fill front/rear images in only 1 is present-------------//
        if($Productdetailid!=null)
        {
       		$this->Customimage->resetTable($uid,$Productdetailid);
        }
        else
        {
        	$this->Customimage->resetTable($uid);
        }
        //-------------generate image for unsaved sides of images--------------//
        $imageArray = $this->Customimage->removeTemp($uid);  
        
        
        
        
        
        
        if(is_array($imageArray)) {
            
            foreach($imageArray as $images) {
                
                if(!empty($images['design_items'])) {
                    //------------------background image--------------------//
                    $editedImg = $this->Customize->index($images['image_path']);
                    foreach($images['design_items'] as $designs) {
                        
                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);
                        
                    }

                    //--------------------foreground image-----------------//
                    
                    
                    
                    
                    
                    //Code For Finding Image Creation Proportion Currently HardCoded as 2
                    $ratio=2;
                    
            
                    //Chosing Plain image based on size
                    if(IMAGE_PROPRTION)
                    {
                    $editedImg_blank = $this->Customize->index("blank_1024.png", true);
                    }
                    else
                    {
                    $editedImg_blank = $this->Customize->index("blank.png", true);	
                    }
 //For SVG FOREGROUND
                		 $tmp = explode(".", $editedImg_blank);
                    	 $this->Customize->editedImg_svg=$tmp[0].".svg";

                         copy(WWW_ROOT.IMAGES_URL."plain.svg", WWW_ROOT.IMAGES_URL.$this->Customize->editedImg_svg);
                         require_once WWW_ROOT."/svglib/svglib.php";
                  // echo "image". WWW_ROOT.IMAGES_URL.$this->Customize->editedImg_svg; 
                    

               
                    
///////////////////
                    foreach($images['design_items'] as $designs) {
                        

                        $designs['type'] == 'text' ? $this->Customize->addText($designs,$ratio) : $this->Customize->addImage($designs,$ratio);
               
                    }

                }
                else {
                    $editedImg = $this->Customize->index($images['image_path']);
                    $editedImg_blank = $this->Customize->index("blank.png", true);
                    //For Plain SVG
                    $tmp = explode(".", $editedImg_blank);
                    $this->Customize->editedImg_svg=$tmp[0].".svg";
                    copy(WWW_ROOT.IMAGES_URL."plain.svg", WWW_ROOT.IMAGES_URL.$this->Customize->editedImg_svg);
                    
                    
                    copy(WWW_ROOT.IMAGES_URL.$images['image_path'], WWW_ROOT.IMAGES_URL.$editedImg);
                    copy(WWW_ROOT.IMAGES_URL."blank.png", WWW_ROOT.IMAGES_URL.$editedImg_blank);
                }
                
                $this->Customimage->updateSaveImage($editedImg, $editedImg_blank, $images['id']);
                
            }
            
        }
    }
    
    function cusomizeDesign($pid,$fid)
    {
        
        $sess_arr = $this->Session->read('Userlog');
        if($sess_arr['id'] != "" && !$this->Session->read('Admin')) {
            $uid = $sess_arr['id'];
        }
        elseif($this->Session->read('tempUser')) {
            $uid = $this->Session->read('tempUser');
        }
        else $uid = $this->Session->id();
         $pid = $this->Customimage->getFrontDetails($fid);
         $savedID = $this->Customimage->makeCustomizationUs($pid['productdetails_id'], $fid,$uid);
         //echo $savedID;
         $row = $this->Customimage->getFrontDetails($savedID);
         
         //print_r($row);
        
         $fid = $row['id'];
         $side = $row['type'];
         
         $timestamp = explode('-', $row['ref_name']); 
         $timestamp = $timestamp[1];
         $combId = $row['productdetails_id'];
         $this->redirect(array('controller' => 'customimages', 'action' => "richeditor/$combId/$side/$timestamp/$lastId")); 
		//	exit();
    }
    
    /************ Function to calculate price baised on Price Tier ************/
    function getTieredPrice($pid,$totqty,$contoller=''){
    	//echo $pid."Quantity".$totqty;exit;
    	$priceTier       =       $this->Productpricetier->select_product_pricetier($pid); // get price tier
    	foreach ($priceTier as $key => $value) {
    		 
    		if($value['pricerates']['type']=="Between")
    		{
    			$arrqtyrange= explode(",", $value['pricerates']['quantity']);
    			$closestQty[] = abs($arrqtyrange[1]-$totqty);
    			$betweenRange = range($arrqtyrange[0],$arrqtyrange[1]);
    			if(in_array($totqty, $betweenRange))
    				$dat["product_price"]=$value['pricerates']['rate'];
    		}
    		if($value['pricerates']['type']=="Above")
    		{
    			$closestQty[] = abs($value['pricerates']['quantity']-$totqty);
    			if($totqty > $value['pricerates']['quantity'])
    				$dat["product_price"]=$value['pricerates']['rate'];
    		}
    	} 
    	
    	//////////// case Quantity not in any range take the price of nearest range //////
    	/* if($dat["product_price"]==''){
    	$closeQty = min($closestQty);
    	foreach ($priceTier as $key => $value){
    	if($value['pricerates']['type']=="Between")
    	{
    	$arrqtyrange= explode(",", $value['pricerates']['quantity']);
    	$nearval=abs($arrqtyrange[1]-$totqty);
    	if($closeQty==$nearval)
    	{
    	$dat["product_price"]=$value['pricerates']['rate'];
    	break;
    	}
    	}
    	else
    	{
    	$nearval=abs($value['pricerates']['quantity']-$totqty);
    	if($closeQty==$nearval)
    	{
    	$dat["product_price"]=$value['pricerates']['rate'];
    	break;
    	}
    	}
    	}
    	}*/
    	if($contoller==1)
    	{  // echo "here".$dat["product_price"];exit;
    		return $dat["product_price"];}
    	else
    	{
    	return $dat["product_price"];
    	exit;
    	}
    	///// nearest range price for missing range  //////
    	}
        function sendQuoteMail($orderId,$pid)
    {
    
         ################################## Section to send order confirmation mail................................
      $this->Order->id = $orderId; 
     $data = $this->Order->read();
     $odr	=	$data;
      $odr	=	$data;
      $sus			=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $dat["user_id"]		=	0;
        if(!empty($sus)===true) {
            $dat["user_id"]		=	$sus["id"];
        }
        $sessid	=	$this->Session->id();
        $orderData["user_id"] = $dat["user_id"];
        $orderData["date"]    = date('Y-m-d'); 
        $orderData["order_status_id"] = 8;        
        $dat["product_id"]		=	$pid;
        $pdet		                =	$this->Product->findById($pid);
    
        //----------------Get the customization cost---------------------//
        $addnCost = $this->calculateAmt($custid);

        //Setting the prices for whole sale and retail users..
        if(isset($sus) && empty($sus)===false) {
            if($sus["usertype"]=='wholesale') {
                if($pdet["Product"]["wholesale_price"] > 0) {
                    $dat["product_price"]	=	$pdet["Product"]["wholesale_price"];
                }
                else {
                    $dat["product_price"]	=	$pdet["Product"]["price"];
                }
                $dat["price_type"]	=	'W';
            }

            if($sus["usertype"]=='retail') {
                $dat["product_price"]	=	$pdet["Product"]["price"];
                $dat["price_type"]	=	'R';
            }
        }

        else {
            $dat["product_price"]	=	$pdet["Product"]["price"];
        }

        //Setting the prices for whole sale and retail users..

        $dat["discount_type"]	 =	$pdet["Product"]["discount_type"];

        $dat["discount"]	        =       $pdet["Product"]["discount"];        

        $dat["quantity"]		=	$qty;

        $dat["prodtype"]		=	$pdet["Product"]["prodtype"];

        $dat["type"]		    =	'P';

        $dat["savedimages_id"]		=	$custid;
        $productname                    = $pdet["Product"]["pname"];
        $curr1		=	$this->Currency->findByCode($odr["Order"]["currency_type"]);
		$currlogo1 = $curr1["Currency"]["logo"];
           $data1	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr			=	$this->Currency->findByCode($data1["currency"]);
            $currlogo1 = $curr["Currency"]["logo"];
            $currCode1 = $curr["Currency"]["code"];           
      $content = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
	  <tr>

		<td colspan='2' align='center'>

		<h2>Quote Details</h2>

		</td>

	  </tr>

	  <tr>

		<td colspan='2' align='center'>

			<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			 <tr>

				<td><strong>Order Number</strong></td>
				
				<td><strong>Order Status</strong></td>

				<td><strong>Order Date</strong></td>

				<td><strong>User Name</strong></td>

				<td><strong>Currency</strong></td>

			  </tr>

			  <tr>

				<td>&nbsp;</td>
				
				<td>&nbsp;</td>

				<td>&nbsp;</td>

				<td>&nbsp;</td>

				<td>&nbsp;</td>

			  </tr>

			  <tr>

                <td> ".$orderId."</td>
				<td>".
				$odr['OrderStatus']['name']."
				</td>

				<td>";
				

				$dt	= strtotime($orderData["date"]);				

				$content .= date('m/d/Y',$dt );

				$content .= "</td>

				<td> ".$odr['User']['uname']."</td>

				<td>". $currCode1."</td>

			  </tr>

			</table>

		</td>

	  </tr>

	  <tr>

		<td colspan='2' align='center'><h3>Item Details</h3></td>

	   

	  </tr>

	  <tr>

		<td colspan='2'><table width='90%' border='0' cellpadding='2' cellspacing='2' class='manage_table' align='center'>

	  <tr>

		<td colspan='2' width='24%' valign='top'><strong>Product Name</strong></td>

		<td width='12%' valign='top'><strong>Quantity</strong></td>

		<td width='15%' valign='top'><strong>Unit Price</strong></td>

		<td width='15%' valign='top'><strong>Additional Cost</strong></td>

		<td width='14%' valign='top'><strong>Discount</strong></td>

		<td colspan='2' valign='top'><strong>Price</strong></td>		

		<td valign='top'></td>

	  </tr>

	  <tr>

		<td colspan='3'>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

	  </tr>";

	

	  $amt=0;       
       foreach($odr['OrderDetail'] as $det)

	  { 

	      $price=0;

		  $combined_price=0;

		  $dis_amnt=0;	

		  if($det["discount_type"]=='per' && $det["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $det["product_price"] * $det["discount"] / 100;

		  else if($det["discount_type"]=='amnt' && $det["discount"] > 0)

		  $dis_amnt=$det["discount"];		

		  $dis_amnt=number_format($dis_amnt,2,'.','');

		   

			$combined_price=($det["product_price"] + $det["extra_price"]);


			 if(isset($det["discount_type"]) && $det["discount_type"] <> '')

			  { 

				if($det["discount_type"]=='per')

				 {

				  if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0)

					{					 

					    $discounted_price=($det["product_price"]-(($det["product_price"] * $det['discount'])/100));

						$price=($discounted_price + $det["extra_price"]) * $det['quantity'];

						$amt += $price;

					}			

					else

					$amt+=($combined_price)*($det['quantity']);										 

				 }

				 else if($det["discount_type"]=='amnt')

				 {	 

				     if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0)

					 {
						$discounted_price=($det["product_price"]-$det['discount']);

						$price=($discounted_price + $det["extra_price"]) * ($det['quantity']);

						$amt+= $price;									

					 }		

					 else

					$amt+=($combined_price)*($det['quantity']);			

				}

			  }

			 else

			 {			 	

			    $price = ($combined_price)*($det['quantity']);

				$amt+= $price;		 	

			 }				

			 $price=number_format($price,2,".","");  

			 $amt=number_format($amt,2,".",""); 

			 

                         
                         
                         
                         
                         
                         
                         
                         
                         /******************* to get Combination name *************/
                         
                          $combnstr = array();
        $combinations = array();
       $combinationanme = '';
         $prod1 = $this->Productdetail->findById($det['combination_id']);
               
       
          
              
               if($prod1){ 
                  $pcmbnids=$prod1["Productdetail"]["customvalue_id"];

                  $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                       if($val!='') { 
                           $combnstr[]=$this->Product->getpdctcmbn($val);
          
                           $combinations=implode(", ",$combnstr);
                           
                           
                           $combinationanme = $combinations;
                        }else{
                            $combinationanme = '';
                        }

                    }

                  
               }
                
		  /******************* to get Combination name *************/

			 $content .= " <tr>

			<td colspan='2' valign='top'>".$productname.' '.$combinationanme."</td>

			<td valign='top'> ".$det['quantity']." </td>

			<td valign='top'>".$currlogo1. " ".$det['product_price']." </td>

			<td valign='top'> ".$currlogo1. " ".$det['extra_price']." </td>

			<td valign='top'>".$currlogo1. " ".$dis_amnt." </td>

			<td valign='top'>".$currlogo1. " ".$price." </td>			

			<td valign='top'>&nbsp;</td>

		  </tr>
       
                  <tr>
                  <td colspan='2' ></td>

			<td height='15' >&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>
                        <td>&nbsp;</td>
			<td>&nbsp;</td>
</tr>
                 
             
              ";
	  } 

	  $content.="  <tr>
                  <td colspan='2' ><strong>Total Price</strong></td>

			<td>".$currlogo1. " ".$amt." </td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>
                        <td>&nbsp;</td>
			<td>&nbsp;</td>
                </tr>
               
                <tr>
                  <td colspan='2' ><strong>Tax Name</strong></td>

			<td> ".$odr['Order']['tax_name']." </td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>
                        <td>&nbsp;</td>
			<td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Tax</strong></td>

			<td> ".$currlogo1. " ".$odr['Order']['tax_price'] ." </td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>
                        <td>&nbsp;</td>
			<td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Discount</strong></td>

			<td>".$currlogo1. " ".$dis_amnt." </td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>
                        <td>&nbsp;</td>
			<td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Grand Total</strong></td>

			<td>".$currlogo1. " ".$odr['Order']['total_price']." </td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
                        
                        <td>User Phone</td>
			<td><b> ".$odr['User']['uphone']." </b></td>
                        <td>&nbsp;</td>
			<td></td>			
                </tr>
              
		  <tr>

			<td colspan='3' height='15'>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>

			<td>&nbsp;</td>

		  </tr>";

	     if($odr["Order"]["discount"] > $amt)				

		 $discamt=number_format($amt,2,'.','');

		 else

		 $discamt=number_format($odr["Order"]["discount"],2,'.',''); 

	$content .= "</table>

	</td>

	  </tr>

	  <tr>

		<td width='50%'>";
        $content .="<tr>

			<td>&nbsp;</td>

		  </tr>

		</table>

	  </td>

	   <td>&nbsp;</td>

	  </tr>

	</table>";

$det['Product']."</td>

			<td>".$det['quantity']." </td>

			<td>".$currlogo1. " ".$det['product_price']." </td>

			<td>".$currlogo1. " ".$det['extra_price']." </td>

			<td>".$currlogo1. " ".$dis_amnt." </td>

			<td>".$currlogo1. " ".$price." </td>

			<td>Non-Digital</td>

			<td>&nbsp;</td>

		  </tr>

		  <tr>

			<td colspan='3' height='15'>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>

			<td>&nbsp;</td>
			<td>&nbsp;</td>

			<td>&nbsp;</td>

		  </tr>";
	

	  

	     if($odr["Order"]["discount"] > $amt)				

		 $discamt=number_format($amt,2,'.','');

		 else

		 $discamt=number_format($odr["Order"]["discount"],2,'.',''); 

	$content .= "</table>

	</td>

	  </tr>

	  <tr>

		<td width='70%'>";

		 	

	 $content .="</td>

		<td width='70%' colspan='2' ><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			 ";			 

			   $content .="

			   
			  
			  
			</table></td>

	  </tr>

	   <tr height='15'>

		<td colspan='2' align='center'>&nbsp;

		</td>

	  </tr>

	  <tr>

	  <td>";

	  

	  

	

	$content .=" </td>

	   <td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>
  
	  
	  

	  <tr>

		<td>&nbsp;</td>

	  </tr>

	</table></td>

	  </tr>";
		$content .="<tr>

			<td>&nbsp;</td>

		  </tr>

		</table>

	  </td>

	   <td>&nbsp;</td>

	  </tr>

	</table>";
	
$cnfg 			=	Configure::read('Neutrino');
$subject 		= "Quote request placed at ".$cnfg["site_name"];

$headers 		= "MIME-Version: 1.0\r\n";

$headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

$headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

$headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";

$headers        .= "Organization: ".$cnfg["site_name"]."\r\n";

$headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

$pdt 			= 	$this->Cmspage->findByTitle('Quote confirm mail');

$path			=	"SiteLogo_disp.gif";

$mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

<tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr></table>";

$cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

//Mail for User

        $pdt 			= 	$this->Cmspage->findByTitle('Quote confirm mail');

        $mailcontent	=	$mcont.$pdt["Cmspage"]["content"];

        $mailcontent = str_replace("[ORDER_DETAILS]", $content, $mailcontent);

        $mailcontent = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent);

        $mailcontent = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);		

        $mailsent 		= mail($odr['User']['email'],$subject,$mailcontent,$headers);	



        //Mail for Admin

        $pdt1 			= 	$this->Cmspage->findByTitle('Admin quote confirm mail');

        $mailcontent1	=	$mcont.$pdt1["Cmspage"]["content"];

        $mailcontent1 = str_replace("[ORDER_DETAILS]", $content, $mailcontent1);

        $mailcontent1 = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent1);

        $mailcontent1 = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent1);       
        
        //echo $mailcontent1; exit;
        $mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontent1,$headers);
    }
    
    
    
    function sendOrderMail($orderId,$pid)
    {
         ################################## Section to send order confirmation mail................................
      $this->Order->id = $orderId; 
     $data = $this->Order->read();
     $odr	=	$data;
        $sus			=	$this->Session->read('Userlog');
        $this->set('sus', $sus);
        $dat["user_id"]		=	0;
        if(!empty($sus)===true) {
            $dat["user_id"]		=	$sus["id"];
        }
        $sessid	=	$this->Session->id();
        $orderData["user_id"] = $dat["user_id"];
        $orderData["date"]    = date('Y-m-d'); 
        $orderData["order_status_id"] = 8;        
        $dat["product_id"]		=	$pid;
        $pdet		                =	$this->Product->findById($pid);
        $productname                    = $pdet["Product"]["pname"];
         $curr1		=	$this->Currency->findByCode($odr["Order"]["currency_type"]);
		$currlogo1 = $curr1["Currency"]["logo"];
      $data1	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr			=	$this->Currency->findByCode($data1["currency"]);
            $currlogo1 = $curr["Currency"]["logo"];
            $currCode1 = $curr["Currency"]["code"];    
                
     $content = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
	  <tr>

		<td colspan='2' align='center'>

		<h2>Order Details</h2>

		</td>

	  </tr>

	  <tr>

		<td colspan='2' align='center'>

			<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>

			 <tr>

				<td><strong>Order Number</strong></td>
				
				<td><strong>Order Status</strong></td>

				<td><strong>Order Date</strong></td>

				<td><strong>User Name</strong></td>

				<td><strong>Currency</strong></td>

			  </tr>

			  <tr>

				<td>&nbsp;</td>
				
				<td>&nbsp;</td>

				<td>&nbsp;</td>

				<td>&nbsp;</td>

				<td>&nbsp;</td>

			  </tr>

			  <tr>

                <td> ".$orderId."</td>
				<td>".
				$odr['OrderStatus']['name']."
				</td>

				<td>";
				

				$dt	= strtotime($orderData["date"]);				

				$content .= date('m/d/Y',$dt );

				$content .= "</td>

				<td> ".$odr['User']['uname']."</td>

				<td>". $currCode1."</td>

			  </tr>

			</table>

		</td>

	  </tr>

	  <tr>

		<td colspan='2' align='center'><h3>Item Details</h3></td>

	   

	  </tr>

	  <tr>

		<td colspan='2'><table width='90%' border='0' cellpadding='2' cellspacing='2' class='manage_table' align='center'>

	  <tr>

		<td colspan='2'><strong>Product Name</strong></td>

		<td><strong>Quantity</strong></td>

		<td><strong> Unit Price</strong></td>

		<td><strong>Additional Cost</strong></td>

		<td><strong>Discount</strong></td>

		<td colspan='2'><strong>Price</strong></td>		

		<td></td>

	  </tr>

	  <tr>

		<td colspan='3'>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

		<td>&nbsp;</td>

	  </tr>";

$content2 = $content;	  

	  $amt=0;       
       foreach($odr['OrderDetail'] as $det)

	  { 

	      $price=0;

		  $combined_price=0;

		  $dis_amnt=0;	

		  if($det["discount_type"]=='per' && $det["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $det["product_price"] * $det["discount"] / 100;

		  else if($det["discount_type"]=='amnt' && $det["discount"] > 0)

		  $dis_amnt=$det["discount"];		

		  $dis_amnt=number_format($dis_amnt,2,'.','');

		   

			$combined_price=($det["product_price"] + $det["extra_price"]);


			 if(isset($det["discount_type"]) && $det["discount_type"] <> '')

			  { 

				if($det["discount_type"]=='per')

				 {

				  if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0)

					{					 

					    $discounted_price=($det["product_price"]-(($det["product_price"] * $det['discount'])/100));

						$price=($discounted_price + $det["extra_price"]) * $det['quantity'];

						$amt += $price;

					}			

					else

					$amt+=($combined_price)*($det['quantity']);										 

				 }

				 else if($det["discount_type"]=='amnt')

				 {	 

				     if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0)

					 {
						$discounted_price=($det["product_price"]-$det['discount']);

						$price=($discounted_price + $det["extra_price"]) * ($det['quantity']);

						$amt+= $price;									

					 }		

					 else

					$amt+=($combined_price)*($det['quantity']);			

				}

			  }

			 else

			 {			 	

			    $price = ($combined_price)*($det['quantity']);

				$amt+= $price;		 	

			 }				

			 $price=number_format($price,2,".","");  

			 $amt=number_format($amt,2,".",""); 

			  /******************* to get Combination name *************/
                         
                          $combnstr = array();
        $combinations = array();
       $combinationanme = '';
         $prod1 = $this->Productdetail->findById($det['combination_id']);
               
       
          
              
               if($prod1){ 
                  $pcmbnids=$prod1["Productdetail"]["customvalue_id"];

                  $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                       if($val!='') { 
                           $combnstr[]=$this->Product->getpdctcmbn($val);
          
                           $combinations=implode(", ",$combnstr);
                           
                           
                           $combinationanme = $combinations;
                        }else{
                            $combinationanme = '';
                        }

                    }

                  
               }
                
		  /******************* to get Combination name *************/

		

			 $content .= " <tr><td colspan='2'>".$productname.' '.$combinationanme."</td><td> ".$det['quantity']." </td>			<td> ".$currlogo1." ".$det['product_price']." </td>
			<td> ".$det['extra_price']." </td><td> ".$currlogo1." ".$dis_amnt." </td><td>".$currlogo1." ".$price." </td>
			<td>&nbsp;</td>
		  </tr>
                  <tr>
                  <td colspan='2' ></td>
<td height='15' >&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
</tr>         ";                    
              
                
             /****************************/
                   $content2 .= " <tr><td colspan='2'>".$productname.' '.$combinationanme."</td><td> ".$det['quantity']." </td>			<td>".$currlogo1." ".$det['product_price']." </td>
			<td> ".$det['extra_price']." </td><td> ".$currlogo1." ".$dis_amnt." </td><td>".$currlogo1." ".$price." </td>
			<td>&nbsp;</td>
		  </tr>
                 ";
             /******************************/
             
	  } 

	  $content.="  <tr>   <td colspan='2' ><strong>Total Price</strong></td>
<td> ".$currlogo1." ".$amt." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                </tr>
               
                <tr>
                  <td colspan='2' ><strong>Tax Name</strong></td>
	<td> ".$odr['Order']['tax_name']." </td><td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td> <td>&nbsp;</td><td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Tax</strong></td>
	<td>".$currlogo1." ".$odr['Order']['tax_price'] ." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Discount</strong></td>
		<td>".$currlogo1." ".$discamt." </td>	<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Grand Total</strong></td>
			<td>".$currlogo1." ".$odr['Order']['total_price']." </td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>                        
                        <td>User Phone</td>
			<td><b> ".$odr['User']['uphone']." </b></td>
                        <td>&nbsp;</td>
			<td></td>			
                </tr>              
		  <tr><td colspan='3' height='15'>&nbsp;</td>
			<td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td>
		  </tr>";
          
          
          $content2.=" <tr>
                  <td colspan='2' ></td>
<td height='15' >&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
</tr>                             
                <tr>   <td colspan='2' ><strong>Total Price</strong></td>
<td>".$currlogo1." ".$amt." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                </tr>
               
                <tr>
                  <td colspan='2' ><strong>Tax Name</strong></td>
	<td> ".$odr['Order']['tax_name']." </td><td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td> <td>&nbsp;</td><td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Tax</strong></td>
	<td>".$currlogo1." ".$odr['Order']['tax_price'] ." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Discount</strong></td>
		<td>".$currlogo1." ".$discamt." </td>	<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                </tr>
              
                <tr>
                  <td colspan='2' ><strong>Grand Total</strong></td>
			<td> ".$odr['Order']['total_price']." </td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>                        
                        <td>&nbsp;</td>
			<td>&nbsp;</td>
                        <td>&nbsp;</td>
			<td></td>			
                </tr>              
		  <tr><td colspan='3' height='15'>&nbsp;</td>
			<td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td>
		  </tr>";

	     if($odr["Order"]["discount"] > $amt)				

		 $discamt=number_format($amt,2,'.','');

		 else

		 $discamt=number_format($odr["Order"]["discount"],2,'.',''); 

	$content .= "</table></td> </tr> <tr><td width='50%'>";
        $content2 .= "</table></td> </tr> <tr><td width='50%'>";
        $content .="<tr><td>&nbsp;</td>  </tr></table> </td>  <td>&nbsp;</td> </tr></table>";
                        $det['Product']."</td>
			<td> ".$det['quantity']." </td>
			<td>".$currlogo1." ".$det['product_price']." </td>
			<td>".$currlogo1." ".$det['extra_price']." </td>
                        <td>".$currlogo1." ".$dis_amnt." </td>
			<td>".$currlogo1." ".$price." </td>	
			<td>&nbsp;</td>
		  </tr> <tr>
			<td colspan='3' height='15'>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
			<td>&nbsp;</td>	<td>&nbsp;</td> </tr>";
          $content2 .="<tr><td>&nbsp;</td>  </tr></table> </td>  <td>&nbsp;</td> </tr></table>";
                        $det['Product']."</td>
			<td> ".$det['quantity']." </td>
			<td>".$currlogo1." ".$det['product_price']." </td>
			<td>".$currlogo1." ".$det['extra_price']." </td>
                        <td>".$currlogo1." ".$dis_amnt." </td>
			<td>".$currlogo1." ".$price." </td>	
			<td>&nbsp;</td>
		  </tr> <tr>
			<td colspan='3' height='15'>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
			<td>&nbsp;</td>	<td>&nbsp;</td> </tr>";
	  

	     if($odr["Order"]["discount"] > $amt)				

		 $discamt=number_format($amt,2,'.','');

		 else

		 $discamt=number_format($odr["Order"]["discount"],2,'.',''); 

	$content .= "</table></td> </tr> <tr><td width='70%'>";	 	
        $content .="</td><td width='70%' colspan='2' ><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>";			 
         $content .="</table></td> </tr> <tr height='15'>
		<td colspan='2' align='center'>&nbsp;</td> </tr> <tr><td>";	

	$content .=" </td>
	   <td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>
<tr><td>&nbsp;</td> </tr></table></td>	  </tr>";
        $content .="<tr>
			<td>&nbsp;</td> </tr></table> </td><td>&nbsp;</td> </tr>
	</table>";
       /****************************/
        $content2 .= "</table></td> </tr> <tr><td width='70%'>";	 	
        $content2 .="</td><td width='70%' colspan='2' ><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>";			 
         $content2 .="</table></td> </tr> <tr height='15'>
		<td colspan='2' align='center'>&nbsp;</td> </tr> <tr><td>";	

	$content2 .=" </td>
	   <td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>
<tr><td>&nbsp;</td> </tr></table></td>	  </tr>";
        $content2 .="<tr>
			<td>&nbsp;</td> </tr></table> </td><td>&nbsp;</td> </tr>
	</table>";
        /******************************/
	
$cnfg 			=	Configure::read('Neutrino');
//$subject 		= "Order send to admin at ".$cnfg["site_name"];
$subject 		= "New order placed at ".$cnfg["site_name"];

$headers 		= "MIME-Version: 1.0\r\n";

$headers        .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

$headers        .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";

$headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";

$headers        .= "Organization: ".$cnfg["site_name"]."\r\n";

$headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

$pdt 			= 	$this->Cmspage->findByTitle('Order confirm mail');

$path			=	"SiteLogo_disp.gif";

$mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

<tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr></table>";

$cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

//Mail for User

        $pdt 			= 	$this->Cmspage->findByTitle('Order confirm mail');

        $mailcontent	=	$mcont.$pdt["Cmspage"]["content"];

        $mailcontent = str_replace("[ORDER_DETAILS]", $content2, $mailcontent);

        $mailcontent = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent);

        $mailcontent = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);		

        $mailsent 		= mail($odr['User']['email'],$subject,$mailcontent,$headers);	



        //Mail for Admin

        $pdt1 			= 	$this->Cmspage->findByTitle('Admin order confirm mail');

        $mailcontent1	=	$mcont.$pdt1["Cmspage"]["content"];

        $mailcontent1 = str_replace("[ORDER_DETAILS]", $content, $mailcontent1);

        $mailcontent1 = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent1);

        $mailcontent1 = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent1);       
        

        $mailsent1 		= mail($cnfg["admin_email"],$subject,$mailcontent1,$headers);
     

    }
    
    
    function checkproductdet()
    {
        
        extract($_POST);
        $productDet = $this->Customimage->getProductDetails_customVal($customfields,$product_id);
       echo json_encode($productDet); exit;
    }
    
    
    
    
} 
