<?php
App::import('Sanitize');

class RulersController extends AppController {
    var $name = "Ruler";

    var $helpers = array('Html', 'Form','Pagination','Javascript','Ajax','Csv','xls');

    var $components = array ('Pagination','Catmenu','History','Email','Twitter'); // Added

    var $uses = array('User','Setting','Ruler');

    var $paginate = array('limit' => 25,'order' => array('Ruler.id' => 'asc'));




    function beforeFilter() {

        if (isset($this->Setting) && !empty($this->Setting->table)) {

            $this->Setting->load();

        }

        global $sitefolder;

        global $meta_description;

        global $meta_keywords;

        global $page_title;

        $cnfg 				=	Configure::read('Neutrino');

        $sitefolder			=	$cnfg["sitebasefolder"];

        $meta_description	=	$cnfg["meta_description"];

        $meta_keywords		=	$cnfg["meta_keywords"];

        $page_title			=	$cnfg["page_title"];

        global $style;

        $style				=	$cnfg["style"];

       $this->set('style', $style);

         $this->set('meta_description', $meta_description);

        $this->set('meta_keywords', $meta_keywords);

        $this->pageTitle = $page_title	;

        $this->set('cnfg',$cnfg);

        $this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.

        $this->set('sitefolder', $sitefolder);

        $httpHost	=	$_SERVER['HTTP_HOST'];

        $this->set('sitebase','http://'.$httpHost);
        
      

    }

    function beforeRender() {

       

    }



    function index() {



        /* if($this->Session->check('Userlog') != false) {
                $this->Session->setFlash('The URL you have followed requires you to login.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
                }*/

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

     

        $criteria=NULL;

        $cmbSearchType	=	"";

        $txtSearch		=	"";

        if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {

            $cmbSearchType	=	$_GET["cmbSearchType"];

            $txtSearch		=	$_GET["txtSearch"];

            $data = $this->paginate('Ruler', array('Ruler.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%"));

        }

        else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&

                $this->passedArgs["txtSearch"] != '') {

            $cmbSearchType	=	$this->passedArgs["cmbSearchType"];

            $txtSearch		=	$this->passedArgs["txtSearch"];

            $data = $this->paginate('Ruler', array('Ruler.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%"));

        }

        else {

            $data = $this->paginate('Ruler', array('Ruler.id <>' => 0));

        }



        $this->set('cmbSearchType', $cmbSearchType);

        $this->set('txtSearch', stripcslashes($txtSearch));

        $this->passedArgs['limit']=$this->paginate["limit"];

        $this->set('passedarg',$this->passedArgs);

        $this->set('rulers', $data);

        $this->layout = 'adm';


    }


       function __validateLoginStatus($typ='A') {
        if($typ == 'A') {
            if($this->Session->check('Admin') == false) {
                $this->Session->setFlash('The URL you have followed requires you to login.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'admins', 'action' => 'login'));
            }
        }else {
            if($this->Session->check('Userlog') == false) {
                $this->Session->setFlash('The URL you have followed requires you to login.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
            }
        }
    }

    function add() {



		 $this->__validateLoginStatus();



		$admsess	=	$this->Session->read('Admin');



		if($admsess["promocodes"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index'));



			exit();



		}



		if (!empty($this->data)) {
               


			//checking for duplicates starts here...



			 $dups=$this->Ruler->findByRulerName($this->data["Ruler"]["ruler_name"]);



			 if(isset($dups["Ruler"]["id"]) && $dups["Ruler"]["id"] <> '')



		     {



		         $this->Session->setFlash('Ruler Name Already exists.', 'default',array('class'=> 'failure'));


		         $this->redirect('/rulers');

		         exit();

		      }



			//checking for duplicates ends here...


                        $this->data['ruler_status'] = 'Y';
                        
                      
			if ($this->Ruler->save($this->data)) {



				$this->Session->setFlash('This ruler has been saved.', 'default',array('class'=> 'success'));



				$this->redirect(array('controller' => 'rulers', 'action' => 'index'));



			}



		}



		$this->layout = 'adm';



	}

        function edit($id=0) {



		$this->__validateLoginStatus();



		$admsess	=	$this->Session->read('Admin');



		if($admsess["promocodes"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index'));



			exit();



		}



		if($id == 0){



			$this->redirect(array('controller' => 'rulers','action'=>'index'));



			exit();



		}



		$this->Ruler->id					=	$id;



		if (!empty($this->data)) {



		    //checking for duplicates starts here...



		     $dups=$this->Ruler->checkEditDups($this->data["Ruler"]["ruler_name"],$id);



		     if(isset($dups) && $dups > 0)



		     {



				 $this->Session->setFlash('Ruler Already exists.', 'default',array('class'=> 'failure'));



		         $this->redirect('/rulers');



		         exit();



		      }



		    //checking for duplicates ends here...







			if ($this->Ruler->save($this->data)) {



				 $this->Session->setFlash('Ruler has been edited Successfully.', 'default',array('class'=> 'success'));



				$this->redirect(array('controller' => 'rulers', 'action' => 'index'));



			}



		}



		$this->data 					= 	$this->Ruler->read();



		$this->set('Ruler', $this->data);



		$this->layout = 'adm';







	}


        function delete($id){



		$this->__validateLoginStatus();



		$admsess	=	$this->Session->read('Admin');



		if($admsess["promocodes"] <> 1){



		 	$this->redirect(array('controller' => 'admins', 'action' => 'index'));



			exit();



		}

              //  if($user_exists == 0){

                    $this->Ruler->del($id,true);

                    $this->Session->setFlash('Ruler has been deleted Successfully.', 'default',array('class'=> 'success'));
                    $this->redirect('index');
             /*   }
                else{
                    $this->Session->setFlash('Sorry, this ruler is already used, you cannot delete this account number. ', 'default',array('class'=> 'success'));
                    $this->redirect('index');
                }*/





	}




    }
?>
