/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jrdesktop.main;
import jrdesktop.utilities.ImageUtility;
import jrdesktop.viewer.FileMng.FilesDropTargetListener;
import jrdesktop.viewer.Recorder;

public class ScreenPlayer
extends JLabel {
    private Recorder recorder;
    private Image img;
    boolean PartialScreenMode = false;
    private Rectangle selectionRect = new Rectangle(0, 0, 0, 0);
    private Rectangle oldselectionRect = new Rectangle(-1, -1, -1, -1);
    private Rectangle screenRect = new Rectangle(0, 0, 0, 0);
    private Rectangle oldScreenRect = new Rectangle(-1, -1, -1, -1);
    private KeyAdapter keyAdapter;
    private MouseAdapter mouseAdapter;
    private MouseWheelListener mouseWheelListener;
    private MouseMotionAdapter mouseMotionAdapter;
    private boolean isSelecting = false;
    private int srcx;
    private int srcy;
    private int destx;
    private int desty;
    private BasicStroke bs;
    private GradientPaint gp;

    public ScreenPlayer(Recorder recorder) {
        this.recorder = recorder;
        this.keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 122) {
                    ((ScreenPlayer)ScreenPlayer.this).recorder.viewerGUI.changeFullScreenMode();
                }
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }

            public void keyReleased(KeyEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }
        };
        this.mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }
        };
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }

            public void mouseDragged(MouseEvent e) {
                if (ScreenPlayer.this.isSelecting) {
                    ScreenPlayer.this.destx = e.getX();
                    ScreenPlayer.this.desty = e.getY();
                } else {
                    ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
                }
            }
        };
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (ScreenPlayer.this.isSelecting) {
                    ScreenPlayer.this.destx = (ScreenPlayer.this.srcx = e.getX());
                    ScreenPlayer.this.desty = (ScreenPlayer.this.srcy = e.getY());
                } else {
                    ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                ScreenPlayer.this.DoneSelecting();
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }
        };
        this.setFocusable(true);
        this.InitialSelectionRect();
        new DropTarget(this, new FilesDropTargetListener(this, recorder));
    }

    public void addAdapters() {
        this.addKeyListener(this.keyAdapter);
        this.addMouseWheelListener(this.mouseWheelListener);
        this.addMouseMotionListener(this.mouseMotionAdapter);
        this.addMouseListener(this.mouseAdapter);
    }

    public void removeAdapters() {
        this.removeKeyListener(this.keyAdapter);
        this.removeMouseWheelListener(this.mouseWheelListener);
        this.removeMouseMotionListener(this.mouseMotionAdapter);
        this.removeMouseListener(this.mouseAdapter);
    }

    public void paint(Graphics g) {
        g.drawImage(this.img, 0, 0, this.screenRect.width, this.screenRect.height, this);
        this.DrawSelectingRect(g);
    }

    public void UpdateScreen(byte[] data) {
        this.screenRect = new Rectangle(this.recorder.viewerData.getScreenRect());
        float screenScale = this.recorder.viewerData.getScreenScale();
        this.screenRect.width = (int)((float)this.screenRect.width * screenScale);
        this.screenRect.height = (int)((float)this.screenRect.height * screenScale);
        if (!this.PartialScreenMode) {
            if (!this.screenRect.equals(this.oldScreenRect)) {
                this.oldScreenRect = this.screenRect;
                this.setSize(this.screenRect.getSize());
                this.setPreferredSize(this.screenRect.getSize());
            }
        } else if (!this.isSelecting && !this.selectionRect.equals(this.oldselectionRect)) {
            this.oldselectionRect = this.selectionRect;
            this.setSize(this.selectionRect.getSize());
            this.setPreferredSize(this.selectionRect.getSize());
        }
        this.img = ImageUtility.read(data);
        this.repaint();
    }

    public void clearScreen() {
        this.setSize(new Dimension(1, 1));
        this.setPreferredSize(new Dimension(1, 1));
        this.img = this.createImage(this.getWidth(), this.getHeight());
        this.repaint();
        this.oldScreenRect = new Rectangle(-1, -1, -1, -1);
    }

    public void InitialSelectionRect() {
        this.bs = new BasicStroke(5.0f, 1, 1, 0.0f, new float[]{12.0f, 12.0f}, 0.0f);
        this.gp = new GradientPaint(0.0f, 0.0f, Color.red, 1.0f, 1.0f, Color.white, true);
    }

    public void DrawSelectingRect(Graphics g) {
        if (this.isSelecting && (this.srcx != this.destx || this.srcy != this.desty)) {
            int x1 = this.srcx < this.destx ? this.srcx : this.destx;
            int y1 = this.srcy < this.desty ? this.srcy : this.desty;
            int x2 = this.srcx > this.destx ? this.srcx : this.destx;
            int y2 = this.srcy > this.desty ? this.srcy : this.desty;
            this.selectionRect.x = x1;
            this.selectionRect.y = y1;
            this.selectionRect.width = x2 - x1 + 1;
            this.selectionRect.height = y2 - y1 + 1;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(this.bs);
            g2d.setPaint(this.gp);
            g2d.draw(this.selectionRect);
            this.PartialScreenMode = true;
        }
    }

    public boolean isPartialScreenMode() {
        return this.PartialScreenMode;
    }

    public Rectangle getSelectionRect() {
        return this.selectionRect;
    }

    public boolean isSelectionRectChanged() {
        boolean bool = !this.selectionRect.equals(this.oldselectionRect);
        this.oldselectionRect = this.selectionRect;
        return bool;
    }

    public boolean isScreenRectChanged() {
        boolean bool = !this.screenRect.equals(this.oldScreenRect);
        this.oldScreenRect = this.screenRect;
        return bool;
    }

    public void startSelectingMode() {
        this.isSelecting = true;
        Cursor cursor = new Cursor(1);
        this.setCursor(cursor);
    }

    public void stopSelectingMode() {
        this.PartialScreenMode = false;
        this.selectionRect = new Rectangle(0, 0, 0, 0);
        this.recorder.viewerData.setScreenRect(new Rectangle(0, 0, 0, 0));
        this.recorder.viewer.updateOptions();
    }

    public void DoneSelecting() {
        if (this.isSelecting) {
            this.isSelecting = false;
            this.oldselectionRect = new Rectangle();
            if (this.PartialScreenMode) {
                float screenScale = 1.0f / this.recorder.viewerData.getScreenScale();
                Rectangle rect = new Rectangle(this.selectionRect);
                rect.x = (int)((float)rect.x * screenScale);
                rect.y = (int)((float)rect.y * screenScale);
                rect.height = (int)((float)rect.height * screenScale);
                rect.width = (int)((float)rect.width * screenScale);
                this.recorder.viewerData.setScreenRect(rect);
                this.recorder.viewer.updateOptions();
                this.recorder.viewerGUI.jBtnPartialComplete.setIcon(new ImageIcon(main.DEFAULT_SCREEN_ICON));
            }
            this.srcx = this.destx;
            this.srcy = this.desty;
            Cursor cursor = new Cursor(0);
            this.setCursor(cursor);
        }
    }
}

