/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jrdesktop.main;
import jrdesktop.server.rmi.Server;

public class ActiveConnectionsGUI
extends JFrame {
    DefaultListModel listModel = new DefaultListModel();
    private JButton jButtonClose;
    private JButton jButtonDetails;
    private JButton jButtonDisconnect;
    private JButton jButtonDisconnectAll;
    private JButton jButtonProperties;
    private JButton jButtonRefresh;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public ActiveConnectionsGUI() {
        this.initComponents();
        this.jList1.setModel(this.listModel);
        this.updateList();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButtonClose = new JButton();
        this.jButtonDisconnect = new JButton();
        this.jButtonProperties = new JButton();
        this.jButtonDisconnectAll = new JButton();
        this.jButtonDetails = new JButton();
        this.jButtonRefresh = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Active Connections");
        this.setIconImage(new ImageIcon(main.IDLE_ICON).getImage());
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Active Connections"));
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 227, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 218, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsGUI.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonDisconnect.setText("Disconnect");
        this.jButtonDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsGUI.this.jButtonDisconnectActionPerformed(evt);
            }
        });
        this.jButtonProperties.setText("Properties");
        this.jButtonProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsGUI.this.jButtonPropertiesActionPerformed(evt);
            }
        });
        this.jButtonDisconnectAll.setText("Disconnect all");
        this.jButtonDisconnectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsGUI.this.jButtonDisconnectAllActionPerformed(evt);
            }
        });
        this.jButtonDetails.setText("Details");
        this.jButtonDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsGUI.this.jButtonDetailsActionPerformed(evt);
            }
        });
        this.jButtonRefresh.setText("Refresh");
        this.jButtonRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsGUI.this.jButtonRefreshActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonDisconnectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonRefresh, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose, -2, 74, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jButtonDisconnect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProperties, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDetails))).addGap(27, 27, 27)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDisconnect).addComponent(this.jButtonProperties).addComponent(this.jButtonDetails)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDisconnectAll).addComponent(this.jButtonRefresh).addComponent(this.jButtonClose)).addContainerGap()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 308) / 2, (screenSize.height - 380) / 2, 308, 380);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDisconnectActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index == -1) {
            return;
        }
        InetAddress inetAddress = (InetAddress)this.jList1.getSelectedValue();
        if (JOptionPane.showConfirmDialog(this, "Disconnect " + inetAddress.toString() + " ? ", "Confirm Dialog", 2, 3) == 2) {
            return;
        }
        Server.removeViewer(index);
        this.listModel.remove(index);
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Server.displayViewerProperties(index);
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.listModel.clear();
        this.updateList();
    }

    private void jButtonDisconnectAllActionPerformed(ActionEvent evt) {
        int index = this.jList1.getModel().getSize();
        if (index == 0) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Disconnect all viewers ? ", "Confirm Dialog", 2, 3) == 0) {
            Server.disconnectAllViewers();
        }
        this.listModel.clear();
        this.updateList();
    }

    private void jButtonDetailsActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Server.displayConnectionInfos(index);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ActiveConnectionsGUI().setVisible(true);
            }
        });
    }

    public void updateList() {
        if (Server.getViewersCount() == 0) {
            return;
        }
        Object[] objects = (Object[])Server.getViewersAds().toArray().clone();
        for (int i = 0; i < objects.length; ++i) {
            this.listModel.addElement(objects[i]);
        }
    }
}

