/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.awt.AWTException;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jrdesktop.AboutGUI;
import jrdesktop.main;
import jrdesktop.mainFrame;
import jrdesktop.server.ActiveConnectionsGUI;
import jrdesktop.server.Config;
import jrdesktop.server.ConfigGUI;
import jrdesktop.server.rmi.Server;
import jrdesktop.viewer.ConnectionDialog;

public class SysTray {
    public static final int SERVER_STARTED = 1;
    public static final int SERVER_STOPPED = 2;
    public static final int CONNECTION_FAILED = 3;
    public static final int SERVER_RUNNING = 4;
    public static final int SERVER_NOT_RUNNING = 5;
    private static MenuItem serverItem;
    private static TrayIcon trayIcon;
    private static boolean enabled;

    public static void updateServerStatus(int msgType) {
        if (!SystemTray.isSupported() || !enabled) {
            return;
        }
        switch (msgType) {
            case 4: {
                serverItem.setLabel("Stop Server");
                if (Server.isRunning()) {
                    if (Server.getViewersCount() != 0) {
                        trayIcon.setImage(new ImageIcon(main.ALIVE_ICON).getImage());
                    } else {
                        trayIcon.setImage(new ImageIcon(main.WAIT_ICON).getImage());
                    }
                }
                trayIcon.setToolTip("jrdesktop [Server running]\n" + Config.server_address);
                break;
            }
            case 5: {
                serverItem.setLabel("Start");
                trayIcon.setImage(new ImageIcon(main.IDLE_ICON).getImage());
                trayIcon.setToolTip("jrdesktop [Server stopped]\n" + Config.server_address);
                break;
            }
            case 1: {
                serverItem.setLabel("Stop");
                trayIcon.displayMessage("Connection status", "Server Started !!", TrayIcon.MessageType.INFO);
                trayIcon.setImage(new ImageIcon(main.WAIT_ICON).getImage());
                trayIcon.setToolTip("jrdesktop [Server running]\n" + Config.server_address);
                break;
            }
            case 3: {
                trayIcon.displayMessage("Connection status", "Connection Failed !!", TrayIcon.MessageType.ERROR);
                break;
            }
            case 2: {
                serverItem.setLabel("Start");
                trayIcon.displayMessage("Connection status", "Server Stopped !!", TrayIcon.MessageType.INFO);
                trayIcon.setImage(new ImageIcon(main.IDLE_ICON).getImage());
                trayIcon.setToolTip("jrdesktop [Server stopped]\n" + Config.server_address);
            }
        }
        serverItem.setEnabled(true);
    }

    public static void displayViewer(String viewer, int size, boolean connected) {
        if (!SystemTray.isSupported() || !enabled) {
            return;
        }
        if (connected) {
            trayIcon.displayMessage("Viewer details", viewer + " connected !!", TrayIcon.MessageType.INFO);
            if (size == 0) {
                trayIcon.setImage(new ImageIcon(main.ALIVE_ICON).getImage());
            }
        } else {
            trayIcon.displayMessage("Viewer details", viewer + " disconnected !!", TrayIcon.MessageType.INFO);
            if (size == 0) {
                trayIcon.setImage(new ImageIcon(main.WAIT_ICON).getImage());
            }
        }
    }

    public static boolean isSupported() {
        return SystemTray.isSupported();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isServerRunning() {
        boolean bool = Server.isRunning();
        if (!bool) {
            JOptionPane.showMessageDialog(null, "Server is not running !!", "Information", 1);
        }
        return bool;
    }

    public static void Hide() {
        enabled = false;
        if (!SystemTray.isSupported()) {
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        tray.remove(trayIcon);
    }

    public static void Show() {
        if (!SystemTray.isSupported()) {
            return;
        }
        enabled = true;
        Runnable runner = new Runnable(){

            public void run() {
                final SystemTray tray = SystemTray.getSystemTray();
                PopupMenu popup = new PopupMenu();
                trayIcon = new TrayIcon(new ImageIcon(main.IDLE_ICON).getImage(), "Remote Desktop Application", popup);
                MenuItem item = new MenuItem("Open jrdesktop");
                item.setFont(new Font(null, 1, 12));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        mainFrame.main(null);
                    }
                });
                item = new MenuItem("-");
                Menu menu = new Menu("Server");
                serverItem = new MenuItem("Start");
                serverItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        serverItem.setEnabled(false);
                        if (Server.isRunning()) {
                            Server.Stop();
                        } else {
                            Server.Start();
                        }
                    }
                });
                menu.add(serverItem);
                item = new MenuItem("Configuration ...");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ConfigGUI.main(null);
                    }
                });
                menu.add(item);
                item = new MenuItem("Active Connections");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (SysTray.isServerRunning()) {
                            ActiveConnectionsGUI.main(null);
                        }
                    }
                });
                menu.add(item);
                Menu subMenu = new Menu("File transfer");
                item = new MenuItem("Send Files");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (SysTray.isServerRunning() && Server.SendClipboardFileList() == 0) {
                            JOptionPane.showMessageDialog(null, "No file in clipboard !!", "Information", 1);
                        }
                    }
                });
                subMenu.add(item);
                item = new MenuItem("Receive Files");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (SysTray.isServerRunning()) {
                            Server.setUploadingFolder();
                        }
                    }
                });
                subMenu.add(item);
                item = new MenuItem("-");
                item = new MenuItem("Connect to Server ...");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ConnectionDialog.main(null);
                    }
                });
                popup.add(item);
                item = new MenuItem("-");
                item = new MenuItem("About");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        AboutGUI.main(null);
                    }
                });
                item = new MenuItem("Exit");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (JOptionPane.showConfirmDialog(null, "Exit application ?", "Confirm Dialog", 2) == 0) {
                            tray.remove(trayIcon);
                            main.exit();
                        }
                    }
                });
                popup.add(item);
                try {
                    tray.add(trayIcon);
                }
                catch (AWTException e) {
                    System.err.println("Can't add to tray");
                }
                if (Server.isRunning()) {
                    SysTray.updateServerStatus(4);
                } else if (!Server.isIdle()) {
                    SysTray.updateServerStatus(5);
                }
            }
        };
        EventQueue.invokeLater(runner);
    }

    static {
        enabled = false;
    }
}

