TRUNCATE TABLE `cms_sections`;

INSERT INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`, `module`, `db_type`, `smb_id`) VALUES
	(1, 2, 'Manage Groups', 'groups', 'cms_groups', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"publishColumn":"published",\r\n"listColumns":["id","group_name","user_privilege"],\r\n"showColumns":["id","group_name","position","user_privilege"],\r\n"detailColumns":["id","group_name","position","user_privilege"],\r\n"detailHeaderColumns":["group_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","searchable":"searchable","editoptions":{"type":"hidden"}},\r\n    "group_name":{"name":"Group Name","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Group Name","class":"textbox"}},\r\n    "position":{"name":"Display Order","sortable":"true","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}},\r\n    "user_privilege":{"name":"Privilege","sortable":"true","searchable":"searchable","editoptions":{"type":"select","source":{"all":"All","s":"Superadmin"},"source_type":"array","label":"Privilege","class":"select","enumvalues":{"all":"All","s":"Superadmin"}}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 2, '', 'admin', 'main', NULL),
	(2, 2, 'Manage Sections', 'sections', 'cms_sections', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"listColumns":["group_id","section_name","section_alias","visibilty","display_order"],\r\n"showColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailHeaderColumns":["section_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_id":{"name":"Group ID","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"select","source":"Cms::getAllGroups","source_type":"function","label":"Group Name","class":"select"},"external":"true","externalOptions":{"externalTable":"cms_groups","externalColumn":"id","externalShowColumn":"group_name"}},\r\n    "section_name":{"name":"Section Name","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Name","class":"textbox"}},\r\n    "section_alias":{"name":"Section Alias","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Alias","class":"textbox"}},\r\n    "table_name":{"name":"Table Name","editoptions":{"validations":["required"],"type":"textbox","label":"Table Name","class":"textbox"}},\r\n    "section_config":{"name":"Section Config","editoptions":{"validations":["required"],"type":"textarea","label":"Section Config","class":"textarea"}},\r\n    "visibilty":{"name":"Make Visible","sortable":"true","searchable":"searchable","editoptions":{"type":"checkbox","label":"Make Visible","class":"inline","default":"yes","enumvalues":{"1":"Visible","0":"Invisible"}}},\r\n    "display_order":{"name":"Display Order","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 3, '', 'admin', 'main', NULL),
	(3, 2, 'Manage Settings', 'manage_settings', 'tbl_cms_settings', '{\r\n"keyColumn":"id",\r\n"listColumns":["cms_set_name","cms_set_value"],\r\n"showColumns":["cms_set_name","cms_set_value"],\r\n"detailColumns":["id","cms_set_name","cms_set_value"],\r\n"detailHeaderColumns":["cms_set_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "cms_set_name":{"name":"Name","sortable":"true","searchable":"searchable","editoptions":{"type":"disabled","label":"Name"}},\r\n    "cms_set_value":{"name":"Value","sortable":"true","searchable":"searchable","editoptions":{"width":"400px","type":"textbox","label":"Value","class":"textbox"}}\r\n},\r\n"opertations":["edit","view"]\r\n}', '1', 1, '', 'admin', 'main', NULL),
	(56, 1, 'Users', 'users', 'tbl_users', '{\r\n	"keyColumn": "user_id",\r\n	"wildsearch": "true",\r\n	"includeJsFiles": [\r\n		"cms_select_state_user.js"\r\n	],\r\n	"detailHeaderColumnPrefix": "Users: ",\r\n	"detailHeaderColumns": [\r\n		"user_email"\r\n	],\r\n	"where": "user_status!=\'D\' ",\r\n	"breadCrumbColumn": "user_firstname,user_lastname",\r\n	"handleFile": "true",\r\n	"orderBy": {\r\n		"user_id": "DESC"\r\n	},\r\n	"listColumns": [\r\n		"user_image_id",\r\n		"user_firstname",\r\n		"user_lastname",\r\n		"user_email",\r\n		"user_status",\r\n		"Login"\r\n	],\r\n	"showColumns": [\r\n		"user_id",\r\n		"user_image_id",\r\n		"user_firstname",\r\n		"user_lastname",\r\n		"user_email",\r\n		"user_password",\r\n		"user_gender",\r\n		"user_date_of_birth",\r\n		"user_address",\r\n		"user_city",\r\n		"user_state",\r\n		"user_country",\r\n		"user_phone",\r\n		"user_zipcode",\r\n		"user_created_on",\r\n		"user_last_login"\r\n	],\r\n	"detailColumns": [\r\n		"user_id",\r\n		"user_image_id",\r\n		"user_firstname",\r\n		"user_lastname",\r\n		"user_email",\r\n		"user_password",\r\n		"user_gender",\r\n		"user_date_of_birth",\r\n		"user_address",\r\n		"user_city",\r\n		"user_state",\r\n		"user_country",\r\n		"user_phone",\r\n		"user_zipcode",\r\n		"user_created_on",\r\n		"user_last_login",\r\n		"user_status",\r\n		"Login"\r\n	],\r\n	"columns": {\r\n		"user_id": {\r\n			"name": "ID",\r\n			"editoptions": {\r\n				"type": "hidden"\r\n			}\r\n		},\r\n		"user_image_id": {\r\n			"name": "Profile Picture",\r\n			"editoptions": {\r\n				"type": "file",\r\n				"label": "Profile Picture",\r\n				"class": "file",\r\n				"hint": "Ideal size 300 x 300. Allowed file types are jpg,jpeg,gif and png.",\r\n				"file_types": "gif,png,jpg,jpeg",\r\n				"validations": [\r\n					"file_type"\r\n				]\r\n\r\n			},\r\n			"external": "true",\r\n			"externalOptions": {\r\n				"externalTable": "tbl_files",\r\n				"externalColumn": "file_id",\r\n				"externalShowColumn": "file_id"\r\n			}\r\n		},\r\n		"user_firstname": {\r\n			"name": "First Name",\r\n			"searchable": "true",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "First Name",\r\n				"class": "textbox",\r\n				"validations": [\r\n					"required"\r\n				]\r\n			}\r\n		},\r\n		"user_lastname": {\r\n			"name": "Last Name",\r\n			"searchable": "true",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "Last Name",\r\n				"class": "textbox",\r\n				"validations": [\r\n					"required"\r\n				]\r\n			}\r\n		},\r\n		"user_email": {\r\n			"name": "Email",\r\n			"sortable": "true",\r\n			"searchable": "true",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "Email",\r\n				"class": "textbox",\r\n				"validations": [\r\n					"required",\r\n					"email"\r\n				]\r\n			}\r\n		},\r\n		"user_password": {\r\n			"name": "Password",\r\n			"editoptions": {\r\n				"type": "password",\r\n				"label": "Password",\r\n				"class": "textbox",\r\n				"validations": [\r\n					"required"\r\n				]\r\n			}\r\n		},\r\n		"user_gender": {\r\n			"name": "Gender",\r\n			"editoptions": {\r\n				"type": "radio",\r\n				"options": {\r\n					"M": "Male",\r\n					"F": "Female"\r\n				},\r\n				"label": "Gender",\r\n				"class": "radio",\r\n				"enumvalues": {\r\n					"M": "Male",\r\n					"F": "Female"\r\n				}\r\n			}\r\n		},\r\n		"user_date_of_birth": {\r\n			"name": "Date of Birth",\r\n			"dbFormat": "date",\r\n			"displayFormat": "m/d/Y",\r\n			"editoptions": {\r\n				"type": "datepicker",\r\n				"label": "Date of Birth"\r\n			}\r\n		},\r\n		"user_address": {\r\n			"name": "Address",\r\n			"editoptions": {\r\n				"type": "textarea",\r\n				"label": "Address",\r\n				"class": "textarea"\r\n			}\r\n		},\r\n		"user_city": {\r\n			"name": "City",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "City",\r\n				"class": "textbox"\r\n			}\r\n		},\r\n		"user_zipcode": {\r\n			"name": "Zip",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "Zip",\r\n				"class": "textbox"\r\n			}\r\n		},\r\n		"user_state": {\r\n			"name": "State",\r\n			"editoptions": {\r\n				"type": "select",\r\n				"source": "Cmshelper::getAllStates",\r\n				"source_type": "function",\r\n				"label": "State",\r\n				"class": "select"\r\n			},\r\n			"external": "true",\r\n			"externalOptions": {\r\n				"externalTable": "tbl_state",\r\n				"externalColumn": "ts_code",\r\n				"externalShowColumn": "ts_name"\r\n			}\r\n		},\r\n		"user_country": {\r\n			"name": "Country",\r\n			"editoptions": {\r\n				"type": "select",\r\n				"source": "Cmshelper::getAllCountries",\r\n				"source_type": "function",\r\n				"label": "Country",\r\n				"class": "select"\r\n			},\r\n			"external": "true",\r\n			"externalOptions": {\r\n				"externalTable": "tbl_country",\r\n				"externalColumn": "tc_code",\r\n				"externalShowColumn": "tc_name"\r\n			}\r\n		},\r\n		"user_phone": {\r\n			"name": "Telephone",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "Telephone",\r\n				"class": "textbox"\r\n			}\r\n		},\r\n		"user_status": {\r\n			"name": "Status",\r\n			"searchable": "true",\r\n			"sortable": "true",\r\n\r\n			"listoptions": {\r\n				"type": "button",\r\n				"customaction": "Cmshelper::changeUserStatus",\r\n				"enumvalues": {\r\n					"A": "Active",\r\n					"I": "Inactive"\r\n				},\r\n				"buttonColors": {\r\n					"A": "green",\r\n					"I": "red"\r\n				}\r\n			}\r\n		},\r\n		"user_created_on": {\r\n			"name": "Joined On",\r\n			"sortable": "true",\r\n			"dbFormat": "timestamp",\r\n			"displayFormat": "m/d/Y"\r\n		},\r\n		"user_last_login": {\r\n			"name": "Last Logged In On",\r\n			"dbFormat": "timestamp",\r\n			"displayFormat": "m/d/Y"\r\n		},\r\n		"user_points": {\r\n			"name": "User Points",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "User Points",\r\n				"class": "textbox"\r\n			}\r\n		},\r\n		"Login": {\r\n			"name": "Login",\r\n			"customColumn": "true",\r\n			"customaction": "Cmshelper::getUserLoginUrl"\r\n		}\r\n	},\r\n	"relations": {\r\n		"Friends List": {\r\n			"name": "Friends List",\r\n			"section": "friends_list",\r\n			"child_table": "tbl_friends_list",\r\n			"parent_join_column": "user_id",\r\n			"child_join_column": "friends_list_user_id",\r\n			"where": "child.friends_list_status!=\'D\' "\r\n		},\r\n		"Community": {\r\n			"name": "Group List",\r\n			"section": "user_community",\r\n			"child_table": "tbl_community_member",\r\n			"parent_join_column": "user_id",\r\n			"child_join_column": "cmember_id",\r\n			"where": "child.cmember_status!=\'D\' "\r\n		}\r\n	},\r\n	"customActions": {\r\n		"afterAddRecord": "User::updateUserRegisterTime",\r\n		"beforeAddRecord": "Cmshelper::userUpdate",\r\n		"beforeEditRecord": "Cmshelper::userUpdate",\r\n		"afterEditRecord": "User::updateUserFile"\r\n	},\r\n	"opertations": [\r\n		"add",\r\n		"view",\r\n		"edit",\r\n		"customdelete"\r\n	],\r\n	"customDeleteOperation": "Cmshelper::deleteUser"\r\n}', '1', 2, 'all', 'admin', 'main', NULL),
	(57, 4, 'Meta Tags', 'meta_tags', 'fw_metadata', '{\r\n "keyColumn": "id",\r\n "detailHeaderColumnPrefix": "Meta Tag : ",\r\n    "detailHeaderColumns": [\r\n        "url"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "url",\r\n        "title",\r\n        "keyword"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "title": {\r\n            "name": "Meta Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Meta Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "keyword": {\r\n            "name": "Meta Keywords",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Keywords",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "description": {\r\n            "name": "Meta Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "url": {\r\n            "name": "Page Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "label": "Page Url",\r\n                "type": "textbox",\r\n                "class": "textbox",\r\n                "hint":"<b>Url combinations can be : </b><br/><b style=\'color:red\'> /abc/</b> [exact location abc after your domain name] eg : www.domainname.com/abc/ ,<br/> <b style=\'color:red\'>/abc/* </b> [any combination after location abc after your domain name] eg : www.domainname.com/abc/test1,<br/> <b style=\'color:red\'>* </b>[default value] ",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all', 'admin', 'main', NULL),
	(58, 4, 'Static Content', 'static_content', 'tbl_content', '{\r\n	"keyColumn": "content_id",\r\n	"detailHeaderColumns": [\r\n		"content_title"\r\n	],\r\n	"orderBy": {\r\n		"content_id": "ASC"\r\n	},\r\n	"listColumns": [\r\n		"content_title",\r\n		"content_description"\r\n	],\r\n	"showColumns": [\r\n		"content_id",\r\n		"content_title",\r\n		"content_description"\r\n	],\r\n	"detailColumns": [\r\n		"content_id",\r\n		"content_title",\r\n		"content_description"\r\n	],\r\n	"columns": {\r\n		"content_id": {\r\n			"name": "ID",\r\n			"sortable": "true",\r\n			"editoptions": {\r\n				"type": "hidden"\r\n			}\r\n		},\r\n		"content_title": {\r\n			"name": "Title",\r\n			"sortable": "true",\r\n			"searchable": "searchable",\r\n			"editoptions": {\r\n				"validations": [\r\n					"required"\r\n				],\r\n				"type": "textbox",\r\n				"label": "Title",\r\n				"class": "textbox"\r\n			}\r\n		},\r\n		"content_description": {\r\n			"name": "Content",\r\n			"editoptions": {\r\n				"validations": [\r\n					"required"\r\n				],\r\n				"type": "textarea",\r\n                "label": "Content",\r\n                "class": "textarea",\r\n                "editorType": "ckeditor"\r\n				\r\n			}\r\n		}\r\n	},\r\n	"opertations": [\r\n		"edit",\r\n		"view", "add"\r\n	]\r\n}', '1', 1, 'all', 'admin', 'main', NULL),
	(59, 4, 'Help Content', 'help_content', 'tbl_Help', '{\r\n    "keyColumn": "help_id",\r\n"detailHeaderColumns":[ "help_id"],\r\n    "orderBy": {\r\n        "help_id": "ASC"\r\n    },\r\n    "listColumns": [\r\n     \r\n        "help_category_id",\r\n        "help_title",\r\n        "help_description",\r\n        "help_position",\r\n        "help_active"\r\n    ],\r\n    "showColumns": [\r\n         "help_id",\r\n        "help_category_id",\r\n        "help_title",\r\n        "help_description",\r\n        "help_position",\r\n        "help_active"\r\n    ],\r\n    "detailColumns": [\r\n        "help_id",\r\n        "help_category_id",\r\n        "help_title",\r\n        "help_description",\r\n        "help_position",\r\n        "help_active"\r\n    ],\r\n    "columns": {\r\n        "help_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n                \r\n            }\r\n        },"help_category_id": {\r\n           "name": "Category",\r\n           "sortable": "true",\r\n           "searchable": "true",\r\n           "editoptions": {\r\n               "validations": [\r\n                   "required"\r\n               ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllHelpCategories",\r\n                "source_type": "function",\r\n                "label": "Category",\r\n                "class": "select"\r\n           },\r\n           "external": "true",\r\n           "externalOptions": {\r\n               "externalTable": "tbl_HelpCategory",\r\n               "externalColumn": "help_category_id",\r\n               "externalShowColumn": "help_category_title"\r\n           }\r\n       },\r\n        "help_title": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                \r\n                \r\n                "label": "Title",\r\n                "class": "textbox",\r\n                \r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "help_description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "help_position": {\r\n            "name": "Sort Order",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Sort Order",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "help_active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 3, 'all', 'admin', 'main', NULL),
	(60, 4, 'Help Category', 'help_category', 'tbl_HelpCategory', '{\r\n    "keyColumn": "help_category_id",\r\n"detailHeaderColumns":["help_category_id"],\r\n    "orderBy": {\r\n        "help_category_id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        \r\n        "help_category_type",\r\n        "help_category_title",\r\n        "help_category_position",\r\n        "help_category_active"\r\n    ],\r\n    "showColumns": [\r\n        "help_category_id",\r\n        "help_category_type",\r\n        "help_category_title",\r\n        "help_category_position",\r\n        "help_category_active"\r\n    ],\r\n    "detailColumns": [\r\n        "help_category_id",\r\n        "help_category_type",\r\n        "help_category_title",\r\n        "help_category_position",\r\n        "help_category_active"\r\n    ],\r\n    "columns": {\r\n        "help_category_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n               \r\n            }\r\n        },\r\n        "help_category_type": {\r\n            "name": "User Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "admin": "Admin",\r\n                    "user": "User"\r\n                },\r\n                "source_type": "array",\r\n                "label": "User Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "admin": "Admin",\r\n                    "user": "User"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "help_category_title": {\r\n            "name": "Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "help_category_position": {\r\n            "name": "Sort Order",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Sort Order",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "help_category_active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 4, 'all', 'admin', 'main', NULL),
	(61, 4, 'Mail Templates', 'mail_templates', 'tbl_mail_template', '{\r\n    "keyColumn": "id",\r\n    "detailHeaderColumns": [\r\n        "id"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_status"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_body",\r\n        "mail_template_status",\r\n        "created_on"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_body",\r\n        "mail_template_status",\r\n        "created_on "\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "mail_template_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n            \r\n                "type": "textbox",\r\n                "label": "Template Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_sub": {\r\n            "name": "Subject",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Subject",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_body": {\r\n            "name": "Body",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Body",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_status": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeMailTemplateStatus",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                },\r\n                "buttonColors": {\r\n                    "0": "red",\r\n                    "1": "green"\r\n                }\r\n            }\r\n        },\r\n        "created_on": {\r\n            "name": "Created On",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "add"\r\n    ]\r\n}', '0', 1, 'all', 'admin', 'main', NULL),
	(62, 1, 'Classifieds', 'classifieds', 'tbl_classifieds', '{\r\n    "keyColumn": "classifieds_id",\r\n    "wildsearch": "true",\r\n    "detailHeaderColumnPrefix": "Classifieds: ",\r\n    "detailHeaderColumns": [\r\n        "classifieds_title"\r\n    ],\r\n    "orderBy": {\r\n        "classifieds_id": "DESC"\r\n    },\r\n    "where": "classifieds_status!=\'D\' ",\r\n    "breadCrumbColumn": "classifieds_title",\r\n    "handleFile": "true",\r\n    "listColumns": [\r\n        "classifieds_image_id",\r\n        "classifieds_title",\r\n        "classifieds_description",\r\n        "classifieds_created_by",\r\n        "classifieds_created_on",\r\n        "classifieds_status"\r\n    ],\r\n    "showColumns": [\r\n        "classifieds_image_id",\r\n        "classifieds_id",\r\n        "classifieds_title",\r\n        "classifieds_description",\r\n        "classifieds_category_id",\r\n        "classifieds_created_by",\r\n        "classifieds_created_on"\r\n    ],\r\n    "detailColumns": [\r\n        "classifieds_image_id",\r\n        "classifieds_id",\r\n        "classifieds_title",\r\n        "classifieds_description",\r\n        "classifieds_category_id",\r\n        "classifieds_created_by",\r\n        "classifieds_created_on",\r\n        "classifieds_status"\r\n    ],\r\n    "columns": {\r\n        "classifieds_id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "classifieds_title": {\r\n            "name": "Title",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "classifieds_description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "classifieds_image_id": {\r\n            "name": "Image",\r\n            "editoptions": {\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint": "Ideal size 300 x 300. Allowed file types are jpg,jpeg,gif and png.",\r\n                "file_types": "gif,png,jpg,jpeg",\r\n                "validations": [\r\n                    "file_type"\r\n                ]\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "classifieds_category_id": {\r\n            "name": "Category Name",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCategoryName",\r\n                "source_type": "function",\r\n                "label": "Category Name",\r\n                "defaulttext": "Nil",\r\n                "class": "select",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_categories",\r\n                "externalColumn": "category_id",\r\n                "externalShowColumn": "category_name"\r\n            }\r\n        },\r\n        "classifieds_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeClassifiedsStatus",\r\n                "enumvalues": {\r\n                    "A": "Approved",\r\n                    "I": "Not Approved"\r\n                },\r\n                "buttonColors": {\r\n                    "A": "green",\r\n                    "I": "red"\r\n                }\r\n            }\r\n        },\r\n        "classifieds_created_on": {\r\n            "name": "Posted On",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "classifieds_created_by": {\r\n            "name": "Posted By",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getClassifiedsCreatorName"\r\n        }\r\n    },\r\n    "relations": {\r\n        "Comments": {\r\n            "name": "Comments Posted",\r\n            "section": "classifieds_comments",\r\n            "child_table": "tbl_comments",\r\n            "parent_join_column": "classifieds_id",\r\n            "child_join_column": "comment_entity_id",\r\n            "where": "child.comment_entity_type=\'CF\' AND child.comment_status!=\'D\' "\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Classifieds::updateClassifiedsRegisterTime",\r\n        "afterEditRecord": "Classifieds::updateClassifiedsFile"\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "customdelete"\r\n    ],\r\n    "customDeleteOperation": "Cmshelper::deleteClassifieds"\r\n}', '0', 4, 'all', 'admin', 'main', NULL),
	(63, 3, 'Industries', 'industry', 'tbl_industry', '{\r\n    "keyColumn": "industry_id",\r\n    "wildsearch": "true",\r\n    "detailHeaderColumnPrefix": "Indusrties: ",\r\n    "detailHeaderColumns": [\r\n        "industry_name"\r\n    ],\r\n    "orderBy": {\r\n        "industry_parent_id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "industry_name",\r\n        "industry_parent_id",\r\n        "industry_status"\r\n    ],\r\n    "showColumns": [\r\n        "industry_name",\r\n        "industry_parent_id",\r\n        "industry_status"\r\n    ],\r\n    "detailColumns": [\r\n        "industry_name",\r\n        "industry_parent_id",\r\n        "industry_status",\r\n        "industry_id"\r\n    ],\r\n    "columns": {\r\n        "industry_id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "industry_name": {\r\n            "name": "Industry Name",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Industry Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "industry_parent_id": {\r\n            "name": "Parent Industry",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllIndustryName",\r\n                "source_type": "function",\r\n                "label": "Parent Industry",\r\n                "defaulttext": "Nil",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_industry",\r\n                "externalColumn": "industry_id",\r\n                "externalShowColumn": "industry_name"\r\n            }\r\n        },\r\n        "industry_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "default": "A",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeIndustryStatus",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "A": "green",\r\n                    "I": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 6, 'all', 'admin', 'main', NULL),
	(64, 1, 'Friends List', 'friends_list', 'tbl_friends_list', '{\r\n    "keyColumn": "friends_list_id",\r\n    "wildsearch": "true",\r\n    "reference": {\r\n        "referenceTable": " tbl_users",\r\n        "referenceColumn": "friends_list_user_id",\r\n        "referenceTableForiegnKey": "user_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Friends list: ",\r\n    "detailHeaderColumns": [\r\n        "friends_list_friend_id"\r\n    ],\r\n    "orderBy": {\r\n        "friends_list_id": "DESC"\r\n    },\r\n    "where": "friends_list_status!=\'D\'",\r\n    "listColumns": [\r\n  "Image",   \r\n        "friends_list_friend_id",    \r\n "Name",      \r\n        "Gender",\r\n        "Country"\r\n    ],\r\n    "detailColumns": [\r\n"friends_list_id",\r\n  "Image",\r\n        "friends_list_friend_id",\r\n        "Name",      \r\n        "Gender",\r\n        "Country"\r\n\r\n    ],\r\n    "columns": {\r\n        "friends_list_id": {\r\n            "name": "ID",\r\n            "type": "hidden"\r\n        },\r\n        "friends_list_friend_id": {\r\n            "name": "Email",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_users",\r\n                "externalColumn": "user_id",\r\n                "externalShowColumn": "user_email"\r\n            }\r\n        },\r\n        "Name": {\r\n            "name": "Name",\r\n           \r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getFriendName"\r\n        },\r\n        "Image": {\r\n            "name": "Profile Picture",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getFriendImage"\r\n        },\r\n        "Gender": {\r\n            "name": "Gender",\r\n         \r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getFriendGender",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "M": "Male",\r\n                    "F": "Female"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "M": "Male",\r\n                    "F": "Female"\r\n                }\r\n            }\r\n        },\r\n        "Country": {\r\n            "name": "Country",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getFriendCountry"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 2, 'all', 'admin', 'main', NULL),
	(75, 3, 'Settings', 'settings', 'tbl_lookup', '{\r\n    "siteSettings": "true",\r\n    "settingStyle": "tab",\r\n    "beforeEditRecord": "Cmshelper::changeLogo",\r\n    "hints": {\r\n        "vadmin_email": "Email where all site notifications, alerts and notifications are sent",\r\n        "sitelogo": "This is where you can change the logo of your site.",\r\n        "perpage": "Number of records to be displayed in all the listing pages.",\r\n        "ADMIN_APPROVE_BUSINESS_AUTO": "Uncheck to manually approve new business",\r\n        "ADMIN_APPROVE_CLASSIFIEDS_AUTO": "Uncheck to manually approve new classifieds",\r\n        "ADMIN_APPROVE_BIZCOM_AUTO": "Check to Auto Enable Approval of new groups",\r\n        "auto_approval": "Check to Auto Enable Approval of new pages",\r\n        "ADMIN_APPROVE_USER_AUTO": "Uncheck to manually activate new users",\r\n        "group_display": "Check to display groups as a widget in the user feed",\r\n        "friend_display": "Check to display friends as a widget in the user feed",\r\n        "organization_display": "Check to display Pages as a widget in the user feed",\r\n        "galleryForUsers": "Check to display Gallery as a widget in the user feed",\r\n        "pageGroupRelation": "Check to relate the page & group"\r\n    }\r\n}', '1', 1, 'all', 'admin', 'main', NULL),
	(76, 1, 'Dashboard', 'dashboard', 'tbl_lookup', '{\r\n    "dashboardPanel2": "true",\r\n    "rows": "3",\r\n    "row2": {\r\n        "columns": "1",\r\n        "column1": {\r\n            "display": "listing",\r\n            "title": "Recent Users",\r\n            "titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getNewUsersLink",\r\n            "fetchValue": "Cmshelper::getNewUsers",\r\n            "listcolumns": {\r\n                "username": {\r\n                    "name": "Name"\r\n                },\r\n                "email": {\r\n                    "name": "Email"\r\n                },\r\n                "joined_on": {\r\n                    "name": "Joined On"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "row3": {\r\n        "columns": "2",\r\n        "column1": {\r\n            "display": "listing",\r\n            "title": "Recent Group",\r\n            "titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getNewCommunityLink",\r\n            "fetchValue": "Cmshelper::getNewCommunity",\r\n            "listcolumns": {\r\n                "communityname": {\r\n                    "name": "Name"\r\n                },\r\n                "created_by": {\r\n                    "name": "Owner"\r\n                },\r\n                "created_on": {\r\n                    "name": "Created On"\r\n                }\r\n            }\r\n        },\r\n        "column2": {\r\n            "display": "listing",\r\n            "title": "Recent Page",\r\n            "titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getNewBusinessLink",\r\n            "fetchValue": "Cmshelper::getNewBusiness",\r\n            "listcolumns": {\r\n                "businessname": {\r\n                    "name": "Name"\r\n                },\r\n                "created_by": {\r\n                    "name": "Created By"\r\n                },\r\n                "industry": {\r\n                    "name": "Industry"\r\n                },\r\n                "created_on": {\r\n                    "name": "Created On"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "row1": {\r\n        "columns": "1",\r\n        "column1": {\r\n            "display": "listing",\r\n            "title": "Monthly Overview",\r\n            "fetchValue": "Cmshelper::getStatistics",\r\n            "listcolumns": {\r\n                "title": {\r\n                    "name": "Title"\r\n                },\r\n                "count": {\r\n                    "name": "Count"\r\n                }\r\n            }\r\n        }\r\n    }\r\n}', '1', 1, 'all', 'admin', 'main', NULL),
	(74, 1, 'Comments Posted', 'classifieds_comments', 'tbl_comments', '{\r\n    "keyColumn": "comment_id",\r\n"wildsearch":"true",\r\n    "reference": {\r\n        "referenceTable": " tbl_classifieds",\r\n        "referenceColumn": "comment_entity_id",\r\n        "referenceTableForiegnKey": "classifieds_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Comments Posted: ",\r\n    "detailHeaderColumns": [\r\n        "comment_id"\r\n    ],\r\n    "orderBy": {\r\n        "comment_id": "DESC"\r\n    },\r\n    "where": "comment_entity_type=\'CF\' AND comment_status!=\'D\' ",\r\n    "listColumns": [\r\n        "comment_content",\r\n"comment_created_by",\r\n        "comment_status"\r\n    ],\r\n  "showColumns": [\r\n      "comment_content",\r\n        "comment_status"\r\n    ],\r\n    "detailColumns": [\r\n"comment_id",\r\n        "comment_content",\r\n        "comment_created_on",\r\n "comment_created_by",\r\n        "comment_status"\r\n    ],\r\n    "columns": {\r\n        "comment_id": {\r\n            "name": "ID",\r\n   "editoptions": {\r\n            "type": "hidden"\r\n}\r\n        },\r\n        "comment_content": {\r\n            "name": "Comment",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n"editoptions":{\r\n"type": "textarea",\r\n"label": "Comment",\r\n"class":"textarea"\r\n}\r\n        },\r\n        "comment_created_on": {\r\n            "name": "Posted On",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n  "comment_created_by": {\r\n            "name": "Posted By",       \r\n    "sortable": "true",\r\n            "searchable": "true", \r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCommentCreatorName"\r\n        },\r\n        "comment_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "A": "Active",\r\n                    "I": "Inactive",\r\n                    "D": "Delete"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive",\r\n                    "D": "Delete"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeCommentStatus",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "A": "green",\r\n                    "I": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "customdelete"\r\n    ],\r\n    "customDeleteOperation": "Cmshelper::deleteComment"\r\n}', '0', 0, 'all', 'admin', 'main', NULL),
	(66, 1, 'Page', 'business', 'tbl_businesses', '{\r\n    "keyColumn": "business_id",\r\n    "wildsearch": "true",\r\n    "includeJsFiles": [\r\n        "cms_select_state_business.js"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Page : ",\r\n    "detailHeaderColumns": [\r\n        "business_name"\r\n    ],\r\n    "breadCrumbColumn": "business_name",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "business_id": "DESC"\r\n    },\r\n    "where": "business_status != \'D\' ",\r\n    "listColumns": [\r\n        "business_image_id",\r\n        "business_name",\r\n        "business_url",\r\n        "business_created_by",\r\n        "business_type",\r\n        "business_status"\r\n    ],\r\n    "showColumns": [\r\n        "business_id",\r\n        "business_name",\r\n        "business_url",\r\n        "business_email",\r\n        "business_description",\r\n        "business_type",\r\n        "business_address",\r\n        "business_city",\r\n        "business_state",\r\n        "business_country",\r\n        "business_phone",\r\n        "business_zipcode",\r\n        "business_image_id",\r\n        "business_created_on"\r\n        \r\n    ],\r\n    "detailColumns": [\r\n        "business_id",\r\n        "business_image_id",\r\n        "business_name",\r\n        "business_url",\r\n        "business_email",\r\n        "business_description",\r\n        "business_type",\r\n        "business_address",\r\n        "business_city",\r\n        "business_state",\r\n        "business_country",\r\n        "business_phone",\r\n        "business_zipcode",\r\n        "business_created_by",\r\n        "business_created_on",\r\n        "business_status"\r\n    ],\r\n    "columns": {\r\n        "business_id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "business_image_id": {\r\n            "name": "Logo",\r\n            "editoptions": {\r\n                "type": "file",\r\n                "label": "Logo",\r\n                "class": "file",\r\n                "hint": "Ideal size 300 x 300. Allowed file types are jpg,jpeg,gif and png.",\r\n"file_types":"gif,png,jpg,jpeg",\r\n"validations": [\r\n                    "file_type"\r\n                ]\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "business_name": {\r\n            "name": "Name",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "business_url": {\r\n            "name": "Site URL",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Site URL",\r\n                "class": "textbox",\r\n                "placeholder": "http://www.example.com",\r\n                "validations": [\r\n                    "required",\r\n                    "url"\r\n                ]\r\n            }\r\n        },\r\n        "business_email": {\r\n            "name": "Email",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Email",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required",\r\n                    "email"\r\n                ]\r\n            }\r\n        },\r\n        "business_description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "business_type": {\r\n            "name": "Type",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "P": "Product",\r\n                    "S": "Service"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Type",\r\n                "class": "select",\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "enumvalues": {\r\n                    "P": "Product",\r\n                    "S": "Service"\r\n                }\r\n            }\r\n        },\r\n        "business_address": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Address",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "business_city": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "business_zipcode": {\r\n            "name": "Zip",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "business_state": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllStates",\r\n                "source_type": "function",\r\n                "label": "State",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_state",\r\n                "externalColumn": "ts_code",\r\n                "externalShowColumn": "ts_name"\r\n            }\r\n        },\r\n        "business_country": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCountries",\r\n                "source_type": "function",\r\n                "label": "Country",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_country",\r\n                "externalColumn": "tc_code",\r\n                "externalShowColumn": "tc_name"\r\n            }\r\n        },\r\n        "business_phone": {\r\n            "name": "Telephone",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Telephone",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "business_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            \r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeBusinessStatus",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "A": "green",\r\n                    "I": "red"\r\n                }\r\n            }\r\n        },\r\n        "business_created_by": {\r\n            "name": "Created By",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getBusinessCreatorName"\r\n        },\r\n        "business_created_on": {\r\n            "name": "Joined On",\r\n            "sortable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n     "customActions": {\r\n        "afterAddRecord": "Business::updateBusinessRegisterTime",\r\n        "afterEditRecord": "Business::updateBusinessFile"\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "customdelete"\r\n    ],\r\n    "customDeleteOperation": "Cmshelper::deleteBusiness"\r\n}', '1', 2, 'all', 'admin', 'main', NULL),
	(73, 1, 'Comments Posted', 'bizcom_comments', 'tbl_comments', '{\r\n    "keyColumn": "comment_id",\r\n"wildsearch":"true",\r\n    "reference": {\r\n        "referenceTable": " tbl_communities",\r\n        "referenceColumn": "comment_entity_id",\r\n        "referenceTableForiegnKey": "community_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Comments Posted: ",\r\n    "detailHeaderColumns": [\r\n        "comment_id"\r\n    ],\r\n    "orderBy": {\r\n        "comment_id": "DESC"\r\n    },\r\n    "where": "comment_entity_type=\'C\' AND comment_status!=\'D\' ",\r\n    "listColumns": [\r\n        "comment_content",\r\n        "comment_created_by",\r\n        "comment_status"\r\n    ],\r\n    "showColumns": [\r\n"comment_id",\r\n        "comment_content",\r\n        "comment_status"\r\n    ],\r\n    "detailColumns": [\r\n"comment_id",\r\n        "comment_content",\r\n        "comment_created_on",\r\n        "comment_created_by",\r\n        "comment_status"\r\n    ],\r\n    "columns": {\r\n        "comment_id": {\r\n    "name": "ID",     \r\n "editoptions": {   \r\n            "type": "hidden" }\r\n        },\r\n        "comment_content": {\r\n            "name": "Comment",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Comment",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "comment_created_on": {\r\n            "name": "Posted On",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "comment_created_by": {\r\n            "name": "Posted By",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCommentCreatorName"\r\n        },\r\n        "comment_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "A": "Active",\r\n                    "I": "Inactive",\r\n                    "D": "Delete"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive",\r\n                    "D": "Delete"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeCommentStatus",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "A": "green",\r\n                    "I": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "customdelete"\r\n    ],\r\n    "customDeleteOperation": "Cmshelper::deleteComment"\r\n}', '0', 0, 'all', 'admin', 'main', NULL),
	(70, 1, 'Comments Posted', 'business_comments', 'tbl_comments', '{\r\n    "keyColumn": "comment_id",\r\n"wildsearch":"true",\r\n    "reference": {\r\n        "referenceTable": " tbl_businesses",\r\n        "referenceColumn": "comment_entity_id",\r\n        "referenceTableForiegnKey": "business_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Comments Posted: ",\r\n    "detailHeaderColumns": [\r\n        "comment_id"\r\n    ],\r\n    "orderBy": {\r\n        "comment_id": "DESC"\r\n    },\r\n    "where": "comment_entity_type=\'B\' AND comment_status!=\'D\' ",\r\n    "listColumns": [\r\n        "comment_content",\r\n"comment_created_by",\r\n        "comment_status"\r\n    ],\r\n  "showColumns": [\r\n      "comment_content",\r\n        "comment_status"\r\n    ],\r\n    "detailColumns": [\r\n"comment_id",\r\n        "comment_content",\r\n        "comment_created_on",\r\n "comment_created_by",\r\n        "comment_status"\r\n    ],\r\n    "columns": {\r\n        "comment_id": {\r\n            "name": "ID",\r\n"editoptions":{\r\n            "type": "hidden"\r\n}\r\n        },\r\n        "comment_content": {\r\n            "name": "Comment",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n"editoptions":{\r\n"type": "textarea",\r\n"label": "Comment",\r\n"class":"textarea"\r\n}\r\n        },\r\n        "comment_created_on": {\r\n            "name": "Posted On",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n  "comment_created_by": {\r\n            "name": "Posted By",        \r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCommentCreatorName"\r\n        },\r\n        "comment_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "A": "Active",\r\n                    "I": "Inactive",\r\n                    "D": "Delete"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive",\r\n                    "D": "Delete"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeCommentStatus",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "A": "green",\r\n                    "I": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "customdelete"\r\n    ],\r\n    "customDeleteOperation": "Cmshelper::deleteComment"\r\n}', '0', 0, 'all', 'admin', 'main', NULL),
	(71, 1, 'Members List', 'bizcom_member', 'tbl_community_member', '{\r\n    "keyColumn": "cmember_list_id",\r\n    "wildsearch": "true",\r\n    "reference": {\r\n        "referenceTable": " tbl_communities",\r\n        "referenceColumn": "cmember_community_id",\r\n        "referenceTableForiegnKey": "community_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Members list: ",\r\n    "detailHeaderColumns": [\r\n        "cmember_id"\r\n    ],\r\n    "orderBy": {\r\n        "cmember_list_id": "DESC"\r\n    },\r\n    "where": "cmember_status!=\'D\'",\r\n    "listColumns": [\r\n        "Image",\r\n        "cmember_id",\r\n        "Name",\r\n        "cmember_joined_on",\r\n        "cmember_type"\r\n    ],\r\n    "detailColumns": [\r\n        "cmember_list_id",\r\n        "Image",\r\n        "cmember_id",\r\n        "Name",\r\n        "cmember_joined_on",\r\n        "cmember_type"\r\n    ],\r\n    "columns": {\r\n        "cmember_list_id": {\r\n            "name": "ID",\r\n            "type": "hidden"\r\n        },\r\n        "cmember_id": {\r\n            "name": "Email",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_users",\r\n                "externalColumn": "user_id",\r\n                "externalShowColumn": "user_email"\r\n            }\r\n        },\r\n        "Name": {\r\n            "name": "Name",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getMemberName"\r\n        },\r\n        "Image": {\r\n            "name": "Profile Picture",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCommunityMemberImage"\r\n        },\r\n        "cmember_joined_on": {\r\n            "name": "Joined On",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "cmember_type": {\r\n            "name": "Member Type",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "A": "Owner",\r\n                    "U": "Member"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Member Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "A": "Owner",\r\n                    "U": "Member"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "relations": {\r\n        "business1": {\r\n            "name": "Business",\r\n            "section": "business",\r\n            "child_table": "tbl_businesses",\r\n            "parent_join_column": "cmember_id",\r\n            "child_join_column": "business_created_by"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all', 'admin', 'main', NULL),
	(72, 1, 'Group', 'bizcom', 'tbl_communities', '{\r\n	"keyColumn": "community_id",\r\n	"wildsearch": "true",\r\n	"detailHeaderColumnPrefix": "Group: ",\r\n	"detailHeaderColumns": [\r\n		"community_name"\r\n	],\r\n	"breadCrumbColumn": "community_name",\r\n	"handleFile": "true",\r\n	"orderBy": {\r\n		"community_id": "DESC"\r\n	},\r\n	"where": "community_status!=\'D\'",\r\n	"listColumns": [\r\n		"community_image_id",\r\n		"community_name",\r\n		"community_created_by",\r\n		"community_type",\r\n		"community_status"\r\n	],\r\n	"showColumns": [\r\n		"community_id",\r\n		"community_image_id",\r\n		"community_name",\r\n		"community_description",\r\n		"community_created_on",\r\n		"community_type"\r\n\r\n	],\r\n	"detailColumns": [\r\n		"community_id",\r\n		"community_image_id",\r\n		"community_name",\r\n		"community_created_by",\r\n		"community_created_on",\r\n		"community_description",\r\n		"community_type",\r\n		"community_status"\r\n	],\r\n	"columns": {\r\n		"community_id": {\r\n			"name": "ID",\r\n			"editoptions": {\r\n				"type": "hidden"\r\n			}\r\n		},\r\n		"community_image_id": {\r\n			"name": "Logo",\r\n			"editoptions": {\r\n				"type": "file",\r\n				"label": "Logo",\r\n				"class": "file",\r\n				"hint": "Ideal size 300 x 300. Allowed file types are jpg,jpeg,gif and png.",\r\n				"file_types": "gif,png,jpg,jpeg",\r\n				"validations": [\r\n					"file_type"\r\n				]\r\n			},\r\n			"external": "true",\r\n			"externalOptions": {\r\n				"externalTable": "tbl_files",\r\n				"externalColumn": "file_id",\r\n				"externalShowColumn": "file_id"\r\n			}\r\n		},\r\n		"community_name": {\r\n			"name": "Name",\r\n			"searchable": "true",\r\n			"sortable": "true",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "Name",\r\n				"class": "textbox",\r\n				"validations": [\r\n					"required"\r\n				]\r\n			}\r\n		},\r\n		"community_description": {\r\n			"name": "Description",\r\n			"editoptions": {\r\n				"type": "textarea",\r\n				"label": "Description",\r\n				"class": "textarea"\r\n			}\r\n		},\r\n		"community_created_by": {\r\n			"name": " Owner",\r\n			"sortable": "true",\r\n			"customColumn": "true",\r\n			"customaction": "Cmshelper::getCommunityOwner"\r\n		},\r\n		"community_type": {\r\n			"name": "Type",\r\n			"searchable": "true",\r\n			"sortable": "true",\r\n			"editoptions": {\r\n				"type": "select",\r\n				"source": {\r\n					"PUBLIC": "Public",\r\n					"PRIVATE": "Private"\r\n				},\r\n				"source_type": "array",\r\n				"label": "Type",\r\n				"class": "select",\r\n				"default": "PUBLIC",\r\n				"enumvalues": {\r\n					"PUBLIC": "Public",\r\n					"PRIVATE": "Private"\r\n				},\r\n				"validations": [\r\n					"required"\r\n				]\r\n			}\r\n		},\r\n		"community_status": {\r\n			"name": "Status",\r\n			"searchable": "true",\r\n			"sortable": "true",\r\n			"listoptions": {\r\n				"type": "button",\r\n				"customaction": "Cmshelper::changeCommunityStatus",\r\n				"enumvalues": {\r\n					"A": "Active",\r\n					"I": "Inactive"\r\n				},\r\n				"buttonColors": {\r\n					"A": "green",\r\n					"I": "red"\r\n				}\r\n			}\r\n		},\r\n		"community_created_on": {\r\n			"name": "Created On",\r\n			"sortable": "true",\r\n			"dbFormat": "timestamp",\r\n			"displayFormat": "m/d/Y"\r\n		}\r\n	},\r\n	"relations": {\r\n		"Group Members": {\r\n			"name": "Group Members",\r\n			"section": "bizcom_member",\r\n			"child_table": "tbl_community_member",\r\n			"parent_join_column": "community_id",\r\n			"child_join_column": "cmember_community_id",\r\n			"where": "child.cmember_status!=\'D\' "\r\n		}\r\n	},\r\n	"customActions": {\r\n		"afterAddRecord": "Communities::updateCommunityRegisterTime",\r\n		"afterEditRecord": "Communities::updateCommunityFile"\r\n	},\r\n	"opertations": [\r\n		"add",\r\n		"view",\r\n		"edit",\r\n		"customdelete"\r\n	],\r\n\r\n	"customDeleteOperation": "Cmshelper::deleteCommunity"\r\n}', '1', 4, 'all', 'admin', 'main', NULL),
	(77, 1, 'Group List', 'user_community', 'tbl_community_member', '{\r\n    "keyColumn": "cmember_list_id",\r\n    "wildsearch": "true",\r\n    "reference": {\r\n        "referenceTable": " tbl_users",\r\n        "referenceColumn": "cmember_id",\r\n        "referenceTableForiegnKey": "user_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Members list: ",\r\n    "detailHeaderColumns": [\r\n        "cmember_community_id"\r\n    ],\r\n    "orderBy": {\r\n        "cmember_list_id": "DESC"\r\n    },\r\n    "where": "cmember_status!=\'D\'",\r\n    "listColumns": [\r\n        "Image",\r\n        "cmember_community_id",\r\n        "cmember_joined_on",\r\n        "cmember_type"\r\n    ],\r\n    "detailColumns": [\r\n"cmember_list_id",\r\n        "Image",\r\n        "cmember_community_id",\r\n        "cmember_joined_on",\r\n        "cmember_type"\r\n    ],\r\n    "columns": {\r\n        "cmember_list_id": {\r\n            "name": "ID",\r\n            "type": "hidden"\r\n        },\r\n        "cmember_community_id": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_communities",\r\n                "externalColumn": "community_id",\r\n                "externalShowColumn": "community_name"\r\n            }\r\n        },\r\n        "Image": {\r\n            "name": "Logo",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCommunityImage"\r\n        },\r\n        "cmember_joined_on": {\r\n            "name": "Joined On",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "cmember_type": {\r\n            "name": "Member Type",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "A": "Owner",\r\n                    "U": "Member"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Member Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "A": "Owner",\r\n                    "U": "Member"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 2, 'all', 'admin', 'main', NULL),
	(78, 5, 'Manage Roles', 'manage_roles', 'cms_roles', '{"customCmsAction":"true","controller":"cms","method":"manageroles","module":"cms"}', '1', 1, 'all', 'admin', 'main', NULL),
	(90, 5, 'Manage Privileges ', 'cms_privileges', 'cms_privileges', '{"customCmsAction":"true","controller":"cms","method":"manageprivilege","module":"cms"}', '1', 1, 'all', 'admin', 'main', NULL),
	(91, 5, 'CMS users', 'cms_users', 'cms_users', '{"customCmsAction":"true","controller":"cms","method":"manageusers","module":"cms"}', '1', 3, 'all', 'admin', 'main', NULL),
	(94, 3, 'Banners', 'banners', 'tbl_banners', '{\r\n    "keyColumn": "banner_id",\r\n    "detailHeaderColumnPrefix": "Banner: ",\r\n    "detailHeaderColumns": [\r\n        "banner_title"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "banner_id": "DESC"\r\n    },\r\n    "where": "banner_status != \'D\'",\r\n    "listColumns": [\r\n        "banner_title",\r\n        "banner_image_id",\r\n        "banner_status"\r\n    ],\r\n    "showColumns": [\r\n        "banner_id",\r\n        "banner_title",\r\n        "banner_image_id",\r\n        "banner_description",\r\n        "banner_link",\r\n        "banner_link_text",\r\n        "banner_status"\r\n    ],\r\n    "detailColumns": [\r\n        "banner_id",\r\n        "banner_title",\r\n        "banner_image_id",\r\n        "banner_description",\r\n        "banner_link",\r\n        "banner_link_text",\r\n        "banner_status"\r\n    ],\r\n    "columns": {\r\n        "banner_id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "banner_title": {\r\n            "name": "Title",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n  "hint": "Title to be displayed on the banner"\r\n            }\r\n        },\r\n        "banner_link_text": {\r\n            "name": "Button Text",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Button Text",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "hint": "Text to be displayed in the button on the banner"\r\n            }\r\n        },\r\n        "banner_link": {\r\n            "name": "External Link",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "External Link",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                   \r\n                ],\r\n                "hint": "Page to go to on clicking the button in the banner"\r\n            }\r\n        },\r\n        "banner_image_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint": "Ideal size 560 x 446. Allowed file types are jpg,jpeg,gif and png. Image to be displayed on the banner.",\r\n"file_types":"gif,png,jpg,jpeg",\r\n"validations": [\r\n                    "file_type"\r\n                ]\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "banner_description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "hint": "Text to be displayed on the banner"\r\n            }\r\n        },\r\n        "banner_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeBannerStatus",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "A": "green",\r\n                    "I": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterEditRecord": "Cmshelper::updateBanner",\r\n        "afterAddRecord": "Cmshelper::updateBanner"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 2, 'all', 'admin', 'main', NULL),
	(93, 3, 'Categories', 'categories', 'tbl_categories', '{\r\n    "keyColumn": "category_id",\r\n    "wildsearch": "true",\r\n    "detailHeaderColumnPrefix": "Categories: ",\r\n    "detailHeaderColumns": [\r\n        "category_name"\r\n    ],\r\n    "orderBy": {\r\n        "category_name": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "category_name",\r\n        "category_status"\r\n    ],\r\n    "showColumns": [\r\n        "category_name"\r\n    ],\r\n    "detailColumns": [\r\n        "category_id",\r\n        "category_name",\r\n        "category_status"\r\n    ],\r\n    "columns": {\r\n        "category_id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "category_name": {\r\n            "name": "Category Name",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Category Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "category_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            \r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeCategoryStatus",\r\n                "enumvalues": {\r\n                    "A": "Active",\r\n                    "I": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "A": "green",\r\n                    "I": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::getCategoryAlias"\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 4, 'all', 'admin', 'main', NULL),
	(95, 1, 'Invitations Sent', 'bizcom_invitations', 'tbl_invitation', '{\r\n    "keyColumn": "invitation_id",\r\n    "wildsearch": "true",\r\n    "reference": {\r\n        "referenceTable": " tbl_communities",\r\n        "referenceColumn": "invitation_entity_id",\r\n        "referenceTableForiegnKey": "community_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Invitations sent: ",\r\n    "detailHeaderColumns": [\r\n        "invitation_entity_id"\r\n    ],\r\n    "orderBy": {\r\n        "invitation_id": "DESC"\r\n    },\r\n    "where": "invitation_entity = \'C\'",\r\n    "listColumns": [\r\n        "Name",\r\n        "invitation_sender_email",\r\n        "invitation_receiver_email",\r\n        "invitation_created_on",\r\n        "invitation_status"\r\n    ],\r\n    "detailColumns": [\r\n        "invitation_id",\r\n        "invitation_entity_id",\r\n        "Name",\r\n        "invitation_sender_email",\r\n        "invitation_receiver_email",\r\n        "invitation_created_on",\r\n        "invitation_status"\r\n    ],\r\n    "columns": {\r\n        "invitation_id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "invitation_entity_id": {\r\n            "name": "Community",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_communities",\r\n                "externalColumn": "community_id",\r\n                "externalShowColumn": "community_name"\r\n            },\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "Name": {\r\n            "name": "Name",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getInvitationSenderName"\r\n        },\r\n        "invitation_sender_email": {\r\n            "name": "Sender Email",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "invitation_receiver_email": {\r\n            "name": "Receiver Email",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "invitation_created_on": {\r\n            "name": "Sent On",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "dbFormat": "timestamp",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "invitation_status": {\r\n            "name": "Invitation Status",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "P": "Pending",\r\n                    "A": "Accepted",\r\n                    "R": "Rejected",\r\n                    "DJ": "Disjoined"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Invitation Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "P": "Pending",\r\n                    "A": "Accepted",\r\n                    "R": "Rejected",\r\n                    "DJ": "Disjoined"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all', 'admin', 'main', NULL),
	(96, 1, 'Reconcile Charity', 'reconcilecharity', 'tbl_charity_reconcilation_details', '{\r\n    "keyColumn": "reconcilation_id",\r\n    "wildsearch": "true",\r\n    "detailHeaderColumnPrefix": "Reconcile Charity: ",\r\n    "detailHeaderColumns": [\r\n        "user_email"\r\n    ],\r\n   \r\n    "breadCrumbColumn": "username",\r\n    "orderBy": {\r\n        "campaign_name": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "campaign_name",\r\n        "charity_organisation_name",\r\n        "user_name",\r\n        "reconcilation_amount",\r\n        "reconcilation_invoice_number",\r\n        "reconcilation_submit_date",\r\n        "reconcilation_settle_status"\r\n    ],\r\n    "showColumns": [\r\n        "reconcilation_id",\r\n        "campaign_name",\r\n        "charity_organisation_name",\r\n        "user_name",\r\n        "reconcilation_amount",\r\n        "reconcilation_invoice_number",\r\n        "reconcilation_submit_date",\r\n        "reconcilation_settle_status"\r\n    ],\r\n    "detailColumns": [\r\n        "campaign_name",\r\n        "charity_organisation_name",\r\n        "user_name",\r\n        "reconcilation_amount",\r\n        "reconcilation_invoice_number",\r\n        "reconcilation_submit_date",\r\n        "reconcilation_settle_status"\r\n    ],\r\n    "columns": {\r\n        "campaign_name": {\r\n            "name": "Campaign Name",\r\n            "searchable": "true",\r\n            "sortable": "true"\r\n        },\r\n        "charity_organisation_name": {\r\n            "name": "Charity Organisation",\r\n            "searchable": "true",\r\n            "sortable": "true"\r\n        },\r\n        "user_name": {\r\n            "name": "User Name",\r\n            "searchable": "true",\r\n            "sortable": "true"\r\n        },\r\n        "reconcilation_amount": {\r\n            "name": "Amount(GBP)",\r\n            "searchable": "true",\r\n            "sortable": "true"\r\n        },\r\n        "reconcilation_invoice_number": {\r\n            "name": "Invoice Number",\r\n            "searchable": "true",\r\n            "sortable": "true"\r\n        },\r\n        "reconcilation_submit_date": {\r\n            "name": "Date",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "reconcilation_settle_status": {\r\n            "name": "Reconcile Status",\r\n	"sortable": "true",\r\n            "searchable": "true",\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeReconcileStatus",\r\n                "enumvalues": {\r\n                    "Y": "Complete",\r\n                    "N": "Incomplete"\r\n                },\r\n                "buttonColors": {\r\n                    "Y": "green",\r\n                    "N": "red"\r\n                }\r\n            }\r\n        }\r\n    }\r\n}', '0', 6, 'all', 'admin', 'main', NULL),
	(97, 1, 'Announcements', 'announcements', 'tbl_admin_announcements', '{\r\n	"keyColumn": "admin_announcement_id",\r\n	"wildsearch": "true",\r\n	"detailHeaderColumnPrefix": "Communities: ",\r\n	"detailHeaderColumns": ["admin_announcement_title"],\r\n	"breadCrumbColumn": "admin_announcement_title",\r\n	"handleFile": "true",\r\n	"orderBy": {\r\n		"admin_announcement_id": "DESC"\r\n	},\r\n	"where": "admin_announcement_status!=\'D\'",\r\n	"listColumns": ["admin_announcement_title", "admin_announcement_content", "admin_announcement_type", "admin_announcement_created_date", "admin_announcement_expiry_date", "admin_announcement_status", "admin_announcement_image_id"],\r\n	"showColumns": ["admin_announcement_id", "admin_announcement_title", "admin_announcement_content", "admin_announcement_type", "admin_announcement_created_date", "admin_announcement_expiry_date", "admin_announcement_status", "admin_announcement_image_id", "admin_announcement_description"],\r\n	"detailColumns": ["admin_announcement_id", "admin_announcement_title", "admin_announcement_content", "admin_announcement_type", "admin_announcement_created_date", "admin_announcement_expiry_date", "admin_announcement_status", "admin_announcement_image_id", "admin_announcement_description"],\r\n	"columns": {\r\n		"admin_announcement_id": {\r\n			"name": "ID",\r\n			"editoptions": {\r\n				"type": "hidden"\r\n			}\r\n		},\r\n		"admin_announcement_image_id": {\r\n			"name": "Announcement Picture",\r\n			"editoptions": {\r\n				"type": "file",\r\n				"label": "Announcement Picture",\r\n				"class": "file",\r\n				"hint": "Ideal size 300 x 300. Allowed file types are jpg,jpeg,gif and png.",\r\n				"file_types": "gif,png,jpg,jpeg",\r\n				"validations": [\r\n					"file_type"\r\n				]\r\n\r\n			},\r\n			"external": "true",\r\n			"externalOptions": {\r\n				"externalTable": "tbl_files",\r\n				"externalColumn": "file_id",\r\n				"externalShowColumn": "file_id"\r\n			}\r\n		},\r\n		"admin_announcement_title": {\r\n			"name": "Announcement Title",\r\n			"searchable": "true",\r\n			"sortable": "true",\r\n			"editoptions": {\r\n				"type": "textbox",\r\n				"label": "Announcement Title",\r\n				"class": "textbox",\r\n				"validations": ["required"]\r\n			}\r\n		},\r\n		"admin_announcement_content": {\r\n			"name": "Content",\r\n			"editoptions": {\r\n				"type": "textarea",\r\n				"label": "Description",\r\n				"class": "textarea"\r\n			}\r\n		},\r\n		"admin_announcement_type": {\r\n			"name": "Display Type",\r\n			"searchable": "true",\r\n			"sortable": "true",\r\n			"editoptions": {\r\n				"type": "select",\r\n				"source": {\r\n					"A": "All Users",\r\n					"N": "New Users"\r\n				},\r\n				"source_type": "array",\r\n				"label": "Display Type",\r\n				"class": "select",\r\n				"default": "A",\r\n				"enumvalues": {\r\n					"A": "All Users",\r\n					"N": "New Users"\r\n				},\r\n				"validations": ["required"]\r\n			}\r\n		},\r\n		"admin_announcement_status": {\r\n			"name": "Status",\r\n			"searchable": "true",\r\n			"sortable": "true",\r\n			"editoptions": {\r\n				"type": "select",\r\n				"source": {\r\n					"A": "Active",\r\n					"I": "Inactive"\r\n				},\r\n				"source_type": "array",\r\n				"label": "Status",\r\n				"class": "select",\r\n				"default": "A",\r\n				"enumvalues": {\r\n					"A": "Active",\r\n					"I": "Inactive",\r\n					"D": "Delete"\r\n				},\r\n				"validations": ["required"]\r\n			}\r\n		},\r\n		"admin_announcement_created_date": {\r\n			"name": "Created On",\r\n			"sortable": "true",\r\n			"dbFormat": "date",\r\n			"displayFormat": "m/d/Y"\r\n		},\r\n		"admin_announcement_expiry_date": {\r\n			"name": "Expired On",\r\n			"sortable": "true",\r\n			"searchable": "true",\r\n			"dbFormat": "date",\r\n			"displayFormat": "m/d/Y",\r\n			"editoptions": {\r\n				"type": "datepicker",\r\n				"label": "Expiry Date",\r\n				"class": "datepicker",\r\n				"validations": ["required"]\r\n			}\r\n		},\r\n		"admin_announcement_description": {\r\n			"name": "Admin Announcemnet Description",\r\n			"editoptions": {\r\n				"type": "htmlEditor",\r\n				"label": "Admin Announcemnet Description",\r\n				"class": "textarea",\r\n				"editorType": "ckeditor",\r\n				"validations": [\r\n					"required"\r\n				]\r\n			}\r\n		}\r\n	},\r\n	"customActions": {\r\n		"afterAddRecord": "User::updateAdminFile",\r\n		"afterEditRecord": "User::updateAdminFile"\r\n	},\r\n\r\n	"opertations": ["add", "view", "edit", "delete"]\r\n}', '0', 7, 'all', 'admin', 'main', NULL);

