<?php
/**
 * Mubashir Ali
 * saad_ali6@yahoo.com
 */
    class fedexRates extends shippingAPI
    {
        public function __construct()
        {
            parent::__construct();
        }
         
        
        
        function addShippingChargesPayment()
    {
        $shippingChargesPayment = array
        (
            'PaymentType' => 'SENDER', // valid values RECIPIENT, SENDER and THIRD_PARTY
            'Payor' => array
                (
                    'AccountNumber' => $this->bill_account,
                    'CountryCode' => 'US')
        );

        return $shippingChargesPayment;
    }/*end of addShippingChargesPayment()*/
    
    
    function addSpecialServices() 
    {
        $specialServices = array(
            'SpecialServiceTypes' => array('COD'),
            'CodDetail' => array(
                'CodCollectionAmount' => array('Currency' => 'USD', 'Amount' => 150),
                'CollectionType' => 'ANY')// ANY, GUARANTEED_FUNDS
        );
        return $specialServices;
    }/*end of addSpecialServices()*/
    
    
    public function requestType($type)
    {
        switch($type)
        {
            case "address":
                $this->wsdl_path = "AddressValidationService_v2.wsdl";
                $this->Major = 10;
                break;
            case "package":
                $this->wsdl_path = "PackageMovementInformationService_v5.wsdl";
                $this->Major = 10;
                break;
            case "close":
                $this->wsdl_path = "CloseService_v2.wsdl";
                $this->Major = 10;
                break;
            case "locator":
                $this->wsdl_path = "LocatorService_v2.wsdl";
                $this->Major = 10;
                break;
            case "pickup":
                $this->wsdl_path = "PickupService_v3.wsdl";
                $this->ServiceId = "disp";
                $this->Major = 3;
                break;
            case "rate":
                $this->wsdl_path = "RateService_v13.wsdl";
                $this->ServiceId = "crs";
                $this->Major = 13;
                break;
            case "return":
                $this->wsdl_path = "ReturnTagService_v1.wsdl";
                $this->Major = 10;
                break;
            case "shipment":
                $this->wsdl_path = "ShipService_v10.wsdl";
                $this->ServiceId = "ship";
                $this->Major = 10;
                break;
            case "track":
                $this->wsdl_path = "TrackService_v5.wsdl";
                $this->ServiceId = "trck";
                $this->Major = 5;
                break;
            case "upload":
                $this->wsdl_path = "UploadDocumentService_v1.wsdl";
                $this->Major = 10;
                break;
            default:
                $this->wsdl_path = "";
                $this->Major = 10;
                break;
        }
    }/*end of requestType()*/
    
    
    
    public function getServiceTypeName($service_type)
    {
        $s_type = "";
        if(trim($service_type) == "")
            return false;
        switch($service_type)
        {
            case "INTERNATIONAL_ECONOMY":
                $s_type = "International Economy";
                break;
            case "INTERNATIONAL_PRIORITY":
                $s_type = "International Priority";
                break;
            case "EUROPE_FIRST_INTERNATIONAL_PRIORITY":
                $s_type = "International Priority (Europe First)";
                break;
            case "INTERNATIONAL_FIRST":
                $s_type = "International First";
                break;
            
            case "STANDARD_OVERNIGHT":
                $s_type = "FedEx Standard Overnight";
                break;
             case "FEDEX_GROUND":
                $s_type = "FedEx Ground";
                break;
             case "PRIORITY_OVERNIGHT":
                $s_type = "FedEx Priority Overnight";
                break;
            case "FEDEX2DAY":
                $s_type = "FedEx 2 Day";
                break;
            case "FIRST_OVERNIGHT":
                $s_type = "FedEx First Overnight";
                break;
            
            
            default:
                $s_type = "";
        }
        return $s_type;
    }/*end of getServiceTypeName()*/
  
    
    
    public function rateRequest($aryRecipient,$aryShipper, $aryOrder, $aryPackage='')
    {            

        $request['WebAuthenticationDetail'] = $this->getAuthenticationDetail();  

        $request['ClientDetail'] = $this->getClientDetail();

        $request['TransactionDetail'] = array('CustomerTransactionId' => ' *** Rate Request v13 using PHP ***');
        $request['Version'] = $this->getServiceVersion();
        $request['ReturnTransitAndCommit'] = true;

        $request['RequestedShipment']['DropoffType'] = $aryOrder['DropoffType'];
        $request['RequestedShipment']['ShipTimestamp'] = @date("c",time());
        $request['RequestedShipment']['ServiceType'] = $aryOrder['ServiceType'];
        $request['RequestedShipment']['PackagingType'] = $aryOrder['PackageType'];

        $request['International']['TermsOfSaleType'] = $aryOrder['TermsOfSaleType'];

        //$request['RequestedShipment']['TotalInsuredValue'] = array('Ammount'=>100,'Currency'=>'USD');//No Need

        //$request['RequestedShipment']['Shipper'] = $this->addShipper();
        //$request['RequestedShipment']['Shipper']   =  $this->addShipper();
        $request['RequestedShipment']['Shipper']   =  $aryShipper;
        $request['RequestedShipment']['Recipient'] =  $aryRecipient;
        //$request['RequestedShipment']['ShippingChargesPayment'] = $this->addShippingChargesPayment(); //No Need
        $request['RequestedShipment']['RateRequestTypes'] = 'ACCOUNT'; 
        $request['RequestedShipment']['RateRequestTypes'] = 'LIST'; 
        $request['RequestedShipment']['PackageCount'] = $aryOrder['TotalPackages'];
        $request['RequestedShipment']['RequestedPackageLineItems'] = $aryPackage;
       
        return $request;

    }/*end of rateRequest()*/


    public function getRates($request,$client)
    {
        
        
        try 
        {
            if($this->setEndpoint('changeEndpoint'))
            {
                $newLocation = $client->__setLocation(setEndpoint('endpoint'));
            }

            $response = $client->getRates($request);
          

            $rateService = new stdClass();
            
        if(!empty($response)){    

            if ($response -> HighestSeverity != 'FAILURE' && $response -> HighestSeverity != 'ERROR')
            {
                            $success = $this->showResponseMessage($response);

                            $rateReply = $response ->RateReplyDetails;

                            $rateService->ServiceType = $rateReply ->ServiceType;
                            
                            $rateService->ServiceName = $this->getServiceTypeName($rateReply ->ServiceType);

                            $rateService->amount      = number_format($rateReply->RatedShipmentDetails[0]->ShipmentRateDetail->TotalNetCharge->Amount,2,".",",");

                             if(array_key_exists('DeliveryTimestamp',$rateReply))
                            {
                                 $rateService->DeliveryTimestamp = $rateReply->DeliveryTimestamp;
                            }
                             if(array_key_exists('TransitTime',$rateReply))
                            {

                                $rateService->TransitTime   = $rateReply->TransitTime;
                            }

              }
        
                    else
                    {
                                        $error = $this->showResponseMessage($response);
                                        $rateService->error = $error;
                    }
        }
                        else
                        {
                            $error = "Fedex Service Not Availbale.";
                            $rateService->error = $error;
                        }

                   return      $rateService;

      } 
                    catch (SoapFault $exception) 
                    {
                         $this->requestError($exception, $client);
                    }
    }/*end of getRates()*/

    }
?>