RENAME TABLE `multicart_products` TO `multicart_products_backup`; 

DROP TABLE IF EXISTS `multicart_products`;
CREATE TABLE IF NOT EXISTS `multicart_products` (
  `product_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_name` varchar(255) DEFAULT NULL,
  `product_code` varchar(20) DEFAULT NULL,
  `product_description` text,
  `product_price` double DEFAULT NULL,
  `product_category` int(11) DEFAULT NULL,
  `product_artist_id` int(11) DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `deleted` char(1) DEFAULT 'N',
  `featured` char(1) DEFAULT 'N',
  `vdigital_product` char(1) NOT NULL DEFAULT '',
  `vapproved` char(2) NOT NULL DEFAULT 'N',
  `payment_status` enum('PENDING','COMPLETED') NOT NULL DEFAULT 'PENDING',
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `multicart_admin_menu`;
CREATE TABLE IF NOT EXISTS `multicart_admin_menu` (
  `menu_id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(200) NOT NULL default '',
  `link` varchar(200) NOT NULL default '',
  `parent_id` smallint(4) NOT NULL default '0',
  `display_order` tinyint(4) NOT NULL default '0',
  `divname` varchar(200) NOT NULL default '',
  `status` enum('ACTIVE','INACTIVE') NOT NULL default 'ACTIVE',
  PRIMARY KEY  (`menu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;

CREATE TABLE IF NOT EXISTS `multicart_metatags` (
  `nId` int(11) NOT NULL auto_increment,
  `vTitle` varchar(200) default NULL,
  `vKeywords` text,
  `vDescription` text,
  `vPageName` varchar(20) default NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;


ALTER TABLE `multicart_artists` 
	CHANGE `sellerPlanID` `sellerPlanID` int(11)   NOT NULL DEFAULT '0' after `additionalflatrate`, 
	CHANGE `plan_expired` `plan_expired` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' COMMENT 'Whether \r\n\r\nplan expired or not' after `paypalemail`;

ALTER TABLE `multicart_cart` 
	ADD COLUMN `product_option_id` bigint(20)   NOT NULL after `product_id`, 
	CHANGE `quantity` `quantity` int(11)   NULL after `product_option_id`, 
	CHANGE `status` `status` tinyint(4)   NULL after `quantity`, 
	CHANGE `datetime_added` `datetime_added` varchar(20)  COLLATE latin1_swedish_ci NULL after `status`;


ALTER TABLE `multicart_categories` 
	ADD COLUMN `avatar` varchar(250)  COLLATE latin1_swedish_ci NOT NULL after `gift_certificate_flag`;

CREATE TABLE IF NOT EXISTS `multicart_category_options`(
	`category_option_id` bigint(20) NOT NULL  auto_increment , 
	`category_id` bigint(20) NOT NULL  , 
	`option_id` bigint(20) NOT NULL  , 
	PRIMARY KEY (`category_option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';



 CREATE TABLE IF NOT EXISTS multicart_couponCode (
  ccID int(11) NOT NULL auto_increment,
  ccStartDate date NOT NULL default '0000-00-00',
  ccEndDate date NOT NULL default '0000-00-00',
  ccCode varchar(50) NOT NULL default '',
  ccDescription text NOT NULL,
  ccDiscount int(11) NOT NULL default '0',
  subscriptionStatus char(1) NOT NULL default '',
  ccStatus char(1) NOT NULL default '',
  PRIMARY KEY  (ccID),
  UNIQUE KEY ccCode (ccCode)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS multicart_couponcode (
  ccID int(11) NOT NULL auto_increment,
  ccStartDate date NOT NULL default '0000-00-00',
  ccEndDate date NOT NULL default '0000-00-00',
  ccCode varchar(50) NOT NULL default '',
  ccDescription text NOT NULL,
  ccDiscount int(11) NOT NULL default '0',
  subscriptionStatus char(1) NOT NULL default '',
  ccStatus char(1) NOT NULL default '',
  PRIMARY KEY  (ccID),
  UNIQUE KEY ccCode (ccCode)
) ENGINE=MyISAM;


CREATE TABLE IF NOT EXISTS `multicart_email_templates_back`(
	`nemail_id` int(11) NOT NULL  auto_increment , 
	`vtemplate_name` varchar(100) COLLATE latin1_swedish_ci NOT NULL  DEFAULT '' , 
	`vtemplate_title` varchar(100) COLLATE latin1_swedish_ci NOT NULL  DEFAULT '' , 
	`vemail_body` text COLLATE latin1_swedish_ci NOT NULL  , 
	`vreplaceable_variables` text COLLATE latin1_swedish_ci NOT NULL  , 
	`vtemplate_flag` char(1) COLLATE latin1_swedish_ci NULL  DEFAULT '' , 
	PRIMARY KEY (`nemail_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_flat_rate_default`(
	`flat_rate_default_id` bigint(20) NOT NULL  auto_increment , 
	`flat_rate_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`first_Item_charge` float NOT NULL  , 
	`additional_Item_charge` float NOT NULL  , 
	PRIMARY KEY (`flat_rate_default_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_flat_rate_seller`(
	`flat_rate_seller_id` bigint(20) NOT NULL  auto_increment , 
	`flat_rate_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`first_Item_charge` float NOT NULL  , 
	`additional_Item_charge` float NOT NULL  , 
	`seller_id` bigint(20) NOT NULL  , 
	PRIMARY KEY (`flat_rate_seller_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_help`(
	`hid` int(11) NOT NULL  auto_increment , 
	`hcid` int(11) NULL  , 
	`htitle` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	`hdescription` text COLLATE latin1_swedish_ci NULL  , 
	`hposition` int(11) NULL  , 
	`active` enum('0','1') COLLATE latin1_swedish_ci NULL  , 
	`himage` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	PRIMARY KEY (`hid`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_helpcategory`(
	`hcid` int(11) NOT NULL  auto_increment , 
	`htype` varchar(10) COLLATE latin1_swedish_ci NULL  , 
	`hctitle` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	`hcposition` int(11) NULL  , 
	`active` enum('0','1') COLLATE latin1_swedish_ci NULL  , 
	PRIMARY KEY (`hcid`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_homepagebanners`(
	`homepage_banner_id` bigint(20) NOT NULL  auto_increment , 
	`image` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`deleted` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'N' , 
	`created_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	PRIMARY KEY (`homepage_banner_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_message_to_seller`(
	`message_to_seller_id` bigint(20) NOT NULL  auto_increment , 
	`artist_id` int(11) NOT NULL  , 
	`name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`email` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`subject` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`message` text COLLATE latin1_swedish_ci NOT NULL  , 
	`created_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	`read` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'N' , 
	PRIMARY KEY (`message_to_seller_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';



CREATE TABLE `multicart_options`(
	`option_id` bigint(20) NOT NULL  auto_increment , 
	`option_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_order_details` 
	ADD COLUMN `product_option_id` int(11)   NOT NULL after `product_id`, 
	CHANGE `product_name` `product_name` varchar(200)  COLLATE latin1_swedish_ci NULL after `product_option_id`, 
	CHANGE `product_code` `product_code` varchar(20)  COLLATE latin1_swedish_ci NULL after `product_name`, 
	CHANGE `product_price` `product_price` double   NULL after `product_code`, 
	ADD COLUMN `product_tax` float   NOT NULL after `product_price`, 
	CHANGE `product_quantity` `product_quantity` int(11)   NULL after `product_tax`, 
	CHANGE `artist_id` `artist_id` bigint(20)   NULL after `product_quantity`, 
	CHANGE `item_status` `item_status` smallint(6)   NULL after `artist_id`, 
	CHANGE `artist_payment_status` `artist_payment_status` smallint(6)   NULL after `item_status`, 
	CHANGE `artist_payment_id` `artist_payment_id` bigint(20)   NULL after `artist_payment_status`, 
	CHANGE `user_refund_id` `user_refund_id` bigint(20)   NULL DEFAULT '0' after `artist_payment_id`, 
	CHANGE `product_discount` `product_discount` int(11)   NULL DEFAULT '0' after `user_refund_id`, 
	CHANGE `item_delivery_date` `item_delivery_date` datetime   NOT NULL after `product_discount`, 
	ADD COLUMN `product_commission_amount` float   NOT NULL DEFAULT '0' after `item_delivery_date`;

ALTER TABLE `multicart_orders` 
	CHANGE `vgiftcertificate_code` `vgiftcertificate_code` varchar(255)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `transaction_id`, 
	CHANGE `nused_gift_amount` `nused_gift_amount` double   NOT NULL DEFAULT '0' after `vgiftcertificate_code`, 
	CHANGE `namount_paid` `namount_paid` double   NOT NULL DEFAULT '0' after `nused_gift_amount`, 
	ADD COLUMN `buyer_comments` text  COLLATE latin1_swedish_ci NOT NULL after `namount_paid`;

CREATE TABLE `multicart_product_impression`(
	`product_impression_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`ip` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`visited_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	PRIMARY KEY (`product_impression_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_listing_fee_payment`(
	`product_listing_fee_payment_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`total_amount` int(11) NOT NULL  , 
	`amount_paid` int(11) NOT NULL  , 
	`payment_method` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`payment_date` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	`payment_status` enum('PENDING','COMPLETED') COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`product_listing_fee_payment_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_option_values`(
	`product_option_value_id` bigint(20) NOT NULL  auto_increment , 
	`product_option_id` bigint(20) NOT NULL  , 
	`option_id` bigint(20) NOT NULL  , 
	`value` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`product_option_value_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_options`(
	`product_option_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`additional_price` float NOT NULL  , 
	`image_small` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`image_big` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`product_stock` int(11) NOT NULL  , 
	`reorder_level` int(11) NOT NULL  , 
	`product_shipping_weight` float NOT NULL  , 
	`default_option` enum('YES','NO') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'YES' , 
	`discount` float NOT NULL  , 
	`discount_description` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`product_width` int(11) NOT NULL  , 
	`product_height` int(11) NOT NULL  , 
	`product_length` int(11) NOT NULL  , 
	PRIMARY KEY (`product_option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_settings` 
	CHANGE `vReview` `vReview` varchar(9)  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'automatic' after `site_logo`, 
	ADD COLUMN `enable_multicurrency` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `site_logo`, 
	ADD COLUMN `slideshow_delay` int(5)   NOT NULL after `enable_multicurrency`, 
	ADD COLUMN `enable_affiliates` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'Y' after `slideshow_delay`, 
	ADD COLUMN `more_image_limit` int(11)   NOT NULL after `enable_affiliates`, 
	ADD COLUMN `vyourpay_userid` varchar(100)  COLLATE latin1_swedish_ci NOT NULL after `more_image_limit`, 
	ADD COLUMN `paypal_api_username` varchar(200)  COLLATE latin1_swedish_ci NOT NULL after `vyourpay_userid`, 
	ADD COLUMN `paypal_api_password` varchar(200)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_username`, 
	ADD COLUMN `paypal_api_signature` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_password`, 
	ADD COLUMN `paypal_application_app_id` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_signature`, 
	ADD COLUMN `product_listing_fee` int(11)   NOT NULL after `paypal_application_app_id`, 
	ADD COLUMN `enable_commentbox` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `product_listing_fee`, 
	ADD COLUMN `vbluepay_enable` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `enable_commentbox`, 
	ADD COLUMN `bluepay_accountid` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `vbluepay_enable`, 
	ADD COLUMN `bluepay_secretkey` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `bluepay_accountid`, 
	ADD COLUMN `bluepay_test_mode` enum('TEST','LIVE')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'TEST' after `bluepay_secretkey`;

ALTER TABLE `multicart_shipping_details` 
	ADD COLUMN `nproduct_option_id` int(11)   NOT NULL after `nshp_productid`, 
	ADD COLUMN `nshp_productname` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `nproduct_option_id`, 
	CHANGE `vshipping_name` `vshipping_name` varchar(250)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `nshp_productname`, 
	CHANGE `nshipping_cost` `nshipping_cost` float   NOT NULL DEFAULT '0' after `vshipping_name`, 
	CHANGE `nshipping_weight` `nshipping_weight` int(11)   NOT NULL DEFAULT '0' after `nshipping_cost`, 
	CHANGE `vshipping_currency` `vshipping_currency` varchar(10)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `nshipping_weight`, 
	CHANGE `dshipped_date` `dshipped_date` datetime   NOT NULL DEFAULT '0000-00-00 00:00:00' after `vshipping_currency`, 
	CHANGE `nshp_status` `nshp_status` char(1)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `dshipped_date`, 
	CHANGE `user_id` `user_id` bigint(11)   NOT NULL DEFAULT '0' after `nshp_status`;

CREATE TABLE `multicart_social_media`(
	`social_media_id` int(11) NOT NULL  auto_increment , 
	`name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`title` varchar(250) COLLATE latin1_swedish_ci NOT NULL , 
	`link` text COLLATE latin1_swedish_ci NOT NULL  , 
	`logo` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`active` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'Y' , 
	PRIMARY KEY (`social_media_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';

ALTER TABLE `multicart_artist_payments` ADD `seller_order_total_amount` DOUBLE NOT NULL DEFAULT '0' AFTER `commission_percentage` ,ADD `admin_commision_amount` DOUBLE NOT NULL DEFAULT '0' AFTER `seller_order_total_amount` ;

ALTER TABLE `multicart_orders` ADD `payment_completed_status` ENUM( 'Y', 'N' ) NOT NULL DEFAULT 'N';

ALTER TABLE `multicart_artists` ADD INDEX `seller_index` ( `vapproved` , `deleted` );

ALTER TABLE `multicart_artists` ADD INDEX `date_register` ( `date_registered` );

ALTER TABLE multicart_product_options  ADD INDEX `defaultoption` ( `product_id` , `default_option` );

ALTER TABLE `multicart_products` ADD INDEX `vapproved` (`vapproved`);

ALTER TABLE `multicart_products` ADD INDEX `date_added` (`date_added`);

ALTER TABLE `multicart_products` ADD INDEX `deleted` (`deleted`);

ALTER TABLE `multicart_product_impression` ADD INDEX `product_id` (`product_id`) ;

ALTER TABLE `multicart_orders` ADD INDEX `paymentstatus` ( `vpayment_status` );

ALTER TABLE `multicart_artist_payments` ADD INDEX ( `order_id` );

ALTER TABLE `multicart_artist_payments` ADD INDEX ( `payment_status`);

ALTER TABLE `multicart_shipping_details` ADD INDEX ( `norder_id`);

ALTER TABLE `multicart_fedexsettings`
	ADD COLUMN `FedexPassword` VARCHAR(50) NULL DEFAULT NULL AFTER `FedexCurrency`,
	ADD COLUMN `FedexKey` VARCHAR(50) NULL DEFAULT NULL AFTER `FedexPassword`;