<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2010 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
class FedexComponent extends Object{
	var $components = array('Xmlparser', 'Fedexprice','Fedexerror');
	//var $server = "https://gatewaybeta.fedex.com/GatewayDC";
    //var $server = "https://wsbeta.fedex.com:443/web-services";
    var $server = "http://fedex.com/ws/track/v9";
    var $accountNumber;
    var $meterNumber;
    var $carrierCode = "FDXG";
    var $dropoffType = "REGULARPICKUP";
    var $service;
    var $serviceName;
    var $packaging = "YOURPACKAGING";
    var $weightUnits = "LBS";
    var $weight;
    // Origin Address
    var $originStateOrProvinceCode;
    var $originPostalCode;
    var $originCountryCode;
    // Destination Address
    var $destStateOrProvinceCode;
    var $destPostalCode;
    var $destCountryCode;
    var $payorType = "SENDER";
    
    
    // Functions    
    function setServer($server) {
        $this->server = $server;
    }

    function setAccountNumber($accountNumber) {
        $this->accountNumber = $accountNumber;
    }

    function setMeterNumber($meterNumber) {
        $this->meterNumber = $meterNumber;
    }

    function setCarrierCode($carrierCode) {
        $this->carrierCode = $carrierCode;
    }
    
    function setDropoffType($dropoffType) {
        $this->dropoffType = $dropoffType;
    }

    function setService($service, $name) {
        $this->service = $service;
        $this->serviceName = $name;
    }

    function setPackaging($packaging) {
        $this->packaging = $packaging;
    }
    
    function setWeightUnits($units) {
        $this->weightUnits = $units;
    }
    
    function setWeight($weight) {
        $this->weight = $weight;
    }
    
    function setOriginStateOrProvinceCode($code) {
        $this->originStateOrProvinceCode = $code;
    }
    
    function setOriginPostalCode($code) {
        $this->originPostalCode = $code;
    }
    
    function setOriginCountryCode($code) {
        $this->originCountryCode = $code;
    }
    
    function setDestStateOrProvinceCode($code) {
        $this->destStateOrProvinceCode = $code;
    }
    
    function setDestPostalCode($code) {
        $this->destPostalCode = $code;
    }
    
    function setDestCountryCode($code) {
        $this->destCountryCode = $code;
    }
    
    function setPayorType($type) {
        $this->payorType = $type;
    }
    
    function getPrice() {
        
        /*$str = '<?xml version="1.0" encoding="UTF-8" ?>';
        $str .= '    <FDXRateRequest xmlns:api="http://www.fedex.com/fsmapi" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="FDXRateRequest.xsd">';
        $str .= '        <RequestHeader>';
        $str .= '            <CustomerTransactionIdentifier>Express Rate</CustomerTransactionIdentifier>';
        $str .= '            <AccountNumber>'.$this->accountNumber.'</AccountNumber>';
        $str .= '            <MeterNumber>'.$this->meterNumber.'</MeterNumber>';
        $str .= '            <CarrierCode>'.$this->carrierCode.'</CarrierCode>';
        $str .= '        </RequestHeader>';
        $str .= '        <DropoffType>'.$this->dropoffType.'</DropoffType>';
        $str .= '        <Service>'.$this->service.'</Service>';
        $str .= '        <Packaging>'.$this->packaging.'</Packaging>';
        $str .= '        <WeightUnits>'.$this->weightUnits.'</WeightUnits>';
        $str .= '        <Weight>'.number_format($this->weight, 1, '.', '').'</Weight>';
        $str .= '        <OriginAddress>';
        $str .= '            <StateOrProvinceCode>'.$this->originStateOrProvinceCode.'</StateOrProvinceCode>';
        $str .= '            <PostalCode>'.$this->originPostalCode.'</PostalCode>';
        $str .= '            <CountryCode>'.$this->originCountryCode.'</CountryCode>';
        $str .= '        </OriginAddress>';
        $str .= '        <DestinationAddress>';
        $str .= '            <StateOrProvinceCode>'.$this->destStateOrProvinceCode.'</StateOrProvinceCode>';
        $str .= '            <PostalCode>'.$this->destPostalCode.'</PostalCode>';
        $str .= '            <CountryCode>'.$this->destCountryCode.'</CountryCode>';
        $str .= '        </DestinationAddress>';
        $str .= '        <Payment>';
        $str .= '            <PayorType>'.$this->payorType.'</PayorType>';
        $str .= '        </Payment>';
        $str .= '        <PackageCount>'.ceil(bcdiv(number_format($this->weight, 1, '.', ''), '150', 3)).'</PackageCount>';
        $str .= '    </FDXRateRequest>';*/

        $str = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
                    xmlns:v9="http://fedex.com/ws/track/v9"> 
                     <soapenv:Header/> 
                     <soapenv:Body> 
                     <v9:TrackRequest> 
                     <v9:WebAuthenticationDetail> 
                     <v9:UserCredential> 
                     <v9:Key>xxxxxx</v9:Key> 
                     <v9:Password/> 
                     </v9:UserCredential> 
                     </v9:WebAuthenticationDetail> 
                     <v9:ClientDetail> 
                     <v9:AccountNumber>'.$this->accountNumber.'</v9:AccountNumber> 
                     <v9:MeterNumber>'.$this->meterNumber.'</v9:MeterNumber> 
                     <v9:Localization> 
                     <v9:LanguageCode>EN</v9:LanguageCode> 
                     <v9:LocaleCode>US</v9:LocaleCode> 
                     </v9:Localization> 
                     </v9:ClientDetail> 
                     <v9:TransactionDetail> 
                     <v9:CustomerTransactionId>Track By Number_v9</v9:CustomerTransactionId> 
                     <v9:Localization> 
                     <v9:LanguageCode>EN</v9:LanguageCode> 
                     <v9:LocaleCode>US</v9:LocaleCode> 
                     </v9:Localization> 
                     </v9:TransactionDetail> 
                     <v9:Version> 
                     <v9:ServiceId>trck</v9:ServiceId> 
                     <v9:Major>9</v9:Major> 
                     <v9:Intermediate>1</v9:Intermediate> 
                     <v9:Minor>0</v9:Minor> 
                     </v9:Version> 
                     <v9:SelectionDetails> 
                     <v9:CarrierCode>FDXE</v9:CarrierCode> 
                     <v9:PackageIdentifier> 
                     <v9:Type>TRACKING_NUMBER_OR_DOORTAG</v9:Type> 
                     <v9:Value>XXXX</v9:Value> 
                     </v9:PackageIdentifier> 
                     <v9:ShipmentAccountNumber/> 
                     <v9:SecureSpodAccount/>
                    <v9:Destination> 
                         <v9:StreetLines>Address_Line</v9:StreetLines> 
                         <v9:City>City</v9:City> 
                         <v9:StateOrProvinceCode>'.$this->destStateOrProvinceCode.'</v9:StateOrProvinceCode> 
                         <v9:PostalCode>'.$this->destPostalCode.'</v9:PostalCode> 
                         <v9:CountryCode>'.$this->destCountryCode.'</v9:CountryCode> 
                     </v9:Destination> 
                     </v9:SelectionDetails> 
                     </v9:TrackRequest> 
                     </soapenv:Body> 
                    </soapenv:Envelope> 
                    ';

        //print($str);
        $header[] = "Host: www.smart-shop.com";
        $header[] = "MIME-Version: 1.0";
        $header[] = "Content-type: multipart/mixed; boundary=----doc";
        $header[] = "Accept: text/xml";
        $header[] = "Content-length: ".strlen($str);
        $header[] = "Cache-Control: no-cache";
        $header[] = "Connection: close \r\n";
        $header[] = $str;

        $ch = curl_init();
        //Disable certificate check.
        // uncomment the next line if you get curl error 60: error setting certificate verify locations
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        // uncommenting the next line is most likely not necessary in case of error 60
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        //-------------------------
        //curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        //curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        //curl_setopt($ch, CURLOPT_CAINFO, "c:/ca-bundle.crt");
        //-------------------------
        curl_setopt($ch, CURLOPT_URL,$this->server);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 4);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST,'POST');
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
            
        $data = curl_exec($ch);
//echo '<pre/>';print_r($data);
        if (curl_errno($ch)) {
            echo $this->getPrice();
        } else {
            // close curl resource, and free up system resources
            curl_close($ch);
            $array = $this->Xmlparser->GetXMLTree($data);

            //$xmlParser->print($array);
			if(isset($array['FDXRATEREPLY'][0]['ERROR']))
			{
            if(count($array['FDXRATEREPLY'][0]['ERROR'])) { // If it is error
                $this->Fedexerror->number = $array['FDXRATEREPLY'][0]['ERROR'][0]['CODE'][0]['VALUE'];
                $this->Fedexerror->description = $array['FDXRATEREPLY'][0]['ERROR'][0]['MESSAGE'][0]['VALUE'];
                $this->Fedexerror->response = $array;
                $this->error = $this->Fedexerror;
            } 
			}
			else if (count($array['FDXRATEREPLY'][0]['ESTIMATEDCHARGES'][0]['DISCOUNTEDCHARGES'][0]['NETCHARGE'])) {
                $this->Fedexprice->rate = $array['FDXRATEREPLY'][0]['ESTIMATEDCHARGES'][0]['DISCOUNTEDCHARGES'][0]['NETCHARGE'][0]['VALUE'];
                $this->Fedexprice->service = $this->serviceName;
                $this->Fedexprice->response = $array;
                $this->price = $this->Fedexprice;            
            }
            //print_r($this);
            return $this;
        }
    }
}
?>
