<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2010 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
class PaginatorComponent extends Object {
	var $uses = array('Paging'); 
	
	function setPageLimit($curr_page='',$limit='')
	{
		if(!isset($curr_page))
		$page=1;
		else
		$page=$curr_page;				
		if($page) 
		$start = ($page - 1) * $limit; //first item to display on this page
		else
	    $start = 0;	//if no page var is given, set start to 0
		return $start;
	}			
	function paginator($page='',$limit='',$total_pages='')
	{
       $adjacents = 3;		
	     if ($page == 0) $page = 1;					//if no page var is given, default to 1.
				$prev = $page - 1;							//previous page is page - 1
				$next = $page + 1;							//next page is page + 1
				$lastpage = ceil($total_pages/$limit);		//lastpage is = total pages / items per page, rounded up.
				$lpm1 = $lastpage - 1;						//last page minus 1	
				
						$pagination = "";
						if($lastpage > 1)
						{	
							$pagination .= "<div class=\"pagination\">";
							//previous button
							if ($page > 1) 
								$pagination.= "<a href=\"$prev\">&lt;&lt; previous</a>";
							else
								$pagination.= "<span class=\"disabled\">&lt;&lt; previous</span>";	
							
							//pages	
							if ($lastpage < 7 + ($adjacents * 2))	//not enough pages to bother breaking it up
							{	
								for ($counter = 1; $counter <= $lastpage; $counter++)
								{
									if ($counter == $page)
										$pagination.= "<span class=\"current\">$counter</span>";
									else
										$pagination.= "<a href=\"$counter\">$counter</a>";					
								}
							}
							elseif($lastpage > 5 + ($adjacents * 2))	//enough pages to hide some
							{
								//close to beginning; only hide later pages
								if($page < 1 + ($adjacents * 2))		
								{
									for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
									{
										if ($counter == $page)
											$pagination.= "<span class=\"current\">$counter</span>";
										else
											$pagination.= "<a href=\"$counter\">$counter</a>";					
									}
									$pagination.= "...";
									$pagination.= "<a href=\"$lpm1\">$lpm1</a>";
									$pagination.= "<a href=\"$lastpage\">$lastpage</a>";		
								}
								//in middle; hide some front and some back
								elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
								{
									$pagination.= "<a href=\"1\">1</a>";
									$pagination.= "<a href=\"2\">2</a>";
									$pagination.= "...";
									for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
									{
										if ($counter == $page)
											$pagination.= "<span class=\"current\">$counter</span>";
										else
											$pagination.= "<a href=\"$counter\">$counter</a>";					
									}
									$pagination.= "...";
									$pagination.= "<a href=\"$lpm1\">$lpm1</a>";
									$pagination.= "<a href=\"$lastpage\">$lastpage</a>";		
								}
								//close to end; only hide early pages
								else
								{
									$pagination.= "<a href=\"1\">1</a>";
									$pagination.= "<a href=\"2\">2</a>";
									$pagination.= "...";
									for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++)
									{
										if ($counter == $page)
											$pagination.= "<span class=\"current\">$counter</span>";
										else
											$pagination.= "<a href=\"$counter\">$counter</a>";					
									}
								}
							}
							
							//next button
							if ($page < $counter - 1) 
								$pagination.= "<a href=\"$next\">next &gt;&gt;</a>";
							else
								$pagination.= "<span class=\"disabled\">next &gt;&gt;</span>";
							$pagination.= "</div>\n";		
						}
					return $pagination;	
	 
	 }
}
?>