<?php

/**
 * Mubashir Ali
 * saad_ali6@yahoo.com
 */
class shippingAPI
{
    protected $ship_account;
    protected $bill_account;
    protected $duty_account;
    protected $account_to_validate;
    protected $track_account;
    protected $account;
    
    protected $ServiceId;
    protected $Major;

    protected $meter;
    protected $key;
    protected $password;

    public $wsdl_root_path;
    public $wsdl_path;

    public function __construct($mode = "test")
    {
        if($mode == "test")
        {
            $this->ship_account       = "";
            $this->bill_account       = "";
            $this->duty_account       = "";
            $this->account_to_validate= "";
            $this->track_account      = "";
            $this->account            = "";

            $this->meter    = "";
            $this->key      = "";
            $this->password = "";
            
            $this->setWSDLRoot("wsdl/");
        }
        else
        {
            $this->ship_account       = "";
            $this->bill_account       = "";
            $this->duty_account       = "";
            $this->account_to_validate= "";
            $this->track_account      = "";
            $this->account            = "";    //FEDEX Account Number
            $this->meter    = "";      //Production Meter Number
            $this->key      = "";   //Production Key
            $this->password = "";  //Production Password
            
        }
        
      
        
    }
    
    public function setWSDLRoot($root = "wsdl/")
    {
        $this->wsdl_root_path = $root;
    }
    
    public function setData($objData)
    {
            $this->ship_account       =    $objData->ship_account;
            $this->bill_account       =    $objData->bill_account;
            $this->duty_account       =    $objData->duty_account;
            $this->account_to_validate=    $objData->account_to_validate;
            $this->track_account      =    $objData->track_account;
            $this->account            =    $objData->account;
            $this->meter              =    $objData->meter;  
            $this->key                =    $objData->key;
            $this->password           =    $objData->password;
            $this->wsdl_path          =    $objData->wsdl_path;
            $this->accopunt           =    $objData->account;
      
    }
    public function requestError($exception, $client) 
    {
        $str = "";
        $str .= '<h2>Fault: </h2>';
        $str .= "<b>Code:</b>{$exception->faultcode}<br>\n";
        $str .= "<b>String:</b>{$exception->faultstring}<br>\n";
        return $str;
    }
    
    public function getAuthenticationDetail()
    {
        $aryAuthentication = array(
                'UserCredential' =>array(
                        'Key' => $this->key, 
                        'Password' => $this->password
                )
        ); 
        return $aryAuthentication;
    }
    
    public function getClientDetail()
    {
        $aryClient = array(
                'AccountNumber' => $this->ship_account, 
                'MeterNumber' => $this->meter
        );
        
        
        return $aryClient;
    }
    
    public function getServiceVersion()
    {
        $aryVersion = array(
                'ServiceId' => $this->ServiceId, 
                'Major' => $this->Major, 
                'Intermediate' => '0', 
                'Minor' => '0'
        );
        return $aryVersion;
    }
    
   
    function setEndpoint($var)
    {
        if($var == 'changeEndpoint') 
            return false;

        if($var == 'endpoint') 
            return '';
    }
         
    public function addShipper()
    {
        $shipper = array
        (
            'Contact' => array
                (
                    'PersonName' => 'Person Name',
                    'CompanyName' => 'Company Name',
                    'PhoneNumber' => '111-000-1111'
                ),
                'Address' => array
                (
                    'StreetLines' => array
                        (
                            'Street 1',
                            'Street 2'
                        ),
                    'City' => 'Test City',
                    'StateOrProvinceCode' => 'CA',
                    'PostalCode' => '11111',
                    'CountryCode' => 'US'
                )
           );

        return $shipper;
    }
    
    public function showResponseMessage($response)
    {
        if(isset($response->Notifications->Message))
            return $response->Notifications->Message;
        else
            return $response->Notifications[0]->Message;
    }
    
    
    //Functions from Fedex Common 
    
 function printSuccess($client, $response) {
    echo '<h2>Transaction Successful</h2>';  
    echo "\n";
    printRequestResponse($client);
}
function printRequestResponse($client){
	echo '<h2>Request</h2>' . "\n";
	echo '<pre>' . htmlspecialchars($client->__getLastRequest()). '</pre>';  
	echo "\n";
   
	echo '<h2>Response</h2>'. "\n";
	echo '<pre>' . htmlspecialchars($client->__getLastResponse()). '</pre>';
	echo "\n";
}

/**
 *  Print SOAP Fault
 */  
function printFault($exception, $client) {
    echo '<h2>Fault</h2>' . "<br>\n";                        
    echo "<b>Code:</b>{$exception->faultcode}<br>\n";
    echo "<b>String:</b>{$exception->faultstring}<br>\n";
    writeToLog($client);
}

/**
 * SOAP request/response logging to a file
 */                                  
function writeToLog($client){  
if (!$logfile = fopen(TRANSACTIONS_LOG_FILE, "a"))
{
   error_func("Cannot open " . TRANSACTIONS_LOG_FILE . " file.\n", 0);
   exit(1);
}

fwrite($logfile, sprintf("\r%s:- %s",date("D M j G:i:s T Y"), $client->__getLastRequest(). "\n\n" . $client->__getLastResponse()));
}
    
    
}
?>