drop table if exists Vista_admins;
CREATE TABLE `Vista_admins` (
  `id` int(11) NOT NULL auto_increment,
  `admin_name` varchar(100) NOT NULL default '',
  `admin_pword` varchar(100) NOT NULL default '',
  `settings` char(1) default NULL,
  `custom` char(1) default NULL,
  `category` char(1) default NULL,
  `products` char(1) default NULL,
  `feedback` char(1) default NULL,
  `users` char(1) default NULL,
  `orders` char(1) default NULL,
  `refund` char(1) default NULL,
  `promocodes` char(1) default NULL,
  `websitecontent` char(1) default NULL,
  `reports` char(1) default NULL,
  `homepage` char(1) default NULL,
  `help` char(1) default NULL,
  `adminusers` char(1) default NULL,
  `newsletter` char(1) default NULL,
  `newsletterusers` char(1) default NULL,
  `sentnewsletters` char(1) default NULL,
  `giftcards` char(1) default NULL,
  `giftcardusers` char(1) default NULL,
  `email` varchar(200) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
drop table if exists Vista_carts;
CREATE TABLE `Vista_carts` (
  `id` int(11) NOT NULL auto_increment,
  `sess_id` varchar(100) NOT NULL default '',
  `product_id` int(11) NOT NULL default '0',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `prodtype` varchar(20) NOT NULL default '',
  `extra_price` decimal(10,2) default '0.00',
  `discount_type` varchar(5) default NULL,
  `discount` decimal(10,2) default '0.00',
  `quantity` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  `shipping_charge` decimal(10,2) NOT NULL default '0.00',
  `customvalue` text,
  `customfields_id` int(11) default NULL,
  `option_id` bigint(20) NOT NULL default '0',
  `type` varchar(150) NOT NULL default '',
  `price_type` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_categories;
CREATE TABLE `Vista_categories` (
  `id` int(11) NOT NULL auto_increment,
  `cname` varchar(100) NOT NULL default '',
  `parent_id` int(11) NOT NULL default '0',
  `custom_combination` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_cmspages;
CREATE TABLE `Vista_cmspages` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `content` text,
  `type` varchar(100) NOT NULL default 'email',
  `status` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_contacts;
CREATE TABLE `Vista_contacts` (
  `id` bigint(20) NOT NULL auto_increment,
  `cname` varchar(50) NOT NULL default '',
  `cemail` varchar(200) NOT NULL default '',
  `cdate` varchar(25) NOT NULL default '',
  `cdescr` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_countries;
CREATE TABLE `Vista_countries` (
  `country_id` int(11) NOT NULL auto_increment,
  `country_name` varchar(64) NOT NULL default '',
  `country_iso_code_2` char(2) NOT NULL default '',
  PRIMARY KEY  (`country_id`),
  KEY `IDX_COUNTRY_NAME` (`country_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_coupons;
CREATE TABLE `Vista_coupons` (
  `id` bigint(20) NOT NULL auto_increment,
  `code` varchar(100) NOT NULL default '',
  `type` enum('Perc','Amt') NOT NULL default 'Perc',
  `giftvalue` decimal(10,2) NOT NULL default '0.00',
  `from_date` date NOT NULL default '0000-00-00',
  `to_date` date NOT NULL default '0000-00-00',
  `status` char(1) NOT NULL default 'A',
  `descr` text,
  `minamt` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_currencies;
CREATE TABLE `Vista_currencies` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) default NULL,
  `logo` varchar(100) character set utf8 collate utf8_unicode_ci default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_customcombinations;
CREATE TABLE `Vista_customcombinations` (
  `id` bigint(20) NOT NULL auto_increment,
  `category_id` bigint(20) NOT NULL default '0',
  `customfield_id` bigint(20) NOT NULL default '0',
  `customvalue_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

drop table if exists Vista_customfields;
CREATE TABLE `Vista_customfields` (
  `id` bigint(20) NOT NULL auto_increment,
  `custom_name` varchar(200) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `custom_id` (`custom_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_customfieldvalues;
CREATE TABLE `Vista_customfieldvalues` (
  `id` bigint(20) NOT NULL auto_increment,
  `customfield_id` bigint(20) NOT NULL default '0',
  `custom_value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

drop table if exists Vista_feedbacks;
CREATE TABLE `Vista_feedbacks` (
 `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `product_id` int(11) NOT NULL default '0',
  `date` varchar(25) NOT NULL default '',
  `type` varchar(100) NOT NULL default '',
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_giftcard_details;
CREATE TABLE `Vista_giftcard_details` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `card_id` bigint(20) NOT NULL default '0',
  `card_code` text NOT NULL,
  `amount` decimal(10,2) NOT NULL default '0.00',
  `balance` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_giftcards;
CREATE TABLE `Vista_giftcards` (
  `id` bigint(20) NOT NULL auto_increment,
  `gift_code` varchar(255) NOT NULL default '',
  `gift_amnt` decimal(10,2) NOT NULL default '0.00',
  `from` date default '0000-00-00',
  `to` date default '0000-00-00',
  `stock` bigint(20) NOT NULL default '0',
  `status` char(1) NOT NULL default 'A',
  `descr` text,
  `gift_img` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `code` (`gift_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_giftcardusers;
CREATE TABLE `Vista_giftcardusers` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `card_id` bigint(20) NOT NULL default '0',
  `usercard_id` bigint(20) NOT NULL default '0',
  `date` varchar(20) NOT NULL default '',
  `amnt_used` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_helps;
CREATE TABLE `Vista_helps` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `content` longtext NOT NULL,
  `type` enum('A','U') NOT NULL default 'A',
  `order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


drop table if exists Vista_homelayouts;
CREATE TABLE `Vista_homelayouts` (
  `id` int(11) NOT NULL auto_increment,
  `prod_type` char(50) default NULL,
  `section` char(15) default NULL,
  `status` enum('Y','N') NOT NULL default 'Y',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_newsletters;
CREATE TABLE `Vista_newsletters` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `content` longtext NOT NULL,
  `news_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


drop table if exists Vista_newsletterusers;
CREATE TABLE `Vista_newsletterusers` (
  `id` int(11) NOT NULL auto_increment,
  `uname` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `sub_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` enum('N','Y') NOT NULL default 'Y',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_order_details;
CREATE TABLE `Vista_order_details` (
  `id` int(11) NOT NULL auto_increment,
  `order_id` int(11) NOT NULL default '0',
  `product_id` int(11) NOT NULL default '0',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `prodtype` varchar(20) default NULL,
  `discount_type` varchar(5) default 'amnt',
  `discount` decimal(10,2) default '0.00',
  `quantity` int(11) NOT NULL default '0',
  `extra_price` decimal(10,2) NOT NULL default '0.00',
  `customfields_id` int(11) default NULL,
  `combination_id` bigint(20) NOT NULL default '0',
  `type` char(1) NOT NULL default '',
  `price_type` char(1) default NULL,
  PRIMARY KEY  (`id`),
  KEY `orders_id` (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_order_statuses;
CREATE TABLE `Vista_order_statuses` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_orders;
CREATE TABLE `Vista_orders` (
  `id` int(11) NOT NULL auto_increment,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `exp_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `user_id` int(11) NOT NULL default '0',
  `shipping_method` varchar(100) NOT NULL default '',
  `shipping_service` varchar(100) NOT NULL default '',
  `shipping_price` decimal(10,2) NOT NULL default '0.00',
  `tax_price` decimal(10,2) NOT NULL default '0.00',
  `total_price` decimal(10,2) NOT NULL default '0.00',
  `order_status_id` int(10) NOT NULL default '1',
  `ship_fname` varchar(50) NOT NULL default '',
  `ship_lname` varchar(50) NOT NULL default '',
  `ship_address` varchar(50) NOT NULL default '',
  `ship_city` varchar(50) NOT NULL default '',
  `ship_state` varchar(50) NOT NULL default '',
  `ship_country` varchar(50) NOT NULL default '',
  `ship_zip` varchar(50) NOT NULL default '',
  `ship_phone` varchar(50) NOT NULL default '',
  `ship_mobile` varchar(50) NOT NULL default '',
  `ship_fax` varchar(50) NOT NULL default '',
  `transaction_id` varchar(50) default NULL,
  `bill_fname` varchar(50) NOT NULL default '',
  `bill_lname` varchar(50) NOT NULL default '',
  `bill_address` varchar(50) NOT NULL default '',
  `bill_city` varchar(50) NOT NULL default '',
  `bill_state` varchar(50) NOT NULL default '',
  `bill_country` varchar(50) NOT NULL default '',
  `bill_zip` varchar(50) NOT NULL default '',
  `bill_phone` varchar(50) NOT NULL default '',
  `bill_mobile` varchar(50) NOT NULL default '',
  `bill_fax` varchar(50) NOT NULL default '',
  `payment_method` varchar(100) NOT NULL default '',
  `currency_type` varchar(10) NOT NULL default 'USD',
  `note` text,
  `comments` longtext NOT NULL,
  `tax_name` varchar(100) default NULL,
  `coupon_id` int(11) NOT NULL default '0',
  `discount` decimal(10,2) NOT NULL default '0.00',
  `tracking_no` text,
  `label_pdf` text,
  PRIMARY KEY  (`id`),
  KEY `users_id` (`user_id`,`order_status_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


drop table if exists Vista_productcustomfields;
CREATE TABLE `Vista_productcustomfields` (
  `id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL default '0',
  `customfield_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product_id` (`product_id`,`customfield_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_productdetails;
CREATE TABLE `Vista_productdetails` (
  `id` bigint(20) NOT NULL auto_increment,
  `category_id` bigint(20) NOT NULL default '0',
  `product_id` bigint(20) NOT NULL default '0',
  `customvalue_id` varchar(255) NOT NULL default '',
  `stock` bigint(20) NOT NULL default '0',
  `reorderlevel` bigint(20) NOT NULL default '0',
  `skuno` varchar(100) NOT NULL default '',
  `extraprice` bigint(20) NOT NULL default '0',
  `pdctfile` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

drop table if exists Vista_productimages;
CREATE TABLE `Vista_productimages` (
  `id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL default '0',
  `imagename` varchar(200) NOT NULL default '',
  `default_img` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  KEY `product_id` (`product_id`,`imagename`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_products;
CREATE TABLE `Vista_products` (
  `id` int(11) NOT NULL auto_increment,
  `pname` varchar(100) NOT NULL default '',
  `category_id` int(11) NOT NULL default '0',
  `descr` text NOT NULL,
  `price` decimal(10,2) NOT NULL default '0.00',
  `wholesale_price` decimal(10,2) NOT NULL default '0.00',
  `discount_type` varchar(5) NOT NULL default '',
  `discount` decimal(10,2) default '0.00',
  `image1` varchar(100) default NULL,
  `image2` varchar(100) default NULL,
  `featured` enum('0','1') NOT NULL default '1',
  `stock` int(11) default '0',
  `skuno` varchar(100) default NULL,
  `reorderlevel` int(11) default '0',
  `weight` decimal(10,2) NOT NULL default '0.00',
  `shipping_price` decimal(10,2) NOT NULL default '0.00',
  `status` varchar(10) NOT NULL default 'A',
  `pdctfile` varchar(250) NOT NULL default '',
  `prodtype` varchar(100) NOT NULL default 'Non-Digital',
  `combination` char(1) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_randoms;
CREATE TABLE `Vista_randoms` (
  `id` bigint(20) NOT NULL auto_increment,
  `rand_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_ratings;
CREATE TABLE `Vista_ratings` (
  `id` int(11) NOT NULL auto_increment,
  `product_id` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  `rate` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_refundoptions;
CREATE TABLE `Vista_refundoptions` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_refundproducts;
CREATE TABLE `Vista_refundproducts` (
  `id` bigint(20) NOT NULL auto_increment,
  `refund_id` bigint(20) NOT NULL default '0',
  `product_id` bigint(20) NOT NULL default '0',
  `combination_id` bigint(20) NOT NULL default '0',
  `quantity` bigint(20) default NULL,
  `return_reason` text NOT NULL,
  `extra_price` decimal(10,2) NOT NULL default '0.00',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `discount` int(11) default '0',
  `discount_type` varchar(5) default NULL,
  `type` char(1) default NULL,
  `price_type` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


drop table if exists Vista_refundreasons;
CREATE TABLE `Vista_refundreasons` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_refunds;
CREATE TABLE `Vista_refunds` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `customer_feedback` text,
  `status` varchar(255) default NULL,
  `additional_info` text,
  `date` date NOT NULL default '0000-00-00',
  `refund_mode` varchar(255) default NULL,
  `reference_number` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_refundstatuses;
CREATE TABLE `Vista_refundstatuses` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_reports;
CREATE TABLE `Vista_reports` (
  `id` int(11) NOT NULL default '0',
  `reports` varchar(255) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_sent_newsletters;
CREATE TABLE `Vista_sent_newsletters` (
  `id` bigint(20) NOT NULL auto_increment,
  `newsletter_id` bigint(20) NOT NULL default '0',
  `user_id` bigint(20) NOT NULL default '0',
  `send_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_settings;
CREATE TABLE `Vista_settings` (
  `fieldname` varchar(100) NOT NULL default '',
  `value` varchar(100) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_statecodes;
CREATE TABLE `Vista_statecodes` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `country_id` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_states;
CREATE TABLE `Vista_states` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `country_id` varchar(10) NOT NULL default '',
  `tax_rate` decimal(10,2) NOT NULL default '0.00',
  `tax_name` varchar(100) default NULL,
  PRIMARY KEY  (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_user_addresses;
CREATE TABLE `Vista_user_addresses` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `addr_type` enum('Billing','Shipping') NOT NULL default 'Billing',
  `fname` varchar(50) NOT NULL default '',
  `lname` varchar(50) NOT NULL default '',
  `address` text NOT NULL,
  `city` varchar(100) NOT NULL default '',
  `state` varchar(100) NOT NULL default '',
  `country` varchar(100) NOT NULL default '',
  `zip` varchar(20) NOT NULL default '',
  `phone` varchar(25) NOT NULL default '',
  `fax` varchar(25) NOT NULL default '',
  `mobile` varchar(25) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `users_id` (`user_id`,`addr_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

drop table if exists Vista_users;
CREATE TABLE `Vista_users` (
  `id` int(11) NOT NULL auto_increment,
  `uname` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `reg_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `usertype` varchar(20) NOT NULL default 'R',
  `reg_status` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

ALTER TABLE `Vista_orders` ADD `specials` TEXT NULL;
ALTER TABLE `Vista_orders` ADD `special_price` DECIMAL( 10, 2 ) NULL;
LTER TABLE `Vista_orders` ADD `order_type` VARCHAR( 2 ) NULL;
ALTER TABLE `Vista_orders` CHANGE `coupon_id` `coupon_id` INT( 11 ) NULL DEFAULT '0';
ALTER TABLE `Vista_users` ADD `user_credit` FLOAT NOT NULL DEFAULT '0';
UPDATE `Vista_settings` SET `value` = 'paypal-*-authorize-*-googlechk-*-twocheckout' WHERE `Vista_settings`.`fieldname` = 'payment_method' AND `Vista_settings`.`value` = 'paypal-*-authorize-*-googlechk*-twocheckout' LIMIT 1 ;
ALTER TABLE `Vista_admins` ADD `blog_pword` VARCHAR( 100 ) NOT NULL;

CREATE TABLE IF NOT EXISTS `Vista_wp_add_custom_link` (
  `custom_link_id` int(11) NOT NULL auto_increment,
  `id` varchar(200) NOT NULL,
  `title` varchar(200) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `href` varchar(500) NOT NULL,
  PRIMARY KEY  (`custom_link_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

CREATE TABLE IF NOT EXISTS `Vista_wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL auto_increment,
  `comment_id` bigint(20) unsigned NOT NULL default '0',
  `meta_key` varchar(255) default NULL,
  `meta_value` longtext,
  PRIMARY KEY  (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `Vista_wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL auto_increment,
  `comment_post_ID` bigint(20) unsigned NOT NULL default '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL default '',
  `comment_author_url` varchar(200) NOT NULL default '',
  `comment_author_IP` varchar(100) NOT NULL default '',
  `comment_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL default '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL default '0',
  `comment_approved` varchar(20) NOT NULL default '1',
  `comment_agent` varchar(255) NOT NULL default '',
  `comment_type` varchar(20) NOT NULL default '',
  `comment_parent` bigint(20) unsigned NOT NULL default '0',
  `user_id` bigint(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (`comment_ID`),
  KEY `comment_approved` (`comment_approved`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `Vista_wp_links` (
  `link_id` bigint(20) unsigned NOT NULL auto_increment,
  `link_url` varchar(255) NOT NULL default '',
  `link_name` varchar(255) NOT NULL default '',
  `link_image` varchar(255) NOT NULL default '',
  `link_target` varchar(25) NOT NULL default '',
  `link_description` varchar(255) NOT NULL default '',
  `link_visible` varchar(20) NOT NULL default 'Y',
  `link_owner` bigint(20) unsigned NOT NULL default '1',
  `link_rating` int(11) NOT NULL default '0',
  `link_updated` datetime NOT NULL default '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL default '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

CREATE TABLE IF NOT EXISTS `Vista_wp_options` (
  `option_id` bigint(20) unsigned NOT NULL auto_increment,
  `blog_id` int(11) NOT NULL default '0',
  `option_name` varchar(64) NOT NULL default '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL default 'yes',
  PRIMARY KEY  (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=307 ;


CREATE TABLE IF NOT EXISTS `Vista_wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL auto_increment,
  `post_id` bigint(20) unsigned NOT NULL default '0',
  `meta_key` varchar(255) default NULL,
  `meta_value` longtext,
  PRIMARY KEY  (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;


CREATE TABLE IF NOT EXISTS `Vista_wp_posts` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `post_author` bigint(20) unsigned NOT NULL default '0',
  `post_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL default '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL default 'publish',
  `comment_status` varchar(20) NOT NULL default 'open',
  `ping_status` varchar(20) NOT NULL default 'open',
  `post_password` varchar(20) NOT NULL default '',
  `post_name` varchar(200) NOT NULL default '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL default '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL default '0000-00-00 00:00:00',
  `post_content_filtered` text NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL default '0',
  `guid` varchar(255) NOT NULL default '',
  `menu_order` int(11) NOT NULL default '0',
  `post_type` varchar(20) NOT NULL default 'post',
  `post_mime_type` varchar(100) NOT NULL default '',
  `comment_count` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

CREATE TABLE IF NOT EXISTS `Vista_wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL auto_increment,
  `name` varchar(200) NOT NULL default '',
  `slug` varchar(200) NOT NULL default '',
  `term_group` bigint(10) NOT NULL default '0',
  PRIMARY KEY  (`term_id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

CREATE TABLE IF NOT EXISTS `Vista_wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL default '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL default '0',
  `term_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `Vista_wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL auto_increment,
  `term_id` bigint(20) unsigned NOT NULL default '0',
  `taxonomy` varchar(32) NOT NULL default '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL default '0',
  `count` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;


CREATE TABLE IF NOT EXISTS `Vista_wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL auto_increment,
  `user_id` bigint(20) unsigned NOT NULL default '0',
  `meta_key` varchar(255) default NULL,
  `meta_value` longtext,
  PRIMARY KEY  (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

CREATE TABLE IF NOT EXISTS `Vista_wp_users` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `user_login` varchar(60) NOT NULL default '',
  `user_pass` varchar(64) NOT NULL default '',
  `user_nicename` varchar(50) NOT NULL default '',
  `user_email` varchar(100) NOT NULL default '',
  `user_url` varchar(100) NOT NULL default '',
  `user_registered` datetime NOT NULL default '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL default '',
  `user_status` int(11) NOT NULL default '0',
  `display_name` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

ALTER TABLE `Vista_admins` ADD `blog_pword` VARCHAR( 100 ) NOT NULL;

ALTER TABLE `Vista_orders` CHANGE `comments` `comments` LONGTEXT  NULL;

ALTER TABLE `Vista_order_details` CHANGE `combination_id` `combination_id` BIGINT( 20 ) NULL DEFAULT '0';

ALTER TABLE `Vista_products` CHANGE `price` `price` DECIMAL( 10, 2 ) NULL DEFAULT '0.00';

ALTER TABLE `Vista_states` CHANGE `tax_rate` `tax_rate` DECIMAL( 10, 2 ) NULL DEFAULT '0.00';
        
ALTER TABLE `Vista_admins` CHANGE `blog_pword` `blog_pword` VARCHAR( 100 )  NULL DEFAULT NULL ; 

ALTER TABLE `Vista_currencies` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
