{
    "keyColumn": "nLocation_Id",
    "includeJsFiles": [
        "cms_location.js"
    ],
    "handleFile": "true",
    "orderBy": {
        "nLocation_Id": "DESC"
    },
    "breadCrumbColumn": "vLocation_Name",
    "detailHeaderColumnPrefix": "Location: ",
    "detailHeaderColumns": [
        "vLocation_Name"
    ],
    "listColumns": [
        "vLocation_Name",
        "nDestination_Id",
        "vFeatured",
        "vActive",
        "Promote"
    ],
    "detailColumns": [
        "nLocation_Id",
        "nDestination_Id",
        "vLocation_Name",
        "vLocation_Description",
        "vAddress",
        "vCity",
       
        "vCountry",
        "vState",
 "vZip",
        "nStartingPrice",
        "vFeatured",
        "vActive",
        "vAmenities",
        "Promote"
    ],
    "showColumns": [
        "nLocation_Id",
        "nDestination_Id",
        "vLocation_Name",
        "vLocation_Description",
        "vAddress",
        "vCity",
      
        "vCountry",
        "vState",
  "vZip",
        "nStartingPrice",
        "vFeatured",
        "vActive",
        "vAmenities"
    ],
    "columns": {
        "nLocation_Id": {
            "name": "ID",
            "sortable": "true",
            "editoptions": {
                "type": "hidden"
            }
        },
        "vLocation_Name": {
            "name": "Location",
            "sortable": "true",
            "searchable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "Location",
                "class": "textbox"
            },
            "popupoptions": {
                "type": "popup",
                "customaction": "Cmshelper::getLocationPopupUrlLocationLink"
            }
        },
        "nDestination_Id": {
            "name": "Destination",
            "sortable": "true",
            "searchable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllDestinations",
                "source_type": "function",
                "label": "Destination",
                "class": "select"
            },
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_destination",
                "externalColumn": "nDestination_Id",
                "externalShowColumn": "vDestination_Name"
            },
            "popupoptions": {
                "type": "popup",
                "customaction": "Cmshelper::getDestinationPopupUrlLocationLink"
            }
        },
        "vLocation_Description": {
            "name": "Description",
            "editoptions": {
                "type": "textarea",
                "label": "Overview",
                "class": "textarea"
            }
        },
        "vAmenities": {
            "name": "Amenities",
            "editoptions": {
                "type": "htmlEditor",
                "label": "Amenities",
                "class": "textarea"
            }
        },
        "vAddress": {
            "name": "Address",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textarea",
                "label": "Address",
                "class": "textarea"
            }
        },
        "vCity": {
            "name": "City",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "City",
                "class": "textbox"
            }
        },
        "vState": {
            "name": "State",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllStates",
                "source_type": "function",
                "label": "State",
                "class": "select"
            }
        },
        "vZip": {
            "name": "Zip",
            "editoptions": {
                "type": "textbox",
                "label": "Zip",
                "class": "textbox"
            }
        },
        "vCountry": {
            "name": "Country",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllCountries",
                "source_type": "function",
                "label": "Country",
                "class": "select"
            }
        },
        "nStartingPrice": {
            "name": "StartingPrice ($)",
            "sortable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "StartingPrice ($)",
                "class": "textbox"
            }
        },
        "vActive": {
            "name": "Status",
            "searchable": "true",
            "editoptions": {
"validations": [
                    "required"
                ],
                "type": "select",
                "source": {
                    "active": "Active",
                    "deactive": "Inactive"
                },
                "source_type": "array",
                "label": "Status",
                "class": "select",
                "enumvalues": {
                    "active": "Active",
                    "deactive": "Inactive"
                }
            },
            "listoptions": {
                "type": "button",
                "customaction": "Cmshelper::changeLocationStatus",
                "enumvalues": {
                    "active": "Active",
                    "deactive": "Inactive"
                },
                "buttonColors": {
                    "active": "green",
                    "deactive": "red"
                }
            }
        },
        "vFeatured": {
            "name": "Featured",
            "searchable": "true",
            "editoptions": {
"validations": [
                    "required"
                ],
                "type": "select",
                "source": {
                    "No": "No",
                    "Yes": "Yes"
                },
                "source_type": "array",
                "label": "Featured",
                "class": "select",
                "enumvalues": {
                    "No": "No",
                    "Yes": "Yes"
                }
            },
            "listoptions": {
                "type": "button",
                "customaction": "Cmshelper::changeLocationFeaturedStatus",
                "enumvalues": {
                    "Yes": "Featured",
                    "No": "NotFeatured"
                },
                "buttonColors": {
                    "Yes": "green",
                    "No": "red"
                }
            }
        },
        "Promote": {
            "name": "Publish",
            "customColumn": "true",
            "customaction": "Cmshelper::displayPromoteLink"
        }
    },
    "relations": {
        "location_offer_tag": {
            "name": "SpecialOffers",
            "section": "location_offer_tag",
            "child_table": "tbl_special_offers",
            "parent_join_column": "nLocation_Id",
            "child_join_column": "nLocation_Id"
        },
        "location_gallery_tag": {
            "name": "Gallery",
            "section": "location_gallery_tag",
            "child_table": "tbl_gallery",
            "parent_join_column": "nLocation_Id",
            "child_join_column": "nLocation_Id"
        },
        "location_accomodation_tag1": {
            "name": "Accommodations",
            "section": "location_accomodation_tag1",
            "child_table": "tbl_available_acco_type",
            "parent_join_column": "nLocation_Id",
            "child_join_column": "nLocation_Id"
        },
        "location_review_tag": {
            "name": "Reviews",
            "section": "location_review_tag",
            "child_table": "tbl_rating",
            "parent_join_column": "nLocation_Id",
            "child_join_column": "nLocation_Id"
        }
    },
    "customActions": {
        "afterAddRecord": "Cmshelper::mapLatLong",
        "afterEditRecord": "Cmshelper::mapLatLong"
    },
    "opertations": [
        "view",
        "edit",
        "delete",
        "add"
    ]
}